clear

%%% LOW-NO3 %%%%%%%%%%%%%%

load ../output/lowno3/aerconc.res;

%% EQUILIBRIUM DATA FROM EQUISOLV II
%% FROM FIG 3 IN AST 2005
timeq=11.0;
eq_h2o=9.04;
eq_no3=0.11;
eq_sul=9.72;
eq_nh4=3.46;
eq_chl=5.63;
eq_nap=3.71;
%%%%%%%%%%%%%%%%%%%%%%%%%%%

time=aerconc(:,1);
time=time/3600.;
time=time-10;
tmax=6*60*12;
%time column
infile='aerconc.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);


%AEROSOL MASS CONCENTRATION
%INERT = BPBA (XXXX)
%no msa_p, no DUST/ASH, no EC, no OC, no SO4
%
pmsulct=aerconc(:,2)+aerconc(:,3)+aerconc(:,4)+aerconc(:,5);
%pmmsact=aerconc(:,6)+aerconc(:,7)+aerconc(:,8)+aerconc(:,9);
pmxxxct=aerconc(:,10)+aerconc(:,11)+aerconc(:,12)+aerconc(:,13);
%pmorgct=aerconc(:,14)+aerconc(:,15)+aerconc(:,16)+aerconc(:,17);
pmamoct=aerconc(:,18)+aerconc(:,19)+aerconc(:,20)+aerconc(:,21);
pmnitct=aerconc(:,22)+aerconc(:,23)+aerconc(:,24)+aerconc(:,25);
%pmecbct=aerconc(:,26)+aerconc(:,27)+aerconc(:,28)+aerconc(:,29);
%pmdusct=aerconc(:,30)+aerconc(:,31)+aerconc(:,32)+aerconc(:,33);
pmseact=aerconc(:,34)+aerconc(:,35)+aerconc(:,36)+aerconc(:,37);
pmwatct=aerconc(:,38)+aerconc(:,39)+aerconc(:,40)+aerconc(:,41);

pmna   =aerconc(1,34)+aerconc(1,35)+aerconc(1,36)+aerconc(1,37);
pmnap  =pmna*0.46; %MAFOR Na+

pmsulf =pmsulct*1.e-3;
%pmmsap =pmmsact*1.e-3;
pmbpba =pmxxxct*1.e-3;
pmammo =pmamoct*1.e-3;
pmanit =pmnitct*1.e-3;
pmwatt =pmwatct*1.e-3;
%pmdust =pmdusct*1.e-3;
%pmorgt =pmorgct*1.e-3;
%pmecbt =pmecbct*1.e-3; 
pmseat =pmseact*1.e-3 - pmnap*1.e-3;  %Cl-

for i=1:tmax
  pmnat(i)  = pmnap*1.e-3; %Na+
end

% TOTAL in ug/m3 (dry mass)
pmtotal=(pmsulct+pmxxxct+pmamoct+pmnitct+pmseact)*1e-3;


%Normalize to initial
clf();
graphics_toolkit ("fltk")

figure(1);clf
axes('linewidth',2,'fontsize',19 , 'XScale','linear','YScale','log','tickdir','out')
semilogy(time(1:tmax),pmsulf(1:tmax), '-m','LineWidth' ,1.5)
hold
ax=gca;
set(ax,'linewidth',1.0,'fontsize',19,'tickdir','out')
grid on
grid(gca,'minor')
grid off
semilogy(time(1:tmax),pmanit(1:tmax), '-g','LineWidth' ,1.5)
semilogy(time(1:tmax),pmseat(1:tmax), '-b','LineWidth' ,1.5)
semilogy(time(1:tmax),pmammo(1:tmax), '-r','LineWidth' ,1.5)
semilogy(time(1:tmax),pmwatt(1:tmax)*0.1,'-k','LineWidth',0.9)
semilogy(time(1:tmax),pmnat(1:tmax),  '-c','LineWidth' ,1.5)

semilogy(timeq+0.5,eq_sul, 'mo','LineWidth',2.0,'MarkerSize',11.0)
semilogy(timeq,eq_no3, 'go','LineWidth',2.0,'MarkerSize',11.0)
semilogy(timeq,eq_chl, 'bo','LineWidth',2.0,'MarkerSize',11.0)
semilogy(timeq+0.5,eq_nh4, 'ro','LineWidth',2.0,'MarkerSize',11.0)
semilogy(timeq,eq_h2o, 'ko','LineWidth',2.0,'MarkerSize',11.0)
semilogy(timeq,eq_nap, 'co','LineWidth',2.0,'MarkerSize',11.0)

xlabel('Time from start (h)'              ,'FontSize',17,'FontName','Arial')
ylabel('Summed mass conc. (\mug m^{-3})'  ,'FontSize',17,'FontName','Arial')
%title('Case2 | low-NO3  | T=298K | RH=90%' ,'FontSize',16,'FontName','Arial')

text( 6., 13.5 ,['H_2O x 0.1'] ,'fontsize',18,'color','k')
text(5.7, 11.5 ,['\downarrow'] ,'fontsize',18,'color','k')
text( 9., 12.5 ,['S(VI)']      ,'fontsize',18,'color','m')
text(8.7, 10.5 ,['\downarrow'] ,'fontsize',18,'color','m')
text( 9., 6.6, ['Cl^{^{\_}}'] ,'fontsize',18,'color','b')
text(8.7, 6.0 ,['\downarrow']  ,'fontsize',18,'color','b')
text( 6., 6.6 ,['Na^{+}']      ,'fontsize',18,'color','c')
text(5.7, 5.5 ,['\downarrow']  ,'fontsize',18,'color','c')
text( 9., 2.4  , ['NH_{4}^{+}'],'fontsize',18,'color','r')
text( 9., 0.075, ['NO_{3}^{^{\_}}'],'fontsize',18,'color','g')

set(gca,'ytick',[1e-2,1e-1,1e0,1e1,1e2,1e3 ]);
set(gca, 'yticklabel', [0.01,0.1,1.0,10.,100.,1000.]);

set(gca,'xlim', [0.0  12]);
set(gca,'ylim', [0.01  30.0 ]);

print -djpg '../plots/case3_partmass_lowno3.jpg'
