clear

load ../output/CO1/size_dis.res;
%load ../output/CO2/size_dis.res;


infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);                    %row=xxx col=61

% 1800s (0.5 h)
dndlogdp_bin01=y(4+180,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin01=y(1,2:col)*1e9; 

% 3600s (1h)
dndlogdp_bin02=y(4+360,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin02=y(1,2:col)*1e9; 

% 7200s (2h)
dndlogdp_bin03=y(4+720,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin03=y(1,2:col)*1e9; 

% 10800s (3h)
dndlogdp_bin04=y(4+1080,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin04=y(1,2:col)*1e9; 

% 14400s (4h)
dndlogdp_bin05=y(4+1440,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin05=y(1,2:col)*1e9; 

% 18000s (5h)
dndlogdp_bin06=y(4+1800,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin06=y(1,2:col)*1e9; 

% 21600s (6h)
dndlogdp_bin07=y(4+2160,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin07=y(1,2:col)*1e9; 

% 32400s (9h)
dndlogdp_bin08=y(4+3240,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin08=y(1,2:col)*1e9;

% Smooth Lines
windowSize=3;
r1f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin01);
r2f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin02);
r3f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin03);
r4f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin04);
r6f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin06);
r8f=filter(ones(1,windowSize)/windowSize,1,dndlogdp_bin08);


%loglog
% first 8h: hourly. then every 8h 
%1 hour= 1*60*6 = 360
% TIME UTC HERE AND ABOVE
figure(1)
axes('linewidth',2,'fontsize',14 ,'tickdir','out')
%MAFOR   0.0s
semilogx(diameter_bin01,r1f/2.303,      '-sk'  ,'LineWidth',1.6,'MarkerSize',3.5)
hold
ax=gca;
set(ax,'linewidth',2,'fontsize',14,'tickdir','out')

semilogx(diameter_bin02,r2f/2.303,      '-or'  ,'LineWidth',1.6,'MarkerSize',3.5)
semilogx(diameter_bin03,r3f/2.303,      '-^b'  ,'LineWidth',1.6,'MarkerSize',3.5)
semilogx(diameter_bin04,r4f/2.303,      '-vc'  ,'LineWidth',1.6,'MarkerSize',3.5)
  %%%semilogx(diameter_bin05,dndlogdp_bin05/2.303,      '--g' ,'LineWidth',2.1)
semilogx(diameter_bin06,r6f/2.303,      '-<m'  ,'LineWidth',1.6,'MarkerSize',3.5)
  %%%semilogx(diameter_bin07,dndlogdp_bin07/2.303,      '--y' ,'LineWidth',2.1)
semilogx(diameter_bin08,r8f/2.303, '->','Color',[.1 .45 .1] ,'LineWidth',1.6,'MarkerSize',3.5)

%LEGEND
legend(' 0.5h',' 1h',' 2h',' 3h',' 5h',' 9h','Location','NorthEast')  
xlabel('Particle diameter Dp (nm)','FontSize',16)
ylabel('dN/dln( Dp) (particles/cm^3)','FontSize',16)

%%title('Case3 | Df=3.00 nowall | Size distr. (dry Dp)','FontSize',16,'FontName','Arial')
%%title('Case3 | Df=1.75 nowall | Size distr. (dry Dp)','FontSize',16,'FontName','Arial')

%loglog
set(gca,'xtick',[1,10,100,1000,10000]);
set(gca, 'xticklabel', [1,10,100,1000,10000]);
%CO1
set(gca,'ytick',       [0,5.e5,1.0e6,1.5e6,2.0e6,2.5e6,3.0e6,3.5e6]);
set(gca, 'yticklabel', ['0';'0.5x10^6';'1.0x10^6';'2.0x10^6';'2.5x10^6'; ...
                        '3.0x10^6';'3.5x10^6']);
set(gca,'XLim',[5. 300.],'Ylim',[0 3.0e06]);

print -djpg '../plots/case2_sizedis_CO1.jpg'
%print -djpg '../plots/case2_sizedis_CO2.jpg'

