clear

%REFERENCE = 160 BINS

load ../output/160/wetdp.res;
load ../output/160/size_dis.res;

infile='size_dis.res';
in=strrep(infile,'.res','');
y160=eval(in);
[row,col]=size(y160);                    %row=xxx col=61

infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp160=eval(indp);
[rowdp,coldp]=size(dp160);

%dndlogdp_binbg=y(3,2:col)   *1e-6  *2.303;
% 0.0s INIT
dndlogdp_bin00=y160(4,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin00=y160(1,2:col)   *1e6; 
diameter_bin00=dp160(4,2:coldp)*1e6;

% 10h = 36000s
dndlogdp_bin160=y160(  3600,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin160=y160(  3600,2:col)   *1e6; 
diameter_bin160=dp160( 3600,2:coldp)*1e6;


% 120 BINS
load ../output/120/wetdp.res;
load ../output/120/size_dis.res;
infile='size_dis.res';
in=strrep(infile,'.res','');
y120=eval(in);
[row,col]=size(y120);                    %row=xxx col=61
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp120=eval(indp);
[rowdp,coldp]=size(dp120);
% 10h = 36000s
dndlogdp_bin120=y120(  3600,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin120=y120(  3600,2:col)   *1e6; 
diameter_bin120=dp120( 3600,2:coldp)*1e6;


% 060 BINS
load ../output/060/wetdp.res;
load ../output/060/size_dis.res;

infile='size_dis.res';
in=strrep(infile,'.res','');
y060=eval(in);
[row,col]=size(y060);                    %row=xxx col=61
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp060=eval(indp);
[rowdp,coldp]=size(dp060);
% 10h = 36000s
dndlogdp_bin060=y060(  3600,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin060=y060(  3600,2:col)   *1e6; 
diameter_bin060=dp060( 3600,2:coldp)*1e6;


% 032 BINS
load ../output/032/wetdp.res;
load ../output/032/size_dis.res;

infile='size_dis.res';
in=strrep(infile,'.res','');
y032=eval(in);
[row,col]=size(y032);                    %row=xxx col=61
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp032=eval(indp);
[rowdp,coldp]=size(dp032);
% 10h = 36000s
dndlogdp_bin032=y032(  3600,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin032=y032(  3600,2:col)   *1e6; 
diameter_bin032=dp032( 3600,2:coldp)*1e6;


% 016 BINS
load ../output/016/wetdp.res;
load ../output/016/size_dis.res;

infile='size_dis.res';
in=strrep(infile,'.res','');
y016=eval(in);
[row,col]=size(y016);                    %row=xxx col=61
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp016=eval(indp);
[rowdp,coldp]=size(dp016);
% 10h = 36000s
dndlogdp_bin016=y016(  3600,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin016=y016(  3600,2:col)   *1e6; 
diameter_bin016=dp016( 3600,2:coldp)*1e6;

windowSize0=4;
r1f=filter(ones(1,windowSize0)/windowSize0,1,dndlogdp_bin00);


%Normalize to initial
clf();
%graphics_toolkit ("fltk")

%loglog
% first 8h: hourly. then every 8h 
%1 hour= 1*60*6 = 360
% TIME UTC HERE AND ABOVE
figure(1)
axes('linewidth',2,'fontsize',16 , 'XScale','log','YScale','log','tickdir','out')
%MAFOR INIT
loglog(diameter_bin00,r1f,'Color',[.5 .5 .5],'LineStyle','--','LineWidth',1.5)
hold
ax=gca;
set(ax,'linewidth',2,'fontsize',16,'tickdir','out')
%grid on
%grid(gca,'minor')

%modelled at x bins
loglog(diameter_bin016,dndlogdp_bin016,      ':m'  ,'LineWidth',0.7)
loglog(diameter_bin032,dndlogdp_bin032,      ':g'  ,'LineWidth',0.7)
loglog(diameter_bin060,dndlogdp_bin060,'Color',[.1 .45 .1], ...
                                    'LineStyle',':','LineWidth',0.7)  %darkgreen
loglog(diameter_bin120,dndlogdp_bin120,      ':r'  ,'LineWidth',0.7)
loglog(diameter_bin160,dndlogdp_bin160,      '--b'  ,'LineWidth',1.5)

%LEGEND
legend('Ref t=0s','  16 bins','  32 bins','  60 bins',' 120 bins','160 bins','Location','NorthEast')  
xlabel('Particle diameter ({\mu}m)','FontSize',16)
ylabel('dN/dlogDp (particles cm^{-3})','FontSize',16)
%title(' Case 1 | Number size distribution','FontSize',15,'FontName','Arial')
%loglog
%set(gca,'xtick',[1,10,50,100,500,1000]);
%set(gca, 'xticklabel', [1,10,50,100,500,1000]);
set(gca,'xtick',[0.001,0.01,0.1,1.0,10]);
set(gca, 'xticklabel', [0.001,0.01,0.1,1.0,10]);
set(gca,'XLim',[0.001 2.],'Ylim',[1.e1 2.e4]); 

print -djpg '../plots/case1_sizedis_allbins.jpg'

clear
