######################/|\ ^._.^ /|\######################################
#Seasonal variation in age, sex, and reproductive condition of 
#Mexican free-tailed bats at a cave roost in eastern Nevada
#Authors: Joseph R. Danielson, Jason A. Williams, Richard E. Sherwin, 
#Kelsey L. Ekholm, Bryan T. Hamilton
#######################/|\ ^._.^ /|\###########################################
#Load packages
library(dplyr)
library(tidyr)
library(lubridate)
library(ggplot2)
library('lattice')
library(lme4)
library(MuMIn)#This package calculates AIC weights for model set
#set working directory 
setwd("F:/Publications/BatDemographics")
#Read in the Tadarida data
bats=read.csv("F:/Publications/BatDemographics/TadaridaData.csv")
#Model juveniles by julian day
bats$count=1 #add count colummn to make summary statistics easier to calculate
AgeData=  bats %>%
  complete(year,jday,age, fill = list(count = 0)) %>% 
  group_by(year,jday,age, .drop=FALSE) %>% 
  summarise(count = sum(count)) %>%  
  spread(key=age,value=count) %>% 
  filter(A!=0|SA!=0) %>% 
  print(n=Inf) 
AgeData$year=as.numeric(AgeData$year)
AgeData$jday=as.numeric(AgeData$jday)
AgeData=as.data.frame(AgeData)#convert to data frame, some strange errors with tibble
#rescale and center the day and year
#this helps the glmer mixedx models run
AgeData=AgeData %>%
  mutate(year2=scale(year, center = TRUE, scale = TRUE))
AgeData$jday2=scale(AgeData$jday, center = TRUE, scale = TRUE)
head(AgeData)
names(AgeData)
################################
#Build Models for Juveniles
##################################
model1=glmer(cbind(AgeData$SA,AgeData$A)~1+
               (1|year2),data=AgeData,family=binomial)
model2=glmer(cbind(AgeData$SA,AgeData$A)~jday2+
               (1|year2),data=AgeData,family=binomial)
model3=glmer(cbind(AgeData$SA,AgeData$A)~jday2+I(jday2^2)+
               (1|year2),data=AgeData,family=binomial)
model4=glmer(cbind(AgeData$SA,AgeData$A)~jday2+I(jday2^2)+I(jday2^3)+
               (1|year2),data=AgeData,family=binomial)
w=Weights(AICc(model1,model2,model3,model4))
ww=cbind(AICc(model1,model2,model3,model4),w)
ww[order(-w),]
ww[order(ww[,2]),]
#model 4 is highest weighted with 100%
summary(model4)
coef(summary(model4)) 
##########################################
#Model Adult females by julian day
##############################################
bats=read.csv("F:/Publications/BatDemographics/TadaridaData.csv")
head(bats)
names(bats)
bats=subset(bats, bats$age=="A")#Subset to only include adults
bats=droplevels(bats)
bats$count=1 #add count colummn to make summary statistics easier to calculate
bats=  bats %>%
  group_by(year,jday,sex, .drop=FALSE) %>% 
  summarise(count = sum(count)) %>%  
  spread(key=sex,value=count) %>% 
  filter(M!=0|F!=0) %>% 
  print(n=Inf) 
bats$year=as.numeric(bats$year)
bats$jday=as.numeric(bats$jday)
bats=as.data.frame(bats)#convert to data frame, some strange errors with tibble
bats$total=with(bats,(M+F))
#rescale and center the day and year
#this helps the glmer mixedx models run
bats=bats %>%
  mutate(year2=scale(year, center = TRUE, scale = TRUE))
bats$jday2=scale(bats$jday, center = TRUE, scale = TRUE)
#############################################
#Build Models for adult female bats
###############################################
model1=glmer(cbind(bats$F,bats$total-bats$F)~1+(1|year2),
             data=bats,family=binomial)
model2=glmer(cbind(bats$F,bats$total-bats$F)~jday2+(1|year2),
             data=bats,family=binomial)
model3=glmer(cbind(bats$F,bats$total-bats$F)~jday2+I(jday2^2)+
               (1|year2),data=bats,family=binomial)
model4=glmer(cbind(bats$F,bats$total-bats$F)~jday2+(I(jday2^2))+(I(jday2^3))+
               (1|year2), data=bats,family=binomial)
w=Weights(AICc(model1,model2,model3,model4))
ww=cbind(AICc(model1,model2,model3,model4),w)
ww[order(-w),]
ww[order(ww[,2]),]
#Model 4 is by far the highest weighted model
summary(model4)
coef(summary(model4)) 

#Model Pregnant Females
bats=read.csv("F:/Publications/BatDemographics/TadaridaData.csv")
females=subset(bats, bats$sex=="F")
females=subset(females, females$age=="A")
females=droplevels(females)
females$count=1 #add count colummn to make summary statistics easier to calculate
females$reproduct_stat=factor(females$reproduct_stat, 
                              levels = c("PG","LAC","PL","NRF"), ordered = TRUE)
females=  females %>%
  complete(year,jday,reproduct_stat, fill = list(count = 0)) %>% 
  group_by(year,jday,reproduct_stat, .drop=FALSE) %>% 
  summarise(count = sum(count)) %>%  
  spread(key=reproduct_stat,value=count) %>% 
  filter(PG!=0|LAC!=0|PL!=0|NRF!=0) %>% 
  print(n=Inf) 
females$year=as.numeric(females$year)
females$jday=as.numeric(females$jday)
females=as.data.frame(females)#convert to data frame, some strange errors with tibble
females$total=with(females,(PG+LAC+PL+NRF))
#rescale and center the day and year
#this helps the glmer mixedx models run
females=females %>%
  mutate(year2=scale(year, center = TRUE, scale = TRUE))
females$jday2=scale(females$jday, center = TRUE, scale = TRUE)
########################################
#Build Models for pregnant females
##############################################
#pregnancy model doesn't support random effects
#No pregnant females were captured in 2019 or 2017
#model 5 is highest weighted
pmodel1=glm(cbind(females$PG,females$total-females$PG)~1,
            data=females,family=binomial)
pmodel2=glm(cbind(females$PG,females$total-females$PG)~jday2,
            data=females,family=binomial)
pmodel3=glm(cbind(females$PG,females$total-females$PG)~jday2+I(jday2^2),
            data=females,family=binomial)
pmodel4=glm(cbind(females$PG,females$total-females$PG)~jday2+I(jday2^2)+
              I(jday2^3),data=females,family=binomial)

#Model 4 doesn't seem to run and the AIC is too big
w=Weights(AICc(pmodel1,pmodel2,pmodel3))
ww=cbind(AICc(pmodel1,pmodel2,pmodel3),w)
ww[order(-w),]
ww[order(ww[,2]),]
coef(summary(pmodel3)) 
###############################
#Build Models for lactating females
############################################
lmodel1=glmer(cbind(females$LAC,females$total-females$LAC)~1+
                (1|year2),data=females,family=binomial)
lmodel2=glmer(cbind(females$LAC,females$total-females$LAC)~jday2+
                (1|year2),data=females,family=binomial)
lmodel3=glmer(cbind(females$LAC,females$total-females$LAC)~jday2+I(jday2^2)+
                (1|year2),data=females,family=binomial)
lmodel4=glmer(cbind(females$LAC,females$total-females$LAC)~jday2+I(jday2^2)+I(jday2^3)+
                (1|year2),data=females,family=binomial)
#model 4 is highest weighted with 100% of the weight
w=Weights(AICc(lmodel1,lmodel2,lmodel3,lmodel4))
ww=cbind(AICc(lmodel1,lmodel2,lmodel3,lmodel4),w)
ww[order(-w),]
ww[order(ww[,2]),]
coef(summary(lmodel4)) 
###########################################
#Build Models for post-lactating females
###################################################
plmodel1=glmer(cbind(females$PL,females$total-females$PL)~1+(1|year2),
               data=females,family=binomial)
plmodel2=glmer(cbind(females$PL,females$total-females$PL)~jday2+(1|year2),
               data=females,family=binomial)
plmodel3=glmer(cbind(females$PL,females$total-females$PL)~jday2+I(jday2^2)+(1|year2),
               data=females,family=binomial)
#plmodel 3 is highest weighted
Weights(AICc(plmodel1,plmodel2,plmodel3))
w=Weights(AICc(plmodel1,plmodel2,plmodel3))
ww=cbind(AICc(plmodel1,plmodel2,plmodel3),w)
ww[order(-w),]
ww[order(ww[,2]),]
coef(summary(plmodel3))
#####################################################
#Build Models for non-reproductive adult females
nrmodel1=glmer(cbind(females$NRF,females$total-females$NRF)~1+(1|year2),
               data=females,family=binomial)
nrmodel2= glmer(cbind(females$NRF,females$total-females$NRF)~jday2+(1|year2),
                data=females,family=binomial)
nrmodel3= glmer(cbind(females$NRF,females$total-females$NRF)~jday2+I(jday2^2)+(1|year2),
                data=females,family=binomial)
nrmodel4=glmer(cbind(females$NRF,females$total-females$NRF)~jday2+I(jday2^2)+I(jday2^3)+
                 (1|year2),data=females,family=binomial)
#nr model 4 is highest weighted
#random effects plmodels are highly prefered
w=Weights(AICc(nrmodel1,nrmodel2,nrmodel3,nrmodel4))
ww=cbind(AICc(nrmodel1,nrmodel2,nrmodel3,nrmodel4),w)
ww[order(-w),]
ww[order(ww[,2]),]
coef(summary(nrmodel4))
