<!--
👋 Hello, and thank you for starting this contribution!
📖 Make sure you've read our CONTRIBUTING.md guide before submitting your pull request.
❗️ Please follow the template below to help other contributors review your work.
-->

### PR and Code Checklist
<!--
NOTE: We will not merge if the following steps have not been completed!
-->
- [ ] [semantic-release](https://github.com/semantic-release/semantic-release) commit messages
- [ ] Run `npm run reformat` to have correctly formatted code

### Context
<!--
Explain why this change is needed. Please include relevant links supporting this change, such as:
- fix #ISSUE_NUMBER (from issue tracker)
- discourse post thread, or any other existing references
-->

### Changes
<!--
Please describe what is changing. Include:
- APIs added, deleted, deprecated, or changed
- Classes and methods added, deleted, deprecated, or changed
- A summary of usage if this is a new feature or change to an API. Adequate documentation and TS definitions should also be added/updated.
-->
- [ ] Documentation and TypeScript definitions were updated to match those changes

### Results
<!--
Describe or illustrate the effects of your contribution. Please include:
- comparisons of the behavior before vs after
- screenshots of new or changed visualizations if applicable
-->

### Testing
<!--
Please describe how this can be tested by reviewers. Be specific about anything not tested and the reasons why. Tests should be added for new functionality and existing tests should complete without errors. See CONTRIBUTING.md
-->
- [ ] This change adds or fixes unit tests
- [ ] All tests complete without errors on the following environment:
  - **vtk.js**: <!-- ex: 14.0.0 (favor latest master) -->
  - **OS**: <!-- ex: Windows 10, iOS 13.6 -->
  - **Browser**: <!-- ex: Chrome 89.0.4389.128 -->

<!-- Remove the line below if it is not relevant -->
_This contribution is funded by [Example](https://example.com)._
