% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_stds.R
\name{sim_stds}
\alias{sim_stds}
\title{Simulate standard and sample collection}
\usage{
sim_stds(
  stdfreqs = c(1, 1, 1, 1, 0),
  stdn = 50,
  smpn = 50,
  stdev = 50,
  smpt = 0,
  input_slope = kslope,
  stdtable = make_std_table(slope = input_slope),
  smpinfo = make_smp_info(smpt),
  out = "none"
)
}
\arguments{
\item{stdfreqs}{An integer/numeric vector with the proportion of each
standard in stdtable.}

\item{stdn}{The total number of standard measurements to simulate.}

\item{smpn}{The total number of sample measurements to simulate.}

\item{stdev}{The standard deviation of measurements in ppm (0.001 ‰)}

\item{smpt}{The known temperature of the sample. Not needed in case smpinfo
is provided.}

\item{input_slope}{The input slope of the ETF.}

\item{stdtable}{A \link[tibble:tibble-package]{tibble} of standard info,
generated with \code{make_std_table()}.}

\item{smpinfo}{A \link[tibble:tibble-package]{tibble} of sample info, generated
with \code{make_std_table()}.}

\item{out}{A string describing the desired output, either "none" (default),
"cond", "smp", "std", "cis", "etf", "pl", or "all".}
}
\value{
Based on parameter "out", it returns either:
\item{none}{Nothing is returned, without warning.}
\item{cond}{The input conditions.}
\item{smp}{The full table of sample simulations.}
\item{std}{The full table of standard simulations.}
\item{cis}{The confidence intervals.}
\item{etf}{The empirical transfer function linear regression model.}
\item{pl}{The ggplot output.}
\item{all}{A list of the above.}
}
\description{
This function simulates the measurement of samples and standards based on
'smpinfo' and 'stdtable' based on further arguments. It then fits a linear
regression through the standards (the empirical transfer function, or ETF),
which is then applied to the input sample values to calculate the final
\eqn{\Delta_{47}}{Δ[47]}-value of the sample, using inverse regression. It
can return all the intermediate steps to follow along, as well as a plot to
show how the ETF is applied.
}
\examples{
library(stdsim)

# set global output options
options(genplot = TRUE, verbose = TRUE)

# generate a standard reference table
eth.info <- make_std_table()

# run the simulation with the above table as input
sim_stds(stdfreqs = c(1, 1, 1, 1, 0), stdn = 80, smpn = 20, stdtable = eth.info)

# more examples
sim_stds(c(1, 1, 1, 0, 9), smpn = 20, stdn = 300, stdtable = eth.info, smpt = 10)
sim_stds(stdn = 90, smpn = 10, out = "cis", stdtable = eth.info)
sim_stds(c(1, 1, 1, 1, 0))
sim_stds(c(1, 1, 9, 1, 1), smpn = 30, stdn = 100, out = "cond")
sim_stds(c(1, 1, 9, 0, 0), smpn = 16, stdn = 84, 50, smpt = 0, out = "cis")
exmp <- sim_stds(c(1, 1, 2, 1, 2), stdtable = eth.info, out = "all")
}
\references{
Brandon M. Greenwell and Christine M. Schubert Kabban (2014)
investr: An R Package for Inverse Estimation. The R Journal, 6(1), 90-100.
URL http://journal.r-project.org/archive/2014-1/greenwell-kabban.pdf
}
