% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{revcal}
\alias{revcal}
\title{Reverse temperature calibration}
\usage{
revcal(
  D47,
  slope = 0.0449,
  intercept = 0.167,
  slpcnf = 0.001,
  intcnf = 0.01,
  ignorecnf = FALSE
)
}
\arguments{
\item{D47}{The \eqn{\Delta_{47}}{Δ[47]} value.}

\item{slope}{The slope of the regression.}

\item{intercept}{The intercept of the regression.}

\item{slpcnf}{The confidence of the slope of the regression.}

\item{intcnf}{The confidence of the intercept of the regression.}

\item{ignorecnf}{Whether or not to ignore the confidence interval.}
}
\value{
A \link[tibble:tibble-package]{tibble} with input D47 and estimated Tc
value with lower and upper bounds.
}
\description{
A clumped isotope temperature calibration in reversed form, where the normal
calibration y = a * 10^6 / T_K^2 + b is expressed as a function of T_C:
T_C = sqrt((a * 10^6) / (y - b)) - 273.15
}
\details{
Defaults to Bonifacie et al. 2017
\eqn{\Delta_{47}}{Δ[47]} = (0.0449 ± 0.001 * 10^6) / T^2 + (0.167 ± 0.01)
}
\seealso{
tempcal
}
