% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim.R
\name{plot_sim}
\alias{plot_sim}
\title{Plot output of single simulation}
\usage{
plot_sim(
  out,
  input_etf = TRUE,
  input_pointrange = FALSE,
  graylines = TRUE,
  violin = TRUE,
  point = TRUE,
  point_alpha = 0.5,
  pointrange = TRUE,
  labs = TRUE,
  fixed = TRUE,
  idscale = TRUE,
  axlabs = TRUE
)
}
\arguments{
\item{out}{The output list of \code{sim_stds()} with \code{out="all"} specified.}

\item{input_etf}{Logical. Plot input ETF line.}

\item{input_pointrange}{Logical. Plot input pointrange with SD.}

\item{graylines}{Logical. Plot gray lines at input Raw and output accepted
values.}

\item{violin}{Logical. Plot violins for sample and standard distributions.}

\item{point}{Logical. Plot simulation points.}

\item{point_alpha}{The alpha value of the points.}

\item{pointrange}{Logical. Plot the pointrange of the simulations.}

\item{labs}{Logical. Plot labels with \link[ggrepel:ggrepel]{ggrepel}.}

\item{fixed}{Logical. Fix coordinates.}

\item{idscale}{Logical. Set the scale and fill scales.}

\item{axlabs}{Logical. Set the axis labels.}
}
\value{
A ggplot object.
}
\description{
This function plots the simulation's output using ggplot2.
}
