% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_std_table.R
\name{make_std_table}
\alias{make_std_table}
\title{Create reference table of standards}
\usage{
make_std_table(
  id = c(paste0("ETH-", 1:4), "UU1"),
  col = c("orange", "purple", "#00B600", "blue", "#FFCD00"),
  D47_std = c(0.258, 0.256, 0.691, 0.507, tempcal(4, ignorecnf = TRUE)),
  slope = kslope,
  intercept = kintercept,
  aff = kaff
)
}
\arguments{
\item{id}{The names of the standards that are used in the simulations.}

\item{col}{The colours that these standards will have in plots.}

\item{D47_std}{The accepted \eqn{\Delta_{47}}{Δ[47]} values of the standards.}

\item{slope}{The input ETF slope.}

\item{intercept}{The input ETF intercept.}

\item{aff}{The acid fractionation factor.}
}
\value{
A \link[tibble:tibble-package]{tibble} of standard names (id), colours
(col), \eqn{\Delta_{47}}{Δ[47]} accepted value (D47),
\eqn{\Delta_{47}}{Δ47} with acid fractionation subtracted, i.e. projected
to 70°C (D47.noacid), the expected raw value based on the linear
regression (rawcat) and the temperature in °C (temp).
}
\description{
Create a reference table with expected values for the standards
}
\seealso{
make_smp_info kslope kintercept kaff
}
