% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_smp_info.R
\name{make_smp_info}
\alias{make_smp_info}
\title{Create a tibble with sample information.}
\usage{
make_smp_info(smpt = 0, slope = kslope, intercept = kintercept, aff = kaff)
}
\arguments{
\item{smpt}{The temperature from which to calculate \eqn{\Delta_{47}}{Δ[47]}
values.}

\item{slope}{The input ETF slope.}

\item{intercept}{The input ETF intercept.}

\item{aff}{The acid fractionation factor.}
}
\value{
A \link[tibble:tibble-package]{tibble} of the sample name (id), colour
(col), \eqn{\Delta_{47}}{Δ[47]} accepted value (D47),
\eqn{\Delta_{47}}{Δ[47]} with acid fractionation subtracted, i.e.
projected to 70°C (D47.noacid), the expected raw value based on the linear
regression (rawcat) and the temperature in °C (temp).
}
\description{
Create a reference table with expected values for the sample of interest.
}
\seealso{
make_std_info kslope kintercept kaff
}
