#!/bin/bash

#Code to fine-map the OAS1/2/3 lcous using FINEMAP v1.4.
#Hugo Zeberg, hugo.zeberg@ki.se, 2021-06-12

#Requires:
#afr_dataset.ld (LD structure among African ancestry individuals)
#eur_dataset.ld (LD structure among Europeans ancestry individual)
#eur_dataset.z (effect estimates among Europeans ancestry individual, includes a probability column based on scaled CADD-scores)
#afr_dataset_no_prior.z (effect estimates among Europeans ancestry individual, without prior probabilities)
#master_afr (run file for the finemapping step on African ancestry individuals)
#master_eur (run file for the finemapping step on African ancestry individuals)

#Prior unscaled standard deviation = (log(2)/1.96)
#Scaling below for phi (case/control ratio). See Benner, C. et al. Bioinformatics 32, 1493–1501 (2016).
#phi_eur = 17992/(17992+1810493)
#phi_afr = 2113/(2113+121925)
#prior-std_afr = (log(2)/1.96)*sqrt(phi_eur*(1-phi_eur)) = 0.0349
#prior-std_afr = (log(2)/1.96)*sqrt(phi_afr*(1-phi_afr)) = 0.0458

#Make folders.
mkdir -p out
mkdir -p tmp
rm out/*
rm tmp/*

#Run FINEMAP on European data, no priors. 
finemap --sss --in-files master_eur --prior-std 0.0349
mv eur_dataset.snp tmp/
mv eur_dataset.cred* tmp/
mv eur_dataset.config tmp/
rename eur_dataset eur_dataset_no_cadd_prior tmp/*
mv tmp/* out/

#Run FINEMAP on European data, with priors. 
finemap --prior-snps --sss --in-files master_eur --prior-std 0.0349 
mv eur_dataset.snp tmp/
mv eur_dataset.cred* tmp/
mv eur_dataset.config tmp/
rename eur_dataset eur_dataset_cadd_prior tmp/*
mv tmp/* out/

#Run FINEMAP on African data, no cadd priors. 
#Extract posterior probabilities from European analysis and use as priors in the African analysis.
echo "prob" > prior_prob_afr.txt
sed '1d' out/eur_dataset_no_cadd_prior.snp | sort -V -k 1,1 | awk '{print $11}' >> prior_prob_afr.txt
paste -d' ' afr_dataset_no_prior.z prior_prob_afr.txt > afr_dataset.z
sed -i '/^ /d' afr_dataset.z

finemap --prior-snps --sss --in-files master_afr --prior-std 0.0458
mv afr_dataset.snp tmp/
mv afr_dataset.cred* tmp/
mv afr_dataset.config tmp/
rename afr_dataset afr_dataset_no_cadd_prior tmp/*
mv tmp/* out/
rm prior_prob_afr.txt
rm afr_dataset.z

#Run FINEMAP on African data, with cadd priors. 
#Extract posterior probabilities from European analysis and use as priors in the African analysis.
echo "prob" > prior_prob_afr.txt
sed '1d' out/eur_dataset_cadd_prior.snp | sort -V -k 1,1 | awk '{print $11}' >> prior_prob_afr.txt
paste -d' ' afr_dataset_no_prior.z prior_prob_afr.txt > afr_dataset.z
sed -i '/^ /d' afr_dataset.z

finemap --prior-snps --sss --in-files master_afr --prior-std 0.0458
mv afr_dataset.snp tmp/
mv afr_dataset.cred* tmp/
mv afr_dataset.config tmp/
rename afr_dataset afr_dataset_cadd_prior tmp/*
mv tmp/* out/
rm prior_prob_afr.txt
rm afr_dataset.z

#Clean up
rmdir tmp
