clear
set more off

use data_halfyearly

/*Merge experimental data*/
merge m:1 pid using data_experimental, keep(match master)
drop _merge

/***************************************************************************/
/*Table S11: Table S11: Robustness check for Sharpe Ratio, relative volatility,
 relative semi-volatility, and tracking error when calculating these measures
 based on daily data over half a year*/

 	/*Column 1*/
 areg SR crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YH)
est store reg_s11_1

	/*Column 2*/
areg RV crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, vce(cluster pid) absorb(YH)
est store reg_s11_2

	/*Column 3*/
areg RSV crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, vce(cluster pid) absorb(YH)
est store reg_s11_3

	/*Column 4*/
areg TE crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0 & RV~=., cluster(pid) absorb(YH)
est store reg_s11_4

outreg2 [reg_s11_*] using TableS11.doc, keep(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper) ///
 sortvar(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper) ///
 nocons depvar word pval alpha(0.005, 0.05) e(N_clust) adjr2 dec(3) replace