clear
set more off

use data_monthly

/*Merge experimental data*/
merge m:1 pid using data_experimental, keep(match master)
drop _merge

/***************************************************************************/
/*Table 5: Performance – gross returns, abnormal returns and value added*/
	/*Column 1*/
areg ret_gross crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_5_1 

	/*Column 2*/
areg ret_gross crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest Team, cluster(pid) absorb(YM)
est store reg_5_2

	/*Column 3*/
areg ret_abn crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_5_3

	/*Column 4*/
areg ret_abn crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest Team, cluster(pid) absorb(YM)
est store reg_5_4

	/*Column 5*/
areg V crt tom competitive risk loss ambiguity ///
 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_5_5

	/*Column 6*/
areg V crt tom competitive risk loss ambiguity ///
 exper cat_eq cat_all cat_rest Team, cluster(pid) absorb(YM)
est store reg_5_6

outreg2 [reg_5_*] using Table5.doc, ///
 keep(ret_gross crt tom competitive risk loss ambiguity lAUM_1 exper Team) ///
 sortvar(ret_gross crt tom competitive risk loss ambiguity lAUM_1 exper Team) ///
 nocons depvar word pval alpha(0.005, 0.05) adjr2 e(N_clust) dec(3) replace

 
/***************************************************************************/
/*Table 6: Sharpe Ratio and risk measures*/
	/*Column 1*/
areg SR crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_6_1

	/*Column 2*/
areg SR crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest Team, cluster(pid) absorb(YM)
est store reg_6_2

	/*Column 3*/
areg RV crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, vce(cluster pid) absorb(YM)
est store reg_6_3

	/*Column 4*/
areg RV crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper  Team cat_eq cat_all cat_rest Team, vce(cluster pid) absorb(YM)
est store reg_6_4

	/*Column 5*/
areg TE crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_6_5

	/*Column 6*/
areg TE crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest Team, cluster(pid) absorb(YM)
est store reg_6_6

outreg2 [reg_6_*] using Table6.doc, ///
 keep(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 sortvar(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 nocons depvar word pval alpha(0.005, 0.05) adjr2  e(N_clust) dec(3) replace

 
/****************************************************************************/
/*Table S5: Adjusted R-squared values of regressions with time-, manager-,
and fund fixed efects*/ 

putexcel set TableS5, replace
putexcel B1="R_gross"
putexcel C1="R_abn"
putexcel D1="V"
putexcel E1="SR"
putexcel F1="RV"
putexcel G1="TE"

	/*Only Time Fixed Effects*/
putexcel A2="Time FE"
	
areg ret_gross lAUM_1 if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel B2=results[1,1], nformat(0.0)

areg ret_abn lAUM_1 if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel C2=results[1,1], nformat(0.0)

areg V if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel D2=results[1,1], nformat(0.0)

areg SR ret_gross_1_neg ret_gross_1_pos lAUM_1 if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel E2=results[1,1], nformat(0.0)

areg RV ret_gross_1_neg ret_gross_1_pos lAUM_1 if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel F2=results[1,1], nformat(0.0)

areg TE ret_gross_1_neg ret_gross_1_pos lAUM_1 if Team==0, absorb(YM) 
matrix define results=e(r2_a)*100
putexcel G2=results[1,1], nformat(0.0)

	/*Time and Manager Fixed Effects*/
putexcel A3="Time + Manager FE"
tab pid, g(man)		/*Generate manager dummies*/

areg ret_gross lAUM_1 man* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel B3=results[1,1], nformat(0.0)

areg ret_abn lAUM_1 man* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel C3=results[1,1], nformat(0.0)

areg V man* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel D3=results[1,1], nformat(0.0)

areg SR ret_gross_1_neg ret_gross_1_pos lAUM_1 man* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel E3=results[1,1], nformat(0.0)

areg RV ret_gross_1_neg ret_gross_1_pos lAUM_1 man* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel F3=results[1,1], nformat(0.0)

areg TE ret_gross_1_neg ret_gross_1_pos lAUM_1 man* if Team==0, absorb(YM) 
matrix define results=e(r2_a)*100
putexcel G3=results[1,1], nformat(0.0)

drop man*

	/*Time and Fund Fixed Effects*/
putexcel A4="Time + Fund FE"
tab FundId, g(fund)		/*Generate fund dummies*/

areg ret_gross lAUM_1 fund* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel B4=results[1,1], nformat(0.0)

areg ret_abn lAUM_1 fund* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel C4=results[1,1], nformat(0.0)

areg V fund* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel D4=results[1,1], nformat(0.0)

areg SR ret_gross_1_neg ret_gross_1_pos lAUM_1 fund* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel E4=results[1,1], nformat(0.0)

areg RV ret_gross_1_neg ret_gross_1_pos lAUM_1 fund* if Team==0, absorb(YM)
matrix define results=e(r2_a)*100
putexcel F4=results[1,1], nformat(0.0)

areg TE ret_gross_1_neg ret_gross_1_pos lAUM_1 fund* if Team==0, absorb(YM) 
matrix define results=e(r2_a)*100
putexcel G4=results[1,1], nformat(0.0)

drop fund*
putexcel save

/***************************************************************************/
/*Table S7: Robustness check for abnormal returns and tracking error using
factor-model based benchmarks*/
	/*Column 1*/
areg ret_abn_global4 crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s7_1

	/*Column 2*/
areg TE_global4 crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s7_2

	/*Column 3*/
areg ret_abn_FF_EU crt tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s7_3

	/*Column 4*/
areg TE_FF_EU crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s7_4

outreg2 [reg_s7_*] using TableS7.doc, keep(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper) ///
 sortvar(crt tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper) ///
 nocons depvar word pval alpha(0.005, 0.05) e(N_clust) adjr2 dec(3) replace


/***************************************************************************/
/*Table S8: Robustness check for including the experimental measures separately */

putexcel set TableS8, replace
putexcel B1="R_gross"
putexcel C1="R_abn"
putexcel D1="V"
putexcel E1="SR"
putexcel F1="RV"
putexcel G1="TE"

	/*CRT results*/
putexcel A2="CRT"
putexcel A3="  p-value"

areg ret_gross crt lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B2=results[1,1], nformat(0.000)
putexcel B3=results[4,1], nformat(0.000)

areg ret_abn crt lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C2=results[1,1], nformat(0.000)
putexcel C3=results[4,1], nformat(0.000)

areg V crt exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D2=results[1,1], nformat(0.000)
putexcel D3=results[4,1], nformat(0.000)

areg SR crt ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E2=results[1,1], nformat(0.000)
putexcel E3=results[4,1], nformat(0.000)

areg RV crt ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F2=results[1,1], nformat(0.000)
putexcel F3=results[4,1], nformat(0.000)

areg TE crt ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G2=results[1,1], nformat(0.000)
putexcel G3=results[4,1], nformat(0.000)


	/*TOM results*/
putexcel A5="TOM"
putexcel A6="  p-value"

areg ret_gross tom lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B5=results[1,1], nformat(0.000)
putexcel B6=results[4,1], nformat(0.000)

areg ret_abn tom lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C5=results[1,1], nformat(0.000)
putexcel C6=results[4,1], nformat(0.000)

areg V tom exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D5=results[1,1], nformat(0.000)
putexcel D6=results[4,1], nformat(0.000)

areg SR tom ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E5=results[1,1], nformat(0.000)
putexcel E6=results[4,1], nformat(0.000)

areg RV tom ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F5=results[1,1], nformat(0.000)
putexcel F6=results[4,1], nformat(0.000)

areg TE tom ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G5=results[1,1], nformat(0.000)
putexcel G6=results[4,1], nformat(0.000)

	/*COMPETITIVENESS results*/
putexcel A8="COMPETITIVENESS"
putexcel A9="  p-value"

areg ret_gross competitive lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B8=results[1,1], nformat(0.000)
putexcel B9=results[4,1], nformat(0.000)

areg ret_abn competitive lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C8=results[1,1], nformat(0.000)
putexcel C9=results[4,1], nformat(0.000)

areg V competitive exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D8=results[1,1], nformat(0.000)
putexcel D9=results[4,1], nformat(0.000)

areg SR competitive ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E8=results[1,1], nformat(0.000)
putexcel E9=results[4,1], nformat(0.000)

areg RV competitive ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F8=results[1,1], nformat(0.000)
putexcel F9=results[4,1], nformat(0.000)

areg TE competitive ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G8=results[1,1], nformat(0.000)
putexcel G9=results[4,1], nformat(0.000)

	/*RISK TOLERANCE results*/
putexcel A11="RISK TOLERANCE"
putexcel A12="  p-value"

areg ret_gross risk lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B11=results[1,1], nformat(0.000)
putexcel B12=results[4,1], nformat(0.000)

areg ret_abn risk lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C11=results[1,1], nformat(0.000)
putexcel C12=results[4,1], nformat(0.000)

areg V risk exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D11=results[1,1], nformat(0.000)
putexcel D12=results[4,1], nformat(0.000)

areg SR risk ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E11=results[1,1], nformat(0.000)
putexcel E12=results[4,1], nformat(0.000)

areg RV risk ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F11=results[1,1], nformat(0.000)
putexcel F12=results[4,1], nformat(0.000)

areg TE risk ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G11=results[1,1], nformat(0.000)
putexcel G12=results[4,1], nformat(0.000)

	/*LOSS TOLERANCE results*/
putexcel A14="LOSS TOLERANCE"
putexcel A15="  p-value"

areg ret_gross loss lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B14=results[1,1], nformat(0.000)
putexcel B15=results[4,1], nformat(0.000)

areg ret_abn loss lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C14=results[1,1], nformat(0.000)
putexcel C15=results[4,1], nformat(0.000)

areg V loss exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D14=results[1,1], nformat(0.000)
putexcel D15=results[4,1], nformat(0.000)

areg SR loss ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E14=results[1,1], nformat(0.000)
putexcel E15=results[4,1], nformat(0.000)

areg RV loss ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F14=results[1,1], nformat(0.000)
putexcel F15=results[4,1], nformat(0.000)

areg TE loss ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G14=results[1,1], nformat(0.000)
putexcel G15=results[4,1], nformat(0.000)

	/*LOSS TOLERANCE results*/
putexcel A17="AMBIGUITY TOLERANCE"
putexcel A18="  p-value"

areg ret_gross ambiguity lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel B17=results[1,1], nformat(0.000)
putexcel B18=results[4,1], nformat(0.000)

areg ret_abn ambiguity lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel C17=results[1,1], nformat(0.000)
putexcel C18=results[4,1], nformat(0.000)

areg V ambiguity exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel D17=results[1,1], nformat(0.000)
putexcel D18=results[4,1], nformat(0.000)

areg SR ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel E17=results[1,1], nformat(0.000)
putexcel E18=results[4,1], nformat(0.000)

areg RV ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel F17=results[1,1], nformat(0.000)
putexcel F18=results[4,1], nformat(0.000)

areg TE ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
matrix define results=r(table)
putexcel G17=results[1,1], nformat(0.000)
putexcel G18=results[4,1], nformat(0.000)

putexcel save


/***************************************************************************/
/*Table S9: Robustness check for excluding the 2008-2009 crisis period and
including time preferences*/
	/*Column 1*/
areg SR crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0 & YM>=ym(2010,1), cluster(pid) absorb(YM)
est store reg_s9_1

	/*Column 2*/
areg RV crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0 & YM>=ym(2010,1), cluster(pid) absorb(YM)
est store reg_s9_2

	/*Column 3*/
areg TE crt tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0 & YM>=ym(2010,1), cluster(pid) absorb(YM)
est store reg_s9_3

	/*Column 4*/
areg SR crt tom competitive risk loss ambiguity patience ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s9_4

	/*Column 5*/
areg RV crt tom competitive risk loss ambiguity patience ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s9_5

	/*Column 6*/
areg TE crt tom competitive risk loss ambiguity patience ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s9_6

outreg2 [reg_s9_*] using TableS9.doc, keep(crt tom competitive risk loss ambiguity patience ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 sortvar(crt tom competitive risk loss ambiguity patience ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 nocons depvar word pval alpha(0.005, 0.05) adjr2 e(N_clust) dec(3) replace


/***************************************************************************/
/*Table S10: Robustness check for using apm instead of crt*/
	/*Column 1*/
areg ret_gross apm tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_1

	/*Column 2*/
areg ret_abn apm tom competitive risk loss ambiguity ///
 lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_2

	/*Column 3*/
areg V apm tom competitive risk loss ambiguity ///
 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_3

	/*Column 4*/
areg SR apm tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_4

	/*Column 5*/
areg RV apm tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_5

	/*Column 6*/
areg TE apm tom competitive risk loss ambiguity ///
 ret_gross_1_neg ret_gross_1_pos lAUM_1 exper cat_eq cat_all cat_rest if Team==0, cluster(pid) absorb(YM)
est store reg_s10_6

outreg2 [reg_s10_*] using TableS10.doc, keep(apm tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 sortvar(apm tom competitive risk loss ambiguity ret_gross_1_neg ret_gross_1_pos lAUM_1 exper Team) ///
 nocons depvar word pval alpha(0.005, 0.05) adjr2  e(N_clust) dec(3) replace


/***************************************************************************/
/*Table S6: Robustness check for handling multiple funds run by a manager*/

/*For this table, we have to aggregate observation across funds run by 
the same manager in a given month*/

/*By manager-month, percentage of AUM managed as single manager*/
sort pid FundId YM
replace AUM_1=0 if AUM_1==.
gen interaction=Team*AUM_1, a(AUM_1)
sort pid YM
by pid YM: egen totAUM=total(AUM_1)
by pid YM: egen totAUMTeam=total(interaction)
gen maninteam=totAUMTeam/totAUM
drop totAUM totAUMTeam interaction
	/*those observations where all funds are single managed or all are team-manged*/
by pid YM: egen allsingle=total(Team)	
replace maninteam=0 if allsingle==0
drop allsingle
by pid YM: egen allteam=total(1-Team)	
replace maninteam=1 if allteam==0
drop allteam

/*Keep only manager-months where management in team is less than 50%*/
keep if maninteam<0.5 & maninteam~=.
drop maninteam

/*AUM divided by size of management team*/
replace AUM_1=AUM_1/(TeamSize+1) if TeamSize>0

/*Category of manager - largest category by AUM*/
sort pid YM
foreach type in "fi" "eq" "all" "rest" {
	gen AUM_temp=AUM_1*cat_`type'
	by pid YM: egen AUM_`type'=total(AUM_temp)
	drop AUM_temp
}
egen maxAUM=rowmax(AUM_fi - AUM_rest)
foreach type in "fi" "eq" "all" "rest" {
	gen cat2_`type'=AUM_`type'==maxAUM & maxAUM~=0
}
drop AUM_fi-maxAUM
egen sumcat2=rowtotal(cat2_fi - cat2_rest)
foreach type in "fi" "eq" "all" "rest" {
	by pid YM: egen AUM_`type'=total(cat_`type') if sumcat2==0
}
egen maxAUM=rowmax(AUM_fi - AUM_rest) if sumcat2==0
foreach type in "fi" "eq" "all" "rest" {
	replace cat2_`type'=AUM_`type'==maxAUM if sumcat2==0
}
drop sumcat2
egen sumcat2=rowtotal(cat2_fi - cat2_rest)
replace cat2_fi=0 if sumcat2==2
replace cat2_eq=0 if sumcat2==2
replace cat2_all=0 if sumcat2==2
replace cat2_rest=1 if sumcat2==2
drop sumcat2
egen sumcat2=rowtotal(cat2_fi - cat2_rest)
drop AUM_fi-maxAUM sumcat2
drop cat_fi - cat_rest
foreach type in "fi" "eq" "all" "rest" {
	rename cat2_`type' cat_`type'
}

/*Aggregate dependent variables across funds for every manager-YM*/
sort pid YM

foreach var of varlist ret_gross ret_abn V RV TE SR {

	by pid YM: egen numfund=count(`var')
	by pid YM: egen totAUM=total(AUM_1) if numfund>=2 & `var'~=.
	gen w=AUM_1/totAUM if `var'~=.
	gen `var'prod=`var'*w
	by pid YM: egen `var'avg=total(`var'prod) if numfund>=2 & totAUM>0
	by pid YM: egen `var'avg2=mean(`var') if numfund>=2 & totAUM==0
	replace `var'avg=`var'avg2 if numfund>=2 & totAUM==0
	drop `var'avg2
	by pid YM: egen `var'avg2=total(`var') if numfund==1 
	replace `var'avg=`var'avg2 if numfund==1
	drop `var'avg2
	drop numfund totAUM w
	
	drop `var' `var'prod
	rename `var'avg `var'
}

/*Total AUM*/
by pid YM: egen totAUM=total(AUM_1)
drop lAUM_1
gen lAUM_1=log(totAUM)
drop totAUM

/*Getting rid of duplicates in terms of manager-YM*/
duplicates drop pid YM, force

/*Regressions for Table S6*/
	/*Column 1*/
areg ret_gross crt tom competitive risk loss ambiguity ///
lAUM_1 exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_1

	/*Column 2*/
areg ret_abn crt tom competitive risk loss ambiguity ///
lAUM_1 exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_2

	/*Column 3*/
areg V crt tom competitive risk loss ambiguity ///
exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_3

	/*Column 4*/
areg SR crt tom competitive risk loss ambiguity ///
lAUM_1 exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_4

	/*Column 5*/	
areg RV crt tom competitive risk loss ambiguity ///
lAUM_1 exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_5

	/*Column 6*/
areg TE crt tom competitive risk loss ambiguity ///
lAUM_1 exper cat_eq cat_all cat_rest, cluster(pid) absorb(YM)
est store reg_s6_6

outreg2 [reg_s6_*] using TableS6, keep(crt tom competitive risk loss ambiguity lAUM_1 exper) ///
 sortvar(crt tom competitive risk loss ambiguity lAUM_1 exper) ///
 nocons depvar word pval alpha(0.005, 0.05) adjr2 e(N_clust) dec(3) replace