clear

set more off
use data_monthly

/******************************************************************************/
/*Table S2: Number of (non-missing) fund-month observations for each variable*/
putexcel set TableS2, replace
putexcel B1="Fund-month observations"
putexcel C1="Number of Funds"
	/*Sample*/
putexcel A2="Sample"
su YM
putexcel B2=`r(N)'
egen tag=tag(FundId)
by FundId: egen numnonmiss=count(YM)
su YM if tag==1 & numnonmiss>0
putexcel C2=`r(N)'
drop numnonmiss

	/*AUM*/
putexcel A3="Assets under management (AUM)"
su AUM
putexcel B3=`r(N)'
by FundId: egen numnonmiss=count(AUM)
su YM if tag==1 & numnonmiss>0
putexcel C3=`r(N)'
drop numnonmiss

	/*Net return*/
putexcel A4="Net return (in EUR)"
su ret_net
putexcel B4=`r(N)'
by FundId: egen numnonmiss=count(ret_net)
su YM if tag==1 & numnonmiss>0
putexcel C4=`r(N)'
drop numnonmiss

	/*ER*/
putexcel A5="Total Expense Ratio (ER) "
su ER
putexcel B5=`r(N)'
by FundId: egen numnonmiss=count(ER)
su YM if tag==1 & numnonmiss>0
putexcel C5=`r(N)'
drop numnonmiss

putexcel save
drop tag


/******************************************************************************/
/*Table S3: Summary of steps involved for creating fund level observations for AUM*/
tab2docx AUM_source, filename("TableS3" , replace)


/******************************************************************************/
/*Table S4: Summary of steps involved for creating fund level observations for ER*/
tab2docx ER_source, filename("TableS4" , replace)


/******************************************************************************/
/*Table 4: Summary statistics of the sample at the fund level:*/
/*Panel A: Funds with benchmark return data*/

duplicates drop FundId YM, force
	/*use only funds where we have benchmark data*/
by FundId: egen ret_abn_nonmiss=count(ret_abn)
by FundId: egen AUM_nonmiss=count(lAUM_1)
gen tag2=1
replace tag2=0 if ret_abn_nonmiss==0 | AUM_nonmiss==0 | tag==0
keep if tag2==1
	/*Calculate time-seires averages per fund*/
by FundId: egen insample=count(YM)
by FundId: egen AUM_avg=mean(AUM/1000000)
by FundId: egen ER_avg=mean(ER)
by FundId: egen ret_gross_avg=mean(ret_gross)
by FundId: egen ret_net_avg=mean(ret_net)
by FundId: egen ret_abn_avg=mean(ret_abn)
by FundId: egen V_avg=mean(V)
by FundId: egen SR_avg=mean(SR)
by FundId: egen RV_avg=mean(RV)
by FundId: egen TE_avg=mean(TE)
by FundId: egen Team_avg=min(Team)

drop AUM ER ret_gross ret_net ret_abn V SR RV TE Team
rename AUM_avg AUM
rename ER_avg ER
rename ret_gross_avg ret_gross
rename ret_net_avg ret_net
rename ret_abn_avg ret_abn
rename V_avg V
rename SR_avg SR
rename RV_avg RV
rename TE_avg TE
rename Team_avg Team_managed
rename cat_fi Fixed_income
rename cat_eq Equity
rename cat_all Allocation
rename cat_rest Rest

	/*Summary stats from the table*/
duplicates drop FundId, force
	
outreg2 using Table4_PanelA.doc, replace sum(detail) ///
	keep(insample AUM ER ret_gross ret_net ret_abn V SR RV TE Team_managed Fixed_income Equity Allocation Rest) ///
	sortvar(insample AUM ER ret_gross ret_net ret_abn V SR RV TE Team_managed Fixed_income Equity Allocation Rest) ///
	eqkeep(N mean sd p10 p25 p50 p75 p90) word dec(2)


/******************************************************************************/
/*Table 4: Summary statistics of the sample at the fund level:*/
/*Panel B: All funds*/
clear
use data_monthly

duplicates drop FundId YM, force
	/*Calculate time-seires averages per fund*/
by FundId: egen insample=count(YM)
by FundId: egen AUM_avg=mean(AUM/1000000)
by FundId: egen ER_avg=mean(ER)
by FundId: egen ret_gross_avg=mean(ret_gross)
by FundId: egen ret_net_avg=mean(ret_net)
by FundId: egen SR_avg=mean(SR)		
by FundId: egen Team_avg=min(Team)

drop AUM ER ret_gross ret_net SR Team
rename AUM_avg AUM
rename ER_avg ER
rename ret_gross_avg ret_gross
rename ret_net_avg ret_net
rename SR_avg SR
rename Team_avg Team_managed
rename cat_fi Fixed_income
rename cat_eq Equity
rename cat_all Allocation
rename cat_rest Rest


	/*Summary stats from the table*/
duplicates drop FundId, force	

outreg2 using Table4_PanelB.doc, replace sum(detail) ///
	keep(insample AUM ER ret_gross ret_net SR Team_managed Fixed_income Equity Allocation Rest) ///
	sortvar(insample AUM ER ret_gross ret_net SR Team_managed Fixed_income Equity Allocation Rest) ///
	eqkeep(N mean sd p10 p25 p50 p75 p90) word dec(2)