clear

set more off
use data_funds2017

/**************************************************************************/
/*Table 3: Fund population at the end of 2017*/

putexcel set Table3, replace
putexcel B1="N"
putexcel C1="Mean"
putexcel D1="SD"
putexcel E1="p10"
putexcel F1="p25"
putexcel G1="p50"
putexcel H1="p75"
putexcel I1="p90"

/*Panel A*/
putexcel A3="Panel A: All funds"
	/*AUM*/
putexcel A4="AUM (mio. EUR)"
su AUM, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B4=matrix(summary), nformat(0.00)
	/*Return*/
putexcel A5="Return in 2017 (%)"
su Ret, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B5=matrix(summary), nformat(0.00)
	/*MS Rating*/
putexcel A6="MS rating (1 to 5)"
su MSRating, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B6=matrix(summary), nformat(0.00)

/*Panel B*/
putexcel A8="Panel B: Sample funds"
	/*AUM*/
putexcel A9="AUM (mio. EUR)"
su AUM if Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B9=matrix(summary), nformat(0.00)
	/*Return*/
putexcel A10="Return in 2017 (%)"
su Ret if Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B10=matrix(summary), nformat(0.00)
	/*MS Rating*/
putexcel A11="MS rating (1 to 5)"
su MSRating if Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B11=matrix(summary), nformat(0.00)

/*Panel C*/
putexcel A13="Panel C: All single-managed funds"
	/*AUM*/
putexcel A14="AUM (mio. EUR)"
su AUM if Team==0, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B14=matrix(summary), nformat(0.00)
	/*Return*/
putexcel A15="Return in 2017 (%)"
su Ret if Team==0, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B15=matrix(summary), nformat(0.00)
	/*MS Rating*/
putexcel A16="MS rating (1 to 5)"
su MSRating if Team==0, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B16=matrix(summary), nformat(0.00)
	/*Tenure*/
putexcel A17="Tenure (years)"
su Tenure if Team==0, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B17=matrix(summary), nformat(0.00)

/*Panel D*/
putexcel A19="Panel D: Sample single-managed funds"
	/*AUM*/
putexcel A20="AUM (mio. EUR)"
su AUM if Team==0 & Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B20=matrix(summary), nformat(0.00)
	/*Return*/
putexcel A21="Return in 2017 (%)"
su Ret if Team==0 & Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B21=matrix(summary), nformat(0.00)
	/*MS Rating*/
putexcel A22="MS rating (1 to 5)"
su MSRating if Team==0 & Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B22=matrix(summary), nformat(0.00)
	/*Tenure*/
putexcel A23="Tenure (years)"
su Tenure if Team==0 & Sample==1, de
matrix input summary=(`r(N)',`r(mean)',`r(sd)',`r(p10)',`r(p25)',`r(p50)',`r(p75)',`r(p90)')
putexcel B23=matrix(summary), nformat(0.00)

/*Panel E*/
tab Category, g(cat)
putexcel A25="Panel E: Category distribution (%)"
putexcel B26="All"
putexcel C26="Sample"
putexcel D26="All (single)"
putexcel E26="Sample (single)"
	/*Fixed Income*/
putexcel A27="Fixed Income"
su cat3
putexcel B27=`r(mean)'*100, nformat(0.0)
su cat3 if Sample==1
putexcel C27=`r(mean)'*100, nformat(0.0)
su cat3 if Team==0
putexcel D27=`r(mean)'*100, nformat(0.0)
su cat3 if Team==0 & Sample==1
putexcel E27=`r(mean)'*100, nformat(0.0)
	/*Equity*/
putexcel A28="Equity"
su cat2
putexcel B28=`r(mean)'*100, nformat(0.0)
su cat2 if Sample==1
putexcel C28=`r(mean)'*100, nformat(0.0)
su cat2 if Team==0
putexcel D28=`r(mean)'*100, nformat(0.0)
su cat2 if Team==0 & Sample==1
putexcel E28=`r(mean)'*100, nformat(0.0)
	/*Allocation*/
putexcel A29="Allocation"
su cat1
putexcel B29=`r(mean)'*100, nformat(0.0)
su cat1 if Sample==1
putexcel C29=`r(mean)'*100, nformat(0.0)
su cat1 if Team==0
putexcel D29=`r(mean)'*100, nformat(0.0)
su cat1 if Team==0 & Sample==1
putexcel E29=`r(mean)'*100, nformat(0.0)
	/*Other*/
putexcel A30="Other"
su cat4
putexcel B30=`r(mean)'*100, nformat(0.0)
su cat4 if Sample==1
putexcel C30=`r(mean)'*100, nformat(0.0)
su cat4 if Team==0
putexcel D30=`r(mean)'*100, nformat(0.0)
su cat4 if Team==0 & Sample==1
putexcel E30=`r(mean)'*100, nformat(0.0)

putexcel save