clear
set more off

use data_experimental

/******************************************************************************/
/*Table 2: Summary statistics of scores in the experimental tasks*/
outreg2 using Table2.doc, replace sum(detail) ///
	keep(crt_raw apm_raw tom_raw risk loss ambiguity competitive_raw) ///
	sortvar(crt_raw apm_raw tom_raw risk loss ambiguity competitive_raw) ///
	eqkeep(mean sd min max) word dec(2)


/******************************************************************************/
/*Table S1: Pearson correlation coefcients between the experimental variables*/
pwcorr crt_raw apm_raw tom_raw risk loss ambiguity competitive_raw, sig
	/*Export the results*/
matrix define mat_corr=r(C)
matrix define mat_sig=r(sig)
putexcel set TableS1, replace
putexcel A1="Correlation coefficient"
putexcel A2="(1) CRT"
putexcel A3="(2) APM"
putexcel A4="(3) TOM"
putexcel A5="(4) Risk Tolerance"
putexcel A6="(5) Loss Tolerance"
putexcel A7="(6) Ambiguity Tolerance"
putexcel A8="(7) Competitiveness"
putexcel B1="(1)"
putexcel C1="(2)"
putexcel D1="(3)"
putexcel E1="(4)"
putexcel F1="(5)"
putexcel G1="(6)"
putexcel H1="(7)"
putexcel B2=matrix(mat_corr), nformat(0.00)

putexcel A11="p-value"
putexcel A12="(1) CRT"
putexcel A13="(2) APM"
putexcel A14="(3) TOM"
putexcel A15="(4) Risk Tolerance"
putexcel A16="(5) Loss Tolerance"
putexcel A17="(6) Ambiguity Tolerance"
putexcel A18="(7) Competitiveness"
putexcel B11="(1)"
putexcel C11="(2)"
putexcel D11="(3)"
putexcel E11="(4)"
putexcel F11="(5)"
putexcel G11="(6)"
putexcel H11="(7)"
putexcel B12=matrix(mat_sig), nformat(0.00)

putexcel save


/******************************************************************************/
/*Figure S3: Histograms of the eight tasks on cognitive skills, 
economic preferences, and attitudes towards competitiveness*/

	/*CRT*/
hist crt_raw, freq discrete
graph export "FigureS3_CRT.png", as(png) replace

	/*APM*/
hist apm_raw, freq discrete xlabel(0(2)18)
graph export "FigureS3_APM.png", as(png) replace

	/*TOM*/
hist tom_raw, freq discrete xlabel(0(2)18) ylabel(0(4)16)
graph export "FigureS3_TOM.png", as(png) replace

	/*Risk*/
hist risk, freq discrete xlabel(2(12)62) ylabel(0(15)60)
graph export "FigureS3_Risk.png", as(png) replace

	/*Loss*/
hist loss, freq discrete xlabel(0.75(4.5)23.25) ylabel(0(10)40)
graph export "FigureS3_Loss.png", as(png) replace

	/*Ambiguity*/
hist ambiguity, freq discrete xlabel(4(18)94) ylabel(0(10)40)
graph export "FigureS3_Ambiguity.png", as(png) replace

	/*Patience*/
hist patience, freq discrete xlabel(-22.25(4.5)0.25) ylabel(0(10)40)
graph export "FigureS3_Patience.png", as(png) replace

	/*Competitiveness*/
hist competitive_raw, freq discrete xlabel(5(5)35) ylabel(0(3)12)
graph export "FigureS3_Competitiveness.png", as(png) replace