####Script to reproduce plots from Suplementary material####
#Only plots of predictor variables are reproduced in this script 
#For PCoA and RDA plots, see specific scripts

# Prepared by Fabiana Schneck (fabiana.schneck@gmail.com) in March/2021
# Revised by FS in October/2021
#===============================================================================.

#loading required packages
library(ggplot2)
library(cowplot)
library(beanplot)
library(GGally) #function ggcorr

#loading data from scripts 1 and 2
source("script_1-Regression_models_Diatoms.R")
source("script_2-Regression_models_Insects.R")

My_Theme <- theme(
  axis.title.x = element_text(size = 16,colour="black"),
  axis.text.x = element_text(size = 14,colour="black"),
  axis.title.y = element_text(size = 16,colour="black"),
  axis.text.y = element_text(size = 14,colour="black"),
  legend.text = element_text(size = 14,colour="black"),
  legend.title = element_text(size = 14,colour="black"))


####Figure S1 - Forest cover####
#Diatoms
plot.forest.d<-ggplot(data=beta.diat[,c(4,5,10)],aes(x=Lon, y=Lat,size=Forest)) +
  geom_point( alpha=0.6,shape=21,fill="darkgreen")+
  scale_size_continuous(range = c(2, 7))+
  coord_fixed(ratio = 1, ylim=c(-24.5,-23.75))+
  theme_bw()+
  My_Theme+
  xlab("")+
  ylab("Latitude")+
  theme(axis.text.x=element_blank())+
  theme(legend.position = "none")


#Insects
plot.forest.i<-ggplot(data=beta.inv[,c(4,5,10)],aes(x=Lon, y=Lat,size=Forest)) +
  geom_point( alpha=0.6,shape=21,fill="darkgreen")+
  scale_size_continuous(range = c(2, 7))+
  coord_fixed(ratio = 1, ylim=c(-24.5,-23.75))+
  theme_bw()+
  My_Theme+
  xlab("Longitude")+
  ylab("Latitude")+
  theme(legend.position = "none")


png("ESM_Fig1S_Forest_NOVA.png",
    height = 30, width =25,units="cm",res=600)
plot_grid(plot.forest.d,plot.forest.i,nrow=2,labels = c("(a)","(b)"),label_size=14,
          label_fontface="plain",hjust=-2,vjust=c(2.5,2)) 
dev.off()


####Figure S2 - Beanplot of land uses####
land.mod<-land[,7:16]
colnames(land.mod)<-c("Agriculture","Bare\nsoil","Forest","Mining","Mixed",
                      "Pasture","Planted\nforest","Secondary\nforest","Urban","Water")



png("ESM_FigS2_NOVA.png",height = 20, width = 20, units = 'cm',res=600)
par(mfrow = c(3,1),mar=c(4,5,1,1),oma=c(1,5,1,1))
#All 100 streams
beanplot(land.mod*100,las=1,bw="nrd0",what=c(0,1,1,1),beanlinewd=2,
         border=NA,method="overplot",ll = 0.1,xaxt="n",ylab="Percentage of cover (%)",
         cex.lab=1.5,cex.axis=1.2,
         col=list(c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#35B779FF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black")))
axis(1,at=1:10,labels=FALSE)

#Only streams used for diatoms 
beanplot(land.mod[-excluir.sites.diat,]*100,las=1,bw="nrd0",what=c(0,1,1,1),beanlinewd=2,
         border=NA,method="overplot",ll = 0.1,xaxt="n",ylab="Percentage of cover (%)",
         cex.lab=1.5,cex.axis=1.2,
         col=list(c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#35B779FF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black")))
axis(1,at=1:10,labels=FALSE)

#Only streams used for insects
beanplot(land.mod[-excluir.sites.inv,]*100,las=1,bw="nrd0",what=c(0,1,1,1),beanlinewd=2,
         border=NA,method="overplot",ll = 0.1,xlab="Land use and cover",ylab="Percentage of cover (%)",
         cex.lab=1.5,cex.axis=1.2,
         col=list(c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#35B779FF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black"),
                  c("#D2E21BFF","black","black","black")))

dev.off()


####Figure S3####
##correlation between forest and all other land-uses (for all 100 streams and for streams used for diatoms/insects)####
correl.forest100<-ggcorr(land.mod, label = T, label_round = 2,hjust = 1,label_size = 3,
                         layout.exp =2,legend.position = "n")

correl.forest.d<-ggcorr(land.mod[-excluir.sites.diat,], 
                        name = "Pearson\n correlation",label_size = 3,
                        label = T, label_round = 2,hjust = 1, layout.exp = 2, legend.size = 10)

correl.forest.i<-ggcorr(land.mod[-excluir.sites.inv,], label_size = 3,
                        label = T, label_round = 2,hjust = 1, layout.exp = 2,legend.position = "n")

png("ESM_FigS3.png",height = 30, width = 15, units = 'cm',res=600)
plot_grid(correl.forest100,correl.forest.d,correl.forest.i,
          nrow=3,align="v", axis="lr",labels=c("(a)","(b)","(c)"), label_fontface = "plain",hjust=-1)
dev.off()




####Figure S4####
##correlations between predictors###
##generated here, but rearranged in an image editor

#Figure 4a
ggcorr(beta.diat[,6:10],
       name = "Pearson\n correlation",
       label = T, label_round = 2,
       label_size = 5, legend.size = 12)

ggcorr(beta.inv[,6:10],
       name = "Pearson\n correlation",
       label = T, label_round = 2,
       label_size = 5, legend.size = 12)



#Figure 4b (last row of each plot)
ggcorr(cbind(beta.diat$LCEH_phy,land.diat),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)

ggcorr(cbind(beta.diat$LCEH_wc,land.diat),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)

ggcorr(cbind(beta.diat$LCEH_lu,land.diat),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)


ggcorr(cbind(beta.inv$LCEH_phy,land.inv),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9, label_size = 4)

ggcorr(cbind(beta.inv$LCEH_wc,land.inv),
       label = T, label_round = 2, layout.exp = 2,hjust=0.9,label_size = 4)

ggcorr(cbind(beta.inv$LCEH_lu,land.inv),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)


#Figure 4c (last row of each plot)
ggcorr(cbind(beta.diat$LCEH_phy,env[-excluir.sites.diat,1:10]),
       label = T,  label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)

ggcorr(cbind(beta.inv$LCEH_phy,env[-excluir.sites.inv,1:10]),
       label = T, label_round = 2,layout.exp = 2,hjust=0.9,label_size = 4)
