####Script to reproduce PCoA plots of traits and taxonomic relatedness of diatoms and insects####

# Prepared by Fabiana Schneck (fabiana.schneck@gmail.com) in March/2021
# Revised by FS in October/2021
#===============================================================================.

#loading required packages
library(vegan)
library(ggplot2)
library(ggrepel)
library(viridis)
library(cowplot) 


#loading data from scripts 1 and 2
source("script_1-Regression_models_Diatoms.R")
source("script_2-Regression_models_Insects.R")

My_Theme <- theme(
  axis.title.x = element_text(size = 14,colour="black"),
  axis.text.x = element_text(size = 12,colour="black"),
  axis.title.y = element_text(size = 14,colour="black"),
  axis.text.y = element_text(size = 12,colour="black"),
  legend.text = element_text(size = 14,colour="black"),
  legend.title = element_text(size = 14,colour="black"))



####Figure S5 - PCoA of diatom traits####

#Extracting centroids for categorical traits and arrows for continuous traits
efit.tr.diat<-envfit(pcoa.traits.diat,traits.diat)
efit.tr1.diat<-data.frame(rbind(efit.tr.diat$factors$centroids,efit.tr.diat$vectors$arrows))
efit.tr1.diat$categ<-c(rep("Size class",5),rep("Functional group",4),
                       rep("Life form",2),rep("Attachment mode",4),"Length/width\n(continuous trait)")

row.names(efit.tr1.diat)<-c("1","2","3","4","5",
                            "High-profile","Low-profile","Motile","Planktonic",
                            "Colonial","NonColonial",
                            "Prostrate","TubeForming","Unattached","Vertical",
                            "Length/width")


#Just checking the data sets
efit.tr1.diat
cbind(rownames(data.frame(rbind(efit.tr.diat$factors$centroids,efit.tr.diat$vectors$arrows))),rownames(efit.tr1.diat))


g.pcoa.tr.diat<-ggplot(efit.tr1.diat) +
  geom_text_repel(aes(x=MDS1,y=MDS2,colour= factor(categ)),label=row.names(efit.tr1.diat),
                  size=4,fontface="bold",key_glyph=draw_key_point,seed=1)+ 
  geom_point(aes(x=MDS1,y=MDS2,colour= factor(categ)))+
  scale_colour_viridis(end=0.9,discrete=TRUE,name="Trait")+
  geom_vline(xintercept = 0, linetype = 'dotted',alpha=0.4)+
  geom_hline(yintercept = 0, linetype = 'dotted',alpha=0.4)+
  coord_fixed(ratio = 1)+
  xlab("Axis 1 (37%)")+ylab("Axis 2 (16%)")+
  theme_bw()+      
  theme(panel.grid=element_blank())+
  My_Theme+
  theme(legend.position = "bottom")+
  guides(col = guide_legend(nrow = 3))

ggsave("FigS5_PcoaDiat.png",g.pcoa.tr.diat,height=20,width=15,units="cm",dpi=600)



####Figure S6a - PCoA of insect traits####

#Extracting centroids for categorical traits 
efit.tr.inv <- envfit(pcoa.traits.inv,traits.inv)
efit.tr1.inv<-data.frame(efit.tr.inv$factors$centroids)
efit.tr1.inv$categ<-c(rep("Refuge",4),rep("Body shape",2),rep("Locomotion",5),
                  rep("Feeding guild",5),rep("Respiration",3),rep("Body size",3))

row.names(efit.tr1.inv)<-c("FixNet","NoRef","SheltLeaf","SheltSDW",
                       "Hydrod","NoHydrod",
                       "Burrower","ClimberCrawler","Clinger","Sprawler","Swimmer",
                       "CollecFil","CollecGat","Herbivore","Predator","Shredder",
                       "Air","Gill","Tegum","Small","Medium","Large")      

#Just checking the data sets
efit.tr1.inv
cbind(rownames(data.frame(efit.tr.inv$factors$centroids)),rownames(efit.tr1))


g.pcoa.tr.inv<-ggplot(efit.tr1) +
  geom_text_repel(aes(x=MDS1,y=MDS2,colour=factor(categ)),label=row.names(efit.tr1),
                  size=4,fontface="bold",key_glyph=draw_key_point,force_pull=50,seed=1)+ 
  geom_point(aes(x=MDS1,y=MDS2,colour= factor(categ)))+
  scale_colour_viridis(end=0.90,discrete=TRUE,name="Trait")+
  geom_vline(xintercept = 0, linetype = 'dotted',alpha=0.4)+
  geom_hline(yintercept = 0, linetype = 'dotted',alpha=0.4)+
  coord_fixed(ratio = 1)+
  xlab("Axis 1 (31%)")+ylab("Axis 2 (17%)")+
  theme_bw()+      
  theme(panel.grid=element_blank())+
  My_Theme+
  theme(legend.position = "bottom")+
  guides(col = guide_legend(nrow = 2))



####Figure S6b - PCoA of insects taxonomic relatedness####
efit.tax.inv <- envfit(pcoa.taxo.inv,taxo.inv)

#Extracting centroids for taxonomic levels
efit.tax1.inv<-data.frame(efit.tax.inv$factors$centroids)

#I want to plot only the Order level
efit.order<-efit.tax1.inv[101:106, ]
row.names(efit.order)<-c("Coleoptera",
                         "Ephemeroptera",
                         "Megaloptera",
                         "Odonata",
                         "Plecoptera",
                         "Trichoptera")


g.pcoa.taxo.inv<-ggplot(efit.order) +
  geom_text_repel(aes(x=MDS1,y=MDS2),label=row.names(efit.order),
                  size=4,fontface="bold",color="steelblue",direction="both",force_pull=100,seed=1)+ 
  geom_point(aes(x=MDS1,y=MDS2),color="steelblue")+
  geom_vline(xintercept = 0, linetype = 'dotted',alpha=0.4)+
  geom_hline(yintercept = 0, linetype = 'dotted',alpha=0.4)+
  coord_fixed(ratio = 1)+
  xlab("Axis 1 (14%)")+ylab("Axis 2 (10%)")+
  theme_bw()+      
  theme(panel.grid=element_blank())+
  My_Theme+
  theme(legend.position = "none")

png("FigS6_PcoasInsect.png",
    height=30, width=15,units="cm",res=600)
plot_grid(g.pcoa.tr.inv,g.pcoa.taxo.inv,nrow=2,ncol=1,align="hv",axis="rl",rel_heights=c(1.2,1),
          labels=c("(a)","(b)"),label_size=14,label_fontface="plain",hjust=-1.5,vjust=c(4.5,2)) 
dev.off()



