####Script for preparing figures from results based on LCBD and SCBD####

# Prepared by Fabiana Schneck (fabiana.schneck@gmail.com) in March/2021
# Revised by FS in October/2021
#===============================================================================.

#loading required packages
library(ggplot2)
library(cowplot) #plot_grid
library(modelsummary) #modelplot

#loading data from scripts 1 and 2
source("script_1-Regression_models_Diatoms.R")
source("script_2-Regression_models_Insects.R")



My_Theme <- theme(
  axis.title.x = element_text(size = 20,colour="black"),
  axis.text.x = element_text(size = 18,colour="black"),
  axis.title.y = element_text(size = 20,colour="black"),
  axis.text.y = element_text(size = 18,colour="black"),
  legend.text = element_text(size = 12,colour="black"),
  legend.title = element_text(size = 12,colour="black"))



####Figure 2 - LCBD maps ####
#Diatoms
g1.d<-ggplot(data=beta.diat,aes(x=Lon, y=Lat, size = LCBD)) +
  geom_point( alpha=0.6,shape=21,fill="orange")+
  scale_size_continuous(limits=c(0.004727045,0.026626579),range = c(0.5, 10))+
  coord_fixed(ratio = 1, ylim=c(-24.5,-23.75))+
  theme_bw()+
  My_Theme+
  xlab("")+
  ylab("Latitude")+
  theme(axis.text.x=element_blank())+
  theme(legend.position = "none")

  
g2.d<-ggplot(data=as.data.frame(correlog.diat),aes(x=dist.class, y=coef)) +
  geom_point(size=5,color="orange")+geom_line(linetype="dashed")+
  scale_x_continuous(breaks=seq(0.1,1.5,0.2))+
  theme_bw()+
  My_Theme+
  xlab("")+
  ylab("Moran's I")+
  theme(axis.text.x=element_blank())+
  theme(panel.grid=element_blank())
  

#Insects
g1.i<-ggplot(data=beta.inv,aes(x=Lon, y=Lat, size = LCBD)) +
  geom_point(alpha=0.6,shape=21,fill="steelblue")+
  scale_size_continuous(limits=c(0.004727045,0.026626579),range = c(0.5, 10))+
  coord_fixed(ratio = 1, ylim=c(-24.5,-23.75))+
  theme_bw()+
  My_Theme+
  xlab("Longitude")+
  ylab("Latitude")+
  theme(legend.position = "none")
 

g2.i<-ggplot(data=as.data.frame(correlog.inv),aes(x=dist.class, y=coef)) +
  geom_point(size=5,color="steelblue")+geom_line(linetype="dashed")+
  scale_x_continuous(breaks=seq(0.1,1.5,0.2))+
  theme_bw()+
  My_Theme+
  xlab("Distance classes\n(decimal degrees)")+
  ylab("Moran's I")+
  theme(panel.grid=element_blank())


png("Fig2_LCBD.png",
    height = 22, width =44,units="cm",res=600)
plot_grid(g1.d,g2.d,g1.i,g2.i,nrow=2,ncol=2,labels = "auto",label_size=14,label_x=0.1,
          align="h",axis="b",rel_widths = c(2, 1)) 
dev.off()



####Figure 3 - LCBD correlations####
#Diatoms-richness
g3.d<-ggplot(data=beta.diat, aes(x=S, y=LCBD))+
  geom_point(colour = "orange", alpha=0.7,shape=16,size = 5)+
  scale_x_continuous(limits=c(2,40))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("")+
  theme(axis.text.x=element_blank())
 

#Diatoms-dominance
g4.d<-ggplot(data=beta.diat, aes(x=Domi, y=LCBD))+
  geom_point(color = "orange", alpha=0.7,shape=16,size = 5)+
  scale_x_continuous(limits=c(0.05,0.75))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("")+
  ylab("")+
  theme(axis.text.y=element_blank())+
  theme(axis.text.x=element_blank())
  

#Insects-richness
g3.i<-ggplot(data=beta.inv, aes(x=S, y=LCBD))+
  geom_point(colour =  "steelblue", alpha=0.7,shape=16,size = 5)+
  scale_x_continuous(limits=c(2,40))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("Taxa richness")#+
  

#Insects-dominance
g4.i<-ggplot(data=beta.inv, aes(x=Domi, y=LCBD))+
  geom_point(colour =  "steelblue", alpha=0.7,shape=16,size = 5)+
  scale_x_continuous(limits=c(0.05,0.75))+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("Simpson dominance index")+
  ylab("")+
  theme(axis.text.y=element_blank())


png("Fig3_LCBDcorrels.png",
    height = 25, width =25,units="cm",res=600)
plot_grid(g3.d, g4.d,g3.i,g4.i,nrow=2,ncol=2,labels="auto",label_size=12,label_x=0.1,align="hv")
dev.off()



####Figure 4 - Model coefficient plots####
#LCBD
modelsLCBD <- list() 
modelsLCBD[['LCBD diat']] <- LCBD.diat.model
modelsLCBD[['LCBD inv']] <- LCBD.inv.model

expla.LCBD <- c('scale(asin(sqrt(LCEH_phy)))'='LCEH_Phy',
                'scale(asin(sqrt(LCEH_wc)))'='LCEH_WC',
                'scale(asin(sqrt(Forest)))'='Forest cover',
                'scale(asin(sqrt(LCEH_lu)))'='LCEH_LU')

coeff.LCBD<-modelplot(modelsLCBD,coef_map=expla.LCBD,fatten = 4,size=1)+
  geom_vline(xintercept = 0, linetype = 'dashed')+
  labs(y = 'Predictor variables',x="Coefficient estimates (95% CI)")+
  scale_y_discrete(labels=c("LCEH_LU"=expression(LCEH[LU]),
                            "LCEH_WC"=expression(LCEH[WC]),
                            "LCEH_Phy"=expression(LCEH[Phy])))+
  scale_color_manual(values=c("orange","steelblue"))+
  scale_x_continuous(limits = c(-0.2,0.2))+
  annotate("text",x=-0.16,y=1.5,label="Diatoms~R[pseudo]^2==0.17",parse=T,color="darkorange",hjust=0.5,size=6)+
  annotate("text" ,x=-0.2,y=1.5, label="Insects~R[pseudo]^2==0.27",parse=T,color="steelblue",hjust=0.5,size=6)+
  annotate("text" ,x=0.2,y=2.5, label="LCBD",color="black",size=7)+
  theme_bw()+   
  theme(panel.grid=element_blank())+
  theme(legend.position = "none")+
  coord_flip()+
  My_Theme
  

#SCBD
modelsSCBD <- list() 
modelsSCBD[['SCBD diat']] <- SCBD.diat.model
modelsSCBD[['SCBD inv']] <- SCBD.inv.model

expla.SCBD <- c('scale(Ax1traits)' = 'Ax1\nTraits',
                'scale(Ax2traits)' = 'Ax2\nTraits',
                'scale(Ax1taxo)' = 'Ax1\nTaxo',
                'scale(Ax2taxo)' = 'Ax2\nTaxo')

coeff.SCBD<-modelplot(modelsSCBD,coef_map=expla.SCBD, fatten = 3,size=1)+
  geom_vline(xintercept = 0, color = 'black',linetype = 'dashed')+
  labs(y = 'Predictor variables',x="Coefficient estimates (95% CI)")+
  scale_color_manual(values=c("orange","steelblue"))+
  scale_x_continuous(limits = c(-0.6,0.6))+
  annotate("text",x=-0.46,y=1.5,label="Diatoms~R[pseudo]^2==0.04",parse=T,color="darkorange",hjust=0.5,size=6)+
  annotate("text" ,x=-0.57,y=1.5, label="Insects~R[pseudo]^2==0.20",parse=T,color="steelblue",hjust=0.5,size=6)+
  annotate("text" ,x=0.6,y=2.5, label="SCBD",color="black",size=7)+
  theme_bw()+   
  theme(panel.grid=element_blank())+
  theme(legend.position = "none")+
  coord_flip()+
  My_Theme

png("Fig4_model_coeff.png",
    height = 15, width =30,units="cm",res=600)
plot_grid(coeff.LCBD,coeff.SCBD,nrow=1,ncol=2,align="hv",axis="b") 
dev.off()


####Figure 5 ####
#SCBD rank - diatoms
SCBD.diat.ordem<-SCBD.diat[order(SCBD.diat$SCBD,decreasing=T),]

g5.d<-ggplot(data=SCBD.diat.ordem, aes(x=1:356,y=SCBD))+
  geom_point(alpha=0.6,shape=21,size = 3,fill="orange")+
  geom_hline(yintercept=mean(SCBD.diat$SCBD), linetype="dashed", color = "black")+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("Species rank")+
  annotate("text", x = 290, y = 0.005, label = "Mean = 0.0028")


#SCBD rank - insects
SCBD.inv.ordem<-SCBD.inv[order(SCBD.inv$SCBD,decreasing=T),]

g5.i<-ggplot(data=SCBD.inv.ordem, aes(x=1:83,y=SCBD))+
  geom_point( alpha=0.6,shape=21,size=3,fill="steelblue")+
  geom_hline(yintercept=mean(SCBD.inv$SCBD), linetype="dashed", color = "black")+
  theme_bw()+
  theme(panel.grid=element_blank())+
  My_Theme+
  xlab("Genus rank")+
  annotate("text", x = 70, y = 0.014, label = "Mean = 0.012")


#SCBD correlations - diatoms
g6.d<-ggplot(data=SCBD.diat,aes(x=Abund, y=SCBD))+
  geom_point(colour = "orange", alpha=0.7,shape=16,size = 5)+
  theme_bw()+
  My_Theme+
  theme(panel.grid=element_blank())+
  theme(axis.text.y=element_blank())+
  xlab("Species abundance")+
  ylab("")

g7.d<-ggplot(data=SCBD.diat,aes(x=Occurrence, y=SCBD))+
  geom_point(colour = "orange", alpha=0.7,shape=16,size = 5)+
  theme_bw()+
  My_Theme+
  theme(panel.grid=element_blank())+
  theme(axis.text.y=element_blank())+
  xlab("Sites occupied")+
  ylab("")

#SCBD correlations - insects
g6.i<-ggplot(data=SCBD.inv,aes(x=Abund, y=SCBD))+
  geom_point(colour = "steelblue", alpha=0.7,shape=16,size = 5)+
  theme_bw()+
  My_Theme+
  theme(panel.grid=element_blank())+
  theme(axis.text.y=element_blank())+
  xlab("Genus abundance")+
  ylab("")

g7.i<-ggplot(data=SCBD.inv,aes(x=Occurrence, y=SCBD))+
  geom_point(colour = "steelblue", alpha=0.7,shape=16,size = 5)+
  theme_bw()+
  My_Theme+
  theme(panel.grid=element_blank())+
  theme(axis.text.y=element_blank())+
  xlab("Sites occupied")+
  ylab("")


png("Fig5_SCBD.png",
    height = 20, width =30,units="cm",res=600)
plot_grid(g5.d,g6.d,g7.d,g5.i,g6.i,g7.i,nrow=2,ncol=3,labels="auto",label_size=14,label_x=0.08,align="hv")
dev.off()

