import i18n from "i18next";
import { initReactI18next } from "react-i18next";

// the translations
// (tip move them in a JSON file and import them)
const resources = {
  en: {
    translation: {
      // routes
      "Dashboard": "Dashboard",
      "Space Data": "Space",
      "Equipment Data": "Equipment",
      "Meter Data": "Meter",
      "Tenant Data": "Tenant",
      "Store Data": "Store",
      "Shopfloor Data": "Shopfloor",
      "Combined Equipment Data": "Combined Equipment",
      "Auxiliary System": "Auxiliary System",
      "Fault Detection & Diagnostics": "FDD",
      "Monitoring": "Monitoring",
      "Advanced Reporting": "Advanced Reporting",
      "Knowledge Base": "Knowledge Base",
      "Energy Category Data": "Energy Category",
      "Energy Item Data": "Energy Item",
      "Cost": "Cost",
      "Output": "Output",
      "Income": "Income",
      "Efficiency": "Efficiency",
      "Load": "Load",
      "Statistics": "Statistics",
      "Batch Analysis": "Batch Analysis",
      "Saving": "Saving",
      "Equipment Tracking": "Equipment Tracking",
      "Meter Energy": "Meter Energy",
      "Meter Cost": "Meter Cost",
      "Meter Trend": "Meter Trend",
      "Meter Realtime": "Meter Realtime",
      "Master Meter Submeters Balance": "Master Meter Submeters Balance",
      "Virtual Meter Energy": "Virtual Meter Energy",
      "Virtual Meter Cost": "Virtual Meter Cost",
      "Offline Meter Energy": "Offline Meter Energy",
      "Offline Meter Cost": "Offline Meter Cost",
      "Meter Tracking": "Meter Tracking",
      "Tenant Bill": "Tenant Bill",
      "Energy Flow Diagram": "Energy Flow Diagram",
      "Distribution System":"Distribution System",
      "Fault Statistics": "Fault Statistics",
      "Space Faults Data": "Space Faults",
      "Equipment Faults Data": "Equipment Faults",
      "Combined Equipment Faults Data": "Combined Eequipment Faults",
      "Tenant Faults Data": "Tenant Faults",
      "Store Faults Data": "Store Faults",
      "Shopfloor Faults Data": "Shopfloor Faults Data",
      "Space Equipments": "Space Equipments",
      "Combined Equipments": "Combined Equipments",
      "Tenant Equipments": "Tenant Equipments",
      "Store Equipments": "Store Equipments",
      "Shopfloor Equipments": "Shopfloor Equipments",
      // Dashboard
      "Welcome to MyEMS": "Welcome to MyEMS",
      "An Industry Leading Open Source Energy Management System": "An Industry Leading Open Source Energy Management System",
      "This Year's Consumption CATEGORY VALUE UNIT": "This Year's Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "This Year's Costs CATEGORY VALUE UNIT": "This Year's Costs {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Consumption CATEGORY VALUE UNIT": "Last Year's Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Costs CATEGORY VALUE UNIT": "Last Year's Costs {{CATEGORY}} {{VALUE}} {{UNIT}}",
      // Entities
      "Space": "Space",
      "Equipment": "Equipment",
      "Meter": "Meter",
      "Offline Meter": "Offline Meter",
      "Virtual Meter": "Virtual Meter",
      "Tenant": "Tenant",
      "Store": "Store",
      "Shopfloor": "Shopfloor",
      "Combined Equipment": "Combined Equipment",
      "Cost Center": "Cost Center",
      "Name": "Name",
      "Description": "Description",
      "Energy Category": "Energy Category",
      "Child Spaces": "Child Spaces",
      "Associated Equipment": "Associated Equipment",
      //Energy Categories
      "Electricity": "Electricity",
      "Water": "Water",
      "Natural Gas": "Natural Gas",
      // SidePanelModal
      "Settings": "Settings",
      "Set your own customized style": "Set your own customized style",
      "Color Scheme": "Color Scheme",
      "Choose the perfect color mode for your app": "Choose the perfect color mode for your app",
      "Light": "Light",
      "Dark": "Dark",
      "RTL Mode": "RTL Mode",
      "Switch your language direction": "Switch your language direction",
      "Fluid Layout": "Fluid Layout",
      "Toggle container layout system": "Toggle container layout system",
      "Navigation Position": "Navigation Position",
      "Select a suitable navigation system for your web application": "Select a suitable navigation system for your web application",
      "Vertical Nav": "Vertical Nav",
      "Top Nav": "Top Nav",
      "Vertical Navbar Style": "Vertical Navbar Style",
      "Switch between styles for your vertical navbar": "Switch between styles for your vertical navbar",
      "Language": "Language",
      "Switch between languages": "Switch between languages",
      "language-zh_CN": "简体中文",
      "language-en": "English",
      "language-de": "Deutsch",
      "Like What You See?": "Like What You See?",
      "Get MyEMS now": "Get MyEMS now",
      "Purchase": "Purchase",
      // Query Panel
      "Base Period Begins": "Base Period Begins",
      "Base Period Ends": "Base Period Ends",
      "Comparison Types": "Comparison Types",
      "Year-Over-Year": "Year-Over-Year",
      "Month-On-Month": "Month-On-Month",
      "Free Comparison": "Free Comparison",
      "None Comparison": "None Comparison",
      "Reporting Period Begins": "Reporting Period Begins",
      "Reporting Period Ends": "Reporting Period Ends",
      "(Optional)": "(Optional)",
      "Period Types": "Period Types",
      "Yearly": "Yearly",
      "Monthly": "Monthly",
      "Weekly": "Weekly",
      "Daily": "Daily",
      "Hourly": "Hourly",
      "Submit": "Submit",
      "Input Energy Category": "Input Energy Category",
      "Output Energy Category": "Output Energy Category",
      "Fraction Parameter": "Fraction Parameter",
      "Search": "Search",
      //Card Summaries and Line Charts
      "Base Period": "Base Period",
      "Reporting Period": "Reporting Period",
      "Per Unit Area": "Per Unit Area",
      "Per Unit Production": "Per Unit Production",
      "Baseline Value - Actual Value": "Baseline - Actual",
      "Average Load": "Average Load",
      "Maximum Load": "Maximum Load",
      "Load Factor": "Load Factor",
      "Ratio of Average Load to Maximum Load": "Ratio of Average Load to Maximum Load",
      "Costs by Energy Category": "Costs by Energy Category",
      "Incomes by Energy Category": "Incomes by Energy Category",
      "Electricity Consumption by Time-Of-Use": "Electricity Consumption by Time-Of-Use",
      "Electricity Cost by Time-Of-Use": "Electricity Cost by Time-Of-Use",
      "CATEGORY UNIT Consumption by Energy Items": "{{CATEGORY}} {{UNIT}} Comsumption by Energy Items",
      "Ton of Standard Coal by Energy Category": "Ton of Standard Coal(TCE) by Energy Category",
      "Ton of Carbon Dioxide Emissions by Energy Category": "Ton of Carbon Dioxide Emissions(TCO2E) by Energy Category",
      "Reporting Period Consumption CATEGORY UNIT": "Reporting Period Consumption {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{EQUIPMENT}} Reporting Period Consumption {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} Reporting Period Consumption {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption CATEGORY VALUE UNIT": "Reporting Period Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption CATEGORY VALUE UNIT": "Base Period Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY UNIT": "Reporting Period Consumption {{ITEM}} {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY VALUE UNIT": "Reporting Period Consumption {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption ITEM CATEGORY VALUE UNIT": "Base Period Consumption {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Child Space Proportion CATEGORY UNIT": "Child Space Proportion by Energy Category {{CATEGORY}} {{UNIT}}",
      "Child Space Total Proportion": "Child Space Total Proportion",
      "Reporting Period Costs CATEGORY UNIT": "Reporting Period Costs {{CATEGORY}} {{UNIT}}",
      "Reporting Period Costs CATEGORY VALUE UNIT": "Reporting Period Costs {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Costs CATEGORY VALUE UNIT": "Base Period Costs {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Output CATEGORY UNIT": "Reporting Period Output {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{EQUIPMENT}} Reporting Period Output {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} Reporting Period Output {{CATEGORY}} {{UNIT}}",
      "Reporting Period Output CATEGORY VALUE UNIT": "Reporting Period Output {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Output CATEGORY VALUE UNIT": "Base Period Output {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Income CATEGORY UNIT": "Reporting Period Income {{CATEGORY}} {{UNIT}}",
      "Reporting Period Income CATEGORY VALUE UNIT": "Reporting Period Income {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Income CATEGORY VALUE UNIT": "Base Period Income {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Total Income UNIT": "Reporting Period Total Income {{UNIT}}",
      "Reporting Period Cumulative Efficiency NAME UNIT": "Reporting Period Cumulative Efficiency {{NAME}} {{UNIT}}",
      "EQUIPMENT Reporting Period Cumulative Efficiency UNIT": "{{EQUIPMENT}} Reporting Period Cumulative Efficiency {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} Reporting Period Cumulative Comprehensive Efficiency {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} Reporting Period Cumulative Comprehensive Efficiency {{VALUE}} {{UNIT}}",
      "COMBINED_EQUIPMENT Base Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} Base Period Cumulative Comprehensive Efficiency {{VALUE}} {{UNIT}}",
      "Instantaneous Efficiency UNIT": "Instantaneous Efficiency {{UNIT}}",
      "EQUIPMENT Instantaneous Efficiency UNIT": "{{EQUIPMENT}} Instantaneous Efficiency {{UNIT}}",
      "COMBINED_EQUIPMENT Instantaneous Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} Instantaneous Comprehensive Efficiency {{UNIT}}",
      "Reporting Period Cumulative Efficiency VALUE UNIT": "Reporting Period Cumulative Efficiency {{VALUE}} {{UNIT}}",
      "Base Period Cumulative Efficiency VALUE UNIT": "Base Period Cumulative Efficiency {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Maximum Load UNIT": "Reporting Period {{CATEGORY}} Maximum Load {{UNIT}}",
      "Reporting Period CATEGORY Average Load UNIT": "Reporting Period {{CATEGORY}} Average Load {{UNIT}}",
      "Reporting Period CATEGORY Load Factor": "Reporting Period {{CATEGORY}} Load Factor",
      "Base Period CATEGORY Average Load VALUE UNIT": "Base Period {{CATEGORY}} Average Load {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Average UNIT": "Reporting Period {{CATEGORY}} Average Value {{UNIT}}",
      "Reporting Period CATEGORY Maximum UNIT": "Reporting Period {{CATEGORY}} Maximum Value {{UNIT}}",
      "Reporting Period CATEGORY Minimum UNIT": "Reporting Period {{CATEGORY}} Minimum Value {{UNIT}}",
      "Reporting Period CATEGORY Mean UNIT": "Reporting Period {{CATEGORY}} Arithmetic Mean {{UNIT}}",
      "Reporting Period CATEGORY Median UNIT": "Reporting Period {{CATEGORY}} Median (Middle Value) {{UNIT}}",
      "Reporting Period CATEGORY Stdev UNIT": "Reporting Period {{CATEGORY}} Sample Standard Deviation {{UNIT}}",
      "Reporting Period CATEGORY Variance UNIT": "Reporting Period {{CATEGORY}} Sample Variance {{UNIT}}",
      "Reporting Period Savings CATEGORY (Baseline - Actual) UNIT": "Reporting Period Savings {{CATEGORY}} (Baseline - Actual) {{UNIT}}",
      "Reporting Period Decreased CATEGORY (Baseline - Actual) UNIT": "Reporting Period Decreased {{CATEGORY}} (Baseline - Actual) {{UNIT}}",
      "Reporting Period Savings CATEGORY VALUE UNIT": "Reporting Period Savings {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Savings CATEGORY VALUE UNIT": "Base Period Savings {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY UNIT": "Reporting Period Master Meter Consumption {{CATEGORY}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY VALUE UNIT": "Reporting Period Master Meter Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY UNIT": "Reporting Period Submeters Consumption {{CATEGORY}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY VALUE UNIT": "Reporting Period Submeters Consumption {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Difference CATEGORY UNIT": "Reporting Period Difference {{CATEGORY}} {{UNIT}}",
      "Reporting Period Percentage Difference": "Reporting Period Percentage Difference",
      "Reporting Period Difference CATEGORY VALUE UNIT": "Reporting Period Difference {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Trend Values": "Trend Values",
      //FDD
      "Fault List": "Fault List",
      "Reporting Period Number of Fault VALUE": "Reporting Period Number of Fault {{VALUE}}",
      "All Faults": "All Faults",
      "Space Faults": "Space Faults",
      "Equipment Faults": "Equipment Faults",
      "Tenant Faults": "Tenant Faults",
      "Store Faults": "Store Faults",
      "Shopfloor Faults": "Shopfloor Faults",
      "Combined Equipment Faults": "Combined Equipment Faults",
      "Number of All Faults": "Number of All Faults",
      "Number of Space Faults": "Number of Space Faults",
      "Number of Equipment Faults": "Number of Equipment Faults",
      "Number of Tenant Faults": "Number of Tenant Faults",
      "Number of Store Faults": "Number of Store Faults",
      "Number of Shopfloor Faults": "Number of Shopfloor Faults",
      "Number of Combined Equipment Faults": "Number of Combined Equipment Faults",
      //Data Panels
      "Ton of Standard Coal": "Ton of Standard Coal",
      "Ton of Carbon Dioxide Emissions": "Ton of Carbon Dioxide Emissions",
      "Related Parameters": "Related Parameters",
      "Tariff": "Tariff",
      "Detailed Data": "Detailed Data",
      "Child Spaces Data": "Child Spaces Data",
      "Associated Equipment Data": "Associated Equipment Data",
      "This Year": "This Year",
      "This Month": "This Month",
      "This Day": "This Day",
      "Total": "Total",
      "No data found": "No data found",
      "Export": "Export",
      "Datetime": "Datetime",
      "Time-Of-Use Type": "Time-Of-Use Type",
      "Top-Peak": "Top-Peak",
      "On-Peak": "On-Peak",
      "Mid-Peak": "Mid-Peak",
      "Off-Peak": "Off-Peak",
      "Percentage": "Percentage",
      //Realtime Chart
      "Trend in the last hour of Energy Value Point (UNIT)": "Trend in the last hour of Energy Value Point (UNIT) {{UNIT}}",
      "Circuit": "Circuit",
      "Point": "Point",
      "Realtime Value": "Realtime Value",
      //Meter Tracking
      "Meter List": "Meter List",
      "Edit Meter": "Edit",
      "Start Value": "Start Value",
      "End Value": "End Value",
      //Equipment Tracking
      "Equipment List": "Equipment List",
      "Edit Equipment": "Edit",
      //Profile Dropdown
      "Feedback": "Feedback",
      "Account Settings": "Account Settings",
      "Logout": "Logout",
      //Authentication
      "Log in": "Log in",
      "Email address": "Email address",
      "Password": "Password",
      "Remember me": "Remember me",
      "Logged in as ": "Logged in as ",
      "Forget Password?": "Forget Password?",
      "Forgot your password?": "Forgot your password?",
      "Enter your email and we'll send you a reset link": "Enter your email and we'll send you a reset link",
      "Send reset link": "Send reset link",
      "Thanks for using MyEMS!": "Thanks for using MyEMS!",
      "You are now successfully signed out": "You are now successfully signed out",
      "Return to Login": "Return to Login",
      "Please check your email!": "Please check your email!",
      "An email has been sent to ": "An email has been sent to ",
      "Please click on the included link to reset your password": "Please click on the included link to reset your password",
      "An email with password reset link is sent to ": "An email with password reset link is sent to ",
      "Change Password": "Change Password",
      "Old Password": "Old Password",
      "New Password": "New Password",
      "Confirm Password": "Confirm Password",
      "Update Password": "Update Password",
      "Password has been changed!": "Password has been changed!",
      //notification
      "Notifications": "Notifications",
      "Mark all as read": "Mark all as read",
      "View all": "View all",
      "notification_NEW": "NEW",
      "notification_EARLIER": "EARLIER",
      "Notification List": "Notification List",
      "Bulk actions": "Bulk actions",
      "Notification Subject": "Subject",
      "Notification Created Datetime": "Datetime",
      "Notification Message": "Message",
      "Notification Status": "Status",
      "Notification Mark As Read": "Mark As Read",
      "Notification Unread": "Unread",
      "Notification Read": "Read",
      "Notification Archive": "Archive",
      "Notification Delete": "Delete",
      "Notification Apply": "Apply",
      //Monitoring
      "Run Commands": "Run Commands",
      "Fault Alarms": "Fault Alarms",
      "Instantaneous Efficiency VALUE UNIT": "Instantaneous Efficiency {{VALUE}} {{UNIT}}",
      "Communication Online": "Online",
      "Communication Offline": "Offline",
      "Equipment Running": "Running",
      "Equipment Stopped": "Stopped",
      "Show Up to": "Show Up to",
      "All": "All",
      "FROM - TO of TOTAL Equipments": "{{FROM}} - {{TO}} of {{TOTAL}} Equipments",
      //Advanced Reporting & Knowledge base
      "Created Datetime": "Created Datetime",
      "File Format": "File Format",
      "File Size": "File Size",
      "Uploader": "Uploader",
      //Error
      "The page you're looking for is not found": "The page you're looking for is not found",
      "Make sure the address is correct and that the page hasn't moved. ": "Make sure the address is correct and that the page hasn't moved. ",
      "If you think this is a mistake,": "If you think this is a mistake,",
      "contact us": "contact us",
      "Take me home": "Take me home",
      "Whoops, something went wrong!": "Whoops, something went wrong!",
      "Try refreshing the page, or going back and attempting the action again. ": "Try refreshing the page, or going back and attempting the action again. ",
      "If this problem persists,": "If this problem persists,",
      //Tenant Bill
      "Lease Contract Number": "Lease Contract Number",
      "Download": "Download",
      "Print": "Print",
      "Payment Notice": "Payment Notice",
      "Bill To": "Bill To",
      "Bill Number": "Bill Number",
      "Bill Date": "Bill Date",
      "Payment Due Date": "Payment Due Date",
      "Amount Payable": "Amount Payable",
      "Billing Period Start": "Billing Period Start",
      "Billing Period End": "Billing Period End",
      "Quantity": "Quantity",
      "Price": "Price",
      "Unit": "Unit",
      "Amount": "Amount",
      "Subtotal": "Subtotal",
      "VAT Output Tax": "VAT Output Tax",
      "Total Amount Payable": "Total Amount Payable",
      "Please make sure to pay on or before the payment due date above":"Please make sure to pay on or before the payment due date above",
      "Send money to the following account": "Send money to the following account",
      "Account Name": "Account Name",
      "Bank Name": "Bank Name",
      "Bank Address": "Bank Address",
      "RMB Account": "RMB Account",
      // button
      "Toggle Navigation": "Toggle Navigation",
      //API
      "API.ADMINISTRATOR_SESSION_NOT_FOUND": "Administrator session not found",
      "API.ADMINISTRATOR_SESSION_TIMEOUT": "Administrator session timeout",
      "API.ADVANCED_REPORT_NOT_FOUND": "Advanced report not found",
      "API.BAD_REQUEST": "Bad request",
      "API.CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER": "Cannot set existing submeter as master meter",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS": "Combined equipment equipment relation exists",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND": "Combined equipment equipment relation not found",
      "API.COMBINED_EQUIPMENT_METER_RELATION_EXISTS": "Combined equipment meter relation exists",
      "API.COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND": "Combined equipment meter relation not found",
      "API.COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Combined equipment name is already in use",
      "API.COMBINED_EQUIPMENT_NOT_FOUND": "Combined equipment not found",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Combined equipment offline meter relation exists",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Combined equipment offline meter relation not found",
      "API.COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Combined equipment parameter name is already in use",
      "API.COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Combined equipment parameter not found or not match",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Combined equipment virtual meter relation exists",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Combined equipment virtual meter relation not found",
      "API.CONTACT_NAME_IS_ALREADY_IN_USE": "Contact name is already in use",
      "API.CONTACT_NOT_FOUND": "Contact not found",
      "API.COST_CENTER_EXTERNAL_ID_EXISTS": "Cost center external id exists",
      "API.COST_CENTER_NAME_EXISTS": "Cost center name exists",
      "API.COST_CENTER_NOT_FOUND": "Cost center not found",
      "API.COST_FILE_NOT_FOUND": "Cost file not found",
      "API.DATA_SOURCE_NAME_IS_ALREADY_IN_USE": "Data source name is already in use",
      "API.DATA_SOURCE_NOT_FOUND": "Data source not found",
      "API.DATABASE_ERROR": "Database error",
      "API.DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE": "Distribution circuit name is already in use",
      "API.DISTRIBUTION_CIRCUIT_NOT_FOUND": "Distribution circuit not found",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS": "Distribution circuit point relation exists",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND": "Distribution circuit point relation not found",
      "API.DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE": "Distribution system name is already in use",
      "API.DISTRIBUTION_SYSTEM_NOT_FOUND": "Distribution system not found",
      "API.EMAIL_IS_ALREADY_IN_USE": "Email is already in use",
      "API.EMAIL_MESSAGE_NOT_FOUND": "Email message not found",
      "API.EMAIL_SERVER_HOST_IS_ALREADY_IN_USE": "Email server host is already in use",
      "API.EMAIL_SERVER_NOT_FOUND": "Email server not found",
      "API.EMPTY_VARIABLES_ARRAY": "Empty variables array",
      "API.ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE": "Energy category name is already in use",
      "API.ENERGY_CATEGORY_NOT_FOUND": "Energy category not found",
      "API.ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS": "Energy category used in energy items",
      "API.ENERGY_CATEGORY_USED_IN_METER": "Energy category used in meter",
      "API.ENERGY_CATEGORY_USED_IN_OFFLINE_METER": "Energy category used in offline meter",
      "API.ENERGY_CATEGORY_USED_IN_TARIFFS": "Energy category used in tariffs",
      "API.ENERGY_CATEGORY_USED_IN_VIRTUAL_METER": "Energy category used in virtual meter",
      "API.ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE": "Energy flow diagram link is already in use",
      "API.ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram link not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE": "Energy flow diagram name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE": "Energy flow diagram node name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram node not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NOT_FOUND": "Energy flow diagram not found",
      "API.ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item does not belong to energy category",
      "API.ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item is not belong to energy category",
      "API.ENERGY_ITEM_NAME_IS_ALREADY_IN_USE": "Energy item name is already in use",
      "API.ENERGY_ITEM_NOT_FOUND": "Energy item not found",
      "API.ENERGY_ITEM_USED_IN_METER": "Energy item used in meter",
      "API.ENERGY_ITEM_USED_IN_OFFLINE_METER": "Energy item used in offline meter",
      "API.ENERGY_ITEM_USED_IN_VIRTUAL_METER": "Energy item used in virtual meter",
      "API.EQUIPMENT_METER_RELATION_EXISTS": "Equipment meter relation exists",
      "API.EQUIPMENT_METER_RELATION_NOT_FOUND": "Equipment meter relation not found",
      "API.EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Equipment name is already in use",
      "API.EQUIPMENT_NOT_FOUND": "Equipment not found",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Equipment offline meter relation exists",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Equipment offline meter relation not found",
      "API.EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Equipment parameter name is already in use",
      "API.EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Equipment parameter not found or not match",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Equipment virtual meter relation exists",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Equipment virtual meter relation not found",
      "API.ERROR": "Error",
      "API.EXCEPTION": "Exception",
      "API.FAILED_TO_RESTORE_COST_FILE": "Failed to restore cost file",
      "API.FAILED_TO_RESTORE_KNOWLEDGE_FILE": "Failed to restore knowledge file",
      "API.FAILED_TO_RESTORE_OFFLINE_METER_FILE": "Failed to restore offline meter file",
      "API.FAILED_TO_UPLOAD_COST_FILE": "Failed to upload cost file",
      "API.FAILED_TO_UPLOAD_KNOWLEDGE_FILE": "Failed to upload knowledge file",
      "API.FAILED_TO_UPLOAD_OFFLINE_METER_FILE": "Failed to upload offline meter file",
      "API.GATEWAY_NAME_IS_ALREADY_IN_USE": "Gateway name is already in use",
      "API.GATEWAY_NOT_FOUND": "Gateway not found",
      "API.INVALID_": "Invalid ",
      "API.INVALID_ADDRESS": "Invalid address",
      "API.INVALID_ADDRESS_VALUE": "Invalid address value",
      "API.INVALID_ADVANCED_REPORT_ID": "Invalid advanced report id",
      "API.INVALID_AREA_VALUE": "Invalid area value",
      "API.INVALID_BASE_PERIOD_END_DATETIME": "Invalid base period end datetime",
      "API.INVALID_BASE_PERIOD_START_DATETIME": "Invalid base period start datetime",
      "API.INVALID_BAUD_RATE": "Invalid baud rate",
      "API.INVALID_BUILDINGS_VALUE": "Invalid buildings value",
      "API.INVALID_CATEGORY": "Invalid category",
      "API.INVALID_CHANNEL": "Invalid channel",
      "API.INVALID_COMBINED_EQUIPMENT_ID": "Invalid combined equipment id",
      "API.INVALID_COMBINED_EQUIPMENT_NAME": "Invalid combined equipment name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_ID": "Invalid combined equipment parameter id",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME": "Invalid combined equipment parameter name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE": "Invalid combined equipment parameter type",
      "API.INVALID_CONNECTION": "Invalid connection",
      "API.INVALID_CONSTANT_VALUE": "Invalid constant value",
      "API.INVALID_CONTACT_ID": "Invalid contact id",
      "API.INVALID_CONTACT_NAME": "Invalid contact name",
      "API.INVALID_COST_CENTER_ID": "Invalid cost center id",
      "API.INVALID_COST_FILE_ID": "Invalid cost file id",
      "API.INVALID_DATA_SOURCE_ID": "Invalid data source id",
      "API.INVALID_DATA_SOURCE_NAME": "Invalid data source name",
      "API.INVALID_DATA_SOURCE_PROTOCOL": "Invalid data source protocol",
      "API.INVALID_DENOMINATOR_METER_UUID": "Invalid denominator meter uuid",
      "API.INVALID_DISPLAY_NAME": "Invalid display name",
      "API.INVALID_DISTRIBUTION_CIRCUIT_ID": "Invalid distribution circuit id",
      "API.INVALID_DISTRIBUTION_CIRCUIT_NAME": "Invalid distribution circuit name",
      "API.INVALID_DISTRIBUTION_ROOM": "Invalid distribution room",
      "API.INVALID_DISTRIBUTION_SYSTEM_ID": "Invalid distribution system id",
      "API.INVALID_DISTRIBUTION_SYSTEM_NAME": "Invalid distribution system name",
      "API.INVALID_EMAIL": "Invalid email",
      "API.INVALID_EMAIL_MESSAGE_ID": "Invalid email message id",
      "API.INVALID_EMAIL_SERVER_HOST": "Invalid email server host",
      "API.INVALID_EMAIL_SERVER_ID": "Invalid email server id",
      "API.INVALID_END_DATE_FORMAT": "Invalid end date format",
      "API.INVALID_END_DATETIME": "Invalid end datetime",
      "API.INVALID_ENERGY_CATEGORY_ID": "Invalid energy category id",
      "API.INVALID_ENERGY_CATEGORY_NAME": "Invalid energy category name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_ID": "Invalid energy flow diagram id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID": "Invalid energy flow diagram link id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NAME": "Invalid energy flow diagram name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID": "Invalid energy flow diagram node id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME": "Invalid energy flow diagram node name",
      "API.INVALID_ENERGY_ITEM_ID": "Invalid energy item id",
      "API.INVALID_ENERGY_ITEM_NAME": "Invalid energy item name",
      "API.INVALID_EQUATION_IN_EXPRESSION": "Invalid equation in expression",
      "API.INVALID_EQUIPMENT_ID": "Invalid equipment id",
      "API.INVALID_equipment_ID": "Invalid equipment id",
      "API.INVALID_EQUIPMENT_NAME": "Invalid equipment name",
      "API.INVALID_EQUIPMENT_PARAMETER_ID": "Invalid equipment parameter id",
      "API.INVALID_EQUIPMENT_PARAMETER_NAME": "Invalid equipment parameter name",
      "API.INVALID_EQUIPMENT_PARAMETER_TYPE": "Invalid equipment parameter type",
      "API.INVALID_EXPRESSION": "Invalid expression",
      "API.INVALID_EXPRESSION_OBJECT": "Invalid expression object",
      "API.INVALID_FDD_CODE": "Invalid fdd code",
      "API.INVALID_FLOORS_VALUE": "Invalid floors value",
      "API.INVALID_FROM_ADDR": "Invalid from addr",
      "API.INVALID_GATEWAY_ID": "Invalid gateway id",
      "API.INVALID_GATEWAY_NAME": "Invalid gateway name",
      "API.INVALID_HOURLY_HIGH_LIMIT_VALUE": "Invalid hourly high limit value",
      "API.INVALID_HOURLY_LOW_LIMIT_VALUE": "Invalid hourly low limit value",
      "API.INVALID_IS_ADMIN_VALUE": "Invalid is admin value",
      "API.INVALID_IS_COUNTED_VALUE": "Invalid is counted value",
      "API.INVALID_IS_ENABLED": "Invalid is enabled",
      "API.INVALID_IS_HIDDEN": "Invalid is hidden",
      "API.INVALID_IS_IN_LEASE_VALUE": "Invalid is in lease value",
      "API.INVALID_IS_INPUT_COUNTED_VALUE": "Invalid is input counted value",
      "API.INVALID_IS_KEY_TENANT_VALUE": "Invalid is key tenant value",
      "API.INVALID_IS_OUTPUT_COUNTED_VALUE": "Invalid is output counted value",
      "API.INVALID_IS_OUTPUT_VALUE": "Invalid is output value",
      "API.INVALID_IS_TREND_VALUE": "Invalid is trend value",
      "API.INVALID_IS_VIRTUAL_VALUE": "Invalid is virtual value",
      "API.INVALID_KGCE": "Invalid kgce",
      "API.INVALID_KGCO2E": "Invalid kgco2e",
      "API.INVALID_KNOWLEDGE_FILE_ID": "Invalid knowledge file id",
      "API.INVALID_LATITUDE_VALUE": "Invalid latitude value",
      "API.INVALID_LEASE_NUMBER_VALUE": "Invalid lease number value",
      "API.INVALID_LONGITUDE_VALUE": "Invalid longitude value",
      "API.INVALID_LOW_LIMIT_VALUE": "Invalid low limit value",
      "API.INVALID_MASTER_METER_ID": "Invalid master meter id",
      "API.INVALID_MENU_ID": "Invalid menu id",
      "API.INVALID_MESSAGE_TEMPLATE": "Invalid message template",
      "API.INVALID_METER_ID": "Invalid meter id",
      "API.INVALID_METER_NAME": "Invalid meter name",
      "API.INVALID_METER_UUID": "Invalid meter uuid",
      "API.INVALID_NAME_VALUE": "Invalid name value",
      "API.INVALID_NEW_PASSWORD": "Invalid new password",
      "API.INVALID_NOTIFICATION_ID": "Invalid notification id",
      "API.INVALID_NUMERATOR_METER_UUID": "Invalid numerator meter uuid",
      "API.INVALID_OBJECT_TYPE": "Invalid object type",
      "API.INVALID_OFFLINE_METER_FILE_ID": "Invalid offline meter file id",
      "API.INVALID_OFFLINE_METER_ID": "Invalid offline meter id",
      "API.INVALID_OFFLINE_METER_NAME": "Invalid offline meter name",
      "API.INVALID_OLD_PASSWORD": "Invalid old password",
      "API.INVALID_PARENT_SPACE_ID": "Invalid parent space id",
      "API.INVALID_PASSWORD": "Invalid password",
      "API.INVALID_PEAK_CURRENT": "Invalid peak current",
      "API.INVALID_PEAK_LOAD": "Invalid peak load",
      "API.INVALID_PERIOD_TYPE": "Invalid period type",
      "API.INVALID_POINT_ID": "Invalid point id",
      "API.INVALID_POINT_NAME": "Invalid point name",
      "API.INVALID_PORT": "Invalid port",
      "API.INVALID_PRIORITY": "Invalid priority",
      "API.INVALID_PRIVILEGE": "Invalid privilege",
      "API.INVALID_PRIVILEGE_DATA": "Invalid privilege data",
      "API.INVALID_PRIVILEGE_ID": "Invalid privilege id",
      "API.INVALID_PRIVILEGE_NAME": "Invalid privilege name",
      "API.INVALID_RATIO_VALUE": "Invalid ratio value",
      "API.INVALID_REPLY": "Invalid reply",
      "API.INVALID_REPORTING_PERIOD_END_DATETIME": "Invalid reporting period end datetime",
      "API.INVALID_REPORTING_PERIOD_START_DATETIME": "Invalid reporting period start datetime",
      "API.INVALID_REQUIRES_AUTHENTICATION": "Invalid requires authentication",
      "API.INVALID_ROOMS_VALUE": "Invalid rooms value",
      "API.INVALID_RULE_ID": "Invalid rule id",
      "API.INVALID_RULE_NAME": "Invalid rule name",
      "API.INVALID_SENSOR_ID": "Invalid sensor id",
      "API.INVALID_SENSOR_NAME": "Invalid sensor name",
      "API.INVALID_SERIAL_PORT": "Invalid serial port",
      "API.INVALID_SESSION_PLEASE_RE_LOGIN": "Invalid session please re-login",
      "API.INVALID_SHOPFLOOR_ID": "Invalid shopfloor id",
      "API.INVALID_SHOPFLOOR_NAME": "Invalid shopfloor name",
      "API.INVALID_SOURCE_NODE_ID": "Invalid source node id",
      "API.INVALID_SPACE_ID": "Invalid space id",
      "API.INVALID_SPACE_NAME": "Invalid space name",
      "API.INVALID_START_DATE_FORMAT": "Invalid start date format",
      "API.INVALID_START_DATETIME": "Invalid start datetime",
      "API.INVALID_STATUS": "Invalid status",
      "API.INVALID_STORE_ID": "Invalid store id",
      "API.INVALID_STORE_NAME": "Invalid store name",
      "API.INVALID_STORE_TYPE_DESCRIPTION": "Invalid store type description",
      "API.INVALID_STORE_TYPE_ID": "Invalid store type id",
      "API.INVALID_STORE_TYPE_NAME": "Invalid store type name",
      "API.INVALID_STORE_TYPE_SIMPLIFIED_CODE": "Invalid store type simplified code",
      "API.INVALID_SVG": "Invalid svg",
      "API.INVALID_SWITCHGEAR": "Invalid switchgear",
      "API.INVALID_TARGET_NODE_ID": "Invalid target node id",
      "API.INVALID_TARIFF_BLOCK_PRICING": "Invalid tariff block pricing",
      "API.INVALID_TARIFF_ID": "Invalid tariff id",
      "API.INVALID_TARIFF_TIME_OF_USE_PRICING": "Invalid tariff time of use pricing",
      "API.INVALID_TARIFF_TYPE": "Invalid tariff type",
      "API.INVALID_TENANT_ID": "Invalid tenant id",
      "API.INVALID_TENANT_NAME": "Invalid tenant name",
      "API.INVALID_TENANT_TYPE_DESCRIPTION": "Invalid tenant type description",
      "API.INVALID_TENANT_TYPE_ID": "Invalid tenant type id",
      "API.INVALID_TENANT_TYPE_NAME": "Invalid tenant type name",
      "API.INVALID_TENANT_TYPE_SIMPLIFIED_CODE": "Invalid tenant type simplified code",
      "API.INVALID_TEXT_MESSAGE_ID": "Invalid text message id",
      "API.INVALID_TIMEZONE_ID": "Invalid timezone id",
      "API.INVALID_TOKEN": "Invalid token",
      "API.INVALID_UNIT_OF_MEASURE": "Invalid unit of measure",
      "API.INVALID_UNIT_OF_PRICE": "Invalid unit of price",
      "API.INVALID_UNITS": "Invalid units",
      "API.INVALID_USER_ID": "Invalid user id",
      "API.INVALID_USER_NAME": "Invalid user name",
      "API.INVALID_USER_NAME_OR_EMAIL": "Invalid user name or email",
      "API.INVALID_USER_PHONE": "Invalid user phone",
      "API.INVALID_USER_PLEASE_RE_LOGIN": "Invalid user please re-login",
      "API.INVALID_USER_UUID": "Invalid user uuid",
      "API.INVALID_VARIABLE_METER_ID": "Invalid variable meter id",
      "API.INVALID_VARIABLE_METER_TYPE": "Invalid variable meter type",
      "API.INVALID_VARIABLE_NAME": "Invalid variable name",
      "API.INVALID_VIRTUAL_METER_ID": "Invalid virtual meter id",
      "API.INVALID_VIRTUAL_METER_NAME": "Invalid virtual meter name",
      "API.INVALID_WEB_MESSAGE_ID": "Invalid web message id",
      "API.INVALID_WECHAT_MESSAGE_ID": "Invalid wechat message id",
      "API.KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK": "Knowledge File Cannot be Removed from Disk",
      "API.KNOWLEDGE_FILE_NOT_FOUND": "Knowledge file not found",
      "API.MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY": "Master meter does not belong to same energy category",
      "API.MASTER_METER_NOT_FOUND": "Master meter not found",
      "API.MENU_NOT_FOUND": "Menu not found",
      "API.METER_NAME_IS_ALREADY_IN_USE": "Meter name is already in use",
      "API.METER_NOT_FOUND": "Meter not found",
      "API.METER_OF_VARIABLE_NOT_FOUND": "Meter of variable not found",
      "API.METER_POINT_RELATION_EXISTS": "Meter point relation exists",
      "API.METER_POINT_RELATION_NOT_FOUND": "Meter point relation not found",
      "API.NOT_FOUND": "Not found",
      "API.NOTIFICATION_NOT_FOUND": "Notification not found",
      "API.OFFLINE_METER_FILE_NOT_FOUND": "Offline meter file not found",
      "API.OFFLINE_METER_NAME_IS_ALREADY_IN_USE": "Offline meter name is already in use",
      "API.OFFLINE_METER_NOT_FOUND": "Offline meter not found",
      "API.OFFLINE_METER_OF_VARIABLE_NOT_FOUND": "Offline meter of variable not found",
      "API.PARENT_SPACE_NOT_FOUND": "Parent space not found",
      "API.POINT_NAME_IS_ALREADY_IN_USE": "Point name is already in use",
      "API.POINT_NOT_FOUND": "Point not found",
      "API.PRIVILEGE_NAME_IS_ALREADY_IN_USE": "Privilege name is already in use",
      "API.PRIVILEGE_NOT_FOUND": "Privilege not found",
      "API.RULE_NAME_IS_ALREADY_IN_USE": "Rule name is already in use",
      "API.RULE_NOT_FOUND": "Rule not found",
      "API.SENSOR_NAME_IS_ALREADY_IN_USE": "Sensor name is already in use",
      "API.SENSOR_NOT_FOUND": "Sensor not found",
      "API.SENSOR_POINT_RELATION_EXISTS": "Sensor point relation exists",
      "API.SENSOR_POINT_RELATION_NOT_FOUND": "Sensor point relation not found",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_EXISTS": "Shopfloor equipment relation exists",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND": "Shopfloor equipment relation not found",
      "API.SHOPFLOOR_METER_RELATION_EXISTS": "Shopfloor meter relation exists",
      "API.SHOPFLOOR_METER_RELATION_NOT_FOUND": "Shopfloor meter relation not found",
      "API.SHOPFLOOR_NAME_IS_ALREADY_IN_USE": "Shopfloor name is already in use",
      "API.SHOPFLOOR_NOT_FOUND": "Shopfloor not found",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS": "Shopfloor offline meter relation exists",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND": "Shopfloor offline meter relation not found",
      "API.SHOPFLOOR_POINT_RELATION_EXISTS": "Shopfloor point relation exists",
      "API.SHOPFLOOR_POINT_RELATION_NOT_FOUND": "Shopfloor point relation not found",
      "API.SHOPFLOOR_SENSOR_RELATION_EXISTS": "Shopfloor sensor relation exists",
      "API.SHOPFLOOR_SENSOR_RELATION_NOT_FOUND": "Shopfloor sensor relation not found",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS": "Shopfloor virtual meter relation exists",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND": "Shopfloor virtual meter relation not found",
      "API.SOURCE_NODE_NOT_FOUND": "Source node not found",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS": "Space combined equipment relation exists",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND": "Space combined equipment relation not found",
      "API.SPACE_EQUIPMENT_RELATION_EXISTS": "Space equipment relation exists",
      "API.SPACE_EQUIPMENT_RELATION_NOT_FOUND": "Space equipment relation not found",
      "API.SPACE_METER_RELATION_EXISTS": "Space meter relation exists",
      "API.SPACE_METER_RELATION_NOT_FOUND": "Space meter relation not found",
      "API.SPACE_NAME_IS_ALREADY_IN_USE": "Space name is already in use",
      "API.SPACE_NOT_FOUND": "Space not found",
      "API.SPACE_NOT_FOUND_IN_PRIVILEGE": "Space not found in privilege",
      "API.SPACE_OFFLINE_METER_RELATION_EXISTS": "Space offline meter relation exists",
      "API.SPACE_OFFLINE_METER_RELATION_NOT_FOUND": "Space offline meter relation not found",
      "API.SPACE_POINT_RELATION_EXISTS": "Space point relation exists",
      "API.SPACE_POINT_RELATION_NOT_FOUND": "Space point relation not found",
      "API.SPACE_SENSOR_RELATION_EXISTS": "Space sensor relation exists",
      "API.SPACE_SENSOR_RELATION_NOT_FOUND": "Space sensor relation not found",
      "API.SPACE_SHOPFLOOR_RELATION_EXISTS": "Space shopfloor relation exists",
      "API.SPACE_SHOPFLOOR_RELATION_NOT_FOUND": "Space shopfloor relation not found",
      "API.SPACE_STORE_RELATION_EXISTS": "Space store relation exists",
      "API.SPACE_STORE_RELATION_NOT_FOUND": "Space store relation not found",
      "API.SPACE_TENANT_RELATION_EXISTS": "Space tenant relation exists",
      "API.SPACE_TENANT_RELATION_NOT_FOUND": "Space tenant relation not found",
      "API.SPACE_VIRTUAL_METER_RELATION_EXISTS": "Space virtual meter relation exists",
      "API.SPACE_VIRTUAL_METER_RELATION_NOT_FOUND": "Space virtual meter relation not found",
      "API.START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME": "Start datetime must be early than end datetime",
      "API.STORE_METER_RELATION_EXISTS": "Store meter relation exists",
      "API.STORE_METER_RELATION_NOT_FOUND": "Store meter relation not found",
      "API.STORE_NAME_IS_ALREADY_IN_USE": "Store name is already in use",
      "API.STORE_NOT_FOUND": "Store not found",
      "API.STORE_OFFLINE_METER_RELATION_EXISTS": "Store offline meter relation exists",
      "API.STORE_OFFLINE_METER_RELATION_NOT_FOUND": "Store offline meter relation not found",
      "API.STORE_POINT_RELATION_EXISTS": "Store point relation exists",
      "API.STORE_POINT_RELATION_NOT_FOUND": "Store point relation not found",
      "API.STORE_SENSOR_RELATION_EXISTS": "Store sensor relation exists",
      "API.STORE_SENSOR_RELATION_NOT_FOUND": "Store sensor relation not found",
      "API.STORE_TYPE_NAME_IS_ALREADY_IN_USE": "Store type name is already in use",
      "API.STORE_TYPE_NOT_FOUND": "Store type not found",
      "API.STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Store type simplified code is already in use",
      "API.STORE_TYPE_USED_IN_STORE": "Store type used in store",
      "API.STORE_VIRTUAL_METER_RELATION_EXISTS": "Store virtual meter relation exists",
      "API.STORE_VIRTUAL_METER_RELATION_NOT_FOUND": "Store virtual meter relation not found",
      "API.TARGET_NODE_NOT_FOUND": "Target node not found",
      "API.TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER": "Tariff is already associated with cost center",
      "API.TARIFF_IN_USE": "Tariff in use",
      "API.TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER": "Tariff is not associated with cost center",
      "API.TARIFF_NAME_IS_ALREADY_IN_USE": "Tariff name is already in use",
      "API.TARIFF_NOT_EMPTY": "Tariff not empty",
      "API.TARIFF_NOT_FOUND": "Tariff not found",
      "API.TENANT_METER_RELATION_EXISTS": "Tenant meter relation exists",
      "API.TENANT_METER_RELATION_NOT_FOUND": "Tenant meter relation not found",
      "API.TENANT_NAME_IS_ALREADY_IN_USE": "Tenant name is already in use",
      "API.TENANT_NOT_FOUND": "Tenant not found",
      "API.TENANT_OFFLINE_METER_RELATION_EXISTS": "Tenant offline meter relation exists",
      "API.TENANT_OFFLINE_METER_RELATION_NOT_FOUND": "Tenant offline meter relation not found",
      "API.TENANT_POINT_RELATION_EXISTS": "Tenant point relation exists",
      "API.TENANT_POINT_RELATION_NOT_FOUND": "Tenant point relation not found",
      "API.TENANT_SENSOR_RELATION_EXISTS": "Tenant sensor relation exists",
      "API.TENANT_SENSOR_RELATION_NOT_FOUND": "Tenant sensor relation not found",
      "API.TENANT_TYPE_NAME_IS_ALREADY_IN_USE": "Tenant type name is already in use",
      "API.TENANT_TYPE_NOT_FOUND": "Tenant type not found",
      "API.TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Tenant type simplified code is already in use",
      "API.TENANT_TYPE_USED_IN_TENANT": "Tenant type used in tenant",
      "API.TENANT_VIRTUAL_METER_RELATION_EXISTS": "Tenant virtual meter relation exists",
      "API.TENANT_VIRTUAL_METER_RELATION_NOT_FOUND": "Tenant virtual meter relation not found",
      "API.TEXT_MESSAGE_NOT_FOUND": "Text message not found",
      "API.THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES": "The reporting period must be longer than 15 minutes",
      "API.THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS": "There is associated distribution circuits",
      "API.THERE_IS_RELATION_WITH_CHILD_METERS": "There is relation with child meters",
      "API.THERE_IS_RELATION_WITH_CHILDREN_SPACES": "There is relation with children spaces",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS": "There is relation with combined equipment parameters",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS": "There is relation with combined equipments",
      "API.THERE_IS_RELATION_WITH_DATA_SOURCES": "There is relation with data sources",
      "API.THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS": "There is relation with energy flow diagram links",
      "API.THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS": "There is relation with equipment parameters",
      "API.THERE_IS_RELATION_WITH_EQUIPMENTS": "There is relation with equipments",
      "API.THERE_IS_RELATION_WITH_METER": "There is relation with meter",
      "API.THERE_IS_RELATION_WITH_METERS": "There is relation with meters",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METER": "There is relation with offline meter",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METERS": "There is relation with offline meters",
      "API.THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS": "There is relation with other virtual meters",
      "API.THERE_IS_RELATION_WITH_POINTS": "There is relation with points",
      "API.THERE_IS_RELATION_WITH_SENSORS": "There is relation with sensors",
      "API.THERE_IS_RELATION_WITH_SHOPFLOORS": "There is relation with shopfloors",
      "API.THERE_IS_RELATION_WITH_SPACES": "There is relation with spaces",
      "API.THERE_IS_RELATION_WITH_STORES": "There is relation with stores",
      "API.THERE_IS_RELATION_WITH_TARIFFS": "There is relation with tariffs",
      "API.THERE_IS_RELATION_WITH_TENANTS": "There is relation with tenants",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METER": "There is relation with virtual meter",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METERS": "There is relation with virtual meters",
      "API.THERE_IS_RELATION_WITH_USERS": "There is relation with users",
      "API.THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER": "This data source is being used by a meter",
      "API.THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This meter is being used by a virtual meter",
      "API.THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This offline meter is being used by a virtual meter",
      "API.THIS_SHOPFLOOR_CANNOT_BE_DELETED": "This shopfloor cannot be deleted",
      "API.THIS_SPACE_CANNOT_BE_DELETED": "This space cannot be deleted",
      "API.TIMEZONE_NOT_FOUND": "Timezone not found",
      "API.TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "Token not found in headers please login",
      "API.USER_ACCOUNT_HAS_EXPIRED": "User Account Has Expired",
      "API.USER_NAME_IS_ALREADY_IN_USE": "User name is already in use",
      "API.USER_NOT_FOUND": "User not found",
      "API.USER_PASSWORD_HAS_EXPIRED": "User Password Has Expired",
      "API.USER_PRIVILEGE_NOT_FOUND": "User privilege not found",
      "API.USER_SESSION_NOT_FOUND": "User session not found",
      "API.USER_SESSION_TIMEOUT": "User session timeout",
      "API.USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "User uuid not found in headers please login",
      "API.VIRTUAL_METER_NAME_IS_ALREADY_IN_USE": "Virtual meter name is already in use",
      "API.VIRTUAL_METER_NOT_FOUND": "Virtual meter not found",
      "API.VIRTUAL_METER_OF_VARIABLE_NOT_FOUND": "Virtual meter of variable not found",
      "API.VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE": "Virtual point should be analog value",
      "API.WEB_MESSAGE_NOT_FOUND": "Web message not found",
      "API.WECHAT_MESSAGE_NOT_FOUND": "Wechat message not found",

    }
  },
  de: {
    translation: {
      // routes
      "Dashboard": "Instrumententafel",
      "Space Data": "Platz",
      "Equipment Data": "Ausrüstung",
      "Meter Data": "Meter",
      "Tenant Data": "Mieter",
      "Store Data": "Geschäft",
      "Shopfloor Data": "Werkstatt",
      "Combined Equipment Data": "Kombinierte Ausrüstung",
      "Auxiliary System": "Hilfssystem",
      "Fault Detection & Diagnostics": "Fehlererkennung und -diagnose",
      "Monitoring": "Überwachung",
      "Advanced Reporting": "Erweiterte Berichterstellung",
      "Knowledge Base": "Wissensbasis",
      "Energy Category Data": "Energiekategorie",
      "Energy Item Data": "Unterpunkt Energieverbrauch",
      "Cost": "Kosten",
      "Output": "Ausgang",
      "Income": "Einkommen",
      "Efficiency": "Effizienz",
      "Load": "Stromlast",
      "Statistics": "Statistiken",
      "Batch Analysis": "Charge Analyse",
      "Saving": "Sparen",
      "Equipment Tracking": "Ausrüstung Datei",
      "Meter Energy": "Meter Energie ",
      "Meter Cost": "Meter Kosten",
      "Meter Trend": "Meter Trend",
      "Meter Realtime": "Meter Echtzeit",
      "Master Meter Submeters Balance": "Master Meter Submeters Balance",
      "Virtual Meter Energy": "Virtuelles Meter Energie",
      "Virtual Meter Cost": "Virtuelles Meter Kosten",
      "Offline Meter Energy": "Offline Meter Energie",
      "Offline Meter Cost": "Offline Meter Kosten",
      "Meter Tracking": "Meterverfolgung",
      "Tenant Bill": "Mieter Rechnung",
      "Energy Flow Diagram": "Energieflussdiagramm",
      "Distribution System":"Vertriebssystem",
      "Fault Statistics": "Fehlerstatistik",
      "Space Faults Data": "Platz Fehler",
      "Equipment Faults Data": "Ausrüstung Fehler",
      "Combined Equipment Faults Data": "Kombinierte Ausrüstung Fehler",
      "Tenant Faults Data": "Mieter Fehler",
      "Store Faults Data": "Geschäft Fehler",
      "Shopfloor Faults Data": "Werkstatt Fehler",
      "Space Equipments": "Platz Ausrüstung",
      "Combined Equipments": "Kombinierte Ausrüstung",
      "Tenant Equipments": "Mieter Ausrüstung",
      "Store Equipments": "Geschäft Ausrüstung",
      "Shopfloor Equipments": "Werkstatt Ausrüstung",
      // Dashboard
      "Welcome to MyEMS": 'Willkommen bei MyEMS',
      "An Industry Leading Open Source Energy Management System": "Ein branchenführendes Open Source Energie Management System",
      "This Year's Consumption CATEGORY VALUE UNIT": "Der Verbrauch Dieses Jahr {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "This Year's Costs CATEGORY VALUE UNIT": "Der Kosten Dieses Jahr {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Consumption CATEGORY VALUE UNIT": "Der Verbrauch Letztes Jahr {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Costs CATEGORY VALUE UNIT": "Der Kosten Letztes Jahr {{CATEGORY}} {{VALUE}} {{UNIT}}",
      // Entities
      "Space": "Platz",
      "Equipment": "Ausrüstung",
      "Meter": "Meter",
      "Offline Meter": "Offline Meter",
      "Virtual Meter": "Virtuelles Meter",
      "Tenant": "Mieter",
      "Store": "Geschäft",
      "Shopfloor": "Werkstatt",
      "Combined Equipment": "Kombinierte Ausrüstung",
      "Cost Center": "Kostenstelle",
      "Name": "Name",
      "Description": "Beschreibung",
      "Energy Category": "Energiekategorie",
      "Child Spaces": "Teil Platz",
      "Associated Equipment": "Dazugehörige Geräte",
      //Energy Categories
      "Electricity": "Elektrizität",
      "Water": "Wasser",
      "Natural Gas": "Erdgas",
      // SidePanelModal
      "Settings": "Einstellungen",
      "Set your own customized style": "Stellen Sie Ihren eigenen Stil ein",
      "Color Scheme": "Farbschema",
      "Choose the perfect color mode for your app": "Wählen Sie den perfekten Farbmodus für Ihre App",
      "Light": "Helle",
      "Dark": "Dunkle",
      "RTL Mode": "RTL-Modus",
      "Switch your language direction": "Wechseln Sie Ihre Sprachrichtung",
      "Fluid Layout": "Flüssigkeitsanordnung",
      "Toggle container layout system": "Container-Layout-System umschalten",
      "Navigation Position": "Navigationsposition",
      "Select a suitable navigation system for your web application": "Wählen Sie ein geeignetes Navigationssystem für Ihre Webanwendung",
      "Vertical Nav": "Vertikale Navigation",
      "Top Nav": "Top Nav",
      "Vertical Navbar Style": "Vertikaler Navbar-Stil",
      "Switch between styles for your vertical navbar": "Wechseln Sie zwischen den Stilen für Ihre vertikale Navigationsleiste",
      "Language": "Sprache",
      "Switch between languages": "Zwischen den Sprachen wechseln",
      "language-zh_CN": "简体中文",
      "language-en": "English",
      "language-de": "Deutsch",
      "Like What You See?": "Wie was du siehst?",
      "Get MyEMS now": "Holen Sie sich jetzt MyEMS",
      "Purchase": "Kauf",
      // Query Panels
      "Base Period Begins": "Basisperiode beginnt",
      "Base Period Ends": "Basisperiode endet",
      "Comparison Types": "Vergleichstypen",
      "Year-Over-Year": "Jahr für Jahr",
      "Month-On-Month": "Monat für Monat",
      "Free Comparison": "Freier Vergleich",
      "None Comparison": "Kein Vergleich",
      "Reporting Period Begins": "Berichtszeitraum beginnt",
      "Reporting Period Ends": "Berichtszeitraum endet",
      "(Optional)": "(Optional)",
      "Period Types": "Periodentypen",
      "Yearly": "Jährlich",
      "Monthly": "Monatlich",
      "Weekly": "Wöchentlich",
      "Daily": "Täglich",
      "Hourly": "Stündlich",
      "Submit": "einreichen",
      "Input Energy Category": "Eingangsenergiekategorie",
      "Output Energy Category": "Ausgangsenergiekategorie",
      "Fraction Parameter": "Fraktion Parameter",
      "Search": "Suche",
      //Card Summaries and Line Charts
      "Base Period": "Basiszeitraum",
      "Reporting Period": "Berichtszeitraum",
      "Per Unit Area": "Pro Flächeneinheit",
      "Per Unit Production": "Produktion pro Einheit",
      "Baseline Value - Actual Value": "Basiswert - Istwert",
      "Average Load": "Durchschnittliche Belastung",
      "Maximum Load": "Maximale Last",
      "Load Factor": "Ladefaktor",
      "Ratio of Average Load to Maximum Load": "Verhältnis von durchschnittlicher Last zu maximaler Last",
      "Costs by Energy Category": "Kosten nach Energiekategorie",
      "Incomes by Energy Category": "Einkommen nach Energiekategorie",
      "Electricity Consumption by Time-Of-Use": "Stromverbrauch nach Nutzungsdauer",
      "Electricity Cost by Time-Of-Use": "Stromkosten je nach Nutzungsdauer",
      "CATEGORY UNIT Consumption by Energy Items": "{{CATEGORY}} {{UNIT}} nach Unterpunkt Energieverbrauch",
      "Ton of Standard Coal by Energy Category": "Tonne Standardkohle(TCE) nach Energiekategorie",
      "Ton of Carbon Dioxide Emissions by Energy Category": "Tonne Kohlendioxidemissionen(TCO2E) nach Energiekategorie",
      "Reporting Period Consumption CATEGORY UNIT": "Verbrauch des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{EQUIPMENT}} Verbrauch des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} Verbrauch des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption CATEGORY VALUE UNIT": "Verbrauch des Berichtszeitraums {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption CATEGORY VALUE UNIT": "Verbrauch des Basiszeitraums {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY UNIT": "Verbrauch des Berichtszeitraums {{ITEM}} {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY VALUE UNIT": "Verbrauch des Berichtszeitraums {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption ITEM CATEGORY VALUE UNIT": "Verbrauch des Basiszeitraums {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Child Space Proportion CATEGORY UNIT": "Anteil des Teil Platz nach Energiekategorie {{CATEGORY}} {{UNIT}}",
      "Child Space Total Proportion": "Anteil des Teil Platz Gesamtanteil",
      "Reporting Period Costs CATEGORY UNIT": "Berichtszeitraumkosten {{CATEGORY}} {{UNIT}}",
      "Reporting Period Costs CATEGORY VALUE UNIT": "Berichtszeitraumkosten {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Costs CATEGORY VALUE UNIT": "Kosten des Basiszeitraums {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Output CATEGORY UNIT": "Ausgabe des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{EQUIPMENT}} Ausgabe des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} Ausgabe des Berichtszeitraums {{CATEGORY}} {{UNIT}}",
      "Reporting Period Output CATEGORY VALUE UNIT": "Ausgabe des Berichtszeitraums {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Output CATEGORY VALUE UNIT": "Basisperiodenausgabe {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Income CATEGORY UNIT": "Berichtsperiodeneinkommen {{CATEGORY}} {{UNIT}}",
      "Reporting Period Income CATEGORY VALUE UNIT": "Berichtsperiodeneinkommen {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Income CATEGORY VALUE UNIT": "Basisperiodeneinkommen {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Total Income UNIT": "Berichtszeitraum Gesamteinkommen {{UNIT}}",
      "Reporting Period Cumulative Efficiency NAME UNIT": "Berichtszeitraum Kumulative Effizienz {{NAME}} {{UNIT}}",
      "EQUIPMENT Reporting Period Cumulative Efficiency UNIT": "{{EQUIPMENT}} Berichtszeitraum Kumulative Effizienz {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} Berichtszeitraum Kumulative Gesamteffizienz {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} Berichtszeitraum Kumulative Gesamteffizienz {{VALUE}} {{UNIT}}",
      "COMBINED_EQUIPMENT Base Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} Basisperiode Kumulative Gesamteffizienz {{VALUE}} {{UNIT}}",
      "Instantaneous Efficiency UNIT": "Sofortige Effizienz {{UNIT}}",
      "EQUIPMENT Instantaneous Efficiency UNIT": "{{EQUIPMENT}} Sofortige Effizienz {{UNIT}}",
      "COMBINED_EQUIPMENT Instantaneous Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} Sofortige umfassende Effizienz {{UNIT}}",
      "Reporting Period Cumulative Efficiency VALUE UNIT": "Berichtszeitraum Kumulative Effizienz {{VALUE}} {{UNIT}}",
      "Base Period Cumulative Efficiency VALUE UNIT": "Kumulative Effizienz der Basisperiode {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Maximum Load UNIT": "Berichtszeitraum {{CATEGORY}} Maximale Last {{UNIT}}",
      "Reporting Period CATEGORY Average Load UNIT": "Berichtszeitraum {{CATEGORY}} Durchschnittliche Belastung {{UNIT}}",
      "Reporting Period CATEGORY Load Factor": "Berichtszeitraum {{CATEGORY}} Ladefaktor",
      "Base Period CATEGORY Average Load VALUE UNIT": "Basiszeitraum {{CATEGORY}} Durchschnittliche Belastung {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Average UNIT": "Berichtszeitraum {{CATEGORY}} Durchschnittswert {{UNIT}}",
      "Reporting Period CATEGORY Maximum UNIT": "Berichtszeitraum {{CATEGORY}} Höchster Wert {{UNIT}}",
      "Reporting Period CATEGORY Minimum UNIT": "Berichtszeitraum {{CATEGORY}} Mindestwert {{UNIT}}",
      "Reporting Period CATEGORY Mean UNIT": "Berichtszeitraum {{CATEGORY}} Arithmetisches Mittel {{UNIT}}",
      "Reporting Period CATEGORY Median UNIT": "Berichtszeitraum {{CATEGORY}} Median (Mittlerer Wert) {{UNIT}}",
      "Reporting Period CATEGORY Stdev UNIT": "Berichtszeitraum {{CATEGORY}} Standardabweichung der Probe {{UNIT}}",
      "Reporting Period CATEGORY Variance UNIT": "Berichtszeitraum {{CATEGORY}} Stichprobenvarianz {{UNIT}}",
      "Reporting Period Savings CATEGORY (Baseline - Actual) UNIT": "Einsparungen im Berichtszeitraum {{CATEGORY}} (Grundlinie - Ist) {{UNIT}}",
      "Reporting Period Decreased CATEGORY (Baseline - Actual) UNIT": "Berichtszeitraum verkürzt {{CATEGORY}} (Grundlinie - Ist) {{UNIT}}",
      "Reporting Period Savings CATEGORY VALUE UNIT": "Einsparungen im Berichtszeitraum {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Savings CATEGORY VALUE UNIT": "Einsparungen in der Basisperiode {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY UNIT": "Berichtszeitraum Master Meter Verbrauch {{CATEGORY}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY VALUE UNIT": "Berichtszeitraum Master Meter Verbrauch {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY UNIT": "Berichtszeitraum Submeters Verbrauch {{CATEGORY}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY VALUE UNIT": "Berichtszeitraum Submeters Verbrauch {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Difference CATEGORY UNIT": "Unterschied im Berichtszeitraum {{CATEGORY}} {{UNIT}}",
      "Reporting Period Percentage Difference": "Unterschied im Prozentsatz Berichtszeitraum",
      "Reporting Period Difference CATEGORY VALUE UNIT": "Unterschied im Berichtszeitraum {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Trend Values": "Trendwerte",
      //FDD
      "Fault List": "Fehlerliste",
      "Reporting Period Number of Fault VALUE": "Berichtszeitraum Anzahl der Fehler: {{VALUE}}",
      "All Faults": "Alle Fehler",
      "Space Faults": "Platz Fehler",
      "Equipment Faults": "Ausrüstung Fehler",
      "Tenant Faults": "Mieter Fehler",
      "Store Faults": "Geschäft Fehler",
      "Shopfloor Faults": "Werkstatt Fehler",
      "Combined Equipment Faults": "Kombinierte Ausrüstung Fehler",
      "Number of All Faults": "Anzahl aller Fehler",
      "Number of Space Faults": "Anzahl der Platz Fehler",
      "Number of Equipment Faults": "Anzahl der Ausrüstung Fehler",
      "Number of Tenant Faults": "Anzahl der Mieter Fehler",
      "Number of Store Faults": "Anzahl der Geschäft Fehler",
      "Number of Shopfloor Faults": "Anzahl der Werkstatt Fehler",
      "Number of Combined Equipment Faults": "Anzahl der Kombinierte Ausrüstung Fehler",
      //Data Panels
      "Ton of Standard Coal": "Tonne Standardkohle",
      "Ton of Carbon Dioxide Emissions": "Tonne Kohlendioxidemissionen",
      "Related Parameters": "Verwandte Parameter",
      "Tariff": "Tarif",
      "Detailed Data": "Detaillierte Daten",
      "Child Spaces Data": "Teil Platz Daten",
      "Associated Equipment Data": "Dazugehörige Geräte Daten",
      "This Year": "Dieses Jahr",
      "This Month": "Diesen Monat",
      "This Day": "Dieser Tag",
      "Total": "Gesamt",
      "No data found": "Keine Daten gefunden",
      "Export": "Export",
      "Datetime": "Terminzeit",
      "Time-Of-Use Type": "Art der Zeitteilung",
      "Top-Peak": "Top-Peak",
      "On-Peak": "On-Peak",
      "Mid-Peak": "Mid-Peak",
      "Off-Peak": "Off-Peak",
      "Percentage": "Prozentsatz",
      //Realtime Chart
      "Trend in the last hour of Energy Value Point (UNIT)": "Trend in der letzten Stunde des Energiewertpunkts ({{UNIT}})",
      "Circuit": "Schaltkreis",
      "Point": "Punkt",
      "Realtime Value": "Echtzeitwert",
      //Meter Tracking
      "Meter List": "Zählerliste",
      "Edit Meter": "bearbeiten",
      "Start Value": "Wert des Starts",
      "End Value": "Wert des Ends",
      //Equipment Tracking
      "Equipment List": "Ausrüstungsliste",
      "Edit Equipment": "bearbeiten",
      //Profile Dropdown
      "Feedback": "Feedback",
      "Account Settings": "Kontoeinstellungen",
      "Logout": "Ausloggen",
      //Authentication
      "Log in": "Anmeldung",
      "Email address": "E-Mail-Addresse",
      "Password": "Passwort",
      "Remember me": "Behalte mich in Erinnerung",
      "Logged in as ": "Angemeldet als ",
      "Forget Password?": "Passwort vergessen?",
      "Forgot your password?": "Passwort vergessen?",
      "Enter your email and we'll send you a reset link": "Geben Sie Ihre E-Mail-Adresse ein und wir senden Ihnen einen Link zum Zurücksetzen",
      "Send reset link": "Reset-Link senden",
      "Thanks for using MyEMS!": "Vielen Dank, dass Sie MyEMS verwenden!",
      "You are now successfully signed out": "Sie sind jetzt erfolgreich abgemeldet",
      "Return to Login": "Zurück zum Login",
      "Please check your email!": "Bitte überprüfen Sie Ihre E-Mails!",
      "An email has been sent to ": "Eine email wurde gesendet an ",
      "Please click on the included link to reset your password": "Bitte klicken Sie auf den enthaltenen Link, um Ihr Passwort zurückzusetzen",
      "An email with password reset link is sent to ": "Eine E-Mail mit einem Link zum Zurücksetzen des Passworts wird an gesendet ",
      "Change Password": "Ändere das Passwort",
      "Old Password": "Altes Passwort",
      "New Password": "Neues Kennwort",
      "Confirm Password": "Bestätige das Passwort",
      "Update Password": "Kennwort aktualisieren",
      "Password has been changed!": "Das Passwort wurde geändert!",
      //notification
      "Notifications": "Benachrichtigungen",
      "Mark all as read": "Markiere alle als gelesen",
      "View all": "Alle ansehen",
      "notification_NEW": "Neu",
      "notification_EARLIER": "Vorhin",
      "Notification List": "Benachrichtigungsliste",
      "Bulk actions": "Massenaktionen",
      "Notification Subject": "Betreff",
      "Notification Created Datetime": "Datetime",
      "Notification Message": "Nachricht",
      "Notification Status": "Status",
      "Notification Mark As Read": "Mark as read",
      "Notification Unread": "Ungelesene",
      "Notification Read": "Lesen",
      "Notification Archive": "Archiv",
      "Notification Delete": "Löschen",
      "Notification Apply": "Anwenden",
      //Monitoring
      "Run Commands": "Befehle ausführen",
      "Fault Alarms": "Fehleralarme",
      "Instantaneous Efficiency VALUE UNIT": "Sofortige Effizienz {{VALUE}} {{UNIT}}",
      "Communication Status": "Kommunikationsstatus",
      "Equipment Status": "Ausrüstung Status",
      "Communication Online": "Online",
      "Communication Offline": "Offline",
      "Equipment Running": "Läuft",
      "Equipment Stopped": "Gestoppt",
      "Show Up to": "Zeigen Sie bis zu",
      "All": "Alles",
      "FROM - TO of TOTAL Equipments": "Derzeit angezeigt {{FROM}} - {{TO}} gesamt {{TOTAL}} Ausrüstung",
      //Advanced Reporting & Knowledge Base
      "Created Datetime": "Datetime erstellt",
      "File Format": "Datei Format",
      "File Size": "Dateigröße",
      "Uploader": "Uploader",
      "Upload Datetime": "Datetime hochladen",
      //Error
      "The page you're looking for is not found": "Die gesuchte Seite wurde nicht gefunden",
      "Make sure the address is correct and that the page hasn't moved. ": "Stellen Sie sicher, dass die Adresse korrekt ist und die Seite nicht verschoben wurde",
      "If you think this is a mistake,": "Wenn Sie denken, dass dies ein Fehler ist,",
      "contact us": "kontaktiere uns",
      "Take me home": "Bring mich zurück zur Homepage",
      "Whoops, something went wrong!": "Oh, etwas ist schief gelaufen!",
      "Try refreshing the page, or going back and attempting the action again. ": "Versuchen Sie, die Seite zu aktualisieren, oder gehen Sie zurück und versuchen Sie die Aktion erneut. ",
      "If this problem persists,": "Wenn dieses Problem weiterhin besteht,",
      //Tenant Bill
      "Lease Contract Number": "Mietvertragsnummer",
      "Download": "Herunterladen",
      "Print": "Drucken",
      "Payment Notice": "Zahlungshinweis",
      "Bill To": "Zu",
      "Bill Number": "Rechnungsnummer",
      "Bill Date": "Rechnungsdatum",
      "Payment Due Date": "Fälligkeitsdatum",
      "Amount Payable": "Bezahlbarer Betrag",
      "Billing Period Start": "Beginn des Abrechnungszeitraums",
      "Billing Period End": "Ende des Abrechnungszeitraums",
      "Quantity": "Menge",
      "Price": "Preis",
      "Unit": "Maßeinheit",
      "Amount": "Geldbetrag",
      "Subtotal": "Zwischensumme",
      "VAT Output Tax": "Mehrwertsteuer Ausgangssteuer",
      "Total Amount Payable": "Gesamtbetrag zahlbar",
      "Please make sure to pay on or before the payment due date above":"Bitte stellen Sie sicher, dass Sie am oder vor dem oben genannten Fälligkeitsdatum bezahlen",
      "Send money to the following account": "Senden Sie Geld auf das folgende Konto",
      "Account Name": "Kontobezeichnung",
      "Bank Name": "Bank Name",
      "Bank Address": "Bankadresse",
      "RMB Account": "RMB-Konto",
      // button
      "Toggle Navigation": "Navigation umschalten",
      // API
      "API.ADMINISTRATOR_SESSION_NOT_FOUND": "Administrator session not found",
      "API.ADMINISTRATOR_SESSION_TIMEOUT": "Administrator session timeout",
      "API.ADVANCED_REPORT_NOT_FOUND": "Advanced report not found",
      "API.BAD_REQUEST": "Bad request",
      "API.CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER": "Cannot set existing submeter as master meter",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS": "Combined equipment equipment relation exists",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND": "Combined equipment equipment relation not found",
      "API.COMBINED_EQUIPMENT_METER_RELATION_EXISTS": "Combined equipment meter relation exists",
      "API.COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND": "Combined equipment meter relation not found",
      "API.COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Combined equipment name is already in use",
      "API.COMBINED_EQUIPMENT_NOT_FOUND": "Combined equipment not found",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Combined equipment offline meter relation exists",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Combined equipment offline meter relation not found",
      "API.COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Combined equipment parameter name is already in use",
      "API.COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Combined equipment parameter not found or not match",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Combined equipment virtual meter relation exists",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Combined equipment virtual meter relation not found",
      "API.CONTACT_NAME_IS_ALREADY_IN_USE": "Contact name is already in use",
      "API.CONTACT_NOT_FOUND": "Contact not found",
      "API.COST_CENTER_EXTERNAL_ID_EXISTS": "Cost center external id exists",
      "API.COST_CENTER_NAME_EXISTS": "Cost center name exists",
      "API.COST_CENTER_NOT_FOUND": "Cost center not found",
      "API.COST_FILE_NOT_FOUND": "Cost file not found",
      "API.DATA_SOURCE_NAME_IS_ALREADY_IN_USE": "Data source name is already in use",
      "API.DATA_SOURCE_NOT_FOUND": "Data source not found",
      "API.DATABASE_ERROR": "Database error",
      "API.DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE": "Distribution circuit name is already in use",
      "API.DISTRIBUTION_CIRCUIT_NOT_FOUND": "Distribution circuit not found",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS": "Distribution circuit point relation exists",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND": "Distribution circuit point relation not found",
      "API.DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE": "Distribution system name is already in use",
      "API.DISTRIBUTION_SYSTEM_NOT_FOUND": "Distribution system not found",
      "API.EMAIL_IS_ALREADY_IN_USE": "Email is already in use",
      "API.EMAIL_MESSAGE_NOT_FOUND": "Email message not found",
      "API.EMAIL_SERVER_HOST_IS_ALREADY_IN_USE": "Email server host is already in use",
      "API.EMAIL_SERVER_NOT_FOUND": "Email server not found",
      "API.EMPTY_VARIABLES_ARRAY": "Empty variables array",
      "API.ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE": "Energy category name is already in use",
      "API.ENERGY_CATEGORY_NOT_FOUND": "Energy category not found",
      "API.ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS": "Energy category used in energy items",
      "API.ENERGY_CATEGORY_USED_IN_METER": "Energy category used in meter",
      "API.ENERGY_CATEGORY_USED_IN_OFFLINE_METER": "Energy category used in offline meter",
      "API.ENERGY_CATEGORY_USED_IN_TARIFFS": "Energy category used in tariffs",
      "API.ENERGY_CATEGORY_USED_IN_VIRTUAL_METER": "Energy category used in virtual meter",
      "API.ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE": "Energy flow diagram link is already in use",
      "API.ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram link not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE": "Energy flow diagram name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE": "Energy flow diagram node name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram node not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NOT_FOUND": "Energy flow diagram not found",
      "API.ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item does not belong to energy category",
      "API.ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item is not belong to energy category",
      "API.ENERGY_ITEM_NAME_IS_ALREADY_IN_USE": "Energy item name is already in use",
      "API.ENERGY_ITEM_NOT_FOUND": "Energy item not found",
      "API.ENERGY_ITEM_USED_IN_METER": "Energy item used in meter",
      "API.ENERGY_ITEM_USED_IN_OFFLINE_METER": "Energy item used in offline meter",
      "API.ENERGY_ITEM_USED_IN_VIRTUAL_METER": "Energy item used in virtual meter",
      "API.EQUIPMENT_METER_RELATION_EXISTS": "Equipment meter relation exists",
      "API.EQUIPMENT_METER_RELATION_NOT_FOUND": "Equipment meter relation not found",
      "API.EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Equipment name is already in use",
      "API.EQUIPMENT_NOT_FOUND": "Equipment not found",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Equipment offline meter relation exists",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Equipment offline meter relation not found",
      "API.EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Equipment parameter name is already in use",
      "API.EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Equipment parameter not found or not match",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Equipment virtual meter relation exists",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Equipment virtual meter relation not found",
      "API.ERROR": "Error",
      "API.EXCEPTION": "Exception",
      "API.FAILED_TO_RESTORE_COST_FILE": "Failed to restore cost file",
      "API.FAILED_TO_RESTORE_KNOWLEDGE_FILE": "Failed to restore knowledge file",
      "API.FAILED_TO_RESTORE_OFFLINE_METER_FILE": "Failed to restore offline meter file",
      "API.FAILED_TO_UPLOAD_COST_FILE": "Failed to upload cost file",
      "API.FAILED_TO_UPLOAD_KNOWLEDGE_FILE": "Failed to upload knowledge file",
      "API.FAILED_TO_UPLOAD_OFFLINE_METER_FILE": "Failed to upload offline meter file",
      "API.GATEWAY_NAME_IS_ALREADY_IN_USE": "Gateway name is already in use",
      "API.GATEWAY_NOT_FOUND": "Gateway not found",
      "API.INVALID_": "Invalid ",
      "API.INVALID_ADDRESS": "Invalid address",
      "API.INVALID_ADDRESS_VALUE": "Invalid address value",
      "API.INVALID_ADVANCED_REPORT_ID": "Invalid advanced report id",
      "API.INVALID_AREA_VALUE": "Invalid area value",
      "API.INVALID_BASE_PERIOD_END_DATETIME": "Invalid base period end datetime",
      "API.INVALID_BASE_PERIOD_START_DATETIME": "Invalid base period start datetime",
      "API.INVALID_BAUD_RATE": "Invalid baud rate",
      "API.INVALID_BUILDINGS_VALUE": "Invalid buildings value",
      "API.INVALID_CATEGORY": "Invalid category",
      "API.INVALID_CHANNEL": "Invalid channel",
      "API.INVALID_COMBINED_EQUIPMENT_ID": "Invalid combined equipment id",
      "API.INVALID_COMBINED_EQUIPMENT_NAME": "Invalid combined equipment name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_ID": "Invalid combined equipment parameter id",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME": "Invalid combined equipment parameter name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE": "Invalid combined equipment parameter type",
      "API.INVALID_CONNECTION": "Invalid connection",
      "API.INVALID_CONSTANT_VALUE": "Invalid constant value",
      "API.INVALID_CONTACT_ID": "Invalid contact id",
      "API.INVALID_CONTACT_NAME": "Invalid contact name",
      "API.INVALID_COST_CENTER_ID": "Invalid cost center id",
      "API.INVALID_COST_FILE_ID": "Invalid cost file id",
      "API.INVALID_DATA_SOURCE_ID": "Invalid data source id",
      "API.INVALID_DATA_SOURCE_NAME": "Invalid data source name",
      "API.INVALID_DATA_SOURCE_PROTOCOL": "Invalid data source protocol",
      "API.INVALID_DENOMINATOR_METER_UUID": "Invalid denominator meter uuid",
      "API.INVALID_DISPLAY_NAME": "Invalid display name",
      "API.INVALID_DISTRIBUTION_CIRCUIT_ID": "Invalid distribution circuit id",
      "API.INVALID_DISTRIBUTION_CIRCUIT_NAME": "Invalid distribution circuit name",
      "API.INVALID_DISTRIBUTION_ROOM": "Invalid distribution room",
      "API.INVALID_DISTRIBUTION_SYSTEM_ID": "Invalid distribution system id",
      "API.INVALID_DISTRIBUTION_SYSTEM_NAME": "Invalid distribution system name",
      "API.INVALID_EMAIL": "Invalid email",
      "API.INVALID_EMAIL_MESSAGE_ID": "Invalid email message id",
      "API.INVALID_EMAIL_SERVER_HOST": "Invalid email server host",
      "API.INVALID_EMAIL_SERVER_ID": "Invalid email server id",
      "API.INVALID_END_DATE_FORMAT": "Invalid end date format",
      "API.INVALID_END_DATETIME": "Invalid end datetime",
      "API.INVALID_ENERGY_CATEGORY_ID": "Invalid energy category id",
      "API.INVALID_ENERGY_CATEGORY_NAME": "Invalid energy category name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_ID": "Invalid energy flow diagram id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID": "Invalid energy flow diagram link id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NAME": "Invalid energy flow diagram name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID": "Invalid energy flow diagram node id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME": "Invalid energy flow diagram node name",
      "API.INVALID_ENERGY_ITEM_ID": "Invalid energy item id",
      "API.INVALID_ENERGY_ITEM_NAME": "Invalid energy item name",
      "API.INVALID_EQUATION_IN_EXPRESSION": "Invalid equation in expression",
      "API.INVALID_EQUIPMENT_ID": "Invalid equipment id",
      "API.INVALID_equipment_ID": "Invalid equipment id",
      "API.INVALID_EQUIPMENT_NAME": "Invalid equipment name",
      "API.INVALID_EQUIPMENT_PARAMETER_ID": "Invalid equipment parameter id",
      "API.INVALID_EQUIPMENT_PARAMETER_NAME": "Invalid equipment parameter name",
      "API.INVALID_EQUIPMENT_PARAMETER_TYPE": "Invalid equipment parameter type",
      "API.INVALID_EXPRESSION": "Invalid expression",
      "API.INVALID_EXPRESSION_OBJECT": "Invalid expression object",
      "API.INVALID_FDD_CODE": "Invalid fdd code",
      "API.INVALID_FLOORS_VALUE": "Invalid floors value",
      "API.INVALID_FROM_ADDR": "Invalid from addr",
      "API.INVALID_GATEWAY_ID": "Invalid gateway id",
      "API.INVALID_GATEWAY_NAME": "Invalid gateway name",
      "API.INVALID_HOURLY_HIGH_LIMIT_VALUE": "Invalid hourly high limit value",
      "API.INVALID_HOURLY_LOW_LIMIT_VALUE": "Invalid hourly low limit value",
      "API.INVALID_IS_ADMIN_VALUE": "Invalid is admin value",
      "API.INVALID_IS_COUNTED_VALUE": "Invalid is counted value",
      "API.INVALID_IS_ENABLED": "Invalid is enabled",
      "API.INVALID_IS_HIDDEN": "Invalid is hidden",
      "API.INVALID_IS_IN_LEASE_VALUE": "Invalid is in lease value",
      "API.INVALID_IS_INPUT_COUNTED_VALUE": "Invalid is input counted value",
      "API.INVALID_IS_KEY_TENANT_VALUE": "Invalid is key tenant value",
      "API.INVALID_IS_OUTPUT_COUNTED_VALUE": "Invalid is output counted value",
      "API.INVALID_IS_OUTPUT_VALUE": "Invalid is output value",
      "API.INVALID_IS_TREND_VALUE": "Invalid is trend value",
      "API.INVALID_IS_VIRTUAL_VALUE": "Invalid is virtual value",
      "API.INVALID_KGCE": "Invalid kgce",
      "API.INVALID_KGCO2E": "Invalid kgco2e",
      "API.INVALID_KNOWLEDGE_FILE_ID": "Invalid knowledge file id",
      "API.INVALID_LATITUDE_VALUE": "Invalid latitude value",
      "API.INVALID_LEASE_NUMBER_VALUE": "Invalid lease number value",
      "API.INVALID_LONGITUDE_VALUE": "Invalid longitude value",
      "API.INVALID_LOW_LIMIT_VALUE": "Invalid low limit value",
      "API.INVALID_MASTER_METER_ID": "Invalid master meter id",
      "API.INVALID_MENU_ID": "Invalid menu id",
      "API.INVALID_MESSAGE_TEMPLATE": "Invalid message template",
      "API.INVALID_METER_ID": "Invalid meter id",
      "API.INVALID_METER_NAME": "Invalid meter name",
      "API.INVALID_METER_UUID": "Invalid meter uuid",
      "API.INVALID_NAME_VALUE": "Invalid name value",
      "API.INVALID_NEW_PASSWORD": "Invalid new password",
      "API.INVALID_NOTIFICATION_ID": "Invalid notification id",
      "API.INVALID_NUMERATOR_METER_UUID": "Invalid numerator meter uuid",
      "API.INVALID_OBJECT_TYPE": "Invalid object type",
      "API.INVALID_OFFLINE_METER_FILE_ID": "Invalid offline meter file id",
      "API.INVALID_OFFLINE_METER_ID": "Invalid offline meter id",
      "API.INVALID_OFFLINE_METER_NAME": "Invalid offline meter name",
      "API.INVALID_OLD_PASSWORD": "Invalid old password",
      "API.INVALID_PARENT_SPACE_ID": "Invalid parent space id",
      "API.INVALID_PASSWORD": "Invalid password",
      "API.INVALID_PEAK_CURRENT": "Invalid peak current",
      "API.INVALID_PEAK_LOAD": "Invalid peak load",
      "API.INVALID_PERIOD_TYPE": "Invalid period type",
      "API.INVALID_POINT_ID": "Invalid point id",
      "API.INVALID_POINT_NAME": "Invalid point name",
      "API.INVALID_PORT": "Invalid port",
      "API.INVALID_PRIORITY": "Invalid priority",
      "API.INVALID_PRIVILEGE": "Invalid privilege",
      "API.INVALID_PRIVILEGE_DATA": "Invalid privilege data",
      "API.INVALID_PRIVILEGE_ID": "Invalid privilege id",
      "API.INVALID_PRIVILEGE_NAME": "Invalid privilege name",
      "API.INVALID_RATIO_VALUE": "Invalid ratio value",
      "API.INVALID_REPLY": "Invalid reply",
      "API.INVALID_REPORTING_PERIOD_END_DATETIME": "Invalid reporting period end datetime",
      "API.INVALID_REPORTING_PERIOD_START_DATETIME": "Invalid reporting period start datetime",
      "API.INVALID_REQUIRES_AUTHENTICATION": "Invalid requires authentication",
      "API.INVALID_ROOMS_VALUE": "Invalid rooms value",
      "API.INVALID_RULE_ID": "Invalid rule id",
      "API.INVALID_RULE_NAME": "Invalid rule name",
      "API.INVALID_SENSOR_ID": "Invalid sensor id",
      "API.INVALID_SENSOR_NAME": "Invalid sensor name",
      "API.INVALID_SERIAL_PORT": "Invalid serial port",
      "API.INVALID_SESSION_PLEASE_RE_LOGIN": "Invalid session please re-login",
      "API.INVALID_SHOPFLOOR_ID": "Invalid shopfloor id",
      "API.INVALID_SHOPFLOOR_NAME": "Invalid shopfloor name",
      "API.INVALID_SOURCE_NODE_ID": "Invalid source node id",
      "API.INVALID_SPACE_ID": "Invalid space id",
      "API.INVALID_SPACE_NAME": "Invalid space name",
      "API.INVALID_START_DATE_FORMAT": "Invalid start date format",
      "API.INVALID_START_DATETIME": "Invalid start datetime",
      "API.INVALID_STATUS": "Invalid status",
      "API.INVALID_STORE_ID": "Invalid store id",
      "API.INVALID_STORE_NAME": "Invalid store name",
      "API.INVALID_STORE_TYPE_DESCRIPTION": "Invalid store type description",
      "API.INVALID_STORE_TYPE_ID": "Invalid store type id",
      "API.INVALID_STORE_TYPE_NAME": "Invalid store type name",
      "API.INVALID_STORE_TYPE_SIMPLIFIED_CODE": "Invalid store type simplified code",
      "API.INVALID_SVG": "Invalid svg",
      "API.INVALID_SWITCHGEAR": "Invalid switchgear",
      "API.INVALID_TARGET_NODE_ID": "Invalid target node id",
      "API.INVALID_TARIFF_BLOCK_PRICING": "Invalid tariff block pricing",
      "API.INVALID_TARIFF_ID": "Invalid tariff id",
      "API.INVALID_TARIFF_TIME_OF_USE_PRICING": "Invalid tariff time of use pricing",
      "API.INVALID_TARIFF_TYPE": "Invalid tariff type",
      "API.INVALID_TENANT_ID": "Invalid tenant id",
      "API.INVALID_TENANT_NAME": "Invalid tenant name",
      "API.INVALID_TENANT_TYPE_DESCRIPTION": "Invalid tenant type description",
      "API.INVALID_TENANT_TYPE_ID": "Invalid tenant type id",
      "API.INVALID_TENANT_TYPE_NAME": "Invalid tenant type name",
      "API.INVALID_TENANT_TYPE_SIMPLIFIED_CODE": "Invalid tenant type simplified code",
      "API.INVALID_TEXT_MESSAGE_ID": "Invalid text message id",
      "API.INVALID_TIMEZONE_ID": "Invalid timezone id",
      "API.INVALID_TOKEN": "Invalid token",
      "API.INVALID_UNIT_OF_MEASURE": "Invalid unit of measure",
      "API.INVALID_UNIT_OF_PRICE": "Invalid unit of price",
      "API.INVALID_UNITS": "Invalid units",
      "API.INVALID_USER_ID": "Invalid user id",
      "API.INVALID_USER_NAME": "Invalid user name",
      "API.INVALID_USER_NAME_OR_EMAIL": "Invalid user name or email",
      "API.INVALID_USER_PHONE": "Invalid user phone",
      "API.INVALID_USER_PLEASE_RE_LOGIN": "Invalid user please re-login",
      "API.INVALID_USER_UUID": "Invalid user uuid",
      "API.INVALID_VARIABLE_METER_ID": "Invalid variable meter id",
      "API.INVALID_VARIABLE_METER_TYPE": "Invalid variable meter type",
      "API.INVALID_VARIABLE_NAME": "Invalid variable name",
      "API.INVALID_VIRTUAL_METER_ID": "Invalid virtual meter id",
      "API.INVALID_VIRTUAL_METER_NAME": "Invalid virtual meter name",
      "API.INVALID_WEB_MESSAGE_ID": "Invalid web message id",
      "API.INVALID_WECHAT_MESSAGE_ID": "Invalid wechat message id",
      "API.KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK": "Knowledge File Cannot be Removed from Disk",
      "API.KNOWLEDGE_FILE_NOT_FOUND": "Knowledge file not found",
      "API.MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY": "Master meter does not belong to same energy category",
      "API.MASTER_METER_NOT_FOUND": "Master meter not found",
      "API.MENU_NOT_FOUND": "Menu not found",
      "API.METER_NAME_IS_ALREADY_IN_USE": "Meter name is already in use",
      "API.METER_NOT_FOUND": "Meter not found",
      "API.METER_OF_VARIABLE_NOT_FOUND": "Meter of variable not found",
      "API.METER_POINT_RELATION_EXISTS": "Meter point relation exists",
      "API.METER_POINT_RELATION_NOT_FOUND": "Meter point relation not found",
      "API.NOT_FOUND": "Not found",
      "API.NOTIFICATION_NOT_FOUND": "Notification not found",
      "API.OFFLINE_METER_FILE_NOT_FOUND": "Offline meter file not found",
      "API.OFFLINE_METER_NAME_IS_ALREADY_IN_USE": "Offline meter name is already in use",
      "API.OFFLINE_METER_NOT_FOUND": "Offline meter not found",
      "API.OFFLINE_METER_OF_VARIABLE_NOT_FOUND": "Offline meter of variable not found",
      "API.PARENT_SPACE_NOT_FOUND": "Parent space not found",
      "API.POINT_NAME_IS_ALREADY_IN_USE": "Point name is already in use",
      "API.POINT_NOT_FOUND": "Point not found",
      "API.PRIVILEGE_NAME_IS_ALREADY_IN_USE": "Privilege name is already in use",
      "API.PRIVILEGE_NOT_FOUND": "Privilege not found",
      "API.RULE_NAME_IS_ALREADY_IN_USE": "Rule name is already in use",
      "API.RULE_NOT_FOUND": "Rule not found",
      "API.SENSOR_NAME_IS_ALREADY_IN_USE": "Sensor name is already in use",
      "API.SENSOR_NOT_FOUND": "Sensor not found",
      "API.SENSOR_POINT_RELATION_EXISTS": "Sensor point relation exists",
      "API.SENSOR_POINT_RELATION_NOT_FOUND": "Sensor point relation not found",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_EXISTS": "Shopfloor equipment relation exists",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND": "Shopfloor equipment relation not found",
      "API.SHOPFLOOR_METER_RELATION_EXISTS": "Shopfloor meter relation exists",
      "API.SHOPFLOOR_METER_RELATION_NOT_FOUND": "Shopfloor meter relation not found",
      "API.SHOPFLOOR_NAME_IS_ALREADY_IN_USE": "Shopfloor name is already in use",
      "API.SHOPFLOOR_NOT_FOUND": "Shopfloor not found",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS": "Shopfloor offline meter relation exists",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND": "Shopfloor offline meter relation not found",
      "API.SHOPFLOOR_POINT_RELATION_EXISTS": "Shopfloor point relation exists",
      "API.SHOPFLOOR_POINT_RELATION_NOT_FOUND": "Shopfloor point relation not found",
      "API.SHOPFLOOR_SENSOR_RELATION_EXISTS": "Shopfloor sensor relation exists",
      "API.SHOPFLOOR_SENSOR_RELATION_NOT_FOUND": "Shopfloor sensor relation not found",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS": "Shopfloor virtual meter relation exists",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND": "Shopfloor virtual meter relation not found",
      "API.SOURCE_NODE_NOT_FOUND": "Source node not found",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS": "Space combined equipment relation exists",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND": "Space combined equipment relation not found",
      "API.SPACE_EQUIPMENT_RELATION_EXISTS": "Space equipment relation exists",
      "API.SPACE_EQUIPMENT_RELATION_NOT_FOUND": "Space equipment relation not found",
      "API.SPACE_METER_RELATION_EXISTS": "Space meter relation exists",
      "API.SPACE_METER_RELATION_NOT_FOUND": "Space meter relation not found",
      "API.SPACE_NAME_IS_ALREADY_IN_USE": "Space name is already in use",
      "API.SPACE_NOT_FOUND": "Space not found",
      "API.SPACE_NOT_FOUND_IN_PRIVILEGE": "Space not found in privilege",
      "API.SPACE_OFFLINE_METER_RELATION_EXISTS": "Space offline meter relation exists",
      "API.SPACE_OFFLINE_METER_RELATION_NOT_FOUND": "Space offline meter relation not found",
      "API.SPACE_POINT_RELATION_EXISTS": "Space point relation exists",
      "API.SPACE_POINT_RELATION_NOT_FOUND": "Space point relation not found",
      "API.SPACE_SENSOR_RELATION_EXISTS": "Space sensor relation exists",
      "API.SPACE_SENSOR_RELATION_NOT_FOUND": "Space sensor relation not found",
      "API.SPACE_SHOPFLOOR_RELATION_EXISTS": "Space shopfloor relation exists",
      "API.SPACE_SHOPFLOOR_RELATION_NOT_FOUND": "Space shopfloor relation not found",
      "API.SPACE_STORE_RELATION_EXISTS": "Space store relation exists",
      "API.SPACE_STORE_RELATION_NOT_FOUND": "Space store relation not found",
      "API.SPACE_TENANT_RELATION_EXISTS": "Space tenant relation exists",
      "API.SPACE_TENANT_RELATION_NOT_FOUND": "Space tenant relation not found",
      "API.SPACE_VIRTUAL_METER_RELATION_EXISTS": "Space virtual meter relation exists",
      "API.SPACE_VIRTUAL_METER_RELATION_NOT_FOUND": "Space virtual meter relation not found",
      "API.START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME": "Start datetime must be early than end datetime",
      "API.STORE_METER_RELATION_EXISTS": "Store meter relation exists",
      "API.STORE_METER_RELATION_NOT_FOUND": "Store meter relation not found",
      "API.STORE_NAME_IS_ALREADY_IN_USE": "Store name is already in use",
      "API.STORE_NOT_FOUND": "Store not found",
      "API.STORE_OFFLINE_METER_RELATION_EXISTS": "Store offline meter relation exists",
      "API.STORE_OFFLINE_METER_RELATION_NOT_FOUND": "Store offline meter relation not found",
      "API.STORE_POINT_RELATION_EXISTS": "Store point relation exists",
      "API.STORE_POINT_RELATION_NOT_FOUND": "Store point relation not found",
      "API.STORE_SENSOR_RELATION_EXISTS": "Store sensor relation exists",
      "API.STORE_SENSOR_RELATION_NOT_FOUND": "Store sensor relation not found",
      "API.STORE_TYPE_NAME_IS_ALREADY_IN_USE": "Store type name is already in use",
      "API.STORE_TYPE_NOT_FOUND": "Store type not found",
      "API.STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Store type simplified code is already in use",
      "API.STORE_TYPE_USED_IN_STORE": "Store type used in store",
      "API.STORE_VIRTUAL_METER_RELATION_EXISTS": "Store virtual meter relation exists",
      "API.STORE_VIRTUAL_METER_RELATION_NOT_FOUND": "Store virtual meter relation not found",
      "API.TARGET_NODE_NOT_FOUND": "Target node not found",
      "API.TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER": "Tariff is already associated with cost center",
      "API.TARIFF_IN_USE": "Tariff in use",
      "API.TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER": "Tariff is not associated with cost center",
      "API.TARIFF_NAME_IS_ALREADY_IN_USE": "Tariff name is already in use",
      "API.TARIFF_NOT_EMPTY": "Tariff not empty",
      "API.TARIFF_NOT_FOUND": "Tariff not found",
      "API.TENANT_METER_RELATION_EXISTS": "Tenant meter relation exists",
      "API.TENANT_METER_RELATION_NOT_FOUND": "Tenant meter relation not found",
      "API.TENANT_NAME_IS_ALREADY_IN_USE": "Tenant name is already in use",
      "API.TENANT_NOT_FOUND": "Tenant not found",
      "API.TENANT_OFFLINE_METER_RELATION_EXISTS": "Tenant offline meter relation exists",
      "API.TENANT_OFFLINE_METER_RELATION_NOT_FOUND": "Tenant offline meter relation not found",
      "API.TENANT_POINT_RELATION_EXISTS": "Tenant point relation exists",
      "API.TENANT_POINT_RELATION_NOT_FOUND": "Tenant point relation not found",
      "API.TENANT_SENSOR_RELATION_EXISTS": "Tenant sensor relation exists",
      "API.TENANT_SENSOR_RELATION_NOT_FOUND": "Tenant sensor relation not found",
      "API.TENANT_TYPE_NAME_IS_ALREADY_IN_USE": "Tenant type name is already in use",
      "API.TENANT_TYPE_NOT_FOUND": "Tenant type not found",
      "API.TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Tenant type simplified code is already in use",
      "API.TENANT_TYPE_USED_IN_TENANT": "Tenant type used in tenant",
      "API.TENANT_VIRTUAL_METER_RELATION_EXISTS": "Tenant virtual meter relation exists",
      "API.TENANT_VIRTUAL_METER_RELATION_NOT_FOUND": "Tenant virtual meter relation not found",
      "API.TEXT_MESSAGE_NOT_FOUND": "Text message not found",
      "API.THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES": "The reporting period must be longer than 15 minutes",
      "API.THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS": "There is associated distribution circuits",
      "API.THERE_IS_RELATION_WITH_CHILD_METERS": "There is relation with child meters",
      "API.THERE_IS_RELATION_WITH_CHILDREN_SPACES": "There is relation with children spaces",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS": "There is relation with combined equipment parameters",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS": "There is relation with combined equipments",
      "API.THERE_IS_RELATION_WITH_DATA_SOURCES": "There is relation with data sources",
      "API.THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS": "There is relation with energy flow diagram links",
      "API.THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS": "There is relation with equipment parameters",
      "API.THERE_IS_RELATION_WITH_EQUIPMENTS": "There is relation with equipments",
      "API.THERE_IS_RELATION_WITH_METER": "There is relation with meter",
      "API.THERE_IS_RELATION_WITH_METERS": "There is relation with meters",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METER": "There is relation with offline meter",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METERS": "There is relation with offline meters",
      "API.THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS": "There is relation with other virtual meters",
      "API.THERE_IS_RELATION_WITH_POINTS": "There is relation with points",
      "API.THERE_IS_RELATION_WITH_SENSORS": "There is relation with sensors",
      "API.THERE_IS_RELATION_WITH_SHOPFLOORS": "There is relation with shopfloors",
      "API.THERE_IS_RELATION_WITH_SPACES": "There is relation with spaces",
      "API.THERE_IS_RELATION_WITH_STORES": "There is relation with stores",
      "API.THERE_IS_RELATION_WITH_TARIFFS": "There is relation with tariffs",
      "API.THERE_IS_RELATION_WITH_TENANTS": "There is relation with tenants",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METER": "There is relation with virtual meter",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METERS": "There is relation with virtual meters",
      "API.THERE_IS_RELATION_WITH_USERS": "There is relation with users",
      "API.THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER": "This data source is being used by a meter",
      "API.THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This meter is being used by a virtual meter",
      "API.THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This offline meter is being used by a virtual meter",
      "API.THIS_SHOPFLOOR_CANNOT_BE_DELETED": "This shopfloor cannot be deleted",
      "API.THIS_SPACE_CANNOT_BE_DELETED": "This space cannot be deleted",
      "API.TIMEZONE_NOT_FOUND": "Timezone not found",
      "API.TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "Token not found in headers please login",
      "API.USER_ACCOUNT_HAS_EXPIRED": "User Account Has Expired",
      "API.USER_NAME_IS_ALREADY_IN_USE": "User name is already in use",
      "API.USER_NOT_FOUND": "User not found",
      "API.USER_PASSWORD_HAS_EXPIRED": "User Password Has Expired",
      "API.USER_PRIVILEGE_NOT_FOUND": "User privilege not found",
      "API.USER_SESSION_NOT_FOUND": "User session not found",
      "API.USER_SESSION_TIMEOUT": "User session timeout",
      "API.USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "User uuid not found in headers please login",
      "API.VIRTUAL_METER_NAME_IS_ALREADY_IN_USE": "Virtual meter name is already in use",
      "API.VIRTUAL_METER_NOT_FOUND": "Virtual meter not found",
      "API.VIRTUAL_METER_OF_VARIABLE_NOT_FOUND": "Virtual meter of variable not found",
      "API.VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE": "Virtual point should be analog value",
      "API.WEB_MESSAGE_NOT_FOUND": "Web message not found",
      "API.WECHAT_MESSAGE_NOT_FOUND": "Wechat message not found",
    }
  },
  zh_CN: {
    translation: {
      // routes
      "Dashboard": "总览",
      "Space Data": "空间数据",
      "Equipment Data": "设备数据",
      "Meter Data": "计量表数据",
      "Tenant Data": "租户数据",
      "Store Data": "门店数据",
      "Shopfloor Data": "车间数据",
      "Combined Equipment Data": "组合设备数据",
      "Auxiliary System": "辅助系统",
      "Fault Detection & Diagnostics": "故障检测与诊断",
      "Monitoring": "设备监控",
      "Advanced Reporting": "高级报表",
      "Knowledge Base": "知识库",
      "Energy Category Data": "能耗分类分析",
      "Energy Item Data": "能耗分项分析",
      "Cost": "成本分析",
      "Output": "产出分析",
      "Income": "收入分析",
      "Efficiency": "效率分析",
      "Load": "负荷分析",
      "Statistics": "统计分析",
      "Batch Analysis": "批量分析",
      "Saving": "节能分析",
      "Equipment Tracking": "设备台账",
      "Meter Energy": "计量表能耗分析",
      "Meter Cost": "计量表成本分析",
      "Meter Trend": "计量表趋势分析",
      "Meter Realtime": "计量表实时分析",
      "Master Meter Submeters Balance": "总分表平衡分析",
      "Virtual Meter Energy": "虚拟表能耗分析",
      "Virtual Meter Cost": "虚拟表成本分析",
      "Offline Meter Energy": "离线表能耗分析",
      "Offline Meter Cost": "离线表成本分析",
      "Meter Tracking": "计量表台账",
      "Tenant Bill": "租户账单",
      "Energy Flow Diagram": "能流图",
      "Distribution System": "配电系统",
      "Fault Statistics": "故障统计分析",
      "Space Faults Data": "空间故障分析",
      "Equipment Faults Data": "设备故障分析",
      "Combined Equipment Faults Data": "组合设备故障分析",
      "Tenant Faults Data": "租户故障分析",
      "Store Faults Data": "门店故障分析",
      "Shopfloor Faults Data": "车间故障分析",
      "Space Equipments": "空间设备",
      "Combined Equipments": "组合设备",
      "Tenant Equipments": "租户设备",
      "Store Equipments": "门店设备",
      "Shopfloor Equipments": "车间设备",
      // Dashboard
      "Welcome to MyEMS": '欢迎使用MyEMS',
      "An Industry Leading Open Source Energy Management System": "行业领先的开源能源管理系统",
      "This Year's Consumption CATEGORY VALUE UNIT": "本年消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "This Year's Costs CATEGORY VALUE UNIT": "本年成本 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Consumption CATEGORY VALUE UNIT": "去年消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Last Year's Costs CATEGORY VALUE UNIT": "去年成本 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      // Entities
      "Space": "空间",
      "Equipment": "设备",
      "Meter": "计量表",
      "Offline Meter": "离线表",
      "Virtual Meter": "虚拟表",
      "Tenant": "租户",
      "Store": "门店",
      "Shopfloor": "车间",
      "Combined Equipment": "组合设备",
      "Cost Center": "成本中心",
      "Name": "名称",
      "Description": "描述",
      "Energy Category": "能耗分类",
      "Child Spaces": "子空间",
      "Associated Equipment": "相关设备",
      //Energy Categories
      "Electricity": "电",
      "Water": "自来水",
      "Natural Gas": "天然气",
      // SidePanelModal
      "Settings": "设置",
      "Set your own customized style": "设置您的自定义样式",
      "Color Scheme": "配色方案",
      "Choose the perfect color mode for your app": "为您的应用选择理想的色彩模式",
      "Light": "亮色",
      "Dark": "暗色",
      "RTL Mode": "RTL模式",
      "Switch your language direction": "改变你的语言方向",
      "Fluid Layout": "流动布局",
      "Toggle container layout system": "切换容器布局系统",
      "Navigation Position": "导航栏位置",
      "Select a suitable navigation system for your web application": "为您的web应用程序选择合适的导航栏系统",
      "Vertical Nav": "垂直导航栏",
      "Top Nav": "顶部导航栏",
      "Vertical Navbar Style": "垂直导航栏样式",
      "Switch between styles for your vertical navbar": "切换垂直导航栏的样式",
      "Language": "语言",
      "Switch between languages": "切换语言",
      "language-zh_CN": "简体中文",
      "language-en": "English",
      "language-de": "Deutsch",
      "Like What You See?": "喜欢这个系统?",
      "Get MyEMS now": "立即获取MyEMS",
      "Purchase": "购买",
      // Query Panels
      "Base Period Begins": "基准期开始",
      "Base Period Ends": "基准期结束",
      "Comparison Types": "比较类型",
      "Year-Over-Year": "上年同比",
      "Month-On-Month": "上月环比",
      "Free Comparison": "自由比",
      "None Comparison": "不比",
      "Reporting Period Begins": "报告期开始",
      "Reporting Period Ends": "报告期结束",
      "(Optional)": "(可选)",
      "Period Types": "时间尺度",
      "Yearly": "年",
      "Monthly": "月",
      "Weekly": "周",
      "Daily": "日",
      "Hourly": "时",
      "Submit": "提交",
      "Input Energy Category": "消耗能源分类",
      "Output Energy Category": "产出能源分类",
      "Fraction Parameter": "分式参数",
      "Search": "搜索",
      //Card Summaries and Line Charts
      "Base Period": "基准期",
      "Reporting Period": "报告期",
      "Per Unit Area": "单位面积值",
      "Per Unit Production": "单位产品值",
      "Baseline Value - Actual Value": "基线值-实际值",
      "Average Load": "平均负荷",
      "Maximum Load": "最大负荷",
      "Load Factor": "负荷系数",
      "Ratio of Average Load to Maximum Load": "平均负荷与最大负荷的比值",
      "Costs by Energy Category": "成本占比",
      "Incomes by Energy Category": "收入占比",
      "Electricity Consumption by Time-Of-Use": "分时消耗电量",
      "Electricity Cost by Time-Of-Use": "分时用电成本",
      "CATEGORY UNIT Consumption by Energy Items": "{{CATEGORY}} {{UNIT}} 分项消耗占比",
      "Ton of Standard Coal by Energy Category": "吨标准煤(TCE)占比",
      "Ton of Carbon Dioxide Emissions by Energy Category": "吨二氧化碳排放(TCO2E)占比",
      "Reporting Period Consumption CATEGORY UNIT": "报告期消耗 {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{EQUIPMENT}} 报告期消耗 {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Consumption CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} 报告期消耗 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption CATEGORY VALUE UNIT": "报告期消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption CATEGORY VALUE UNIT": "基准期消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY UNIT": "报告期消耗 {{ITEM}} {{CATEGORY}} {{UNIT}}",
      "Reporting Period Consumption ITEM CATEGORY VALUE UNIT": "报告期消耗 {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Consumption ITEM CATEGORY VALUE UNIT": "基准期消耗 {{ITEM}} {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Child Space Proportion CATEGORY UNIT": "子空间分类占比 {{CATEGORY}} {{UNIT}}",
      "Child Space Total Proportion": "子空间总计占比",
      "Reporting Period Costs CATEGORY UNIT": "报告期成本 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Costs CATEGORY VALUE UNIT": "报告期成本 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Costs CATEGORY VALUE UNIT": "基准期成本 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Output CATEGORY UNIT": "报告期产出 {{CATEGORY}} {{UNIT}}",
      "EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{EQUIPMENT}} 报告期产出 {{CATEGORY}} {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Output CATEGORY UNIT": "{{COMBINED_EQUIPMENT}} 报告期产出 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Output CATEGORY VALUE UNIT": "报告期产出 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Output CATEGORY VALUE UNIT": "基准期产出 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Income CATEGORY UNIT": "报告期收入 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Income CATEGORY VALUE UNIT": "报告期收入 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Income CATEGORY VALUE UNIT": "基准期收入 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Total Income UNIT": "报告期总收入 {{UNIT}}",
      "Reporting Period Cumulative Efficiency NAME UNIT": "报告期累积效率 {{NAME}} {{UNIT}}",
      "EQUIPMENT Reporting Period Cumulative Efficiency UNIT": "{{EQUIPMENT}} 报告期累积效率 {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} 报告期累积综合效率 {{UNIT}}",
      "COMBINED_EQUIPMENT Reporting Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} 报告期累积综合效率 {{VALUE}} {{UNIT}}",
      "COMBINED_EQUIPMENT Base Period Cumulative Comprehensive Efficiency VALUE UNIT": "{{COMBINED_EQUIPMENT}} 基准期累积综合效率 {{VALUE}} {{UNIT}}",
      "Instantaneous Efficiency UNIT": "瞬时效率 {{UNIT}}",
      "EQUIPMENT Instantaneous Efficiency UNIT": "{{EQUIPMENT}} 瞬时效率 {{UNIT}}",
      "COMBINED_EQUIPMENT Instantaneous Comprehensive Efficiency UNIT": "{{COMBINED_EQUIPMENT}} 瞬时综合效率 {{UNIT}}",
      "Reporting Period Cumulative Efficiency VALUE UNIT": "报告期累积效率 {{VALUE}} {{UNIT}}",
      "Base Period Cumulative Efficiency VALUE UNIT": "基准期累积效率 {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Maximum Load UNIT": "报告期 {{CATEGORY}} 最大负荷 {{UNIT}}",
      "Reporting Period CATEGORY Average Load UNIT": "报告期 {{CATEGORY}} 平均负荷 {{UNIT}}",
      "Reporting Period CATEGORY Load Factor": "报告期 {{CATEGORY}} 负荷系数",
      "Base Period CATEGORY Average Load VALUE UNIT": "基准期 {{CATEGORY}} 平均负荷 {{VALUE}} {{UNIT}}",
      "Reporting Period CATEGORY Average UNIT": "报告期 {{CATEGORY}} 平均值 {{UNIT}}",
      "Reporting Period CATEGORY Maximum UNIT": "报告期 {{CATEGORY}} 最大值 {{UNIT}}",
      "Reporting Period CATEGORY Minimum UNIT": "报告期 {{CATEGORY}} 最小值 {{UNIT}}",
      "Reporting Period CATEGORY Mean UNIT": "报告期 {{CATEGORY}}  算术平均数 {{UNIT}}",
      "Reporting Period CATEGORY Median UNIT": "报告期 {{CATEGORY}} 中位数 {{UNIT}}",
      "Reporting Period CATEGORY Stdev UNIT": "报告期 {{CATEGORY}} 样本标准差 {{UNIT}}",
      "Reporting Period CATEGORY Variance UNIT": "报告期 {{CATEGORY}} 样本方差 {{UNIT}}",
      "Reporting Period Savings CATEGORY (Baseline - Actual) UNIT": "报告期节约 {{CATEGORY}} (基线-实际) {{UNIT}}",
      "Reporting Period Decreased CATEGORY (Baseline - Actual) UNIT": "报告期减少 {{CATEGORY}} (基线-实际) {{UNIT}}",
      "Reporting Period Savings CATEGORY VALUE UNIT": "报告期节约 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Base Period Savings CATEGORY VALUE UNIT": "基准期节约 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY UNIT": "报告期总表消耗 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Master Meter Consumption CATEGORY VALUE UNIT": "报告期总表消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY UNIT": "报告期分表消耗 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Submeters Consumption CATEGORY VALUE UNIT": "报告期分表消耗 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Reporting Period Difference CATEGORY UNIT": "报告期差值 {{CATEGORY}} {{UNIT}}",
      "Reporting Period Percentage Difference": "报告期差值百分比",
      "Reporting Period Difference CATEGORY VALUE UNIT": "报告期差值 {{CATEGORY}} {{VALUE}} {{UNIT}}",
      "Trend Values": "趋势值",
      //FDD
      "Fault List": "故障列表",
      "Reporting Period Number of Fault VALUE": "报告期故障数: {{VALUE}}",
      "All Faults": "全部故障",
      "Space Faults": "空间故障",
      "Equipment Faults": "设备故障",
      "Tenant Faults": "租户故障",
      "Store Faults": "门店故障",
      "Shopfloor Faults": "车间故障",
      "Combined Equipment Faults": "组合设备故障",
      "Number of All Faults": "全部故障数",
      "Number of Space Faults": "空间故障数",
      "Number of Equipment Faults": "设备故障数",
      "Number of Tenant Faults": "租户故障数",
      "Number of Store Faults": "门店故障数",
      "Number of Shopfloor Faults": "车间故障数",
      "Number of Combined Equipment Faults": "组合设备故障数",
      //Data Panels
      "Ton of Standard Coal": "吨标准煤",
      "Ton of Carbon Dioxide Emissions": "吨二氧化碳排放",
      "Related Parameters": "相关参数",
      "Tariff": "费率",
      "Detailed Data": "详细数据",
      "Child Spaces Data": "子空间数据",
      "Associated Equipment Data": "相关设备数据",
      "This Year": "本年",
      "This Month": "本月",
      "This Day": "本日",
      "Total": "总计",
      "No data found": "没有数据",
      "Export": "导出",
      "Datetime": "日期时间",
      "Time-Of-Use Type": "分时类型",
      "Top-Peak": "尖",
      "On-Peak": "峰",
      "Mid-Peak": "平",
      "Off-Peak": "谷",
      "Percentage": "百分比",
      //Realtime Chart
      "Trend in the last hour of Energy Value Point (UNIT)": "能耗值点最近一小时趋势 ({{UNIT}})",
      "Circuit": "回路",
      "Point": "数据点",
      "Realtime Value": "实时值",
      //Meter Tracking
      "Meter List": "计量表列表",
      "Edit Meter": "编辑",
      "Start Value": "开始值",
      "End Value": "结束值",
      //Equipment Tracking
      "Equipment List": "设备列表",
      "Edit Equipment": "编辑",
      //Profile Dropdown
      "Feedback": "反馈",
      "Account Settings": "账号设置",
      "Logout": "退出",
      //Authentication
      "Log in": "登录",
      "Email address": "电子邮件地址",
      "Password": "密码",
      "Remember me": "记住我",
      "Logged in as ": "已登录 ",
      "Forget Password?": "忘记密码?",
      "Forgot your password?": "忘记你的密码?",
      "Enter your email and we'll send you a reset link": "输入电子邮件地址，我们会把重置链接发送给您",
      "Send reset link": "发送重置连接",
      "Thanks for using MyEMS!": "感谢您使用MyEMS!",
      "You are now successfully signed out": "您已成功退出",
      "Return to Login": "返回登录",
      "Please check your email!": "请查收您的电子邮件!",
      "An email has been sent to ": "一封电子邮件已经发送至 ",
      "Please click on the included link to reset your password": "请点击里面的链接重置您的密码",
      "An email with password reset link is sent to ": "一封包含密码重置链接的电子邮件已经发送至 ",
      "Change Password": "修改密码",
      "Old Password": "原密码",
      "New Password": "新密码",
      "Confirm Password": "重复新密码",
      "Update Password": "更新密码",
      "Password has been changed!": "密码已修改!",
      //notification
      "Notifications": "通知",
      "Mark all as read": "全部设为已读",
      "View all": "查看全部",
      "notification_NEW": "新的",
      "notification_EARLIER": "更早的",
      "Notification List": "通知列表",
      "Bulk actions": "批量操作",
      "Notification Subject": "主题",
      "Notification Created Datetime": "时间",
      "Notification Message": "内容",
      "Notification Status": "状态",
      "Notification Mark As Read": "标记为已读",
      "Notification Unread": "未读",
      "Notification Read": "已读",
      "Notification Archive": "存档",
      "Notification Delete": "删除",
      "Notification Apply": "应用",
      //Monitoring
      "Run Commands": "运行命令",
      "Fault Alarms": "故障报警",
      "Instantaneous Efficiency VALUE UNIT": "瞬时效率 {{VALUE}} {{UNIT}}",
      "Communication Status": "通信状态",
      "Equipment Status": "设备状态",
      "Communication Online": "在线",
      "Communication Offline": "离线",
      "Equipment Running": "运行",
      "Equipment Stopped": "停机",
      "Show Up to": "每页显示数量",
      "All": "全部",
      "FROM - TO of TOTAL Equipments": "当前显示{{FROM}} - {{TO}} 总计{{TOTAL}}台设备",
      //Advanced Reporting & Knowledge Base
      "Created Datetime": "生成时间",
      "File Format": "文件格式",
      "File Size": "文件大小",
      "Uploader": "上传者",
      "Upload Datetime": "上传时间",
      //Error
      "The page you're looking for is not found": "您要找的页面不存在",
      "Make sure the address is correct and that the page hasn't moved": "请确认地址正确且页面没有被移动",
      "If you think this is a mistake,": "如果您认为这是一个错误,",
      "contact us": "联系我们",
      "Take me home": "带我回首页",
      "Whoops, something went wrong!": "哦, 出错了！!",
      "Try refreshing the page, or going back and attempting the action again": "请尝试刷新页面, 或回退并再次尝试执行这个操作",
      "If this problem persists,": "如果问题依然存在,",
      //Tenant Bill
      "Lease Contract Number": "租赁合同号码",
      "Download": "下载",
      "Print": "打印",
      "Payment Notice": "付款通知书",
      "Bill To": "致",
      "Bill Number": "账单号码",
      "Bill Date": "账单日期",
      "Payment Due Date": "付款到期日",
      "Amount Payable": "应付款金额",
      "Billing Period Start": "结算期开始日期",
      "Billing Period End": "结算期结束日期",
      "Quantity": "数量",
      "Price": "价格",
      "Unit": "单位",
      "Amount": "金额",
      "Subtotal": "小计",
      "VAT Output Tax": "增值税销项税金",
      "Total Amount Payable": "应付金额合计",
      "Please make sure to pay on or before the payment due date above":"请确保在上述付款到期日或之前付款",
      "Send money to the following account": "汇款至以下账户",
      "Account Name": "账户名称",
      "Bank Name": "开户银行",
      "Bank Address": "银行地址",
      "RMB Account": "人民币账户",
      // button
      "Toggle Navigation": "切换导航",
      // API
      "API.ADMINISTRATOR_SESSION_NOT_FOUND": "Administrator session not found",
      "API.ADMINISTRATOR_SESSION_TIMEOUT": "Administrator session timeout",
      "API.ADVANCED_REPORT_NOT_FOUND": "Advanced report not found",
      "API.BAD_REQUEST": "Bad request",
      "API.CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER": "Cannot set existing submeter as master meter",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS": "Combined equipment equipment relation exists",
      "API.COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND": "Combined equipment equipment relation not found",
      "API.COMBINED_EQUIPMENT_METER_RELATION_EXISTS": "Combined equipment meter relation exists",
      "API.COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND": "Combined equipment meter relation not found",
      "API.COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Combined equipment name is already in use",
      "API.COMBINED_EQUIPMENT_NOT_FOUND": "Combined equipment not found",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Combined equipment offline meter relation exists",
      "API.COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Combined equipment offline meter relation not found",
      "API.COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Combined equipment parameter name is already in use",
      "API.COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Combined equipment parameter not found or not match",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Combined equipment virtual meter relation exists",
      "API.COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Combined equipment virtual meter relation not found",
      "API.CONTACT_NAME_IS_ALREADY_IN_USE": "Contact name is already in use",
      "API.CONTACT_NOT_FOUND": "Contact not found",
      "API.COST_CENTER_EXTERNAL_ID_EXISTS": "Cost center external id exists",
      "API.COST_CENTER_NAME_EXISTS": "Cost center name exists",
      "API.COST_CENTER_NOT_FOUND": "Cost center not found",
      "API.COST_FILE_NOT_FOUND": "Cost file not found",
      "API.DATA_SOURCE_NAME_IS_ALREADY_IN_USE": "Data source name is already in use",
      "API.DATA_SOURCE_NOT_FOUND": "Data source not found",
      "API.DATABASE_ERROR": "Database error",
      "API.DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE": "Distribution circuit name is already in use",
      "API.DISTRIBUTION_CIRCUIT_NOT_FOUND": "Distribution circuit not found",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS": "Distribution circuit point relation exists",
      "API.DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND": "Distribution circuit point relation not found",
      "API.DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE": "Distribution system name is already in use",
      "API.DISTRIBUTION_SYSTEM_NOT_FOUND": "Distribution system not found",
      "API.EMAIL_IS_ALREADY_IN_USE": "Email is already in use",
      "API.EMAIL_MESSAGE_NOT_FOUND": "Email message not found",
      "API.EMAIL_SERVER_HOST_IS_ALREADY_IN_USE": "Email server host is already in use",
      "API.EMAIL_SERVER_NOT_FOUND": "Email server not found",
      "API.EMPTY_VARIABLES_ARRAY": "Empty variables array",
      "API.ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE": "Energy category name is already in use",
      "API.ENERGY_CATEGORY_NOT_FOUND": "Energy category not found",
      "API.ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS": "Energy category used in energy items",
      "API.ENERGY_CATEGORY_USED_IN_METER": "Energy category used in meter",
      "API.ENERGY_CATEGORY_USED_IN_OFFLINE_METER": "Energy category used in offline meter",
      "API.ENERGY_CATEGORY_USED_IN_TARIFFS": "Energy category used in tariffs",
      "API.ENERGY_CATEGORY_USED_IN_VIRTUAL_METER": "Energy category used in virtual meter",
      "API.ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE": "Energy flow diagram link is already in use",
      "API.ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram link not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE": "Energy flow diagram name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE": "Energy flow diagram node name is already in use",
      "API.ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH": "Energy flow diagram node not found or not match",
      "API.ENERGY_FLOW_DIAGRAM_NOT_FOUND": "Energy flow diagram not found",
      "API.ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item does not belong to energy category",
      "API.ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY": "Energy item is not belong to energy category",
      "API.ENERGY_ITEM_NAME_IS_ALREADY_IN_USE": "Energy item name is already in use",
      "API.ENERGY_ITEM_NOT_FOUND": "Energy item not found",
      "API.ENERGY_ITEM_USED_IN_METER": "Energy item used in meter",
      "API.ENERGY_ITEM_USED_IN_OFFLINE_METER": "Energy item used in offline meter",
      "API.ENERGY_ITEM_USED_IN_VIRTUAL_METER": "Energy item used in virtual meter",
      "API.EQUIPMENT_METER_RELATION_EXISTS": "Equipment meter relation exists",
      "API.EQUIPMENT_METER_RELATION_NOT_FOUND": "Equipment meter relation not found",
      "API.EQUIPMENT_NAME_IS_ALREADY_IN_USE": "Equipment name is already in use",
      "API.EQUIPMENT_NOT_FOUND": "Equipment not found",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_EXISTS": "Equipment offline meter relation exists",
      "API.EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND": "Equipment offline meter relation not found",
      "API.EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE": "Equipment parameter name is already in use",
      "API.EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH": "Equipment parameter not found or not match",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS": "Equipment virtual meter relation exists",
      "API.EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND": "Equipment virtual meter relation not found",
      "API.ERROR": "Error",
      "API.EXCEPTION": "Exception",
      "API.FAILED_TO_RESTORE_COST_FILE": "Failed to restore cost file",
      "API.FAILED_TO_RESTORE_KNOWLEDGE_FILE": "Failed to restore knowledge file",
      "API.FAILED_TO_RESTORE_OFFLINE_METER_FILE": "Failed to restore offline meter file",
      "API.FAILED_TO_UPLOAD_COST_FILE": "Failed to upload cost file",
      "API.FAILED_TO_UPLOAD_KNOWLEDGE_FILE": "Failed to upload knowledge file",
      "API.FAILED_TO_UPLOAD_OFFLINE_METER_FILE": "Failed to upload offline meter file",
      "API.GATEWAY_NAME_IS_ALREADY_IN_USE": "Gateway name is already in use",
      "API.GATEWAY_NOT_FOUND": "Gateway not found",
      "API.INVALID_": "Invalid ",
      "API.INVALID_ADDRESS": "Invalid address",
      "API.INVALID_ADDRESS_VALUE": "Invalid address value",
      "API.INVALID_ADVANCED_REPORT_ID": "Invalid advanced report id",
      "API.INVALID_AREA_VALUE": "Invalid area value",
      "API.INVALID_BASE_PERIOD_END_DATETIME": "Invalid base period end datetime",
      "API.INVALID_BASE_PERIOD_START_DATETIME": "Invalid base period start datetime",
      "API.INVALID_BAUD_RATE": "Invalid baud rate",
      "API.INVALID_BUILDINGS_VALUE": "Invalid buildings value",
      "API.INVALID_CATEGORY": "Invalid category",
      "API.INVALID_CHANNEL": "Invalid channel",
      "API.INVALID_COMBINED_EQUIPMENT_ID": "Invalid combined equipment id",
      "API.INVALID_COMBINED_EQUIPMENT_NAME": "Invalid combined equipment name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_ID": "Invalid combined equipment parameter id",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME": "Invalid combined equipment parameter name",
      "API.INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE": "Invalid combined equipment parameter type",
      "API.INVALID_CONNECTION": "Invalid connection",
      "API.INVALID_CONSTANT_VALUE": "Invalid constant value",
      "API.INVALID_CONTACT_ID": "Invalid contact id",
      "API.INVALID_CONTACT_NAME": "Invalid contact name",
      "API.INVALID_COST_CENTER_ID": "Invalid cost center id",
      "API.INVALID_COST_FILE_ID": "Invalid cost file id",
      "API.INVALID_DATA_SOURCE_ID": "Invalid data source id",
      "API.INVALID_DATA_SOURCE_NAME": "Invalid data source name",
      "API.INVALID_DATA_SOURCE_PROTOCOL": "Invalid data source protocol",
      "API.INVALID_DENOMINATOR_METER_UUID": "Invalid denominator meter uuid",
      "API.INVALID_DISPLAY_NAME": "Invalid display name",
      "API.INVALID_DISTRIBUTION_CIRCUIT_ID": "Invalid distribution circuit id",
      "API.INVALID_DISTRIBUTION_CIRCUIT_NAME": "Invalid distribution circuit name",
      "API.INVALID_DISTRIBUTION_ROOM": "Invalid distribution room",
      "API.INVALID_DISTRIBUTION_SYSTEM_ID": "Invalid distribution system id",
      "API.INVALID_DISTRIBUTION_SYSTEM_NAME": "Invalid distribution system name",
      "API.INVALID_EMAIL": "Invalid email",
      "API.INVALID_EMAIL_MESSAGE_ID": "Invalid email message id",
      "API.INVALID_EMAIL_SERVER_HOST": "Invalid email server host",
      "API.INVALID_EMAIL_SERVER_ID": "Invalid email server id",
      "API.INVALID_END_DATE_FORMAT": "Invalid end date format",
      "API.INVALID_END_DATETIME": "Invalid end datetime",
      "API.INVALID_ENERGY_CATEGORY_ID": "Invalid energy category id",
      "API.INVALID_ENERGY_CATEGORY_NAME": "Invalid energy category name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_ID": "Invalid energy flow diagram id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID": "Invalid energy flow diagram link id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NAME": "Invalid energy flow diagram name",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID": "Invalid energy flow diagram node id",
      "API.INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME": "Invalid energy flow diagram node name",
      "API.INVALID_ENERGY_ITEM_ID": "Invalid energy item id",
      "API.INVALID_ENERGY_ITEM_NAME": "Invalid energy item name",
      "API.INVALID_EQUATION_IN_EXPRESSION": "Invalid equation in expression",
      "API.INVALID_EQUIPMENT_ID": "Invalid equipment id",
      "API.INVALID_equipment_ID": "Invalid equipment id",
      "API.INVALID_EQUIPMENT_NAME": "Invalid equipment name",
      "API.INVALID_EQUIPMENT_PARAMETER_ID": "Invalid equipment parameter id",
      "API.INVALID_EQUIPMENT_PARAMETER_NAME": "Invalid equipment parameter name",
      "API.INVALID_EQUIPMENT_PARAMETER_TYPE": "Invalid equipment parameter type",
      "API.INVALID_EXPRESSION": "Invalid expression",
      "API.INVALID_EXPRESSION_OBJECT": "Invalid expression object",
      "API.INVALID_FDD_CODE": "Invalid fdd code",
      "API.INVALID_FLOORS_VALUE": "Invalid floors value",
      "API.INVALID_FROM_ADDR": "Invalid from addr",
      "API.INVALID_GATEWAY_ID": "Invalid gateway id",
      "API.INVALID_GATEWAY_NAME": "Invalid gateway name",
      "API.INVALID_HOURLY_HIGH_LIMIT_VALUE": "Invalid hourly high limit value",
      "API.INVALID_HOURLY_LOW_LIMIT_VALUE": "Invalid hourly low limit value",
      "API.INVALID_IS_ADMIN_VALUE": "Invalid is admin value",
      "API.INVALID_IS_COUNTED_VALUE": "Invalid is counted value",
      "API.INVALID_IS_ENABLED": "Invalid is enabled",
      "API.INVALID_IS_HIDDEN": "Invalid is hidden",
      "API.INVALID_IS_IN_LEASE_VALUE": "Invalid is in lease value",
      "API.INVALID_IS_INPUT_COUNTED_VALUE": "Invalid is input counted value",
      "API.INVALID_IS_KEY_TENANT_VALUE": "Invalid is key tenant value",
      "API.INVALID_IS_OUTPUT_COUNTED_VALUE": "Invalid is output counted value",
      "API.INVALID_IS_OUTPUT_VALUE": "Invalid is output value",
      "API.INVALID_IS_TREND_VALUE": "Invalid is trend value",
      "API.INVALID_IS_VIRTUAL_VALUE": "Invalid is virtual value",
      "API.INVALID_KGCE": "Invalid kgce",
      "API.INVALID_KGCO2E": "Invalid kgco2e",
      "API.INVALID_KNOWLEDGE_FILE_ID": "Invalid knowledge file id",
      "API.INVALID_LATITUDE_VALUE": "Invalid latitude value",
      "API.INVALID_LEASE_NUMBER_VALUE": "Invalid lease number value",
      "API.INVALID_LONGITUDE_VALUE": "Invalid longitude value",
      "API.INVALID_LOW_LIMIT_VALUE": "Invalid low limit value",
      "API.INVALID_MASTER_METER_ID": "Invalid master meter id",
      "API.INVALID_MENU_ID": "Invalid menu id",
      "API.INVALID_MESSAGE_TEMPLATE": "Invalid message template",
      "API.INVALID_METER_ID": "Invalid meter id",
      "API.INVALID_METER_NAME": "Invalid meter name",
      "API.INVALID_METER_UUID": "Invalid meter uuid",
      "API.INVALID_NAME_VALUE": "Invalid name value",
      "API.INVALID_NEW_PASSWORD": "Invalid new password",
      "API.INVALID_NOTIFICATION_ID": "Invalid notification id",
      "API.INVALID_NUMERATOR_METER_UUID": "Invalid numerator meter uuid",
      "API.INVALID_OBJECT_TYPE": "Invalid object type",
      "API.INVALID_OFFLINE_METER_FILE_ID": "Invalid offline meter file id",
      "API.INVALID_OFFLINE_METER_ID": "Invalid offline meter id",
      "API.INVALID_OFFLINE_METER_NAME": "Invalid offline meter name",
      "API.INVALID_OLD_PASSWORD": "Invalid old password",
      "API.INVALID_PARENT_SPACE_ID": "Invalid parent space id",
      "API.INVALID_PASSWORD": "Invalid password",
      "API.INVALID_PEAK_CURRENT": "Invalid peak current",
      "API.INVALID_PEAK_LOAD": "Invalid peak load",
      "API.INVALID_PERIOD_TYPE": "Invalid period type",
      "API.INVALID_POINT_ID": "Invalid point id",
      "API.INVALID_POINT_NAME": "Invalid point name",
      "API.INVALID_PORT": "Invalid port",
      "API.INVALID_PRIORITY": "Invalid priority",
      "API.INVALID_PRIVILEGE": "Invalid privilege",
      "API.INVALID_PRIVILEGE_DATA": "Invalid privilege data",
      "API.INVALID_PRIVILEGE_ID": "Invalid privilege id",
      "API.INVALID_PRIVILEGE_NAME": "Invalid privilege name",
      "API.INVALID_RATIO_VALUE": "Invalid ratio value",
      "API.INVALID_REPLY": "Invalid reply",
      "API.INVALID_REPORTING_PERIOD_END_DATETIME": "Invalid reporting period end datetime",
      "API.INVALID_REPORTING_PERIOD_START_DATETIME": "Invalid reporting period start datetime",
      "API.INVALID_REQUIRES_AUTHENTICATION": "Invalid requires authentication",
      "API.INVALID_ROOMS_VALUE": "Invalid rooms value",
      "API.INVALID_RULE_ID": "Invalid rule id",
      "API.INVALID_RULE_NAME": "Invalid rule name",
      "API.INVALID_SENSOR_ID": "Invalid sensor id",
      "API.INVALID_SENSOR_NAME": "Invalid sensor name",
      "API.INVALID_SERIAL_PORT": "Invalid serial port",
      "API.INVALID_SESSION_PLEASE_RE_LOGIN": "Invalid session please re-login",
      "API.INVALID_SHOPFLOOR_ID": "Invalid shopfloor id",
      "API.INVALID_SHOPFLOOR_NAME": "Invalid shopfloor name",
      "API.INVALID_SOURCE_NODE_ID": "Invalid source node id",
      "API.INVALID_SPACE_ID": "Invalid space id",
      "API.INVALID_SPACE_NAME": "Invalid space name",
      "API.INVALID_START_DATE_FORMAT": "Invalid start date format",
      "API.INVALID_START_DATETIME": "Invalid start datetime",
      "API.INVALID_STATUS": "Invalid status",
      "API.INVALID_STORE_ID": "Invalid store id",
      "API.INVALID_STORE_NAME": "Invalid store name",
      "API.INVALID_STORE_TYPE_DESCRIPTION": "Invalid store type description",
      "API.INVALID_STORE_TYPE_ID": "Invalid store type id",
      "API.INVALID_STORE_TYPE_NAME": "Invalid store type name",
      "API.INVALID_STORE_TYPE_SIMPLIFIED_CODE": "Invalid store type simplified code",
      "API.INVALID_SVG": "Invalid svg",
      "API.INVALID_SWITCHGEAR": "Invalid switchgear",
      "API.INVALID_TARGET_NODE_ID": "Invalid target node id",
      "API.INVALID_TARIFF_BLOCK_PRICING": "Invalid tariff block pricing",
      "API.INVALID_TARIFF_ID": "Invalid tariff id",
      "API.INVALID_TARIFF_TIME_OF_USE_PRICING": "Invalid tariff time of use pricing",
      "API.INVALID_TARIFF_TYPE": "Invalid tariff type",
      "API.INVALID_TENANT_ID": "Invalid tenant id",
      "API.INVALID_TENANT_NAME": "Invalid tenant name",
      "API.INVALID_TENANT_TYPE_DESCRIPTION": "Invalid tenant type description",
      "API.INVALID_TENANT_TYPE_ID": "Invalid tenant type id",
      "API.INVALID_TENANT_TYPE_NAME": "Invalid tenant type name",
      "API.INVALID_TENANT_TYPE_SIMPLIFIED_CODE": "Invalid tenant type simplified code",
      "API.INVALID_TEXT_MESSAGE_ID": "Invalid text message id",
      "API.INVALID_TIMEZONE_ID": "Invalid timezone id",
      "API.INVALID_TOKEN": "Invalid token",
      "API.INVALID_UNIT_OF_MEASURE": "Invalid unit of measure",
      "API.INVALID_UNIT_OF_PRICE": "Invalid unit of price",
      "API.INVALID_UNITS": "Invalid units",
      "API.INVALID_USER_ID": "Invalid user id",
      "API.INVALID_USER_NAME": "Invalid user name",
      "API.INVALID_USER_NAME_OR_EMAIL": "Invalid user name or email",
      "API.INVALID_USER_PHONE": "Invalid user phone",
      "API.INVALID_USER_PLEASE_RE_LOGIN": "Invalid user please re-login",
      "API.INVALID_USER_UUID": "Invalid user uuid",
      "API.INVALID_VARIABLE_METER_ID": "Invalid variable meter id",
      "API.INVALID_VARIABLE_METER_TYPE": "Invalid variable meter type",
      "API.INVALID_VARIABLE_NAME": "Invalid variable name",
      "API.INVALID_VIRTUAL_METER_ID": "Invalid virtual meter id",
      "API.INVALID_VIRTUAL_METER_NAME": "Invalid virtual meter name",
      "API.INVALID_WEB_MESSAGE_ID": "Invalid web message id",
      "API.INVALID_WECHAT_MESSAGE_ID": "Invalid wechat message id",
      "API.KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK": "Knowledge File Cannot be Removed from Disk",
      "API.KNOWLEDGE_FILE_NOT_FOUND": "Knowledge file not found",
      "API.MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY": "Master meter does not belong to same energy category",
      "API.MASTER_METER_NOT_FOUND": "Master meter not found",
      "API.MENU_NOT_FOUND": "Menu not found",
      "API.METER_NAME_IS_ALREADY_IN_USE": "Meter name is already in use",
      "API.METER_NOT_FOUND": "Meter not found",
      "API.METER_OF_VARIABLE_NOT_FOUND": "Meter of variable not found",
      "API.METER_POINT_RELATION_EXISTS": "Meter point relation exists",
      "API.METER_POINT_RELATION_NOT_FOUND": "Meter point relation not found",
      "API.NOT_FOUND": "Not found",
      "API.NOTIFICATION_NOT_FOUND": "Notification not found",
      "API.OFFLINE_METER_FILE_NOT_FOUND": "Offline meter file not found",
      "API.OFFLINE_METER_NAME_IS_ALREADY_IN_USE": "Offline meter name is already in use",
      "API.OFFLINE_METER_NOT_FOUND": "Offline meter not found",
      "API.OFFLINE_METER_OF_VARIABLE_NOT_FOUND": "Offline meter of variable not found",
      "API.PARENT_SPACE_NOT_FOUND": "Parent space not found",
      "API.POINT_NAME_IS_ALREADY_IN_USE": "Point name is already in use",
      "API.POINT_NOT_FOUND": "Point not found",
      "API.PRIVILEGE_NAME_IS_ALREADY_IN_USE": "Privilege name is already in use",
      "API.PRIVILEGE_NOT_FOUND": "Privilege not found",
      "API.RULE_NAME_IS_ALREADY_IN_USE": "Rule name is already in use",
      "API.RULE_NOT_FOUND": "Rule not found",
      "API.SENSOR_NAME_IS_ALREADY_IN_USE": "Sensor name is already in use",
      "API.SENSOR_NOT_FOUND": "Sensor not found",
      "API.SENSOR_POINT_RELATION_EXISTS": "Sensor point relation exists",
      "API.SENSOR_POINT_RELATION_NOT_FOUND": "Sensor point relation not found",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_EXISTS": "Shopfloor equipment relation exists",
      "API.SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND": "Shopfloor equipment relation not found",
      "API.SHOPFLOOR_METER_RELATION_EXISTS": "Shopfloor meter relation exists",
      "API.SHOPFLOOR_METER_RELATION_NOT_FOUND": "Shopfloor meter relation not found",
      "API.SHOPFLOOR_NAME_IS_ALREADY_IN_USE": "Shopfloor name is already in use",
      "API.SHOPFLOOR_NOT_FOUND": "Shopfloor not found",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS": "Shopfloor offline meter relation exists",
      "API.SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND": "Shopfloor offline meter relation not found",
      "API.SHOPFLOOR_POINT_RELATION_EXISTS": "Shopfloor point relation exists",
      "API.SHOPFLOOR_POINT_RELATION_NOT_FOUND": "Shopfloor point relation not found",
      "API.SHOPFLOOR_SENSOR_RELATION_EXISTS": "Shopfloor sensor relation exists",
      "API.SHOPFLOOR_SENSOR_RELATION_NOT_FOUND": "Shopfloor sensor relation not found",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS": "Shopfloor virtual meter relation exists",
      "API.SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND": "Shopfloor virtual meter relation not found",
      "API.SOURCE_NODE_NOT_FOUND": "Source node not found",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS": "Space combined equipment relation exists",
      "API.SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND": "Space combined equipment relation not found",
      "API.SPACE_EQUIPMENT_RELATION_EXISTS": "Space equipment relation exists",
      "API.SPACE_EQUIPMENT_RELATION_NOT_FOUND": "Space equipment relation not found",
      "API.SPACE_METER_RELATION_EXISTS": "Space meter relation exists",
      "API.SPACE_METER_RELATION_NOT_FOUND": "Space meter relation not found",
      "API.SPACE_NAME_IS_ALREADY_IN_USE": "Space name is already in use",
      "API.SPACE_NOT_FOUND": "Space not found",
      "API.SPACE_NOT_FOUND_IN_PRIVILEGE": "Space not found in privilege",
      "API.SPACE_OFFLINE_METER_RELATION_EXISTS": "Space offline meter relation exists",
      "API.SPACE_OFFLINE_METER_RELATION_NOT_FOUND": "Space offline meter relation not found",
      "API.SPACE_POINT_RELATION_EXISTS": "Space point relation exists",
      "API.SPACE_POINT_RELATION_NOT_FOUND": "Space point relation not found",
      "API.SPACE_SENSOR_RELATION_EXISTS": "Space sensor relation exists",
      "API.SPACE_SENSOR_RELATION_NOT_FOUND": "Space sensor relation not found",
      "API.SPACE_SHOPFLOOR_RELATION_EXISTS": "Space shopfloor relation exists",
      "API.SPACE_SHOPFLOOR_RELATION_NOT_FOUND": "Space shopfloor relation not found",
      "API.SPACE_STORE_RELATION_EXISTS": "Space store relation exists",
      "API.SPACE_STORE_RELATION_NOT_FOUND": "Space store relation not found",
      "API.SPACE_TENANT_RELATION_EXISTS": "Space tenant relation exists",
      "API.SPACE_TENANT_RELATION_NOT_FOUND": "Space tenant relation not found",
      "API.SPACE_VIRTUAL_METER_RELATION_EXISTS": "Space virtual meter relation exists",
      "API.SPACE_VIRTUAL_METER_RELATION_NOT_FOUND": "Space virtual meter relation not found",
      "API.START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME": "Start datetime must be early than end datetime",
      "API.STORE_METER_RELATION_EXISTS": "Store meter relation exists",
      "API.STORE_METER_RELATION_NOT_FOUND": "Store meter relation not found",
      "API.STORE_NAME_IS_ALREADY_IN_USE": "Store name is already in use",
      "API.STORE_NOT_FOUND": "Store not found",
      "API.STORE_OFFLINE_METER_RELATION_EXISTS": "Store offline meter relation exists",
      "API.STORE_OFFLINE_METER_RELATION_NOT_FOUND": "Store offline meter relation not found",
      "API.STORE_POINT_RELATION_EXISTS": "Store point relation exists",
      "API.STORE_POINT_RELATION_NOT_FOUND": "Store point relation not found",
      "API.STORE_SENSOR_RELATION_EXISTS": "Store sensor relation exists",
      "API.STORE_SENSOR_RELATION_NOT_FOUND": "Store sensor relation not found",
      "API.STORE_TYPE_NAME_IS_ALREADY_IN_USE": "Store type name is already in use",
      "API.STORE_TYPE_NOT_FOUND": "Store type not found",
      "API.STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Store type simplified code is already in use",
      "API.STORE_TYPE_USED_IN_STORE": "Store type used in store",
      "API.STORE_VIRTUAL_METER_RELATION_EXISTS": "Store virtual meter relation exists",
      "API.STORE_VIRTUAL_METER_RELATION_NOT_FOUND": "Store virtual meter relation not found",
      "API.TARGET_NODE_NOT_FOUND": "Target node not found",
      "API.TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER": "Tariff is already associated with cost center",
      "API.TARIFF_IN_USE": "Tariff in use",
      "API.TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER": "Tariff is not associated with cost center",
      "API.TARIFF_NAME_IS_ALREADY_IN_USE": "Tariff name is already in use",
      "API.TARIFF_NOT_EMPTY": "Tariff not empty",
      "API.TARIFF_NOT_FOUND": "Tariff not found",
      "API.TENANT_METER_RELATION_EXISTS": "Tenant meter relation exists",
      "API.TENANT_METER_RELATION_NOT_FOUND": "Tenant meter relation not found",
      "API.TENANT_NAME_IS_ALREADY_IN_USE": "Tenant name is already in use",
      "API.TENANT_NOT_FOUND": "Tenant not found",
      "API.TENANT_OFFLINE_METER_RELATION_EXISTS": "Tenant offline meter relation exists",
      "API.TENANT_OFFLINE_METER_RELATION_NOT_FOUND": "Tenant offline meter relation not found",
      "API.TENANT_POINT_RELATION_EXISTS": "Tenant point relation exists",
      "API.TENANT_POINT_RELATION_NOT_FOUND": "Tenant point relation not found",
      "API.TENANT_SENSOR_RELATION_EXISTS": "Tenant sensor relation exists",
      "API.TENANT_SENSOR_RELATION_NOT_FOUND": "Tenant sensor relation not found",
      "API.TENANT_TYPE_NAME_IS_ALREADY_IN_USE": "Tenant type name is already in use",
      "API.TENANT_TYPE_NOT_FOUND": "Tenant type not found",
      "API.TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE": "Tenant type simplified code is already in use",
      "API.TENANT_TYPE_USED_IN_TENANT": "Tenant type used in tenant",
      "API.TENANT_VIRTUAL_METER_RELATION_EXISTS": "Tenant virtual meter relation exists",
      "API.TENANT_VIRTUAL_METER_RELATION_NOT_FOUND": "Tenant virtual meter relation not found",
      "API.TEXT_MESSAGE_NOT_FOUND": "Text message not found",
      "API.THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES": "The reporting period must be longer than 15 minutes",
      "API.THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS": "There is associated distribution circuits",
      "API.THERE_IS_RELATION_WITH_CHILD_METERS": "There is relation with child meters",
      "API.THERE_IS_RELATION_WITH_CHILDREN_SPACES": "There is relation with children spaces",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS": "There is relation with combined equipment parameters",
      "API.THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS": "There is relation with combined equipments",
      "API.THERE_IS_RELATION_WITH_DATA_SOURCES": "There is relation with data sources",
      "API.THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS": "There is relation with energy flow diagram links",
      "API.THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS": "There is relation with equipment parameters",
      "API.THERE_IS_RELATION_WITH_EQUIPMENTS": "There is relation with equipments",
      "API.THERE_IS_RELATION_WITH_METER": "There is relation with meter",
      "API.THERE_IS_RELATION_WITH_METERS": "There is relation with meters",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METER": "There is relation with offline meter",
      "API.THERE_IS_RELATION_WITH_OFFLINE_METERS": "There is relation with offline meters",
      "API.THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS": "There is relation with other virtual meters",
      "API.THERE_IS_RELATION_WITH_POINTS": "There is relation with points",
      "API.THERE_IS_RELATION_WITH_SENSORS": "There is relation with sensors",
      "API.THERE_IS_RELATION_WITH_SHOPFLOORS": "There is relation with shopfloors",
      "API.THERE_IS_RELATION_WITH_SPACES": "There is relation with spaces",
      "API.THERE_IS_RELATION_WITH_STORES": "There is relation with stores",
      "API.THERE_IS_RELATION_WITH_TARIFFS": "There is relation with tariffs",
      "API.THERE_IS_RELATION_WITH_TENANTS": "There is relation with tenants",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METER": "There is relation with virtual meter",
      "API.THERE_IS_RELATION_WITH_VIRTUAL_METERS": "There is relation with virtual meters",
      "API.THERE_IS_RELATION_WITH_USERS": "There is relation with users",
      "API.THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER": "This data source is being used by a meter",
      "API.THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This meter is being used by a virtual meter",
      "API.THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER": "This offline meter is being used by a virtual meter",
      "API.THIS_SHOPFLOOR_CANNOT_BE_DELETED": "This shopfloor cannot be deleted",
      "API.THIS_SPACE_CANNOT_BE_DELETED": "This space cannot be deleted",
      "API.TIMEZONE_NOT_FOUND": "Timezone not found",
      "API.TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "Token not found in headers please login",
      "API.USER_ACCOUNT_HAS_EXPIRED": "User Account Has Expired",
      "API.USER_NAME_IS_ALREADY_IN_USE": "User name is already in use",
      "API.USER_NOT_FOUND": "User not found",
      "API.USER_PASSWORD_HAS_EXPIRED": "User Password Has Expired",
      "API.USER_PRIVILEGE_NOT_FOUND": "User privilege not found",
      "API.USER_SESSION_NOT_FOUND": "User session not found",
      "API.USER_SESSION_TIMEOUT": "User session timeout",
      "API.USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN": "User uuid not found in headers please login",
      "API.VIRTUAL_METER_NAME_IS_ALREADY_IN_USE": "Virtual meter name is already in use",
      "API.VIRTUAL_METER_NOT_FOUND": "Virtual meter not found",
      "API.VIRTUAL_METER_OF_VARIABLE_NOT_FOUND": "Virtual meter of variable not found",
      "API.VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE": "Virtual point should be analog value",
      "API.WEB_MESSAGE_NOT_FOUND": "Web message not found",
      "API.WECHAT_MESSAGE_NOT_FOUND": "Wechat message not found",

    }
  }
};

i18n
  .use(initReactI18next) // passes i18n down to react-i18next
  .init({
    resources,
    lng: "zh_CN",

    keySeparator: false, // we do not use keys in form messages.welcome

    interpolation: {
      escapeValue: false // react already safes from xss
    }
  });

  export default i18n;
