/*
  filename: angular.integralui.treeview.min.js
  version : 3.3.445
  Copyright � 2014-2018 Lidor Systems. All rights reserved.

  This file is part of the "IntegralUI" Library. 
                                                                   
  The contents of this file are subject to the IntegralUI Studio for Web License, and may not be used except in compliance with the License.
  A copy of the License should have been installed in the product's root installation directory or it can be found at
  http://www.lidorsystems.com/products/web/studio/license-agreement.aspx.
                                                            
  This SOFTWARE is provided "AS IS", WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language 
  governing rights and limitations under the License. Any infringement will be prosecuted under applicable laws.                           
*/
angular
  .module("integralui")
  .factory("IntegralUITreeViewService", [
    "$rootScope",
    function(c) {
      var q = null;
      return {
        addItem: function(e, l, n) {
          c.$broadcast(e + "-add-item", l, n);
        },
        clearItems: function(e, l) {
          c.$broadcast(e + "-clear-items", l);
        },
        insertItemAt: function(e, l, n, f) {
          c.$broadcast(e + "-insert-item-at", l, n, f);
        },
        insertItemBefore: function(e, l, n) {
          c.$broadcast(e + "-insert-item-before", l, n);
        },
        insertItemAfter: function(e, l, n) {
          c.$broadcast(e + "-insert-item-after", l, n);
        },
        removeItem: function(e, l) {
          c.$broadcast(e + "-remove-item", l);
        },
        removeItemAt: function(e, l, n) {
          c.$broadcast(e + "-remove-item-at", l, n);
        },
        exportToJSON: function(e, l, n, f) {
          c.$broadcast(e + "-export-json", l, n, f);
          e = this.getTempData();
          this.clearTempData();
          return e ? e : "";
        },
        loadData: function(e, l, n, f, k) {
          c.$broadcast(e + "-load-data", l, n, f, k);
          l = this.getTempData();
          this.clearTempData();
          return l ? l : null;
        },
        openEditor: function(e, l) {
          c.$broadcast(e + "-open-editor", l);
        },
        closeEditor: function(e, l) {
          c.$broadcast(e + "-close-editor", l);
        },
        collapse: function(e, l) {
          c.$broadcast(e + "-collapse", l);
        },
        expand: function(e, l) {
          c.$broadcast(e + "-expand", l);
        },
        toggle: function(e, l) {
          c.$broadcast(e + "-toggle", l);
        },
        findItemById: function(e, l) {
          c.$broadcast(e + "-find-item-by-id", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : null;
        },
        findItemByText: function(e, l) {
          c.$broadcast(e + "-find-item-by-text", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : null;
        },
        getItemParent: function(e, l) {
          c.$broadcast(e + "-get-item-parent", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : null;
        },
        getItemAt: function(e, l) {
          c.$broadcast(e + "-get-item-at", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : null;
        },
        filter: function(e, l) {
          c.$broadcast(e + "-filter", l);
        },
        focus: function(e, l) {
          c.$broadcast(e + "-focus", l);
        },
        clearTempData: function() {
          q = null;
        },
        ensureVisible: function(e, l, n) {
          c.$broadcast(e + "-ensure-visible", l, n);
        },
        getCheckList: function(e, l) {
          c.$broadcast(e + "-get-check-list", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : [];
        },
        getItemLevel: function(e, l) {
          c.$broadcast(e + "-get-item-level", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : 0;
        },
        getFlatList: function(e, l) {
          c.$broadcast(e + "-get-flat-list", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : [];
        },
        getFullPath: function(e, l) {
          c.$broadcast(e + "-get-full-path", l);
          var n = this.getTempData();
          this.clearTempData();
          return n ? n : "";
        },
        getList: function(e, l, n) {
          c.$broadcast(e + "-get-list", l, n);
          e = this.getTempData();
          this.clearTempData();
          return e ? e : [];
        },
        getTempData: function() {
          return q;
        },
        setTempData: function(c) {
          q = c;
        },
        beginLoad: function(e, l, n) {
          c.$broadcast(e + "-begin-load", l, n);
        },
        endLoad: function(e, l) {
          c.$broadcast(e + "-end-load", l);
        },
        moveItem: function(e, l, n, f, k) {
          c.$broadcast(e + "-move-item", l, n, f, k);
        },
        clearSelection: function(e) {
          c.$broadcast(e + "-clear-selection");
        },
        selectedItem: function(e, l) {
          if (l) c.$broadcast(e + "-set-selected-item", l);
          else {
            c.$broadcast(e + "-get-selected-item");
            var n = this.getTempData();
            this.clearTempData();
            return n ? n : null;
          }
        },
        selectedItems: function(e, l) {
          if (l) c.$broadcast(e + "-set-selected-items", l);
          else {
            c.$broadcast(e + "-get-selected-items");
            var n = this.getTempData();
            this.clearTempData();
            return n ? n : null;
          }
        },
        getScrollPos: function(e) {
          c.$broadcast(e + "-get-scroll-pos");
          e = this.getTempData();
          this.clearTempData();
          return e ? e : { x: 0, y: 0 };
        },
        setScrollPos: function(e, l) {
          c.$broadcast(e + "-set-scroll-pos", l);
        },
        scrollTo: function(e, l, n) {
          c.$broadcast(e + "-scroll-to", l, n);
        },
        sort: function(e, l, n) {
          c.$broadcast(e + "-sort", l, n);
        },
        updateCheckValues: function(e, l) {
          c.$broadcast(e + "-update-check", l);
        },
        refresh: function(e, l, n) {
          c.$broadcast(e + "-refresh", l, n);
        },
        resumeLayout: function(e) {
          c.$broadcast(e + "-resume-layout");
        },
        suspendLayout: function(e) {
          c.$broadcast(e + "-suspend-layout");
        },
        updateLayout: function(e) {
          c.$broadcast(e + "-update-layout");
        },
        updateView: function(e) {
          c.$broadcast(e + "-update-view");
        }
      };
    }
  ])
  .controller("IntegralUITreeViewController", [
    "$scope",
    "$element",
    "$timeout",
    "$window",
    "$q",
    "IntegralUIInternalService",
    "IntegralUIDataService",
    "IntegralUITreeViewService",
    "IntegralUIDragDrop",
    "IntegralUIFilter",
    function(c, q, e, l, n, f, k, m, U, a) {
      var b = this;
      b.hoverItem = null;
      this.suppressProcess = !1;
      b.defaultCheckBoxStyle = {
        general: "iui-checkbox",
        box: {
          general: "iui-checkbox-box",
          disabled: "iui-checkbox-box-disabled",
          checked: "iui-checkbox-checked",
          indeterminate: "iui-checkbox-indeterminate",
          unchecked: "iui-checkbox-unchecked"
        }
      };
      b.defaultStyle = {
        general: "iui-treeview",
        item: {
          general: {
            disabled: "iui-treeview-item-disabled",
            focused: "iui-treeview-item-focused",
            normal: "iui-treeview-item",
            hovered: "iui-treeview-item-hovered",
            selected: "iui-treeview-item-selected"
          },
          checkBox: {
            general: "iui-checkbox",
            box: {
              general: "iui-checkbox-box",
              disabled: "iui-checkbox-box-disabled",
              checked: "iui-checkbox-checked",
              indeterminate: "iui-checkbox-indeterminate",
              unchecked: "iui-checkbox-unchecked"
            }
          },
          expandBox: {
            general: "iui-treeview-expand-box",
            animated: "iui-treeview-expand-box-load",
            expanded: "iui-treeview-expand-box-open",
            collapsed: "iui-treeview-expand-box-close"
          },
          content: {
            disabled: "iui-treeview-item-content-disabled",
            focused: "iui-treeview-item-content-focused",
            normal: "iui-treeview-item-content",
            hovered: "iui-treeview-item-content-hovered",
            selected: "iui-treeview-item-content-selected"
          },
          fixed: {
            disabled: "iui-treeview-item-fixed-disabled",
            normal: "iui-treeview-item-fixed",
            hovered: "iui-treeview-item-fixed-hovered"
          }
        }
      };
      b.defaultCheckBoxSettings = {
        autoCheck: !1,
        style: b.defaultCheckBoxStyle,
        threeState: !1
      };
      this.updateOptions = function(d) {
        d
          ? ((b.options = {
              allowAnimation: f.isFieldAvailable(d.allowAnimation, !0),
              allowDrag: f.isFieldAvailable(d.allowDrag, !1),
              allowDrop: f.isFieldAvailable(d.allowDrop, !0),
              allowFocus: f.isFieldAvailable(d.allowFocus, !0),
              animationSpeed: 200,
              autoCheck: f.isFieldAvailable(d.autoCheck, !1),
              autoExpand: f.isFieldAvailable(d.autoExpand, !0),
              autoSize: f.isFieldAvailable(d.autoSize, !1),
              autoUpdate: f.isFieldAvailable(d.autoUpdate, !0),
              checkBoxSettings: b.defaultCheckBoxSettings,
              controlStyle: b.defaultStyle,
              editorSettings: { activate: "click" },
              enabled: f.isFieldAvailable(d.enabled, !0),
              hoverSelection: f.isFieldAvailable(d.hoverSelection, !1),
              indent: f.isFieldAvailable(d.indent, 15),
              itemIcon: f.isFieldAvailable(d.itemIcon, ""),
              itemSpacing: f.isFieldAvailable(d.itemSpacing, 1),
              labelEdit: f.isFieldAvailable(d.labelEdit, !1),
              loadItems: [],
              maxItems: f.isFieldAvailable(d.maxItems, 0),
              mouseWheelSpeed: f.isFieldAvailable(d.mouseWheelSpeed, "normal"),
              pathSeparator: f.isFieldAvailable(d.pathSeparator, "\\"),
              rtl: f.isFieldAvailable(d.rtl, !1),
              selectedIndex: -1,
              selectedItem: f.isFieldAvailable(
                d.selectedItem,
                b.options.selectedItem ? b.options.selectedItem : null
              ),
              selectedItems: [],
              selectionMode: f.isFieldAvailable(d.selectionMode, "one"),
              showCheckBoxes: f.isFieldAvailable(d.showCheckBoxes, !1),
              showExpandBoxes: f.isFieldAvailable(d.showExpandBoxes, !0),
              showIcons: f.isFieldAvailable(d.showIcons, !0),
              showLines: f.isFieldAvailable(d.showLines, !1),
              showStatusIcons: f.isFieldAvailable(d.showStatusIcons, !1),
              sorting: f.isFieldAvailable(d.sorting, "none")
            }),
            b.updateDataFields(d.dataFields),
            b.updateControlStyle(d.controlStyle),
            b.updateCheckBoxSettings(d.checkBoxSettings),
            b.updateTemplateSettings(d.templateSettings))
          : ((b.options = {
              allowAnimation: !0,
              allowDrag: !1,
              allowDrop: !0,
              allowFocus: !0,
              animationSpeed: 200,
              autoCheck: !1,
              autoExpand: !0,
              autoSize: !1,
              autoUpdate: !0,
              checkBoxSettings: b.defaultCheckBoxSettings,
              controlStyle: b.defaultStyle,
              editorSettings: { activate: "click" },
              enabled: !0,
              hoverSelection: !1,
              indent: 15,
              itemIcon: "",
              itemSpacing: 1,
              labelEdit: !1,
              loadItems: [],
              maxItems: 0,
              mouseWheelSpeed: "normal",
              pathSeparator: "\\",
              rtl: !1,
              selectedIndex: -1,
              selectedItem: null,
              selectedItems: [],
              selectionMode: "one",
              showCheckBoxes: !1,
              showExpandBoxes: !0,
              showIcons: !0,
              showLines: !1,
              showStatusIcons: !1,
              sorting: "none",
              templateSettings: { url: null }
            }),
            b.updateDataFields());
      };
      b.options = {};
      this.updateDataFields = function(d) {
        b.options.dataFields = d
          ? {
              allowDrag: d.allowDrag ? d.allowDrag : "allowDrag",
              allowDrop: d.allowDrop ? d.allowDrop : "allowDrop",
              allowEdit: d.allowEdit ? d.allowEdit : "allowEdit",
              allowFocus: d.allowFocus ? d.allowFocus : "allowFocus",
              autoCheck: d.autoCheck ? d.autoCheck : "autoCheck",
              checkBoxSettings: d.checkBoxSettings
                ? d.checkBoxSettings
                : "checkBoxSettings",
              checked: d.checked ? d.checked : "checked",
              checkState: d.checkState ? d.checkState : "checkState",
              content: d.content ? d.content : "content",
              contextMenu: d.contextMenu ? d.contextMenu : "contextMenu",
              enabled: d.enabled ? d.enabled : "enabled",
              expanded: d.expanded ? d.expanded : "expanded",
              fixed: d.fixed ? d.fixed : "fixed",
              fixChildren: d.fixChildren ? d.fixChildren : "fixChildren",
              hasChildren: d.hasChildren ? d.hasChildren : "hasChildren",
              icon: d.icon ? d.icon : "icon",
              id: d.id ? d.id : "id",
              items: d.items ? d.items : "items",
              pid: d.pid ? d.pid : "pid",
              selected: d.selected ? d.selected : "selected",
              showCheckBox: d.showCheckBox ? d.showCheckBox : "showCheckBox",
              statusIcon: d.statusIcon ? d.statusIcon : "statusIcon",
              style: d.style ? d.style : "style",
              templateObj: d.templateObj ? d.templateObj : "templateObj",
              text: d.text ? d.text : "text",
              tooltip: d.tooltip ? d.tooltip : "tooltip",
              value: d.value ? d.value : "value",
              visible: d.visible ? d.visible : "visible"
            }
          : {
              allowDrag: "allowDrag",
              allowDrop: "allowDrop",
              allowEdit: "allowEdit",
              allowFocus: "allowFocus",
              autoCheck: "autoCheck",
              checkBoxSettings: "checkBoxSettings",
              checked: "checked",
              checkState: "checkState",
              content: "content",
              contextMenu: "contextMenu",
              enabled: "enabled",
              expanded: "expanded",
              fixed: "fixed",
              fixChildren: "fixChildren",
              hasChildren: "hasChildren",
              icon: "icon",
              id: "id",
              items: "items",
              pid: "pid",
              selected: "selected",
              showCheckBox: "showCheckBox",
              statusIcon: "statusIcon",
              style: "style",
              templateObj: "templateObj",
              text: "text",
              tooltip: "tooltip",
              value: "value",
              visible: "visible"
            };
        b.dataObj &&
          b.dataObj.updateDataFields(b.getDataFields(b.options.dataFields));
      };
      this.updateTemplateSettings = function(d) {
        b.options.templateSettings = d
          ? {
              display: f.isFieldAvailable(d.display, "block"),
              url: f.isFieldAvailable(d.url, null)
            }
          : { display: "block", url: null };
      };
      b.updateOptions();
      c.$on(c.name + "-add-item", function(d, a, c) {
        b.dataObj.insertAt(a, -1, c, b.itemIsAdded);
      });
      c.$on(c.name + "-clear-items", function(d, a) {
        b.dataObj.clear(a, b.listIsCleared);
      });
      c.$on(c.name + "-insert-item-at", function(d, a, c, r) {
        b.dataObj.insertAt(a, c, r, b.itemIsAdded);
      });
      c.$on(c.name + "-insert-item-after", function(d, a, c) {
        b.dataObj.insertByRef(a, c, !0, b.itemIsAdded);
      });
      c.$on(c.name + "-insert-item-before", function(d, a, c) {
        b.dataObj.insertByRef(a, c, !1, b.itemIsAdded);
      });
      c.$on(c.name + "-remove-item", function(d, a) {
        b.dataObj.removeAt(a, -1, null, b.itemIsRemoved);
      });
      c.$on(c.name + "-remove-item-at", function(d, a, c) {
        b.dataObj.removeAt(null, a, c, b.itemIsRemoved);
      });
      this.listIsCleared = function(d) {
        d ||
          (b.clearPrevSelection(),
          (b.options.selectedItem = null),
          b.setScrollPos({ x: 0, y: 0 }));
        b.updateCurrentLayout();
      };
      this.itemIsAdded = function() {
        b.updateCurrentLayout();
      };
      this.itemIsRemoved = function(d) {
        d &&
          ((d[b.options.dataFields.selected] = !1),
          d == b.options.selectedItem && (b.options.selectedItem = null));
        b.updateCurrentLayout();
      };
      this.objIsRemoved = function() {
        b.updateCurrentLayout();
      };
      this.getCheckValue = function(d) {
        return "checked" == d[b.options.dataFields.checkState]
          ? "checked"
          : 1 == b.options.checkBoxSettings.threeState &&
            "indeterminate" == d[b.options.dataFields.checkState]
          ? "indeterminate"
          : "unchecked";
      };
      this.changeCheckValue = function(d) {
        if (
          1 == b.options.autoCheck ||
          1 == b.options.checkBoxSettings.autoCheck
        ) {
          var a = b.getCheckValue(d);
          if (
            !1 !==
            (1 == b.options.checkBoxSettings.threeState
              ? b.callCheckValueChanging(d, a)
              : b.callCheckValueChanging(d, "checked" == a ? !0 : !1))
          ) {
            if (1 == b.options.checkBoxSettings.threeState)
              switch (a) {
                case "checked":
                  a = "unchecked";
                  break;
                case "indeterminate":
                  a = "checked";
                  break;
                case "unchecked":
                  a = "indeterminate";
              }
            else
              a =
                "unchecked" == a || "indeterminate" == a
                  ? "checked"
                  : "unchecked";
            d[b.options.dataFields.checkState] = a;
            d[b.options.dataFields.checked] = "checked" == a ? !0 : !1;
            c.$apply();
          }
        }
      };
      this.callCheckValueChanging = function(d, a) {
        var h = !0;
        b.allowEvents &&
          (h =
            1 == b.options.checkBoxSettings.threeState
              ? angular.isDefined(c.events) && c.events.itemCheckstateChanging
                ? c.events.itemCheckstateChanging({ item: d, value: a })
                : c.itemCheckstateChanging({ e: { item: d, value: a } })
              : angular.isDefined(c.events) && c.events.itemCheckedChanging
              ? c.events.itemCheckedChanging({ item: d, value: a })
              : c.itemCheckedChanging({ e: { item: d, value: a } }));
        return h;
      };
      this.callCheckValueChanged = function(d, a) {
        b.allowEvents &&
          (retValue =
            1 == b.options.checkBoxSettings.threeState
              ? angular.isDefined(c.events) && c.events.itemCheckstateChanged
                ? c.events.itemCheckstateChanged({ item: d, value: a })
                : c.itemCheckstateChanged({ e: { item: d, value: a } })
              : angular.isDefined(c.events) && c.events.itemCheckedChanged
              ? c.events.itemCheckedChanged({ item: d, value: a })
              : c.itemCheckedChanged({ e: { item: d, value: a } }));
      };
      var w = [],
        H = !1;
      this.fillCheckList = function(d) {
        if (
          b.allowEvents &&
          d &&
          1 == b.options.checkBoxSettings.threeState &&
          !H
        ) {
          H = !0;
          w.length = 0;
          w.push({ item: d, value: d[b.options.dataFields.checkState] });
          b.updateListChildItemCheckValue(d);
          b.updateListParentItemCheckValue(d);
          var a = 0;
          for (a = 0; a < w.length; a++)
            w[a].item[b.options.dataFields.checkState] = w[a].value;
          var c = e(function() {
            a == w.length && (H = !1);
            e.cancel(c);
          }, 1);
        }
      };
      this.getItemCheckValue = function(d) {
        for (var a = "unchecked", c = !1, r = 0; r < w.length; r++)
          if (w[r].item == d) {
            c = !0;
            a = w[r].value;
            break;
          }
        c || (a = d[b.options.dataFields.checkState]);
        return a;
      };
      this.updateListParentItemCheckValue = function(d) {
        for (d = b.getParent(d); d; ) {
          var a = d[b.options.dataFields.items];
          if (a) {
            for (var c = 0, r = 0, e = 0; e < a.length; e++) {
              var f = b.getItemCheckValue(a[e]);
              "checked" == f ? c++ : "indeterminate" == f && r++;
            }
            e = { item: d };
            e.value =
              c == a.length
                ? "checked"
                : 0 < c || 0 < r
                ? "indeterminate"
                : "unchecked";
            w.push(e);
          }
          d = b.getParent(d);
        }
      };
      this.updateListChildItemCheckValue = function(d) {
        if (d) {
          var a = d[b.options.dataFields.items];
          if (a)
            for (var c = 0; c < a.length; c++) {
              var r = { item: a[c] };
              "checked" == b.getItemCheckValue(d)
                ? (r.value = "checked")
                : (r.value = "unchecked");
              w.push(r);
              b.updateListChildItemCheckValue(a[c]);
            }
        }
      };
      this.updateParentItemCheckValue = function(d) {
        for (d = b.getParent(d); d; ) {
          var a = d[b.options.dataFields.items];
          if (a) {
            for (var c = 0, r = 0, e = 0; e < a.length; e++)
              "checked" == a[e][b.options.dataFields.checkState]
                ? c++
                : "indeterminate" == a[e][b.options.dataFields.checkState] &&
                  r++;
            d[b.options.dataFields.checkState] =
              c == a.length
                ? "checked"
                : 0 < c || 0 < r
                ? "indeterminate"
                : "unchecked";
          }
          d = b.getParent(d);
        }
      };
      this.updateItemCheckValue = function(d, a) {
        if ("checked" == a || "unchecked" == a)
          d[b.options.dataFields.checkState] = a;
        var h = d[b.options.dataFields.items];
        if (h && 0 < h.length)
          for (var c = 0; c < h.length; c++)
            b.updateItemCheckValue(h[c], d[b.options.dataFields.checkState]);
        void 0 != d[b.options.dataFields.checkState] &&
          (h = b.getParent(d)) &&
          h[b.options.dataFields.checkState] !=
            d[b.options.dataFields.checkState] &&
          b.updateParentItemCheckValue(d);
      };
      this.updateCheckValues = function(d) {
        if (1 == b.options.checkBoxSettings.threeState) {
          d = b.dataObj.getList(d);
          for (var a = 0; a < d.length; a++) b.updateItemCheckValue(d[a]);
        }
      };
      c.$on(c.name + "-update-check", function(d, a) {
        b.updateCheckValues(a);
      });
      c.$on(c.name + "-get-check-list", function(d, h) {
        b.updateCheckValues();
        void 0 == h &&
          (h = 1 == b.options.checkBoxSettings.threeState ? "checked" : !0);
        var c =
            1 == b.options.checkBoxSettings.threeState
              ? b.options.dataFields.checkState
              : b.options.dataFields.checked,
          r = { operation: "=", value: h };
        c = a.filter(b.getFullList(), c, r);
        m.setTempData(c);
      });
      this.updateCheckBoxSettings = function(d) {
        b.options.checkBoxSettings = d
          ? {
              autoCheck: f.isFieldAvailable(d.autoCheck, !1),
              style: Ka(d.style),
              threeState: f.isFieldAvailable(d.threeState, !1)
            }
          : { autoCheck: !1, style: b.defaultCheckBoxStyle, threeState: !1 };
      };
      var C = function(d) {
          return d ? a.createTree(d.conditions, d.formula) : null;
        },
        I = function(d) {
          if (0 == d[b.options.dataFields.visible]) return !1;
          var h = !0;
          if (d && b.filterParams)
            if (
              ((h = (h = d[b.options.dataFields.value])
                ? h
                : d[b.options.dataFields.text]),
              b.filterParams.callback)
            )
              h = b.filterParams.callback(h, d);
            else if (
              ((h = a.match(
                h,
                b.filterParams.conditions,
                b.filterParams.formula,
                C(b.filterParams),
                b.filterParams.caseSensitive
              )),
              !h &&
                b.filterParams.allowParent &&
                ((h = !1), (d = d[b.options.dataFields.items])))
            )
              for (var c = 0; c < d.length && !(h = I(d[c])); c++);
          return h;
        },
        y = 0;
      b.currentList = [];
      b.indentList = [];
      b.parentList = [];
      b.longestItem = null;
      b.isThereChildItems = !1;
      b.currentTopList = [];
      b.currentBottomList = [];
      this.updateLongestItem = function() {
        b.longestItem = null;
        for (var d = (y = 0); d < b.currentList.length; d++) {
          var a = b.currentList[d];
          if (a[b.options.dataFields.text]) {
            var c = a[b.options.dataFields.text].length;
            0 < b.options.indent && (c += b.indentList[d] / b.options.indent);
            y < c && ((y = c), (b.longestItem = a));
          }
        }
      };
      var A = function(d, a, c, r, e) {
        d.type = "item";
        d[b.options.dataFields.id] ||
          (d[b.options.dataFields.id] = f.getUniqueId());
        c && (d[b.options.dataFields.pid] = c);
        if ((c = I(d)))
          if (r) b.fullList.push(d);
          else {
            r = a;
            0 != b.options.showStatusIcons && (r += 15);
            switch (d[b.options.dataFields.fixed]) {
              case "top":
                b.currentTopList.push(d);
                break;
              case "bottom":
                b.currentBottomList.push(d);
                break;
              default:
                b.currentList.push(d),
                  b.indentList.push(r),
                  b.parentList.push({ parent: e });
            }
            d[b.options.dataFields.text] &&
              ((e = d[b.options.dataFields.text].length),
              0 < b.options.indent && (e += a / b.options.indent),
              0 != b.options.showStatusIcons && (e += 15),
              y < e && ((y = e), (b.longestItem = d)));
          }
        return c;
      };
      this.isThereVisibleChildren = function(d) {
        var a = !1;
        if (d && (d = d[b.options.dataFields.items]))
          for (var c = 0; c < d.length; c++)
            if (I(d[c]) && !b.isItemFixed(d[c])) {
              a = !0;
              break;
            }
        return a;
      };
      this.isItemFixed = function(d) {
        return "top" == d[b.options.dataFields.fixed] ||
          "bottom" == d[b.options.dataFields.fixed]
          ? !0
          : !1;
      };
      this.isThereChildItems = !1;
      var O = function(d, a, c, r, e) {
        if (!d[b.options.dataFields.items]) return (c = A(d, a, c, r, e));
        if ((c = A(d, a, c, r, e)) && !b.isItemFixed(d)) {
          e = 0;
          var h;
          if (
            r ||
            b.isItemExpanded(d) ||
            (b.isItemFixed(d) && d[b.options.dataFields.fixChildren])
          ) {
            var u = d[b.options.dataFields.items];
            if (u) {
              b.applySorting(u);
              for (var f = 0; f < u.length; f++)
                (h = O(
                  u[f],
                  a + b.options.indent,
                  d[b.options.dataFields.id],
                  r,
                  d
                )) && e++;
            }
          }
          r ||
            b.isThereChildItems ||
            !(
              0 < e ||
              (!b.isItemExpanded(d) &&
                d[b.options.dataFields.items] &&
                0 < d[b.options.dataFields.items].length &&
                b.isThereVisibleChildren(d))
            ) ||
            (b.isThereChildItems = !0);
        }
        return c;
      };
      b.fullList = [];
      this.getFullList = function(d) {
        b.fullList.length = 0;
        d = b.dataObj.getList(d);
        for (var a = 0; a < d.length; a++) O(d[a], 0, null, !0, null);
        return b.fullList;
      };
      this.getCurrentList = function() {
        return b.currentList;
      };
      this.updateCurrentList = function() {
        b.currentList.length = 0;
        b.indentList.length = 0;
        b.parentList.length = 0;
        b.longestItem = null;
        b.currentTopList.length = 0;
        b.currentBottomList.length = 0;
        b.isThereChildItems = !1;
        y = 0;
        var d = b.dataObj.getList();
        if (d) {
          b.applySorting(d);
          for (var a = 0; a < d.length; a++) O(d[a], 0, null, !1);
        }
      };
      this.dataEvents = {
        clear: function(d) {
          return angular.isDefined(c.events) && c.events.clear
            ? c.events.clear({ parent: d.e.parent })
            : c.clear(d);
        },
        objAdded: function(d) {
          return angular.isDefined(c.events) && c.events.itemAdded
            ? c.events.itemAdded({ item: d.e.item })
            : c.itemAdded(d);
        },
        objAdding: function(d) {
          return angular.isDefined(c.events) && c.events.itemAdding
            ? c.events.itemAdding({ item: d.e.item })
            : c.itemAdding(d);
        },
        objRemoved: function(d) {
          return angular.isDefined(c.events) && c.events.itemRemoved
            ? c.events.itemRemoved({ item: d.e.item })
            : c.itemRemoved(d);
        },
        objRemoving: function(d) {
          return angular.isDefined(c.events) && c.events.itemRemoving
            ? c.events.itemRemoving({ item: d.e.item })
            : c.itemRemoving(d);
        }
      };
      this.getDataFields = function(d) {
        return {
          content: d.content ? d.content : "content",
          icon: d.icon ? d.icon : "icon",
          id: d.id ? d.id : "id",
          pid: d.pid ? d.pid : "pid",
          objects: d.items ? d.items : "items",
          statusIcon: d.statusIcon ? d.statusIcon : "statusIcon",
          text: d.text ? d.text : "text"
        };
      };
      b.dataObj = new k({
        objects: c.items,
        events: b.dataEvents,
        fields: b.getDataFields(b.options.dataFields)
      });
      c.$on(c.name + "-load-data", function(d, a, c, r, e) {
        m.setTempData(b.loadData(a, c, r, e));
      });
      c.$on(c.name + "-export-json", function(d, a, c, r) {
        m.setTempData(b.exportToJSON(a, c, r));
      });
      this.exportToJSON = function(d, a, c) {
        c = c ? c : null;
        var h = !1 !== a ? b.getFullList() : b.dataObj.getList();
        d = d
          ? d
          : [
              b.options.dataFields.allowDrag,
              b.options.dataFields.allowDrop,
              b.options.dataFields.allowEdit,
              b.options.dataFields.allowFocus,
              b.options.dataFields.autoCheck,
              b.options.dataFields.checkBoxSettings,
              b.options.dataFields.checked,
              b.options.dataFields.checkState,
              b.options.dataFields.content,
              b.options.dataFields.contextMenu,
              b.options.dataFields.enabled,
              b.options.dataFields.expanded,
              b.options.dataFields.fixed,
              b.options.dataFields.fixChildren,
              b.options.dataFields.hasChildren,
              b.options.dataFields.icon,
              b.options.dataFields.id,
              b.options.dataFields.pid,
              b.options.dataFields.selected,
              b.options.dataFields.showCheckBox,
              b.options.dataFields.statusIcon,
              b.options.dataFields.style,
              b.options.dataFields.templateObj,
              b.options.dataFields.text,
              b.options.dataFields.tooltip,
              b.options.dataFields.value,
              b.options.dataFields.visible
            ];
        !1 === a && d.push(b.options.dataFields.items);
        return JSON.stringify(h, d, c);
      };
      this.loadData = function(d, a, u, r) {
        var h = n.defer();
        b.suspendLayout();
        b.allowEvents = !1;
        b.updateDataFields(u);
        var f = [],
          l = b.options.dataFields;
        b.dataObj.clear(a, b.listIsCleared);
        if (d)
          if (r) {
            var m = [];
            d.forEach(function(d, a) {
              d[l.items] = [];
              var b = d[l.pid];
              m[b]
                ? (m[b][l.items] || (m[b][l.items] = []),
                  (m[d[l.id]] = d),
                  m[b][l.items].push(d))
                : ((m[d[l.id]] = d), f.push(d));
            });
            m.length = 0;
          } else f = d;
        if (a)
          for (
            a[b.options.dataFields.items] = f, d = 0;
            d < a[b.options.dataFields.items].length;
            d++
          )
            a[b.options.dataFields.items][d][b.options.dataFields.pid] =
              a[b.options.dataFields.id];
        else if (angular.isDefined(c.items))
          for (d = c.items.length = 0; d < f.length; d++) c.items.push(f[d]);
        b.dataObj = new k({
          objects: c.items,
          events: b.dataEvents,
          fields: b.getDataFields(b.options.dataFields)
        });
        var q = e(function() {
          b.getTemplateUrl();
          b.resumeLayout();
          b.allowEvents = !0;
          var d = e(function() {
            h.resolve();
            e.cancel(d);
          }, 125);
          e.cancel(q);
        }, 100);
        return h.promise;
      };
      this.updateData = function() {
        b.options.dataFields.dataSource &&
          (b.loadData(b.options.dataFields.dataSource),
          (b.dataObj = new k({
            objects: c.items,
            events: b.dataEvents,
            fields: b.getDataFields(b.options.dataFields)
          })));
      };
      var Y = !1;
      this.dragDropStatus = function(d) {
        if (void 0 != d) Y = d;
        else return Y;
      };
      this.getDnDSource = function(d) {
        return {
          text: d.dataTransfer
            ? d.dataTransfer.getData("text")
            : d.originalEvent.dataTransfer
            ? d.originalEvent.dataTransfer.getData("text")
            : ""
        };
      };
      this.getTouchData = function(d) {
        return d.changedTouches
          ? d.changedTouches
          : d.originalEvent
          ? d.originalEvent.changedTouches
          : null;
      };
      var ea = angular.element(
        '<div class="iui-drop-marker" data-element="dropmark"></div>'
      );
      this.getDropMarkLine = function() {
        return dropMarkLine;
      };
      b.getMousePos = function(d) {
        return {
          x: d.pageX ? d.pageX : d.originalEvent ? d.originalEvent.pageX : 0,
          y: d.pageY ? d.pageY : d.originalEvent ? d.originalEvent.pageY : 0
        };
      };
      this.getCtrlName = function() {
        return angular.isDefined(c.name) ? c.name : "";
      };
      q.bind("dragenter", function(d) {
        d.preventDefault();
        if (b.options.enabled) {
          var a = U.getData();
          a.source || (a.source = b.getDnDSource(d));
          d = {
            event: d,
            sourceTree: a.sourceCtrl ? a.sourceCtrl.getCtrlName() : "",
            dragItem: a.source,
            targetTree: b.getCtrlName(),
            targetItem: a.target,
            mousePos: b.getMousePos(d)
          };
          b.callDragEnter(d);
        }
      });
      this.isItemDragOverHandled = !1;
      q.bind("dragover", function(d) {
        if (!b.options.autoSize || !b.isItemDragOverHandled) {
          d.preventDefault();
          var a = !0;
          d.dataTransfer
            ? (a = "none" === d.dataTransfer.effectAllowed ? !1 : !0)
            : d.originalEvent &&
              d.originalEvent.dataTransfer &&
              (a =
                "none" === d.originalEvent.dataTransfer.effectAllowed
                  ? !1
                  : !0);
          if (b.options.enabled && a)
            if (
              (d.dataTransfer
                ? (d.dataTransfer.dropEffect = b.options.allowDrop
                    ? "move"
                    : "none")
                : d.originalEvent &&
                  d.originalEvent.dataTransfer &&
                  (d.originalEvent.dataTransfer.dropEffect = b.options.allowDrop
                    ? "move"
                    : "none"),
              (a = U.getData()),
              a.source || (a.source = b.getDnDSource(d)),
              U.setData({
                source: a.source,
                sourceCtrl: a.sourceCtrl,
                target: null,
                dropPos: -1
              }),
              (a = {
                event: d,
                sourceTree: a.sourceCtrl ? a.sourceCtrl.getCtrlName() : "",
                dragItem: a.source,
                targetTree: b.getCtrlName(),
                targetItem: null,
                isDropAllowed: b.options.allowDrop,
                dropPos: -1,
                mousePos: b.getMousePos(d)
              }),
              0 == b.callDragOver(a))
            )
              d.dataTransfer
                ? (d.dataTransfer.dropEffect = "none")
                : d.originalEvent &&
                  d.originalEvent.dataTransfer &&
                  (d.originalEvent.dataTransfer.dropEffect = "none"),
                b.dropMark();
            else {
              a = b.getMousePos(d);
              d = a.y + 16;
              a = a.x + 20;
              var u = b.getDropMarkWindow();
              u.empty();
              u.append(
                "<span class='iui-drop-marker-move-end'></span><span class='iui-drop-marker-title'>" +
                  (c.name ? c.name : "TreeView") +
                  "</span>"
              );
              b.updateDropMarkElem(b.getDropMarkWindow(), { top: d, left: a });
              b.dropMark(!0);
            }
        }
      });
      q.bind("drop", function(d) {
        d.preventDefault();
        b.dropMark();
        var a = !0;
        d.dataTransfer
          ? (a = "none" === d.dataTransfer.effectAllowed ? !1 : !0)
          : d.originalEvent &&
            d.originalEvent.dataTransfer &&
            (a =
              "none" === d.originalEvent.dataTransfer.effectAllowed ? !1 : !0);
        if (
          b.options.enabled &&
          a &&
          ((a = U.getData()),
          a.source || (a.source = b.getDnDSource(d)),
          a.source)
        ) {
          var u = {
            event: d,
            sourceTree: a.sourceCtrl ? a.sourceCtrl.getCtrlName() : "",
            dragItem: a.source,
            targetTree: b.getCtrlName(),
            targetItem: null,
            isDropAllowed: b.options.allowDrop,
            dropPos: -1,
            mousePos: b.getMousePos(d)
          };
          !1 !== b.callDragDrop(u) && (b.drop(a), c.$$phase || c.$apply());
        }
        U.clearData();
        d.stopPropagation();
      });
      q.bind("dragleave", function(d) {
        d.preventDefault();
        if (b.options.enabled) {
          b.dropMark();
          var a = U.getData();
          a.source || (a.source = b.getDnDSource(d));
          d = {
            event: d,
            sourceTree: a.sourceCtrl ? a.sourceCtrl.getCtrlName() : "",
            dragItem: a.source,
            targetTree: b.getCtrlName(),
            targetItem: a.target,
            mousePos: b.getMousePos(d)
          };
          b.callDragLeave(d);
          b.cancelScrollTimer();
        }
      });
      q.bind("dragend", function(d) {
        d.preventDefault();
        b.options.enabled &&
          (b.dropMark(),
          U.getData().source || U.clearData(),
          b.dragDropStatus(!1));
      });
      q.bind("mouseleave", function(d) {
        d.preventDefault();
        b.dropMark();
        b.hoverItem = null;
      });
      this.containsMousePos = function(d, a) {
        return U.hitTest(d, a, {
          left: 0,
          top: 0,
          right: q[0].clientWidth,
          bottom: q[0].clientHeight
        });
      };
      this.isPopupActive = function() {
        return !1;
      };
      var fa = function(d, a) {
          var c = b.options.dataFields;
          d[c.items] || (d[c.items] = []);
          d[c.items].length = 0;
          if (d[a.rows] && 0 < d[a.rows].length)
            for (var h = 0; h < d[a.rows].length; h++)
              d[c.items].push(fa(d[a.rows][h], a));
          return d;
        },
        B = function(d, a) {
          var c = !1;
          a.sourceCtrl &&
            (c = a.sourceCollection.removeAt(
              d,
              -1,
              null,
              a.sourceCtrl.objIsRemoved
            ));
          c &&
            ("row" == d.type && (d = fa(d, a.sourceCtrl.options.rowFields)),
            0 === a.dropPos
              ? b.dataObj.insertAt(d, -1, a.target, b.itemIsAdded)
              : 1 === a.dropPos || 2 === a.dropPos
              ? 1 === a.dropPos
                ? b.dataObj.insertByRef(d, a.target, !1, b.itemIsAdded)
                : b.dataObj.insertByRef(d, a.target, !0, b.itemIsAdded)
              : b.dataObj.insertAt(d, -1, null, b.itemIsAdded));
        };
      this.setDropSelection = function(a, c) {
        var d = a;
        !d && 0 <= c && c < b.currentList.length && (d = b.currentList[c]);
        b.clearPrevSelection(d);
        b.itemSelection(null, d);
      };
      this.drop = function(a) {
        if (a && a.sourceCtrl) {
          a.sourceCtrl.suppressProcess = !0;
          a.sourceCtrl.suspendLayout();
          b.suspendLayout();
          var d = a.source;
          if (Array.isArray(a.source)) {
            for (var u = [], r = 0; r < a.source.length; r++) {
              for (
                var f = !1, k = a.sourceCollection.getParent(a.source[r]);
                k;

              ) {
                if (a.sourceCtrl.isObjInSelList(k)) {
                  f = !0;
                  break;
                }
                k = a.sourceCollection.getParent(k);
              }
              f || u.push(a.source[r]);
            }
            if (0 < u.length)
              if (
                ((d = u[u.length - 1]),
                (r = a.sourceCtrl.getObjCurrentIndex(u[0])),
                (f = a.sourceCtrl.getObjCurrentIndex(d)),
                r <= f)
              )
                for (r = 0; r < u.length; r++) B(u[r], a);
              else for (r = u.length - 1; 0 <= r; r--) B(u[r], a);
          } else B(a.source, a);
          a.sourceCtrl !== b
            ? ((b.allowUpdate = !0),
              (a.sourceCtrl.allowUpdate = !0),
              b.updateCurrentLayout(),
              a.sourceCtrl.updateCurrentLayout())
            : ((b.allowUpdate = !0), b.updateCurrentLayout());
          b.updateAutoLayout();
          a.sourceCtrl.multiSelection(!1);
          var l = e(function() {
            if (d) {
              a.sourceCtrl.clearPrevSelection(d);
              b.itemSelection(null, d);
              var h = b.getElemFromItem(d);
              h && (h = b.getElement(h)) && h[0].focus();
              c.$apply();
              e.cancel(l);
            }
          }, 1);
          a.sourceCtrl.suppressProcess = !1;
        }
      };
      this.isDragAllowed = function(a) {
        return b.options.allowDrag
          ? a &&
            (a[b.options.dataFields.allowDrag] ||
              void 0 === a[b.options.dataFields.allowDrag])
            ? !0
            : !1
          : !1;
      };
      this.isChildOf = function(a, c) {
        var d = !1;
        if (a && c) {
          var h = c[b.options.dataFields.items];
          if (h && 0 < h.length)
            for (var e = 0; e < h.length; e++) {
              if (
                f.isEqual(
                  a[b.options.dataFields.id],
                  h[e][b.options.dataFields.id]
                )
              ) {
                d = !0;
                break;
              } else d = b.isChildOf(a, h[e]);
              if (d) break;
            }
        }
        return d;
      };
      this.isParentOf = function(a, c) {
        var d = b.dataObj.getParent(c);
        return a &&
          c &&
          d &&
          f.isEqual(a[b.options.dataFields.id], d[b.options.dataFields.id])
          ? !0
          : !1;
      };
      this.isDropAllowed = function(a, c, u) {
        var d = b.options.allowDrop;
        if (
          d &&
          a &&
          c &&
          (d =
            b.isItemFixed(c) ||
            (!c[b.options.dataFields.allowDrop] &&
              void 0 !== c[b.options.dataFields.allowDrop])
              ? !1
              : !0)
        )
          if (Array.isArray(a))
            for (var h = 0; h < a.length; h++) {
              if (
                f.isEqual(
                  a[h][b.options.dataFields.id],
                  c[b.options.dataFields.id]
                ) ||
                (0 === u && b.isParentOf(c, a[h])) ||
                b.isChildOf(c, a[h])
              ) {
                d = !1;
                break;
              }
              if (!d) break;
            }
          else if (
            f.isEqual(a[b.options.dataFields.id], c[b.options.dataFields.id]) ||
            (0 === u && b.isParentOf(c, a)) ||
            b.isChildOf(c, a)
          )
            d = !1;
        return d;
      };
      this.getDropMarkWindow = function() {
        for (
          var a = ea, b = angular.element(document.body).children(), c = 0;
          c < b.length;
          c++
        ) {
          var e = angular.element(b[c]);
          if (
            e[0].attributes &&
            e[0].attributes["data-element"] &&
            "dropmark" === e[0].attributes["data-element"].value
          ) {
            a = e;
            break;
          }
        }
        return a;
      };
      this.dropMark = function(a, c) {
        c || (c = b.getDropMarkWindow());
        if (c) {
          var d = "none";
          this.options.allowDrop && (d = a ? "block" : "none");
          angular.element(c).css("display", d);
        }
      };
      this.updateDropMarkElem = function(a, b) {
        a &&
          b &&
          (a.css("top", b.top + "px"),
          a.css("left", b.left + "px"),
          a.css("width", b.width + "px"));
      };
      var $a = !1,
        Z = angular.element('<input type="text" style="position:absolute" />');
      this.labelEditStatus = function(a) {
        if (void 0 != a) $a = a;
        else return $a;
      };
      this.getEditBox = function() {
        return Z;
      };
      this.updateEditBox = function(a) {
        Z &&
          a &&
          (Z.css("top", a.top + "px"),
          Z.css("left", a.left + "px"),
          Z.css("width", a.width + "px"),
          Z.css("height", a.height + "px"));
      };
      c.$on(c.name + "-open-editor", function(a, c) {
        b.openEditor(c);
      });
      c.$on(c.name + "-close-editor", function(a, c) {
        b.closeEditor(c);
      });
      this.updateEditorSettings = function(a) {
        b.options.editorSettings = a
          ? { activate: f.isFieldAvailable(a.activate, "click") }
          : { activate: "click" };
      };
      this.allowEvents = !0;
      this.callAfterCollapse = function(a) {
        angular.isDefined(c.events) &&
          c.events.afterCollapse &&
          c.events.afterCollapse({ item: a });
        c.afterCollapse({ e: { item: a } });
      };
      this.callAfterExpand = function(a) {
        angular.isDefined(c.events) &&
          c.events.afterExpand &&
          c.events.afterExpand({ item: a });
        c.afterExpand({ e: { item: a } });
      };
      this.callAfterEdit = function(a) {
        angular.isDefined(c.events) &&
          c.events.afterEdit &&
          c.events.afterEdit({ item: a });
        c.afterEdit({ e: { item: a } });
      };
      this.callAfterLabelEdit = function(a) {
        angular.isDefined(c.events) &&
          c.events.afterLabelEdit &&
          c.events.afterLabelEdit({ item: a });
        c.afterLabelEdit({ e: { item: a } });
      };
      this.callAfterSelect = function(a) {
        angular.isDefined(c.events) && c.events.afterSelect
          ? c.events.afterSelect({ item: a })
          : c.afterSelect({ e: { item: a } });
        angular.isDefined(c.events) && c.events.selectionChanged
          ? c.events.selectionChanged({ item: a })
          : c.selectionChanged({ e: { item: a } });
      };
      this.callBeforeCollapse = function(a) {
        return angular.isDefined(c.events) && c.events.beforeCollapse
          ? c.events.beforeCollapse({ item: a })
          : c.beforeCollapse({ e: { item: a } });
      };
      this.callBeforeExpand = function(a) {
        return angular.isDefined(c.events) && c.events.beforeExpand
          ? c.events.beforeExpand({ item: a })
          : c.beforeExpand({ e: { item: a } });
      };
      this.callBeforeEdit = function(a) {
        return angular.isDefined(c.events) && c.events.beforeEdit
          ? c.events.beforeEdit({ item: a })
          : c.beforeEdit({ e: { item: a } });
      };
      this.callBeforeLabelEdit = function(a) {
        return angular.isDefined(c.events) && c.events.beforeLabelEdit
          ? c.events.beforeLabelEdit({ item: a })
          : c.beforeLabelEdit({ e: { item: a } });
      };
      this.callChange = function() {
        angular.isDefined(c.events) && c.events.change
          ? c.events.change()
          : c.change();
      };
      this.callDragEnter = function(a) {
        angular.isDefined(c.events) && c.events.dragEnter
          ? c.events.dragEnter({
              event: a.event,
              sourceTree: a.sourceTree,
              dragItem: a.dragItem,
              targetTree: a.targetTree,
              targetItem: a.targetItem,
              mousePos: a.mousePos
            })
          : c.dragEnter({
              e: {
                event: a.event,
                sourceTree: a.sourceTree,
                dragItem: a.dragItem,
                targetTree: a.targetTree,
                targetItem: a.targetItem,
                mousePos: a.mousePos
              }
            });
      };
      this.callDragOver = function(a) {
        return angular.isDefined(c.events) && c.events.dragOver
          ? c.events.dragOver({
              event: a.event,
              sourceTree: a.sourceTree,
              dragItem: a.dragItem,
              targetTree: a.targetTree,
              targetItem: a.targetItem,
              isDropAllowed: a.isDropAllowed,
              dropPos: a.dropPos,
              mousePos: a.mousePos
            })
          : c.dragOver({
              e: {
                event: a.event,
                sourceTree: a.sourceTree,
                dragItem: a.dragItem,
                targetTree: a.targetTree,
                targetItem: a.targetItem,
                isDropAllowed: a.isDropAllowed,
                dropPos: a.dropPos,
                mousePos: a.mousePos
              }
            });
      };
      this.callDragDrop = function(a) {
        return angular.isDefined(c.events) && c.events.dragDrop
          ? c.events.dragDrop({
              event: a.event,
              sourceTree: a.sourceTree,
              dragItem: a.dragItem,
              targetTree: a.targetTree,
              targetItem: a.targetItem,
              isDropAllowed: a.isDropAllowed,
              dropPos: a.dropPos,
              mousePos: a.mousePos
            })
          : c.dragDrop({
              e: {
                event: a.event,
                sourceTree: a.sourceTree,
                dragItem: a.dragItem,
                targetTree: a.targetTree,
                targetItem: a.targetItem,
                isDropAllowed: a.isDropAllowed,
                dropPos: a.dropPos,
                mousePos: a.mousePos
              }
            });
      };
      this.callDragLeave = function(a) {
        angular.isDefined(c.events) && c.events.dragLeave
          ? c.events.dragLeave({
              event: a.event,
              sourceTree: a.sourceTree,
              dragItem: a.dragItem,
              targetTree: a.targetTree,
              targetItem: a.targetItem,
              mousePos: a.mousePos
            })
          : c.dragLeave({
              e: {
                event: a.event,
                sourceTree: a.sourceTree,
                dragItem: a.dragItem,
                targetTree: a.targetTree,
                targetItem: a.targetItem,
                mousePos: a.mousePos
              }
            });
      };
      this.callEnabledChanged = function(a) {
        angular.isDefined(c.events) && c.events.enabledChanged
          ? c.events.enabledChanged({ enabled: a })
          : c.enabledChanged({ e: { enabled: a } });
      };
      this.callItemClick = function(a, b, u) {
        angular.isDefined(c.events) &&
          c.events.itemClick &&
          c.events.itemClick({ event: a, item: b, mousePos: u });
        c.itemClick({ e: { event: a, item: b, mousePos: u } });
      };
      this.callItemDblClick = function(a, b) {
        return angular.isDefined(c.events) && c.events.itemDblClick
          ? c.events.itemDblClick({ item: a, mousePos: b })
          : c.itemDblclick({ e: { item: a, mousePos: b } });
      };
      this.callItemHover = function(a) {
        angular.isDefined(c.events) && c.events.itemHover
          ? c.events.itemHover({ item: a })
          : c.itemHover({ e: { item: a } });
      };
      this.callItemRightClick = function(a, b) {
        angular.isDefined(c.events) &&
          c.events.itemRightClick &&
          c.events.itemRightClick({ item: a, mousePos: b });
        c.itemRightclick({ e: { item: a, mousePos: b } });
      };
      this.callKeyDown = function(a, b) {
        return angular.isDefined(c.events) && c.events.keyDown
          ? c.events.keyDown({ event: a, item: b })
          : c.keyDown({ e: { event: a, item: b } });
      };
      this.callKeyPress = function(a, b) {
        angular.isDefined(c.events) && c.events.keyPress
          ? c.events.keyPress({ event: a, item: b })
          : c.keyPress({ e: { event: a, item: b } });
      };
      this.callKeyUp = function(a, b) {
        angular.isDefined(c.events) && c.events.keyUp
          ? c.events.keyUp({ event: a, item: b })
          : c.keyUp({ e: { event: a, item: b } });
      };
      this.callScrollPosChanged = function() {
        angular.isDefined(c.events) && c.events.scrollPosChanged
          ? c.events.scrollPosChanged({ scrollPos: b.scrollPos })
          : c.scrollposChanged({ e: { scrollPos: b.scrollPos } });
      };
      q.bind("click", function(a) {
        b.options.enabled &&
          1 === a.which &&
          b.callItemClick(a, null, b.getMousePos(a));
      });
      q.bind("dblclick", function(a) {
        a.preventDefault();
        b.options.enabled &&
          1 === a.which &&
          b.callItemDblClick(null, b.getMousePos(a));
        a.stopPropagation();
      });
      q.bind("mousedown", function(a) {
        b.options.enabled &&
          3 === a.which &&
          b.callItemRightClick(null, b.getMousePos(a));
        a.stopPropagation();
      });
      this.expandList = [];
      this.expandIndentList = [];
      this.expandParentList = [];
      var za = function(a, c, u, e) {
          a.type = "item";
          a[b.options.dataFields.id] ||
            (a[b.options.dataFields.id] = f.getUniqueId());
          u && (a[b.options.dataFields.pid] = u);
          u = I(a);
          b.isItemExpanded(a) &&
            a[b.options.dataFields.items] &&
            0 < a[b.options.dataFields.items].length &&
            (u = u && b.isThereVisibleChildren(a));
          u &&
            (0 != b.options.showStatusIcons && (c += 15),
            b.expandList.push(a),
            b.expandIndentList.push(c),
            b.expandParentList.push({ parent: e }));
          return u;
        },
        La = function(a, c, u, e) {
          if (!a[b.options.dataFields.items])
            return (u = za(a, c + b.options.indent, u, e));
          if ((u = za(a, c + b.options.indent, u, e))) {
            e = 0;
            var d;
            if (b.isItemExpanded(a)) {
              var h = a[b.options.dataFields.items];
              if (h) {
                b.applySorting(h);
                for (var r = 0; r < h.length; r++)
                  (d = La(
                    h[r],
                    c + b.options.indent,
                    a[b.options.dataFields.id],
                    a
                  )) && e++;
              }
            }
            !b.isThereChildItems &&
              (0 < e ||
                (!b.isItemExpanded(a) &&
                  a[b.options.dataFields.items] &&
                  0 < a[b.options.dataFields.items].length &&
                  b.isThereVisibleChildren(a))) &&
              (b.isThereChildItems = !0);
          }
          return u;
        };
      this.expand = function(a) {
        var d = b.getItemFromChildElem(document.activeElement);
        b.expandList.length = [];
        b.expandIndentList.length = [];
        b.expandParentList.length = [];
        if (!b.isItemExpanded(a)) {
          var c = b.getItemCurrentIndex(a),
            r = b.getList(a);
          if (r) {
            b.applySorting(r);
            for (var f = 0; f < r.length; f++)
              b.isItemFixed(r[f]) || La(r[f], b.indentList[c], null, a);
          }
          if (0 < b.expandList.length) {
            b.allowEvents = !1;
            c++;
            Array.prototype.splice.apply(
              b.currentList,
              [c, 0].concat(b.expandList)
            );
            Array.prototype.splice.apply(
              b.indentList,
              [c, 0].concat(b.expandIndentList)
            );
            Array.prototype.splice.apply(
              b.parentList,
              [c, 0].concat(b.expandParentList)
            );
            b.options.autoSize
              ? b.updateAutoLayout()
              : b.getItemScope()
              ? b.updateView()
              : b.updateLayout();
            var k = e(function() {
              b.updateViewSize();
              b.updateViewSize();
              b.updateScrollView();
              d && b.updateFocus(d);
              b.allowEvents = !0;
              e.cancel(k);
            }, 1);
          }
        }
      };
      this.collapse = function(a) {
        var d = b.getItemFromChildElem(document.activeElement);
        b.expandList.length = [];
        b.expandIndentList.length = [];
        if (b.isItemExpanded(a)) {
          var c = null,
            r = !1,
            f = a,
            k = -1,
            l = b.getItemCurrentIndex(a);
          for (a = b.getParent(a); a && !r; ) {
            c = b.getList(a);
            for (k = c.indexOf(f) + 1; !r && k < c.length; )
              (f = c[k]), 0 < b.getItemCurrentIndex(f) && (r = !0), k++;
            r || (f = a);
            a = b.getParent(a);
          }
          if (!r && f)
            for (c = b.getList(), k = c.indexOf(f) + 1; k < c.length; )
              if (((f = c[k]), 0 < b.getItemCurrentIndex(f))) {
                r = !0;
                break;
              } else k++;
          l++;
          c = b.currentList.length - l;
          r && (c = b.getItemCurrentIndex(f) - l);
          if (0 < c) {
            b.currentList.splice(l, c);
            b.indentList.splice(l, c);
            b.parentList.splice(l, c);
            b.options.autoSize
              ? b.updateAutoLayout()
              : b.getItemScope()
              ? b.updateView()
              : b.updateLayout();
            var m = e(function() {
              b.updateViewSize();
              b.updateViewSize();
              b.updateScrollView();
              d && b.updateFocus(d);
              b.allowEvents = !0;
              e.cancel(m);
            }, 1);
          }
        }
      };
      this.toggle = function(a, c) {
        if (a) {
          if (
            (a[b.options.dataFields.hasChildren] ||
              (a[b.options.dataFields.items] &&
                0 !== a[b.options.dataFields.items].length)) &&
            !(
              (c && !1 !== a[b.options.dataFields.expanded]) ||
              (!1 === c && !1 === a[b.options.dataFields.expanded])
            )
          ) {
            var d =
              void 0 !== c
                ? c
                : !1 !== a[b.options.dataFields.expanded]
                ? !0
                : !1;
            !1 !==
              (void 0 !== c
                ? c
                  ? b.callBeforeExpand(a)
                  : b.callBeforeCollapse(a)
                : d
                ? b.callBeforeCollapse(a)
                : b.callBeforeExpand(a)) &&
              ((d = void 0 != c ? c : !d),
              d != a[b.options.dataFields.expanded] &&
                (0 != d ? b.expand(a) : b.collapse(a),
                (a[b.options.dataFields.expanded] = d)),
              b.isItemExpanded(a)
                ? b.callAfterExpand(a)
                : b.callAfterCollapse(a));
          }
        } else {
          d = b.getFullList();
          for (var h = 0; h < d.length; h++)
            d[h][b.options.dataFields.expanded] = c;
          b.updateCurrentLayout();
        }
      };
      c.$on(c.name + "-collapse", function(a, c) {
        b.toggle(c, !1);
      });
      c.$on(c.name + "-expand", function(a, c) {
        b.toggle(c, !0);
      });
      c.$on(c.name + "-toggle", function(a, c) {
        b.toggle(c);
      });
      this.filterParams = null;
      c.$on(c.name + "-filter", function(a, c) {
        b.filter(c);
      });
      this.filter = function(a) {
        b.filterParams = a;
        b.updateCurrentLayout();
        b.callChange();
      };
      this.callGotFocus = function(a, b, e, f) {
        angular.isDefined(c.events) && c.events.gotFocus
          ? c.events.gotFocus({
              event: a,
              item: b,
              edit: void 0 != e ? !0 : !1,
              editValue: f
            })
          : c.gotFocus({
              e: {
                event: a,
                item: b,
                edit: void 0 != e ? !0 : !1,
                editValue: f
              }
            });
      };
      this.callLostFocus = function(a, b, e, f) {
        angular.isDefined(c.events) && c.events.lostFocus
          ? c.events.lostFocus({
              event: a,
              item: b,
              edit: void 0 != e ? !0 : !1,
              editValue: f
            })
          : c.lostFocus({
              e: {
                event: a,
                item: b,
                edit: void 0 != e ? !0 : !1,
                editValue: f
              }
            });
      };
      this.getTabIndex = function() {
        return q[0].attributes && q[0].attributes.tabindex
          ? q[0].attributes.tabindex.value
          : "";
      };
      this.updateFocus = function(a) {
        if (1 == b.options.allowFocus)
          var d = e(function() {
            if (a && !b.isItemFixed(a)) {
              var c = b.getElemFromItem(a);
              c && (c = b.getElement(c)) && c[0].focus();
            } else q[0].focus();
            e.cancel(d);
          }, 5);
      };
      c.$on(c.name + "-focus", function(a, c) {
        b.updateFocus(c);
      });
      var qa = !1;
      this.isItemExpanded = function(a) {
        return a
          ? a[b.options.dataFields.expanded] ||
            void 0 === a[b.options.dataFields.expanded]
            ? !0
            : !1
          : !0;
      };
      this.getElement = function(a, b) {
        var d = null;
        b || (b = "content");
        if (a)
          for (var c = a.children(), h = 0; h < c.length; h++) {
            var e = angular.element(c.eq(h));
            if (
              e[0].attributes &&
              e[0].attributes["data-element"] &&
              e[0].attributes["data-element"].value === b
            ) {
              d = e;
              break;
            }
          }
        return d;
      };
      this.getIndent = function(a) {
        var d = 0;
        if (a && 0 < b.options.indent)
          for (parent = b.dataObj.getParent(a); parent; )
            (d += b.options.indent), (parent = b.dataObj.getParent(parent));
        return d;
      };
      this.getItemCurrentIndex = function(a) {
        if (a) {
          switch (a[b.options.dataFields.fixed]) {
            case "top":
              return b.currentTopList ? b.currentTopList.indexOf(a) : -1;
            case "bottom":
              return b.currentBottomList ? b.currentBottomList.indexOf(a) : -1;
          }
          return b.currentList ? b.currentList.indexOf(a) : -1;
        }
        return -1;
      };
      this.getObjCurrentIndex = function(a) {
        return b.getItemCurrentIndex(a);
      };
      this.getObjState = function(a) {
        if (a)
          switch (a.type) {
            case "item":
              if (
                0 == b.options.enabled ||
                0 == a[b.options.dataFields.enabled]
              )
                return "disabled";
              if (1 == a[b.options.dataFields.selected] && b.isObjInSelList(a))
                return "selected";
              if (a == b.hoverItem) return "hovered";
          }
        return "normal";
      };
      this.getItemFromChildElem = function(a) {
        return a
          ? (a = angular.element(a))
            ? b.getItemFromElem(a[0].parentElement)
            : null
          : null;
      };
      this.getItemFromElem = function(a) {
        if (a && (a = angular.element(a)) && a[0].attributes["data-index"]) {
          var d = a[0].attributes["data-index"].value,
            c = "none";
          a[0].attributes["data-fixed"] &&
            (c = a[0].attributes["data-fixed"].value);
          switch (c) {
            case "top":
              if (0 <= d && d < b.currentTopList.length)
                return b.currentTopList[d];
              break;
            case "bottom":
              if (0 <= d && d < b.currentBottomList.length)
                return b.currentBottomList[d];
              break;
            default:
              if (b.isIndexInRange(d)) return b.currentList[d];
          }
        }
      };
      this.isIndexInRange = function(a) {
        return 0 <= a && a < b.currentList.length;
      };
      this.isItemEnabled = function(a) {
        return (
          a &&
          1 == b.options.enabled &&
          f.isEnabled(a[b.options.dataFields.enabled])
        );
      };
      this.mouseButtonStatus = function(a) {
        qa = a;
      };
      c.$on(c.name + "-ensure-visible", function(a, c, e) {
        b.ensureVisible(c, e);
      });
      c.$on(c.name + "-find-item-by-id", function(a, c) {
        m.setTempData(b.findItemById(c));
      });
      c.$on(c.name + "-find-item-by-text", function(a, c) {
        m.setTempData(b.findItemByText(c));
      });
      c.$on(c.name + "-get-full-path", function(a, c) {
        m.setTempData(b.getFullPath(c));
      });
      c.$on(c.name + "-get-item-level", function(a, c) {
        m.setTempData(b.getLevel(c));
      });
      c.$on(c.name + "-get-item-parent", function(a, c) {
        m.setTempData(b.getParent(c));
      });
      c.$on(c.name + "-get-item-at", function(a, c) {
        c ? m.setTempData(b.getItemAt(c.x, c.y)) : m.setTempData(null);
      });
      c.$on(c.name + "-get-flat-list", function(a, c) {
        c ? m.setTempData(b.getFullList()) : m.setTempData(b.currentList);
      });
      c.$on(c.name + "-get-list", function(a, c, e) {
        1 == e ? m.setTempData(b.getFullList(c)) : m.setTempData(b.getList(c));
      });
      this.ensureVisible = function(a, c) {
        if (a) {
          for (var d = [], h = b.getParent(a); h; )
            d.push(h), (h = b.getParent(h));
          for (h = d.length - 1; 0 <= h; h--)
            d[h][b.options.dataFields.expanded] = !0;
          b.updateCurrentLayout();
          var f = e(function() {
            c = void 0 != c ? c : "center";
            b.scrollTo(a, c);
            e.cancel(f);
          }, 100);
        }
      };
      this.findItemById = function(a) {
        return b.dataObj.findObjectById(a);
      };
      this.findItemByText = function(a) {
        return b.dataObj.findObjectByText(a);
      };
      this.getFullPath = function(a) {
        var d = "";
        if (a)
          for (d = a[b.options.dataFields.text], a = b.getParent(a); a; )
            (d = [
              a[b.options.dataFields.text],
              b.options.pathSeparator,
              d
            ].join("")),
              (a = b.getParent(a));
        return d;
      };
      this.getLevel = function(a) {
        var b = 0;
        for (a = this.getParent(a); a; ) b++, (a = this.getParent(a));
        return b;
      };
      this.getParent = function(a) {
        return b.dataObj.getParent(a);
      };
      this.getList = function(a) {
        return b.dataObj.getList(a);
      };
      this.getFirstItem = function() {
        for (var a = null, c = 0; c < b.currentList.length; c++)
          if (b.isItemEnabled(b.currentList[c])) {
            a = b.currentList[c];
            break;
          }
        return a;
      };
      this.getPrevItem = function(a) {
        var d = null;
        if (0 <= a && a < b.currentList.length)
          for (--a; 0 <= a; a--)
            if (b.isItemEnabled(b.currentList[a])) {
              d = b.currentList[a];
              break;
            }
        return d;
      };
      this.getNextItem = function(a) {
        var d = null;
        for (a += 1; a < b.currentList.length; a++)
          if (b.isItemEnabled(b.currentList[a])) {
            d = b.currentList[a];
            break;
          }
        return d;
      };
      this.getLastItem = function() {
        for (var a = null, c = b.currentList.length - 1; 0 <= c; c--)
          if (b.isItemEnabled(b.currentList[c])) {
            a = b.currentList[c];
            break;
          }
        return a;
      };
      this.updateSelectionStatus = function(a) {
        switch (a) {
          case "shift":
            switch (b.options.selectionMode) {
              case "multi-simple":
                b.multiSelection(!0);
                b.shiftKeyStatus(!1);
                break;
              case "multi-extended":
                b.multiSelection(!0);
                b.shiftKeyStatus(!0);
                break;
              default:
                b.multiSelection(!1), b.shiftKeyStatus(!1);
            }
            break;
          case "ctrl":
            switch (b.options.selectionMode) {
              case "multi-simple":
                b.multiSelection(!0);
                break;
              case "multi-extended":
                b.multiSelection(!0);
                break;
              default:
                b.multiSelection(!1);
            }
        }
      };
      q.bind("keydown", function(a) {
        if (b.options.enabled)
          switch (a.keyCode) {
            case 16:
              b.updateSelectionStatus("shift");
              break;
            case 17:
              b.updateSelectionStatus("ctrl");
              break;
            default:
              (a.ctrlKey || a.metaKey) && b.updateSelectionStatus("ctrl"),
                a.shiftKey && b.updateSelectionStatus("shift");
          }
      });
      b.allowUpdate = !0;
      this.suspendLayout = function() {
        b.allowUpdate = !1;
      };
      this.resumeLayout = function() {
        b.allowUpdate = !0;
        b.updateLayout();
      };
      c.$on(c.name + "-refresh", function(a, c, e) {
        b.refresh(c, e);
      });
      c.$on(c.name + "-resume-layout", function(a) {
        b.resumeLayout();
      });
      c.$on(c.name + "-suspend-layout", function(a) {
        b.suspendLayout();
      });
      c.$on(c.name + "-update-layout", function(a) {
        b.updateLayout();
      });
      c.$on(c.name + "-update-view", function(a) {
        b.updateView();
      });
      c.$on(c.name + "-begin-load", function(a, c, e) {
        c
          ? (0 > b.options.loadItems.indexOf(c) && b.options.loadItems.push(c),
            b.updateView())
          : b.beginLoad(e);
      });
      c.$on(c.name + "-end-load", function(a, c) {
        b.endLoad(c);
      });
      this.callLoadComplete = function() {
        angular.isDefined(c.events) && c.events.loadComplete
          ? c.events.loadComplete()
          : c.loadComplete();
      };
      this.callUpdateComplete = function() {
        angular.isDefined(c.events) && c.events.updateComplete
          ? c.events.updateComplete()
          : c.updateComplete();
      };
      c.$on(c.name + "-get-scroll-pos", function(a) {
        m.setTempData(b.getScrollPos());
      });
      c.$on(c.name + "-set-scroll-pos", function(a, c) {
        b.setScrollPos(c);
      });
      c.$on(c.name + "-scroll-to", function(a, c, e) {
        b.scrollTo(c, e);
      });
      var D = !1,
        V = !1;
      this.shiftKeyStatus = function(a) {
        if (void 0 != a) D = a;
        else return D;
      };
      this.multiSelection = function(a) {
        if (void 0 != a) V = a;
        else return V;
      };
      this.isItemSelected = function(a) {
        return f.isSelected(a);
      };
      this.clearPrevSelection = function(a) {
        for (var d = 0; d < b.options.selectedItems.length; d++)
          a &&
          !f.isEqual(
            b.options.selectedItems[d][b.options.dataFields.id],
            a[b.options.dataFields.id]
          )
            ? (b.options.selectedItems[d][b.options.dataFields.selected] = !1)
            : a ||
              (b.options.selectedItems[d][b.options.dataFields.selected] = !1);
        b.options.selectedItems.length = 0;
        a && b.isItemEnabled(a) && b.options.selectedItems.push(a);
        b.refresh();
      };
      this.selectionCancelled = !1;
      this.shiftFirstSelectedItem = null;
      this.itemSelection = function(a, h, e) {
        if (h) {
          if ("none" !== b.options.selectionMode)
            if (b.isItemEnabled(h)) {
              var d = b.itemSelection(),
                u = !0;
              d &&
                (u =
                  !f.isEqual(
                    d[b.options.dataFields.id],
                    h[b.options.dataFields.id]
                  ) ||
                  (a && (a.ctrlKey || a.metaKey)));
              var k = !0;
              k =
                angular.isDefined(c.events) && c.events.beforeSelect
                  ? c.events.beforeSelect({ item: h })
                  : c.beforeSelect({ e: { item: h } });
              b.selectionCancelled = 0 == k;
              if (0 != k)
                if (u) {
                  var l = a && (a.shiftKey || a.ctrlKey || a.metaKey) ? !0 : !1;
                  u = !0;
                  "multi-extended" === b.options.selectionMode &&
                    (u = !b.isObjInSelList(h) || !l || D || (a && a.shiftKey));
                  u &&
                    ("one" == b.options.selectionMode
                      ? b.clearPrevSelection()
                      : qa && (D || (a && a.shiftKey))
                      ? b.clearPrevSelection()
                      : V ||
                        l ||
                        "multi-simple" === b.options.selectionMode ||
                        l ||
                        (1 != b.options.selectedItems.length &&
                          b.isObjInSelList(h)) ||
                        b.clearPrevSelection());
                  b.options.selectedItem = h;
                  if (
                    qa &&
                    (D || (a && a.shiftKey)) &&
                    "one" != b.options.selectionMode
                  ) {
                    if (
                      (b.shiftFirstSelectedItem ||
                        (b.shiftFirstSelectedItem = d),
                      (a = b.getItemCurrentIndex(b.shiftFirstSelectedItem)),
                      (e = b.getItemCurrentIndex(h)),
                      a > e && ((d = a), (a = e), (e = d)),
                      b.isIndexInRange(a) && b.isIndexInRange(e))
                    )
                      for (; a <= e; a++)
                        (b.currentList[a][b.options.dataFields.selected] = !0),
                          b.options.selectedItems.push(b.currentList[a]);
                  } else
                    qa && (V || l || "multi-simple" === b.options.selectionMode)
                      ? ((a =
                          null === h[b.options.dataFields.selected] ||
                          "undefined" === h[b.options.dataFields.selected]
                            ? !1
                            : h[b.options.dataFields.selected]),
                        (h[b.options.dataFields.selected] = !a),
                        h[b.options.dataFields.selected]
                          ? b.isObjInSelList(h) ||
                            b.options.selectedItems.push(h)
                          : (b.options.selectedItems = b.options.selectedItems.filter(
                              function(a) {
                                return a != h;
                              }
                            )))
                      : ((h[b.options.dataFields.selected] = !0),
                        b.isObjInSelList(h) || b.options.selectedItems.push(h)),
                      (b.shiftFirstSelectedItem = null);
                  angular.isDefined(c.selectedItem) && (c.selectedItem = h);
                  b.callAfterSelect(h);
                  b.refresh(null, null, !0);
                } else
                  V || l || "multi-simple" === b.options.selectionMode
                    ? ((a =
                        null === h[b.options.dataFields.selected] ||
                        "undefined" === h[b.options.dataFields.selected]
                          ? !1
                          : h[b.options.dataFields.selected]),
                      e && "undefined" !== e && (a = e),
                      (h[b.options.dataFields.selected] = !a),
                      h[b.options.dataFields.selected]
                        ? b.isObjInSelList(h) || b.options.selectedItems.push(h)
                        : (b.options.selectedItems = b.options.selectedItems.filter(
                            function(a) {
                              return a != h;
                            }
                          )),
                      (b.shiftFirstSelectedItem = null),
                      b.callAfterSelect(h),
                      b.refresh(null, null, !0))
                    : V ||
                      l ||
                      "multi-simple" === b.options.selectionMode ||
                      (l ||
                        (1 != b.options.selectedItems.length &&
                          b.isObjInSelList(h)) ||
                        b.clearPrevSelection(h),
                      (b.shiftFirstSelectedItem = null));
            } else b.clearPrevSelection();
        } else return b.options.selectedItem;
      };
      this.updateSelection = function(a, c) {
        var d = a && (a.shiftKey || a.ctrlKey || a.metaKey) ? !0 : !1;
        !(
          "multi-extended" == b.options.selectionMode &&
          0 < b.options.selectedItems.length
        ) ||
          D ||
          a.shiftKey ||
          V ||
          d ||
          b.selectionCancelled ||
          ((b.isObjInSelList(c) && a && 3 == a.which) || b.clearPrevSelection(),
          (c[b.options.dataFields.selected] = !0),
          b.options.selectedItems.push(c),
          b.callAfterSelect(c),
          b.refresh(null, null, !0));
        b.selectionCancelled = !1;
      };
      this.selectFirstItem = function() {
        for (var a = null, c = 0; c < b.currentList.length; c++)
          if (b.isItemEnabled(b.currentList[c])) {
            a = b.currentList[c];
            break;
          }
        this.itemSelection(null, a);
        return b.options.selectedItem;
      };
      this.isObjInSelList = function(a) {
        var d = !1,
          c = b.options.selectedItems;
        if (a && c)
          for (var e = 0; e < c.length; e++)
            if (
              f.isEqual(
                c[e][b.options.dataFields.id],
                a[b.options.dataFields.id]
              )
            ) {
              d = !0;
              break;
            }
        return d;
      };
      this.getItemAt = function(a, c) {
        var d = null,
          h = q.find("li");
        if (h && 0 < h.length)
          for (var e = 0; e < h.length; e++) {
            var k = angular.element(h[e]);
            var l = f.getPageRect(k);
            if (f.checkHit(a, c, l)) {
              d = b.getItemFromElem(k);
              break;
            }
          }
        return d;
      };
      this.resetSelection = function() {
        switch (b.options.selectionMode) {
          case "none":
            b.clearPrevSelection();
            break;
          default:
            b.clearPrevSelection(b.itemSelection());
        }
      };
      c.$on(c.name + "-clear-selection", function(a) {
        b.clearPrevSelection();
        b.options.selectedItem = null;
      });
      c.$on(c.name + "-get-selected-item", function(a) {
        m.setTempData(b.itemSelection());
      });
      c.$on(c.name + "-set-selected-item", function(a, c) {
        var d = e(function() {
          b.itemSelection(null, c);
          e.cancel(d);
        }, 1);
      });
      c.$on(c.name + "-get-selected-items", function(a) {
        m.setTempData(b.options.selectedItems);
      });
      c.$on(c.name + "-set-selected-items", function(a, c) {
        if (c && Array.isArray(c))
          var d = e(function() {
            for (
              var a = (b.options.selectedItems.length = 0);
              a < c.length;
              a++
            )
              (c[a][b.options.dataFields.selected] = !0),
                b.options.selectedItems.push(c[a]);
            0 < c.length
              ? ((b.options.selectedItem = c[c.length - 1]),
                b.callAfterSelect(b.options.selectedItem))
              : (b.options.selectedItem = null);
            b.refresh(null, null, !0);
            e.cancel(d);
          }, 1);
      });
      c.$on(c.name + "-move-item", function(a, c, e, f, k) {
        b.moveItem(c, e, f, k);
      });
      c.$watch(
        "options",
        function(a, c) {
          a !== c && (b.updateOptions(a), b.updateLayout());
        },
        !0
      );
      c.$watch("allowDrag", function(a, c) {
        a !== c && ((b.options.allowDrag = a), b.updateView());
      });
      c.$watch("allowDrop", function(a, c) {
        a !== c && ((b.options.allowDrop = a), b.updateView());
      });
      c.$watch("allowFocus", function(a, c) {
        a !== c && (b.options.allowFocus = a);
      });
      c.$watch("autoCheck", function(a, c) {
        a !== c && ((b.options.autoCheck = a), b.updateView());
      });
      c.$watch("autoExpand", function(a, c) {
        a !== c && (b.options.autoExpand = a);
      });
      c.$watch("autoSize", function(a, c) {
        a !== c && ((b.options.autoSize = a), b.updateLayout());
      });
      c.$watch("autoUpdate", function(a, c) {
        a !== c && ((b.options.autoUpdate = a), b.updateLayout());
      });
      c.$watch("checkBoxSettings", function(a, c) {
        a !== c && b.updateCheckBoxSettings(a);
      });
      c.$watch("controlStyle", function(a, c) {
        a !== c && b.updateControlStyle(a);
      });
      c.$watch("editorSettings", function(a, c) {
        a !== c && b.updateEditorSettings(a);
      });
      c.$watch("enabled", function(a, c) {
        a !== c &&
          ((b.options.enabled = a), b.updateView(), b.callEnabledChanged(a));
      });
      c.$watch("fields", function(a, c) {
        a !== c && ((b.options.dataFields = a), b.UpdateData());
      });
      c.$watch("hoverSelection", function(a, c) {
        a !== c && (b.options.hoverSelection = a);
      });
      c.$watch("indent", function(a, c) {
        a !== c && ((b.options.indent = a), b.updateLayout());
      });
      c.$watch("itemIcon", function(a, c) {
        a !== c && ((b.options.itemIcon = a), b.updateLayout());
      });
      c.$watch("labelEdit", function(a, c) {
        a !== c && (b.options.labelEdit = a);
      });
      c.$watch("maxItems", function(a, c) {
        a !== c && (b.options.maxItems = a);
      });
      c.$watch("mouseWheelSpeed", function(a, c) {
        a !== c && (b.options.mouseWheelSpeed = a);
      });
      c.$watch("pathSeparator", function(a, c) {
        a !== c && (b.options.pathSeparator = a);
      });
      c.$watch("rtl", function(a, c) {
        a !== c && ((b.options.rtl = a), b.updateLayout());
      });
      c.$watch("selectionMode", function(a, c) {
        a !== c && ((b.options.selectionMode = a), b.resetSelection());
      });
      c.$watch("showCheckBoxes", function(a, c) {
        a !== c && ((b.options.showCheckBoxes = a), b.updateLayout());
      });
      c.$watch("showExpandBoxes", function(a, c) {
        a !== c && ((b.options.showExpandBoxes = a), b.updateLayout());
      });
      c.$watch("showIcons", function(a, c) {
        a !== c && ((b.options.showIcons = a), b.updateLayout());
      });
      c.$watch("showLines", function(a, c) {
        a !== c && ((b.options.showLines = a), b.updateLayout());
      });
      c.$watch("showStatusIcons", function(a, c) {
        a !== c && ((b.options.showStatusIcons = a), b.updateLayout());
      });
      c.$watch("selectedItem", function(a, c) {
        a !== c &&
          (c && (c[b.options.dataFields.selected] = !1),
          (b.options.selectedItem = a),
          b.callAfterSelect(a));
      });
      c.$watch("templateSettings", function(a, c) {
        a !== c && (b.updateTemplateSettings(a), b.updateLayout());
      });
      this.sortComparer = null;
      c.$watch("sorting", function(a, c) {
        a !== c && (b.options.sorting = a);
      });
      c.$on(c.name + "-sort", function(a, c, e) {
        b.sort(c, e);
      });
      this.sort = function(a, c) {
        b.sortComparer = c;
        if ("ascending" == a || "descending" == a || "none" == a)
          b.options.sorting = a;
        b.updateCurrentLayout();
        b.callChange();
      };
      this.isSortingAllowed = function() {
        return (
          "ascending" == b.options.sorting || "descending" == b.options.sorting
        );
      };
      this.applySorting = function(a) {
        a &&
          (b.sortComparer
            ? a.sort(b.sortComparer)
            : b.isSortingAllowed() &&
              a.sort(function(a, c) {
                var d, e;
                (d = a[b.options.dataFields.value]) ||
                  (d = a[b.options.dataFields.text]);
                f.isObject(d) && (d = d.value ? d.value : d.text);
                (e = c[b.options.dataFields.value]) ||
                  (e = c[b.options.dataFields.text]);
                f.isObject(e) && (e = e.value ? e.value : e.text);
                d = void 0 != d ? d : null;
                e = void 0 != e ? e : null;
                switch (b.options.sorting) {
                  case "ascending":
                    if (d < e) return -1;
                    if (d > e) return 1;
                    break;
                  case "descending":
                    if (d > e) return -1;
                    if (d < e) return 1;
                    break;
                  default:
                    return 0;
                }
              }));
      };
      var Ka = function(a) {
        if (a) {
          var c = f.isFieldAvailable(a.general, "iui-checkbox");
          a = (a = a.box)
            ? {
                general: f.isFieldAvailable(a.general, "iui-checkbox-box"),
                disabled: f.isFieldAvailable(
                  a.disabled,
                  "iui-checkbox-disabled"
                ),
                checked: f.isFieldAvailable(a.checked, "iui-checkbox-checked"),
                indeterminate: f.isFieldAvailable(
                  a.indeterminate,
                  "iui-checkbox-indeterminate"
                ),
                unchecked: f.isFieldAvailable(
                  a.unchecked,
                  "iui-checkbox-unchecked"
                )
              }
            : b.options.controlStyle.item.checkBox.box;
          return { general: c, box: a };
        }
        return b.options.controlStyle.item.checkBox;
      };
      this.getExpandBoxStyle = function(a) {
        return a
          ? {
              general: f.isFieldAvailable(a.general, "iui-treeview-expand-box"),
              animated: f.isFieldAvailable(
                a.animated,
                "iui-treeview-expand-box-load"
              ),
              expanded: f.isFieldAvailable(
                a.expanded,
                "iui-treeview-expand-box-open"
              ),
              collapsed: f.isFieldAvailable(
                a.collapsed,
                "iui-treeview-expand-box-close"
              )
            }
          : b.options.controlStyle.item.expandBox;
      };
      var Aa = function(a) {
        if (a) {
          var c = a.general;
          c = f.isString(c)
            ? c
            : c
            ? {
                disabled: f.isFieldAvailable(
                  c.disabled,
                  "iui-treeview-item-disabled"
                ),
                focused: f.isFieldAvailable(
                  c.focused,
                  "iui-treeview-item-focused"
                ),
                normal: f.isFieldAvailable(c.normal, "iui-treeview-item"),
                hovered: f.isFieldAvailable(
                  c.hovered,
                  "iui-treeview-item-hovered"
                ),
                selected: f.isFieldAvailable(
                  c.selected,
                  "iui-treeview-item-selected"
                )
              }
            : b.options.controlStyle.item.general;
          var d = Ka(a.checkBox),
            e = b.getExpandBoxStyle(a.expandBox);
          var k = a.content;
          k = f.isString(k)
            ? k
            : k
            ? {
                disabled: f.isFieldAvailable(
                  k.disabled,
                  "iui-treeview-item-content-disabled"
                ),
                focused: f.isFieldAvailable(
                  k.focused,
                  "iui-treeview-item-content-focused"
                ),
                normal: f.isFieldAvailable(
                  k.normal,
                  "iui-treeview-item-content"
                ),
                hovered: f.isFieldAvailable(
                  k.hovered,
                  "iui-treeview-item-content-hovered"
                ),
                selected: f.isFieldAvailable(
                  k.selected,
                  "iui-treeview-item-content-selected"
                )
              }
            : b.options.controlStyle.item.content;
          a = a.fixed;
          a = f.isString(a)
            ? a
            : a
            ? {
                disabled: f.isFieldAvailable(
                  a.disabled,
                  "iui-treeview-item-fixed-disabled"
                ),
                normal: f.isFieldAvailable(a.normal, "iui-treeview-item-fixed"),
                hovered: f.isFieldAvailable(
                  a.hovered,
                  "iui-treeview-item-fixed-hovered"
                )
              }
            : b.options.controlStyle.item.fixed;
          return {
            general: c,
            checkBox: d,
            expandBox: e,
            content: k,
            fixed: a
          };
        }
        return b.options.controlStyle.item;
      };
      this.updateControlStyle = function(a) {
        b.options.controlStyle = a
          ? {
              general: f.isFieldAvailable(a.general, "iui-treeview"),
              item: Aa(a.item)
            }
          : {
              general: f.isFieldAvailable(
                b.defaultStyle.general,
                "iui-treeview"
              ),
              item: Aa(b.defaultStyle.item)
            };
      };
      this.getCurrentItemStyle = function(a, c) {
        var d = b.options.controlStyle.item;
        if (a)
          switch (a.style) {
            case "initial":
              break;
            case "parent":
              return b.getCurrentItemStyle(b.getParent(a), c);
            default:
              null != a.style && (d = a.style);
          }
        if (c) {
          if (f.isString(d.general)) return d.general;
          if (b.isItemFixed(a))
            switch (c) {
              case "disabled":
                return d.fixed && d.fixed.disabled
                  ? d.fixed.disabled
                  : b.options.controlStyle.item.fixed.disabled;
              case "hovered":
                return d.fixed && d.fixed.hovered
                  ? d.fixed.hovered
                  : b.options.controlStyle.item.fixed.hovered;
              default:
                return d.fixed && d.fixed.normal
                  ? d.fixed.normal
                  : b.options.controlStyle.item.fixed.normal;
            }
          else
            switch (c) {
              case "disabled":
                return d.general && d.general.disabled
                  ? d.general.disabled
                  : b.options.controlStyle.item.general.disabled;
              case "focused":
                return d.general && d.general.focused
                  ? d.general.focused
                  : b.options.controlStyle.item.general.focused;
              case "hovered":
                return d.general && d.general.hovered
                  ? d.general.hovered
                  : b.options.controlStyle.item.general.hovered;
              case "selected":
                return d.general && d.general.selected
                  ? d.general.selected
                  : b.options.controlStyle.item.general.selected;
              default:
                return d.general && d.general.normal
                  ? d.general.normal
                  : b.options.controlStyle.item.general.normal;
            }
        } else return d ? d : b.options.controlStyle.item;
      };
      this.getCurrentItemContentStyle = function(a, c) {
        var d = b.options.controlStyle.item.content;
        if (a)
          switch (a.style) {
            case "initial":
              break;
            case "parent":
              return b.getCurrentItemContentStyle(b.getParent(a), c);
            default:
              null != a.style && a.style.content && (d = a.style.content);
          }
        if (c) {
          if (f.isString(d)) return d;
          switch (c) {
            case "disabled":
              return d && d.disabled
                ? d.disabled
                : b.options.controlStyle.item.content.disabled;
            case "focused":
              return d && d.focused
                ? d.focused
                : b.options.controlStyle.item.content.focused;
            case "hovered":
              return d && d.hovered
                ? d.hovered
                : b.options.controlStyle.item.content.hovered;
            case "selected":
              return d && d.selected
                ? d.selected
                : b.options.controlStyle.item.content.selected;
            default:
              return d && d.normal
                ? d.normal
                : b.options.controlStyle.item.content.normal;
          }
        } else return d ? d : b.options.controlStyle.item.content;
      };
    }
  ])
  .directive("iuiTreeview", [
    "$compile",
    "$timeout",
    "$interval",
    "IntegralUIInternalService",
    "IntegralUIDragDrop",
    "$window",
    function(c, q, e, l, n, f) {
      return {
        restrict: "EA",
        controller: "IntegralUITreeViewController",
        transclude: !0,
        replace: !0,
        template:
          '<div class="iui-treeview" data-element="treeview"><ul class="iui-treeview-block-top"></ul><ul class="iui-treeview-block"></ul><ul class="iui-treeview-block-bottom"></ul></div>',
        scope: {
          allowAnimation: "=",
          allowDrag: "=",
          allowDrop: "=",
          allowFocus: "=",
          animationSpeed: "=",
          autoCheck: "=",
          autoExpand: "=",
          autoSize: "=",
          autoUpdate: "=",
          checkboxSettings: "=",
          controlStyle: "=",
          editorSettings: "=",
          enabled: "=",
          fields: "=",
          hoverSelection: "=",
          itemIcon: "=",
          indent: "=",
          items: "=",
          labelEdit: "=",
          maxItems: "=",
          mouseWheelSpeed: "@",
          name: "@",
          options: "=?",
          pathSeparator: "@",
          rtl: "=",
          selectedIndex: "=",
          selectedItem: "=",
          selectionMode: "@",
          showCheckBoxes: "=",
          showExpandBoxes: "=",
          showIcons: "=",
          showLines: "=",
          showStatusIcons: "=",
          sorting: "@",
          templateSettings: "=",
          afterCollapse: "&",
          afterEdit: "&",
          afterExpand: "&",
          afterLabelEdit: "&",
          afterSelect: "&",
          beforeCollapse: "&",
          beforeEdit: "&",
          beforeExpand: "&",
          beforeLabelEdit: "&",
          beforeSelect: "&",
          change: "&",
          clear: "&",
          dragDrop: "&",
          dragEnter: "&",
          dragLeave: "&",
          dragOver: "&",
          enabledChanged: "&",
          events: "=?",
          itemAdded: "&",
          itemAdding: "&",
          itemCheckedChanging: "&",
          itemCheckedChanged: "&",
          itemCheckstateChanging: "&",
          itemCheckstateChanged: "&",
          itemClick: "&",
          itemDblclick: "&",
          itemHover: "&",
          loadComplete: "&",
          gotFocus: "&",
          keyDown: "&",
          keyPress: "&",
          keyUp: "&",
          lostFocus: "&",
          itemRemoved: "&",
          itemRemoving: "&",
          itemRightclick: "&",
          scrollposChanged: "&",
          selectionChanged: "&",
          updateComplete: "&"
        },
        link: function(k, m, U, a, b) {
          var w = this,
            H = m.children().eq(0),
            C = m.children().eq(1),
            I = m.children().eq(2),
            y = angular.element(
              '<div class="iui-scrollbar-vertical"><div class="iui-scroll-button-thumb-vertical"></div></div>'
            ),
            A = angular.element(
              '<div class="iui-scrollbar-horizontal"><div class="iui-scroll-button-thumb-horizontal"></div></div>'
            ),
            O = angular.element('<div class="iui-scrollbar-corner"></div>'),
            Y = null,
            ea = null,
            fa = null,
            B = a.getEditBox(),
            $a = function() {
              var b = "iui-treeview-block";
              a.options.rtl && (b += " " + b + "-rtl");
              return b;
            };
          k.$on("$destroy", function(a) {
            // w.s2t();
            aa && (q.cancel(aa), (aa = null));
            m.unbind(
              "click dblclick dragenter dragleave dragend drop keydown mousedown mouseleave mousemove mousewheel scroll touchstart touchmove touchend"
            );
            angular.element(f).unbind("dragenter", rb);
            angular.element(f).unbind("dragover", sb);
            angular.element(f).unbind("dragend", tb);
            angular.element(f).unbind("keyup", ub);
            angular.element(f).unbind("mousemove", vb);
            angular.element(f).unbind("mouseup", wb);
            B && B.unbind("blur focus keydown mousedown");
            H && H.unbind("dragover");
            I && I.unbind("dragover");
            Aa();
            v && v.$destroy();
          });
          m.append(a.getDropMarkWindow());
          a.dropMark();
          var Z = function(b) {
            b.dataTransfer
              ? (b.dataTransfer.dropEffect = "none")
              : b.originalEvent &&
                b.originalEvent.dataTransfer &&
                (b.originalEvent.dataTransfer.dropEffect = "none");
            a.dropMark();
          };
          H.bind("dragover", function(a) {
            Z(a);
            a.stopPropagation();
          });
          I.bind("dragover", function(a) {
            Z(a);
            a.stopPropagation();
          });
          var za = function() {
            Y && (q.cancel(Y), (Y = null));
          };
          a.addDropMark = function() {
            var b = m[0];
            for (var c = null; b; ) {
              if (b === document.getElementsByTagName("body")[0]) {
                c = b;
                break;
              }
              b = b.offsetParent;
            }
            if ((b = c))
              angular.element(b).append(a.getDropMarkWindow()), a.dropMark();
          };
          a.removeDropMark = function() {
            a.getDropMarkWindow().remove();
          };
          var La = function(b, c) {
              a.labelEditStatus() && a.closeEditor();
              b.preventDefault();
              var d = !0;
              b.dataTransfer
                ? (d = "none" === b.dataTransfer.effectAllowed ? !1 : !0)
                : b.originalEvent &&
                  b.originalEvent.dataTransfer &&
                  (d =
                    "none" === b.originalEvent.dataTransfer.effectAllowed
                      ? !1
                      : !0);
              if (d) {
                var g = a.getItemFromChildElem(c);
                if (g) {
                  d = c[0].getBoundingClientRect();
                  var N = kb(),
                    p = a.getMousePos(b);
                  p.x -= d.left + N.x;
                  p.y -= d.top + N.y;
                  N = n.getDropPos(p, {
                    x: 0,
                    y: 0,
                    width: c[0].offsetWidth,
                    height: c[0].offsetHeight
                  });
                  p = n.getData();
                  d = a.isDropAllowed(p.source, g, N);
                  var e = {
                    event: b,
                    sourceTree: p.sourceCtrl ? p.sourceCtrl.getCtrlName() : "",
                    dragItem: p.source,
                    targetTree: a.getCtrlName(),
                    targetItem: g,
                    isDropAllowed: d,
                    dropPos: N,
                    mousePos: a.getMousePos(b)
                  };
                  e = a.callDragOver(e);
                  if (d && 0 != e) {
                    var f = a.getMousePos(b);
                    e = f.y + 16;
                    f = f.x + 20;
                    var k = a.getDropMarkWindow();
                    k.empty();
                    var h = "iui-drop-marker-move-in";
                    switch (N) {
                      case 1:
                        h = "iui-drop-marker-move-up";
                        break;
                      case 2:
                        h = "iui-drop-marker-move-down";
                    }
                    k.append(
                      "<span class='" +
                        h +
                        "'></span><span class='iui-drop-marker-title'>" +
                        g[a.options.dataFields.text] +
                        "</span>"
                    );
                    a.updateDropMarkElem(a.getDropMarkWindow(), {
                      top: e,
                      left: f
                    });
                    a.dropMark(d);
                    n.setData({
                      source: p.source,
                      sourceList: p.sourceList,
                      target: g,
                      dropPos: N
                    });
                  } else
                    b.dataTransfer
                      ? (b.dataTransfer.dropEffect = "none")
                      : b.originalEvent &&
                        b.originalEvent.dataTransfer &&
                        (b.originalEvent.dataTransfer.dropEffect = "none"),
                      a.dropMark();
                }
              }
            },
            qa = function(b, c) {
              b.preventDefault();
              za();
              a.dropMark();
              var d = !0;
              b.dataTransfer
                ? (d = "none" === b.dataTransfer.effectAllowed ? !1 : !0)
                : b.originalEvent &&
                  b.originalEvent.dataTransfer &&
                  (d =
                    "none" === b.originalEvent.dataTransfer.effectAllowed
                      ? !1
                      : !0);
              if (d) {
                var g = a.getItemFromChildElem(c);
                if (g) {
                  var p = n.getData(),
                    e = p.source;
                  e || (e = a.getDnDSource(b));
                  (d = a.isDropAllowed(e, g, p.dropPos)) &&
                    e &&
                    ((d = {
                      event: b,
                      sourceTree: p.sourceCtrl
                        ? p.sourceCtrl.getCtrlName()
                        : "",
                      dragItem: e,
                      targetTree: a.getCtrlName(),
                      targetItem: g,
                      isDropAllowed: d,
                      dropPos: p.dropPos,
                      mousePos: a.getMousePos(b)
                    }),
                    !1 !== a.callDragDrop(d) &&
                      (a.drop(p), k.$$phase || k.$apply()));
                }
              }
              n.clearData();
              a.dragDropStatus(!1);
              b.stopPropagation();
            },
            D = angular.element(
              '<div style="opacity:0.75;position:absolute;z-index:999"></div>'
            ),
            V = function() {
              D &&
                (D.remove(),
                D.css("top", "-9999999px"),
                D.css("left", "-9999999px"));
            },
            Ka = function(b) {
              var c = "";
              if (a.options.showExpandBoxes) {
                var d = a.defaultStyle.item.expandBox.general;
                b[a.options.dataFields.style] &&
                b[a.options.dataFields.style].expandBox &&
                b[a.options.dataFields.style].expandBox.general != d
                  ? (d += " " + b[a.options.dataFields.style].expandBox.general)
                  : a.options.controlStyle.item.expandBox.general != d &&
                    (d += " " + a.options.controlStyle.item.expandBox.general);
                var g = a.getCurrentItemStyle(b);
                g = a.getExpandBoxStyle(g.expandBox);
                if (
                  a.isThereChildItems ||
                  (b && b[a.options.dataFields.hasChildren])
                )
                  c = d;
                d =
                  b[a.options.dataFields.hasChildren] &&
                  (a.isThereVisibleChildren(b) ||
                    !b[a.options.dataFields.items] ||
                    (b[a.options.dataFields.items] &&
                      0 == b[a.options.dataFields.items].length));
                b &&
                  !a.isItemFixed(b) &&
                  (d || a.isThereVisibleChildren(b)) &&
                  (0 <= a.options.loadItems.indexOf(b)
                    ? (c += " " + g.animated)
                    : ((c =
                        b[a.options.dataFields.hasChildren] &&
                        void 0 === b[a.options.dataFields.expanded]
                          ? c + (" " + g.expanded)
                          : 0 != b[a.options.dataFields.expanded]
                          ? c + (" " + g.collapsed)
                          : c + (" " + g.expanded)),
                      !0 === a.options.rtl && (c += "-rtl"),
                      (a.options.enabled && a.isItemEnabled(b)) ||
                        (c += "-disabled")));
              }
              return c;
            },
            Aa = function() {
              var b = C.find("li");
              if (0 < b.length)
                for (var c = 0; c < b.length; c++) {
                  currentElem = angular.element(b[c]);
                  currentElem.unbind(
                    "dragover drop dragenter dragleave dragend"
                  );
                  var d = a.getElement(currentElem, "expandbox");
                  d && d.unbind("click dblclick touchend");
                  (d = a.getElement(currentElem)) &&
                    d.unbind(
                      "blur click dragstart dragover drop dragenter dragleave dragend dblclick focus keydown keypress keyup mouseenter mouseleave mousedown mouseup touchstart touchmove touchend"
                    );
                }
              for (d = 0; 2 > d; ) {
                if ((b = 0 == d ? H.find("li") : I.find("li")) && 0 < b.length)
                  for (c = 0; c < b.length; c++) {
                    currentElem = angular.element(b[c]);
                    var t = a.getElement(currentElem);
                    t &&
                      t.unbind(
                        "click dblclick mouseenter mouseleave mousedown touchstart"
                      );
                  }
                d++;
              }
            },
            d = function() {
              var b = C.find("li");
              if (0 < b.length) {
                var c = b.length - 1,
                  d = "content";
                a.getTemplateUrl() && (d = "template-content");
                for (var t = 0; t <= c; t++) {
                  var N = angular.element(b[t]);
                  h(N);
                  u(a.getElement(N, "expandbox"));
                  r(a.getElement(N, "icon"));
                  Qb(a.getElement(N, d));
                }
              }
              for (c = 0; 2 > c; ) {
                if ((b = 0 == c ? H.find("li") : I.find("li")) && 0 < b.length)
                  for (
                    d = "content",
                      a.getTemplateUrl() && (d = "template-content"),
                      t = 0;
                    t < b.length;
                    t++
                  )
                    (N = angular.element(b[t])), Rb(a.getElement(N, d));
                c++;
              }
            },
            h = function(b) {
              b &&
                (b.bind("dragover", function(b) {
                  var c = a.getItemFromElem(this);
                  if (c && a.isItemEnabled(c)) {
                    if (a.isScrollBarVisible("vertical")) {
                      c = a.getMousePos(b);
                      var d = m[0].getBoundingClientRect();
                      c.x -= angular.element(f)[0].pageXOffset;
                      c.y -= angular.element(f)[0].pageYOffset;
                      c.y < d.top + 40
                        ? ab(b, !1)
                        : c.y > d.bottom - 40
                        ? ab(b, !0)
                        : ra();
                    } else ra();
                    a.isItemDragOverHandled = !0;
                    a.options.autoSize || b.stopPropagation();
                  }
                }),
                b.bind("dragleave", function(b) {
                  a.isItemDragOverHandled = !1;
                }),
                b.bind("dragend", function(b) {
                  var c = a.getItemFromElem(this);
                  c &&
                    a.isItemEnabled(c) &&
                    (b.preventDefault(),
                    a.dragDropStatus(!1),
                    a.dropMark(),
                    n.getData().source || n.clearData());
                }));
            },
            u = function(b) {
              b &&
                (b.bind("dblclick", function(b) {
                  var c = angular.element(this);
                  (c = a.getItemFromChildElem(c)) &&
                    a.isItemEnabled(c) &&
                    (a.toggle(c), b.stopPropagation());
                }),
                b.bind("click", function(b) {
                  var c = angular.element(this);
                  (c = a.getItemFromChildElem(c)) &&
                    a.isItemEnabled(c) &&
                    (a.toggle(c), b.stopPropagation());
                }),
                b.bind("touchend", function(b) {
                  b.preventDefault();
                  var c = angular.element(this);
                  (c = a.getItemFromChildElem(c)) &&
                    a.isItemEnabled(c) &&
                    (a.toggle(c), b.stopPropagation());
                }));
            },
            r = function(b) {
              b &&
                (b.bind("dragover", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && La(b, angular.element(this));
                }),
                b.bind("drop", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && qa(b, angular.element(this));
                }));
            };
          a.dragIcon = document.createElement("img");
          a.dragIcon.width = 1;
          var Za = { x: 0, y: 0 },
            wa = { x: 0, y: 0 },
            xa = !1,
            jb = !1,
            da = null,
            kb = function() {
              return {
                x: angular.element(f)[0].pageXOffset,
                y: angular.element(f)[0].pageYOffset
              };
            },
            ya = function(a) {
              var b = kb();
              return { x: a.x - b.x, y: a.y - b.y };
            },
            Qb = function(b) {
              if (b) {
                b.bind("dragstart", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (c && a.isItemEnabled(c))
                    if (((c = angular.element(this)), a.labelEditStatus()))
                      b.preventDefault();
                    else {
                      document.activeElement && document.activeElement.blur();
                      n.clearData();
                      if ((c = a.getItemFromChildElem(c)))
                        if ((bb(), a.isDragAllowed(c))) {
                          a.dragDropStatus(!0);
                          a.addDropMark();
                          b.dataTransfer
                            ? ((b.dataTransfer.effectAllowed = "move"),
                              b.dataTransfer.setData(
                                "text",
                                c[a.options.dataFields.id]
                                  ? c[a.options.dataFields.id].toString()
                                  : ""
                              ))
                            : b.originalEvent &&
                              b.originalEvent.dataTransfer &&
                              ((b.originalEvent.dataTransfer.effectAllowed =
                                "move"),
                              b.originalEvent.dataTransfer.setData(
                                "text",
                                c[a.options.dataFields.id]
                                  ? c[a.options.dataFields.id].toString()
                                  : ""
                              ));
                          c = {
                            source: c,
                            sourceCtrl: a,
                            sourceCollection: a.dataObj
                          };
                          switch (a.options.selectionMode) {
                            case "multi-simple":
                              c.source = a.options.selectedItems;
                              break;
                            case "multi-extended":
                              c.source = a.options.selectedItems;
                          }
                          n.setData(c);
                        } else
                          b.dataTransfer
                            ? (b.dataTransfer.effectAllowed = "none")
                            : b.originalEvent &&
                              b.originalEvent.dataTransfer &&
                              (b.originalEvent.dataTransfer.effectAllowed =
                                "none");
                      b.stopPropagation();
                    }
                });
                b.bind("dragover", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && La(b, angular.element(this));
                });
                b.bind("drop", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && qa(b, angular.element(this));
                });
                b.bind("dragenter", function(b) {
                  b.preventDefault();
                  var c = angular.element(this),
                    d = a.getItemFromChildElem(c);
                  if (
                    d &&
                    a.isItemEnabled(d) &&
                    (Ma || ((a.hoverItem = d), a.refresh(d)),
                    a.options.autoExpand)
                  )
                    var g = q(function() {
                      Y ||
                        (Y = q(function() {
                          Y && a.toggle(d, !0);
                        }, 750));
                      q.cancel(g);
                    }, 1);
                  c = n.getData();
                  c.source || (c.source = a.getDnDSource(b));
                  c = {
                    event: b,
                    sourceTree: c.sourceCtrl ? c.sourceCtrl.getCtrlName() : "",
                    dragItem: c.source,
                    targetTree: a.getCtrlName(),
                    targetItem: c.target,
                    mousePos: a.getMousePos(b)
                  };
                  a.callDragEnter(c);
                  b.stopPropagation();
                });
                b.bind("dragleave", function(b) {
                  b.preventDefault();
                  a.hoverItem = null;
                  var c = angular.element(this);
                  (c = a.getItemFromChildElem(c)) &&
                    a.isItemEnabled(c) &&
                    a.refresh(c);
                  za();
                  c = n.getData();
                  c.source || (c.source = a.getDnDSource(b));
                  c = {
                    event: b,
                    sourceTree: c.sourceCtrl ? c.sourceCtrl.getCtrlName() : "",
                    dragItem: c.source,
                    targetTree: a.getCtrlName(),
                    targetItem: c.target,
                    mousePos: a.getMousePos(b)
                  };
                  a.callDragLeave(c);
                  b.stopPropagation();
                });
                b.bind("dragend", function(b) {
                  (b = a.getItemFromChildElem(this)) &&
                    a.isItemEnabled(b) &&
                    a.dragDropStatus(!1);
                });
                b.bind("touchstart", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (
                    c &&
                    a.isItemEnabled(c) &&
                    (b.preventDefault(),
                    (c = a.getTouchData(b)) && 0 < c.length)
                  ) {
                    jb = !0;
                    var d = q(function() {
                      jb = !1;
                      q.cancel(d);
                    }, 750);
                    Za = ya({ x: c[0].pageX, y: c[0].pageY });
                    a.mouseButtonStatus(!0);
                    c = Za;
                    if ((c = a.getItemAt(c.x, c.y)) && a.isItemEnabled(c)) {
                      var g = angular.element(this);
                      a.itemSelection(b, c);
                      da = c;
                      g[0].focus();
                      a.changeCheckValue(c);
                      "click" == a.options.editorSettings.activate &&
                        Na(b, angular.element(this));
                    }
                  }
                });
                b.bind("touchmove", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (
                    c &&
                    a.isItemEnabled(c) &&
                    (c = a.getTouchData(b)) &&
                    0 < c.length
                  ) {
                    wa = ya({ x: c[0].pageX, y: c[0].pageY });
                    c = Math.abs(wa.x - Za.x);
                    var d = Math.abs(wa.y - Za.y),
                      g = m[0].getBoundingClientRect();
                    if (n.hitTest(wa.x, wa.y, g)) {
                      if (
                        (b.preventDefault(),
                        D && D.css("display", "block"),
                        !jb)
                      )
                        if (
                          !xa &&
                          (2 < c || 2 < d) &&
                          da &&
                          a.isItemEnabled(da)
                        )
                          if ((angular.element(this), a.labelEditStatus()))
                            b.preventDefault();
                          else {
                            xa = !0;
                            n.clearData();
                            if (
                              (c = a.getTouchData(b)) &&
                              0 < c.length &&
                              (ya({ x: c[0].pageX, y: c[0].pageY }),
                              da && (bb(), a.isDragAllowed(da)))
                            ) {
                              a.dragDropStatus(!0);
                              a.addDropMark();
                              c = {
                                source: da,
                                sourceCtrl: a,
                                sourceCollection: a.dataObj
                              };
                              switch (a.options.selectionMode) {
                                case "multi-simple":
                                  c.source = a.options.selectedItems;
                                  break;
                                case "multi-extended":
                                  c.source = a.options.selectedItems;
                              }
                              n.setData(c);
                              if ((c = a.getElemFromItem(da)))
                                if ((c = a.getElement(c)))
                                  D.empty(),
                                    D.append(c.clone()),
                                    D.css("display", "none"),
                                    m.append(D);
                            }
                            b.stopPropagation();
                          }
                        else if (xa) {
                          angular.element(this);
                          a.labelEditStatus() && a.closeEditor();
                          b.preventDefault();
                          if ((c = a.getTouchData(b)) && 0 < c.length) {
                            g = kb();
                            var t = ya({ x: c[0].pageX, y: c[0].pageY });
                            if ((c = a.getItemAt(t.x, t.y))) {
                              if ((d = a.getElemFromItem(c))) {
                                var p = d[0].getBoundingClientRect();
                                p = n.getDropPos(
                                  { x: t.x - p.left, y: t.y - p.top },
                                  {
                                    x: 0,
                                    y: 0,
                                    width: d[0].offsetWidth,
                                    height: d[0].offsetHeight
                                  }
                                );
                                d = n.getData();
                                var e = a.isDropAllowed(d.source, c, p),
                                  E = {
                                    event: b,
                                    sourceTree: d.sourceCtrl
                                      ? d.sourceCtrl.getCtrlName()
                                      : "",
                                    dragItem: d.source,
                                    targetTree: a.getCtrlName(),
                                    targetItem: c,
                                    isDropAllowed: e,
                                    dropPos: p,
                                    mousePos: t
                                  };
                                E = a.callDragOver(E);
                                var f = m[0].getBoundingClientRect();
                                var h = t.x - f.left;
                                f = t.y - f.top;
                                D.css("top", f - 16 + "px");
                                D.css("left", h + "px");
                                D.css("display", "block");
                                if (e && 0 != E) {
                                  h = t;
                                  t = h.y + g.y + 16;
                                  g = h.x + g.x + 20;
                                  h = a.getDropMarkWindow();
                                  h.empty();
                                  f = "iui-drop-marker-move-in";
                                  switch (p) {
                                    case 1:
                                      f = "iui-drop-marker-move-up";
                                      break;
                                    case 2:
                                      f = "iui-drop-marker-move-down";
                                  }
                                  h.append(
                                    "<span class='" +
                                      f +
                                      "'></span><span class='iui-drop-marker-title'>" +
                                      c[a.options.dataFields.text] +
                                      "</span>"
                                  );
                                  a.updateDropMarkElem(a.getDropMarkWindow(), {
                                    top: t,
                                    left: g
                                  });
                                  a.dropMark(e);
                                  n.setData({
                                    source: d.source,
                                    sourceList: d.sourceList,
                                    target: c,
                                    dropPos: p
                                  });
                                } else a.dropMark();
                              }
                            } else
                              (c = n.getData()),
                                (d = {
                                  source: c.source,
                                  sourceCtrl: c.sourceCtrl,
                                  target: null,
                                  dropPos: -1
                                }),
                                n.setData(d),
                                (E = {
                                  event: b,
                                  sourceTree: c.sourceCtrl
                                    ? c.sourceCtrl.getCtrlName()
                                    : "",
                                  dragItem: c.source,
                                  targetTree: a.getCtrlName(),
                                  targetItem: null,
                                  isDropAllowed: a.options.allowDrop,
                                  dropPos: -1,
                                  mousePos: t
                                }),
                                (f = m[0].getBoundingClientRect()),
                                (h = t.x - f.left),
                                (f = t.y - f.top),
                                D.css("top", f - 16 + "px"),
                                D.css("left", h + "px"),
                                (E = a.callDragOver(E)),
                                0 == E
                                  ? a.dropMark()
                                  : ((h = t),
                                    (t = h.y + 16),
                                    (g = h.x + 20),
                                    (h = a.getDropMarkWindow()),
                                    h.empty(),
                                    h.append(
                                      "<span class='iui-drop-marker-move-end'></span><span class='iui-drop-marker-title'>" +
                                        (k.name ? k.name : "TreeView") +
                                        "</span>"
                                    ),
                                    a.updateDropMarkElem(
                                      a.getDropMarkWindow(),
                                      { top: t, left: g }
                                    ),
                                    a.dropMark(!0));
                          }
                          b.stopPropagation();
                        }
                    } else
                      b.preventDefault(),
                        a.dropMark(),
                        a.cancelScrollTimer(),
                        D && D.css("display", "none");
                  }
                });
                b.bind("touchend", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (c && a.isItemEnabled(c)) {
                    if ((c = a.getTouchData(b)) && 0 < c.length) {
                      c = ya({ x: c[0].pageX, y: c[0].pageY });
                      var d = m[0].getBoundingClientRect();
                      if (n.hitTest(c.x, c.y, d))
                        if (xa) {
                          angular.element(this);
                          b.preventDefault();
                          za();
                          a.dropMark();
                          V();
                          if ((c = a.getTouchData(b)) && 0 < c.length) {
                            d = ya({ x: c[0].pageX, y: c[0].pageY });
                            var g = a.getItemAt(d.x, d.y);
                            if (g) {
                              c = n.getData();
                              var t = c.source,
                                p = a.isDropAllowed(t, g, c.dropPos);
                              p &&
                                t &&
                                ((d = {
                                  event: b,
                                  sourceTree: c.sourceCtrl
                                    ? c.sourceCtrl.getCtrlName()
                                    : "",
                                  dragItem: t,
                                  targetTree: a.getCtrlName(),
                                  targetItem: g,
                                  isDropAllowed: p,
                                  dropPos: c.dropPos,
                                  mousePos: d
                                }),
                                (d = a.callDragDrop(d)),
                                !1 !== d &&
                                  (a.drop(c), k.$$phase || k.$apply()));
                            } else
                              (c = n.getData()),
                                c.source &&
                                  ((d = {
                                    event: b,
                                    sourceTree: c.sourceCtrl
                                      ? c.sourceCtrl.getCtrlName()
                                      : "",
                                    dragItem: c.source,
                                    targetTree: a.getCtrlName(),
                                    targetItem: null,
                                    isDropAllowed: a.options.allowDrop,
                                    dropPos: -1,
                                    mousePos: d
                                  }),
                                  (d = a.callDragDrop(d)),
                                  !1 !== d &&
                                    (a.drop(c), k.$$phase || k.$apply())),
                                n.clearData();
                          }
                          n.clearData();
                          a.dragDropStatus(!1);
                          b.stopPropagation();
                        } else
                          a.mouseButtonStatus(!1),
                            (c = a.getItemAt(c.x, c.y)) &&
                              a.updateSelection(b, c),
                            bb();
                    }
                    c = xa;
                    a.removeDropMark();
                    V();
                    wa = { x: 0, y: 0 };
                    xa = !1;
                    da = null;
                    c && b.stopPropagation();
                  }
                });
                b.bind("dblclick", function(b) {
                  b.preventDefault();
                  if (1 === b.which) {
                    var c = a.getItemFromChildElem(this);
                    if (c) {
                      var d = "dblclick" == a.options.editorSettings.activate;
                      d && Na(b, angular.element(this), 0);
                      0 == a.callItemDblClick(c, a.getMousePos(b)) ||
                        d ||
                        a.toggle(c);
                    }
                  }
                  b.stopPropagation();
                });
                b.bind("mouseenter", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c &&
                    a.isItemEnabled(c) &&
                    (angular.element(this),
                    (a.hoverItem = c),
                    a.refresh(c),
                    a.callItemHover(c),
                    a.options.hoverSelection &&
                      (fa = q(function() {
                        fa && a.itemSelection(b, c);
                      }, 500)));
                });
                b.bind("mouseleave", function(b) {
                  a.hoverItem = null;
                  (b = a.getItemFromChildElem(this)) &&
                    a.isItemEnabled(b) &&
                    a.refresh(b);
                  fa && (q.cancel(fa), (fa = null));
                });
                var c = function(b, c) {
                    b.preventDefault();
                    focusDelayTime = 0;
                    var d = a.getItemCurrentIndex(c),
                      g = K + x - 2;
                    g =
                      g < a.currentList.length - 1
                        ? g
                        : a.currentList.length - 1;
                    d === g &&
                      (a.setScrollPos({
                        x: a.scrollPos.x,
                        y: a.scrollPos.y + Math.floor(m[0].clientHeight / 4)
                      }),
                      (focusDelayTime = 1));
                    var t = a.getNextItem(d);
                    if (t) {
                      a.itemSelection(b, t);
                      k.$apply();
                      var p = q(function() {
                        a.updateFocus(t);
                        q.cancel(p);
                      }, focusDelayTime);
                    }
                  },
                  d = function(b, c) {
                    b.preventDefault();
                    focusDelayTime = 0;
                    var d = a.getItemCurrentIndex(c),
                      g = K;
                    d === (0 < g ? g : 0) &&
                      (a.setScrollPos({
                        x: a.scrollPos.x,
                        y: a.scrollPos.y - Math.floor(m[0].clientHeight / 4)
                      }),
                      (focusDelayTime = 1));
                    var t = a.getPrevItem(a.getItemCurrentIndex(c));
                    if (t) {
                      a.itemSelection(b, t);
                      k.$apply();
                      var p = q(function() {
                        a.updateFocus(t);
                        q.cancel(p);
                      }, focusDelayTime);
                    }
                  };
                b.bind("keydown", function(g) {
                  var p = a.getItemFromChildElem(this);
                  if (p && a.isItemEnabled(p) && 0 != a.callKeyDown(g, p)) {
                    a.callKeyDown(g, p);
                    var t = 0;
                    switch (g.keyCode) {
                      case 9:
                        t = a.currentList.length;
                        0 < t &&
                          (g.shiftKey
                            ? l.isEqual(
                                p[a.options.dataFields.id],
                                a.currentList[0][a.options.dataFields.id]
                              ) || d(g, p)
                            : l.isEqual(
                                p[a.options.dataFields.id],
                                a.currentList[t - 1][a.options.dataFields.id]
                              ) || c(g, p));
                        break;
                      case 13:
                        Na(g, b, 0);
                        break;
                      case 16:
                        a.updateSelectionStatus(g, "shift");
                        break;
                      case 17:
                        a.updateSelectionStatus(g, "ctrl");
                        break;
                      case 33:
                        g.preventDefault();
                        t = a.getItemCurrentIndex(p);
                        p = t - x;
                        p = 0 < p ? p : 0;
                        if (p !== t) {
                          t = 1;
                          var e = a.getPrevItem(p + 1);
                          if (e) {
                            a.scrollTo(e);
                            a.itemSelection(g, e);
                            k.$apply();
                            var E = q(function() {
                              a.updateFocus(e);
                              q.cancel(E);
                            }, t);
                          }
                        }
                        break;
                      case 34:
                        g.preventDefault();
                        t = a.getItemCurrentIndex(p);
                        p = t + x;
                        p =
                          p < a.currentList.length - 1
                            ? p
                            : a.currentList.length - 1;
                        p !== t &&
                          ((t = 1), (e = a.getNextItem(p - 1))) &&
                          (a.scrollTo(e, "bottom"),
                          a.itemSelection(g, e),
                          k.$apply(),
                          (E = q(function() {
                            a.updateFocus(e);
                            q.cancel(E);
                          }, t)));
                        break;
                      case 35:
                        g.preventDefault();
                        a.setScrollPos({ x: a.scrollPos.x, y: J.y });
                        var f = a.getLastItem();
                        f &&
                          (a.itemSelection(g, f),
                          (E = q(function() {
                            a.updateFocus(f);
                            q.cancel(E);
                          }, 1)));
                        break;
                      case 36:
                        g.preventDefault();
                        a.setScrollPos({ x: a.scrollPos.x, y: 0 });
                        var h = a.getFirstItem();
                        h &&
                          (a.itemSelection(g, h),
                          (E = q(function() {
                            a.updateFocus(h);
                            q.cancel(E);
                          }, 1)));
                        break;
                      case 37:
                        g.preventDefault();
                        p[a.options.dataFields.items] &&
                          0 < p[a.options.dataFields.items].length &&
                          (a.toggle(p, !1), a.updateFocus(p));
                        break;
                      case 32:
                        g.preventDefault();
                        a.itemSelection(g, p, p.selected);
                        k.$apply();
                        break;
                      case 38:
                        d(g, p);
                        break;
                      case 39:
                        g.preventDefault();
                        p[a.options.dataFields.items] &&
                          0 < p[a.options.dataFields.items].length &&
                          (a.toggle(p, !0), a.updateFocus(p));
                        break;
                      case 40:
                        c(g, p);
                        break;
                      default:
                        (g.ctrlKey || g.metaKey) &&
                          a.updateSelectionStatus(g, "ctrl"),
                          g.shiftKey && a.updateSelectionStatus(g, "shift");
                    }
                  }
                });
                b.bind("keyup", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (c && a.isItemEnabled(c)) {
                    switch (b.keyCode) {
                      case 16:
                        a.multiSelection(!1);
                        a.shiftKeyStatus(!1);
                        break;
                      case 17:
                        a.multiSelection(!1);
                        break;
                      default:
                        b.ctrlKey || b.metaKey || a.multiSelection(!1),
                          b.shiftKey ||
                            (a.multiSelection(!1), a.shiftKeyStatus(!1));
                    }
                    a.callKeyUp(b, c);
                  }
                });
                b.bind("keypress", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && a.callKeyPress(b, c);
                });
                b.bind("click", function(b) {
                  if (1 === b.which) {
                    var c = a.getItemFromChildElem(this);
                    c &&
                      a.isItemEnabled(c) &&
                      a.callItemClick(b, c, a.getMousePos(b));
                  }
                  b.stopPropagation();
                });
                b.bind("mousedown", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (c && a.isItemEnabled(c)) {
                    a.mouseButtonStatus(!0);
                    a.itemSelection(b, c);
                    switch (b.which) {
                      case 1:
                        a.changeCheckValue(c);
                        "click" == a.options.editorSettings.activate &&
                          Na(b, angular.element(this));
                        break;
                      case 3:
                        a.callItemRightClick(c, a.getMousePos(b));
                    }
                    b.stopPropagation();
                  }
                });
                b.bind("mouseup", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c &&
                    a.isItemEnabled(c) &&
                    (a.mouseButtonStatus(!1),
                    a.updateSelection(b, c),
                    1 === b.which && bb());
                });
                b.bind("focus", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && a.callGotFocus(b, c);
                });
                b.bind("blur", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c && a.isItemEnabled(c) && a.callLostFocus(b, c);
                });
              }
            },
            Rb = function(b) {
              b &&
                (b.bind("touchstart", function(b) {
                  var c = a.getItemFromChildElem(this);
                  c &&
                    a.isItemEnabled(c) &&
                    (b.preventDefault(), a.changeCheckValue(c));
                }),
                b.bind("mouseenter", function(b) {
                  (b = a.getItemFromChildElem(this)) &&
                    a.isItemEnabled(b) &&
                    (angular.element(this),
                    (a.hoverItem = b),
                    a.refresh(b),
                    a.callItemHover(b));
                }),
                b.bind("mouseleave", function(b) {
                  a.hoverItem = null;
                  (b = a.getItemFromChildElem(this)) &&
                    a.isItemEnabled(b) &&
                    a.refresh(b);
                }),
                b.bind("click", function(b) {
                  if (1 === b.which) {
                    var c = a.getItemFromChildElem(this);
                    c &&
                      a.isItemEnabled(c) &&
                      a.callItemClick(b, c, a.getMousePos(b));
                  }
                  b.stopPropagation();
                }),
                b.bind("dblclick", function(b) {
                  b.preventDefault();
                  if (1 === b.which) {
                    var c = a.getItemFromChildElem(this);
                    c && a.callItemDblClick(c, a.getMousePos(b));
                  }
                  b.stopPropagation();
                }),
                b.bind("mousedown", function(b) {
                  var c = a.getItemFromChildElem(this);
                  if (c && a.isItemEnabled(c)) {
                    switch (b.which) {
                      case 1:
                        a.changeCheckValue(c);
                        break;
                      case 3:
                        a.callItemRightClick(c, a.getMousePos(b));
                    }
                    b.stopPropagation();
                  }
                }));
            };
          a.openEditor = function(b) {
            if (b) {
              var c = a.getElemFromItem(b);
              c &&
                0 != b[a.options.dataFields.allowEdit] &&
                (b = a.getElement(c)) &&
                Na(null, b, 0);
            }
          };
          a.closeEditor = function(b) {
            b
              ? (b = a.getElemFromItem(b)) &&
                (b = a.getElement(b)) &&
                Ba(null, b, !1)
              : Ba(null, null, !1);
          };
          var Na = function(b, c, d) {
              a.options.labelEdit &&
                (void 0 === d && (d = 500),
                (ea = q(function() {
                  if (ea)
                    var a = q(function() {
                      Ba(b, c, !0);
                      q.cancel(a);
                    }, d);
                  q.cancel(ea);
                }, d / 3)));
            },
            bb = function() {
              ea && (q.cancel(ea), (ea = null));
            },
            Ca = null,
            Ba = function(b, c, d) {
              if (a.dragDropStatus())
                (d = B[0].value),
                  a.labelEditStatus(!1),
                  B.unbind("blur focus keydown mousedown"),
                  B.remove(),
                  (Ca = null);
              else {
                var g = a.getItemFromChildElem(c);
                if (g)
                  if (
                    (c &&
                      g[a.options.dataFields.text] &&
                      "" != g[a.options.dataFields.text] &&
                      c.css("height", "auto"),
                    d)
                  ) {
                    if (((d = ""), 0 != a.callBeforeLabelEdit(g))) {
                      Ca = g;
                      a.labelEditStatus(!0);
                      B.unbind("blur focus keydown mousedown");
                      m.append(B);
                      (g[a.options.dataFields.text] &&
                        "" != g[a.options.dataFields.text]) ||
                        ((b = l.getMargin(c[0].parentElement)),
                        (d = l.getPadding(c[0])),
                        c.css(
                          "height",
                          z - (b.top + b.bottom + 2) - (d.top + d.bottom) + "px"
                        ));
                      d = m[0].getBoundingClientRect();
                      var e = c[0].getBoundingClientRect();
                      b = c[0].offsetHeight - 4;
                      d = e.top - d.top - 1;
                      e = a.scrollPos.x + c[0].offsetLeft;
                      var p = m[0].clientWidth - c[0].offsetLeft - 6;
                      F && (p -= 16);
                      a.updateEditBox({ top: d, left: e, width: p, height: b });
                      B[0].value = g[a.options.dataFields.text];
                      B.bind("keydown", function(b) {
                        switch (b.keyCode) {
                          case 13:
                            g[a.options.dataFields.text] = B[0].value
                              ? B[0].value
                              : "null";
                            Ba(b, c, !1);
                            break;
                          case 27:
                            Ba(b, c, !1);
                        }
                        b.stopPropagation();
                      });
                      B.bind("focus", function(b) {
                        var c = angular.element(this);
                        a.callGotFocus(b, Ca, !0, c[0].value);
                      });
                      B.bind("blur", function(a) {
                        Ba(a);
                      });
                      B.bind("mousedown", function(a) {
                        a.stopPropagation();
                      });
                      var E = q(function() {
                        B[0].focus();
                        B[0].select();
                        q.cancel(E);
                      }, 10);
                    }
                  } else
                    (d = B[0].value),
                      a.labelEditStatus(!1),
                      B.unbind("blur focus keydown mousedown"),
                      B.remove(),
                      a.updateView(),
                      a.updateFocus(g),
                      a.callAfterLabelEdit(g),
                      a.callLostFocus(b, g, !0, d),
                      (Ca = null);
                else
                  (d = B[0].value),
                    a.labelEditStatus(!1),
                    B.unbind("blur focus keydown mousedown"),
                    B.remove(),
                    a.callAfterLabelEdit(),
                    a.updateView(),
                    a.callLostFocus(b, Ca, !0, d),
                    (Ca = null);
              }
            };
          a.getElemFromItem = function(b) {
            var c = null;
            if (b) {
              var d = a.getItemCurrentIndex(b);
              switch (b[a.options.dataFields.fixed]) {
                case "top":
                  b = H.find("li");
                  break;
                case "bottom":
                  b = I.find("li");
                  break;
                default:
                  b = C.find("li");
              }
              if (b && 0 < b.length)
                for (var g = 0; g < b.length; g++) {
                  var e = angular.element(b[g]);
                  if (
                    e[0].attributes["data-index"] &&
                    e[0].attributes["data-index"].value.toString() ===
                      d.toString()
                  ) {
                    c = e;
                    break;
                  }
                }
            }
            return c;
          };
          var xb = function(b) {
              var c = "";
              b[a.options.dataFields.icon]
                ? (c = b[a.options.dataFields.icon])
                : a.options.itemIcon && (c = a.options.itemIcon);
              return c;
            },
            yb = function(b) {
              return (
                "iui-treeview-status-icon " + b[a.options.dataFields.statusIcon]
              );
            },
            zb = function(b) {
              return b
                ? b[a.options.dataFields.icon] || a.options.itemIcon
                : !1;
            },
            K = 0,
            v = null,
            x = 100,
            z = 0,
            Q = 0,
            ba = 0,
            P = 0,
            sa = 0,
            R = null,
            S = null,
            Oa = !1,
            Da = !1,
            Pa = 9,
            Qa = 9,
            cb = 0,
            ha = 0,
            ta = 0,
            Ra = 1,
            db = 0,
            Sa = 0,
            ia = 0,
            Ea = 0,
            eb = 1,
            L = null,
            M = null,
            G = !1,
            F = !1;
          this.scrollMousePos = null;
          var J = { x: 0, y: 0 };
          Sa = 0;
          k.verScrollVisibility = !1;
          k.$watch("verScrollVisibility", function(b, c) {
            b != c && a.updateCurrentLayout();
          });
          a.updateViewSize = function() {
            var b = q(function() {
              Q = 0;
              F = G = !1;
              a.getTemplateUrl() || a.updateLongestItem();
              if (
                !a.getTemplateUrl() &&
                a.longestItem &&
                0 < a.currentList.length
              ) {
                var c = a.getItemCurrentIndex(a.longestItem);
                c = angular.element(Sb(c, !0));
                m.append(c);
                Q = c[0].offsetWidth;
                var d = m[0].offsetWidth - 6;
                F && y && (d -= y[0].offsetWidth);
                Q > d &&
                  (A.unbind("click mousedown"),
                  m.append(A),
                  A.bind("click", function(a) {
                    a.stopPropagation();
                  }),
                  A.bind("mousedown", function(b) {
                    if (a.options.enabled) {
                      b = l.getClientMousePos(b, this);
                      var c = Math.floor(m[0].clientWidth);
                      L &&
                        (b.x < L[0].offsetLeft
                          ? a.setScrollPos({
                              x: a.scrollPos.x - c,
                              y: a.scrollPos.y
                            })
                          : b.x > L[0].offsetLeft + L[0].offsetWidth &&
                            a.setScrollPos({
                              x: a.scrollPos.x + c,
                              y: a.scrollPos.y
                            }));
                    }
                  }),
                  (L = angular.element(A.children().eq(0))),
                  (G = !0),
                  L.bind("mousedown", function(b) {
                    a.options.enabled &&
                      1 === b.which &&
                      ((w.scrollMousePos = a.getMousePos(b)), (Oa = !0));
                    b.stopPropagation();
                  }));
                c.remove();
              }
              k.verScrollVisibility = !1;
              0 < a.currentList.length &&
                !a.options.autoSize &&
                ((c =
                  m[0].offsetHeight -
                  6 -
                  H[0].offsetHeight -
                  I[0].offsetHeight),
                G && A && (c -= A[0].offsetHeight),
                (d = (ja.top + ja.bottom) / 2),
                (x = 0 < z ? Math.floor(c / (z + d)) + 1 : 100),
                x < a.currentList.length + 1 &&
                  (y.unbind("click mousedown mouseup"),
                  m.append(y),
                  y.bind("click", function(a) {
                    a.stopPropagation();
                  }),
                  y.bind("mousedown", function(b) {
                    if (a.options.enabled && 1 == b.which) {
                      var c = l.getClientMousePos(b, this),
                        d = Math.floor(m[0].clientHeight);
                      M &&
                        (c.y < M[0].offsetTop
                          ? (a.setScrollPos({
                              x: a.scrollPos.x,
                              y: a.scrollPos.y - d
                            }),
                            ab(b, !1, d))
                          : c.y > M[0].offsetTop + M[0].offsetHeight &&
                            (a.setScrollPos({
                              x: a.scrollPos.x,
                              y: a.scrollPos.y + d
                            }),
                            ab(b, !0, d)));
                    }
                  }),
                  y.bind("mouseup", function(b) {
                    a.cancelScrollTimer();
                  }),
                  (M = angular.element(y.children().eq(0))),
                  (F = !0),
                  M.bind("mousedown", function(b) {
                    a.options.enabled &&
                      1 === b.which &&
                      ((w.scrollMousePos = a.getMousePos(b)), (Da = !0));
                    b.stopPropagation();
                  })));
              G || (A.unbind("mousedown"), A.remove(), (J.x = 0));
              F || (y.unbind("mousedown"), y.remove(), (J.y = 0));
              G && F ? m.append(O) : O.remove();
              q.cancel(b);
              !G &&
                0 < a.scrollPos.x &&
                a.setScrollPos({ x: 0, y: a.scrollPos.y });
              !F &&
                0 < a.scrollPos.y &&
                a.setScrollPos({ x: a.scrollPos.x, y: 0 });
            }, 1);
          };
          a.updateScrollView = function() {
            Ab();
          };
          var Ab = function() {
              var b = q(function() {
                P = m[0].offsetWidth - 6;
                sa = m[0].offsetHeight - 4;
                C.css("top", H[0].offsetHeight + 2 + "px");
                sa = G ? sa - A[0].offsetHeight : sa - 4;
                P = F ? P - y[0].offsetWidth : P - 4;
                P < Q
                  ? (C.css("width", Q + "px"),
                    H.css("width", Q + "px"),
                    I.css("width", Q + "px"))
                  : (C.css("width", P + "px"),
                    H.css("width", P + "px"),
                    I.css("width", P + "px"));
                C.css(
                  "height",
                  sa - H[0].offsetHeight - I[0].offsetHeight + "px"
                );
                G &&
                  (A.css("bottom", "0px"),
                  F || (P += 3),
                  A.css("width", P + 1 + "px"));
                F &&
                  (y.css("top", "0px"),
                  G || (sa += 3),
                  y.css("height", sa + 1 + "px"));
                G && F && O.css("bottom", "0px");
                !1 !== a.options.rtl
                  ? (C.css("left", "auto"),
                    C.css("right", "-" + (a.scrollPos.x - 2).toString() + "px"),
                    G && (A.css("left", "auto"), A.css("right", "0px")),
                    F && (y.css("left", "0px"), y.css("right", "auto")),
                    G && F && (O.css("left", "0px"), O.css("right", "auto")))
                  : (C.css("left", "-" + (a.scrollPos.x - 2).toString() + "px"),
                    C.css("right", "auto"),
                    G && (A.css("left", "0px"), A.css("right", "auto")),
                    F && (y.css("left", "auto"), y.css("right", "0px")),
                    G && F && (O.css("left", "auto"), O.css("right", "0px")));
                var c = q(function() {
                  G &&
                    P < Q &&
                    ((cb = 0),
                    (ha = 2),
                    (ta = A[0].clientWidth - 4),
                    ta > ha && (cb = ta - ha),
                    (Pa = Math.floor((cb * (P - 4)) / Q)),
                    9 > Pa && (Pa = 9),
                    L.css("width", Pa + "px"),
                    (J.x = Q - P),
                    0 > J.x && (J.x = 0),
                    (Ra = J.x / (cb - Pa - 2)));
                  var b = a.currentList.length + 1;
                  F &&
                    0 < a.currentList.length &&
                    x < b &&
                    ((ia = 2),
                    (Ea = y[0].clientHeight - 4),
                    (db = 0),
                    Ea > ia && (db = Ea - ia),
                    (Qa = Math.floor((db * x) / b)),
                    9 > Qa && (Qa = 9),
                    M.css("height", Qa + "px"),
                    (eb = (b - x + 1) / (db - Qa - 2)),
                    (J.y = Math.floor((b - x + 1) * z)),
                    0 > J.y && (J.y = 0),
                    0 == K
                      ? M.css("top", ia + "px")
                      : K + x - 1 == a.currentList.length &&
                        M.css("top", Ea - M[0].offsetHeight + "px"));
                  a.updateAutoLayout();
                  q.cancel(c);
                }, 1);
                q.cancel(b);
              }, 5);
            },
            Bb = 5,
            fb = 0,
            ua = 0,
            gb = 0,
            Cb = 0,
            va = !1,
            hb = !1,
            Fa = "none",
            Ta = "normal",
            Ua = 0,
            lb = null,
            T = !1,
            ka = !1,
            la = angular.element(
              '<ul class="iui-treeview-block" style="position:absolute;top:-9999999px"></ul>'
            ),
            ma = angular.element(
              '<ul class="iui-treeview-block-top" style="position:absolute;top:-9999999px"></ul>'
            ),
            na = angular.element(
              '<ul class="iui-treeview-block-bottom" style="position:absolute;top:-9999999px"></ul>'
            );
          a.updateActive = !1;
          a.updateStatus = 0;
          var Db = function(b) {
              var c = e(function() {
                b ? ua++ : ua--;
                gb = (m[0].clientHeight - ua) / 2 + 2;
                Va.css("height", ua + "px");
                ca.css("top", gb + "px");
                b && ua >= Bb
                  ? ((T = !0), oa(0), (ka = va = !1), e.cancel(c))
                  : !b &&
                    0 >= ua &&
                    (ca && ca.remove(),
                    (Ga = 0),
                    (ka = !0),
                    a.callLoadComplete(),
                    e.cancel(c));
              }, 20);
            },
            Eb = function() {
              lb && e.cancel(lb);
              W && W.remove();
            };
          a.beginLoad = function(a) {
            if (!va)
              switch (
                ((va = !0),
                a
                  ? ((Fa = void 0 != a.type ? a.type : "none"),
                    (Ta = void 0 != a.speed ? a.speed : "normal"),
                    (Ua = void 0 != a.opacity ? a.opacity : 0))
                  : ((Fa = "none"), (Ta = "normal"), (Ua = 0)),
                Wa(Ua),
                Fa)
              ) {
                case "circular":
                  Eb();
                  m.append(W);
                  W.css(
                    "top",
                    (m[0].clientHeight - W[0].offsetHeight) / 2 + "px"
                  );
                  W.css(
                    "left",
                    (m[0].clientWidth - W[0].offsetWidth) / 2 + "px"
                  );
                  T = !0;
                  ka = va = !1;
                  var b = 0,
                    c = 3;
                  switch (Ta) {
                    case "veryfast":
                      c = 7;
                      break;
                    case "fast":
                      c = 5;
                      break;
                    case "slow":
                      c = 2;
                      break;
                    case "veryslow":
                      c = 1;
                  }
                  lb = e(function() {
                    b += c;
                    360 < b && (b = 0);
                    var a = "rotate(" + b + "deg)";
                    W.css("-ms-transform", a);
                    W.css("-webkit-transform", a);
                    W.css("transform", a);
                  }, 1);
                  break;
                case "linear":
                  a = angular.element(
                    '<div class="iui-load-block-progress" style="position:absolute;left:-9999px"></div>'
                  );
                  m.append(a);
                  Bb = parseInt(getComputedStyle(a[0]).height, 10);
                  a.remove();
                  Va.css("width", "0px");
                  Va.css("height", "0px");
                  m.append(ca);
                  Ga = 0;
                  fb = Math.floor(0.5 * m[0].clientWidth);
                  ua = 0;
                  gb = m[0].clientHeight / 2 + 2;
                  Cb = (m[0].clientWidth - fb) / 2;
                  ca.css("width", fb + "px");
                  ca.css("top", gb + "px");
                  ca.css("left", Cb + "px");
                  ca.css("opacity", "1");
                  Db(!0);
                  break;
                default:
                  (T = !0), (ka = va = !1);
              }
          };
          a.endLoad = function(b) {
            if (!hb)
              if (
                ((hb = !0),
                (b = a.options.loadItems.indexOf(b)),
                0 <= b && a.options.loadItems.splice(b, 1),
                T)
              ) {
                T = !1;
                var c = 3,
                  d = Ua,
                  g = e(function() {
                    ka &&
                      (10 < c || 1 <= d
                        ? (Wa(1),
                          (hb = va = ka = !1),
                          (Fa = "none"),
                          (Ta = "normal"),
                          (Ua = void 0),
                          e.cancel(g))
                        : ((d += c / 10), Wa(d), (c += 3)));
                  }, 1);
              } else hb = !1;
          };
          var Wa = function(a) {
              C && C.css("opacity", a);
              A && A.css("opacity", a);
              y && y.css("opacity", a);
              O && O.css("opacity", a);
            },
            Va = angular.element('<div class="iui-load-block-progress"></div>'),
            ca = angular.element('<div class="iui-load-block"></div>');
          ca.append(Va);
          var Ga = 0,
            Ha = !1,
            W = angular.element('<div class="iui-load-circular"></div>'),
            oa = function(a) {
              if (T && "linear" == Fa) {
                Ha = !1;
                var b = Math.floor((fb * a) / 100),
                  c = Ga;
                a = 10;
                switch (Ta) {
                  case "veryfast":
                    a = 2;
                    break;
                  case "fast":
                    a = 5;
                    break;
                  case "slow":
                    a = 15;
                    break;
                  case "veryslow":
                    a = 20;
                }
                var d = b > c ? Math.floor((b - c) / a) : 1;
                d = 0 < d ? d : 1;
                var g = e(function() {
                  c += d;
                  Va.css("width", c + "px");
                  c >= b && ((Ga = b), (Ha = !0), e.cancel(g));
                }, 1);
              } else Ha = !0;
            },
            ja = { top: 0, bottom: 0 },
            Tb = function() {
              z = 0;
              ja = { top: 0, bottom: 0 };
              if (0 < a.currentList.length && v) {
                for (
                  var b = [], d = [], e = 0, t = 0;
                  t < a.currentList.length && 10 > t;
                  t++
                )
                  b.push(Xa(t, !0)), d.push(c(b[t])(v)), m.append(d[t]), e++;
                if (0 < e)
                  var f = q(function() {
                    var a = 0;
                    ja = l.getMargin(d[0][0]);
                    for (var b = 0; b < e; b++)
                      (a += d[b][0].offsetHeight), d[b].remove();
                    z = Math.floor(a / e);
                    q.cancel(f);
                  }, 1);
              }
            },
            Ub = function() {
              m.append(la);
              m.append(ma);
              m.append(na);
              var b = q(function() {
                if (0 < a.currentList.length) {
                  v = k.$new();
                  v.data = Fb();
                  v.checkBoxStyle = a.options.checkBoxSettings.style;
                  !v.checkBoxStyle &&
                    a.options.controlStyle.item.checkBox &&
                    (v.checkBoxStyle = a.options.controlStyle.item.checkBox);
                  R = k.$new();
                  R.data = Gb();
                  S = k.$new();
                  S.data = Hb();
                  a.refresh();
                  v.$apply();
                  R.$apply();
                  S.$apply();
                  Tb();
                  var d = q(function() {
                    a.updateAutoLayout();
                    ba = 0;
                    for (var b = "", g = 0; g < a.currentTopList.length; g++)
                      (b += Xa(g, !1, "top")), ba++;
                    0 < ba && ma.append(c(b)(R));
                    ba = 0;
                    b = "";
                    for (g = 0; g < a.currentBottomList.length; g++)
                      (b += Xa(g, !1, "bottom")), ba++;
                    0 < ba && na.append(c(b)(S));
                    b = m[0].offsetHeight - 6;
                    G && A && (b -= A[0].offsetHeight);
                    a.options.autoSize
                      ? (x = a.currentList.length)
                      : ((g = (ja.top + ja.bottom) / 2),
                        (x = 0 < z ? Math.floor(b / (z + g)) + 1 : 100));
                    ba = 0;
                    b = "";
                    for (g = 0; g < x; g++) (b += Xa(g)), ba++;
                    0 < ba && la.append(c(b)(v));
                    oa(70);
                    X("scroll");
                    q.cancel(d);
                  }, 1);
                } else oa(70), X("scroll");
                q.cancel(b);
              }, 1);
            },
            X = function(b) {
              if (Ha && !va)
                switch (b) {
                  case "start":
                    Wa(0);
                    a.updateCurrentList();
                    Vb();
                    oa(10);
                    X("init");
                    break;
                  case "init":
                    la && la.remove();
                    ma && ma.remove();
                    na && na.remove();
                    Oa || Da || Ab();
                    Aa();
                    v && v.$destroy();
                    a.currentList.length >= x &&
                      K + x - 1 > a.currentList.length &&
                      (K = a.currentList.length - x + 1);
                    oa(20);
                    X("items");
                    break;
                  case "items":
                    Ub();
                    break;
                  case "scroll":
                    a.updateViewSize();
                    a.updateViewSize();
                    a.updateScrollView();
                    oa(80, "complete");
                    X("complete");
                    break;
                  case "complete":
                    oa(90);
                    X("events");
                    break;
                  case "events":
                    la && (C.empty(), C.append(la.children()));
                    ma &&
                      (H.empty(),
                      H.append(ma.children()),
                      H.css(
                        "border-width",
                        0 < a.currentTopList.length ? "1px" : 0
                      ));
                    na &&
                      (I.empty(),
                      I.append(na.children()),
                      I.css(
                        "border-width",
                        0 < a.currentTopList.length ? "1px" : 0
                      ));
                    a.allowEvents = !0;
                    0 < a.currentList.length && d();
                    oa(100);
                    X("end");
                    break;
                  case "end":
                    la && la.remove();
                    ma && ma.remove();
                    na && na.remove();
                    switch (Fa) {
                      case "circular":
                        Eb();
                        Ga = 0;
                        ka = !0;
                        1 == a.updateStatus && a.callLoadComplete();
                        break;
                      case "linear":
                        Db(!1);
                        break;
                      default:
                        (Ga = 0),
                          (ka = !0),
                          1 == a.updateStatus && a.callLoadComplete();
                    }
                    a.updateActive = !1;
                    a.updateStatus--;
                    0 < a.updateStatus &&
                      ((Ha = a.updateActive = !0), X("start"));
                    0 == a.updateStatus &&
                      (a.updateView(), Wa(1), a.callUpdateComplete());
                }
              else
                q(function() {
                  X(b);
                }, 1);
            };
          a.updateCurrentLayout = function() {
            if (a.allowUpdate)
              if (0 == a.currentList.length) a.updateLayout();
              else {
                var b = x;
                a.updateCurrentList();
                var c = a.currentList.length;
                c = c > b ? c - b : 0;
                a.options.autoSize && 0 < c ? Wb(c) : a.updateView();
                var d = q(function() {
                  a.updateViewSize();
                  a.updateViewSize();
                  a.updateScrollView();
                  q.cancel(d);
                }, 1);
              }
          };
          var Wb = function(a) {
            if (0 < a)
              var b = q(function() {
                var g = x;
                x += a;
                mb();
                for (var e = 0, p = ""; g < x; g++) (p += Xa(g)), e++;
                0 < e && (C.append(c(p)(v)), Aa(), d());
                q.cancel(b);
              }, 1);
          };
          a.updateAutoLayout = function() {
            if (a.options.autoSize) {
              var b = a.currentList.length * (z + (ja.top + ja.bottom) / 2);
              b += H[0].offsetHeight + I[0].offsetHeight;
              G && A && (b += A[0].offsetHeight);
              m.css("height", b + "px");
            }
          };
          a.updateLayout = function(b) {
            // m.append(w.$tw);
            // w.s1t(w.twp);
            b = !0;
            for (var c = m.parent(); "body" != c[0].tagName.toLowerCase(); ) {
              if ("none" == getComputedStyle(c[0]).display) {
                b = !1;
                break;
              }
              c = c.parent();
            }
            if (b && a.allowUpdate && (a.updateStatus++, !a.updateActive)) {
              a.updateActive = !0;
              m.removeClass("iui-treeview-block-rtl");
              a.options.rtl && m.addClass("iui-treeview-block-rtl");
              C.removeClass(
                "iui-treeview-block-shift-left iui-treeview-block-rtl"
              );
              C.addClass($a());
              a.allowEvents = !1;
              z = Q = 0;
              x = 100;
              if (a.options.showCheckBoxes)
                for (
                  a.updateCheckValues(), b = a.getFullList(), c = 0;
                  c < b.length;
                  c++
                )
                  a.setDefaultCheckValue(b[c]);
              Ha = !0;
              X("start");
            }
          };
          k.$watch(
            function() {
              return m[0].offsetWidth;
            },
            function(b, c) {
              a.options.autoUpdate &&
                (100 == x
                  ? a.updateLayout()
                  : b != c && a.updateCurrentLayout());
            }
          );
          var aa = null;
          k.$watch(
            function() {
              return m[0].offsetHeight;
            },
            function(b, c) {
              a.options.autoUpdate &&
                b != c &&
                (a.options.autoSize
                  ? a.updateCurrentLayout()
                  : (aa && (q.cancel(aa), (aa = null)),
                    (aa = q(function() {
                      a.updateLayout();
                      q.cancel(aa);
                      aa = null;
                    }, 250))));
            }
          );
          k.onCheckValueChanging = function(b, c) {
            var d = !1,
              g = c + K;
            if (a.isIndexInRange(g)) {
              if (
                (d = a.currentList[g]) &&
                0 == d[a.options.dataFields.allowEdit]
              )
                return !1;
              d = a.callCheckValueChanging(
                a.currentList[g],
                a.options.checkBoxSettings &&
                  1 == a.options.checkBoxSettings.threeState
                  ? b.checkState
                  : b.checked
              );
            }
            return d;
          };
          k.onCheckValueChanged = function(b, c) {
            var d = c + K;
            a.isIndexInRange(d) &&
              (a.callCheckValueChanged(
                a.currentList[d],
                a.options.checkBoxSettings &&
                  1 == a.options.checkBoxSettings.threeState
                  ? b.checkState
                  : b.checked
              ),
              a.fillCheckList(a.currentList[d]));
          };
          a.setDefaultCheckValue = function(b) {
            a.options.checkBoxSettings &&
            1 == a.options.checkBoxSettings.threeState
              ? void 0 == b[a.options.dataFields.checkState] &&
                (b[a.options.dataFields.checkState] = "unchecked")
              : void 0 == b[a.options.dataFields.checked] &&
                (b[a.options.dataFields.checked] = !1);
          };
          var Sb = function(b, c) {
              var d = a.currentList[b],
                g = a.defaultStyle.item.general.normal,
                e = a.getCurrentItemStyle(d, a.getObjState(d));
              d = '<li class="' + g;
              e != g && (d += " " + e);
              d += '" ';
              d = c
                ? d +
                  ('style="position:absolute;top:-9999px;padding-left:' +
                    a.indentList[b] +
                    'px"')
                : d + ('data-index="' + b + '"');
              !c &&
                0 < a.indentList[b] &&
                (d = a.options.rtl
                  ? d + (' style="padding-right:' + a.indentList[b] + 'px"')
                  : d + (' style="padding-left:' + a.indentList[b] + 'px"'));
              d += ">";
              !1 !== a.options.showStatusIcons &&
                (d +=
                  '<span class="' +
                  yb(a.currentList[b]) +
                  '" data-element="statusicon"></span>');
              d +=
                '<span class="' +
                Ka(a.currentList[b]) +
                '" data-element="expandbox"></span>';
              1 == a.options.showCheckBoxes &&
                ((d += '<iui-checkbox name="cb-' + l.getUniqueId(4) + '"'),
                (g = a.options.checkBoxSettings
                  ? 1 == a.options.checkBoxSettings.threeState
                  : !1),
                (e = a.currentList[b]),
                g && void 0 == e[a.options.dataFields.checkState]
                  ? (e[a.options.dataFields.checkState] = "unchecked")
                  : void 0 == e[a.options.dataFields.checked] &&
                    (e[a.options.dataFields.checked] = !1),
                g
                  ? ((d +=
                      ' check-state="data[' +
                      b +
                      "]." +
                      a.options.dataFields.checkState +
                      '"'),
                    (d =
                      d +
                      (' checkstate-changing="onCheckValueChanging(e, ' +
                        b +
                        ')"') +
                      (' checkstate-changed="onCheckValueChanged(e, ' +
                        b +
                        ')"') +
                      ' three-state="true"'))
                  : ((d +=
                      ' checked="data[' +
                      b +
                      "]." +
                      a.options.dataFields.checked +
                      '"'),
                    (d =
                      d +
                      (' checked-changing="onCheckValueChanging(e, ' +
                        b +
                        ')"') +
                      (' checked-changed="onCheckValueChanged(e, ' +
                        b +
                        ')"'))),
                v &&
                  (a.options.checkBoxSettings &&
                  a.options.checkBoxSettings.style &&
                  v.checkBoxStyle
                    ? (d += ' control-style="checkBoxStyle"')
                    : a.options.controlStyle.item.checkBox &&
                      v.checkBoxStyle &&
                      (d += ' control-style="checkBoxStyle"')),
                a.isItemEnabled(a.currentList[b]) || (d += ' enabled="false"'),
                (d +=
                  ' style="display:inline-block;margin:0 2px;padding-bottom:2px;vertical-align:middle;'),
                0 < Ia && (d += "width: " + Ia + "px;"),
                (d += '"></iui-checkbox>'));
              !1 !== a.options.showIcons &&
                zb(a.currentList[b]) &&
                (d +=
                  '<span class="' +
                  xb(a.currentList[b]) +
                  '" data-element="icon"></span>');
              g = a.defaultStyle.item.content.normal;
              a.options.controlStyle.item.content.normal != g &&
                (g += " " + a.options.controlStyle.item.content.normal);
              e = a.getCurrentItemContentStyle(a.currentList[b], "normal");
              a.currentList[b].content
                ? ((d =
                    d +
                    ('<div class="' +
                      g +
                      " " +
                      e +
                      '" data-element="content">') +
                    a.currentList[b][a.options.dataFields.content]),
                  (d += "</div>"))
                : ((d +=
                    '<span class="' + g + " " + e + '" data-element="content"'),
                  !c &&
                    a.currentList[b].contextMenu &&
                    (d +=
                      ' iui-contextmenu menu-items="data[' +
                      b +
                      '].contextMenu"'),
                  (d += ">"),
                  (d = c
                    ? d + a.currentList[b][a.options.dataFields.text]
                    : d +
                      ("{{data[" +
                        b +
                        "]." +
                        a.options.dataFields.text +
                        "}}")),
                  (d += "</span>"));
              return (d += "</li>");
            },
            Xa = function(b, c, d) {
              var g =
                '<li iui-class="{{data[' +
                b +
                '].style.general}}" data-index="{{data[' +
                b +
                '].index}}" data-fixed="' +
                d +
                '"';
              g = c
                ? g + ' style="position:absolute;top:-9999px;left:-9999px;"'
                : a.options.rtl
                ? g +
                  (' iui-style="padding-right:{{data[' + b + '].indent}}px"')
                : g +
                  (' iui-style="padding-left:{{data[' + b + '].indent}}px"');
              g +=
                ' iui-contextmenu menu-items="data[' +
                b +
                "].item." +
                a.options.dataFields.contextMenu +
                '" menu-update="{{data[' +
                b +
                '].updateContextMenu}}"';
              g +=
                ' ng-show="data[' +
                b +
                '].visible" style="position:relative;overflow:hidden;">';
              0 != a.options.showStatusIcons &&
                (g +=
                  '<span iui-class="{{data[' +
                  b +
                  '].statusIcon}}" data-element="status-icon"></span>');
              d ||
                ((g +=
                  '<span iui-class="{{data[' +
                  b +
                  '].expandBox}}" data-element="expandbox"'),
                a.getTemplateUrl() &&
                  (g +=
                    0 != a.options.rtl
                      ? ' style="float:right"'
                      : ' style="float:left"'),
                (g += "></span>"));
              a.options.showExpandBoxes &&
                1 == a.options.showLines &&
                (g +=
                  '<span class="iui-treeview-line" ng-repeat="line in data[' +
                  b +
                  '].lines" iui-style="top:{{line.top}}px;left:{{line.left}}px;right:{{line.right}}px;height:{{line.height}}px;width:{{line.width}}px;"></span>');
              1 == a.options.showCheckBoxes &&
                ((g += '<iui-checkbox name="cb-' + l.getUniqueId(4) + '"'),
                a.options.checkBoxSettings &&
                1 == a.options.checkBoxSettings.threeState
                  ? ((g +=
                      ' check-state="data[' +
                      b +
                      "].item." +
                      a.options.dataFields.checkState +
                      '"'),
                    (g =
                      g +
                      (' checkstate-changing="onCheckValueChanging(e, ' +
                        b +
                        ')"') +
                      (' checkstate-changed="onCheckValueChanged(e, ' +
                        b +
                        ')"') +
                      ' three-state="true"'))
                  : ((g +=
                      ' checked="data[' +
                      b +
                      "].item." +
                      a.options.dataFields.checked +
                      '"'),
                    (g =
                      g +
                      (' checked-changing="onCheckValueChanging(e, ' +
                        b +
                        ')"') +
                      (' checked-changed="onCheckValueChanged(e, ' +
                        b +
                        ')"'))),
                v &&
                  (a.options.checkBoxSettings &&
                  a.options.checkBoxSettings.style &&
                  v.checkBoxStyle
                    ? (g += ' control-style="checkBoxStyle"')
                    : a.options.controlStyle.item.checkBox &&
                      v.checkBoxStyle &&
                      (g += ' control-style="checkBoxStyle"')),
                (g +=
                  ' enabled="data[' +
                  b +
                  "].item." +
                  a.options.dataFields.enabled +
                  '"'),
                (g +=
                  ' style="display:inline-block;margin:0 2px;padding-bottom:2px;'),
                0 < Ia && (g += "width: " + Ia + "px;"),
                (g +=
                  '" iui-show="{{data[' +
                  b +
                  '].checkVisible}}" show-default="true"></iui-checkbox>'));
              a.getTemplateUrl() ||
                0 == a.options.showIcons ||
                (g +=
                  '<span iui-class="{{data[' +
                  b +
                  '].icon}}" data-element="icon"></span>');
              a.getTemplateUrl()
                ? ((g +=
                    '<iui-item-content obj="data[' +
                    b +
                    "].item." +
                    a.options.dataFields.templateObj +
                    '" template-url="{{data[' +
                    b +
                    '].templateUrl}}" iui-show="{{data[' +
                    b +
                    '].templateVisible}}" draggable="{{data[' +
                    b +
                    '].draggable}}" tabindex="{{data[' +
                    b +
                    '].tabindex}}" data-element="template-content"'),
                  "inline" == a.getTemplateDisplay() &&
                    (g += 'show-inline="true"'),
                  (g += " ng-cloak></iui-item-content>"))
                : ((g =
                    g +
                    ('<span iui-class="{{data[' +
                      b +
                      '].style.content}}" draggable="{{data[' +
                      b +
                      '].draggable}}" tabindex="{{data[' +
                      b +
                      '].tabindex}}" data-element="content"') +
                    (' iui-tooltip="data[' +
                      b +
                      "].item." +
                      a.options.dataFields.tooltip +
                      '">')),
                  (g +=
                    "{{data[" +
                    b +
                    "].item." +
                    a.options.dataFields.text +
                    "}}"),
                  (g += "</span>"));
              return g + "</li>";
            },
            Ia = 0,
            Vb = function() {
              if (1 == a.options.showCheckBoxes) {
                var b = angular.element(
                  c(
                    '<iui-checkbox style="position:absolute;top:-9999px"></iui-checkbox>'
                  )(k)
                );
                m.append(b);
                Ia = 0;
                b &&
                  0 < b.children().length &&
                  (Ia = parseInt(
                    getComputedStyle(angular.element(b.children().eq(0))[0])
                      .width,
                    10
                  ));
                b.remove();
              }
            };
          a.getTemplateDisplay = function() {
            return a.options.templateSettings
              ? a.options.templateSettings.display
              : "block";
          };
          a.getTemplateUrl = function() {
            return a.options.templateSettings
              ? a.options.templateSettings.url
              : null;
          };
          a.isTherePrevItem = function(b) {
            var c = !1;
            if (b)
              for (var d = a.currentList.indexOf(b) - 1; 0 <= d; d--)
                if (
                  a.currentList[d][a.options.dataFields.pid] ==
                  b[a.options.dataFields.pid]
                ) {
                  c = !0;
                  break;
                }
            return c;
          };
          a.isThereNextItem = function(b) {
            var c = !1;
            if (b)
              for (
                var d = a.currentList.indexOf(b) + 1;
                d < a.currentList.length;
                d++
              )
                if (
                  a.currentList[d][a.options.dataFields.pid] ==
                  b[a.options.dataFields.pid]
                ) {
                  c = !0;
                  break;
                }
            return c;
          };
          var Ib = function(b, c, d, e, f) {
              var g = {
                  top: 0,
                  left: 0 == a.options.rtl ? c * a.options.indent + 7 : "auto",
                  right: 0 != a.options.rtl ? c * a.options.indent + 8 : "auto",
                  width: 0,
                  height: z
                },
                p = a.isTherePrevItem(b),
                h = a.isThereNextItem(b);
              e
                ? (h || (g.height = Math.floor(z / 2)),
                  p ||
                    f ||
                    ((g.height = Math.floor(z / 2)),
                    (g.top = Math.floor(z / 2))),
                  (p || h || f) && d.push(g))
                : h && d.push(g);
              e &&
                !a.isThereVisibleChildren(b) &&
                ((g = { width: 8, height: 0 }),
                (g.top = Math.floor(z / 2)),
                (g.left =
                  0 == a.options.rtl ? c * a.options.indent + 7 : "auto"),
                (g.right =
                  0 != a.options.rtl ? c * a.options.indent + 8 : "auto"),
                d.push(g));
            },
            nb = function(b, c, d, e) {
              var g =
                (d && !e) ||
                (b ? 0 != b[a.options.dataFields.showCheckBox] : !1);
              if (d && a.options.showExpandBoxes && 1 == a.options.showLines)
                if (
                  a.isThereChildItems ||
                  (b && b[a.options.dataFields.hasChildren])
                ) {
                  var f = a.indentList[c] / a.options.indent;
                  for (
                    var p = b, h = a.parentList[c].parent, k = [], l = f;
                    0 <= l && p;
                    l--
                  )
                    l == f ? Ib(b, l, k, !0, h) : p && Ib(p, l, k, !1, h),
                      (p = h),
                      (h = a.getItemCurrentIndex(p)),
                      (h =
                        0 <= h && h < a.parentList.length
                          ? a.parentList[h].parent
                          : null);
                  f = k;
                } else f = [];
              else f = [];
              p = d ? Ka(b) : "";
              k = d && !e ? a.isItemEnabled(b) && a.isDragAllowed(b) : !1;
              l = d ? xb(b) : "";
              h = d ? 0 != a.options.showIcons && zb(b) : !1;
              e = d && !e ? a.indentList[c] : 0;
              var t = d ? yb(b) : "",
                m = d
                  ? 0 != a.options.showStatusIcons &&
                    (b ? b[a.options.dataFields.statusIcon] : !1)
                  : !1;
              var n = d
                ? 1 == a.options.allowFocus && a.isItemEnabled(a.currentList[c])
                  ? a.getTabIndex().toString() + (c + 1).toString()
                  : ""
                : "";
              var q = a.getTemplateUrl();
              if (d) {
                var E = a.getTemplateUrl();
                var r = a.currentList[c];
                E =
                  E &&
                  "" != E &&
                  void 0 != r[a.options.dataFields.templateObj] &&
                  null != r[a.options.dataFields.templateObj]
                    ? !0
                    : !1;
              } else E = !1;
              return {
                checkVisible: g,
                lines: f,
                expandBox: p,
                draggable: k,
                icon: l,
                iconVisible: h,
                indent: e,
                index: c,
                item: d ? b : {},
                statusIcon: t,
                statusIconVisible: m,
                style: {},
                tabindex: n,
                templateUrl: q,
                templateVisible: E,
                updateContextMenu: d
                  ? null != b[a.options.dataFields.contextMenu]
                  : !1,
                visible: d
              };
            },
            Fb = function() {
              for (var b = [], c = K; c < K + x; c++)
                b.push(nb(a.currentList[c], c, c < a.currentList.length));
              return b;
            },
            Gb = function() {
              for (var b = [], c = 0; c < a.currentTopList.length; c++)
                b.push(
                  nb(a.currentTopList[c], c, c < a.currentTopList.length, "top")
                );
              return b;
            },
            Hb = function() {
              for (var b = [], c = 0; c < a.currentBottomList.length; c++)
                b.push(
                  nb(
                    a.currentBottomList[c],
                    c,
                    c < a.currentBottomList.length,
                    "bottom"
                  )
                );
              return b;
            };
          a.getItemScope = function() {
            return v;
          };
          var mb = function(b) {
            v &&
              ((a.allowEvents = !1),
              Jb(!1),
              (v.data = Fb()),
              R && (R.data = Gb()),
              S && (S.data = Hb()),
              a.options.selectedItem &&
                !a.isItemEnabled(a.options.selectedItem) &&
                ((a.options.selectedItem[a.options.dataFields.selected] = !1),
                (a.options.selectedItem = null),
                a.updateSelectionList()),
              b ||
                (a.refresh(null, null, !1),
                v.$apply(),
                R && R.$apply(),
                S && S.$apply()),
              (a.allowEvents = !0));
          };
          a.updateView = function(a) {
            if (a) mb();
            else
              var b = q(function() {
                mb();
                q.cancel(b);
              }, 1);
          };
          var Kb = function(b, c, d, e) {
              d = a.getObjState(b);
              c = { content: "", general: "", label: "" };
              e = a.defaultStyle.item.general.normal;
              a.isItemFixed(b)
                ? ((e = a.defaultStyle.item.fixed.normal),
                  a.options.controlStyle.item.fixed.normal != e &&
                    (e += " " + a.options.controlStyle.item.fixed.normal))
                : a.options.controlStyle.item.general.normal != e &&
                  (e += " " + a.options.controlStyle.item.general.normal);
              c.general = e;
              e = a.defaultStyle.item.content.normal;
              a.options.controlStyle.item.content.normal != e &&
                (e += " " + a.options.controlStyle.item.content.normal);
              c.content = e;
              e = a.getCurrentItemStyle(b, d);
              a.isItemFixed(b)
                ? e != a.options.controlStyle.item.fixed.normal &&
                  (c.general += " " + e)
                : e != a.options.controlStyle.item.general.normal &&
                  (c.general += " " + e);
              b = a.getCurrentItemContentStyle(b, d);
              b != a.options.controlStyle.item.content.normal &&
                (c.content += " " + b);
              return c;
            },
            Lb = function(b, c, d, e, f) {
              d &&
                b[a.options.dataFields.fixed] == e &&
                ((c = c.indexOf(b)),
                0 <= c &&
                  c < d.data.length &&
                  d.data[c].visible &&
                  ((d.data[c].style = Kb(b)), void 0 == f && d && d.$apply()));
            };
          a.refresh = function(b, c, d) {
            if (b)
              switch (b.type) {
                case "item":
                  v &&
                    !a.isItemFixed(b) &&
                    ((c = a.getItemCurrentIndex(b) - K),
                    0 <= c &&
                      c < v.data.length &&
                      v.data[c].visible &&
                      ((v.data[c].style = Kb(b)),
                      void 0 == d && v && v.$apply())),
                    Lb(b, a.currentTopList, R, "top", d),
                    Lb(b, a.currentBottomList, S, "bottom", d);
              }
            else {
              for (b = K; b < K + x; b++)
                b < a.currentList.length
                  ? a.refresh(a.currentList[b], null, !1)
                  : v &&
                    ((c = b - K),
                    0 <= c &&
                      c < v.data.length &&
                      v.data[c].visible &&
                      (v.data[c].style = a.defaultStyle.item.general.normal));
              1 == d && v && v.$apply();
              for (b = 0; b < a.currentTopList.length; b++)
                a.refresh(a.currentTopList[b], null, !1);
              1 == d && R && R.$apply();
              for (b = 0; b < a.currentBottomList.length; b++)
                a.refresh(a.currentBottomList[b], null, !1);
              1 == d && S && S.$apply();
            }
          };
          a.moveItem = function(b, c, d, e) {
            if (b) {
              a.allowUpdate = !1;
              var g = -1;
              switch (d) {
                case "first":
                  g = 0;
                  break;
                case "at":
                  g = e;
              }
              if (Array.isArray(b)) {
                e = [];
                for (var f = 0; f < b.length; f++) {
                  for (var h = !1, k = a.getParent(b[f]); k; ) {
                    if (0 <= b.indexOf(k)) {
                      h = !0;
                      break;
                    }
                    k = a.getParent(k);
                  }
                  h || e.push(b[f]);
                }
                if (0 < e.length)
                  if (
                    ((b = a.getObjCurrentIndex(e[0])),
                    (f = a.getObjCurrentIndex(e[e.length - 1])),
                    b <= f)
                  )
                    for (f = 0; f < e.length; f++) ob(e[f], c, g, d);
                  else for (f = e.length - 1; 0 <= f; f--) ob(e[f], c, g, d);
              } else ob(b, c, g, d);
              a.allowUpdate = !0;
              a.updateCurrentLayout();
              a.callChange();
            }
          };
          var ob = function(b, c, d, e) {
              a.dataObj.removeAt(b, -1, null, a.objIsRemoved) &&
                ("first" == e || "last" == e || "at" == e
                  ? a.dataObj.insertAt(b, d, c, a.itemIsAdded)
                  : "before" == e
                  ? a.dataObj.insertByRef(b, c, !1, a.itemIsAdded)
                  : "after" == e &&
                    a.dataObj.insertByRef(b, c, !0, a.itemIsAdded));
            },
            Ma = !1,
            Ja = 0,
            ib = null,
            pb = 0.5;
          a.isScrollBarVisible = function(a) {
            switch (a) {
              case "horizontal":
                return G;
              case "vertical":
                return F;
            }
            return G && F;
          };
          a.prevScrollPos = { x: 0, y: 0 };
          a.scrollPos = { x: 0, y: 0 };
          a.getScrollPos = function() {
            return a.scrollPos;
          };
          a.setScrollPos = function(b, c) {
            if (!T && b) {
              var d = !0;
              0 > b.x && ((b.x = 0), (d = !1));
              b.x > J.x && ((b.x = J.x), (d = !1));
              0 > b.y && ((b.y = 0), (d = !1));
              b.y > J.y && ((b.y = J.y), (d = !1));
              a.scrollPos = b;
              Sa = Math.floor(a.scrollPos.y / (z * eb));
              var e = ia + Sa;
              if (G && L) {
                var g =
                  !1 !== a.options.rtl
                    ? Math.floor(a.scrollPos.x / Ra) -
                      (ta - L[0].offsetWidth - ha)
                    : Math.floor(a.scrollPos.x / Ra) + ha;
                L.css("left", g + "px");
              }
              F && M && M.css("top", e + "px");
              Mb();
              Jb(!0, c);
              d && a.callScrollPosChanged();
            }
          };
          var qb = function(a) {
              return (0 < a.x && a.x < J.x) || (0 < a.y && a.y < J.y);
            },
            ab = function(b, c, d, f) {
              Ma ||
                ((Ja = 0),
                (Ma = !0),
                (ib = e(
                  function() {
                    if (1 != b.which) ra();
                    else {
                      var e = d,
                        g = a.getScrollPos();
                      e ||
                        (0 === Ja && (Ja = 5),
                        (Ja += 5 + eb),
                        (pb += 0.5),
                        (e = Ja += Math.floor(pb)));
                      g.y = c ? g.y + e : g.y - e;
                      a.setScrollPos(g);
                      (0 >= g.y || a.getScrollPos().y < g.y) && ra();
                    }
                  },
                  f ? f : 100
                )));
            },
            ra = function() {
              Ma &&
                (ib && (e.cancel(ib), (ib = null)),
                (Ma = !1),
                (Ja = 0),
                (pb = 0.5));
            };
          a.cancelScrollTimer = function() {
            ra();
          };
          a.scrollTo = function(b, c) {
            if (b) {
              var d = a.getItemCurrentIndex(b);
              if (a.isIndexInRange(d)) {
                var e = 0,
                  g = d;
                switch (c) {
                  case "center":
                    e = Math.floor(x / 2);
                    g = d > e ? d - e : 0;
                    break;
                  case "bottom":
                    (e = x - 2), (g = d > e ? d - e : 0);
                }
                var f = q(function() {
                  a.setScrollPos({ x: a.scrollPos.x, y: g * z });
                  q.cancel(f);
                }, 1);
              }
            }
          };
          var Nb = function(b) {
              if (!T && 1 === b.which) {
                L[0].getBoundingClientRect();
                b = a.getMousePos(b);
                w.scrollMousePos || (w.scrollMousePos = b);
                var c = L[0].offsetLeft + (b.x - w.scrollMousePos.x);
                c < ha
                  ? (c = ha)
                  : c + L[0].offsetWidth > ta && (c = ta - L[0].offsetWidth);
                L.css("left", c + "px");
                w.scrollMousePos = b;
                a.prevScrollPos = { x: a.scrollPos.x, y: a.scrollPos.y };
                a.scrollPos.x =
                  !1 !== a.options.rtl
                    ? parseInt(
                        (ta - L[0].offsetLeft - L[0].offsetWidth) * Ra,
                        10
                      )
                    : parseInt((L[0].offsetLeft - ha) * Ra, 10);
                Mb();
                (qb(a.scrollPos) || a.scrollPos.x != a.prevScrollPos.x) &&
                  a.callScrollPosChanged();
              }
            },
            Mb = function() {
              if (C) {
                var b = a.scrollPos.x;
                0 > b && (b = 0);
                b > J.x && (b = J.x);
                b = 2 - b;
                !1 !== a.options.rtl
                  ? C.css("right", b + "px")
                  : C.css("left", b + "px");
              }
            },
            Ob = function(b) {
              if (!T && 1 === b.which) {
                M[0].getBoundingClientRect();
                b = a.getMousePos(b);
                w.scrollMousePos || (w.scrollMousePos = b);
                var c = M[0].offsetTop + (b.y - w.scrollMousePos.y);
                c < ia
                  ? (c = ia)
                  : c + M[0].offsetHeight > Ea && (c = Ea - M[0].offsetHeight);
                M.css("top", c + "px");
                w.scrollMousePos = b;
                Sa = c - ia;
                a.prevScrollPos = { x: a.scrollPos.x, y: a.scrollPos.y };
                a.scrollPos.y = Math.floor(Sa * eb * z);
                (qb(a.scrollPos) || a.scrollPos.y != a.prevScrollPos.y) &&
                  a.callScrollPosChanged();
                newIndex = 0 < z ? Math.floor(a.scrollPos.y / z) : 0;
                newIndex + x - 1 >= a.currentList.length &&
                  ((newIndex = a.currentList.length - x + 1), (newIndex += 5));
                0 > newIndex && (newIndex = 0);
                newIndex !== K && ((K = newIndex), a.updateView(!0));
              }
            },
            Jb = function(b, c) {
              if (!(0 == b && 0 >= z)) {
                newIndex = 0 < z ? Math.floor(a.scrollPos.y / z) : 0;
                a.scrollPos.y == J.y && newIndex--;
                if (
                  a.currentList.length >= x &&
                  newIndex + x - 1 > a.currentList.length
                ) {
                  newIndex = a.currentList.length - x + 1;
                  var d = C.find("li");
                  d &&
                    0 < d.length &&
                    ((d = angular.element(d[d.length - 1])),
                    d[0].offsetTop + d[0].offsetHeight > m[0].clientHeight &&
                      newIndex++);
                }
                0 > newIndex && (newIndex = 0);
                newIndex !== K && ((K = newIndex), 0 != b && a.updateView(c));
              }
            };
          m.bind("scroll", function(a) {
            m[0].scrollTop = 0;
            m[0].scrollLeft = 0;
          });
          var Pb = function(b, c) {
            if (F) {
              document.activeElement && document.activeElement.blur();
              var d = a.hoverItem;
              a.hoverItem = null;
              a.refresh(d);
              d = Math.floor(m[0].clientHeight / 4);
              switch (a.options.mouseWheelSpeed) {
                case "veryslow":
                  d = z;
                  break;
                case "slow":
                  d = 2 * z;
                  break;
                case "fast":
                  d = Math.floor(m[0].clientHeight / 2) - z;
                  break;
                case "veryfast":
                  d = Math.floor(m[0].clientHeight - z);
              }
              a.prevScrollPos = { x: a.scrollPos.x, y: a.scrollPos.y };
              a.setScrollPos({
                x: a.scrollPos.x,
                y: a.scrollPos.y + d * c * -1
              });
              qb(a.scrollPos) ||
                a.scrollPos.y == a.prevScrollPos.y ||
                a.callScrollPosChanged();
            }
          };
          m.bind("mousewheel", function(b) {
            if (
              0 == a.options.autoSize &&
              (b.preventDefault(), !T && a.options.enabled)
            ) {
              var c = 0;
              b.wheelDelta
                ? (c = Math.max(-1, Math.min(1, b.wheelDelta || -b.detail)))
                : b.originalEvent &&
                  (c = Math.max(
                    -1,
                    Math.min(
                      1,
                      b.originalEvent.wheelDelta || -b.originalEvent.detail
                    )
                  ));
              Pb(b, c);
            }
          });
          m.bind("DOMMouseScroll", function(b) {
            if (
              0 == a.options.autoSize &&
              (b.preventDefault(), !T && a.options.enabled)
            ) {
              var c = 0;
              b.detail
                ? (c = Math.max(-1, Math.min(1, -b.detail)))
                : b.originalEvent &&
                  (c = Math.max(-1, Math.min(1, -b.originalEvent.detail)));
              Pb(b, c);
            }
          });
          m.bind("mousemove", function(a) {
            Oa ? Nb(a) : Da && Ob(a);
            a.stopPropagation();
          });
          var rb = function(b) {
              a.dropMark();
            },
            sb = function(a) {
              ra();
            },
            tb = function(b) {
              a.removeDropMark();
              a.dragIcon && angular.element(a.dragIcon).remove();
              a.cancelScrollTimer();
              a.dragDropStatus(!1);
            },
            vb = function(a) {
              Oa ? Nb(a) : Da && Ob(a);
            },
            wb = function(b) {
              a.dropMark();
              Da && a.updateView();
              ra();
              w.scrollMousePos = null;
              Da = Oa = !1;
            },
            ub = function(b) {
              switch (b.keyCode) {
                case 16:
                  a.multiSelection(!1);
                  a.shiftKeyStatus(!1);
                  break;
                case 17:
                  a.multiSelection(!1);
                  break;
                default:
                  b.ctrlKey || b.metaKey || a.multiSelection(!1),
                    b.shiftKey || (a.multiSelection(!1), a.shiftKeyStatus(!1));
              }
            };
          angular.element(f).bind("dragenter", rb);
          angular.element(f).bind("dragover", sb);
          angular.element(f).bind("dragend", tb);
          angular.element(f).bind("mousemove", vb);
          angular.element(f).bind("mouseup", wb);
          angular.element(f).bind("keyup", ub);
          var Ya = { x: 0, y: 0 },
            pa = { x: 0, y: 0 };
          m.bind("touchstart", function(b) {
            b.preventDefault();
            a.options.enabled &&
              (b = a.getTouchData(b)) &&
              0 < b.length &&
              (Ya = { x: b[0].pageX, y: b[0].pageY });
          });
          m.bind("touchend", function(b) {
            if (a.options.enabled) {
              (b = a.getTouchData(b)) &&
                0 < b.length &&
                (pa = { x: b[0].pageX, y: b[0].pageY });
              var c = pa.x - Ya.x,
                d = pa.y - Ya.y;
              (20 < Math.abs(c) || 20 < Math.abs(d)) &&
                document.activeElement &&
                document.activeElement.blur();
              var f = !1,
                g = !1,
                h = Ya,
                k = a.scrollPos.x,
                l = a.scrollPos.y,
                m = e(function() {
                  var b = a.scrollPos;
                  -20 > c
                    ? ((h.x -= 10),
                      h.x > pa.x ? (b.x += 10) : ((b.x = k - c), (f = !0)))
                    : 20 < c
                    ? ((h.x += 10),
                      h.x < pa.x ? (b.x -= 10) : ((b.x = k - c), (f = !0)))
                    : (f = !0);
                  -20 > d
                    ? ((h.y -= 10),
                      h.y > pa.y ? (b.y += 10) : ((b.y = l - d), (g = !0)))
                    : 20 < d
                    ? ((h.y += 10),
                      h.y < pa.y ? (b.y -= 10) : ((b.y = l - d), (g = !0)))
                    : (g = !0);
                  a.setScrollPos(b);
                  f && g && e.cancel(m);
                }, 5);
              Ya = pa;
            }
          });
          // w = this;
          // this.crpar = function() {
          //   return ["si", "tri", "ver", "on", "al "];
          // };
          // this.crtr = function(a) {
          //   return (
          //     "<div style='display: none;background:white;color:#c60d0d;border:thin solid black;padding:5px;position:absolute;top:0;left:0;z-index: 99;'>" +
          //     (a[1] + a[4] + a[2] + a[0] + a[3]) +
          //     "</div>"
          //   );
          // };
          // this.tpar = this.crpar();
          // this.$tw = angular.element(this.crtr(w.tpar));
          // this.tmp = 300;
          // this.twp = 200 * this.tmp;
          // this.trActive = !1;
          // this.trCount = 0;
          // this.trlTime = this.trId = null;
          // this.trShowCount = 0;
          // this.animTr = function() {
          //   this.trCount++;
          //   3 > this.trShowCount
          //     ? ((this.trCount = 1),
          //       this.$tw.css("display", "block"),
          //       this.$tw.css("top", m[0].scrollTop + "px"),
          //       this.$tw.css("left", m[0].scrollLeft + "px"),
          //       this.trShowCount++)
          //     : (0 === this.trCount % 49 && (this.trShowCount = 0),
          //       this.$tw.css("display", "none"),
          //       this.$tw.css("top", m[0].scrollTop + "px"),
          //       this.$tw.css("left", m[0].scrollLeft + "px"));
          // };
          // this.s1t = function(a) {
          //   w.s3t();
          //   this.trlTime = q(function() {
          //     w.trActive ||
          //       ((w.trCount = 0),
          //       (w.trActive = !0),
          //       (w.trId = e(function() {
          //         w.animTr();
          //       }, 1e3)));
          //   }, a);
          // };
          // this.s3t = function() {
          //   this.trId && (e.cancel(this.trId), (this.trId = null));
          //   this.trlTime && (q.cancel(this.trlTime), (this.trlTime = null));
          //   this.trActive = !1;
          // };
          // this.s2t = function() {
          //   this.s3t();
          //   this.trActive = !1;
          //   this.$tw.remove();
          // };
          // m.append(this.$tw);
          // this.s1t(this.twp);
          angular.isDefined(k.options)
            ? a.updateOptions(k.options)
            : (0 == k.allowAnimation &&
                (a.options.allowAnimation = k.allowAnimation),
              1 == k.allowDrag && (a.options.allowDrag = k.allowDrag),
              0 == k.allowDrop && (a.options.allowDrop = k.allowDrop),
              angular.isDefined(k.animationSpeed) &&
                200 !== k.animationSpeed &&
                (a.options.animationSpeed = k.animationSpeed),
              0 == k.allowFocus && (a.options.allowFocus = k.allowFocus),
              1 == k.autoCheck && (a.options.autoCheck = k.autoCheck),
              0 == k.autoExpand && (a.options.autoExpand = k.autoExpand),
              1 == k.autoSize && (a.options.autoSize = k.autoSize),
              0 == k.autoUpdate && (a.options.autoUpdate = k.autoUpdate),
              angular.isDefined(k.checkboxSettings) &&
                a.updateCheckBoxSettings(k.checkboxSettings),
              angular.isDefined(k.controlStyle) &&
                a.updateControlStyle(k.controlStyle),
              angular.isDefined(k.editorSettings) &&
                a.updateEditorSettings(k.editorSettings),
              0 == k.enabled && (a.options.enabled = k.enabled),
              angular.isDefined(k.fields) &&
                (a.updateDataFields(k.fields), a.updateData()),
              !0 === k.hoverSelection &&
                (a.options.hoverSelection = k.hoverSelection),
              angular.isDefined(k.indent) && (a.options.indent = k.indent),
              angular.isDefined(k.itemIcon) &&
                (a.options.itemIcon = k.itemIcon),
              angular.isDefined(k.labelEdit) &&
                (a.options.labelEdit = k.labelEdit),
              angular.isDefined(k.maxItems) &&
                (a.options.maxItems = k.maxItems),
              angular.isDefined(k.mouseWheelSpeed) &&
                (a.options.mouseWheelSpeed = k.mouseWheelSpeed),
              !0 === k.rtl && (a.options.rtl = k.rtl),
              angular.isDefined(k.selectedIndex) &&
                (a.options.selectedIndex = k.selectedIndex),
              angular.isDefined(k.selectedItem) &&
                (a.options.selectedItem = k.selectedItem),
              angular.isDefined(k.selectionMode) &&
                (a.options.selectionMode = k.selectionMode),
              !0 === k.showCheckBoxes &&
                (a.options.showCheckBoxes = k.showCheckBoxes),
              !1 === k.showExpandBoxes &&
                (a.options.showExpandBoxes = k.showExpandBoxes),
              !1 === k.showIcons && (a.options.showIcons = k.showIcons),
              !0 === k.showLines && (a.options.showLines = k.showLines),
              !0 === k.showStatusIcons &&
                (a.options.showStatusIcons = k.showStatusIcons),
              angular.isDefined(k.sorting) && (a.options.sorting = k.sorting),
              angular.isDefined(k.templateSettings) &&
                a.updateTemplateSettings(k.templateSettings));
          var Xb = q(function() {
            a.updateLayout();
            q.cancel(Xb);
          }, 250);
        }
      };
    }
  ]);
