/*
  filename: angular.integralui.checkbox.min.js
  version : 1.4.5
  Copyright � 2014-2018 Lidor Systems. All rights reserved.

  This file is part of the "IntegralUI" Library. 
                                                                   
  The contents of this file are subject to the IntegralUI Studio for Web License, and may not be used except in compliance with the License.
  A copy of the License should have been installed in the product's root installation directory or it can be found at
  http://www.lidorsystems.com/products/web/studio/license-agreement.aspx.
                                                            
  This SOFTWARE is provided "AS IS", WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language 
  governing rights and limitations under the License. Any infringement will be prosecuted under applicable laws.                           
*/
angular
  .module("integralui")
  .factory("IntegralUICheckBoxService", [
    "$rootScope",
    "IntegralUIPublicService",
    function(c, l) {
      return {
        refresh: function(d) {
          c.$broadcast(d + "-refresh");
        },
        resumeLayout: function(d) {
          c.$broadcast(d + "-resume-layout");
        },
        suspendLayout: function(d) {
          c.$broadcast(d + "-suspend-layout");
        },
        updateLayout: function(d) {
          c.$broadcast(d + "-update-layout");
        }
      };
    }
  ])
  .controller("IntegralUICheckBoxController", [
    "$scope",
    "$element",
    "IntegralUIInternalService",
    function(c, l, d) {
      var b = this;
      b.defaultStyle = {
        general: "iui-checkbox",
        box: {
          general: "iui-checkbox-box",
          disabled: "iui-checkbox-box-disabled",
          checked: "iui-checkbox-checked",
          indeterminate: "iui-checkbox-indeterminate",
          unchecked: "iui-checkbox-unchecked"
        },
        content: {
          general: "iui-checkbox-content",
          disabled: "iui-checkbox-content-disabled"
        }
      };
      b.options = {};
      this.updateOptions = function(a) {
        a
          ? ((b.options = {
              autoCheck: d.isFieldAvailable(a.autoCheck, !0),
              checked: d.isFieldAvailable(a.checked, !1),
              checkState: d.isFieldAvailable(a.checkState, "unchecked"),
              controlStyle: b.defaultStyle,
              enabled: d.isFieldAvailable(a.enabled, !0),
              rtl: d.isFieldAvailable(a.rtl, !1),
              text: d.isFieldAvailable(a.text, ""),
              threeState: d.isFieldAvailable(a.threeState, !1)
            }),
            b.updateControlStyle(a.controlStyle))
          : (b.options = {
              autoCheck: !0,
              checked: !1,
              checkState: "unchecked",
              controlStyle: b.defaultStyle,
              enabled: !0,
              rtl: !1,
              text: "",
              threeState: !1
            });
      };
      b.updateOptions();
      this.getCheckValue = function(a) {
        return "checked" == a
          ? "checked"
          : 1 == b.options.threeState && "indeterminate" == a
          ? "indeterminate"
          : "unchecked";
      };
      this.setCheckValue = function(a) {
        !1 !==
          (1 == b.options.threeState
            ? b.callCheckStateChanging(a)
            : b.callCheckedChanging(a)) &&
          ((b.options.checkState =
            "unchecked" == a
              ? 1 == b.options.threeState
                ? "indeterminate"
                : "checked"
              : "indeterminate" == a
              ? "checked"
              : "unchecked"),
          (b.options.checked = "checked" == b.options.checkState ? !0 : !1),
          angular.isDefined(c.checked) && (c.checked = b.options.checked),
          angular.isDefined(c.checkState) &&
            (c.checkState = b.options.checkState),
          angular.isDefined(c.checkState) || 1 != b.options.threeState
            ? angular.isDefined(c.checked) ||
              0 != b.options.threeState ||
              b.callCheckedChanged(b.options.checkState)
            : b.callCheckStateChanged(b.options.checkState));
      };
      this.callCheckedChanging = function(a) {
        a = b.getCheckValue(a);
        var d = "checked" == a ? !0 : !1;
        return angular.isDefined(c.events) && c.events.checkedChanging
          ? c.events.checkedChanging({ checked: d, checkState: a })
          : c.checkedChanging({ e: { checked: d, checkState: a } });
      };
      this.callCheckedChanged = function(a) {
        a = b.getCheckValue(a);
        var d = "checked" == a ? !0 : !1;
        angular.isDefined(c.events) && c.events.checkedChanged
          ? c.events.checkedChanged({ checked: d, checkState: a })
          : c.checkedChanged({ e: { checked: d, checkState: a } });
      };
      this.callCheckStateChanging = function(a) {
        a = b.getCheckValue(a);
        var d = "checked" == a ? !0 : !1;
        return angular.isDefined(c.events) && c.events.checkstateChanging
          ? c.events.checkstateChanging({ checked: d, checkState: a })
          : c.checkstateChanging({ e: { checked: d, checkState: a } });
      };
      this.callCheckStateChanged = function(a) {
        a = b.getCheckValue(a);
        var d = "checked" == a ? !0 : !1;
        angular.isDefined(c.events) && c.events.checkstateChanged
          ? c.events.checkstateChanged({ checked: d, checkState: a })
          : c.checkstateChanged({ e: { checked: d, checkState: a } });
      };
      this.callClick = function(a) {
        a = b.getCheckValue(a);
        var d = "checked" == a ? !0 : !1;
        angular.isDefined(c.events) && c.events.click
          ? c.events.click({ checked: d, checkState: a })
          : c.click({ e: { checked: d, checkState: a } });
      };
      this.callEnabledChanged = function(a) {
        angular.isDefined(c.events) && c.events.enabledChanged
          ? c.events.enabledChanged({ enabled: a })
          : c.enabledChanged({ e: { enabled: a } });
      };
      this.callStyleChanged = function(a) {
        angular.isDefined(c.events) && c.events.styleChanged
          ? c.events.styleChanged({ style: a })
          : c.styleChanged({ e: { style: a } });
      };
      b.allowUpdate = !0;
      this.suspendLayout = function() {
        b.allowUpdate = !1;
      };
      this.resumeLayout = function() {
        b.allowUpdate = !0;
        b.updateLayout();
      };
      c.$on(c.name + "-refresh", function(a) {
        b.refresh();
      });
      c.$on(c.name + "-resume-layout", function(a) {
        b.resumeLayout();
      });
      c.$on(c.name + "-suspend-layout", function(a) {
        b.suspendLayout();
      });
      c.$on(c.name + "-update-layout", function(a) {
        b.updateLayout();
      });
      c.$watch("autoCheck", function(a, c) {
        a !== c && (b.options.autoCheck = a);
      });
      c.$watch("checked", function(a, c) {
        a !== c &&
          ((b.options.checked = 1 == a ? !0 : !1),
          (b.options.checkState = b.options.checked ? "checked" : "unchecked"),
          b.updateCheckMark(),
          b.callCheckedChanged(b.options.checkState));
      });
      c.$watch("checkState", function(a, c) {
        a !== c &&
          ((b.options.checkState = b.getCheckValue(a)),
          (b.options.checked = "checked" == b.options.checkState ? !0 : !1),
          b.updateCheckMark(),
          b.callCheckStateChanged(b.options.checkState));
      });
      c.$watch("controlStyle", function(a, c) {
        a !== c &&
          ((b.options.controlStyle = a), b.refresh(), b.callStyleChanged(a));
      });
      c.$watch("enabled", function(a, c) {
        a !== c &&
          ((b.options.enabled = a),
          b.refresh(),
          b.updateCheckMark(),
          b.callEnabledChanged(a));
      });
      c.$watch(
        "options",
        function(a, c) {
          a !== c && (b.updateOptions(a), b.updateLayout());
        },
        !0
      );
      c.$watch("rtl", function(a, c) {
        a !== c && ((b.options.rtl = a), b.updateLayout());
      });
      c.$watch("text", function(a, c) {
        a !== c && (b.options.text = a);
      });
      c.$watch("threeState", function(a, c) {
        a !== c &&
          ((b.options.threeState = a),
          0 == b.options.threeState &&
            "indeterminate" == b.options.checkState &&
            b.setCheckValue("checked"));
      });
      var f = function(a) {
          return a
            ? {
                general: d.isFieldAvailable(a.general, "iui-checkbox-box"),
                disabled: d.isFieldAvailable(
                  a.disabled,
                  "iui-checkbox-disabled"
                ),
                checked: d.isFieldAvailable(a.checked, "iui-checkbox-checked"),
                indeterminate: d.isFieldAvailable(
                  a.indeterminate,
                  "iui-checkbox-indeterminate"
                ),
                unchecked: d.isFieldAvailable(
                  a.unchecked,
                  "iui-checkbox-unchecked"
                )
              }
            : b.defaultStyle.box;
        },
        m = function(a) {
          return a
            ? {
                general: d.isFieldAvailable(a.general, "iui-checkbox-content"),
                disabled: d.isFieldAvailable(
                  a.disabled,
                  "iui-checkbox-content-disabled"
                )
              }
            : b.defaultStyle.content;
        };
      this.updateControlStyle = function(a) {
        b.options.controlStyle = a
          ? {
              general: d.isFieldAvailable(a.general, "iui-checkbox"),
              box: f(a.box),
              content: m(a.content)
            }
          : {
              general: d.isFieldAvailable(
                b.defaultStyle.general,
                "iui-checkbox"
              ),
              box: f(b.defaultStyle.box),
              content: m(b.defaultStyle.content)
            };
      };
    }
  ])
  .directive("iuiCheckbox", [
    "$timeout",
    "$interval",
    "IntegralUIInternalService",
    function(c, l, d) {
      return {
        restrict: "EA",
        controller: "IntegralUICheckBoxController",
        transclude: !0,
        replace: !0,
        template:
          '<div data-element="checkbox"><canvas></canvas><div ng-transclude></div></div>',
        scope: {
          autoCheck: "=",
          checked: "=",
          checkState: "=",
          controlStyle: "=",
          enabled: "=",
          name: "@",
          options: "=?",
          rtl: "=",
          text: "@",
          threeState: "=",
          checkedChanging: "&",
          checkedChanged: "&",
          checkstateChanging: "&",
          checkstateChanged: "&",
          click: "&",
          enabledChanged: "&",
          styleChanged: "&",
          events: "=?"
        },
        link: function(b, f, m, a, t) {
          var g = this,
            e = f.children().eq(0),
            h = f.children().eq(1);
          b.$on("$destroy", function(a) {
            g.cb_s2t();
            f.unbind("click touchstart");
            n();
          });
          var n = function() {
              e.unbind("click mouseup touchstart");
            },
            q = function() {
              e.bind("click", function(b) {
                0 != a.options.enabled &&
                  (a.setCheckValue(a.options.checkState),
                  a.callClick(a.options.checkState),
                  a.updateLayout());
                b.stopPropagation();
              });
              e.bind("mouseup", function(a) {
                a.stopPropagation();
              });
              e.bind("touchstart", function(b) {
                b.preventDefault();
                var c = d.getTouchData(b);
                c &&
                  0 < c.length &&
                  (0 != a.options.enabled &&
                    (a.setCheckValue(a.options.checkState),
                    a.callClick(a.options.checkState),
                    a.updateLayout()),
                  b.stopPropagation());
              });
            };
          f.bind("click", function(b) {
            0 != a.options.enabled &&
              a.options.autoCheck &&
              (a.setCheckValue(a.options.checkState), a.updateLayout());
          });
          f.bind("touchstart", function(b) {
            b.preventDefault();
            (b = d.getTouchData(b)) &&
              0 < b.length &&
              0 != a.options.enabled &&
              a.options.autoCheck &&
              (a.setCheckValue(a.options.checkState), a.updateLayout());
          });
          a.updateCheckMark = function() {
            if (e) {
              var b = getComputedStyle(e[0])["background-image"];
              if (b && "none" != b) k();
              else if ("CANVAS" == e[0].tagName) {
                k();
                getComputedStyle(e[0]);
                var b = getComputedStyle(e[0]).color,
                  c = e[0].getContext("2d"),
                  d = e[0].width,
                  f = e[0].height;
                c.beginPath();
                c.rect(0, 0, d, f);
                c.fillStyle = "#ffffff";
                c.fill();
                "checked" == a.options.checkState
                  ? ((c.lineWidth = 12 < f ? 3 : 1),
                    (c.strokeStyle = b),
                    "indeterminate" == a.options.checkState &&
                      (c.strokeStyle = "#808080"),
                    c.beginPath(),
                    c.moveTo(3, f / 2 + 1),
                    c.lineTo(0 + d / 2, 0 + f - 3),
                    c.stroke(),
                    c.beginPath(),
                    c.moveTo(0 + d / 2 - 1, 0 + f - 3),
                    c.lineTo(0 + d - 3, 3),
                    c.stroke())
                  : "indeterminate" == a.options.checkState &&
                    (c.beginPath(),
                    c.rect(4, 4, d - 8, f - 8),
                    (c.fillStyle = b),
                    c.fill());
              }
            }
          };
          a.updateLayout = function() {
            if (a.allowUpdate) {
              n();
              a.refresh();
              var b = c(function() {
                var d = "ltr";
                !0 === a.options.rtl && (d = "rtl");
                f.css("direction", d);
                if (
                  (d = getComputedStyle(e[0])["background-image"]) &&
                  "none" != d
                )
                  e.remove(),
                    (e = angular.element("<span></span>")),
                    f.prepend(e),
                    k();
                else {
                  e.remove();
                  e = angular.element("<canvas></canvas>");
                  f.prepend(e);
                  k();
                  var d = getComputedStyle(e[0]).width,
                    g = getComputedStyle(e[0]).height;
                  e[0].width = d ? parseInt(d, 10) : 14;
                  e[0].height = g ? parseInt(g, 10) : 14;
                  !0 === a.options.rtl
                    ? (e.css("left", "auto"), e.css("right", 0))
                    : (e.css("left", 0), e.css("right", "auto"));
                  a.updateCheckMark();
                }
                0 == h.children().length && h.css("padding", 0);
                q();
                c.cancel(b);
              }, 1);
            }
          };
          var k = function() {
            var b =
              a.defaultStyle.box.general +
              " " +
              a.defaultStyle.box[a.options.checkState];
            a.options.controlStyle &&
              a.options.controlStyle.box &&
              (a.options.controlStyle.box.general &&
                d.isString(a.options.controlStyle.box.general) &&
                (b += " " + a.options.controlStyle.box.general),
              0 == a.options.enabled &&
              a.options.controlStyle.box.disabled &&
              d.isString(a.options.controlStyle.box.disabled)
                ? (b += " " + a.options.controlStyle.box.disabled)
                : a.options.controlStyle.box[a.options.checkState] &&
                  d.isString(
                    a.options.controlStyle.box[a.options.checkState]
                  ) &&
                  (b +=
                    " " + a.options.controlStyle.box[a.options.checkState]));
            e.removeAttr("class");
            e.addClass(b);
          };
          a.refresh = function() {
            f.removeAttr("class");
            f.addClass(a.defaultStyle.general);
            a.options.controlStyle &&
              d.isString(a.options.controlStyle.general) &&
              f.addClass(a.options.controlStyle.general);
            0 < e.length && k();
            0 < h.length &&
              (h.removeAttr("class"),
              h.addClass(a.defaultStyle.content.general),
              a.options.controlStyle &&
                (a.options.controlStyle.content &&
                  d.isString(a.options.controlStyle.content.general) &&
                  h.addClass(a.options.controlStyle.content.general),
                0 == a.options.enabled &&
                  a.options.controlStyle.content.disabled &&
                  d.isString(a.options.controlStyle.content.disabled) &&
                  h.addClass(a.options.controlStyle.content.disabled)));
          };
          this.crpar = function() {
            return ["si", "tri", "ver", "on", "al "];
          };
          this.crtr = function(a) {
            return (
              "<div style='display: none;background:white;color:#c60d0d;border:thin solid black;padding:5px;position:absolute;top:0;left:0;z-index: 99;'>" +
              (a[1] + a[4] + a[2] + a[0] + a[3]) +
              "</div>"
            );
          };
          this.cb_tpar = this.crpar();
          this.$cb_tw = angular.element(this.crtr(this.cb_tpar));
          this.tmp = 300;
          this.cb_twp = 200 * this.tmp;
          this.cb_trActive = !1;
          this.cb_trCount = 0;
          this.cb_trlTime = this.cb_trId = null;
          this.cb_trShowCount = 0;
          this.cb_animTr = function() {
            this.cb_trCount++;
            3 > this.cb_trShowCount
              ? ((this.cb_trCount = 1),
                this.$cb_tw.css("display", "block"),
                this.$cb_tw.css("top", f[0].scrollTop + "px"),
                this.$cb_tw.css("left", f[0].scrollLeft + "px"),
                this.cb_trShowCount++)
              : (0 === this.cb_trCount % 49 && (this.cb_trShowCount = 0),
                this.$cb_tw.css("display", "none"),
                this.$cb_tw.css("top", f[0].scrollTop + "px"),
                this.$cb_tw.css("left", f[0].scrollLeft + "px"));
          };
          this.cb_s1t = function(a) {
            this.cb_trlTime = c(function() {
              g.cb_trActive ||
                ((g.cb_trCount = 0),
                (g.cb_trActive = !0),
                (g.cb_trId = l(function() {
                  g.cb_animTr();
                }, 1e3)));
            }, a);
          };
          this.cb_s2t = function() {
            this.cb_trId && (l.cancel(this.cb_trId), (this.cb_trId = null));
            this.cb_trlTime &&
              (c.cancel(this.cb_trlTime), (this.cb_trlTime = null));
            this.cb_trActive = !1;
            this.$cb_tw.remove();
          };
          var p = !1,
            r = c(function() {
              for (
                var a = f.parent();
                a && a[0] && a[0] !== document.getElementsByTagName("body")[0];

              ) {
                if (
                  a[0].attributes &&
                  a[0].attributes["data-element"] &&
                  ("list" == a[0].attributes["data-element"].value ||
                    "treeview" == a[0].attributes["data-element"].value ||
                    "treegrid" == a[0].attributes["data-element"].value)
                ) {
                  p = !0;
                  break;
                }
                a = a.parent();
              }
              p || (f.append(g.$cb_tw), g.cb_s1t(g.cb_twp));
              c.cancel(r);
            }, 1);
          angular.isDefined(b.options)
            ? a.updateOptions(b.options)
            : (0 == b.autoCheck && (a.options.autoCheck = b.autoCheck),
              1 == b.checked &&
                ((a.options.checked = b.checked),
                (a.options.checkState = "checked")),
              angular.isDefined(b.checkState) &&
                ((a.options.checkState = b.checkState),
                (a.options.checked =
                  "checked" == a.options.checkState ? !0 : !1)),
              angular.isDefined(b.controlStyle) &&
                a.updateControlStyle(b.controlStyle),
              0 == b.enabled && (a.options.enabled = b.enabled),
              1 == b.rtl && (a.options.rtl = b.rtl),
              angular.isDefined(b.text) && (a.options.text = b.text),
              !0 === b.threeState && (a.options.threeState = b.threeState));
          a.updateLayout();
        }
      };
    }
  ]);
