/**
 * Translation Resource.
 *
 */
function config($translateProvider) {

    $translateProvider
        .translations('en', {
            MY_EMS_NAME: 'MyEMS',
            LANGUAGE: 'Language',
            FULLSCREEN: 'Full Screen',
            EXITFULLSCREEN: 'Exit Full Screen',
            LOGOUT: 'Logout',
            COMMON: {
                EXECUTE: 'Execute',
                PLACEHOLDER: 'Please select or search...',
                SPACE: 'Space',
                TENANT: 'Tenant',
                STORE: 'Store',
                SHOPFLOOR: 'Shopfloor',
                EQUIPMENT: 'Equipment',
                COMBINED_EQUIPMENT: 'Combined Equipment',
                DATA_SOURCE: 'Data Source',
                SENSOR: 'Sensor',
                ENERGY_FLOW_DIAGRAM: 'Energy Flow Diagram',
                MENU: 'Menu',
                DATE: 'Date Range',
                TARIFF: {
                    TOPPEAK: 'Top-peak',
                    ONPEAK: 'On-peak',
                    OFFPEAK: 'Off-peak',
                    MIDPEAK: 'Mid-peak'
                }
            },
            FDD: {
                ID: 'ID',
                RULE: 'Rule',
                EMAIL_MESSAGE: 'Email Message',
                TEXT_MESSAGE: 'Text Message',
                WEB_MESSAGE: 'Web Message',
                WECHAT_MESSAGE: 'Wechat Message',

                ALARM_LIST: 'Alarm List',
                RULE_LIST: 'Rule List',
                ADD_RULE: 'Add Rule',
                EDIT_RULE: 'Edit Rule',
                FDD_CODE: 'FDD Code',
                CATEGORY: 'Category',
                PRIORITY: 'Priority',
                CHANNEL: 'Channel',
                IS_ENABLED: 'Is Enabled',
                LAST_RUN_DATETIME: 'Last Run Datetime',
                NEXT_RUN_DATETIME: 'Next Run Datetime',
                EXPRESSION: 'Expression',
                MESSAGE_TEMPLATE: 'Message Template',
                CLICK_EDIT_FOR_DETAILS: 'Click "Edit" for details',

                SMS_ALARM_LIST: 'SMS Alarm List',
                RECIPIENT_NAME: 'Recipient Name',
                RECIPIENT_MOBILE: 'Recipient Mobile',
                ALARM_MESSAGE: 'Body',
                ALARM_TIME: 'Created Time',
                SCHEDULE_TIME: 'Scheduled Time',
                ACKNOWLEDGE_CODE: 'Acknowledge Code',

                EMAIL_ALARM_LIST: 'Email Alarm List',
                EMAIL: 'Email',
                TOPIC: 'Subject',
                ATTACHMENT_NAME: 'Attachment',
                ACKNOWLEDGE_MESSAGE: 'Acknowledge Message',
                ACKNOWLEDGE: 'Acknowledge',
                WEB_ALARM_LIST: 'Web Alarm List',
                WECHAT_ALARM_LIST: 'WeChat Alarm List',
                WECHAT_ID: 'WeChat ID',
                MESSAGE_FORMAT: 'Message Format',
                ACKNOWLEDGE_ALARM: 'Acknowledge Alarm?',

            },
            MENU: {
                SETTINGS: {
                    SETTINGS: 'System Settings',
                    SPACE: 'Space Settings',
                    TENANT: 'Tenant Settings',
                    STORE: 'Store Settings',
                    SHOPFLOOR: 'Shopfloor Settings',
                    EQUIPMENT: 'Equipment Settings',
                    COMBINED_EQUIPMENT: 'Combined Equipment Settings',
                    METER: 'Meter Settings',
                    SENSOR: 'Sensor Settings',
                    GATEWAY: 'Gateway Settings',
                    DATASOURCE: 'Data Source Settings',
                    COSTCENTER: 'Cost Center Settings',
                    CATEGORY: 'Energy Categories',
                    ENERGY_FLOW_DIAGRAM: 'Energy Flow Diagram',
                    DISTRIBUTION_SYSTEM: 'Distribution System',
                    MENU: 'Menu Settings',
                    TARIFF: 'Tariff Settings',
                    EMAIL_SERVER: 'Email Server Settings',
                    CONTACT: 'Contacts',
                    KNOWLEDGEFILE: 'Knowledge Base Settings'
                },
                FDD: {
                    FDD: 'FDD',
                    RULE: 'Rule Settings',
                    MESSAGEALARM: 'SMS Alarm',
                    EMAILALARM: 'Email Alarm',
                    WEBALARM: 'Web Alarm',
                    WECHATALARM: 'WeChat Alarm',
                },
                USERSETTING: {
                    USERSETTING: 'Users & Privileges',
                    USER: 'User Settings',
                    PRIVILEGE: 'Privilege Settings'
                }
            },
            LOGIN: {
                USERLOGIN: 'Login',
                USERNAME: 'Username',
                PASSWORD: 'Password',
                LOGIN: 'Login',
                TITLE: 'Energy Management System',
            },
            SETTING: {
                KNOWLEDGEFILE: 'Knowledge File',
                ID: 'ID',
                ACTION: 'Action',
                ADD: 'Add',
                EDIT: 'Edit',
                BIND_PROPERTY: 'Bind Property',
                DELETE: 'Delete',
                SELECT: 'Select',
                RESET: 'Reset',
                SAVE: 'Save',
                CANCEL: 'Cancel',
                DOWNLOAD: 'Download',
                REFRESH: 'Refresh',
                RETURN: 'Return',
                YES: 'Yes',
                NO: 'No',
                ON: 'On',
                OFF: 'OFF',
                OK: 'OK',
                OPTIONAL: 'Optional',
                ADD_SPACE: 'Add Space',
                ADD_TENANT: 'Add Tenant',
                ADD_STORE: 'Add Store',
                ADD_METER: 'Add Meter',
                ADD_VIRTUAL_METER: 'Add Virtual Meter',
                ADD_OFFLINE_METER: 'Add Offline Meter',
                ADD_POINT: 'Add Point',
                ADD_COSTCENTER: 'Add Cost Center',
                ADD_TARIFF: 'Add Tariff',
                ADD_CATEGORY: 'Add Energy Category',
                ADD_ENERGY_ITEM: 'Add Energy Item',
                ADD_CONTACT: 'Add Contact',
                ADD_EMAIL_SERVER: 'Add Email Server',

                EDIT_SPACE: 'Edit Space',
                EDIT_TENANT: 'Edit Tenant',
                EDIT_STORE: 'Edit Store',
                EDIT_METER: 'Edit Meter',
                EDIT_VIRTUAL_METER: 'Edit Virtual Meter',
                EDIT_OFFLINE_METER: 'Edit Offline Meter',
                EDIT_POINT: 'Edit Point',
                EDIT_COSTCENTER: 'Edit Cost Center',
                EDIT_TARIFF: 'Edit Tariff',
                EDIT_CATEGORY: 'Edit Energy Category',
                EDIT_CONTACT: 'Edit Contact',
                EDIT_EMAIL_SERVER: 'Edit Email Server',

                REQUIRES_AUTHENTICATION: 'Requires Authentication',
                SELECT_DATE: 'Please Select Date',
                SELECT_SPACE: 'Please Select Space',
                SELECT_TENANT: 'Please Select Tenant',
                SELECT_STORE: 'Please Select Store',
                SELECT_TIMEZONE: 'Please Select Timezone',
                SELECT_CATEGORY: 'Please Select Category',
                SELECT_COSTCENTER: 'Please Select Cost Center',
                SELECT_METER: 'Please Select Meter',
                IS_INPUT_COUNTED: 'Is Energy Input Counted In',
                IS_OUTPUT_COUNTED: 'Is Energy Output Counted',
                BIND_METER: 'Point Meter',
                BIND_POINT: 'Point Point',
                BIND_SENSOR: 'Bind Sensor',
                BIND_TARIFF: 'Point Tariff',

                INPUT_NAME: 'Please Input Name',
                INPUT_AREA: 'Please Input Area',
                INPUT_UNIT: 'Please Input Unit',
                INPUT_CONTACT: 'Please Input Contact',
                INPUT_EXPRESSION: 'Please Input Expression',
                INPUT_KGCE: 'Please Input KGCE',
                INPUT_KGCO2E: 'Please Input KGCO2E',
                INPUT_HOST: 'Please Input Host',
                INPUT_PORT: 'Please Input Port',
                INPUT_USER_NAME: 'Please Input User Name',
                INPUT_FROM_ADDR: 'Please Input From Addr',
                INPUT_SERIAL_PORT: 'Please Input Serial Port',
                INPUT_BAUD_RATE: 'Please Input Baud Rate',

                EMAIL_SERVER: 'Email Server',
                INVALID_FORMAT: 'Invalid Format',
                INVALID_FROM_ADDR: 'Invalid From Addr',
                INVALID_BAUD_RATE: 'Invalid Baud Rate',
                NOT_NULLABLE: 'Please Input Required',
                METER: 'Meter',
                VIRTUAL_METER: 'Virtual Meter',
                OFFLINE_METER: 'Offline Meter',
                OFFLINE_METER_FILE: 'Offline Meter File',
                N_S_METER: ' Bound Meters',
                N_S_POINT: ' Bound Points',
                N_S_SENSOR: ' Bound Sensors',
                N_S_TARIFF: ' Bound Tariffs',
                TARIFF_LIST: 'Tariff List',
                POINT_LIST: 'Point List',
                SENSOR_LIST: 'Sensor List',
                METER_TYPE: 'Meter Type',
                METER_NAME: 'Meter Name',
                TRASH: 'Trash',
                DRAG_TO_BIND: 'Drag to left to bind',
                DRAG_TO_UNBIND: 'Drag to trash to  unbind',

                COST_FILE: 'Cost File',
                NAME: 'Name',
                AREA: 'Area',
                UNIT: 'Unit',
                CONTACT: 'Contact',
                TIMEZONE: 'Timezone',
                TARIFF: 'Tariff',

                COSTCENTER: 'Cost Center',
                CATEGORY: 'Energy Category',
                ENERGY_ITEM: 'Energy Item',
                STATUS: 'Status',
                UPLOAD_TIME: 'Uploaded Time',
                EXPRESSION: 'Expression',
                VARIABLE_NAME: 'Variable Name',
                POINT: 'Point',
                KGCE: 'Kilogram of Standard Coal',
                KGCO2E: 'Kilogram CO2 Emission',

                START_DATETIME: 'Start Datetime',
                START_TIME: 'Start Time',
                END_DATETIME: 'End Datetime',
                END_TIME: 'End Time',
                TARIFF_TYPE: 'Tariff Type',
                TARIFF_NAME: 'Tariff Name',
                PRICE: 'Price',
                BLOCK: 'Block',
                TIMEOFUSE: 'Time of use',
                PEAK_TYPE: 'Peak Type',
                START_AMOUNT: 'Start Amount',
                END_AMOUNT: 'End Amount',

                PORT: 'Port',
                SMS: 'SMS',
                SERIAL_PORT: 'Serial Port',
                BAUD_RATE: 'Baud Rate',
                FROM_ADDR: 'From Address',
                HOST: 'Host',
                USER_NAME: 'User Name',

                USER: 'User',

                SEARCH: 'Search...',

                RESTORE: 'Restore',
                RESTORE_SUCCESS: 'Restore Success',
                RESTORE_FAILED: 'Restore Failed',

                SELECT_MENU: 'Select Menu',
                CURRENT_SELECTED_MENU: 'Current Selected Menu',
                PARENT_MENU: 'Parent Menu',
                IS_HIDDEN: 'Is Hidden',
                CHILD_MENUS: 'Child Menus',
                EDIT_MENU: 'Edit Menu'
            },
            CONTACT: {
                EMAIL: 'Email',
                PHONE: 'Phone',
                DESCRIPTION: 'Description',
                INPUT_EMAIL: 'Please Input Email',
                INPUT_PHONE: 'Please Input Phone',
                INPUT_DESCRIPTION: 'Please Input Description',
                INVALID_EMAIL: 'Invalid Email Format(xxx@xxx.xx)',
            },
            COSTCENTER: {
                EXTERNAL_ID: 'External ID',
                INPUT_EXTERNAL_ID: 'Please Input External ID',
            },
            ENERGY_FLOW_DIAGRAM: {
                ADD_ENERGY_FLOW_DIAGRAM: 'Add Energy Flow Diagram',
                EDIT_ENERGY_FLOW_DIAGRAM: 'Eidt Energy Flow Diagram',
                SELECT_ENERGY_FLOW_DIAGRAM: 'Select Energy Flow Diagram',
                NODE: 'Node',
                N_S_NODE: ' Associated Node',
                ADD_NODE: 'Add Node',
                EDIT_NODE: 'Edit Node',
                NODE_ID: 'Node ID',
                NODE_NAME: 'Node Name',
                INPUT_NODE_NAME: 'Please Input Node Name',
                LINK: 'Link',
                N_S_LINK: ' Associated link',
                LINK_ID: 'Link ID',
                ADD_LINK: 'Add Link',
                EDIT_LINK: 'Edit Link',
                SOURCE_NODE: 'Source Node',
                TARGET_NODE: 'Target Node',
                METER: 'Meter',
                PREVIEW: 'Preview',
                N_S_PREVIEW: ' Preview',
            },
            GATEWAY: {
                GATEWAY: 'Gateway',
                TOKEN: 'Token',
                LAST_SEEN_DATETIME: 'Last Seen Datetime',
                SELECT_GATEWAY: 'Select Gateway',
                ADD_GATEWAY: 'Add Gateway',
                EDIT_GATEWAY: 'Edit Gateway',
            },
            DATA_SOURCE: {
                DATA_SOURCE: 'Data Source',
                ADD_DATA_SOURCE: 'Add Data Source',
                EDIT_DATA_SOURCE: 'Edit Data Source',
                SELECT_DATA_SOURCE: 'Please Select Data Source',
                PROTOCOL: 'Protocol',
                CONNECTION: 'Connection',
                LAST_SEEN_DATETIME: 'Last Seen Datetime',
                INPUT_PROTOCOL: 'Please Input Protocol',
                INPUT_CONNECTION: 'Please Input Connection',
            },
            POINT: {
                OBJECT_TYPE: 'Object Type',
                UNIT: 'Unit',
                HIGH_LIMIT: 'High Limit',
                LOW_LIMIT: 'Low Limit',
                RATIO: 'Ratio',
                IS_TREND: 'Is Trend',
                IS_VIRTUAL: 'Is Virtual',
                ADDRESS: 'Address(JSON)',
                DESCRIPTION: 'Description(Optionnal)',
                INPUT_HIGH_LIMIT: 'Please Input High Limit',
                INPUT_LOW_LIMIT: 'Please Input Low Limit',
                INPUT_RATIO: 'Please Input Ratio',
                INPUT_ADDRESS: 'Please Input Address',
                INPUT_DESCRIPTION: 'Please Input Description',
            },

            DISTRIBUTION_SYSTEM: {
                DISTRIBUTION_SYSTEM: 'Distribution System',
                ADD_DISTRIBUTION_SYSTEM: 'Add Distribution System',
                EDIT_DISTRIBUTION_SYSTEM: 'Eidt Distribution System',
                SELECT_DISTRIBUTION_SYSTEM: 'Select Distribution System',
                SVG: 'SVG',
                INPUT_SVG: 'Please Input SVG',
                DESCRIPTION: 'Description',
                DISTRIBUTION_CIRCUIT: 'Distribution Circuit',
                N_S_DISTRIBUTION_CIRCUIT: ' Associated Distribution Circuit',
                ADD_DISTRIBUTION_CIRCUIT: 'Add Distribution Circuit',
                EDIT_DISTRIBUTION_CIRCUIT: 'Eidt Distribution Circuit',
                SELECT_DISTRIBUTION_CIRCUIT: 'Select Distribution Circuit',
                DISTRIBUTION_CIRCUIT_ID: 'ID',
                DISTRIBUTION_CIRCUIT_NAME: 'Name',
                INPUT_DISTRIBUTION_CIRCUIT_NAME: 'Please Input Name',
                DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: 'Distribution Room',
                INPUT_DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: 'Please Input Distribution Room',
                DISTRIBUTION_CIRCUIT_SWITCHGEAR: 'Switchgear',
                INPUT_DISTRIBUTION_CIRCUIT_SWITCHGEAR: 'Please Input Switchgear',
                DISTRIBUTION_CIRCUIT_PEAK_LOAD: 'Peak Load (KW)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_LOAD: 'Please Input Peak Load(KW)',
                DISTRIBUTION_CIRCUIT_PEAK_CURRENT: 'Peak Current (A)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_CURRENT: 'Please Input Peak Current (A)',
                DISTRIBUTION_CIRCUIT_CUSTOMERS: 'Customers',
                INPUT_DISTRIBUTION_CIRCUIT_CUSTOMERS: 'Please Input Customers',
                DISTRIBUTION_CIRCUIT_METERS: 'Meters',
                INPUT_DISTRIBUTION_CIRCUIT_METERS: 'Please Input Meters',
                PREVIEW: 'Preview',
                N_S_PREVIEW: ' Preview',
            },
            EQUIPMENT: {
                ADD_EQUIPMENT: 'Add Equipment',
                EDIT_EQUIPMENT: 'Edit Equipment',
                SELECT_EQUIPMENT: 'Please Select Equipment',
                COST_CENTER: 'Cost Center',
                SELECT_COST_CENTER: 'Please Select Cost Center',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                INPUT_METER: 'Input Meter',
                OUTPUT_METER: 'Output Meter',
                PARAMETER: 'Parameter',
                BIND_PARAMETER: 'Bind Parameter',
                ADD_PARAMETER: 'Add Parameter',
                EDIT_PARAMETER: 'Edit Parameter',
                N_S_PARAMETER: 'Parameters',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: 'Name',
                INPUT_PARAMETER_NAME: 'Please Input Parameter Name',
                PARAMETER_TYPE: 'Type',
                SELECT_PARAMETER_TYPE: 'Select Parameter Type',
                CONSTANT: 'CONSTANT',
                POINT: 'POINT',
                SELECT_POINT: 'Select Point',
                FRACTION: 'FRACTION',
                PARAMETER_CONSTANT: 'Constant',
                PARAMETER_POINT: 'Point',
                PARAMETER_NUMERATOR_METER: 'Numerator Meter',
                PARAMETER_DENOMINATOR_METER: 'Denominator Meter',
            },
            COMBINED_EQUIPMENT: {
                ADD_COMBINED_EQUIPMENT: 'Add Combined Equipment',
                EDIT_COMBINED_EQUIPMENT: 'Edit Combined Equipment',
                SELECT_COMBINED_EQUIPMENT: 'Please Select Combined Equipment',
                COST_CENTER: 'Cost Center',
                SELECT_COST_CENTER: 'Please Select Cost Center',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                BIND_EQUIPMENT: 'Bind Equipment',
                N_S_EQUIPMENT: 'Bound Equipments',
                EQUIPMENT_LIST: 'Equipment List',
                INPUT_METER: 'Input Meter',
                OUTPUT_METER: 'Output Meter',
                PARAMETER: 'Parameter',
                BIND_PARAMETER: 'Bind Parameter',
                ADD_PARAMETER: 'Add Parameter',
                EDIT_PARAMETER: 'Edit Parameter',
                N_S_PARAMETER: 'Parameters',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: 'Name',
                INPUT_PARAMETER_NAME: 'Please Input Parameter Name',
                PARAMETER_TYPE: 'Type',
                SELECT_PARAMETER_TYPE: 'Select Parameter Type',
                CONSTANT: 'CONSTANT',
                POINT: 'POINT',
                SELECT_POINT: 'Select Point',
                FRACTION: 'FRACTION',
                PARAMETER_CONSTANT: 'Constant',
                PARAMETER_POINT: 'Point',
                PARAMETER_NUMERATOR_METER: 'Numerator Meter',
                PARAMETER_DENOMINATOR_METER: 'Denominator Meter',
            },
            SPACE: {
                PARENT_SPACE: 'Parent Space',
                AREA: 'Area',
                INPUT_AREA: 'Please Input Area',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                CURRENT_SELECTED_SPACE: 'Current Selected Space',
                CHILD_SPACES: 'Child Spaces',
                BIND_EQUIPMENT: 'Bind Equipment',
                N_S_EQUIPMENT: 'Bound Equipments',
                EQUIPMENT_LIST: 'Equipment List',
                BIND_COMBINED_EQUIPMENT: 'Bind Combined Equipment',
                N_S_COMBINED_EQUIPMENT: 'Bound Combined Equipments',
                COMBINED_EQUIPMENT_LIST: 'Combined Equipment List',
                BIND_STORE: 'Bind Store',
                N_S_STORE: 'Bound Stores',
                STORE_LIST: 'Store List',
                BIND_TENANT: 'Bind Tenant',
                N_S_TENANT: 'Bound Tenants',
                TENANT_LIST: 'Tenant List',
            },
            STORE: {
                ADDRESS: 'Address',
                LATITUDE: 'Latitude',
                LONGITUDE: 'Longitude',
                TYPE: 'Store Type',
                DESCRIPTION: 'Description',
                INPUT_ADDRESS: 'Please Input Address',
                INPUT_LATITUDE: 'Please Input Latitude',
                INPUT_LONGITUDE: 'Please Input Longitude',
                INPUT_DESCRIPTION: 'Please Input Description',
            },
            TENANT: {
                BUILDINGS: 'Buildings',
                FLOORS: 'Floors',
                ROOMS: 'Rooms',
                TYPE: 'Tenant Type',
                IS_KEY_TENANT: 'Is Key Tenant',
                LEASE_NUMBER: 'Lease Number',
                LEASE_START_DATETIME: 'Lease Start Datetime',
                LEASE_END_DATETIME: 'Lease End Datetime',
                IS_IN_LEASE: 'Is In Lease',
                DESCRIPTION: 'Description',
                INPUT_BUILDINGS: 'Please Input Buildings',
                INPUT_FLOORS: 'Please Input Floors',
                INPUT_ROOMS: 'Rooms',
                INPUT_LEASE_NUMBER: 'Please Input Lease Number',
                INPUT_DESCRIPTION: 'Please Input Description',
            },
            SHOPFLOOR: {
                ADD_SHOPFLOOR: 'Add Shopfloor',
                EDIT_SHOPFLOOR: 'Edit Shopfloor',
                SELECT_SHOPFLOOR: 'Select Shopfloor',
                AREA: 'Area',
                INPUT_AREA: 'Please Input Area',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                BIND_EQUIPMENT: 'Bind Equipment',
                N_S_EQUIPMENT: 'Bound Equipments',
                EQUIPMENT_LIST: 'Equipment List',
            },
            METER: {
                HOURLY_LOW_LIMIT: 'Hourly Low Limit (Inclusive)',
                INPUT_HOURLY_LOW_LIMIT: 'Please Input Hourly Low Limit',
                HOURLY_HIGH_LIMIT: 'Hourly High Limit (Inclusive)',
                INPUT_HOURLY_HIGH_LIMIT: 'Please Input Hourly High Limit',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                MASTER_METER: 'Master Meter',
                SELECT_MASTER_METER: 'Select Master Meter',
                TREE_VIEW: 'Tree View',
                CHILD_METERS: 'Child Meters',
            },
            SENSOR: {
                ADD_SENSOR: 'Add Sensor',
                EDIT_SENSOR: 'Edit Sensor',
                DELETE_SENSOR: 'Delete Sensor',
                DESCRIPTION: 'Description',
                INPUT_DESCRIPTION: 'Please Input Description',
                SELECT_SENSOR: 'Select Sensor',
            },
            USER: {
                USER_LIST: 'User List',
                PRIVILEGE_LIST: 'Privilege List',
                ADD_USER: 'Add User',
                EDIT_USER: 'Edit User',
                PRIVILEGE: 'Privilege',
                ADD_PRIVILEGE: 'Add Privilege',
                EDIT_PRIVILEGE: 'Edit Privilege',
                IS_ADMIN: 'Is Admin',
                DISPLAY_NAME: 'Display Name',
                USERNAME: 'User Name',
                PASSWORD: 'Password',
                RESET_PASSWORD: 'Reset Password',
                CHANGE_PASSWORD: 'Change Password',
                OLD_PASSWORD: 'Old Password',
                NEW_PASSWORD: 'New Password',
                CONFIRM_PASSWORD: 'Confirm Password',
                INPUT_PASSWORD: 'Please Input Password',
                DIFF_PASSWORD: 'Password Not Match',
                EMAIL: 'Email',
                INPUT_EMAIL: 'Please Input Email',
                INVALID_EMAIL: 'Invalid Email Format(xxx@xxx.xx)',
                ACCOUNT_EXPIRATION_DATETIME: 'Account Expiration Datetime',
                PASSWORD_EXPIRATION_DATETIME: 'Password Expiration Datetime',
            },
            KNOWLEDGEFILE: {
                KNOWLEDGE_FILE_LIST: 'Knowledge File List',
                UPLOAD_USER: 'Upload User',
                UPLOAD_TIME: 'Upload Time',
                DELETE: 'Delete',
            },
            TOASTER: {
                SUCCESS_TITLE: 'Success',
                LOGIN_SUCCESS: 'Login Success',
                LOGIN_FAILURE: 'Login Failure',
                LOGOUT_SUCCESS: 'Logout Success',
                LOGOUT_FAILURE: 'Logout Failure',

                SUCCESS_ADD_BODY: 'Add {{template}} Success',
                SUCCESS_UPDATE_BODY: 'Update {{template}} Success',
                SUCCESS_DELETE_BODY: 'Delete {{template}} Success',
                ERROR_ADD_BODY: 'Add {{template}} Failure',
                ERROR_UPDATE_BODY: 'Update {{template}} Failure',
                ERROR_DELETE_BODY: 'Delete {{template}} Failure',

                USER_PASSWORD: 'User Password',
                BIND_METER_SUCCESS: 'Bind Meter Success',
                UNBIND_METER_SUCCESS: 'Unbind Meter Success',
                BIND_TARIFF_SUCCESS: 'Bind Tariff Success',
                UNBIND_TARIFF_SUCCESS: 'Unbind Tariff Success',
                BIND_POINT_SUCCESS: 'Bind Point Success',
                UNBIND_POINT_SUCCESS: 'Unbind Point Success',
                BIND_SENSOR_SUCCESS: 'Bind Sensor Success',
                UNBIND_SENSOR_SUCCESS: 'Unbind Sensor Success',
                BIND_EQUIPMENT_SUCCESS: 'Bind Equipment Success',
                UNBIND_EQUIPMENT_SUCCESS: 'Unbind Equipment Success',
                BIND_COMBINED_EQUIPMENT_SUCCESS: 'Bind Combined Equipment Success',
                UNBIND_COMBINED_EQUIPMENT_SUCCESS: 'Unbind Combined Equipment Success',
                BIND_TENANT_SUCCESS: 'Bind Tenant Success',
                UNBIND_TENANT_SUCCESS: 'Unbind Tenant Success',
                BIND_STORE_SUCCESS: 'Bind Store Success',
                UNBIND_STORE_SUCCESS: 'Unbind Store Success',
            },
            SWEET: {
                TITLE: 'Please confirm whether to delete?',
                TEXT: 'Deleting this bar will also delete all related data!',
                CONFIRM_BUTTON_TEXT: 'Confirm delete',
                CANCEL_BUTTON_TEXT: 'Cancel',
            },
            API: {
                ADMINISTRATOR_SESSION_NOT_FOUND: 'Administrator Session Not Found',
                ADMINISTRATOR_SESSION_TIMEOUT: 'Administrator Session Timeout',
                ADVANCED_REPORT_NOT_FOUND: 'Advanced Report Not Found',
                BAD_REQUEST: 'Bad Request',
                CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER: 'Cannot Set Existing Submeter As Master Meter',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS: 'Combined Equipment Equipment Relation Exists',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND: 'Combined Equipment Equipment Relation Not Found',
                COMBINED_EQUIPMENT_METER_RELATION_EXISTS: 'Combined Equipment Meter Relation Exists',
                COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND: 'Combined Equipment Meter Relation Not Found',
                COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Name Is Already In Use',
                COMBINED_EQUIPMENT_NOT_FOUND: 'Combined Equipment Not Found',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Combined Equipment Offline Meter Relation Exists',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Combined Equipment Offline Meter Relation Not Found',
                COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Parameter Name Is Already In Use',
                COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Combined Equipment Parameter Not Found Or Not Match',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Combined Equipment Virtual Meter Relation Exists',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Combined Equipment Virtual Meter Relation Not Found',
                CONTACT_NAME_IS_ALREADY_IN_USE: 'Contact Name Is Already In Use',
                CONTACT_NOT_FOUND: 'Contact Not Found',
                COST_CENTER_EXTERNAL_ID_EXISTS: 'Cost Center External ID Exists',
                COST_CENTER_NAME_EXISTS: 'Cost Center Name Exists',
                COST_CENTER_NOT_FOUND: 'Cost Center Not Found',
                COST_FILE_NOT_FOUND: 'Cost File Not Found',
                DATA_SOURCE_NAME_IS_ALREADY_IN_USE: 'Data Source Name Is Already In Use',
                DATA_SOURCE_NOT_FOUND: 'Data Source Not Found',
                DATABASE_ERROR: 'Database Error',
                DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE: 'Distribution Circuit Name Is Already In Use',
                DISTRIBUTION_CIRCUIT_NOT_FOUND: 'Distribution Circuit Not Found',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS: 'Distribution Circuit Point Relation Exists',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND: 'Distribution Circuit Point Relation Not Found',
                DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE: 'Distribution System Name Is Already In Use',
                DISTRIBUTION_SYSTEM_NOT_FOUND: 'Distribution System Not Found',
                EMAIL_IS_ALREADY_IN_USE: 'Email Is Already In Use',
                EMAIL_MESSAGE_NOT_FOUND: 'Email Message Not Found',
                EMAIL_SERVER_HOST_IS_ALREADY_IN_USE: 'Email Server Host Is Already In Use',
                EMAIL_SERVER_NOT_FOUND: 'Email Server Not Found',
                EMPTY_VARIABLES_ARRAY: 'Empty Variables Array',
                ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE: 'Energy Category Name Is Already In Use',
                ENERGY_CATEGORY_NOT_FOUND: 'Energy Category Not Found',
                ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS: 'Energy Category Used In Energy Items',
                ENERGY_CATEGORY_USED_IN_METER: 'Energy Category Used In Meter',
                ENERGY_CATEGORY_USED_IN_OFFLINE_METER: 'Energy Category Used In Offline Meter',
                ENERGY_CATEGORY_USED_IN_TARIFFS: 'Energy Category Used In Tariffs',
                ENERGY_CATEGORY_USED_IN_VIRTUAL_METER: 'Energy Category Used In Virtual Meter',
                ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE: 'Energy Flow Diagram Link Is Already In Use',
                ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Link Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Node Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Node Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NOT_FOUND: 'Energy Flow Diagram Not Found',
                ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Does Not Belong To Energy Category',
                ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Is Not Belong To Energy Category',
                ENERGY_ITEM_NAME_IS_ALREADY_IN_USE: 'Energy Item Name Is Already In Use',
                ENERGY_ITEM_NOT_FOUND: 'Energy Item Not Found',
                ENERGY_ITEM_USED_IN_METER: 'Energy Item Used In Meter',
                ENERGY_ITEM_USED_IN_OFFLINE_METER: 'Energy Item Used In Offline Meter',
                ENERGY_ITEM_USED_IN_VIRTUAL_METER: 'Energy Item Used In Virtual Meter',
                EQUIPMENT_METER_RELATION_EXISTS: 'Equipment Meter Relation Exists',
                EQUIPMENT_METER_RELATION_NOT_FOUND: 'Equipment Meter Relation Not Found',
                EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Equipment Name Is Already In Use',
                EQUIPMENT_NOT_FOUND: 'Equipment Not Found',
                EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Equipment Offline Meter Relation Exists',
                EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Equipment Offline Meter Relation Not Found',
                EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Equipment Parameter Name Is Already In Use',
                EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Equipment Parameter Not Found Or Not Match',
                EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Equipment Virtual Meter Relation Exists',
                EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Equipment Virtual Meter Relation Not Found',
                ERROR: 'Error',
                EXCEPTION: 'Exception',
                FAILED_TO_RESTORE_COST_FILE: 'Failed To Restore Cost File',
                FAILED_TO_RESTORE_KNOWLEDGE_FILE: 'Failed To Restore Knowledge File',
                FAILED_TO_RESTORE_OFFLINE_METER_FILE: 'Failed To Restore Offline Meter File',
                FAILED_TO_UPLOAD_COST_FILE: 'Failed To Upload Cost File',
                FAILED_TO_UPLOAD_KNOWLEDGE_FILE: 'Failed To Upload Knowledge File',
                FAILED_TO_UPLOAD_OFFLINE_METER_FILE: 'Failed To Upload Offline Meter File',
                GATEWAY_NAME_IS_ALREADY_IN_USE: 'Gateway Name Is Already In Use',
                GATEWAY_NOT_FOUND: 'Gateway Not Found',
                INVALID_ADDRESS: 'Invalid Address',
                INVALID_ADDRESS_VALUE: 'Invalid Address Value',
                INVALID_ADVANCED_REPORT_ID: 'Invalid Advanced Report ID',
                INVALID_AREA_VALUE: 'Invalid Area Value',
                INVALID_BASE_PERIOD_END_DATETIME: 'Invalid Base Period End Datetime',
                INVALID_BASE_PERIOD_START_DATETIME: 'Invalid Base Period Start Datetime',
                INVALID_BAUD_RATE: 'Invalid Baud Rate',
                INVALID_BUILDINGS_VALUE: 'Invalid Buildings Value',
                INVALID_CATEGORY: 'Invalid Category',
                INVALID_CHANNEL: 'Invalid Channel',
                INVALID_COMBINED_EQUIPMENT_ID: 'Invalid Combined Equipment ID',
                INVALID_COMBINED_EQUIPMENT_NAME: 'Invalid Combined Equipment Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_ID: 'Invalid Combined Equipment Parameter ID',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME: 'Invalid Combined Equipment Parameter Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE: 'Invalid Combined Equipment Parameter Type',
                INVALID_CONNECTION: 'Invalid Connection',
                INVALID_CONSTANT_VALUE: 'Invalid Constant Value',
                INVALID_CONTACT_ID: 'Invalid Contact ID',
                INVALID_CONTACT_NAME: 'Invalid Contact Name',
                INVALID_COST_CENTER_ID: 'Invalid Cost Center ID',
                INVALID_COST_FILE_ID: 'Invalid Cost File ID',
                INVALID_DATA_SOURCE_ID: 'Invalid Data Source ID',
                INVALID_DATA_SOURCE_NAME: 'Invalid Data Source Name',
                INVALID_DATA_SOURCE_PROTOCOL: 'Invalid Data Source Protocol',
                INVALID_DENOMINATOR_METER_UUID: 'Invalid Denominator Meter UUID',
                INVALID_DISPLAY_NAME: 'Invalid Display Name',
                INVALID_DISTRIBUTION_CIRCUIT_ID: 'Invalid Distribution Circuit ID',
                INVALID_DISTRIBUTION_CIRCUIT_NAME: 'Invalid Distribution Circuit Name',
                INVALID_DISTRIBUTION_ROOM: 'Invalid Distribution Room',
                INVALID_DISTRIBUTION_SYSTEM_ID: 'Invalid Distribution System ID',
                INVALID_DISTRIBUTION_SYSTEM_NAME: 'Invalid Distribution System Name',
                INVALID_EMAIL: 'Invalid Email',
                INVALID_EMAIL_MESSAGE_ID: 'Invalid Email Message ID',
                INVALID_EMAIL_SERVER_HOST: 'Invalid Email Server Host',
                INVALID_EMAIL_SERVER_ID: 'Invalid Email Server ID',
                INVALID_END_DATE_FORMAT: 'Invalid End Date Format',
                INVALID_END_DATETIME: 'Invalid End Datetime',
                INVALID_ENERGY_CATEGORY_ID: 'Invalid Energy Category ID',
                INVALID_ENERGY_CATEGORY_NAME: 'Invalid Energy Category Name',
                INVALID_ENERGY_FLOW_DIAGRAM_ID: 'Invalid Energy Flow Diagram ID',
                INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID: 'Invalid Energy Flow Diagram Link ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NAME: 'Invalid Energy Flow Diagram Name',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID: 'Invalid Energy Flow Diagram Node ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME: 'Invalid Energy Flow Diagram Node Name',
                INVALID_ENERGY_ITEM_ID: 'Invalid Energy Item ID',
                INVALID_ENERGY_ITEM_NAME: 'Invalid Energy Item Name',
                INVALID_EQUATION_IN_EXPRESSION: 'Invalid Equation In Expression',
                INVALID_EQUIPMENT_ID: 'Invalid Equipment ID',
                INVALID_EQUIPMENT_NAME: 'Invalid Equipment Name',
                INVALID_EQUIPMENT_PARAMETER_ID: 'Invalid Equipment Parameter ID',
                INVALID_EQUIPMENT_PARAMETER_NAME: 'Invalid Equipment Parameter Name',
                INVALID_EQUIPMENT_PARAMETER_TYPE: 'Invalid Equipment Parameter Type',
                INVALID_EXPRESSION: 'Invalid Expression',
                INVALID_EXPRESSION_OBJECT: 'Invalid Expression Object',
                INVALID_FDD_CODE: 'Invalid Fdd Code',
                INVALID_FLOORS_VALUE: 'Invalid Floors Value',
                INVALID_FROM_ADDR: 'Invalid From Address',
                INVALID_GATEWAY_ID: 'Invalid Gateway ID',
                INVALID_GATEWAY_NAME: 'Invalid Gateway Name',
                INVALID_HOURLY_HIGH_LIMIT_VALUE: 'Invalid Hourly High Limit Value',
                INVALID_HOURLY_LOW_LIMIT_VALUE: 'Invalid Hourly Low Limit Value',
                INVALID_IS_ADMIN_VALUE: 'Invalid Is Admin Value',
                INVALID_IS_COUNTED_VALUE: 'Invalid Is Counted Value',
                INVALID_IS_ENABLED: 'Invalid Is Enabled',
                INVALID_IS_HIDDEN: 'Invalid Is Hidden',
                INVALID_IS_IN_LEASE_VALUE: 'Invalid Is In Lease Value',
                INVALID_IS_INPUT_COUNTED_VALUE: 'Invalid Is Input Counted Value',
                INVALID_IS_KEY_TENANT_VALUE: 'Invalid Is Key Tenant Value',
                INVALID_IS_OUTPUT_COUNTED_VALUE: 'Invalid Is Output Counted Value',
                INVALID_IS_OUTPUT_VALUE: 'Invalid Is Output Value',
                INVALID_IS_TREND_VALUE: 'Invalid Is Trend Value',
                INVALID_IS_VIRTUAL_VALUE: 'Invalid Is Virtual Value',
                INVALID_KGCE: 'Invalid KGCE',
                INVALID_KGCO2E: 'Invalid KGCO2E',
                INVALID_KNOWLEDGE_FILE_ID: 'Invalid Knowledge File ID',
                INVALID_LATITUDE_VALUE: 'Invalid Latitude Value',
                INVALID_LEASE_NUMBER_VALUE: 'Invalid Lease Number Value',
                INVALID_LONGITUDE_VALUE: 'Invalid Longitude Value',
                INVALID_LOW_LIMIT_VALUE: 'Invalid Low Limit Value',
                INVALID_MASTER_METER_ID: 'Invalid Master Meter ID',
                INVALID_MENU_ID: 'Invalid Menu ID',
                INVALID_MESSAGE_TEMPLATE: 'Invalid Message Template',
                INVALID_METER_ID: 'Invalid Meter ID',
                INVALID_METER_NAME: 'Invalid Meter Name',
                INVALID_METER_UUID: 'Invalid Meter UUID',
                INVALID_NAME_VALUE: 'Invalid Name Value',
                INVALID_NEW_PASSWORD: 'Invalid New Password',
                INVALID_NOTIFICATION_ID: 'Invalid Notification ID',
                INVALID_NUMERATOR_METER_UUID: 'Invalid Numerator Meter UUID',
                INVALID_OBJECT_TYPE: 'Invalid Object Type',
                INVALID_OFFLINE_METER_FILE_ID: 'Invalid Offline Meter File ID',
                INVALID_OFFLINE_METER_ID: 'Invalid Offline Meter ID',
                INVALID_OFFLINE_METER_NAME: 'Invalid Offline Meter Name',
                INVALID_OLD_PASSWORD: 'Invalid Old Password',
                INVALID_PARENT_SPACE_ID: 'Invalid Parent Space ID',
                INVALID_PASSWORD: 'Invalid Password',
                INVALID_PEAK_CURRENT: 'Invalid Peak Current',
                INVALID_PEAK_LOAD: 'Invalid Peak Load',
                INVALID_PERIOD_TYPE: 'Invalid Period Type',
                INVALID_POINT_ID: 'Invalid Point ID',
                INVALID_POINT_NAME: 'Invalid Point Name',
                INVALID_PORT: 'Invalid Port',
                INVALID_PRIORITY: 'Invalid Priority',
                INVALID_PRIVILEGE: 'Invalid Privilege',
                INVALID_PRIVILEGE_DATA: 'Invalid Privilege Data',
                INVALID_PRIVILEGE_ID: 'Invalid Privilege ID',
                INVALID_PRIVILEGE_NAME: 'Invalid Privilege Name',
                INVALID_RATIO_VALUE: 'Invalid Ratio Value',
                INVALID_REPLY: 'Invalid Reply',
                INVALID_REPORTING_PERIOD_END_DATETIME: 'Invalid Reporting Period End Datetime',
                INVALID_REPORTING_PERIOD_START_DATETIME: 'Invalid Reporting Period Start Datetime',
                INVALID_REQUIRES_AUTHENTICATION: 'Invalid Requires Authentication',
                INVALID_ROOMS_VALUE: 'Invalid Rooms Value',
                INVALID_RULE_ID: 'Invalid Rule ID',
                INVALID_RULE_NAME: 'Invalid Rule Name',
                INVALID_SENSOR_ID: 'Invalid Sensor ID',
                INVALID_SENSOR_NAME: 'Invalid Sensor Name',
                INVALID_SERIAL_PORT: 'Invalid Serial Port',
                INVALID_SESSION_PLEASE_RE_LOGIN: 'Invalid Session Please Re-Login',
                INVALID_SHOPFLOOR_ID: 'Invalid Shopfloor ID',
                INVALID_SHOPFLOOR_NAME: 'Invalid Shopfloor Name',
                INVALID_SOURCE_NODE_ID: 'Invalid Source Node ID',
                INVALID_SPACE_ID: 'Invalid Space ID',
                INVALID_SPACE_NAME: 'Invalid Space Name',
                INVALID_START_DATE_FORMAT: 'Invalid Start Date Format',
                INVALID_START_DATETIME: 'Invalid Start Datetime',
                INVALID_STATUS: 'Invalid Status',
                INVALID_STORE_ID: 'Invalid Store ID',
                INVALID_STORE_NAME: 'Invalid Store Name',
                INVALID_STORE_TYPE_DESCRIPTION: 'Invalid Store Type Description',
                INVALID_STORE_TYPE_ID: 'Invalid Store Type ID',
                INVALID_STORE_TYPE_NAME: 'Invalid Store Type Name',
                INVALID_STORE_TYPE_SIMPLIFIED_CODE: 'Invalid Store Type Simplified Code',
                INVALID_SVG: 'Invalid SVG',
                INVALID_SWITCHGEAR: 'Invalid Switchgear',
                INVALID_TARGET_NODE_ID: 'Invalid Target Node ID',
                INVALID_TARIFF_BLOCK_PRICING: 'Invalid Tariff Block Pricing',
                INVALID_TARIFF_ID: 'Invalid Tariff ID',
                INVALID_TARIFF_TIME_OF_USE_PRICING: 'Invalid Tariff Time Of Use Pricing',
                INVALID_TARIFF_TYPE: 'Invalid Tariff Type',
                INVALID_TENANT_ID: 'Invalid Tenant ID',
                INVALID_TENANT_NAME: 'Invalid Tenant Name',
                INVALID_TENANT_TYPE_DESCRIPTION: 'Invalid Tenant Type Description',
                INVALID_TENANT_TYPE_ID: 'Invalid Tenant Type ID',
                INVALID_TENANT_TYPE_NAME: 'Invalid Tenant Type Name',
                INVALID_TENANT_TYPE_SIMPLIFIED_CODE: 'Invalid Tenant Type Simplified Code',
                INVALID_TEXT_MESSAGE_ID: 'Invalid Text Message ID',
                INVALID_TIMEZONE_ID: 'Invalid Timezone ID',
                INVALID_TOKEN: 'Invalid Token',
                INVALID_UNIT_OF_MEASURE: 'Invalid Unit Of Measure',
                INVALID_UNIT_OF_PRICE: 'Invalid Unit Of Price',
                INVALID_UNITS: 'Invalid Units',
                INVALID_USER_ID: 'Invalid User ID',
                INVALID_USER_NAME: 'Invalid User Name',
                INVALID_USER_NAME_OR_EMAIL: 'Invalid User Name Or Email',
                INVALID_USER_PHONE: 'Invalid User Phone',
                INVALID_USER_PLEASE_RE_LOGIN: 'Invalid User Please Re-Login',
                INVALID_USER_UUID: 'Invalid User UUID',
                INVALID_VARIABLE_METER_ID: 'Invalid Variable Meter ID',
                INVALID_VARIABLE_METER_TYPE: 'Invalid Variable Meter Type',
                INVALID_VARIABLE_NAME: 'Invalid Variable Name',
                INVALID_VIRTUAL_METER_ID: 'Invalid Virtual Meter ID',
                INVALID_VIRTUAL_METER_NAME: 'Invalid Virtual Meter Name',
                INVALID_WEB_MESSAGE_ID: 'Invalid Web Message ID',
                INVALID_WECHAT_MESSAGE_ID: 'Invalid Wechat Message ID',
                KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK: 'Knowledge File Cannot be Removed from Disk',
                KNOWLEDGE_FILE_NOT_FOUND: 'Knowledge File Not Found',
                MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY: 'Master Meter Does Not Belong To Same Energy Category',
                MASTER_METER_NOT_FOUND: 'Master Meter Not Found',
                MENU_NOT_FOUND: 'Menu Not Found',
                METER_NAME_IS_ALREADY_IN_USE: 'Meter Name Is Already In Use',
                METER_NOT_FOUND: 'Meter Not Found',
                METER_OF_VARIABLE_NOT_FOUND: 'Meter Of Variable Not Found',
                METER_POINT_RELATION_EXISTS: 'Meter Point Relation Exists',
                METER_POINT_RELATION_NOT_FOUND: 'Meter Point Relation Not Found',
                NOT_FOUND: 'Not Found',
                NOTIFICATION_NOT_FOUND: 'Notification Not Found',
                OFFLINE_METER_FILE_NOT_FOUND: 'Offline Meter File Not Found',
                OFFLINE_METER_NAME_IS_ALREADY_IN_USE: 'Offline Meter Name Is Already In Use',
                OFFLINE_METER_NOT_FOUND: 'Offline Meter Not Found',
                OFFLINE_METER_OF_VARIABLE_NOT_FOUND: 'Offline Meter Of Variable Not Found',
                PARENT_SPACE_NOT_FOUND: 'Parent Space Not Found',
                POINT_NAME_IS_ALREADY_IN_USE: 'Point Name Is Already In Use',
                POINT_NOT_FOUND: 'Point Not Found',
                PRIVILEGE_NAME_IS_ALREADY_IN_USE: 'Privilege Name Is Already In Use',
                PRIVILEGE_NOT_FOUND: 'Privilege Not Found',
                RULE_NAME_IS_ALREADY_IN_USE: 'Rule Name Is Already In Use',
                RULE_NOT_FOUND: 'Rule Not Found',
                SENSOR_NAME_IS_ALREADY_IN_USE: 'Sensor Name Is Already In Use',
                SENSOR_NOT_FOUND: 'Sensor Not Found',
                SENSOR_POINT_RELATION_EXISTS: 'Sensor Point Relation Exists',
                SENSOR_POINT_RELATION_NOT_FOUND: 'Sensor Point Relation Not Found',
                SHOPFLOOR_EQUIPMENT_RELATION_EXISTS: 'Shopfloor Equipment Relation Exists',
                SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND: 'Shopfloor Equipment Relation Not Found',
                SHOPFLOOR_METER_RELATION_EXISTS: 'Shopfloor Meter Relation Exists',
                SHOPFLOOR_METER_RELATION_NOT_FOUND: 'Shopfloor Meter Relation Not Found',
                SHOPFLOOR_NAME_IS_ALREADY_IN_USE: 'Shopfloor Name Is Already In Use',
                SHOPFLOOR_NOT_FOUND: 'Shopfloor Not Found',
                SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS: 'Shopfloor Offline Meter Relation Exists',
                SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND: 'Shopfloor Offline Meter Relation Not Found',
                SHOPFLOOR_POINT_RELATION_EXISTS: 'Shopfloor Point Relation Exists',
                SHOPFLOOR_POINT_RELATION_NOT_FOUND: 'Shopfloor Point Relation Not Found',
                SHOPFLOOR_SENSOR_RELATION_EXISTS: 'Shopfloor Sensor Relation Exists',
                SHOPFLOOR_SENSOR_RELATION_NOT_FOUND: 'Shopfloor Sensor Relation Not Found',
                SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS: 'Shopfloor Virtual Meter Relation Exists',
                SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND: 'Shopfloor Virtual Meter Relation Not Found',
                SOURCE_NODE_NOT_FOUND: 'Source Node Not Found',
                SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS: 'Space Combined Equipment Relation Exists',
                SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND: 'Space Combined Equipment Relation Not Found',
                SPACE_EQUIPMENT_RELATION_EXISTS: 'Space Equipment Relation Exists',
                SPACE_EQUIPMENT_RELATION_NOT_FOUND: 'Space Equipment Relation Not Found',
                SPACE_METER_RELATION_EXISTS: 'Space Meter Relation Exists',
                SPACE_METER_RELATION_NOT_FOUND: 'Space Meter Relation Not Found',
                SPACE_NAME_IS_ALREADY_IN_USE: 'Space Name Is Already In Use',
                SPACE_NOT_FOUND: 'Space Not Found',
                SPACE_NOT_FOUND_IN_PRIVILEGE: 'Space Not Found In Privilege',
                SPACE_OFFLINE_METER_RELATION_EXISTS: 'Space Offline Meter Relation Exists',
                SPACE_OFFLINE_METER_RELATION_NOT_FOUND: 'Space Offline Meter Relation Not Found',
                SPACE_POINT_RELATION_EXISTS: 'Space Point Relation Exists',
                SPACE_POINT_RELATION_NOT_FOUND: 'Space Point Relation Not Found',
                SPACE_SENSOR_RELATION_EXISTS: 'Space Sensor Relation Exists',
                SPACE_SENSOR_RELATION_NOT_FOUND: 'Space Sensor Relation Not Found',
                SPACE_SHOPFLOOR_RELATION_EXISTS: 'Space Shopfloor Relation Exists',
                SPACE_SHOPFLOOR_RELATION_NOT_FOUND: 'Space Shopfloor Relation Not Found',
                SPACE_STORE_RELATION_EXISTS: 'Space Store Relation Exists',
                SPACE_STORE_RELATION_NOT_FOUND: 'Space Store Relation Not Found',
                SPACE_TENANT_RELATION_EXISTS: 'Space Tenant Relation Exists',
                SPACE_TENANT_RELATION_NOT_FOUND: 'Space Tenant Relation Not Found',
                SPACE_VIRTUAL_METER_RELATION_EXISTS: 'Space Virtual Meter Relation Exists',
                SPACE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Space Virtual Meter Relation Not Found',
                START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME: 'Start Datetime Must Be Earlier Than End Datetime',
                STORE_METER_RELATION_EXISTS: 'Store Meter Relation Exists',
                STORE_METER_RELATION_NOT_FOUND: 'Store Meter Relation Not Found',
                STORE_NAME_IS_ALREADY_IN_USE: 'Store Name Is Already In Use',
                STORE_NOT_FOUND: 'Store Not Found',
                STORE_OFFLINE_METER_RELATION_EXISTS: 'Store Offline Meter Relation Exists',
                STORE_OFFLINE_METER_RELATION_NOT_FOUND: 'Store Offline Meter Relation Not Found',
                STORE_POINT_RELATION_EXISTS: 'Store Point Relation Exists',
                STORE_POINT_RELATION_NOT_FOUND: 'Store Point Relation Not Found',
                STORE_SENSOR_RELATION_EXISTS: 'Store Sensor Relation Exists',
                STORE_SENSOR_RELATION_NOT_FOUND: 'Store Sensor Relation Not Found',
                STORE_TYPE_NAME_IS_ALREADY_IN_USE: 'Store Type Name Is Already In Use',
                STORE_TYPE_NOT_FOUND: 'Store Type Not Found',
                STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Store Type Simplified Code Is Already In Use',
                STORE_TYPE_USED_IN_STORE: 'Store Type Used In Store',
                STORE_VIRTUAL_METER_RELATION_EXISTS: 'Store Virtual Meter Relation Exists',
                STORE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Store Virtual Meter Relation Not Found',
                TARGET_NODE_NOT_FOUND: 'Target Node Not Found',
                TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Already Associated With Cost Center',
                TARIFF_IN_USE: 'Tariff In Use',
                TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Not Associated With Cost Center',
                TARIFF_NAME_IS_ALREADY_IN_USE: 'Tariff Name Is Already In Use',
                TARIFF_NOT_EMPTY: 'Tariff Not Empty',
                TARIFF_NOT_FOUND: 'Tariff Not Found',
                TENANT_METER_RELATION_EXISTS: 'Tenant Meter Relation Exists',
                TENANT_METER_RELATION_NOT_FOUND: 'Tenant Meter Relation Not Found',
                TENANT_NAME_IS_ALREADY_IN_USE: 'Tenant Name Is Already In Use',
                TENANT_NOT_FOUND: 'Tenant Not Found',
                TENANT_OFFLINE_METER_RELATION_EXISTS: 'Tenant Offline Meter Relation Exists',
                TENANT_OFFLINE_METER_RELATION_NOT_FOUND: 'Tenant Offline Meter Relation Not Found',
                TENANT_POINT_RELATION_EXISTS: 'Tenant Point Relation Exists',
                TENANT_POINT_RELATION_NOT_FOUND: 'Tenant Point Relation Not Found',
                TENANT_SENSOR_RELATION_EXISTS: 'Tenant Sensor Relation Exists',
                TENANT_SENSOR_RELATION_NOT_FOUND: 'Tenant Sensor Relation Not Found',
                TENANT_TYPE_NAME_IS_ALREADY_IN_USE: 'Tenant Type Name Is Already In Use',
                TENANT_TYPE_NOT_FOUND: 'Tenant Type Not Found',
                TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Tenant Type Simplified Code Is Already In Use',
                TENANT_TYPE_USED_IN_TENANT: 'Tenant Type Used In Tenant',
                TENANT_VIRTUAL_METER_RELATION_EXISTS: 'Tenant Virtual Meter Relation Exists',
                TENANT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Tenant Virtual Meter Relation Not Found',
                TEXT_MESSAGE_NOT_FOUND: 'Text Message Not Found',
                THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES: 'The Reporting Period Must Be Longer Than 15 Minutes',
                THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS: 'There Is Associated Distribution Circuits',
                THERE_IS_RELATION_WITH_CHILD_METERS: 'There Is Relation With Child Meters',
                THERE_IS_RELATION_WITH_CHILDREN_SPACES: 'There Is Relation With Children Spaces',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS: 'There Is Relation With Combined Equipment Parameters',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS: 'There Is Relation With Combined Equipments',
                THERE_IS_RELATION_WITH_DATA_SOURCES: 'There Is Relation With Data Sources',
                THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS: 'There Is Relation With Energy Flow Diagram Links',
                THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS: 'There Is Relation With Equipment Parameters',
                THERE_IS_RELATION_WITH_EQUIPMENTS: 'There Is Relation With Equipments',
                THERE_IS_RELATION_WITH_METER: 'There Is Relation With Meter',
                THERE_IS_RELATION_WITH_METERS: 'There Is Relation With Meters',
                THERE_IS_RELATION_WITH_OFFLINE_METER: 'There Is Relation With Offline Meter',
                THERE_IS_RELATION_WITH_OFFLINE_METERS: 'There Is Relation With Offline Meters',
                THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS: 'There Is Relation With Other Virtual Meters',
                THERE_IS_RELATION_WITH_POINTS: 'There Is Relation With Points',
                THERE_IS_RELATION_WITH_SENSORS: 'There Is Relation With Sensors',
                THERE_IS_RELATION_WITH_SHOPFLOORS: 'There Is Relation With Shopfloors',
                THERE_IS_RELATION_WITH_SPACES: 'There Is Relation With Spaces',
                THERE_IS_RELATION_WITH_STORES: 'There Is Relation With Stores',
                THERE_IS_RELATION_WITH_TARIFFS: 'There Is Relation With Tariffs',
                THERE_IS_RELATION_WITH_TENANTS: 'There Is Relation With Tenants',
                THERE_IS_RELATION_WITH_VIRTUAL_METER: 'There Is Relation With Virtual Meter',
                THERE_IS_RELATION_WITH_VIRTUAL_METERS: 'There Is Relation With Virtual Meters',
                THERE_IS_RELATION_WITH_USERS: 'There Is Relation With Users',
                THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER: 'This Data Source Is Being Used By A Meter',
                THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Meter Is Being Used By A Virtual Meter',
                THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Offline Meter Is Being Used By A Virtual Meter',
                THIS_SHOPFLOOR_CANNOT_BE_DELETED: 'This Shopfloor Cannot Be Deleted',
                THIS_SPACE_CANNOT_BE_DELETED: 'This Space Cannot Be Deleted',
                TIMEZONE_NOT_FOUND: 'Timezone Not Found',
                TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'Token Not Found In Headers Please Login',
                USER_ACCOUNT_HAS_EXPIRED: 'User Account Has Expired',
                USER_NAME_IS_ALREADY_IN_USE: 'User Name Is Already In Use',
                USER_NOT_FOUND: 'User Not Found',
                USER_PASSWORD_HAS_EXPIRED: 'User Password Has Expired',
                USER_PRIVILEGE_NOT_FOUND: 'User Privilege Not Found',
                USER_SESSION_NOT_FOUND: 'User Session Not Found',
                USER_SESSION_TIMEOUT: 'User Session Timeout',
                USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'User UUID Not Found In Headers Please Login',
                VIRTUAL_METER_NAME_IS_ALREADY_IN_USE: 'Virtual Meter Name Is Already In Use',
                VIRTUAL_METER_NOT_FOUND: 'Virtual Meter Not Found',
                VIRTUAL_METER_OF_VARIABLE_NOT_FOUND: 'Virtual Meter Of Variable Not Found',
                VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE: 'Virtual Point Should Be Analog Value',
                WEB_MESSAGE_NOT_FOUND: 'Web Message Not Found',
                WECHAT_MESSAGE_NOT_FOUND: 'Wechat Message Not Found',
            },
        })
        .translations('zh_CN', {
            MY_EMS_NAME: 'MyEMS',
            LANGUAGE: '语 言',
            FULLSCREEN: '全屏显示',
            EXITFULLSCREEN: '退出全屏',
            LOGOUT: '退出',
            COMMON: {
                EXECUTE: '执行',
                PLACEHOLDER: '请选择或搜索...',
                SPACE: '空间',
                EQUIPMENT: '设备',
                COMBINED_EQUIPMENT: '组合设备',
                TENANT: '租户',
                STORE: '门店',
                SHOPFLOOR: '车间',
                SENSOR: '传感器',
                ENERGY_FLOW_DIAGRAM: '能流图',
                MENU: '菜单',
                DATE: '日期',
                TARIFF: {
                    TOPPEAK: '尖',
                    ONPEAK: '峰',
                    OFFPEAK: '谷',
                    MIDPEAK: '平'
                }
            },
            FDD: {
                ID: 'ID',
                RULE: '规则',
                EMAIL_MESSAGE: '邮件信息',
                TEXT_MESSAGE: '短信信息',
                WEB_MESSAGE: '网页信息',
                WECHAT_MESSAGE: '微信信息',

                ALARM_LIST: '查看报警列表',
                RULE_LIST: '规则列表',
                ADD_RULE: '添加规则',
                EDIT_RULE: '编辑规则',
                FDD_CODE: '诊断代码',
                CATEGORY: '诊断类别',
                PRIORITY: '报警优先级',
                CHANNEL: '报警通道',
                IS_ENABLED: '报警开关',
                LAST_RUN_DATETIME: '上次运行时间',
                NEXT_RUN_DATETIME: '下次运行时间',
                EXPRESSION: '表达式',
                MESSAGE_TEMPLATE: '消息模板',
                CLICK_EDIT_FOR_DETAILS: '点击"修改"查看详情',

                SMS_ALARM_LIST: '短信报警列表',
                RECIPIENT_NAME: '接收人',
                RECIPIENT_MOBILE: '手机号',
                ALARM_MESSAGE: '报警信息',
                ALARM_TIME: '报警时间',
                SCHEDULE_TIME: '预定发送时间',
                ACKNOWLEDGE_CODE: '确认代码',

                EMAIL_ALARM_LIST: '邮件报警列表',
                EMAIL: '邮箱',
                TOPIC: '主题',
                ATTACHMENT_NAME: '附件名称',
                ACKNOWLEDGE_MESSAGE: '确认消息',
                ACKNOWLEDGE: '确认',
                WEB_ALARM_LIST: '网页报警列表',
                WECHAT_ALARM_LIST: '微信报警列表',
                WECHAT_ID: '微信号',
                MESSAGE_FORMAT: '信息格式',
                ACKNOWLEDGE_ALARM: '是否确认报警？',
            },
            MENU: {
                SETTINGS: {
                    SETTINGS: '系统管理',
                    SPACE: '空间管理',
                    TENANT: '租户管理',
                    STORE: '门店管理',
                    SHOPFLOOR: '车间管理',
                    EQUIPMENT: '设备管理',
                    COMBINED_EQUIPMENT: '组合设备管理',
                    METER: '计量表管理',
                    SENSOR: '传感器管理',
                    GATEWAY: '网关管理',
                    DATASOURCE: '数据源管理',
                    COSTCENTER: '成本中心管理',
                    PRODUCT: '产品管理',
                    CATEGORY: '能源分类管理',
                    ENERGY_FLOW_DIAGRAM: '能流图管理',
                    DISTRIBUTION_SYSTEM: '配电系统管理',
                    MENU: '菜单管理',
                    TARIFF: '能源费率管理',
                    EMAIL_SERVER: '邮件服务器设置',
                    CONTACT: '联系人管理',
                    KNOWLEDGEFILE: '知识库管理'
                },
                FDD: {
                    FDD: '故障检测与诊断',
                    RULE: '规则管理',
                    MESSAGEALARM: '短信报警',
                    EMAILALARM: '邮件报警',
                    WEBALARM: '网页报警',
                    WECHATALARM: '微信报警',
                },
                USERSETTING: {
                    USERSETTING: '用户与权限',
                    USER: '用户设置',
                    PRIVILEGE: '权限设置'
                }
            },
            LOGIN: {
                USERLOGIN: '用户登录',
                USERNAME: '用户名',
                PASSWORD: '密 码',
                LOGIN: '登 录',
                TITLE: '能 源 管 理 系 统',
            },
            SETTING: {
                KNOWLEDGEFILE: '知识文件',
                ID: 'ID',
                ACTION: '操作',
                ADD: '添加',
                BIND_PROPERTY: '绑定属性',
                EDIT: '修改',
                DELETE: '删除',
                SELECT: '选择',
                RESET: '重置',
                SAVE: '保存',
                CANCEL: '取消',
                DOWNLOAD: '下载',
                REFRESH: '刷新',
                RETURN: '返回',
                YES: '是',
                NO: '否',
                ON: '打开',
                OFF: '关闭',
                OK: '确定',
                OPTIONAL: '可选',
                ADD_SPACE: '添加空间',
                ADD_TENANT: '添加租户',
                ADD_STORE: '添加门店',
                ADD_METER: '添加计量表',
                ADD_VIRTUAL_METER: '添加虚拟表',
                ADD_OFFLINE_METER: '添加离线表',
                ADD_POINT: '添加数据点',
                ADD_COSTCENTER: '添加成本中心',
                ADD_TARIFF: '添加费率',
                ADD_CATEGORY: '添加能源分类',
                ADD_ENERGY_ITEM: '添加能耗分项',
                ADD_CONTACT: '添加联系人',
                ADD_EMAIL_SERVER: '添加邮件服务器',

                EDIT_SPACE: '编辑空间',
                EDIT_TENANT: '编辑租户',
                EDIT_STORE: '编辑门店',
                EDIT_METER: '编辑计量表',
                EDIT_VIRTUAL_METER: '编辑虚拟表',
                EDIT_OFFLINE_METER: '编辑离线表',
                EDIT_POINT: '编辑数据点',
                EDIT_COSTCENTER: '编辑成本中心',
                EDIT_TARIFF: '编辑费率',
                EDIT_CATEGORY: '编辑能源分类',
                EDIT_ENERGY_ITEM: '编辑能耗分项',
                EDIT_CONTACT: '编辑联系人',
                EDIT_EMAIL_SERVER: '编辑邮箱服务器',

                REQUIRES_AUTHENTICATION: '需要身份验证',
                SELECT_DATE: '请选择日期',
                SELECT_SPACE: '请选择空间',
                SELECT_TENANT: '请选择租户',
                SELECT_STORE: '请选择门店',
                SELECT_TIMEZONE: '请选择时区',
                SELECT_CATEGORY: '请选择能源分类',
                SELECT_ENERGY_ITEM: '请选择能耗分项',
                SELECT_COSTCENTER: '请选择成本中心',
                SELECT_METER: '请选择计量表',
                IS_INPUT_COUNTED: '能耗参与汇总',
                IS_OUTPUT_COUNTED: '能源产出参与汇总',
                BIND_METER: '绑定计量表',
                BIND_POINT: '绑定数据点',
                BIND_SENSOR: '绑定传感器',
                BIND_TARIFF: '绑定费率',

                INPUT_NAME: '请输入名称',
                INPUT_AREA: '请输入面积',
                INPUT_UNIT: '请输入单位',
                INPUT_CONTACT: '请输入联系人',
                INPUT_EXPRESSION: '请输入表达式',
                INPUT_KGCE: '请输入千克标准煤',
                INPUT_KGCO2E: '请输入千克二氧化碳排放',
                INPUT_HOST: '请输入服务器',
                INPUT_PORT: '请输入端口号',
                INPUT_USER_NAME: '请输入用户名',
                INPUT_FROM_ADDR: '请输入发件人地址',
                INPUT_SERIAL_PORT: '请输入串口',
                INPUT_BAUD_RATE: '请输入波特率',

                EMAIL_SERVER: '邮件服务器',
                INVALID_FORMAT: '格式不正确',
                INVALID_FROM_ADDR: '发件人地址不正确',
                INVALID_BAUD_RATE: '波特率不正确',
                NOT_NULLABLE: '不允许为空',
                METER: '计量表',
                VIRTUAL_METER: '虚拟表',
                OFFLINE_METER: '离线表',
                OFFLINE_METER_FILE: '离线表文件',
                PRODUCT: '产品',
                N_S_METER: '绑定的表',
                N_S_POINT: '绑定的数据点',
                N_S_SENSOR: '绑定的传感器',
                N_S_TARIFF: '绑定的费率',
                TARIFF_LIST: '费率列表',
                POINT_LIST: '数据点列表',
                SENSOR_LIST: '传感器列表',
                METER_TYPE: '计量表类型',
                METER_NAME: '计量表名',
                TRASH: '回收桶',
                DRAG_TO_BIND: '请拖拽完成绑定',
                DRAG_TO_UNBIND: '请拖拽至回收桶解除绑定',
                COST_FILE: '成本文件',
                NAME: '名称',
                AREA: '面积',
                UNIT: '单位',
                CONTACT: '联系人',
                TIMEZONE: '时区',
                TARIFF: '费率',

                COSTCENTER: '成本中心',
                CATEGORY: '能源分类',
                ENERGY_ITEM: '能耗分项',
                STATUS: '状态',
                UPLOAD_TIME: '上传时间',
                EXPRESSION: '表达式',
                VARIABLE_NAME: '变量名',
                POINT: '数据点',
                KGCE: '千克标准煤',
                KGCO2E: '千克二氧化碳排放',

                START_DATETIME: '起始时间',
                START_TIME: '开始时间',
                END_DATETIME: '结束时间',
                END_TIME: '结束时间',
                TARIFF_TYPE: '费率类型',
                TARIFF_NAME: '名称',
                PRICE: '价格',
                BLOCK: '阶梯费率',
                TIMEOFUSE: '分时费率',
                PEAK_TYPE: '峰谷平',
                START_AMOUNT: '起始量',
                END_AMOUNT: '结束量',

                PORT: '端口',
                SMS: '短信',
                SERIAL_PORT: '串口地址',
                BAUD_RATE: '波特率',
                FROM_ADDR: '发件人地址',
                HOST: '服务器',
                USER_NAME: '用户名',

                USER: '用户',

                SEARCH: '搜索...',

                RESTORE: '恢复',
                RESTORE_SUCCESS: '恢复成功',
                RESTORE_FAILED: '恢复失败',

                SELECT_MENU: '选择菜单',
                CURRENT_SELECTED_MENU: '当前选定菜单',
                PARENT_MENU: '上级菜单',
                IS_HIDDEN: '是否隐藏',
                CHILD_MENUS: '下级菜单',
                EDIT_MENU: '编辑菜单'
            },
            CONTACT: {
                EMAIL: '邮箱',
                PHONE: '电话',
                DESCRIPTION: '描述',
                INPUT_EMAIL: '请输入邮箱',
                INPUT_PHONE: '请输入电话',
                INPUT_DESCRIPTION: '请输入描述',
                INVALID_EMAIL: '邮箱格式不正确(xxx@xxx.xx)',
            },
            COSTCENTER: {
                EXTERNAL_ID: '外部ID',
                INPUT_EXTERNAL_ID: '请输入外部ID',
            },
            GATEWAY: {
                GATEWAY: '网关',
                TOKEN: '令牌',
                LAST_SEEN_DATETIME: '最后在线时间',
                SELECT_GATEWAY: '选择网关',
                ADD_GATEWAY: '添加网关',
                EDIT_GATEWAY: '编辑网关',
            },
            DATA_SOURCE: {
                DATA_SOURCE: '数据源',
                ADD_DATA_SOURCE: '添加数据源',
                EDIT_DATA_SOURCE: '编辑数据源',
                SELECT_DATA_SOURCE: '请选择数据源',
                PROTOCOL: '协议',
                CONNECTION: '连接',
                LAST_SEEN_DATETIME: '最后在线时间',
                INPUT_PROTOCOL: '请输入协议类型',
                INPUT_CONNECTION: '请输入连接地址',
            },
            POINT: {
                OBJECT_TYPE: '对象类型',
                UNIT: '单位',
                HIGH_LIMIT: '高限',
                LOW_LIMIT: '低限',
                RATIO: '比例系数',
                IS_TREND: '保存趋势',
                IS_VIRTUAL: '虚拟点',
                ADDRESS: '地址(JSON)',
                DESCRIPTION: '描述',
                INPUT_HIGH_LIMIT: '请输入高限',
                INPUT_LOW_LIMIT: '请输入低限',
                INPUT_RATIO: '请输入比例系数',
                INPUT_ADDRESS: '请输入地址',
                INPUT_DESCRIPTION: '请输入描述',
            },

            DISTRIBUTION_SYSTEM: {
                DISTRIBUTION_SYSTEM: '配电系统',
                ADD_DISTRIBUTION_SYSTEM: '添加配电系统',
                EDIT_DISTRIBUTION_SYSTEM: '编辑配电系统',
                SELECT_DISTRIBUTION_SYSTEM: '请选择配电系统',
                SVG: 'SVG',
                INPUT_SVG: '请输入SVG',
                DESCRIPTION: '描述',
                DISTRIBUTION_CIRCUIT: '配电回路',
                N_S_DISTRIBUTION_CIRCUIT: '附属配电回路',
                ADD_DISTRIBUTION_CIRCUIT: '添加配电回路',
                EDIT_DISTRIBUTION_CIRCUIT: '编辑配电回路',
                SELECT_DISTRIBUTION_CIRCUIT: '请选择配电回路',
                DISTRIBUTION_CIRCUIT_ID: 'ID',
                DISTRIBUTION_CIRCUIT_NAME: '名称',
                INPUT_DISTRIBUTION_CIRCUIT_NAME: '请输入名称',
                DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: '配电房',
                INPUT_DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: '请输入配电房',
                DISTRIBUTION_CIRCUIT_SWITCHGEAR: '配电柜',
                INPUT_DISTRIBUTION_CIRCUIT_SWITCHGEAR: '请输入配电柜',
                DISTRIBUTION_CIRCUIT_PEAK_LOAD: '最大容量(KW)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_LOAD: '请输入最大容量(KW)',
                DISTRIBUTION_CIRCUIT_PEAK_CURRENT: '最大电流(A)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_CURRENT: '请输入最大电流(A)',
                DISTRIBUTION_CIRCUIT_CUSTOMERS: '用户',
                INPUT_DISTRIBUTION_CIRCUIT_CUSTOMERS: '请输入用户',
                DISTRIBUTION_CIRCUIT_METERS: '出线电表',
                INPUT_DISTRIBUTION_CIRCUIT_METERS: '请输入出线电表',
                PREVIEW: '预览',
                N_S_PREVIEW: ' 预览',
            },
            ENERGY_FLOW_DIAGRAM: {
                ADD_ENERGY_FLOW_DIAGRAM: '添加能流图',
                EDIT_ENERGY_FLOW_DIAGRAM: '编辑能流图',
                SELECT_ENERGY_FLOW_DIAGRAM: '请选择能流图',
                NODE: '节点',
                N_S_NODE: ' 附属节点',
                ADD_NODE: '添加节点',
                EDIT_NODE: '编辑节点',
                NODE_ID: '节点ID',
                NODE_NAME: '节点名称',
                INPUT_NODE_NAME: '请输入节点名称',
                LINK: '链接',
                N_S_LINK: ' 附属链接',
                LINK_ID: '链接ID',
                ADD_LINK: '添加链接',
                EDIT_LINK: '编辑链接',
                SOURCE_NODE: '源节点',
                TARGET_NODE: '目标节点',
                METER: '计量表',
                PREVIEW: '预览',
                N_S_PREVIEW: '预览',
            },
            COMBINED_EQUIPMENT: {
                ADD_COMBINED_EQUIPMENT: '添加组合设备',
                EDIT_COMBINED_EQUIPMENT: '编辑组合设备',
                SELECT_COMBINED_EQUIPMENT: '请选择组合设备',
                COST_CENTER: '成本中心',
                SELECT_COST_CENTER: '请选择成本中心',
                DESCRIPTION: '描述',
                BIND_EQUIPMENT: '绑定设备',
                N_S_EQUIPMENT: '绑定的设备',
                EQUIPMENT_LIST: '设备列表',
                INPUT_DESCRIPTION: '请输入描述',
                INPUT_METER: '输入表',
                OUTPUT_METER: '输出表',
                PARAMETER: '参数',
                BIND_PARAMETER: '绑定参数',
                ADD_PARAMETER: '添加参数',
                EDIT_PARAMETER: '编辑参数',
                N_S_PARAMETER: '附属参数',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: '名称',
                INPUT_PARAMETER_NAME: '请输入名称',
                PARAMETER_TYPE: '类型',
                SELECT_PARAMETER_TYPE: '选择类型',
                CONSTANT: '常量值',
                POINT: '数据点',
                SELECT_POINT: '选择数据点',
                FRACTION: '分式',
                PARAMETER_CONSTANT: '常量',
                PARAMETER_POINT: '数据点',
                PARAMETER_NUMERATOR_METER: '分子计量表',
                PARAMETER_DENOMINATOR_METER: '分母计量表',
            },
            EQUIPMENT: {
                ADD_EQUIPMENT: '添加设备',
                EDIT_EQUIPMENT: '编辑设备',
                SELECT_EQUIPMENT: '请选择设备',
                COST_CENTER: '成本中心',
                SELECT_COST_CENTER: '请选择成本中心',
                DESCRIPTION: '描述',
                INPUT_DESCRIPTION: '请输入描述',
                INPUT_METER: '输入表',
                OUTPUT_METER: '输出表',
                PARAMETER: '参数',
                BIND_PARAMETER: '绑定参数',
                ADD_PARAMETER: '添加参数',
                EDIT_PARAMETER: '编辑参数',
                N_S_PARAMETER: '附属参数',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: '名称',
                INPUT_PARAMETER_NAME: '请输入名称',
                PARAMETER_TYPE: '类型',
                SELECT_PARAMETER_TYPE: '选择类型',
                CONSTANT: '常量值',
                POINT: '数据点',
                SELECT_POINT: '选择数据点',
                FRACTION: '分式',
                PARAMETER_CONSTANT: '常量',
                PARAMETER_POINT: '数据点',
                PARAMETER_NUMERATOR_METER: '分子计量表',
                PARAMETER_DENOMINATOR_METER: '分母计量表',
            },
            SPACE: {
                PARENT_SPACE: '上级',
                AREA: '面积',
                INPUT_AREA: '请输入面积',
                DESCRIPTION: '描述',
                INPUT_DESCRIPTION: '请输入描述',
                CURRENT_SELECTED_SPACE: '当前选中空间',
                CHILD_SPACES: '子空间',
                BIND_COMBINED_EQUIPMENT: '绑定组合设备',
                N_S_COMBINED_EQUIPMENT: '绑定的组合设备',
                COMBINED_EQUIPMENT_LIST: '组合设备列表',
                BIND_EQUIPMENT: '绑定设备',
                N_S_EQUIPMENT: '绑定的设备',
                EQUIPMENT_LIST: '设备列表',
                BIND_TENANT: '绑定租户',
                N_S_TENANT: '绑定的租户',
                TENANT_LIST: '租户列表',
                BIND_STORE: '绑定门店',
                N_S_STORE: '绑定的门店',
                STORE_LIST: '门店列表',
                BIND_SHOPFLOOR: '绑定车间',
                N_S_SHOPFLOOR: '绑定的车间',
                SHOPFLOOR_LIST: '车间列表',
            },
            TENANT: {
                BUILDINGS: '建筑',
                FLOORS: '楼层',
                ROOMS: '房间',
                TYPE: '租户类型',
                IS_KEY_TENANT: '是否主力租户',
                LEASE_NUMBER: '租约编号',
                LEASE_START_DATETIME: '租赁开始日期时间',
                LEASE_END_DATETIME: '租赁结束日期时间',
                IS_IN_LEASE: '是否在租',
                DESCRIPTION: '描述',
                INPUT_BUILDINGS: '请输入建筑',
                INPUT_FLOORS: '请输入楼层',
                INPUT_ROOMS: '请输入房间',
                INPUT_LEASE_NUMBER: '请输入租约编号',
                INPUT_DESCRIPTION: '请输入描述',
            },
            STORE: {
                ADDRESS: '地址',
                LATITUDE: '纬度',
                LONGITUDE: '经度',
                TYPE: '门店类型',
                DESCRIPTION: '描述',
                INPUT_ADDRESS: '请输入地址',
                INPUT_LATITUDE: '请输入纬度',
                INPUT_LONGITUDE: '请输入经度',
                INPUT_DESCRIPTION: '请输入描述',
            },
            SHOPFLOOR: {
                ADD_SHOPFLOOR: '添加车间',
                EDIT_SHOPFLOOR: '编辑车间',
                SELECT_SHOPFLOOR: '请选择车间',
                AREA: '面积',
                INPUT_AREA: '请输入面积',
                DESCRIPTION: '描述',
                INPUT_DESCRIPTION: '请输入描述',
                BIND_EQUIPMENT: '绑定设备',
                N_S_EQUIPMENT: '绑定的设备',
                EQUIPMENT_LIST: '设备列表',
            },
            METER: {
                HOURLY_LOW_LIMIT: '每小时最小值（包含）',
                INPUT_HOURLY_LOW_LIMIT: '请输入每小时最小值',
                HOURLY_HIGH_LIMIT: '每小时最大值（包含）',
                INPUT_HOURLY_HIGH_LIMIT: '请输入每小时最大值',
                DESCRIPTION: '描述',
                INPUT_DESCRIPTION: '请输入描述',
                MASTER_METER: '上级计量表',
                SELECT_MASTER_METER: '选择上级计量表',
                TREE_VIEW: '树视图',
                CHILD_METERS: '下级计量表',
            },
            SENSOR: {
                ADD_SENSOR: '添加传感器',
                EDIT_SENSOR: '编辑传感器',
                DELETE_SENSOR: '删除传感器',
                DESCRIPTION: '描述',
                INPUT_DESCRIPTION: '请输入描述',
                SELECT_SENSOR: '选择传感器',
            },
            USER: {
                USER_LIST: '用户列表',
                PRIVILEGE_LIST: '权限列表',
                ADD_USER: '添加用户',
                EDIT_USER: '编辑用户',
                PRIVILEGE: '权限',
                ADD_PRIVILEGE: '添加权限',
                EDIT_PRIVILEGE: '编辑权限',
                IS_ADMIN: '是否为管理员',
                DISPLAY_NAME: '显示名',
                USERNAME: '用户名',
                PASSWORD: '密码',
                RESET_PASSWORD: '重置密码',
                CHANGE_PASSWORD: '修改密码',
                OLD_PASSWORD: '旧密码',
                NEW_PASSWORD: '新密码',
                CONFIRM_PASSWORD: '确认密码',
                INPUT_PASSWORD: '请输入密码',
                DIFF_PASSWORD: '两次输入的密码不匹配',
                EMAIL: '邮箱',
                INPUT_EMAIL: '请输入邮箱',
                INVALID_EMAIL: '邮箱格式不正确(xxx@xxx.xx)',
                ACCOUNT_EXPIRATION_DATETIME: '账户失效时间',
                PASSWORD_EXPIRATION_DATETIME: '密码失效时间',
            },
            KNOWLEDGEFILE: {
                KNOWLEDGE_FILE_LIST: '知识文件列表',
                UPLOAD_USER: '上传者',
                UPLOAD_TIME: '上传时间',
                DELETE: '删除',
            },
            TOASTER: {
                SUCCESS_TITLE: '成功',
                LOGIN_SUCCESS: '登录成功',
                LOGIN_FAILURE: '登录失败',
                LOGOUT_SUCCESS: '退出成功',
                LOGOUT_FAILURE: '退出失败',

                SUCCESS_ADD_BODY: '添加 {{template}} 成功',
                SUCCESS_UPDATE_BODY: '更新 {{template}} 成功',
                SUCCESS_DELETE_BODY: '删除 {{template}} 成功',
                ERROR_ADD_BODY: '添加 {{template}} 失败',
                ERROR_UPDATE_BODY: '更新 {{template}} 失败',
                ERROR_DELETE_BODY: '删除 {{template}} 失败',

                USER_PASSWORD: '用户密码',
                BIND_METER_SUCCESS: '绑定计量表成功',
                UNBIND_METER_SUCCESS: '解绑计量表成功',
                BIND_TARIFF_SUCCESS: '绑定费率成功',
                UNBIND_TARIFF_SUCCESS: '解绑费率成功',
                BIND_POINT_SUCCESS: '绑定数据点成功',
                UNBIND_POINT_SUCCESS: '解绑数据点成功',
                BIND_SENSOR_SUCCESS: '绑定传感器成功',
                UNBIND_SENSOR_SUCCESS: '解绑传感器成功',
                BIND_EQUIPMENT_SUCCESS: '绑定设备成功',
                UNBIND_EQUIPMENT_SUCCESS: '解绑设备成功',
                BIND_COMBINED_EQUIPMENT_SUCCESS: '绑定组合设备成功',
                UNBIND_COMBINED_EQUIPMENT_SUCCESS: '解绑组合设备成功',
                BIND_TENANT_SUCCESS: '绑定租户成功',
                UNBIND_TENANT_SUCCESS: '解绑租户成功',
                BIND_STORE_SUCCESS: '绑定门店成功',
                UNBIND_STORE_SUCCESS: '解绑门店成功',
                BIND_SHOPFLOOR_SUCCESS: '绑定车间成功',
                UNBIND_SHOPFLOOR_SUCCESS: '解绑车间成功',
            },
            SWEET: {
                TITLE: '请确认是否删除?',
                TEXT: '删除该条也会删除所有与其相关数据!',
                CONFIRM_BUTTON_TEXT: '确认删除',
                CANCEL_BUTTON_TEXT: '取消',
            },
            API: {
                ADMINISTRATOR_SESSION_NOT_FOUND: 'Administrator Session Not Found',
                ADMINISTRATOR_SESSION_TIMEOUT: 'Administrator Session Timeout',
                ADVANCED_REPORT_NOT_FOUND: 'Advanced Report Not Found',
                BAD_REQUEST: 'Bad Request',
                CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER: 'Cannot Set Existing Submeter As Master Meter',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS: 'Combined Equipment Equipment Relation Exists',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND: 'Combined Equipment Equipment Relation Not Found',
                COMBINED_EQUIPMENT_METER_RELATION_EXISTS: 'Combined Equipment Meter Relation Exists',
                COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND: 'Combined Equipment Meter Relation Not Found',
                COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Name Is Already In Use',
                COMBINED_EQUIPMENT_NOT_FOUND: 'Combined Equipment Not Found',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Combined Equipment Offline Meter Relation Exists',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Combined Equipment Offline Meter Relation Not Found',
                COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Parameter Name Is Already In Use',
                COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Combined Equipment Parameter Not Found Or Not Match',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Combined Equipment Virtual Meter Relation Exists',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Combined Equipment Virtual Meter Relation Not Found',
                CONTACT_NAME_IS_ALREADY_IN_USE: 'Contact Name Is Already In Use',
                CONTACT_NOT_FOUND: 'Contact Not Found',
                COST_CENTER_EXTERNAL_ID_EXISTS: 'Cost Center External ID Exists',
                COST_CENTER_NAME_EXISTS: 'Cost Center Name Exists',
                COST_CENTER_NOT_FOUND: 'Cost Center Not Found',
                COST_FILE_NOT_FOUND: 'Cost File Not Found',
                DATA_SOURCE_NAME_IS_ALREADY_IN_USE: 'Data Source Name Is Already In Use',
                DATA_SOURCE_NOT_FOUND: 'Data Source Not Found',
                DATABASE_ERROR: 'Database Error',
                DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE: 'Distribution Circuit Name Is Already In Use',
                DISTRIBUTION_CIRCUIT_NOT_FOUND: 'Distribution Circuit Not Found',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS: 'Distribution Circuit Point Relation Exists',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND: 'Distribution Circuit Point Relation Not Found',
                DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE: 'Distribution System Name Is Already In Use',
                DISTRIBUTION_SYSTEM_NOT_FOUND: 'Distribution System Not Found',
                EMAIL_IS_ALREADY_IN_USE: 'Email Is Already In Use',
                EMAIL_MESSAGE_NOT_FOUND: 'Email Message Not Found',
                EMAIL_SERVER_HOST_IS_ALREADY_IN_USE: 'Email Server Host Is Already In Use',
                EMAIL_SERVER_NOT_FOUND: 'Email Server Not Found',
                EMPTY_VARIABLES_ARRAY: 'Empty Variables Array',
                ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE: 'Energy Category Name Is Already In Use',
                ENERGY_CATEGORY_NOT_FOUND: 'Energy Category Not Found',
                ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS: 'Energy Category Used In Energy Items',
                ENERGY_CATEGORY_USED_IN_METER: 'Energy Category Used In Meter',
                ENERGY_CATEGORY_USED_IN_OFFLINE_METER: 'Energy Category Used In Offline Meter',
                ENERGY_CATEGORY_USED_IN_TARIFFS: 'Energy Category Used In Tariffs',
                ENERGY_CATEGORY_USED_IN_VIRTUAL_METER: 'Energy Category Used In Virtual Meter',
                ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE: 'Energy Flow Diagram Link Is Already In Use',
                ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Link Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Node Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Node Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NOT_FOUND: 'Energy Flow Diagram Not Found',
                ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Does Not Belong To Energy Category',
                ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Is Not Belong To Energy Category',
                ENERGY_ITEM_NAME_IS_ALREADY_IN_USE: 'Energy Item Name Is Already In Use',
                ENERGY_ITEM_NOT_FOUND: 'Energy Item Not Found',
                ENERGY_ITEM_USED_IN_METER: 'Energy Item Used In Meter',
                ENERGY_ITEM_USED_IN_OFFLINE_METER: 'Energy Item Used In Offline Meter',
                ENERGY_ITEM_USED_IN_VIRTUAL_METER: 'Energy Item Used In Virtual Meter',
                EQUIPMENT_METER_RELATION_EXISTS: 'Equipment Meter Relation Exists',
                EQUIPMENT_METER_RELATION_NOT_FOUND: 'Equipment Meter Relation Not Found',
                EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Equipment Name Is Already In Use',
                EQUIPMENT_NOT_FOUND: 'Equipment Not Found',
                EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Equipment Offline Meter Relation Exists',
                EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Equipment Offline Meter Relation Not Found',
                EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Equipment Parameter Name Is Already In Use',
                EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Equipment Parameter Not Found Or Not Match',
                EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Equipment Virtual Meter Relation Exists',
                EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Equipment Virtual Meter Relation Not Found',
                ERROR: 'Error',
                EXCEPTION: 'Exception',
                FAILED_TO_RESTORE_COST_FILE: 'Failed To Restore Cost File',
                FAILED_TO_RESTORE_KNOWLEDGE_FILE: 'Failed To Restore Knowledge File',
                FAILED_TO_RESTORE_OFFLINE_METER_FILE: 'Failed To Restore Offline Meter File',
                FAILED_TO_UPLOAD_COST_FILE: 'Failed To Upload Cost File',
                FAILED_TO_UPLOAD_KNOWLEDGE_FILE: 'Failed To Upload Knowledge File',
                FAILED_TO_UPLOAD_OFFLINE_METER_FILE: 'Failed To Upload Offline Meter File',
                GATEWAY_NAME_IS_ALREADY_IN_USE: 'Gateway Name Is Already In Use',
                GATEWAY_NOT_FOUND: 'Gateway Not Found',
                INVALID_ADDRESS: 'Invalid Address',
                INVALID_ADDRESS_VALUE: 'Invalid Address Value',
                INVALID_ADVANCED_REPORT_ID: 'Invalid Advanced Report ID',
                INVALID_AREA_VALUE: 'Invalid Area Value',
                INVALID_BASE_PERIOD_END_DATETIME: 'Invalid Base Period End Datetime',
                INVALID_BASE_PERIOD_START_DATETIME: 'Invalid Base Period Start Datetime',
                INVALID_BAUD_RATE: 'Invalid Baud Rate',
                INVALID_BUILDINGS_VALUE: 'Invalid Buildings Value',
                INVALID_CATEGORY: 'Invalid Category',
                INVALID_CHANNEL: 'Invalid Channel',
                INVALID_COMBINED_EQUIPMENT_ID: 'Invalid Combined Equipment ID',
                INVALID_COMBINED_EQUIPMENT_NAME: 'Invalid Combined Equipment Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_ID: 'Invalid Combined Equipment Parameter ID',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME: 'Invalid Combined Equipment Parameter Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE: 'Invalid Combined Equipment Parameter Type',
                INVALID_CONNECTION: 'Invalid Connection',
                INVALID_CONSTANT_VALUE: 'Invalid Constant Value',
                INVALID_CONTACT_ID: 'Invalid Contact ID',
                INVALID_CONTACT_NAME: 'Invalid Contact Name',
                INVALID_COST_CENTER_ID: 'Invalid Cost Center ID',
                INVALID_COST_FILE_ID: 'Invalid Cost File ID',
                INVALID_DATA_SOURCE_ID: 'Invalid Data Source ID',
                INVALID_DATA_SOURCE_NAME: 'Invalid Data Source Name',
                INVALID_DATA_SOURCE_PROTOCOL: 'Invalid Data Source Protocol',
                INVALID_DENOMINATOR_METER_UUID: 'Invalid Denominator Meter UUID',
                INVALID_DISPLAY_NAME: 'Invalid Display Name',
                INVALID_DISTRIBUTION_CIRCUIT_ID: 'Invalid Distribution Circuit ID',
                INVALID_DISTRIBUTION_CIRCUIT_NAME: 'Invalid Distribution Circuit Name',
                INVALID_DISTRIBUTION_ROOM: 'Invalid Distribution Room',
                INVALID_DISTRIBUTION_SYSTEM_ID: 'Invalid Distribution System ID',
                INVALID_DISTRIBUTION_SYSTEM_NAME: 'Invalid Distribution System Name',
                INVALID_EMAIL: 'Invalid Email',
                INVALID_EMAIL_MESSAGE_ID: 'Invalid Email Message ID',
                INVALID_EMAIL_SERVER_HOST: 'Invalid Email Server Host',
                INVALID_EMAIL_SERVER_ID: 'Invalid Email Server ID',
                INVALID_END_DATE_FORMAT: 'Invalid End Date Format',
                INVALID_END_DATETIME: 'Invalid End Datetime',
                INVALID_ENERGY_CATEGORY_ID: 'Invalid Energy Category ID',
                INVALID_ENERGY_CATEGORY_NAME: 'Invalid Energy Category Name',
                INVALID_ENERGY_FLOW_DIAGRAM_ID: 'Invalid Energy Flow Diagram ID',
                INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID: 'Invalid Energy Flow Diagram Link ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NAME: 'Invalid Energy Flow Diagram Name',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID: 'Invalid Energy Flow Diagram Node ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME: 'Invalid Energy Flow Diagram Node Name',
                INVALID_ENERGY_ITEM_ID: 'Invalid Energy Item ID',
                INVALID_ENERGY_ITEM_NAME: 'Invalid Energy Item Name',
                INVALID_EQUATION_IN_EXPRESSION: 'Invalid Equation In Expression',
                INVALID_EQUIPMENT_ID: 'Invalid Equipment ID',
                INVALID_EQUIPMENT_NAME: 'Invalid Equipment Name',
                INVALID_EQUIPMENT_PARAMETER_ID: 'Invalid Equipment Parameter ID',
                INVALID_EQUIPMENT_PARAMETER_NAME: 'Invalid Equipment Parameter Name',
                INVALID_EQUIPMENT_PARAMETER_TYPE: 'Invalid Equipment Parameter Type',
                INVALID_EXPRESSION: 'Invalid Expression',
                INVALID_EXPRESSION_OBJECT: 'Invalid Expression Object',
                INVALID_FDD_CODE: 'Invalid Fdd Code',
                INVALID_FLOORS_VALUE: 'Invalid Floors Value',
                INVALID_FROM_ADDR: 'Invalid From Address',
                INVALID_GATEWAY_ID: 'Invalid Gateway ID',
                INVALID_GATEWAY_NAME: 'Invalid Gateway Name',
                INVALID_HOURLY_HIGH_LIMIT_VALUE: 'Invalid Hourly High Limit Value',
                INVALID_HOURLY_LOW_LIMIT_VALUE: 'Invalid Hourly Low Limit Value',
                INVALID_IS_ADMIN_VALUE: 'Invalid Is Admin Value',
                INVALID_IS_COUNTED_VALUE: 'Invalid Is Counted Value',
                INVALID_IS_ENABLED: 'Invalid Is Enabled',
                INVALID_IS_HIDDEN: 'Invalid Is Hidden',
                INVALID_IS_IN_LEASE_VALUE: 'Invalid Is In Lease Value',
                INVALID_IS_INPUT_COUNTED_VALUE: 'Invalid Is Input Counted Value',
                INVALID_IS_KEY_TENANT_VALUE: 'Invalid Is Key Tenant Value',
                INVALID_IS_OUTPUT_COUNTED_VALUE: 'Invalid Is Output Counted Value',
                INVALID_IS_OUTPUT_VALUE: 'Invalid Is Output Value',
                INVALID_IS_TREND_VALUE: 'Invalid Is Trend Value',
                INVALID_IS_VIRTUAL_VALUE: 'Invalid Is Virtual Value',
                INVALID_KGCE: 'Invalid KGCE',
                INVALID_KGCO2E: 'Invalid KGCO2E',
                INVALID_KNOWLEDGE_FILE_ID: 'Invalid Knowledge File ID',
                INVALID_LATITUDE_VALUE: 'Invalid Latitude Value',
                INVALID_LEASE_NUMBER_VALUE: 'Invalid Lease Number Value',
                INVALID_LONGITUDE_VALUE: 'Invalid Longitude Value',
                INVALID_LOW_LIMIT_VALUE: 'Invalid Low Limit Value',
                INVALID_MASTER_METER_ID: 'Invalid Master Meter ID',
                INVALID_MENU_ID: 'Invalid Menu ID',
                INVALID_MESSAGE_TEMPLATE: 'Invalid Message Template',
                INVALID_METER_ID: 'Invalid Meter ID',
                INVALID_METER_NAME: 'Invalid Meter Name',
                INVALID_METER_UUID: 'Invalid Meter UUID',
                INVALID_NAME_VALUE: 'Invalid Name Value',
                INVALID_NEW_PASSWORD: 'Invalid New Password',
                INVALID_NOTIFICATION_ID: 'Invalid Notification ID',
                INVALID_NUMERATOR_METER_UUID: 'Invalid Numerator Meter UUID',
                INVALID_OBJECT_TYPE: 'Invalid Object Type',
                INVALID_OFFLINE_METER_FILE_ID: 'Invalid Offline Meter File ID',
                INVALID_OFFLINE_METER_ID: 'Invalid Offline Meter ID',
                INVALID_OFFLINE_METER_NAME: 'Invalid Offline Meter Name',
                INVALID_OLD_PASSWORD: 'Invalid Old Password',
                INVALID_PARENT_SPACE_ID: 'Invalid Parent Space ID',
                INVALID_PASSWORD: 'Invalid Password',
                INVALID_PEAK_CURRENT: 'Invalid Peak Current',
                INVALID_PEAK_LOAD: 'Invalid Peak Load',
                INVALID_PERIOD_TYPE: 'Invalid Period Type',
                INVALID_POINT_ID: 'Invalid Point ID',
                INVALID_POINT_NAME: 'Invalid Point Name',
                INVALID_PORT: 'Invalid Port',
                INVALID_PRIORITY: 'Invalid Priority',
                INVALID_PRIVILEGE: 'Invalid Privilege',
                INVALID_PRIVILEGE_DATA: 'Invalid Privilege Data',
                INVALID_PRIVILEGE_ID: 'Invalid Privilege ID',
                INVALID_PRIVILEGE_NAME: 'Invalid Privilege Name',
                INVALID_RATIO_VALUE: 'Invalid Ratio Value',
                INVALID_REPLY: 'Invalid Reply',
                INVALID_REPORTING_PERIOD_END_DATETIME: 'Invalid Reporting Period End Datetime',
                INVALID_REPORTING_PERIOD_START_DATETIME: 'Invalid Reporting Period Start Datetime',
                INVALID_REQUIRES_AUTHENTICATION: 'Invalid Requires Authentication',
                INVALID_ROOMS_VALUE: 'Invalid Rooms Value',
                INVALID_RULE_ID: 'Invalid Rule ID',
                INVALID_RULE_NAME: 'Invalid Rule Name',
                INVALID_SENSOR_ID: 'Invalid Sensor ID',
                INVALID_SENSOR_NAME: 'Invalid Sensor Name',
                INVALID_SERIAL_PORT: 'Invalid Serial Port',
                INVALID_SESSION_PLEASE_RE_LOGIN: 'Invalid Session Please Re-Login',
                INVALID_SHOPFLOOR_ID: 'Invalid Shopfloor ID',
                INVALID_SHOPFLOOR_NAME: 'Invalid Shopfloor Name',
                INVALID_SOURCE_NODE_ID: 'Invalid Source Node ID',
                INVALID_SPACE_ID: 'Invalid Space ID',
                INVALID_SPACE_NAME: 'Invalid Space Name',
                INVALID_START_DATE_FORMAT: 'Invalid Start Date Format',
                INVALID_START_DATETIME: 'Invalid Start Datetime',
                INVALID_STATUS: 'Invalid Status',
                INVALID_STORE_ID: 'Invalid Store ID',
                INVALID_STORE_NAME: 'Invalid Store Name',
                INVALID_STORE_TYPE_DESCRIPTION: 'Invalid Store Type Description',
                INVALID_STORE_TYPE_ID: 'Invalid Store Type ID',
                INVALID_STORE_TYPE_NAME: 'Invalid Store Type Name',
                INVALID_STORE_TYPE_SIMPLIFIED_CODE: 'Invalid Store Type Simplified Code',
                INVALID_SVG: 'Invalid SVG',
                INVALID_SWITCHGEAR: 'Invalid Switchgear',
                INVALID_TARGET_NODE_ID: 'Invalid Target Node ID',
                INVALID_TARIFF_BLOCK_PRICING: 'Invalid Tariff Block Pricing',
                INVALID_TARIFF_ID: 'Invalid Tariff ID',
                INVALID_TARIFF_TIME_OF_USE_PRICING: 'Invalid Tariff Time Of Use Pricing',
                INVALID_TARIFF_TYPE: 'Invalid Tariff Type',
                INVALID_TENANT_ID: 'Invalid Tenant ID',
                INVALID_TENANT_NAME: 'Invalid Tenant Name',
                INVALID_TENANT_TYPE_DESCRIPTION: 'Invalid Tenant Type Description',
                INVALID_TENANT_TYPE_ID: 'Invalid Tenant Type ID',
                INVALID_TENANT_TYPE_NAME: 'Invalid Tenant Type Name',
                INVALID_TENANT_TYPE_SIMPLIFIED_CODE: 'Invalid Tenant Type Simplified Code',
                INVALID_TEXT_MESSAGE_ID: 'Invalid Text Message ID',
                INVALID_TIMEZONE_ID: 'Invalid Timezone ID',
                INVALID_TOKEN: 'Invalid Token',
                INVALID_UNIT_OF_MEASURE: 'Invalid Unit Of Measure',
                INVALID_UNIT_OF_PRICE: 'Invalid Unit Of Price',
                INVALID_UNITS: 'Invalid Units',
                INVALID_USER_ID: 'Invalid User ID',
                INVALID_USER_NAME: 'Invalid User Name',
                INVALID_USER_NAME_OR_EMAIL: 'Invalid User Name Or Email',
                INVALID_USER_PHONE: 'Invalid User Phone',
                INVALID_USER_PLEASE_RE_LOGIN: 'Invalid User Please Re-Login',
                INVALID_USER_UUID: 'Invalid User UUID',
                INVALID_VARIABLE_METER_ID: 'Invalid Variable Meter ID',
                INVALID_VARIABLE_METER_TYPE: 'Invalid Variable Meter Type',
                INVALID_VARIABLE_NAME: 'Invalid Variable Name',
                INVALID_VIRTUAL_METER_ID: 'Invalid Virtual Meter ID',
                INVALID_VIRTUAL_METER_NAME: 'Invalid Virtual Meter Name',
                INVALID_WEB_MESSAGE_ID: 'Invalid Web Message ID',
                INVALID_WECHAT_MESSAGE_ID: 'Invalid Wechat Message ID',
                KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK: 'Knowledge File Cannot be Removed from Disk',
                KNOWLEDGE_FILE_NOT_FOUND: 'Knowledge File Not Found',
                MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY: 'Master Meter Does Not Belong To Same Energy Category',
                MASTER_METER_NOT_FOUND: 'Master Meter Not Found',
                MENU_NOT_FOUND: 'Menu Not Found',
                METER_NAME_IS_ALREADY_IN_USE: 'Meter Name Is Already In Use',
                METER_NOT_FOUND: 'Meter Not Found',
                METER_OF_VARIABLE_NOT_FOUND: 'Meter Of Variable Not Found',
                METER_POINT_RELATION_EXISTS: 'Meter Point Relation Exists',
                METER_POINT_RELATION_NOT_FOUND: 'Meter Point Relation Not Found',
                NOT_FOUND: 'Not Found',
                NOTIFICATION_NOT_FOUND: 'Notification Not Found',
                OFFLINE_METER_FILE_NOT_FOUND: 'Offline Meter File Not Found',
                OFFLINE_METER_NAME_IS_ALREADY_IN_USE: 'Offline Meter Name Is Already In Use',
                OFFLINE_METER_NOT_FOUND: 'Offline Meter Not Found',
                OFFLINE_METER_OF_VARIABLE_NOT_FOUND: 'Offline Meter Of Variable Not Found',
                PARENT_SPACE_NOT_FOUND: 'Parent Space Not Found',
                POINT_NAME_IS_ALREADY_IN_USE: 'Point Name Is Already In Use',
                POINT_NOT_FOUND: 'Point Not Found',
                PRIVILEGE_NAME_IS_ALREADY_IN_USE: 'Privilege Name Is Already In Use',
                PRIVILEGE_NOT_FOUND: 'Privilege Not Found',
                RULE_NAME_IS_ALREADY_IN_USE: 'Rule Name Is Already In Use',
                RULE_NOT_FOUND: 'Rule Not Found',
                SENSOR_NAME_IS_ALREADY_IN_USE: 'Sensor Name Is Already In Use',
                SENSOR_NOT_FOUND: 'Sensor Not Found',
                SENSOR_POINT_RELATION_EXISTS: 'Sensor Point Relation Exists',
                SENSOR_POINT_RELATION_NOT_FOUND: 'Sensor Point Relation Not Found',
                SHOPFLOOR_EQUIPMENT_RELATION_EXISTS: 'Shopfloor Equipment Relation Exists',
                SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND: 'Shopfloor Equipment Relation Not Found',
                SHOPFLOOR_METER_RELATION_EXISTS: 'Shopfloor Meter Relation Exists',
                SHOPFLOOR_METER_RELATION_NOT_FOUND: 'Shopfloor Meter Relation Not Found',
                SHOPFLOOR_NAME_IS_ALREADY_IN_USE: 'Shopfloor Name Is Already In Use',
                SHOPFLOOR_NOT_FOUND: 'Shopfloor Not Found',
                SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS: 'Shopfloor Offline Meter Relation Exists',
                SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND: 'Shopfloor Offline Meter Relation Not Found',
                SHOPFLOOR_POINT_RELATION_EXISTS: 'Shopfloor Point Relation Exists',
                SHOPFLOOR_POINT_RELATION_NOT_FOUND: 'Shopfloor Point Relation Not Found',
                SHOPFLOOR_SENSOR_RELATION_EXISTS: 'Shopfloor Sensor Relation Exists',
                SHOPFLOOR_SENSOR_RELATION_NOT_FOUND: 'Shopfloor Sensor Relation Not Found',
                SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS: 'Shopfloor Virtual Meter Relation Exists',
                SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND: 'Shopfloor Virtual Meter Relation Not Found',
                SOURCE_NODE_NOT_FOUND: 'Source Node Not Found',
                SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS: 'Space Combined Equipment Relation Exists',
                SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND: 'Space Combined Equipment Relation Not Found',
                SPACE_EQUIPMENT_RELATION_EXISTS: 'Space Equipment Relation Exists',
                SPACE_EQUIPMENT_RELATION_NOT_FOUND: 'Space Equipment Relation Not Found',
                SPACE_METER_RELATION_EXISTS: 'Space Meter Relation Exists',
                SPACE_METER_RELATION_NOT_FOUND: 'Space Meter Relation Not Found',
                SPACE_NAME_IS_ALREADY_IN_USE: 'Space Name Is Already In Use',
                SPACE_NOT_FOUND: 'Space Not Found',
                SPACE_NOT_FOUND_IN_PRIVILEGE: 'Space Not Found In Privilege',
                SPACE_OFFLINE_METER_RELATION_EXISTS: 'Space Offline Meter Relation Exists',
                SPACE_OFFLINE_METER_RELATION_NOT_FOUND: 'Space Offline Meter Relation Not Found',
                SPACE_POINT_RELATION_EXISTS: 'Space Point Relation Exists',
                SPACE_POINT_RELATION_NOT_FOUND: 'Space Point Relation Not Found',
                SPACE_SENSOR_RELATION_EXISTS: 'Space Sensor Relation Exists',
                SPACE_SENSOR_RELATION_NOT_FOUND: 'Space Sensor Relation Not Found',
                SPACE_SHOPFLOOR_RELATION_EXISTS: 'Space Shopfloor Relation Exists',
                SPACE_SHOPFLOOR_RELATION_NOT_FOUND: 'Space Shopfloor Relation Not Found',
                SPACE_STORE_RELATION_EXISTS: 'Space Store Relation Exists',
                SPACE_STORE_RELATION_NOT_FOUND: 'Space Store Relation Not Found',
                SPACE_TENANT_RELATION_EXISTS: 'Space Tenant Relation Exists',
                SPACE_TENANT_RELATION_NOT_FOUND: 'Space Tenant Relation Not Found',
                SPACE_VIRTUAL_METER_RELATION_EXISTS: 'Space Virtual Meter Relation Exists',
                SPACE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Space Virtual Meter Relation Not Found',
                START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME: 'Start Datetime Must Be Earlier Than End Datetime',
                STORE_METER_RELATION_EXISTS: 'Store Meter Relation Exists',
                STORE_METER_RELATION_NOT_FOUND: 'Store Meter Relation Not Found',
                STORE_NAME_IS_ALREADY_IN_USE: 'Store Name Is Already In Use',
                STORE_NOT_FOUND: 'Store Not Found',
                STORE_OFFLINE_METER_RELATION_EXISTS: 'Store Offline Meter Relation Exists',
                STORE_OFFLINE_METER_RELATION_NOT_FOUND: 'Store Offline Meter Relation Not Found',
                STORE_POINT_RELATION_EXISTS: 'Store Point Relation Exists',
                STORE_POINT_RELATION_NOT_FOUND: 'Store Point Relation Not Found',
                STORE_SENSOR_RELATION_EXISTS: 'Store Sensor Relation Exists',
                STORE_SENSOR_RELATION_NOT_FOUND: 'Store Sensor Relation Not Found',
                STORE_TYPE_NAME_IS_ALREADY_IN_USE: 'Store Type Name Is Already In Use',
                STORE_TYPE_NOT_FOUND: 'Store Type Not Found',
                STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Store Type Simplified Code Is Already In Use',
                STORE_TYPE_USED_IN_STORE: 'Store Type Used In Store',
                STORE_VIRTUAL_METER_RELATION_EXISTS: 'Store Virtual Meter Relation Exists',
                STORE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Store Virtual Meter Relation Not Found',
                TARGET_NODE_NOT_FOUND: 'Target Node Not Found',
                TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Already Associated With Cost Center',
                TARIFF_IN_USE: 'Tariff In Use',
                TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Not Associated With Cost Center',
                TARIFF_NAME_IS_ALREADY_IN_USE: 'Tariff Name Is Already In Use',
                TARIFF_NOT_EMPTY: 'Tariff Not Empty',
                TARIFF_NOT_FOUND: 'Tariff Not Found',
                TENANT_METER_RELATION_EXISTS: 'Tenant Meter Relation Exists',
                TENANT_METER_RELATION_NOT_FOUND: 'Tenant Meter Relation Not Found',
                TENANT_NAME_IS_ALREADY_IN_USE: 'Tenant Name Is Already In Use',
                TENANT_NOT_FOUND: 'Tenant Not Found',
                TENANT_OFFLINE_METER_RELATION_EXISTS: 'Tenant Offline Meter Relation Exists',
                TENANT_OFFLINE_METER_RELATION_NOT_FOUND: 'Tenant Offline Meter Relation Not Found',
                TENANT_POINT_RELATION_EXISTS: 'Tenant Point Relation Exists',
                TENANT_POINT_RELATION_NOT_FOUND: 'Tenant Point Relation Not Found',
                TENANT_SENSOR_RELATION_EXISTS: 'Tenant Sensor Relation Exists',
                TENANT_SENSOR_RELATION_NOT_FOUND: 'Tenant Sensor Relation Not Found',
                TENANT_TYPE_NAME_IS_ALREADY_IN_USE: 'Tenant Type Name Is Already In Use',
                TENANT_TYPE_NOT_FOUND: 'Tenant Type Not Found',
                TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Tenant Type Simplified Code Is Already In Use',
                TENANT_TYPE_USED_IN_TENANT: 'Tenant Type Used In Tenant',
                TENANT_VIRTUAL_METER_RELATION_EXISTS: 'Tenant Virtual Meter Relation Exists',
                TENANT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Tenant Virtual Meter Relation Not Found',
                TEXT_MESSAGE_NOT_FOUND: 'Text Message Not Found',
                THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES: 'The Reporting Period Must Be Longer Than 15 Minutes',
                THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS: 'There Is Associated Distribution Circuits',
                THERE_IS_RELATION_WITH_CHILD_METERS: 'There Is Relation With Child Meters',
                THERE_IS_RELATION_WITH_CHILDREN_SPACES: 'There Is Relation With Children Spaces',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS: 'There Is Relation With Combined Equipment Parameters',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS: 'There Is Relation With Combined Equipments',
                THERE_IS_RELATION_WITH_DATA_SOURCES: 'There Is Relation With Data Sources',
                THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS: 'There Is Relation With Energy Flow Diagram Links',
                THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS: 'There Is Relation With Equipment Parameters',
                THERE_IS_RELATION_WITH_EQUIPMENTS: 'There Is Relation With Equipments',
                THERE_IS_RELATION_WITH_METER: 'There Is Relation With Meter',
                THERE_IS_RELATION_WITH_METERS: 'There Is Relation With Meters',
                THERE_IS_RELATION_WITH_OFFLINE_METER: 'There Is Relation With Offline Meter',
                THERE_IS_RELATION_WITH_OFFLINE_METERS: 'There Is Relation With Offline Meters',
                THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS: 'There Is Relation With Other Virtual Meters',
                THERE_IS_RELATION_WITH_POINTS: 'There Is Relation With Points',
                THERE_IS_RELATION_WITH_SENSORS: 'There Is Relation With Sensors',
                THERE_IS_RELATION_WITH_SHOPFLOORS: 'There Is Relation With Shopfloors',
                THERE_IS_RELATION_WITH_SPACES: 'There Is Relation With Spaces',
                THERE_IS_RELATION_WITH_STORES: 'There Is Relation With Stores',
                THERE_IS_RELATION_WITH_TARIFFS: 'There Is Relation With Tariffs',
                THERE_IS_RELATION_WITH_TENANTS: 'There Is Relation With Tenants',
                THERE_IS_RELATION_WITH_VIRTUAL_METER: 'There Is Relation With Virtual Meter',
                THERE_IS_RELATION_WITH_VIRTUAL_METERS: 'There Is Relation With Virtual Meters',
                THERE_IS_RELATION_WITH_USERS: 'There Is Relation With Users',
                THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER: 'This Data Source Is Being Used By A Meter',
                THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Meter Is Being Used By A Virtual Meter',
                THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Offline Meter Is Being Used By A Virtual Meter',
                THIS_SHOPFLOOR_CANNOT_BE_DELETED: 'This Shopfloor Cannot Be Deleted',
                THIS_SPACE_CANNOT_BE_DELETED: 'This Space Cannot Be Deleted',
                TIMEZONE_NOT_FOUND: 'Timezone Not Found',
                TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'Token Not Found In Headers Please Login',
                USER_ACCOUNT_HAS_EXPIRED: 'User Account Has Expired',
                USER_NAME_IS_ALREADY_IN_USE: 'User Name Is Already In Use',
                USER_NOT_FOUND: 'User Not Found',
                USER_PASSWORD_HAS_EXPIRED: 'User Password Has Expired',
                USER_PRIVILEGE_NOT_FOUND: 'User Privilege Not Found',
                USER_SESSION_NOT_FOUND: 'User Session Not Found',
                USER_SESSION_TIMEOUT: 'User Session Timeout',
                USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'User UUID Not Found In Headers Please Login',
                VIRTUAL_METER_NAME_IS_ALREADY_IN_USE: 'Virtual Meter Name Is Already In Use',
                VIRTUAL_METER_NOT_FOUND: 'Virtual Meter Not Found',
                VIRTUAL_METER_OF_VARIABLE_NOT_FOUND: 'Virtual Meter Of Variable Not Found',
                VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE: 'Virtual Point Should Be Analog Value',
                WEB_MESSAGE_NOT_FOUND: 'Web Message Not Found',
                WECHAT_MESSAGE_NOT_FOUND: 'Wechat Message Not Found',
            },
        })
	    .translations('de', {
            MY_EMS_NAME: 'MyEMS',
            LANGUAGE: 'Sprache',
            FULLSCREEN: 'Vollbildanzeige',
            EXITFULLSCREEN: 'Beenden Sie den Vollbildmodus',
            LOGOUT: 'ausfallen',
            COMMON: {
                EXECUTE: 'durchgeführt',
                PLACEHOLDER: 'Bitte auswählen oder suchen ...',
                SPACE: 'Raum',
                EQUIPMENT: 'Ausrüstung',
                COMBINED_EQUIPMENT: 'Kombinationsausrüstung',
                TENANT: 'Mieter',
                STORE: 'Geschäft',
                SHOPFLOOR: 'Werkstatt',
                SENSOR: 'Sensor',
                ENERGY_FLOW_DIAGRAM: 'Energieflussdiagramm',
                MENU: 'Menü',
                DATE: 'Datum',
                TARIFF: {
                    TOPPEAK: 'Trinkgeld',
                    ONPEAK: 'Gipfel',
                    OFFPEAK: 'Senke',
                    MIDPEAK: 'Niveau'
                }
            },
            FDD: {
                ID: 'ID',
                RULE: 'Regel',
                EMAIL_MESSAGE: 'Mail-Informationen',
                TEXT_MESSAGE: 'SMS-Nachricht',
                WEB_MESSAGE: 'Webseiteninformationen',
                WECHAT_MESSAGE: 'WeChat Informationen',

                ALARM_LIST: 'Zeigen Sie die Alarmliste an',
                RULE_LIST: 'Liste der Regeln',
                ADD_RULE: 'Regel hinzufügen',
                EDIT_RULE: 'Regeln bearbeiten',
                FDD_CODE: 'Diagnosecode',
                CATEGORY: 'Diagnosekategorie',
                PRIORITY: 'Alarmpriorität',
                CHANNEL: 'Alarmkanal',
                IS_ENABLED: 'Alarmschalter',
                LAST_RUN_DATETIME: 'Letzter Lauf Datetime',
                NEXT_RUN_DATETIME: 'Nächster Lauf Datetime',
                EXPRESSION: 'Ausdruck',
                MESSAGE_TEMPLATE: 'Nachrichtenvorlage',
                CLICK_EDIT_FOR_DETAILS: 'Klicken Sie auf "Bearbeiten"',

                SMS_ALARM_LIST: 'SMS-Alarmliste',
                RECIPIENT_NAME: 'Empfänger',
                RECIPIENT_MOBILE: 'Telefonnummer',
                ALARM_MESSAGE: 'Alarminformationen',
                ALARM_TIME: 'Weckzeit',
                SCHEDULE_TIME: 'Geplante Sendezeit',
                ACKNOWLEDGE_CODE: 'Bestätigungscode',

                EMAIL_ALARM_LIST: 'Mail-Alarmliste',
                EMAIL: 'Briefkasten',
                TOPIC: 'Thema',
                ATTACHMENT_NAME: 'Zubehörname',
                ACKNOWLEDGE_MESSAGE: 'Bestätigungsmeldung',
                ACKNOWLEDGE: 'bestätigen',
                WEB_ALARM_LIST: 'Webseiten-Alarmliste',
                WECHAT_ALARM_LIST: 'WeChat Alarmliste',
                WECHAT_ID: 'Wir chatten Nummer',
                MESSAGE_FORMAT: 'Informationsformat',
                ACKNOWLEDGE_ALARM: 'Bestätigen Sie den Alarm?',
            },
            MENU: {
                SETTINGS: {
                    SETTINGS: 'Systemmanagement',
                    SPACE: 'Raum-Management',
                    TENANT: 'Mietermanagement',
                    STORE: 'Geschäftsleitung',
                    SHOPFLOOR: 'Werkstattmanagement',
                    EQUIPMENT: 'Gerätemanagement',
                    COMBINED_EQUIPMENT: 'Kombiniertes Gerätemanagement',
                    METER: 'Zählerverwaltung',
                    SENSOR: 'Sensorverwaltung',
                    GATEWAY: 'Gateway-Verwaltung',
                    DATASOURCE: 'Datenquellenverwaltung',
                    COSTCENTER: 'Kostenstellenmanagement',
                    PRODUCT: 'Produkt Management',
                    CATEGORY: 'Energieklassifizierungsmanagement',
                    ENERGY_FLOW_DIAGRAM: 'Energieflussdiagramm-Management',
                    DISTRIBUTION_SYSTEM: 'Verwaltung des Verteilungssystems',
                    MENU: 'Verwaltung des Menüs',
                    TARIFF: 'Energieratenmanagement',
                    EMAIL_SERVER: 'Mailserver-Einstellungen',
                    CONTACT: 'Kontaktmanagement',
                    KNOWLEDGEFILE: 'Wissensdatenbankverwaltung'
                },
                FDD: {
                    FDD: 'Fehlererkennung und -diagnose',
                    RULE: 'Regelverwaltung',
                    MESSAGEALARM: 'SMS-Alarm',
                    EMAILALARM: 'E-Mail-Alarm',
                    WEBALARM: 'Webseitenalarm',
                    WECHATALARM: 'WeChat Alarm',
                },
                USERSETTING: {
                    USERSETTING: 'Benutzer und Berechtigungen',
                    USER: 'Benutzereinstellungen',
                    PRIVILEGE: 'Berechtigungseinstellungen'
                }
            },
            LOGIN: {
                USERLOGIN: 'Benutzer-Anmeldung',
                USERNAME: 'Nutzername',
                PASSWORD: 'Passwort',
                LOGIN: 'Einloggen',
                TITLE: 'Energiemanagementsystem',
            },
            SETTING: {
                KNOWLEDGEFILE: 'Wissensdatei',
                ID: 'ID',
                ACTION: 'Betriebs',
                ADD: 'Hinzufügen',
                BIND_PROPERTY: 'Bindungseigenschaften',
                EDIT: 'ändern',
                DELETE: 'löschen',
                SELECT: 'wählen',
                RESET: 'Zurücksetzen',
                SAVE: 'speichern',
                CANCEL: 'stornieren',
                DOWNLOAD: 'herunterladen',
                REFRESH: 'Aktualisierung',
                RETURN: 'Rückkehr',
                YES: 'Ja',
                NO: 'Nein',
                ON: 'anmachen',
                OFF: 'Herunterfahren',
                OK: 'bestimmen',
                OPTIONAL: 'Optional',
                ADD_SPACE: 'Platz hinzufügen',
                ADD_TENANT: 'Mieter hinzufügen',
                ADD_STORE: 'Laden hinzufügen',
                ADD_METER: 'Messgerät hinzufügen',
                ADD_VIRTUAL_METER: 'Virtuelle Meter hinzufügen',
                ADD_OFFLINE_METER: 'Offline Meter hinzufügen',
                ADD_POINT: 'Punkt hinzufügen',
                ADD_COSTCENTER: 'Kostenstelle hinzufügen',
                ADD_TARIFF: 'Rate hinzufügen',
                ADD_CATEGORY: 'Energieklassifizierung hinzufügen',
                ADD_ENERGY_ITEM: 'Unterelemente zum Energieverbrauch hinzufügen',
                ADD_CONTACT: 'Kontakt hinzufügen',
                ADD_EMAIL_SERVER: 'Mail-Server hinzufügen',

                EDIT_SPACE: 'Leerzeichen bearbeiten',
                EDIT_TENANT: 'Mieter bearbeiten',
                EDIT_STORE: 'Speicher bearbeiten',
                EDIT_METER: 'Messgerät bearbeiten',
                EDIT_VIRTUAL_METER: 'Virtuelle Meter bearbeiten',
                EDIT_OFFLINE_METER: 'Offline Meter bearbeiten',
                EDIT_POINT: 'Punkt bearbeiten',
                EDIT_COSTCENTER: 'Kostenstelle bearbeiten',
                EDIT_TARIFF: 'Bearbeitungsrate',
                EDIT_CATEGORY: 'Energieklassifizierung bearbeiten',
                EDIT_ENERGY_ITEM: 'Unterelemente zum Energieverbrauch bearbeiten',
                EDIT_CONTACT: 'Kontakt bearbeiten',
                EDIT_EMAIL_SERVER: 'Postfachserver bearbeiten',

                REQUIRES_AUTHENTICATION: 'Authentifizierung erforderlich',
                SELECT_DATE: 'Bitte wählen Sie ein Datum',
                SELECT_SPACE: 'Bitte wählen Sie ein Leerzeichen',
                SELECT_TENANT: 'Bitte Mieter auswählen',
                SELECT_STORE: 'Bitte wählen Sie ein Geschäft',
                SELECT_TIMEZONE: 'Bitte wählen Sie eine Zeitzone',
                SELECT_CATEGORY: 'Bitte wählen Sie die Energieklassifizierung',
                SELECT_ENERGY_ITEM: 'Bitte wählen Sie den Energieverbrauch',
                SELECT_COSTCENTER: 'Bitte wählen Sie eine Kostenstelle',
                SELECT_METER: 'Bitte wählen Sie einen Zähler',
                IS_INPUT_COUNTED: 'Zusammenfassung der Verbrauchsbeteiligung',
                IS_OUTPUT_COUNTED: 'Zusammenfassung der Beteiligung an der Energieabgabe',
                BIND_METER: 'Bindemessgerät',
                BIND_POINT: 'Datenpunkte binden',
                BIND_SENSOR: 'Bindungssensor',
                BIND_TARIFF: 'Bindungsrate',

                INPUT_NAME: 'Bitte geben Sie einen Namen ein',
                INPUT_AREA: 'Bitte betreten Sie den Bereich',
                INPUT_UNIT: 'Bitte geben Sie eine Einheit ein',
                INPUT_CONTACT: 'Bitte geben Sie einen Kontakt ein',
                INPUT_EXPRESSION: 'Bitte geben Sie einen Ausdruck ein',
                INPUT_KGCE: 'Bitte geben Sie den Kilogramm Standardkohle ein',
                INPUT_KGCO2E: 'Bitte geben Sie Kilogramm Kohlendioxid-Emissionen ein',
                INPUT_HOST: 'Bitte geben Sie den Server ein',
                INPUT_PORT: 'Bitte geben Sie die Portnummer ein',
                INPUT_USER_NAME: 'Bitte geben sie einen Benutzernamen ein',
                INPUT_FROM_ADDR: 'Bitte geben Sie die Absenderadresse ein',
                INPUT_SERIAL_PORT: 'Bitte geben Sie die serielle Schnittstelle ein',
                INPUT_BAUD_RATE: 'Bitte geben Sie die Baudrate ein',

                EMAIL_SERVER: 'Mail-Server',
                INVALID_FORMAT: 'Falsches Format',
                INVALID_FROM_ADDR: 'Falsche Absenderadresse',
                INVALID_BAUD_RATE: 'Falsche Baudrate',
                NOT_NULLABLE: 'Darf nicht leer sein',
                METER: 'Meter',
                VIRTUAL_METER: 'Virtuelle Meter',
                OFFLINE_METER: 'Offline Meter',
                OFFLINE_METER_FILE: 'Offline Meter Datei',
                PRODUCT: 'Produkt',
                N_S_METER: 'Gebundener Tisch',
                N_S_POINT: 'Gebundener Datenpunkt',
                N_S_SENSOR: 'Gebundener Sensor',
                N_S_TARIFF: 'Gebundene Rate',
                TARIFF_LIST: 'Preisliste',
                POINT_LIST: 'Datenpunktliste',
                SENSOR_LIST: 'Sensorliste',
                METER_TYPE: 'Zählertyp',
                METER_NAME: 'Zählername',
                TRASH: 'recyceln können',
                DRAG_TO_BIND: 'Bitte ziehen und ablegen, um die Bindung abzuschließen',
                DRAG_TO_UNBIND: 'Bitte ziehen Sie in den Papierkorb, um die Bindung aufzuheben',
                COST_FILE: 'Datei der Kosten',
                NAME: 'Name',
                AREA: 'Bereich',
                UNIT: 'Einheit',
                CONTACT: 'Gesprächspartner',
                TIMEZONE: 'Zeitzone',
                TARIFF: 'Bewertung',

                COSTCENTER: 'Kostenstelle',
                CATEGORY: 'Energieklassifizierung',
                ENERGY_ITEM: 'Unterpunkt Energieverbrauch',
                STATUS: 'Status',
                UPLOAD_TIME: 'Upload-Zeit',
                EXPRESSION: 'Ausdruck',
                VARIABLE_NAME: 'Variablennamen',
                POINT: 'Datenpunkt',
                KGCE: 'Kilogramm Standardkohle',
                KGCO2E: 'Kilogramm CO2-Emission',

                START_DATETIME: 'Startzeit',
                START_TIME: 'Anfangszeit',
                END_DATETIME: 'Endzeit',
                END_TIME: 'Endzeit',
                TARIFF_TYPE: 'Tarifart',
                TARIFF_NAME: 'Name',
                PRICE: 'Preis',
                BLOCK: 'Staffelpreis',
                TIMEOFUSE: 'Timesharing-Rate',
                PEAK_TYPE: 'Peaktyp',
                START_AMOUNT: 'Startbetrag',
                END_AMOUNT: 'Endbetrag',

                PORT: 'Hafen',
                SMS: 'SMS',
                SERIAL_PORT: 'Adresse der seriellen Schnittstelle',
                BAUD_RATE: 'Baudrate',
                FROM_ADDR: 'Absenderadresse',
                HOST: 'Server',
                USER_NAME: 'Nutzername',

                USER: 'Nutzer',

                SEARCH: 'suchen nach...',

                RESTORE: 'wiederherstellen',
                RESTORE_SUCCESS: 'Erfolgreiche Genesung',
                RESTORE_FAILED: 'Wiederherstellung fehlgeschlagen',

                SELECT_MENU: 'Menü auswählen',
                CURRENT_SELECTED_MENU: 'Aktuelles Menü',
                PARENT_MENU: 'Superior Menü',
                IS_HIDDEN: 'Ist versteckt',
                CHILD_MENUS: 'Unteres Menü',
                EDIT_MENU: 'Menü bearbeiten'
            },
            CONTACT: {
                EMAIL: 'Briefkasten',
                PHONE: 'Telefon',
                DESCRIPTION: 'Beschreibung',
                INPUT_EMAIL: 'Bitte geben Sie Ihre E-Mail-Adresse ein',
                INPUT_PHONE: 'Bitte geben Sie das Telefon ein',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                INVALID_EMAIL: 'Falsches E-Mail-Format (xxx@xxx.xx)',
            },
            COSTCENTER: {
                EXTERNAL_ID: 'Externe ID',
                INPUT_EXTERNAL_ID: 'Bitte geben Sie eine externe ID ein',
            },
            GATEWAY: {
                GATEWAY: 'Tor',
                TOKEN: 'Token',
                LAST_SEEN_DATETIME: 'Zuletzt gesehen datetime',
                SELECT_GATEWAY: 'Wählen Sie ein Gateway',
                ADD_GATEWAY: 'Gateway hinzufügen',
                EDIT_GATEWAY: 'Gateway bearbeiten',
            },
            DATA_SOURCE: {
                DATA_SOURCE: 'Datenquelle',
                ADD_DATA_SOURCE: 'Datenquelle hinzufügen',
                EDIT_DATA_SOURCE: 'Datenquelle bearbeiten',
                SELECT_DATA_SOURCE: 'Bitte wählen Sie die Datenquelle',
                PROTOCOL: 'Protokoll',
                CONNECTION: 'Verbindung',
                LAST_SEEN_DATETIME: 'Zuletzt gesehen datetime',
                INPUT_PROTOCOL: 'Bitte geben Sie den Protokolltyp ein',
                INPUT_CONNECTION: 'Bitte geben Sie die Verbindungsadresse ein',
            },
            POINT: {
                OBJECT_TYPE: 'Objekttyp',
                UNIT: 'Einheit',
                HIGH_LIMIT: 'Obergrenze',
                LOW_LIMIT: 'Untergrenze',
                RATIO: 'Skalierungsfaktor',
                IS_TREND: 'Trend speichern',
                IS_VIRTUAL: 'Virtueller Punkt',
                ADDRESS: 'Adresse (JSON)',
                DESCRIPTION: 'Beschreibung',
                INPUT_HIGH_LIMIT: 'Bitte geben Sie das obere Limit ein',
                INPUT_LOW_LIMIT: 'Bitte geben Sie die Untergrenze ein',
                INPUT_RATIO: 'Bitte geben Sie den Skalierungsfaktor ein',
                INPUT_ADDRESS: 'Bitte geben Sie die Adresse ein',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
            },
            DISTRIBUTION_SYSTEM: {
                DISTRIBUTION_SYSTEM: 'Vertriebssystem',
                ADD_DISTRIBUTION_SYSTEM: 'Stromverteilungssystem hinzufügen',
                EDIT_DISTRIBUTION_SYSTEM: 'Stromverteilungssystem bearbeiten',
                SELECT_DISTRIBUTION_SYSTEM: 'Bitte wählen Sie das Stromverteilungssystem',
                SVG: 'SVG',
                INPUT_SVG: 'Bitte geben Sie SVG ein',
                DESCRIPTION: 'Beschreibung',
                DISTRIBUTION_CIRCUIT: 'Verteilerkreis',
                N_S_DISTRIBUTION_CIRCUIT: 'Eigener Verteilerkreis',
                ADD_DISTRIBUTION_CIRCUIT: 'Verteilerkreis hinzufügen',
                EDIT_DISTRIBUTION_CIRCUIT: 'Stromverteilungskreis bearbeiten',
                SELECT_DISTRIBUTION_CIRCUIT: 'Bitte wählen Sie den Verteilerkreis',
                DISTRIBUTION_CIRCUIT_ID: 'ID',
                DISTRIBUTION_CIRCUIT_NAME: 'Name',
                INPUT_DISTRIBUTION_CIRCUIT_NAME: 'Bitte geben Sie einen Namen ein',
                DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: 'Stromverteilungsraum',
                INPUT_DISTRIBUTION_CIRCUIT_DISTRIBUTION_ROOM: 'Bitte betreten Sie den Stromverteilungsraum',
                DISTRIBUTION_CIRCUIT_SWITCHGEAR: 'Verteilerschrank',
                INPUT_DISTRIBUTION_CIRCUIT_SWITCHGEAR: 'Bitte betreten Sie den Stromverteilungsschrank',
                DISTRIBUTION_CIRCUIT_PEAK_LOAD: 'Maximale Kapazität (KW)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_LOAD: 'Bitte geben Sie die maximale Kapazität (KW) ein',
                DISTRIBUTION_CIRCUIT_PEAK_CURRENT: 'Maximaler Strom (A)',
                INPUT_DISTRIBUTION_CIRCUIT_PEAK_CURRENT: 'Bitte geben Sie den Maximalstrom ein (A)',
                DISTRIBUTION_CIRCUIT_CUSTOMERS: 'Nutzer',
                INPUT_DISTRIBUTION_CIRCUIT_CUSTOMERS: 'Bitte geben Sie den Benutzer ein',
                DISTRIBUTION_CIRCUIT_METERS: 'Ausgehender Zähler',
                INPUT_DISTRIBUTION_CIRCUIT_METERS: 'Bitte geben Sie den Auslasszähler ein',
                PREVIEW: 'Vorschau',
                N_S_PREVIEW: 'Vorschau',
            },
            ENERGY_FLOW_DIAGRAM: {
                ADD_ENERGY_FLOW_DIAGRAM: 'Energieflussdiagramm hinzufügen',
                EDIT_ENERGY_FLOW_DIAGRAM: 'Energieflussdiagramm bearbeiten',
                SELECT_ENERGY_FLOW_DIAGRAM: 'Bitte wählen Sie das Energieflussdiagramm',
                NODE: 'Knoten',
                N_S_NODE: 'Knoten besitzen',
                ADD_NODE: 'Knoten hinzufügen',
                EDIT_NODE: 'Knoten bearbeiten',
                NODE_ID: 'Knoten-ID',
                NODE_NAME: 'Knotenname',
                INPUT_NODE_NAME: 'Bitte geben Sie den Knotennamen ein',
                LINK: 'Verknüpfung',
                N_S_LINK: 'Zugehörigkeit zum Link',
                LINK_ID: 'Link ID',
                ADD_LINK: 'Fügen Sie einen Link hinzu',
                EDIT_LINK: 'Link bearbeiten',
                SOURCE_NODE: 'Quellknoten',
                TARGET_NODE: 'Zielknoten',
                METER: 'Meter',
                PREVIEW: 'Vorschau',
                N_S_PREVIEW: 'Vorschau',
            },
            COMBINED_EQUIPMENT: {
                ADD_COMBINED_EQUIPMENT: 'Fügen Sie ein Kombinationsgerät hinzu',
                EDIT_COMBINED_EQUIPMENT: 'Kombinationsgerät bearbeiten',
                SELECT_COMBINED_EQUIPMENT: 'Bitte wählen Sie ein Kombinationsgerät',
                COST_CENTER: 'Kostenstelle',
                SELECT_COST_CENTER: 'Bitte wählen Sie eine Kostenstelle',
                DESCRIPTION: 'Beschreibung',
                BIND_EQUIPMENT: 'Gerät binden',
                N_S_EQUIPMENT: 'Gebundenes Gerät',
                EQUIPMENT_LIST: 'Geräteliste',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                INPUT_METER: 'Input Meter',
                OUTPUT_METER: 'Output Meter',
                PARAMETER: 'Parameter',
                BIND_PARAMETER: 'Bindungsparameter',
                ADD_PARAMETER: 'Parameter hinzufügen',
                EDIT_PARAMETER: 'Parameter bearbeiten',
                N_S_PARAMETER: 'Enthaltene Parameter',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: 'Name',
                INPUT_PARAMETER_NAME: 'Bitte geben Sie einen Namen ein',
                PARAMETER_TYPE: 'Arten von',
                SELECT_PARAMETER_TYPE: 'Wählen Sie einen Typ',
                CONSTANT: 'Konstanter Wert',
                POINT: 'Datenpunkt',
                SELECT_POINT: 'Datenpunkt auswählen',
                FRACTION: 'Fraktion',
                PARAMETER_CONSTANT: 'Konstante',
                PARAMETER_POINT: 'Datenpunkt',
                PARAMETER_NUMERATOR_METER: 'Molekularmessgerät',
                PARAMETER_DENOMINATOR_METER: 'Nenner Meter',
            },
            EQUIPMENT: {
                ADD_EQUIPMENT: 'Gerät hinzufügen',
                EDIT_EQUIPMENT: 'Gerät bearbeiten',
                SELECT_EQUIPMENT: 'Bitte wählen Sie ein Gerät',
                COST_CENTER: 'Kostenstelle',
                SELECT_COST_CENTER: 'Bitte wählen Sie eine Kostenstelle',
                DESCRIPTION: 'Beschreibung',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                INPUT_METER: 'Input Meter',
                OUTPUT_METER: 'Output Meter',
                PARAMETER: 'Parameter',
                BIND_PARAMETER: 'Bindungsparameter',
                ADD_PARAMETER: 'Parameter hinzufügen',
                EDIT_PARAMETER: 'Parameter bearbeiten',
                N_S_PARAMETER: 'Enthaltene Parameter',
                PARAMETER_ID: 'ID',
                PARAMETER_NAME: 'Name',
                INPUT_PARAMETER_NAME: 'Bitte geben Sie einen Namen ein',
                PARAMETER_TYPE: 'Arten von',
                SELECT_PARAMETER_TYPE: 'Wählen Sie einen Typ',
                CONSTANT: 'Konstanter Wert',
                POINT: 'Datenpunkt',
                SELECT_POINT: 'Datenpunkt auswählen',
                FRACTION: 'Fraktion',
                PARAMETER_CONSTANT: 'Konstante',
                PARAMETER_POINT: 'Datenpunkt',
                PARAMETER_NUMERATOR_METER: 'Molekularmessgerät',
                PARAMETER_DENOMINATOR_METER: 'Nenner Meter',
            },
            SPACE: {
                PARENT_SPACE: 'Überlegen',
                AREA: 'Bereich',
                INPUT_AREA: 'Bitte betreten Sie den Bereich',
                DESCRIPTION: 'Beschreibung',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                CURRENT_SELECTED_SPACE: 'Derzeit ausgewählter Platz',
                CHILD_SPACES: 'Unterraum',
                BIND_COMBINED_EQUIPMENT: 'Kombinationsgerät binden',
                N_S_COMBINED_EQUIPMENT: 'Gebundenes Kombinationsgerät',
                COMBINED_EQUIPMENT_LIST: 'Liste der Kombinationsgeräte',
                BIND_EQUIPMENT: 'Gerät binden',
                N_S_EQUIPMENT: 'Gebundenes Gerät',
                EQUIPMENT_LIST: 'Geräteliste',
                BIND_TENANT: 'Mieter binden',
                N_S_TENANT: 'Gebundener Mieter',
                TENANT_LIST: 'Mieterliste',
                BIND_STORE: 'Laden binden',
                N_S_STORE: 'Gebundener Laden',
                STORE_LIST: 'Liste speichern',
                BIND_SHOPFLOOR: 'Bindungswerkstatt',
                N_S_SHOPFLOOR: 'Gebundene Werkstatt',
                SHOPFLOOR_LIST: 'Werkstattliste',
            },
            TENANT: {
                BUILDINGS: 'Gebäude',
                FLOORS: 'Fußboden',
                ROOMS: 'Zimmer',
                TYPE: 'Mietertyp',
                IS_KEY_TENANT: 'Ob der Hauptmieter',
                LEASE_NUMBER: 'Mietnummer',
                LEASE_START_DATETIME: 'Datum und Uhrzeit des Mietbeginns',
                LEASE_END_DATETIME: 'Datum und Uhrzeit des Leasingendes',
                IS_IN_LEASE: 'Mieten Sie?',
                DESCRIPTION: 'Beschreibun',
                INPUT_BUILDINGS: 'Bitte betreten Sie das Gebäude',
                INPUT_FLOORS: 'Bitte betreten Sie den Boden',
                INPUT_ROOMS: 'Bitte betreten Sie den Raum',
                INPUT_LEASE_NUMBER: 'Bitte geben Sie die Mietnummer ein',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
            },
            STORE: {
                ADDRESS: 'Adresse',
                LATITUDE: 'Breite',
                LONGITUDE: 'Längengrad',
                TYPE: 'Speichertyp',
                DESCRIPTION: 'Beschreibung',
                INPUT_ADDRESS: 'Bitte geben Sie die Adresse ein',
                INPUT_LATITUDE: 'Bitte geben Sie den Breitengrad ein',
                INPUT_LONGITUDE: 'Bitte geben Sie den Längengrad ein',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
            },
            SHOPFLOOR: {
                ADD_SHOPFLOOR: 'Workshop hinzufügen',
                EDIT_SHOPFLOOR: 'Bearbeitungsworkshop',
                SELECT_SHOPFLOOR: 'Bitte Workshop auswählen',
                AREA: 'Bereich',
                INPUT_AREA: 'Bitte betreten Sie den Bereich',
                DESCRIPTION: 'Beschreibung',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                BIND_EQUIPMENT: 'Gerät binden',
                N_S_EQUIPMENT: 'Gebundenes Gerät',
                EQUIPMENT_LIST: 'Geräteliste',
            },
            METER: {
                HOURLY_LOW_LIMIT: 'Stündliches Minimum (inklusive)',
                INPUT_HOURLY_LOW_LIMIT: 'Bitte geben Sie das stündliche Minimum ein',
                HOURLY_HIGH_LIMIT: 'Stundenmaximum (inklusive)',
                INPUT_HOURLY_HIGH_LIMIT: 'Bitte geben Sie das Stundenmaximum ein',
                DESCRIPTION: 'Beschreibung',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                MASTER_METER: 'Überlegenes Messgerät',
                SELECT_MASTER_METER: 'Wählen Sie das übergeordnete Messgerät aus',
                TREE_VIEW: 'Baumsicht',
                CHILD_METERS: 'Unterer Füllstandsmesser',
            },
            SENSOR: {
                ADD_SENSOR: 'Sensor hinzufügen',
                EDIT_SENSOR: 'Sensor bearbeiten',
                DELETE_SENSOR: 'Sensor entfernen',
                DESCRIPTION: 'Beschreibung',
                INPUT_DESCRIPTION: 'Bitte geben Sie eine Beschreibung ein',
                SELECT_SENSOR: 'Sensor auswählen',
            },
            USER: {
                USER_LIST: 'Benutzerliste',
                PRIVILEGE_LIST: 'Berechtigungsliste',
                ADD_USER: 'Nutzer hinzufügen',
                EDIT_USER: 'Benutzer bearbeiten',
                PRIVILEGE: 'Behörde',
                ADD_PRIVILEGE: 'Berechtigungen hinzufügen',
                EDIT_PRIVILEGE: 'Berechtigungen bearbeiten',
                IS_ADMIN: 'Ist ein Administrator',
                DISPLAY_NAME: 'Anzeigename',
                USERNAME: 'Nutzername',
                PASSWORD: 'Passwort',
                RESET_PASSWORD: 'Passwort zurücksetzen',
                CHANGE_PASSWORD: 'ändere das Passwort',
                OLD_PASSWORD: 'Altes Passwort',
                NEW_PASSWORD: 'Neues Passwort',
                CONFIRM_PASSWORD: 'Kennwort bestätigen',
                INPUT_PASSWORD: 'Bitte geben Sie das Passwort ein',
                DIFF_PASSWORD: 'Die beiden eingegebenen Passwörter stimmen nicht überein',
                EMAIL: 'Briefkasten',
                INPUT_EMAIL: 'Bitte geben Sie Ihre E-Mail-Adresse ein',
                INVALID_EMAIL: 'Falsches E-Mail-Format (xxx@xxx.xx)',
                ACCOUNT_EXPIRATION_DATETIME: 'Ablaufdatum des Kontos',
                PASSWORD_EXPIRATION_DATETIME: 'Ablaufdatum des Passworts',
            },
            KNOWLEDGEFILE: {
                KNOWLEDGE_FILE_LIST: 'Liste der Wissensdateien',
                UPLOAD_USER: 'hochgeladen von',
                UPLOAD_TIME: 'Upload-Zeit',
                DELETE: 'löschen',
            },
            TOASTER: {
                SUCCESS_TITLE: 'Erfolg',
                LOGIN_SUCCESS: 'Anmeldung erfolgreich',
                LOGIN_FAILURE: 'Login fehlgeschlagen',
                LOGOUT_SUCCESS: 'Abmeldung erfolgreich',
                LOGOUT_FAILURE: 'Abmeldefehler',

                SUCCESS_ADD_BODY: 'Fügen Sie {{template}} erfolgreich hinzu',
                SUCCESS_UPDATE_BODY: 'Update {{template}} erfolgreich',
                SUCCESS_DELETE_BODY: '{{Template}} erfolgreich löschen',
                ERROR_ADD_BODY: 'Das Hinzufügen von {{template}} ist fehlgeschlagen',
                ERROR_UPDATE_BODY: 'Update {{template}} fehlgeschlagen',
                ERROR_DELETE_BODY: 'Fehler beim Löschen von {{template}}',

                USER_PASSWORD: 'Benutzer-Passwort',
                BIND_METER_SUCCESS: 'Binden Sie das Messgerät erfolgreich',
                UNBIND_METER_SUCCESS: 'Binden Sie das Messgerät erfolgreich ab',
                BIND_TARIFF_SUCCESS: 'Bindungsrate ist erfolgreich',
                UNBIND_TARIFF_SUCCESS: 'Lösen Sie die Rate erfolgreich',
                BIND_POINT_SUCCESS: 'Binden Sie den Datenpunkt erfolgreich',
                UNBIND_POINT_SUCCESS: 'Datenpunkt erfolgreich binden',
                BIND_SENSOR_SUCCESS: 'Binden Sie den Sensor erfolgreich',
                UNBIND_SENSOR_SUCCESS: 'Binden Sie den Sensor erfolgreich ab',
                BIND_EQUIPMENT_SUCCESS: 'Binden Sie das Gerät erfolgreich',
                UNBIND_EQUIPMENT_SUCCESS: 'Binden Sie das Gerät erfolgreich ab',
                BIND_COMBINED_EQUIPMENT_SUCCESS: 'Binden Sie das kombinierte Gerät erfolgreich',
                UNBIND_COMBINED_EQUIPMENT_SUCCESS: 'Binden Sie das kombinierte Gerät erfolgreich ab',
                BIND_TENANT_SUCCESS: 'Mieter erfolgreich binden',
                UNBIND_TENANT_SUCCESS: 'Den Mieter erfolgreich binden',
                BIND_STORE_SUCCESS: 'Binden Sie den Laden erfolgreich',
                UNBIND_STORE_SUCCESS: 'Binden Sie den Laden erfolgreich auf',
                BIND_SHOPFLOOR_SUCCESS: 'Bindungswerkstatt erfolgreich',
                UNBIND_SHOPFLOOR_SUCCESS: 'Lösen Sie den Workshop erfolgreich',
            },
            SWEET: {
                TITLE: 'Bitte bestätigen, um zu löschen?',
                TEXT: 'Durch Löschen dieses Artikels werden auch alle zugehörigen Daten gelöscht!',
                CONFIRM_BUTTON_TEXT: 'Löschung bestätigen',
                CANCEL_BUTTON_TEXT: 'stornieren',
            },
            API: {
                ADMINISTRATOR_SESSION_NOT_FOUND: 'Administrator Session Not Found',
                ADMINISTRATOR_SESSION_TIMEOUT: 'Administrator Session Timeout',
                ADVANCED_REPORT_NOT_FOUND: 'Advanced Report Not Found',
                BAD_REQUEST: 'Bad Request',
                CANNOT_SET_EXISTING_SUBMETER_AS_MASTER_METER: 'Cannot Set Existing Submeter As Master Meter',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_EXISTS: 'Combined Equipment Equipment Relation Exists',
                COMBINED_EQUIPMENT_EQUIPMENT_RELATION_NOT_FOUND: 'Combined Equipment Equipment Relation Not Found',
                COMBINED_EQUIPMENT_METER_RELATION_EXISTS: 'Combined Equipment Meter Relation Exists',
                COMBINED_EQUIPMENT_METER_RELATION_NOT_FOUND: 'Combined Equipment Meter Relation Not Found',
                COMBINED_EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Name Is Already In Use',
                COMBINED_EQUIPMENT_NOT_FOUND: 'Combined Equipment Not Found',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Combined Equipment Offline Meter Relation Exists',
                COMBINED_EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Combined Equipment Offline Meter Relation Not Found',
                COMBINED_EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Combined Equipment Parameter Name Is Already In Use',
                COMBINED_EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Combined Equipment Parameter Not Found Or Not Match',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Combined Equipment Virtual Meter Relation Exists',
                COMBINED_EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Combined Equipment Virtual Meter Relation Not Found',
                CONTACT_NAME_IS_ALREADY_IN_USE: 'Contact Name Is Already In Use',
                CONTACT_NOT_FOUND: 'Contact Not Found',
                COST_CENTER_EXTERNAL_ID_EXISTS: 'Cost Center External ID Exists',
                COST_CENTER_NAME_EXISTS: 'Cost Center Name Exists',
                COST_CENTER_NOT_FOUND: 'Cost Center Not Found',
                COST_FILE_NOT_FOUND: 'Cost File Not Found',
                DATA_SOURCE_NAME_IS_ALREADY_IN_USE: 'Data Source Name Is Already In Use',
                DATA_SOURCE_NOT_FOUND: 'Data Source Not Found',
                DATABASE_ERROR: 'Database Error',
                DISTRIBUTION_CIRCUIT_NAME_IS_ALREADY_IN_USE: 'Distribution Circuit Name Is Already In Use',
                DISTRIBUTION_CIRCUIT_NOT_FOUND: 'Distribution Circuit Not Found',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_EXISTS: 'Distribution Circuit Point Relation Exists',
                DISTRIBUTION_CIRCUIT_POINT_RELATION_NOT_FOUND: 'Distribution Circuit Point Relation Not Found',
                DISTRIBUTION_SYSTEM_NAME_IS_ALREADY_IN_USE: 'Distribution System Name Is Already In Use',
                DISTRIBUTION_SYSTEM_NOT_FOUND: 'Distribution System Not Found',
                EMAIL_IS_ALREADY_IN_USE: 'Email Is Already In Use',
                EMAIL_MESSAGE_NOT_FOUND: 'Email Message Not Found',
                EMAIL_SERVER_HOST_IS_ALREADY_IN_USE: 'Email Server Host Is Already In Use',
                EMAIL_SERVER_NOT_FOUND: 'Email Server Not Found',
                EMPTY_VARIABLES_ARRAY: 'Empty Variables Array',
                ENERGY_CATEGORY_NAME_IS_ALREADY_IN_USE: 'Energy Category Name Is Already In Use',
                ENERGY_CATEGORY_NOT_FOUND: 'Energy Category Not Found',
                ENERGY_CATEGORY_USED_IN_ENERGY_ITEMS: 'Energy Category Used In Energy Items',
                ENERGY_CATEGORY_USED_IN_METER: 'Energy Category Used In Meter',
                ENERGY_CATEGORY_USED_IN_OFFLINE_METER: 'Energy Category Used In Offline Meter',
                ENERGY_CATEGORY_USED_IN_TARIFFS: 'Energy Category Used In Tariffs',
                ENERGY_CATEGORY_USED_IN_VIRTUAL_METER: 'Energy Category Used In Virtual Meter',
                ENERGY_FLOW_DIAGRAM_LINK_IS_ALREADY_IN_USE: 'Energy Flow Diagram Link Is Already In Use',
                ENERGY_FLOW_DIAGRAM_LINK_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Link Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NAME_IS_ALREADY_IN_USE: 'Energy Flow Diagram Node Name Is Already In Use',
                ENERGY_FLOW_DIAGRAM_NODE_NOT_FOUND_OR_NOT_MATCH: 'Energy Flow Diagram Node Not Found Or Not Match',
                ENERGY_FLOW_DIAGRAM_NOT_FOUND: 'Energy Flow Diagram Not Found',
                ENERGY_ITEM_DOES_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Does Not Belong To Energy Category',
                ENERGY_ITEM_IS_NOT_BELONG_TO_ENERGY_CATEGORY: 'Energy Item Is Not Belong To Energy Category',
                ENERGY_ITEM_NAME_IS_ALREADY_IN_USE: 'Energy Item Name Is Already In Use',
                ENERGY_ITEM_NOT_FOUND: 'Energy Item Not Found',
                ENERGY_ITEM_USED_IN_METER: 'Energy Item Used In Meter',
                ENERGY_ITEM_USED_IN_OFFLINE_METER: 'Energy Item Used In Offline Meter',
                ENERGY_ITEM_USED_IN_VIRTUAL_METER: 'Energy Item Used In Virtual Meter',
                EQUIPMENT_METER_RELATION_EXISTS: 'Equipment Meter Relation Exists',
                EQUIPMENT_METER_RELATION_NOT_FOUND: 'Equipment Meter Relation Not Found',
                EQUIPMENT_NAME_IS_ALREADY_IN_USE: 'Equipment Name Is Already In Use',
                EQUIPMENT_NOT_FOUND: 'Equipment Not Found',
                EQUIPMENT_OFFLINE_METER_RELATION_EXISTS: 'Equipment Offline Meter Relation Exists',
                EQUIPMENT_OFFLINE_METER_RELATION_NOT_FOUND: 'Equipment Offline Meter Relation Not Found',
                EQUIPMENT_PARAMETER_NAME_IS_ALREADY_IN_USE: 'Equipment Parameter Name Is Already In Use',
                EQUIPMENT_PARAMETER_NOT_FOUND_OR_NOT_MATCH: 'Equipment Parameter Not Found Or Not Match',
                EQUIPMENT_VIRTUAL_METER_RELATION_EXISTS: 'Equipment Virtual Meter Relation Exists',
                EQUIPMENT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Equipment Virtual Meter Relation Not Found',
                ERROR: 'Error',
                EXCEPTION: 'Exception',
                FAILED_TO_RESTORE_COST_FILE: 'Failed To Restore Cost File',
                FAILED_TO_RESTORE_KNOWLEDGE_FILE: 'Failed To Restore Knowledge File',
                FAILED_TO_RESTORE_OFFLINE_METER_FILE: 'Failed To Restore Offline Meter File',
                FAILED_TO_UPLOAD_COST_FILE: 'Failed To Upload Cost File',
                FAILED_TO_UPLOAD_KNOWLEDGE_FILE: 'Failed To Upload Knowledge File',
                FAILED_TO_UPLOAD_OFFLINE_METER_FILE: 'Failed To Upload Offline Meter File',
                GATEWAY_NAME_IS_ALREADY_IN_USE: 'Gateway Name Is Already In Use',
                GATEWAY_NOT_FOUND: 'Gateway Not Found',
                INVALID_ADDRESS: 'Invalid Address',
                INVALID_ADDRESS_VALUE: 'Invalid Address Value',
                INVALID_ADVANCED_REPORT_ID: 'Invalid Advanced Report ID',
                INVALID_AREA_VALUE: 'Invalid Area Value',
                INVALID_BASE_PERIOD_END_DATETIME: 'Invalid Base Period End Datetime',
                INVALID_BASE_PERIOD_START_DATETIME: 'Invalid Base Period Start Datetime',
                INVALID_BAUD_RATE: 'Invalid Baud Rate',
                INVALID_BUILDINGS_VALUE: 'Invalid Buildings Value',
                INVALID_CATEGORY: 'Invalid Category',
                INVALID_CHANNEL: 'Invalid Channel',
                INVALID_COMBINED_EQUIPMENT_ID: 'Invalid Combined Equipment ID',
                INVALID_COMBINED_EQUIPMENT_NAME: 'Invalid Combined Equipment Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_ID: 'Invalid Combined Equipment Parameter ID',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_NAME: 'Invalid Combined Equipment Parameter Name',
                INVALID_COMBINED_EQUIPMENT_PARAMETER_TYPE: 'Invalid Combined Equipment Parameter Type',
                INVALID_CONNECTION: 'Invalid Connection',
                INVALID_CONSTANT_VALUE: 'Invalid Constant Value',
                INVALID_CONTACT_ID: 'Invalid Contact ID',
                INVALID_CONTACT_NAME: 'Invalid Contact Name',
                INVALID_COST_CENTER_ID: 'Invalid Cost Center ID',
                INVALID_COST_FILE_ID: 'Invalid Cost File ID',
                INVALID_DATA_SOURCE_ID: 'Invalid Data Source ID',
                INVALID_DATA_SOURCE_NAME: 'Invalid Data Source Name',
                INVALID_DATA_SOURCE_PROTOCOL: 'Invalid Data Source Protocol',
                INVALID_DENOMINATOR_METER_UUID: 'Invalid Denominator Meter UUID',
                INVALID_DISPLAY_NAME: 'Invalid Display Name',
                INVALID_DISTRIBUTION_CIRCUIT_ID: 'Invalid Distribution Circuit ID',
                INVALID_DISTRIBUTION_CIRCUIT_NAME: 'Invalid Distribution Circuit Name',
                INVALID_DISTRIBUTION_ROOM: 'Invalid Distribution Room',
                INVALID_DISTRIBUTION_SYSTEM_ID: 'Invalid Distribution System ID',
                INVALID_DISTRIBUTION_SYSTEM_NAME: 'Invalid Distribution System Name',
                INVALID_EMAIL: 'Invalid Email',
                INVALID_EMAIL_MESSAGE_ID: 'Invalid Email Message ID',
                INVALID_EMAIL_SERVER_HOST: 'Invalid Email Server Host',
                INVALID_EMAIL_SERVER_ID: 'Invalid Email Server ID',
                INVALID_END_DATE_FORMAT: 'Invalid End Date Format',
                INVALID_END_DATETIME: 'Invalid End Datetime',
                INVALID_ENERGY_CATEGORY_ID: 'Invalid Energy Category ID',
                INVALID_ENERGY_CATEGORY_NAME: 'Invalid Energy Category Name',
                INVALID_ENERGY_FLOW_DIAGRAM_ID: 'Invalid Energy Flow Diagram ID',
                INVALID_ENERGY_FLOW_DIAGRAM_LINK_ID: 'Invalid Energy Flow Diagram Link ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NAME: 'Invalid Energy Flow Diagram Name',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_ID: 'Invalid Energy Flow Diagram Node ID',
                INVALID_ENERGY_FLOW_DIAGRAM_NODE_NAME: 'Invalid Energy Flow Diagram Node Name',
                INVALID_ENERGY_ITEM_ID: 'Invalid Energy Item ID',
                INVALID_ENERGY_ITEM_NAME: 'Invalid Energy Item Name',
                INVALID_EQUATION_IN_EXPRESSION: 'Invalid Equation In Expression',
                INVALID_EQUIPMENT_ID: 'Invalid Equipment ID',
                INVALID_EQUIPMENT_NAME: 'Invalid Equipment Name',
                INVALID_EQUIPMENT_PARAMETER_ID: 'Invalid Equipment Parameter ID',
                INVALID_EQUIPMENT_PARAMETER_NAME: 'Invalid Equipment Parameter Name',
                INVALID_EQUIPMENT_PARAMETER_TYPE: 'Invalid Equipment Parameter Type',
                INVALID_EXPRESSION: 'Invalid Expression',
                INVALID_EXPRESSION_OBJECT: 'Invalid Expression Object',
                INVALID_FDD_CODE: 'Invalid Fdd Code',
                INVALID_FLOORS_VALUE: 'Invalid Floors Value',
                INVALID_FROM_ADDR: 'Invalid From Address',
                INVALID_GATEWAY_ID: 'Invalid Gateway ID',
                INVALID_GATEWAY_NAME: 'Invalid Gateway Name',
                INVALID_HOURLY_HIGH_LIMIT_VALUE: 'Invalid Hourly High Limit Value',
                INVALID_HOURLY_LOW_LIMIT_VALUE: 'Invalid Hourly Low Limit Value',
                INVALID_IS_ADMIN_VALUE: 'Invalid Is Admin Value',
                INVALID_IS_COUNTED_VALUE: 'Invalid Is Counted Value',
                INVALID_IS_ENABLED: 'Invalid Is Enabled',
                INVALID_IS_HIDDEN: 'Invalid Is Hidden',
                INVALID_IS_IN_LEASE_VALUE: 'Invalid Is In Lease Value',
                INVALID_IS_INPUT_COUNTED_VALUE: 'Invalid Is Input Counted Value',
                INVALID_IS_KEY_TENANT_VALUE: 'Invalid Is Key Tenant Value',
                INVALID_IS_OUTPUT_COUNTED_VALUE: 'Invalid Is Output Counted Value',
                INVALID_IS_OUTPUT_VALUE: 'Invalid Is Output Value',
                INVALID_IS_TREND_VALUE: 'Invalid Is Trend Value',
                INVALID_IS_VIRTUAL_VALUE: 'Invalid Is Virtual Value',
                INVALID_KGCE: 'Invalid KGCE',
                INVALID_KGCO2E: 'Invalid KGCO2E',
                INVALID_KNOWLEDGE_FILE_ID: 'Invalid Knowledge File ID',
                INVALID_LATITUDE_VALUE: 'Invalid Latitude Value',
                INVALID_LEASE_NUMBER_VALUE: 'Invalid Lease Number Value',
                INVALID_LONGITUDE_VALUE: 'Invalid Longitude Value',
                INVALID_LOW_LIMIT_VALUE: 'Invalid Low Limit Value',
                INVALID_MASTER_METER_ID: 'Invalid Master Meter ID',
                INVALID_MENU_ID: 'Invalid Menu ID',
                INVALID_MESSAGE_TEMPLATE: 'Invalid Message Template',
                INVALID_METER_ID: 'Invalid Meter ID',
                INVALID_METER_NAME: 'Invalid Meter Name',
                INVALID_METER_UUID: 'Invalid Meter UUID',
                INVALID_NAME_VALUE: 'Invalid Name Value',
                INVALID_NEW_PASSWORD: 'Invalid New Password',
                INVALID_NOTIFICATION_ID: 'Invalid Notification ID',
                INVALID_NUMERATOR_METER_UUID: 'Invalid Numerator Meter UUID',
                INVALID_OBJECT_TYPE: 'Invalid Object Type',
                INVALID_OFFLINE_METER_FILE_ID: 'Invalid Offline Meter File ID',
                INVALID_OFFLINE_METER_ID: 'Invalid Offline Meter ID',
                INVALID_OFFLINE_METER_NAME: 'Invalid Offline Meter Name',
                INVALID_OLD_PASSWORD: 'Invalid Old Password',
                INVALID_PARENT_SPACE_ID: 'Invalid Parent Space ID',
                INVALID_PASSWORD: 'Invalid Password',
                INVALID_PEAK_CURRENT: 'Invalid Peak Current',
                INVALID_PEAK_LOAD: 'Invalid Peak Load',
                INVALID_PERIOD_TYPE: 'Invalid Period Type',
                INVALID_POINT_ID: 'Invalid Point ID',
                INVALID_POINT_NAME: 'Invalid Point Name',
                INVALID_PORT: 'Invalid Port',
                INVALID_PRIORITY: 'Invalid Priority',
                INVALID_PRIVILEGE: 'Invalid Privilege',
                INVALID_PRIVILEGE_DATA: 'Invalid Privilege Data',
                INVALID_PRIVILEGE_ID: 'Invalid Privilege ID',
                INVALID_PRIVILEGE_NAME: 'Invalid Privilege Name',
                INVALID_RATIO_VALUE: 'Invalid Ratio Value',
                INVALID_REPLY: 'Invalid Reply',
                INVALID_REPORTING_PERIOD_END_DATETIME: 'Invalid Reporting Period End Datetime',
                INVALID_REPORTING_PERIOD_START_DATETIME: 'Invalid Reporting Period Start Datetime',
                INVALID_REQUIRES_AUTHENTICATION: 'Invalid Requires Authentication',
                INVALID_ROOMS_VALUE: 'Invalid Rooms Value',
                INVALID_RULE_ID: 'Invalid Rule ID',
                INVALID_RULE_NAME: 'Invalid Rule Name',
                INVALID_SENSOR_ID: 'Invalid Sensor ID',
                INVALID_SENSOR_NAME: 'Invalid Sensor Name',
                INVALID_SERIAL_PORT: 'Invalid Serial Port',
                INVALID_SESSION_PLEASE_RE_LOGIN: 'Invalid Session Please Re-Login',
                INVALID_SHOPFLOOR_ID: 'Invalid Shopfloor ID',
                INVALID_SHOPFLOOR_NAME: 'Invalid Shopfloor Name',
                INVALID_SOURCE_NODE_ID: 'Invalid Source Node ID',
                INVALID_SPACE_ID: 'Invalid Space ID',
                INVALID_SPACE_NAME: 'Invalid Space Name',
                INVALID_START_DATE_FORMAT: 'Invalid Start Date Format',
                INVALID_START_DATETIME: 'Invalid Start Datetime',
                INVALID_STATUS: 'Invalid Status',
                INVALID_STORE_ID: 'Invalid Store ID',
                INVALID_STORE_NAME: 'Invalid Store Name',
                INVALID_STORE_TYPE_DESCRIPTION: 'Invalid Store Type Description',
                INVALID_STORE_TYPE_ID: 'Invalid Store Type ID',
                INVALID_STORE_TYPE_NAME: 'Invalid Store Type Name',
                INVALID_STORE_TYPE_SIMPLIFIED_CODE: 'Invalid Store Type Simplified Code',
                INVALID_SVG: 'Invalid SVG',
                INVALID_SWITCHGEAR: 'Invalid Switchgear',
                INVALID_TARGET_NODE_ID: 'Invalid Target Node ID',
                INVALID_TARIFF_BLOCK_PRICING: 'Invalid Tariff Block Pricing',
                INVALID_TARIFF_ID: 'Invalid Tariff ID',
                INVALID_TARIFF_TIME_OF_USE_PRICING: 'Invalid Tariff Time Of Use Pricing',
                INVALID_TARIFF_TYPE: 'Invalid Tariff Type',
                INVALID_TENANT_ID: 'Invalid Tenant ID',
                INVALID_TENANT_NAME: 'Invalid Tenant Name',
                INVALID_TENANT_TYPE_DESCRIPTION: 'Invalid Tenant Type Description',
                INVALID_TENANT_TYPE_ID: 'Invalid Tenant Type ID',
                INVALID_TENANT_TYPE_NAME: 'Invalid Tenant Type Name',
                INVALID_TENANT_TYPE_SIMPLIFIED_CODE: 'Invalid Tenant Type Simplified Code',
                INVALID_TEXT_MESSAGE_ID: 'Invalid Text Message ID',
                INVALID_TIMEZONE_ID: 'Invalid Timezone ID',
                INVALID_TOKEN: 'Invalid Token',
                INVALID_UNIT_OF_MEASURE: 'Invalid Unit Of Measure',
                INVALID_UNIT_OF_PRICE: 'Invalid Unit Of Price',
                INVALID_UNITS: 'Invalid Units',
                INVALID_USER_ID: 'Invalid User ID',
                INVALID_USER_NAME: 'Invalid User Name',
                INVALID_USER_NAME_OR_EMAIL: 'Invalid User Name Or Email',
                INVALID_USER_PHONE: 'Invalid User Phone',
                INVALID_USER_PLEASE_RE_LOGIN: 'Invalid User Please Re-Login',
                INVALID_USER_UUID: 'Invalid User UUID',
                INVALID_VARIABLE_METER_ID: 'Invalid Variable Meter ID',
                INVALID_VARIABLE_METER_TYPE: 'Invalid Variable Meter Type',
                INVALID_VARIABLE_NAME: 'Invalid Variable Name',
                INVALID_VIRTUAL_METER_ID: 'Invalid Virtual Meter ID',
                INVALID_VIRTUAL_METER_NAME: 'Invalid Virtual Meter Name',
                INVALID_WEB_MESSAGE_ID: 'Invalid Web Message ID',
                INVALID_WECHAT_MESSAGE_ID: 'Invalid Wechat Message ID',
                KNOWLEDGE_FILE_CANNOT_BE_REMOVED_FROM_DISK: 'Knowledge File Cannot be Removed from Disk',
                KNOWLEDGE_FILE_NOT_FOUND: 'Knowledge File Not Found',
                MASTER_METER_DOES_NOT_BELONG_TO_SAME_ENERGY_CATEGORY: 'Master Meter Does Not Belong To Same Energy Category',
                MASTER_METER_NOT_FOUND: 'Master Meter Not Found',
                MENU_NOT_FOUND: 'Menu Not Found',
                METER_NAME_IS_ALREADY_IN_USE: 'Meter Name Is Already In Use',
                METER_NOT_FOUND: 'Meter Not Found',
                METER_OF_VARIABLE_NOT_FOUND: 'Meter Of Variable Not Found',
                METER_POINT_RELATION_EXISTS: 'Meter Point Relation Exists',
                METER_POINT_RELATION_NOT_FOUND: 'Meter Point Relation Not Found',
                NOT_FOUND: 'Not Found',
                NOTIFICATION_NOT_FOUND: 'Notification Not Found',
                OFFLINE_METER_FILE_NOT_FOUND: 'Offline Meter File Not Found',
                OFFLINE_METER_NAME_IS_ALREADY_IN_USE: 'Offline Meter Name Is Already In Use',
                OFFLINE_METER_NOT_FOUND: 'Offline Meter Not Found',
                OFFLINE_METER_OF_VARIABLE_NOT_FOUND: 'Offline Meter Of Variable Not Found',
                PARENT_SPACE_NOT_FOUND: 'Parent Space Not Found',
                POINT_NAME_IS_ALREADY_IN_USE: 'Point Name Is Already In Use',
                POINT_NOT_FOUND: 'Point Not Found',
                PRIVILEGE_NAME_IS_ALREADY_IN_USE: 'Privilege Name Is Already In Use',
                PRIVILEGE_NOT_FOUND: 'Privilege Not Found',
                RULE_NAME_IS_ALREADY_IN_USE: 'Rule Name Is Already In Use',
                RULE_NOT_FOUND: 'Rule Not Found',
                SENSOR_NAME_IS_ALREADY_IN_USE: 'Sensor Name Is Already In Use',
                SENSOR_NOT_FOUND: 'Sensor Not Found',
                SENSOR_POINT_RELATION_EXISTS: 'Sensor Point Relation Exists',
                SENSOR_POINT_RELATION_NOT_FOUND: 'Sensor Point Relation Not Found',
                SHOPFLOOR_EQUIPMENT_RELATION_EXISTS: 'Shopfloor Equipment Relation Exists',
                SHOPFLOOR_EQUIPMENT_RELATION_NOT_FOUND: 'Shopfloor Equipment Relation Not Found',
                SHOPFLOOR_METER_RELATION_EXISTS: 'Shopfloor Meter Relation Exists',
                SHOPFLOOR_METER_RELATION_NOT_FOUND: 'Shopfloor Meter Relation Not Found',
                SHOPFLOOR_NAME_IS_ALREADY_IN_USE: 'Shopfloor Name Is Already In Use',
                SHOPFLOOR_NOT_FOUND: 'Shopfloor Not Found',
                SHOPFLOOR_OFFLINE_METER_RELATION_EXISTS: 'Shopfloor Offline Meter Relation Exists',
                SHOPFLOOR_OFFLINE_METER_RELATION_NOT_FOUND: 'Shopfloor Offline Meter Relation Not Found',
                SHOPFLOOR_POINT_RELATION_EXISTS: 'Shopfloor Point Relation Exists',
                SHOPFLOOR_POINT_RELATION_NOT_FOUND: 'Shopfloor Point Relation Not Found',
                SHOPFLOOR_SENSOR_RELATION_EXISTS: 'Shopfloor Sensor Relation Exists',
                SHOPFLOOR_SENSOR_RELATION_NOT_FOUND: 'Shopfloor Sensor Relation Not Found',
                SHOPFLOOR_VIRTUAL_METER_RELATION_EXISTS: 'Shopfloor Virtual Meter Relation Exists',
                SHOPFLOOR_VIRTUAL_METER_RELATION_NOT_FOUND: 'Shopfloor Virtual Meter Relation Not Found',
                SOURCE_NODE_NOT_FOUND: 'Source Node Not Found',
                SPACE_COMBINED_EQUIPMENT_RELATION_EXISTS: 'Space Combined Equipment Relation Exists',
                SPACE_COMBINED_EQUIPMENT_RELATION_NOT_FOUND: 'Space Combined Equipment Relation Not Found',
                SPACE_EQUIPMENT_RELATION_EXISTS: 'Space Equipment Relation Exists',
                SPACE_EQUIPMENT_RELATION_NOT_FOUND: 'Space Equipment Relation Not Found',
                SPACE_METER_RELATION_EXISTS: 'Space Meter Relation Exists',
                SPACE_METER_RELATION_NOT_FOUND: 'Space Meter Relation Not Found',
                SPACE_NAME_IS_ALREADY_IN_USE: 'Space Name Is Already In Use',
                SPACE_NOT_FOUND: 'Space Not Found',
                SPACE_NOT_FOUND_IN_PRIVILEGE: 'Space Not Found In Privilege',
                SPACE_OFFLINE_METER_RELATION_EXISTS: 'Space Offline Meter Relation Exists',
                SPACE_OFFLINE_METER_RELATION_NOT_FOUND: 'Space Offline Meter Relation Not Found',
                SPACE_POINT_RELATION_EXISTS: 'Space Point Relation Exists',
                SPACE_POINT_RELATION_NOT_FOUND: 'Space Point Relation Not Found',
                SPACE_SENSOR_RELATION_EXISTS: 'Space Sensor Relation Exists',
                SPACE_SENSOR_RELATION_NOT_FOUND: 'Space Sensor Relation Not Found',
                SPACE_SHOPFLOOR_RELATION_EXISTS: 'Space Shopfloor Relation Exists',
                SPACE_SHOPFLOOR_RELATION_NOT_FOUND: 'Space Shopfloor Relation Not Found',
                SPACE_STORE_RELATION_EXISTS: 'Space Store Relation Exists',
                SPACE_STORE_RELATION_NOT_FOUND: 'Space Store Relation Not Found',
                SPACE_TENANT_RELATION_EXISTS: 'Space Tenant Relation Exists',
                SPACE_TENANT_RELATION_NOT_FOUND: 'Space Tenant Relation Not Found',
                SPACE_VIRTUAL_METER_RELATION_EXISTS: 'Space Virtual Meter Relation Exists',
                SPACE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Space Virtual Meter Relation Not Found',
                START_DATETIME_MUST_BE_EARLIER_THAN_END_DATETIME: 'Start Datetime Must Be Earlier Than End Datetime',
                STORE_METER_RELATION_EXISTS: 'Store Meter Relation Exists',
                STORE_METER_RELATION_NOT_FOUND: 'Store Meter Relation Not Found',
                STORE_NAME_IS_ALREADY_IN_USE: 'Store Name Is Already In Use',
                STORE_NOT_FOUND: 'Store Not Found',
                STORE_OFFLINE_METER_RELATION_EXISTS: 'Store Offline Meter Relation Exists',
                STORE_OFFLINE_METER_RELATION_NOT_FOUND: 'Store Offline Meter Relation Not Found',
                STORE_POINT_RELATION_EXISTS: 'Store Point Relation Exists',
                STORE_POINT_RELATION_NOT_FOUND: 'Store Point Relation Not Found',
                STORE_SENSOR_RELATION_EXISTS: 'Store Sensor Relation Exists',
                STORE_SENSOR_RELATION_NOT_FOUND: 'Store Sensor Relation Not Found',
                STORE_TYPE_NAME_IS_ALREADY_IN_USE: 'Store Type Name Is Already In Use',
                STORE_TYPE_NOT_FOUND: 'Store Type Not Found',
                STORE_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Store Type Simplified Code Is Already In Use',
                STORE_TYPE_USED_IN_STORE: 'Store Type Used In Store',
                STORE_VIRTUAL_METER_RELATION_EXISTS: 'Store Virtual Meter Relation Exists',
                STORE_VIRTUAL_METER_RELATION_NOT_FOUND: 'Store Virtual Meter Relation Not Found',
                TARGET_NODE_NOT_FOUND: 'Target Node Not Found',
                TARIFF_IS_ALREADY_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Already Associated With Cost Center',
                TARIFF_IN_USE: 'Tariff In Use',
                TARIFF_IS_NOT_ASSOCIATED_WITH_COST_CENTER: 'Tariff Is Not Associated With Cost Center',
                TARIFF_NAME_IS_ALREADY_IN_USE: 'Tariff Name Is Already In Use',
                TARIFF_NOT_EMPTY: 'Tariff Not Empty',
                TARIFF_NOT_FOUND: 'Tariff Not Found',
                TENANT_METER_RELATION_EXISTS: 'Tenant Meter Relation Exists',
                TENANT_METER_RELATION_NOT_FOUND: 'Tenant Meter Relation Not Found',
                TENANT_NAME_IS_ALREADY_IN_USE: 'Tenant Name Is Already In Use',
                TENANT_NOT_FOUND: 'Tenant Not Found',
                TENANT_OFFLINE_METER_RELATION_EXISTS: 'Tenant Offline Meter Relation Exists',
                TENANT_OFFLINE_METER_RELATION_NOT_FOUND: 'Tenant Offline Meter Relation Not Found',
                TENANT_POINT_RELATION_EXISTS: 'Tenant Point Relation Exists',
                TENANT_POINT_RELATION_NOT_FOUND: 'Tenant Point Relation Not Found',
                TENANT_SENSOR_RELATION_EXISTS: 'Tenant Sensor Relation Exists',
                TENANT_SENSOR_RELATION_NOT_FOUND: 'Tenant Sensor Relation Not Found',
                TENANT_TYPE_NAME_IS_ALREADY_IN_USE: 'Tenant Type Name Is Already In Use',
                TENANT_TYPE_NOT_FOUND: 'Tenant Type Not Found',
                TENANT_TYPE_SIMPLIFIED_CODE_IS_ALREADY_IN_USE: 'Tenant Type Simplified Code Is Already In Use',
                TENANT_TYPE_USED_IN_TENANT: 'Tenant Type Used In Tenant',
                TENANT_VIRTUAL_METER_RELATION_EXISTS: 'Tenant Virtual Meter Relation Exists',
                TENANT_VIRTUAL_METER_RELATION_NOT_FOUND: 'Tenant Virtual Meter Relation Not Found',
                TEXT_MESSAGE_NOT_FOUND: 'Text Message Not Found',
                THE_REPORTING_PERIOD_MUST_BE_LONGER_THAN_15_MINUTES: 'The Reporting Period Must Be Longer Than 15 Minutes',
                THERE_IS_ASSOCIATED_DISTRIBUTION_CIRCUITS: 'There Is Associated Distribution Circuits',
                THERE_IS_RELATION_WITH_CHILD_METERS: 'There Is Relation With Child Meters',
                THERE_IS_RELATION_WITH_CHILDREN_SPACES: 'There Is Relation With Children Spaces',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENT_PARAMETERS: 'There Is Relation With Combined Equipment Parameters',
                THERE_IS_RELATION_WITH_COMBINED_EQUIPMENTS: 'There Is Relation With Combined Equipments',
                THERE_IS_RELATION_WITH_DATA_SOURCES: 'There Is Relation With Data Sources',
                THERE_IS_RELATION_WITH_ENERGY_FLOW_DIAGRAM_LINKS: 'There Is Relation With Energy Flow Diagram Links',
                THERE_IS_RELATION_WITH_EQUIPMENT_PARAMETERS: 'There Is Relation With Equipment Parameters',
                THERE_IS_RELATION_WITH_EQUIPMENTS: 'There Is Relation With Equipments',
                THERE_IS_RELATION_WITH_METER: 'There Is Relation With Meter',
                THERE_IS_RELATION_WITH_METERS: 'There Is Relation With Meters',
                THERE_IS_RELATION_WITH_OFFLINE_METER: 'There Is Relation With Offline Meter',
                THERE_IS_RELATION_WITH_OFFLINE_METERS: 'There Is Relation With Offline Meters',
                THERE_IS_RELATION_WITH_OTHER_VIRTUAL_METERS: 'There Is Relation With Other Virtual Meters',
                THERE_IS_RELATION_WITH_POINTS: 'There Is Relation With Points',
                THERE_IS_RELATION_WITH_SENSORS: 'There Is Relation With Sensors',
                THERE_IS_RELATION_WITH_SHOPFLOORS: 'There Is Relation With Shopfloors',
                THERE_IS_RELATION_WITH_SPACES: 'There Is Relation With Spaces',
                THERE_IS_RELATION_WITH_STORES: 'There Is Relation With Stores',
                THERE_IS_RELATION_WITH_TARIFFS: 'There Is Relation With Tariffs',
                THERE_IS_RELATION_WITH_TENANTS: 'There Is Relation With Tenants',
                THERE_IS_RELATION_WITH_VIRTUAL_METER: 'There Is Relation With Virtual Meter',
                THERE_IS_RELATION_WITH_VIRTUAL_METERS: 'There Is Relation With Virtual Meters',
                THERE_IS_RELATION_WITH_USERS: 'There Is Relation With Users',
                THIS_DATA_SOURCE_IS_BEING_USED_BY_A_METER: 'This Data Source Is Being Used By A Meter',
                THIS_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Meter Is Being Used By A Virtual Meter',
                THIS_OFFLINE_METER_IS_BEING_USED_BY_A_VIRTUAL_METER: 'This Offline Meter Is Being Used By A Virtual Meter',
                THIS_SHOPFLOOR_CANNOT_BE_DELETED: 'This Shopfloor Cannot Be Deleted',
                THIS_SPACE_CANNOT_BE_DELETED: 'This Space Cannot Be Deleted',
                TIMEZONE_NOT_FOUND: 'Timezone Not Found',
                TOKEN_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'Token Not Found In Headers Please Login',
                USER_ACCOUNT_HAS_EXPIRED: 'User Account Has Expired',
                USER_NAME_IS_ALREADY_IN_USE: 'User Name Is Already In Use',
                USER_NOT_FOUND: 'User Not Found',
                USER_PASSWORD_HAS_EXPIRED: 'User Password Has Expired',
                USER_PRIVILEGE_NOT_FOUND: 'User Privilege Not Found',
                USER_SESSION_NOT_FOUND: 'User Session Not Found',
                USER_SESSION_TIMEOUT: 'User Session Timeout',
                USER_UUID_NOT_FOUND_IN_HEADERS_PLEASE_LOGIN: 'User UUID Not Found In Headers Please Login',
                VIRTUAL_METER_NAME_IS_ALREADY_IN_USE: 'Virtual Meter Name Is Already In Use',
                VIRTUAL_METER_NOT_FOUND: 'Virtual Meter Not Found',
                VIRTUAL_METER_OF_VARIABLE_NOT_FOUND: 'Virtual Meter Of Variable Not Found',
                VIRTUAL_POINT_SHOULD_BE_ANALOG_VALUE: 'Virtual Point Should Be Analog Value',
                WEB_MESSAGE_NOT_FOUND: 'Web Message Not Found',
                WECHAT_MESSAGE_NOT_FOUND: 'Wechat Message Not Found',
            },
        })
        ;
    var lang = window.localStorage.getItem("myems_admin_ui_language") || "zh_CN";

    $translateProvider.preferredLanguage(lang);

}

angular
    .module('inspinia')
    .config(config)
