/**** ***** ***** ******
*   Makind variables
***** ***** ***** *****/

/*
Variable list
[original variables]
suicide_all : Number of all Tweets about suicide
suicide_prevent : Number of Tweets about suicide-prevention
date : date(string variable) "yyyy/mm/dd"

[divide]
date => year, month, day
year： year (range 2011-2014)
month： month (range 1-12)
day： day (range 1-31)

[new variables]
x1 : (related Tweet) = (all Tweet) - (prevent Tweet)
x2 : prevent Tweet
dx1 : interday difference of x1
dx2 : interday difference of x2

counter_month : 1 if Counter month(March)
counter_week  : 1 if Counter week (10 Sep ~ 16 Sep)
prevent : 1 if Counter month or Counter week

*/

set more off

* Avoid errors due to same variable/label name.
capture drop x*
capture drop dhat*
capture drop _est_*
capture drop year
capture drop month
capture drop day
capture drop outliner*
capture drop counter_*
capture drop prevent

* Variables about Tweet
gen x1 = suicide_all - suicide_prevent
gen x2 = suicide_prevent

* Variables about Counter month/week
gen temp = date(date,"YMD")
drop date
rename temp date
gen year = year(date)
gen month = month(date)
gen day = day(date)
gen counter_month = (month==3)
gen counter_week = (month==9 & day>=10 & day<=16)
gen prevent = ((counter_month==1) | (counter_week==1))

* Set Time-series dataset
tsset date

* Variable about interday difference
gen dx1 = D.x1
gen dx2 = D.x2


set more on
