/**** ***** ***** ******
*   Drawing Graph
***** ***** ***** *****/

set more off

local timeline_var x1 x2
local graph_var x1 x2 dx1 dx2

/**** timeline ****/
// Drawing Figure.1 (a) and (b)
foreach var of local timeline_var {
	capture graph drop trend_`var'
	tsline `var' , name("trend_`var'")
}

/**** ACF and PACF ****/
// Drawing Figure.2 (a)~(f)
foreach var of local graph_var{
	capture graph drop ac`var'
	capture graph drop pac`var'
	capture graph drop comb`var'
	ac `var', lag(20) name(ac`var')
	pac  `var', lag(20) name(pac`var')
	graph combine ac`var' pac`var', name(comb`var')
	graph save comb`var' comb`var'.gph , replace
}

set more on
