/**** ***** ***** ******
*   ARMA modeling (x2)
***** ***** ***** *****/

/*
* x2  : (prevent Tweet)
* prevent : 1 if Counter month or Counter week
* outliner1_x2 : Outlier of x2 (top 95%~99%)
* outliner2_x2 : Outlier of x2 (top >99%)

* select model using the following criteria.
 Criteria 1;p-value of Q test is bigger than 0.9
 Criteria 2;lowest AIC or BIC

* trying ARMA(p,q) model
 q=1 based on ac x2
 p=0/5 based on pac x2 
*/

capture log close
log using LOG_AN_ARMA_x2, replace
set more off

capture drop _est_x2*
capture drop x2nres*


// 2 outliner
forvalues v =1/1 {
	forvalues w = 0/5{
		qui:arima x2 prevent outliner1_x2 outliner2_x2, arima(`v',0,`w') nolog
		qui:estimate store x2t_`v'_0_`w'
		qui:predict x2tres`v'_0_`w', residual
		qui:wntestq x2tres`v'_0_`w', lags(10)
		di "Q test of x2tres`v'_0_`w' =" r(stat) ", p-value =" r(p)
	}
}

// display AIC and BIC table
est stat x2*

// display best model = ARMA(1,2)
estimates replay x2t_1_0_2

log close
set more on
exit
