/**** ***** ***** ******
*   ARMA modeling (dx1)
***** ***** ***** *****/

/*
* x1  : (related Tweet) = (all Tweet) - (prevent Tweet)
* dx1 : interday difference of x1
* prevent : 1 if Counter month or Counter week
* outliner1_dx1 : Outlier of dx1 (top 95%~99%)
* outliner2_dx1 : Outlier of dx1 (top >99%)

* select model using the following criteria.
 Criteria 1;p-value of Q test is bigger than 0.9
 Criteria 2;lowest AIC or BIC

* trying ARMA(p,q) model
 q=1/2 based on ac dx1
 p=2/6 based on pac dx1 
*/

capture log close
log using LOG_AN_ARMA_dx1, replace
set more off

capture drop _est_x1*
capture drop dx1nres*


* trying ARMA(p,q) model. p=2/6, q=1/2
forvalues v =2/6 {
	forvalues w = 1/2{
		qui:arima dx1 prevent outliner1_dx1 outliner2_dx1, arima(`v',0,`w') nolog
		qui:estimate store dx1t_`v'_0_`w'
		qui:predict dx1tres`v'_0_`w', residual
		qui:wntestq dx1tres`v'_0_`w', lags(10)
		di "Q test of dx1tres`v'_0_`w' =" r(stat) ", p-value =" r(p)
	}
}



// display AIC and BIC table
est stat dx1*

// display best model = ARMA(2,1)
estimates replay dx1t_2_0_1

log close
set more on
exit
