% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_funcs.R
\name{plot_N_map}
\alias{plot_N_map}
\title{Function to plot abundance map for Bering Sea survey grid}
\usage{
plot_N_map(cur.t = 1, N, Grid, highlight = NULL, cell.width = 1,
  leg.title = "Abundance", hcolor = "yellow", cur.max = NULL,
  myPalette = NULL)
}
\arguments{
\item{cur.t}{Time step to plot map for}

\item{N}{A matrix holding abundance point estimates; different rows correspond to different sampling units}

\item{Grid}{A spatial polygons data frame holding grid entries}

\item{highlight}{If provided, this vector specifies which cells to separately highlight during plotting}

\item{cell.width}{if highlight is provided, cell.width must provide the width of a composite grid cell}

\item{leg.title}{Title for legend of plot (if different from the default "Abundance")}

\item{hcolor}{If highight provided, gives color for highlighting (default = "yellow")}

\item{cur.max}{If provided, sets maximum value for plotted abundance}

\item{myPallete}{A colorRampPalette; default is a spectral palette from RColorBrewer}
}
\value{
An abundance map
}
\description{
Function to plot abundance map for Bering Sea survey grid
}
\author{
Paul Conn \email{paul.conn@noaa.gov}
}
\keyword{abundance}
\keyword{map,}
\keyword{plot}

