% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife.R
\name{GetFilteredResults}
\alias{GetFilteredResults}
\title{Go from a vector of species, newick string, or phylo object to a list of patristic matrices}
\usage{
GetFilteredResults(input = c("Rhea americana", "Pterocnemia pennata",
  "Struthio camelus"), partial = TRUE, usetnrs = FALSE,
  approximatematch = TRUE, cache = datelife.cache, method = "PATHd8")
}
\arguments{
\item{input}{A vector of names, a newick string, or a phylo object}

\item{partial}{If TRUE, use source trees even if they only match some of the desired taxa}

\item{usetnrs}{If TRUE, use OpenTree's services to resolve names. This can dramatically improve the chance of matches, but also take much longer}

\item{approximatematch}{If TRUE, use a slower TNRS to correct mispellings, increasing the chance of matches (including false matches)}

\item{cache}{The cached set of chronograms and other info from data(opentree_chronograms)}

\item{method}{The method used for congruification. PATHd8 only right now, r8s and treePL later.}
}
\value{
List of patristic matrices
}
\description{
Go from a vector of species, newick string, or phylo object to a list of patristic matrices
}

