library(vegan)
library(ggplot2)
library(ggrepel)

df$type<-as.factor(df$type)
df$site<-as.factor(df$site)

env <-as.data.frame(df[,c(11:17)])
m_com2 <- (df[,c(20:ncol(df))])

m_com<-sqrt(sqrt(m_com2))


set.seed(123)
nmds <- metaMDS(m_com, distance = "bray", k=3)
nmds

nmds2<-with(df, MDSrotate(nmds, PO4))


en <- envfit(nmds2, env, permutations = 1000, na.rm = TRUE)
en


data.scores <- as.data.frame(scores(nmds))
data.scores$Site <- df$site
data.scores$Polymer <- df$type
data.scores$pond2 <- df$pond_new


en_coord_cont_sign <- (as.data.frame(scores(en, "vectors")) * ordiArrowMul(en))[c(4:6),]
en_coord_cont_nosign <- (as.data.frame(scores(en, "vectors")) * ordiArrowMul(en))[c(3,7),]


#To add convex hulls

grp.a <- data.scores[data.scores$Site == "EV", ][chull(data.scores[data.scores$Site == 
                                                                   "EV", c("NMDS1", "NMDS2")]), ]  # hull values for grp A
grp.b <- data.scores[data.scores$Site == "JC", ][chull(data.scores[data.scores$Site == 
                                                                   "JC", c("NMDS1", "NMDS2")]), ] 
grp.c <- data.scores[data.scores$Site == "PT", ][chull(data.scores[data.scores$Site == 
                                                                   "PT", c("NMDS1", "NMDS2")]), ] 
grp.d <- data.scores[data.scores$Site == "TL", ][chull(data.scores[data.scores$Site == 
                                                                   "TL", c("NMDS1", "NMDS2")]), ]
grp.e <- data.scores[data.scores$Site == "MR", ][chull(data.scores[data.scores$Site == 
                                                                    "MR", c("NMDS1", "NMDS2")]), ]

                                                                                                                
hull.data <- rbind(grp.a, grp.b, grp.c, grp.d, grp.e)  #combine grp.a and grp.b
hull.data

library(viridis)

nmds_plot <-ggplot(data = data.scores, aes(x = NMDS1, y = NMDS2)) + 
  geom_polygon(data=hull.data,aes(x=NMDS1,y=NMDS2,group=Site, fill=Site),alpha=0.20) +
  geom_point(data = data.scores, aes(colour = Site, shape = Polymer), size = 3, alpha = 0.5) + 
  geom_text_repel(aes(label=pond2, colour=Site), size=3)+
  geom_segment(aes(x = 0, y = 0, xend = NMDS1, yend = NMDS2), 
               data = en_coord_cont_sign, size =1, alpha = 0.5, colour = "grey30") +
  geom_text(data = en_coord_cont_sign, aes(x = NMDS1, y = NMDS2), colour = "grey30", 
            fontface = "bold", label = (c("PO4", "NH4", "SiO4"))) + 
  geom_segment(aes(x = 0, y = 0, xend = NMDS1, yend = NMDS2), linetype=2, 
               data = en_coord_cont_nosign, size =1, alpha = 0.5, colour = "grey30") +
  geom_text(data = en_coord_cont_nosign, aes(x = NMDS1, y = NMDS2), colour = "grey30", 
            fontface = "bold", label = (c("NO3","% macrophyte"))) +
   theme(axis.title = element_text(size = 10, face = "bold", colour = "grey30"), 
        panel.background = element_blank(), panel.border = element_rect(fill = NA, colour = "grey30"), 
        axis.ticks = element_blank(), axis.text = element_blank(), legend.key = element_blank(), 
        legend.title = element_text(size = 10, face = "bold", colour = "grey30"), 
        legend.text = element_text(size = 9, colour = "grey30")) + 
  labs(colour = "Site")


(final_plot<-nmds_plot+scale_color_viridis(discrete=T)+scale_fill_viridis(discrete=T))


#Contour plot with phosphorus concentration
library(ggordiplots)
gg_ordisurf(nmds2, df$PO4, var.label = "PO4", binwidth = 0.5)

