#Upload packages
library(dplyr)
library(vegan)
library(RColorBrewer)

#Aggregate data for genera
genus<-aggregate(biomass[,-c(1:6)],biomass["genus_code"],sum)
genus_trans<-as.data.frame(t(genus[,-1]))
colnames(genus_trans) <- genus[,1]
prop.db<-genus_trans[,-1]
rownames(prop.db)<-db$sample_new
genus.fin<-prop.db %>% select_if(colSums(prop.db!=0) > 5)

#Distance measures
data.dist <- vegdist(prop.db, method = "bray")
row.clus <- hclust(data.dist, "aver")

data.dist.g <- vegdist(t(genus.fin), method = "bray")
col.clus <- hclust(data.dist.g, "aver")


mycol<-brewer.pal(9, "OrRd")

#Plot
heatmap.2(as.matrix(log10(genus.fin+1)),  Rowv = as.dendrogram(row.clus), 
          Colv = as.dendrogram(col.clus), 
          trace="none", 
          col = mycol,  key=T,
          cexRow = 0.7, cexCol=0.7,
          density.info = "none",  offsetRow=0, offsetCol=0,
          key.xlab=NA, lhei=c(0.6,3),lwid=c(0.5,3), margins = c(7.5, 5))