# indicator value (fidelity and relative abundance) of species in clusters or types.
#Upload packages
library(labdsv)
library(dplyr)

#Select data
samples<-samples[,-c(1,4)]
samples$type<-as.factor(samples$type)
samples$site<-as.factor(samples$site)
samples<-samples %>% select_if(colSums(samples!=0) > 1)

#IndVal for site
iva_site <- indval(samples[,-c(1:2)], samples[,1])

sum_site<-summary(iva_site, p=0.05, type='short', digits=2, show=p,
        sort=FALSE, too.many=100)

#IndVal for plastic type
iva_plas <- indval(samples[,-c(1:2)], samples[,2])

summary(iva_plas, p=0.05, type='short', digits=2, show=p,
        sort=FALSE)
