#Diversity index
library(ggplot2)
library(vegan)

#Diversity indices calculation
H<-diversity(sel.dati)
numbsp<-specnumber(sel.dati)
simp<-diversity(sel.dati, "simpson")
invsimp<-diversity(sel.dati, "invsimpson")
J <- H/log(specnumber(sel.dati))
diver_db<-cbind.data.frame(dati[,1:3],numbsp, as.matrix(H), invsimp, J)
colnames(diver_db)<-c("sample", "site", "type","nspecies", "shannon", "invsimp", "pielou")

library('data.table')
dat.m <-melt(as.data.table(diver_db, id.vars = c("sample", "site", "type"),
                            measure.vars = c("nspecies","shannon", "invsimp", "pielou")))
new<-as.data.frame(dat.m)

supp.labs <- c('nspecies'="Species number",
               'shannon'="Shannon index",
               'invsimp'="Inverse Simpson", 
               'pielou'="Pielou's eveness")


#Boxplot
(bp_div<-ggplot(new, aes(x = site, y = value, fill=type)) +
  geom_boxplot(width=0.52, position=position_dodge(0.55))+
  facet_wrap(~ variable, ncol=2, labeller = as_labeller(supp.labs),
             scales="free_y")+
  xlab("Site") +
  ylab("")+
  scale_x_discrete(labels = c('MR','TL','EV', 'PT', 'JC'))+
  scale_fill_manual(values=c("#00AFBB", "#E7B800", "#FC4E07"))+
  theme_bw()+
  theme(legend.title=element_blank(), legend.position="right",
        axis.title.x = element_text(size="16") , 
        axis.title.y = element_text(size="16"), 
        axis.text.x= element_text(size="13"), 
        axis.text.y= element_text(size="13"),
        strip.text.x = element_text(size = "14")))
