setwd("/Volumes/GoogleDrive/Il mio Drive/Aquacosm_MPhyto_NEW/_Manuscript_FINAL/Zenodo_files")
db<-read.table("1_Data_density_biomass.csv", header=T, sep=";", dec=",")

# change data structure
db$site <- as.factor(db$site)
db$type <- as.factor(db$type)
db$mesocosm <- as.factor(db$mesocosm)

#load packges
library(lmerTest)
library(ggplot2)


#Mixed model on TOTAL BIOVOLUME
biom_mod <- lmer(biomass ~ type*site + (1 | mesocosm/site),
                data = db)

anova(biom_mod)


#Mixed model on different phyla (loop)
results <- NULL
count <- 1
for (i in 7:15) {
  fit <- lmer(db[,i] ~ type*site + (1 | mesocosm/site),
              data = db)
  results[[count]] <- anova(fit)
  names(results)[[count]] <- names(db)[i]
  count <- count + 1
}

results



#Model on diatoms removing the interaction term
baci_mod <- lmer(baci ~ type + site + (1 | mesocosm/site),
           data = db)

anova(baci_mod)

