#Upload packages
library(ggplot2)

#Open CSV file
db<-read.table("Data_density_biomass.csv", header=TRUE, sep=";", dec=",")

#Visualize data structure
str(db)
db$site_code<-as.factor(db$site_code) #change 'site_code' to factor

#Transform density and biomass values with logarithm
db$log_dens<-log1p(db$density)
db$log_biom<-log1p(db$biomass)



#Boxplot of density values using ggplot2
(density_plot<-ggplot(db, aes(x = site_code, y = log_dens, fill=type)) +
    geom_boxplot(width=0.52,position=position_dodge(0.55))+
    xlab("Site") +
    ylab(expression(Log[10]~Density~(µg~cm^-2)))+
    scale_x_discrete(labels = c('MR','TL','EV', 'PT', 'JC'))+
    scale_fill_manual(values=c("#00AFBB", "#E7B800", "#FC4E07"))+
    theme_minimal()+
    theme(legend.title=element_blank(), legend.position="right", 
          axis.title.x = element_text(size="18") , 
          axis.title.y = element_text(size="18"), 
          axis.text.x= element_text(size="14"), 
          axis.text.y= element_text(size="14"),
          panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), 
          axis.line = element_line(colour = "black")))


#Boxplot of biomass values using ggplot2
(biomass_plot<-ggplot(db, aes(x = site_code, y = log_biom, fill=type)) +
    geom_boxplot(width=0.52,position=position_dodge(0.55))+
    xlab("Site") +
    ylab(expression(Log[10]~Biomass~(µg~cm^-2)))+
    scale_x_discrete(labels = c('MR','TL','EV', 'PT', 'JC'))+
    scale_fill_manual(values=c("#00AFBB", "#E7B800", "#FC4E07"))+
    theme_minimal()+
    theme(legend.title=element_blank(), legend.position="right", 
          axis.title.x = element_text(size="18") , 
          axis.title.y = element_text(size="18"), 
          axis.text.x= element_text(size="14"), 
          axis.text.y= element_text(size="14"),
          panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          panel.background = element_blank(), 
          axis.line = element_line(colour = "black")))