-- Group [Group]
create table `group` (
   `oid`  integer  not null,
   `groupname`  varchar(255),
  primary key (`oid`)
);


-- Module [Module]
create table `module` (
   `oid`  integer  not null,
   `moduleid`  varchar(255),
   `modulename`  varchar(255),
  primary key (`oid`)
);


-- User [User]
create table `user` (
   `oid`  integer  not null,
   `username`  varchar(255),
   `password`  varchar(255),
   `email`  varchar(255),
  primary key (`oid`)
);


-- Solicitud [ent1]
create table `solicitud` (
   `oid`  integer  not null,
   `fecha`  date,
   `descripcion_equipo`  varchar(255),
   `resumen_cv`  varchar(255),
   `aceptada`  bit,
  primary key (`oid`)
);


-- Fotografo [ent2]
create table `fotografo` (
   `oid`  integer  not null,
   `dni`  varchar(255),
   `nombre`  varchar(255),
   `apellidos`  varchar(255),
   `direccion`  varchar(255),
   `ciudad`  varchar(255),
   `codigo_postal`  varchar(255),
   `telefono`  varchar(255),
  primary key (`oid`)
);


-- Nivel [ent3]
create table `nivel` (
   `oid`  integer  not null,
  primary key (`oid`)
);


-- Group_DefaultModule [Group2DefaultModule_DefaultModule2Group]
alter table `group`  add column  `module_oid`  integer;
alter table `group`   add index fk_group_module (`module_oid`), add constraint fk_group_module foreign key (`module_oid`) references `module` (`oid`);


-- Group_Module [Group2Module_Module2Group]
create table `group_module` (
   `group_oid`  integer not null,
   `module_oid`  integer not null,
  primary key (`group_oid`, `module_oid`)
);
alter table `group_module`   add index fk_group_module_group (`group_oid`), add constraint fk_group_module_group foreign key (`group_oid`) references `group` (`oid`);
alter table `group_module`   add index fk_group_module_module (`module_oid`), add constraint fk_group_module_module foreign key (`module_oid`) references `module` (`oid`);


-- User_DefaultGroup [User2DefaultGroup_DefaultGroup2User]
alter table `user`  add column  `group_oid`  integer;
alter table `user`   add index fk_user_group (`group_oid`), add constraint fk_user_group foreign key (`group_oid`) references `group` (`oid`);


-- User_Group [User2Group_Group2User]
create table `user_group` (
   `user_oid`  integer not null,
   `group_oid`  integer not null,
  primary key (`user_oid`, `group_oid`)
);
alter table `user_group`   add index fk_user_group_user (`user_oid`), add constraint fk_user_group_user foreign key (`user_oid`) references `user` (`oid`);
alter table `user_group`   add index fk_user_group_group (`group_oid`), add constraint fk_user_group_group foreign key (`group_oid`) references `group` (`oid`);


-- Fotografo_Solicitud [rel1]
alter table `fotografo`  add column  `solicitud_oid`  integer;
alter table `fotografo`   add index fk_fotografo_solicitud (`solicitud_oid`), add constraint fk_fotografo_solicitud foreign key (`solicitud_oid`) references `solicitud` (`oid`);


