-- Curso [ent4]
create table `curso` (
   `oid`  integer  not null,
   `nombre`  varchar(255),
   `precio`  double precision,
   `capacidad`  integer,
   `fechainicio`  date,
   `fechafin`  date,
  primary key (`oid`)
);


-- Materia [ent5]
create table `materia` (
   `oid`  integer  not null,
   `nombre`  varchar(255),
   `horas`  integer,
  primary key (`oid`)
);


-- Profesor [ent6]
create table `profesor` (
   `oid`  integer  not null,
   `nombre`  varchar(255),
   `apellidos`  varchar(255),
   `direccion`  varchar(255),
   `telefono`  integer,
   `sueldo`  double precision,
  primary key (`oid`)
);


-- Curso_Materia [rel3]
create table `curso_materia` (
   `curso_oid`  integer not null,
   `materia_oid`  integer not null,
  primary key (`curso_oid`, `materia_oid`)
);
alter table `curso_materia`   add index fk_curso_materia_curso (`curso_oid`), add constraint fk_curso_materia_curso foreign key (`curso_oid`) references `curso` (`oid`);
alter table `curso_materia`   add index fk_curso_materia_materia (`materia_oid`), add constraint fk_curso_materia_materia foreign key (`materia_oid`) references `materia` (`oid`);


-- Materia_Profesor [rel4]
alter table `materia`  add column  `profesor_oid`  integer;
alter table `materia`   add index fk_materia_profesor (`profesor_oid`), add constraint fk_materia_profesor foreign key (`profesor_oid`) references `profesor` (`oid`);


-- Cliente_Curso [rel5]
create table `cliente_curso` (
   `cliente_oid`  integer not null,
   `curso_oid`  integer not null,
  primary key (`cliente_oid`, `curso_oid`)
);
alter table `cliente_curso`   add index fk_cliente_curso_cliente (`cliente_oid`), add constraint fk_cliente_curso_cliente foreign key (`cliente_oid`) references `cliente` (`oid`);
alter table `cliente_curso`   add index fk_cliente_curso_curso (`curso_oid`), add constraint fk_cliente_curso_curso foreign key (`curso_oid`) references `curso` (`oid`);


-- Curso.duracionHoras [ent4#att20]
create view `curso_duracionhoras_view` as
select AL1.`oid` as `oid`, sum(AL3.`horas`) as `der_attr`
from  `curso` AL1 
               left outer join `curso_materia` AL2 on AL1.`oid`=AL2.`curso_oid`
               left outer join `materia` AL3 on AL2.`materia_oid`=AL3.`oid`
group by AL1.`oid`;


