-- Group [Group]
create table `group` (
   `oid`  integer  not null,
   `groupname`  varchar(255),
  primary key (`oid`)
);


-- Module [Module]
create table `module` (
   `oid`  integer  not null,
   `moduleid`  varchar(255),
   `modulename`  varchar(255),
  primary key (`oid`)
);


-- User [User]
create table `user` (
   `oid`  integer  not null,
   `username`  varchar(255),
   `password`  varchar(255),
   `email`  varchar(255),
  primary key (`oid`)
);


-- Cliente [ent1]
create table `cliente` (
   `oid`  integer  not null,
   `dni`  varchar(255),
   `nombre`  varchar(255),
   `apellidos`  varchar(255),
   `direccion`  varchar(255),
   `codigopostal`  integer,
   `ciudad`  varchar(255),
   `telefono`  integer,
  primary key (`oid`)
);


-- FichaReparacion [ent2]
create table `fichareparacion` (
   `oid`  integer  not null,
   `fechareparacion`  varchar(255),
   `descripcion`  varchar(255),
   `importe`  double precision,
   `nombretecnico`  varchar(255),
   `pagado`  bit,
  primary key (`oid`)
);


-- Factura [ent3]
create table `factura` (
   `oid`  integer  not null,
   `fechacreacion`  varchar(255),
  primary key (`oid`)
);


-- Group_DefaultModule [Group2DefaultModule_DefaultModule2Group]
alter table `group`  add column  `module_oid`  integer;
alter table `group`   add index fk_group_module (`module_oid`), add constraint fk_group_module foreign key (`module_oid`) references `module` (`oid`);


-- Group_Module [Group2Module_Module2Group]
create table `group_module` (
   `group_oid`  integer not null,
   `module_oid`  integer not null,
  primary key (`group_oid`, `module_oid`)
);
alter table `group_module`   add index fk_group_module_group (`group_oid`), add constraint fk_group_module_group foreign key (`group_oid`) references `group` (`oid`);
alter table `group_module`   add index fk_group_module_module (`module_oid`), add constraint fk_group_module_module foreign key (`module_oid`) references `module` (`oid`);


-- User_DefaultGroup [User2DefaultGroup_DefaultGroup2User]
alter table `user`  add column  `group_oid`  integer;
alter table `user`   add index fk_user_group (`group_oid`), add constraint fk_user_group foreign key (`group_oid`) references `group` (`oid`);


-- User_Group [User2Group_Group2User]
create table `user_group` (
   `user_oid`  integer not null,
   `group_oid`  integer not null,
  primary key (`user_oid`, `group_oid`)
);
alter table `user_group`   add index fk_user_group_user (`user_oid`), add constraint fk_user_group_user foreign key (`user_oid`) references `user` (`oid`);
alter table `user_group`   add index fk_user_group_group (`group_oid`), add constraint fk_user_group_group foreign key (`group_oid`) references `group` (`oid`);


-- FichaReparacion_Cliente [rel1]
alter table `fichareparacion`  add column  `cliente_oid`  integer;
alter table `fichareparacion`   add index fk_fichareparacion_cliente (`cliente_oid`), add constraint fk_fichareparacion_cliente foreign key (`cliente_oid`) references `cliente` (`oid`);


-- FichaReparacion_Factura [rel2]
alter table `fichareparacion`  add column  `factura_oid`  integer;
alter table `fichareparacion`   add index fk_fichareparacion_factura (`factura_oid`), add constraint fk_fichareparacion_factura foreign key (`factura_oid`) references `factura` (`oid`);


-- Factura.toalAPagar [ent3#att17]
create view `factura_toalapagar_view` as
select AL1.`oid` as `oid`, sum(AL2.`importe`) as `der_attr`
from  `factura` AL1 
               left outer join `fichareparacion` AL2 on AL1.`oid`=AL2.`factura_oid`
group by AL1.`oid`;


