import { AlphaOrbital, Basis } from '../../extensions/alpha-orbitals/data-model';
import { SphericalBasisOrder } from '../../extensions/alpha-orbitals/spherical-functions';

export const DemoMoleculeSDF = `60823
  -OEChem-10232017443D

 76 79  0     1  0  0  0  0  0999 V2000
    4.2325    4.8495   -0.2414 F   0  0  0  0  0  0  0  0  0  0  0  0
    3.3901   -2.4373    3.0602 O   0  0  0  0  0  0  0  0  0  0  0  0
    5.8234   -0.9362   -0.1694 O   0  0  0  0  0  0  0  0  0  0  0  0
   -4.0484   -0.0236    1.5867 O   0  0  0  0  0  0  0  0  0  0  0  0
    5.9513   -3.8220   -3.4785 O   0  0  0  0  0  0  0  0  0  0  0  0
    5.7344   -1.5960   -3.0713 O   0  0  0  0  0  0  0  0  0  0  0  0
    0.3212    0.0758    1.5166 N   0  0  0  0  0  0  0  0  0  0  0  0
   -3.4511   -1.1575   -0.3628 N   0  0  0  0  0  0  0  0  0  0  0  0
   -0.8535   -0.6250    1.5997 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.5803   -0.3344    2.1283 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.1278    1.2100    0.7719 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.9533   -1.9004    2.3428 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.4473   -1.2165    1.2192 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.8115    0.0728    0.8978 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.1907    1.2338    0.3742 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.7416   -1.7120    1.8781 C   0  0  2  0  0  0  0  0  0  0  0  0
    4.5791   -2.6487    0.9881 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.1949    2.1553    0.5088 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.3241   -3.0999    1.4405 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.9352   -1.8320    3.5352 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.7591    2.2833   -0.4268 C   0  0  0  0  0  0  0  0  0  0  0  0
    5.0315   -2.1044   -0.3741 C   0  0  2  0  0  0  0  0  0  0  0  0
   -3.1792   -0.3427    0.7529 C   0  0  0  0  0  0  0  0  0  0  0  0
    5.8126   -3.1249   -1.2008 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.9989    2.0028   -0.6208 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.4170    3.2178    1.3848 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.3259    3.4003    0.1871 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.7439    2.1847   -1.8182 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.0251    2.9131   -0.8744 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.4429    4.1280    1.1313 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.8777    4.4186   -0.5902 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.2957    3.2032   -2.5955 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.2469    3.9758    0.0018 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.6784   -1.7492   -0.7544 C   0  0  0  0  0  0  0  0  0  0  0  0
    5.8309   -2.7456   -2.6619 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.8626    4.3200   -1.9814 C   0  0  0  0  0  0  0  0  0  0  0  0
   -5.8255   -1.5489    0.0136 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.7392   -2.5312   -1.9079 C   0  0  0  0  0  0  0  0  0  0  0  0
   -7.0333   -2.1307   -0.3717 C   0  0  0  0  0  0  0  0  0  0  0  0
   -5.9471   -3.1129   -2.2932 C   0  0  0  0  0  0  0  0  0  0  0  0
   -7.0940   -2.9125   -1.5250 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.1382    0.5731    2.3855 H   0  0  0  0  0  0  0  0  0  0  0  0
    1.3708   -0.8002    3.0947 H   0  0  0  0  0  0  0  0  0  0  0  0
    0.0077   -2.1843    2.7778 H   0  0  0  0  0  0  0  0  0  0  0  0
    1.8521   -2.0869    0.9138 H   0  0  0  0  0  0  0  0  0  0  0  0
    2.6842   -0.6643    0.3050 H   0  0  0  0  0  0  0  0  0  0  0  0
    4.3434   -0.8508    2.1898 H   0  0  0  0  0  0  0  0  0  0  0  0
    5.4691   -2.9413    1.5624 H   0  0  0  0  0  0  0  0  0  0  0  0
    4.0142   -3.5780    0.8346 H   0  0  0  0  0  0  0  0  0  0  0  0
   -0.6944   -3.1286    0.5448 H   0  0  0  0  0  0  0  0  0  0  0  0
   -1.1783   -4.0399    1.9847 H   0  0  0  0  0  0  0  0  0  0  0  0
   -2.3703   -3.0713    1.1264 H   0  0  0  0  0  0  0  0  0  0  0  0
   -1.8631   -2.7437    4.1386 H   0  0  0  0  0  0  0  0  0  0  0  0
   -1.7020   -0.9798    4.1827 H   0  0  0  0  0  0  0  0  0  0  0  0
   -2.9745   -1.7380    3.2088 H   0  0  0  0  0  0  0  0  0  0  0  0
    4.1475   -1.8000   -0.9464 H   0  0  0  0  0  0  0  0  0  0  0  0
    6.8506   -3.2027   -0.8609 H   0  0  0  0  0  0  0  0  0  0  0  0
    5.3309   -4.1061   -1.1198 H   0  0  0  0  0  0  0  0  0  0  0  0
    1.8373    1.1817   -1.3152 H   0  0  0  0  0  0  0  0  0  0  0  0
    0.7989    3.3503    2.2697 H   0  0  0  0  0  0  0  0  0  0  0  0
    4.2168   -2.6972    3.5013 H   0  0  0  0  0  0  0  0  0  0  0  0
   -2.3461    3.4925    1.2706 H   0  0  0  0  0  0  0  0  0  0  0  0
   -1.3066    1.3204   -2.3125 H   0  0  0  0  0  0  0  0  0  0  0  0
   -2.6662   -1.3612   -0.9788 H   0  0  0  0  0  0  0  0  0  0  0  0
    3.6513    2.7948   -1.7537 H   0  0  0  0  0  0  0  0  0  0  0  0
    2.6161    4.9554    1.8131 H   0  0  0  0  0  0  0  0  0  0  0  0
    5.2440   -0.2436    0.1902 H   0  0  0  0  0  0  0  0  0  0  0  0
   -3.3191    5.2883   -0.1123 H   0  0  0  0  0  0  0  0  0  0  0  0
   -2.2842    3.1265   -3.6788 H   0  0  0  0  0  0  0  0  0  0  0  0
   -3.2921    5.1128   -2.5867 H   0  0  0  0  0  0  0  0  0  0  0  0
   -5.8624   -0.9592    0.9179 H   0  0  0  0  0  0  0  0  0  0  0  0
   -3.8528   -2.6952   -2.5153 H   0  0  0  0  0  0  0  0  0  0  0  0
    5.9549   -3.5647   -4.4251 H   0  0  0  0  0  0  0  0  0  0  0  0
   -7.9272   -1.9757    0.2256 H   0  0  0  0  0  0  0  0  0  0  0  0
   -5.9946   -3.7218   -3.1913 H   0  0  0  0  0  0  0  0  0  0  0  0
   -8.0344   -3.3656   -1.8250 H   0  0  0  0  0  0  0  0  0  0  0  0
  1 33  1  0  0  0  0
  2 16  1  0  0  0  0
  2 61  1  0  0  0  0
  3 22  1  0  0  0  0
  3 67  1  0  0  0  0
  4 23  2  0  0  0  0
  5 35  1  0  0  0  0
  5 73  1  0  0  0  0
  6 35  2  0  0  0  0
  7  9  1  0  0  0  0
  7 10  1  0  0  0  0
  7 11  1  0  0  0  0
  8 23  1  0  0  0  0
  8 34  1  0  0  0  0
  8 64  1  0  0  0  0
  9 12  1  0  0  0  0
  9 14  2  0  0  0  0
 10 13  1  0  0  0  0
 10 42  1  0  0  0  0
 10 43  1  0  0  0  0
 11 15  2  0  0  0  0
 11 18  1  0  0  0  0
 12 19  1  0  0  0  0
 12 20  1  0  0  0  0
 12 44  1  0  0  0  0
 13 16  1  0  0  0  0
 13 45  1  0  0  0  0
 13 46  1  0  0  0  0
 14 15  1  0  0  0  0
 14 23  1  0  0  0  0
 15 21  1  0  0  0  0
 16 17  1  0  0  0  0
 16 47  1  0  0  0  0
 17 22  1  0  0  0  0
 17 48  1  0  0  0  0
 17 49  1  0  0  0  0
 18 25  2  0  0  0  0
 18 26  1  0  0  0  0
 19 50  1  0  0  0  0
 19 51  1  0  0  0  0
 19 52  1  0  0  0  0
 20 53  1  0  0  0  0
 20 54  1  0  0  0  0
 20 55  1  0  0  0  0
 21 27  2  0  0  0  0
 21 28  1  0  0  0  0
 22 24  1  0  0  0  0
 22 56  1  0  0  0  0
 24 35  1  0  0  0  0
 24 57  1  0  0  0  0
 24 58  1  0  0  0  0
 25 29  1  0  0  0  0
 25 59  1  0  0  0  0
 26 30  2  0  0  0  0
 26 60  1  0  0  0  0
 27 31  1  0  0  0  0
 27 62  1  0  0  0  0
 28 32  2  0  0  0  0
 28 63  1  0  0  0  0
 29 33  2  0  0  0  0
 29 65  1  0  0  0  0
 30 33  1  0  0  0  0
 30 66  1  0  0  0  0
 31 36  2  0  0  0  0
 31 68  1  0  0  0  0
 32 36  1  0  0  0  0
 32 69  1  0  0  0  0
 34 37  2  0  0  0  0
 34 38  1  0  0  0  0
 36 70  1  0  0  0  0
 37 39  1  0  0  0  0
 37 71  1  0  0  0  0
 38 40  2  0  0  0  0
 38 72  1  0  0  0  0
 39 41  2  0  0  0  0
 39 74  1  0  0  0  0
 40 41  1  0  0  0  0
 40 75  1  0  0  0  0
 41 76  1  0  0  0  0
M  END
`;

export const DemoOrbitals = {
    order: 'cca-reverse' as SphericalBasisOrder,
    basis: <Basis>{
        'atoms': [
            {
                'center': [
                    7.9982659673182726,
                    9.164227180945113,
                    -0.45617989301045103
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987538,
                                -0.020670241479937942,
                                -0.05150303336984537,
                                0.3346271173989955,
                                0.5621061300983123,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            243.87996338407,
                            44.725105704361845,
                            12.568719598666123,
                            1.7973548076770884,
                            0.8157501538300561,
                            0.38902663868632525
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294427,
                                0.05144104825191133,
                                0.18984000600705359,
                                0.40498631911504746,
                                0.4012362861149081,
                                0.10518551890390816
                            ]
                        ],
                        'exponents': [
                            29.892249929549273,
                            7.795290904812277,
                            2.7892293600247955,
                            1.1659511881516988,
                            0.5331523085181105,
                            0.252055600111504
                        ]
                    }
                ]
            },
            {
                'center': [
                    6.406360539951738,
                    -4.6058294212173765,
                    5.782939841645602
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987536,
                                -0.02067024147993795,
                                -0.05150303336984537,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            152.28769660788095,
                            27.928015215973073,
                            7.848374792384515,
                            1.1223350202705642,
                            0.5093846587907856,
                            0.24292266532510307
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911314,
                                0.18984000600705359,
                                0.4049863191150474,
                                0.40123628611490797,
                                0.1051855189039082
                            ]
                        ],
                        'exponents': [
                            27.203421487167727,
                            7.09409912597673,
                            2.5383362605345954,
                            1.0610730767843852,
                            0.4851948916410433,
                            0.22938302550642545
                        ]
                    }
                ]
            },
            {
                'center': [
                    11.00463115398788,
                    -1.7691616409137099,
                    -0.3201196178831781
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987536,
                                -0.02067024147993795,
                                -0.05150303336984537,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            152.28769660788095,
                            27.928015215973073,
                            7.848374792384515,
                            1.1223350202705642,
                            0.5093846587907856,
                            0.24292266532510307
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911314,
                                0.18984000600705359,
                                0.4049863191150474,
                                0.40123628611490797,
                                0.1051855189039082
                            ]
                        ],
                        'exponents': [
                            27.203421487167727,
                            7.09409912597673,
                            2.5383362605345954,
                            1.0610730767843852,
                            0.4851948916410433,
                            0.22938302550642545
                        ]
                    }
                ]
            },
            {
                'center': [
                    -7.650367102279911,
                    -0.04459754174304873,
                    2.9984283715474382
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987536,
                                -0.02067024147993795,
                                -0.05150303336984537,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            152.28769660788095,
                            27.928015215973073,
                            7.848374792384515,
                            1.1223350202705642,
                            0.5093846587907856,
                            0.24292266532510307
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911314,
                                0.18984000600705359,
                                0.4049863191150474,
                                0.40123628611490797,
                                0.1051855189039082
                            ]
                        ],
                        'exponents': [
                            27.203421487167727,
                            7.09409912597673,
                            2.5383362605345954,
                            1.0610730767843852,
                            0.4851948916410433,
                            0.22938302550642545
                        ]
                    }
                ]
            },
            {
                'center': [
                    11.246327358910564,
                    -7.222533299381363,
                    -6.5734121160040475
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987536,
                                -0.02067024147993795,
                                -0.05150303336984537,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            152.28769660788095,
                            27.928015215973073,
                            7.848374792384515,
                            1.1223350202705642,
                            0.5093846587907856,
                            0.24292266532510307
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911314,
                                0.18984000600705359,
                                0.4049863191150474,
                                0.40123628611490797,
                                0.1051855189039082
                            ]
                        ],
                        'exponents': [
                            27.203421487167727,
                            7.09409912597673,
                            2.5383362605345954,
                            1.0610730767843852,
                            0.4851948916410433,
                            0.22938302550642545
                        ]
                    }
                ]
            },
            {
                'center': [
                    10.83644510356695,
                    -3.0160028122530727,
                    -5.803915903273829
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987536,
                                -0.02067024147993795,
                                -0.05150303336984537,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            152.28769660788095,
                            27.928015215973073,
                            7.848374792384515,
                            1.1223350202705642,
                            0.5093846587907856,
                            0.24292266532510307
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911314,
                                0.18984000600705359,
                                0.4049863191150474,
                                0.40123628611490797,
                                0.1051855189039082
                            ]
                        ],
                        'exponents': [
                            27.203421487167727,
                            7.09409912597673,
                            2.5383362605345954,
                            1.0610730767843852,
                            0.4851948916410433,
                            0.22938302550642545
                        ]
                    }
                ]
            },
            {
                'center': [
                    0.6069800561503955,
                    0.14324124332225513,
                    2.865958664994997
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.020670241479937936,
                                -0.051503033369845366,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            116.35365971147681,
                            21.33807819828902,
                            5.996460319657777,
                            0.8575071390506321,
                            0.3891894786733718,
                            0.18560226313108005
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911294,
                                0.18984000600705356,
                                0.4049863191150474,
                                0.40123628611490814,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            26.217456931594718,
                            6.836979620063331,
                            2.44633645145935,
                            1.022615398029685,
                            0.4676094211542217,
                            0.22106923553312668
                        ]
                    }
                ]
            },
            {
                'center': [
                    -6.521634039012388,
                    -2.187358043501701,
                    -0.6855926420360381
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.020670241479937936,
                                -0.051503033369845366,
                                0.33462711739899537,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            116.35365971147681,
                            21.33807819828902,
                            5.996460319657777,
                            0.8575071390506321,
                            0.3891894786733718,
                            0.18560226313108005
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.051441048251911294,
                                0.18984000600705356,
                                0.4049863191150474,
                                0.40123628611490814,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            26.217456931594718,
                            6.836979620063331,
                            2.44633645145935,
                            1.022615398029685,
                            0.4676094211542217,
                            0.22106923553312668
                        ]
                    }
                ]
            },
            {
                'center': [
                    -1.612881263721852,
                    -1.1810788279893105,
                    3.022994832795815
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    2.986334144893717,
                    -0.6319244127032525,
                    4.021904019824529
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    0.24150700383842194,
                    2.286568683074636,
                    1.4586795922957698
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -1.801475913313789,
                    -3.5912356079147907,
                    4.42725017987693
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    4.624726664443373,
                    -2.2988519136988246,
                    2.3039541198098035
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.423238786737237,
                    0.1375720534589881,
                    1.6965960557184734
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -2.250096999143005,
                    2.331544194039838,
                    0.7071355466209848
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    7.070599337691524,
                    -3.2352111490567017,
                    3.5490947059607794
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    8.653245147415527,
                    -5.0053175845498385,
                    1.8672383693002959
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    2.258033814265174,
                    4.072926531480137,
                    0.9614925958812015
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -2.502186394985206,
                    -5.857962027911094,
                    2.722150522397795
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.6569979512648434,
                    -3.461978293041566,
                    6.680560021244969
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.3242171511347696,
                    4.31481151510038,
                    -0.8065351338461595
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    9.508156737330754,
                    -3.97673950488886,
                    -0.7069465426505175
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -6.007817171198703,
                    -0.6476091516135785,
                    1.422774807639086
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    10.984222329543963,
                    -5.905205361248994,
                    -2.2691830210665596
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    3.777373656436472,
                    3.78474345964724,
                    -1.173142012867141
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    2.6777420233439946,
                    6.0807605390619655,
                    2.616892656861545
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -4.395314140690695,
                    6.425635791118669,
                    0.3535677733104924
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.295493278354841,
                    4.128484687881141,
                    -3.43590002530236
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    5.716610486384148,
                    5.504961182034663,
                    -1.6523765606351404
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    4.616411841380269,
                    7.800789032206012,
                    2.137847113064013
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -5.438065040134716,
                    8.349944010674342,
                    -1.1153163720028036
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -4.338244403071771,
                    6.053170915377748,
                    -4.904784142456543
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    6.135751908824475,
                    7.513173197557426,
                    0.0034015100460821034
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -8.840894777155128,
                    -3.3055089118792407,
                    -1.4256094166502764
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    11.01880442431674,
                    -5.188432020089862,
                    -5.0302620537391505
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -5.409530171325255,
                    8.163617183455102,
                    -3.744303368154524
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -11.008599561548964,
                    -2.926996810175005,
                    0.02570027915766187
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -8.955790268274843,
                    -4.783274638735019,
                    -3.6054084276978338
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -13.291010607819139,
                    -4.026439664569924,
                    -0.7024111794962584
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -11.238390543788395,
                    -5.882528489159472,
                    -4.333519979628818
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    -13.405716869695478,
                    -5.50382715821186,
                    -2.881832295239336
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.004151277818987537,
                                -0.02067024147993795,
                                -0.05150303336984539,
                                0.3346271173989954,
                                0.5621061300983125,
                                0.17129946969948573
                            ]
                        ],
                        'exponents': [
                            106.38971661757036,
                            19.510792340428665,
                            5.4829535718846785,
                            0.7840745340315375,
                            0.355861246214981,
                            0.16970821740424916
                        ]
                    },
                    {
                        'angularMomentum': [1],
                        'coefficients': [
                            [
                                0.007924233646294425,
                                0.05144104825191133,
                                0.18984000600705356,
                                0.40498631911504746,
                                0.401236286114908,
                                0.10518551890390819
                            ]
                        ],
                        'exponents': [
                            19.697346208514826,
                            5.136667333842591,
                            1.8379485147102494,
                            0.7682976112330235,
                            0.3513180047504199,
                            0.166090756998636
                        ]
                    }
                ]
            },
            {
                'center': [
                    4.040612484352967,
                    1.0830019869662701,
                    4.507941584164803
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    2.590436606454314,
                    -1.5121588176580882,
                    5.848135623630071
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    0.014550890202010487,
                    -4.127728671999272,
                    5.249281386572312
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    3.4999617834640255,
                    -3.943669441879821,
                    1.726831734989231
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    5.072402955693161,
                    -1.2553451110093883,
                    0.576366481575158
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    8.207836453265527,
                    -1.6077789449744184,
                    4.1381223134646055
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    10.335101146166647,
                    -5.55825129079006,
                    2.952508066002809
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    7.585739008025571,
                    -6.7614402042304,
                    1.5771653703991808
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -1.3122258446578443,
                    -5.912196931245918,
                    1.0295227616039515
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -2.2266643364445224,
                    -7.634304242792196,
                    3.7505393728153975
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -4.479217936657784,
                    -5.803915903273829,
                    2.128587495421482
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.520748841121785,
                    -5.184841620469712,
                    7.8208202992548115
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -3.2163139058307055,
                    -1.8515536303899698,
                    7.904157759129225
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -5.620990246431364,
                    -3.2843440715534555,
                    6.063753335540641
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    7.837639174624395,
                    -3.4015069345000506,
                    -1.788436779444186
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    12.945757347821502,
                    -6.052225670252503,
                    -1.6268651921708819
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    10.073941361925291,
                    -7.759404596679687,
                    -2.1161152608268265
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    3.471993701293057,
                    2.233089345075863,
                    -2.485367744888531
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    1.5097022165878324,
                    6.331149574988688,
                    4.289111480575017
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    7.968597525231825,
                    -5.096969416941539,
                    6.616498263083304
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -4.4334866350836215,
                    6.599868616957096,
                    2.401085940980508
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -2.469116106703258,
                    2.4951943744424634,
                    -4.369991663560449
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -5.038387647558878,
                    -2.5722951538372776,
                    -1.8496639285946612
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    6.8999569114732475,
                    5.281406655001923,
                    -3.3140127389128113
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    4.943712652731338,
                    9.36434882000646,
                    3.426262399718895
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    9.909723719065447,
                    -0.46033727638288935,
                    0.3594259108259994
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -6.272189797665092,
                    9.993438736334976,
                    -0.21221624586310278
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -4.316512325561676,
                    5.9082285236848335,
                    -6.9519246682541
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -6.221167286009484,
                    9.661791960027706,
                    -4.888154496330335
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -11.078330537733011,
                    -1.812625345388083,
                    1.7345796587773876
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -7.2807366102772715,
                    -5.093189788078012,
                    -4.753228188707638
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    11.253129699664113,
                    -6.736306505797713,
                    -8.362226790752713
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -14.980236635053936,
                    -3.7335319440211645,
                    0.4263222216806279
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -11.328151885929605,
                    -7.033182859180466,
                    -6.030682821985784
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            },
            {
                'center': [
                    -15.182815551004266,
                    -6.360062451739084,
                    -3.44875026783795
                ],
                'shells': [
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                0.009163596280542963,
                                0.04936149294292479,
                                0.16853830490998634,
                                0.37056279972195677,
                                0.4164915298246781,
                                0.13033408410772263
                            ]
                        ],
                        'exponents': [
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    },
                    {
                        'angularMomentum': [0],
                        'coefficients': [
                            [
                                -0.32279868167000036,
                                3.209629817295221,
                                2.4672629224617935,
                                -0.048487066612842224,
                                -0.2611850111200143,
                                -0.8917817597810863,
                                -1.9607480081275706,
                                -2.203769342520311,
                                -0.6896328935259993
                            ]
                        ],
                        'exponents': [
                            10.256286070314905,
                            0.6227965325875392,
                            0.2391007667853915,
                            33.710073211949485,
                            6.180705022740464,
                            1.7291385346152253,
                            0.5940057549921978,
                            0.2306698170449518,
                            0.09500256906284119
                        ]
                    }
                ]
            }
        ]
    },
    orbitals: <AlphaOrbital[]>[
        {
            'energy': -0.864359888219898,
            'occupancy': 2,
            'alpha': [
                -0.8759841529727774,
                0.024882741837564518,
                -0.006139318743660939,
                0.022058302037615093,
                0.000004668780379617914,
                -7.577925063247083e-7,
                -0.000001150158260614514,
                0.000002208330219975823,
                0.000028695578448024413,
                -0.000009153790798216256,
                0.0000029555391538223283,
                0.000010599043967314515,
                -5.506869029365343e-7,
                -2.459752666754038e-7,
                1.678142201384592e-7,
                5.6505941139693264e-8,
                -1.9050786157602338e-7,
                1.3981080094722672e-7,
                -3.1706968168812986e-7,
                -2.5541314678425993e-7,
                -4.2124629737283596e-7,
                -3.0430508766705885e-7,
                -5.727537423218497e-7,
                0.0000013230592452899207,
                0.00007363595344993326,
                0.000014964579152669367,
                -0.000004846073042754847,
                0.000014023324073331385,
                -7.639465338359384e-7,
                1.3196702547451926e-7,
                -2.198745298369962e-7,
                -1.1105738002142307e-7,
                0.000010904829752437806,
                0.000013461895160297674,
                -0.0000014404485452241817,
                0.000009353510019262251,
                0.000020978750652669406,
                -0.00002063720503144495,
                -0.000020758090302771263,
                -0.000005918127311247515,
                0.0000658068552470532,
                0.00006160002400881273,
                -0.000003735102352201719,
                0.00003611903714317839,
                1.5643151243753512e-7,
                0.0000020647966754731907,
                -2.478650863116987e-7,
                0.0000016495013018715217,
                0.000017306854397297778,
                -0.000009268613438520705,
                0.0000060550471843338035,
                0.000008859665624164354,
                0.0000025834021302885596,
                0.000005616597804135486,
                2.417860563529898e-7,
                0.0000024880942196876944,
                0.000016291528561233912,
                0.000021581322618986768,
                0.0000025316309880127896,
                0.000006241547013305703,
                0.000006401500596294066,
                -0.000007344825200075789,
                0.00000267260281889985,
                0.000006269869766244081,
                -0.000006559288916775191,
                -0.0000031389654815966686,
                0.000001282514431913544,
                -0.000001190082461207664,
                0.0007491102119006935,
                0.00028434491250207066,
                -0.00006442698293604779,
                0.00024276439896181063,
                -5.738791415398654e-7,
                1.3282853843355463e-7,
                -3.974833146070595e-7,
                1.9825281996781498e-8,
                -3.996547976721523e-7,
                4.23117665104165e-8,
                2.3759260690879997e-7,
                4.841767119465773e-7,
                0.000007056581492979875,
                0.00001174248305611794,
                0.000003105977161959623,
                4.316575064194944e-7,
                -0.000003748993776566404,
                -0.000006787180677928357,
                -0.000002987998673896393,
                0.0000074356741878884845,
                -7.28001011211322e-7,
                2.979171193045871e-7,
                5.2331661342400876e-8,
                1.3924435731202039e-7,
                -0.000005702240805089722,
                7.253857042929886e-7,
                -0.000001032815639718123,
                -0.0000023307398306998494,
                0.0018479147471368276,
                -0.000012661974529035651,
                0.00012131133071381384,
                0.00009096569100171858,
                0.0018337966084659815,
                0.00005137301753584694,
                -0.00011972360449322394,
                -0.000063058675905584,
                0.0000053014897925081116,
                0.000008299545009224367,
                0.000004864000009094032,
                1.2218364616842188e-7,
                0.0000054650679290065505,
                0.000009453427551515387,
                0.0000013521640653127336,
                -0.0000020595496449067903,
                -0.00270674210557725,
                -0.010518353272982827,
                -0.005372558051376404,
                -0.01673838409808351,
                -0.002708495368111458,
                -0.015511976887913314,
                0.011798661524279776,
                -0.0063492601782711095,
                -4.1021629953715515e-7,
                9.358442931843062e-7,
                6.779508200053642e-7,
                3.067064753490432e-7,
                -4.0605758546504523e-7,
                0.0000011947324588731076,
                -1.3280895018694397e-7,
                -2.014140725656389e-7,
                -0.14490327020228944,
                -0.158319618140783,
                0.0390666527387902,
                -0.14034460757240041,
                -2.375802001892905e-7,
                -1.44206647641762e-7,
                -2.6708910750277984e-8,
                -5.647069279580992e-8,
                -0.000003168988709936439,
                8.164191366054324e-7,
                -0.0000015218668097155107,
                -9.257270260468784e-7,
                -7.414398855240241e-7,
                1.479295174139143e-7,
                -3.273813030833963e-8,
                1.2469386591445418e-7,
                -3.688803056243248e-8,
                -5.525373367055705e-8,
                1.0366188622177338e-8,
                -6.547440402063559e-9,
                -1.1517401586351205e-7,
                -8.499750359404403e-8,
                -3.568070792423901e-8,
                -4.680732048968043e-8,
                1.0466620066281951e-9,
                -5.382711500299779e-9,
                1.5718034978448652e-10,
                -1.2224532296894278e-9,
                -1.8777236323516e-10,
                -1.1689272630261912e-8,
                -5.1682203602017065e-9,
                -6.4836741118827116e-9,
                1.66459656452743e-9,
                -1.415806973060829e-9,
                -6.019097994769463e-10,
                -7.486562182424619e-10,
                0.00006481231111107328,
                0.00021831375314981528,
                0.000018674096971123254,
                -0.000005485211862156977,
                0.000001828132588893921,
                -0.0000053156034511985914,
                0.000011979041292743437,
                -0.000009593727570865742,
                0.00006993145639664658,
                0.00009372487134380487,
                0.00000971367700318725,
                -0.00000853610361288678,
                -0.00000436313622036128,
                0.000003021522566310343,
                -0.000001916729447260756,
                4.412520904555489e-7,
                8.813222083355685e-8,
                -0.000002710813309966206,
                -6.336819597110317e-7,
                1.463142221815505e-7,
                -4.305184784305129e-7,
                -1.4054668854891991e-7,
                -6.020025357467269e-7,
                -1.3283505053915857e-8,
                4.5137726045660457e-7,
                -0.0000032298952259242833,
                -3.5233740035661494e-7,
                -2.8223866184680703e-7,
                0.000015293055232793295,
                -0.000042337958004967894,
                -0.000002580450310514352,
                0.0000032495676256532623,
                -0.0000020148427224504122,
                0.0000014869306363178217,
                0.00023505985691931388,
                0.0007693311295487272,
                0.0002278960091311578,
                0.0007601721520293446,
                6.250180419212223e-7,
                -0.0000017198467207117024,
                0.000017378314210527062,
                -0.000009958453720673564,
                0.00001769846571436422,
                -0.00001023757313818674,
                1.380558875613918e-7,
                -0.000002463036355599708,
                -0.0034942962521518858,
                0.004931598623549237,
                -0.0035548388990999484,
                0.005004717757921153,
                0.00006244439426093057,
                -0.00011502435821667621,
                1.928206797578742e-7,
                -0.00000359065103213329,
                1.916398053055882e-7,
                -0.000003587455099736447,
                -3.3611094095843253e-7,
                -1.5141399366604557e-7,
                -2.2336222978019512e-8,
                2.854802191240596e-8,
                -1.6422135695169323e-7,
                9.900362257306609e-8,
                -4.291359689167892e-8,
                1.2633597159741435e-7,
                1.3133605722251563e-9,
                2.403474112712709e-9,
                3.5951944874755856e-9,
                1.0647660185506745e-8,
                6.450762627898068e-10,
                1.023007405100827e-9
            ]
        },
        {
            'energy': -0.8412215947427871,
            'occupancy': 2,
            'alpha': [
                -0.0000010702700713600315,
                -8.26477752347512e-8,
                -1.8101347812388452e-8,
                3.794627159972257e-7,
                -0.00005760941315780318,
                -0.00001199526525558039,
                -3.557223320601553e-7,
                -0.000008182677437655518,
                -0.006434822931047276,
                0.0006424296586356681,
                0.0014358513741932063,
                0.0018744825969035188,
                1.5595520762589354e-7,
                8.444182347200493e-8,
                -5.145196622290962e-8,
                -2.762289876215074e-8,
                0.7648924557445113,
                -0.010207585335116696,
                0.03534971667540291,
                0.10135621006636802,
                0.022504017292371843,
                0.005699714379317236,
                -0.023366773122242578,
                -0.05501577042343241,
                -0.00002956110895613102,
                -0.000005252626987085549,
                0.000001714245647742483,
                0.0000018184063094924662,
                3.5461393298798796e-7,
                -7.601753338248113e-9,
                6.228130270255626e-8,
                5.373458943286451e-9,
                -0.000004814596689880166,
                -0.000006336285562406103,
                0.0000016477889692888224,
                -0.0000014178058863695316,
                -0.00003149844111432968,
                -0.000009011420090711756,
                0.000005178405568932746,
                0.000002143699736553719,
                -0.000007996350259614795,
                -0.000004638375866741797,
                -9.748137882149187e-7,
                0.00000629570919776885,
                -0.0000011802127821516584,
                -0.000002714188539782173,
                9.938429045866969e-7,
                -1.0111523849636158e-7,
                -0.0000048932257494755905,
                -0.000019577354820751525,
                -0.00004406915410833068,
                3.5275291870337344e-7,
                -3.1207921208847473e-7,
                -0.0000013248225475633959,
                -4.470630694647463e-8,
                9.671101845566387e-8,
                -7.247294535522018e-7,
                -0.0000014983414118886325,
                -2.1885247264111005e-7,
                7.844882131156179e-7,
                -0.00007664923545851581,
                -0.000017217994178092327,
                0.000012267489885382671,
                0.0000027274254685596313,
                0.00003727542917514059,
                -0.000029273063506701135,
                0.00015972676875607343,
                -0.0003039654674163887,
                -0.000006104375153765949,
                -0.0000029018499450754136,
                7.578057169951943e-7,
                0.0000048112142516868665,
                -7.423379761499107e-7,
                -0.0000014499975433881172,
                4.7591543227917824e-7,
                -1.6126262825098685e-7,
                7.986376666992157e-7,
                2.310666287042415e-7,
                -4.080523044999227e-8,
                -1.0984855155749807e-8,
                6.297111479679135e-9,
                -1.8887378601082902e-7,
                4.188358062988759e-9,
                8.181089631983381e-8,
                -0.003546093192596936,
                -0.0009867412242595005,
                -0.00005796206026405697,
                -0.0014476286845770854,
                2.681751678355553e-7,
                -2.9967769111424984e-8,
                -5.5704713825771784e-9,
                -6.078879520365855e-8,
                0.006227962591178636,
                0.001089815737044448,
                -0.025905020333855944,
                -0.006347598304611956,
                -0.000008317442839576202,
                -0.000004304327336722822,
                -0.000004746156764432379,
                0.0000034836781883844478,
                -5.333615677023395e-7,
                -4.902621388593305e-7,
                6.518476352083848e-7,
                0.0000011243962166969608,
                2.35466355675325e-8,
                -1.8365217410077457e-9,
                -4.46833083154471e-9,
                -3.920474105435943e-9,
                -1.3208730925905141e-7,
                -2.3511139334856794e-7,
                1.4860450526679516e-8,
                1.447181571843591e-7,
                -0.000006197899213371669,
                -0.000002047689483656007,
                -0.0000021460540274782347,
                0.000005255412910432281,
                -3.0712260693421063e-7,
                -3.028981456750483e-7,
                2.5360504568539564e-7,
                5.797346641860365e-7,
                7.296358486248762e-9,
                2.67473364858077e-9,
                -2.3041393956161492e-9,
                -6.3324712917795954e-9,
                5.79483177673817e-8,
                -1.1290493922052462e-8,
                2.234779897288417e-9,
                -1.1412840810241613e-8,
                -0.000001711663987898141,
                -6.882056453357151e-7,
                1.6529802245155827e-7,
                0.0000019177374823754407,
                7.804270619305974e-8,
                6.541052975037001e-8,
                2.4029145531882755e-8,
                1.5123951447959162e-8,
                0.19100765706521441,
                0.017260660150672846,
                -0.135050845076729,
                -0.1494986692000809,
                1.648128704310366e-8,
                5.076070713758612e-9,
                -2.2366378131610755e-9,
                -1.3006976591479131e-8,
                9.514622281070216e-9,
                1.787542227213656e-8,
                -1.9719741299565707e-9,
                -2.798627034135018e-10,
                2.6293423484958005e-8,
                2.4581683675210378e-8,
                1.2883997711022387e-8,
                8.592059472778609e-9,
                -2.7735500170335066e-10,
                1.3983503378419705e-9,
                3.033000614723884e-10,
                2.27382442858009e-10,
                -1.8116271995668494e-9,
                2.2441320854275195e-9,
                1.4655111051215936e-9,
                1.0444732399156348e-9,
                -7.610408136323553e-10,
                2.5321813922167206e-11,
                3.722573826518918e-10,
                1.1722822870010295e-10,
                -0.000024619661858503028,
                0.000013414647071050244,
                -0.000013455720943221782,
                0.000014559958597897467,
                -0.0000042444449808312075,
                0.000007025291477847252,
                0.000002791723943167972,
                -0.00008339263093489496,
                0.000026839834357169945,
                -0.00020451477810886558,
                -0.000059586866436281135,
                -0.00019298243110215722,
                0.00019971868595056083,
                -0.0007002751142256597,
                0.00016622322655742095,
                -0.00031784468487663063,
                -0.0000032202788881499595,
                0.000002454943508058528,
                -1.3255459159987134e-7,
                0.0000021880414525651515,
                4.115779837767024e-7,
                5.914548974887759e-7,
                5.34221172654255e-7,
                -1.8863206334857948e-7,
                6.583334324310926e-7,
                -5.166902468730993e-7,
                2.0139123287214464e-7,
                -2.1671038989666965e-7,
                -0.0011519864173929974,
                0.0010650052122166628,
                -0.00026958870349771583,
                0.005048788208950011,
                0.0032447991762123347,
                0.0038738295744390216,
                -0.000005884834452851692,
                -0.000018774563030562592,
                1.7149229695450433e-7,
                8.197607095875971e-7,
                -0.00007070073800312321,
                -0.00001866593517394564,
                2.8065808018747383e-8,
                2.5365302062972336e-8,
                -4.554977127258198e-7,
                9.212311255155862e-7,
                4.9933947012177285e-8,
                4.4465491128583304e-7,
                -0.000007451277204086379,
                -2.688067101354814e-7,
                -4.7163493891658427e-8,
                6.434760502245782e-7,
                -0.0005591149519642694,
                -0.0008141697448945443,
                1.7101513796642047e-9,
                1.7816156543416644e-9,
                4.087559783904262e-8,
                3.799310532508794e-8,
                3.865390845312843e-9,
                -3.555903119258317e-9,
                3.3519972033425665e-9,
                -1.8045659970920433e-9,
                3.805548898734406e-8,
                -4.1740711269884516e-8,
                0.11981636429355018,
                0.011101763558315518,
                -2.3924890341494038e-11,
                -9.160555011009262e-10,
                -1.820868712874859e-9,
                -2.484019687706681e-9,
                -2.0969816405648967e-10,
                -3.592578112674576e-10
            ]
        },
        {
            'energy': -0.8089239758559392,
            'occupancy': 2,
            'alpha': [
                -0.00009641119492833707,
                0.000015324327843949384,
                0.000002527786297094722,
                0.000005540723554331973,
                -0.015262634025603251,
                -0.0008134087357506397,
                0.0018842956769165346,
                -0.0014838834278231815,
                0.0013041749177558485,
                -0.0002276205664294018,
                0.000008466721832763809,
                -0.00005029215005318625,
                -0.006298474161745131,
                -0.0022444229339374264,
                0.0025832108131757623,
                0.0011761390562430184,
                0.000019240048065258708,
                -0.000004613570970363954,
                -0.000009356748656940296,
                0.000024379184274832313,
                0.00018635137731289584,
                -0.000004849285889431595,
                0.000030566817043664535,
                -0.0000424938491144705,
                0.7164248318982157,
                -0.005887452125142581,
                -0.0030901460961223685,
                0.0017772319893104213,
                -0.023579484526977296,
                -0.00037777485443791776,
                -0.0010718244618279288,
                -0.0007849626286859848,
                0.11769768550177051,
                0.11855740672405991,
                -0.009308210066698698,
                0.07221742624114859,
                0.11369138883841114,
                -0.11414127544249339,
                -0.05737996250073109,
                0.036379187813581584,
                0.11847574138870574,
                0.018295108792360414,
                0.07571016692674833,
                -0.11605258560163184,
                0.003722753495188532,
                0.00896401413771135,
                -0.005957142585482331,
                0.0141547984992485,
                0.00762603702945846,
                -0.017826100244221942,
                0.003156729531734508,
                0.011417895316057561,
                0.012911479182094752,
                0.03281133205368073,
                0.009355688719341096,
                0.0008347533172090623,
                0.012644003439866524,
                0.0218251964695037,
                0.0167990827620884,
                -0.017184946548058907,
                -0.0043590802015041575,
                0.00035103255690885,
                -0.0028468944143668355,
                0.0020961806593308794,
                -0.00009997166997903053,
                0.00016285950218349434,
                -0.0006660358742285676,
                -0.00009837764943544625,
                0.004923639625146905,
                -0.006374996975312765,
                0.008784808074474017,
                -0.017574492900236775,
                -0.0004947945531595497,
                0.0006273373739958463,
                0.00018395196109376402,
                0.0006116351825113185,
                -0.0005116485706778884,
                0.000709203793977372,
                -0.0004063234876370927,
                0.0002183923013410128,
                -0.002584078846120127,
                0.00023356068252585675,
                0.00018559661890061674,
                -0.00017302863594048564,
                0.0005150104010610536,
                -0.00010267589565834013,
                0.0000545570636741626,
                0.00036247983177744577,
                -0.009718610016899068,
                0.0025829438787801293,
                0.002451130349491343,
                0.0021479615369079247,
                -0.000025582649685298578,
                -0.000035381359554899796,
                1.844369748337707e-7,
                0.00006113714991443627,
                -0.0006803301590230108,
                -0.0006734500121059541,
                0.0016957049504721091,
                -0.001690467077492224,
                -0.0007670324958591621,
                -0.00030280205644659763,
                0.0004131283118127729,
                -0.0023853602116098906,
                -0.0003494160963499565,
                -0.00010795470642018422,
                0.00005966968833479688,
                0.00023122543389445012,
                -0.0003636591926123398,
                -0.000009873372810037937,
                -0.0002779277142053426,
                0.00003396833309438602,
                -0.00014987956056133973,
                0.00020150206364906036,
                -0.00006286086579679944,
                -0.00009393566921238535,
                -0.0001518717417034543,
                0.00013430041101203464,
                0.00016722018266734695,
                0.00005871956991871683,
                0.000021359868745306202,
                -0.000019240578086223427,
                0.0000064150612562539225,
                0.0000413263397774951,
                0.000012780775124082503,
                -0.000006499956337909384,
                -0.000045552407214339506,
                0.000014467437500133978,
                -0.00013308831680722941,
                0.00007345849634394899,
                0.000025365670076437478,
                -1.759432352318757e-7,
                -0.003064439906938135,
                -0.003446136239568641,
                -0.0012033997494065836,
                -0.0017244371474702757,
                0.0000731626205360141,
                -0.000013536715019191828,
                -0.00002536760584289524,
                0.00007458317110837693,
                -8.414256860531949e-7,
                -0.000004633258805734228,
                -0.000005268655571444829,
                0.000009472278725592847,
                -0.00008389091555449871,
                -0.0005816430247238322,
                0.00011071072934663479,
                -0.00008093430500854138,
                -0.000049522878522436884,
                -0.00027243221055681945,
                -0.0003831660904814738,
                -0.0003270465207609086,
                0.000020773264390541076,
                -0.000004961026288242857,
                -0.000009507534973748319,
                -0.000007339464832578358,
                0.000041104069628983783,
                -0.000003557670683904374,
                0.0000029673214063483003,
                0.0000012261731711537142,
                0.000009024153240212519,
                0.000004558915290514496,
                -0.0000015414966469845817,
                3.046570557373382e-7,
                0.02126479476089105,
                0.008394439062389583,
                0.01879593572881607,
                0.009492250923375486,
                0.004400741518937388,
                0.008781293305415843,
                0.004695205285761107,
                0.007145416720923432,
                0.004708365404752515,
                0.006612696430380552,
                -0.0003725410192298031,
                0.00005092737487040537,
                -0.00006345967296821288,
                -0.0005589553406014385,
                0.00020891032423945137,
                -0.0006480922179703758,
                0.0005690104562326107,
                0.002515623321230501,
                0.0004920042292360743,
                -0.00006265399355208315,
                -0.00009359361759125934,
                -0.0004956558628076425,
                0.0005068574792870772,
                -0.000011386245649990662,
                0.00032139787083342925,
                0.002883400746472208,
                0.000023598297850152223,
                -0.00013491732472750064,
                0.0005056205604460134,
                -0.00022416207003428883,
                -0.000040956898673365256,
                0.000026928611247941582,
                -0.00003911212072763748,
                -0.00006043811361088134,
                0.00047687966298277224,
                0.0032526144817642245,
                0.00026204333347966044,
                0.0034086370598056994,
                -0.002403713529931461,
                -0.0009744081371702443,
                -0.0001309000508526119,
                0.0002639732047791076,
                -0.00012542095372745693,
                0.00013850012026113217,
                -0.005218020675462063,
                0.00012798653894660557,
                0.00016904601842736554,
                -0.00030486347824304423,
                0.00016436812878431735,
                -0.000268621871906611,
                0.0005376049804211343,
                -0.00030646931322091917,
                0.000019528252984467786,
                -0.00008664372734768037,
                0.000013043718570027206,
                -0.00008640538619553749,
                -0.000006591563233226764,
                -0.000021650578591373507,
                -0.00001768514270909677,
                -0.0005292902084615879,
                -1.9480893030324898e-8,
                -0.00036508968735216236,
                0.0000070607265162712674,
                0.0000051028158684391595,
                -0.000025011609140988225,
                0.00001558989236627217,
                -0.000011648584052944979,
                0.000014203877092504024,
                -3.521346809167544e-7,
                0.000025158184447872217
            ]
        },
        {
            'energy': -0.8030587929512906,
            'occupancy': 2,
            'alpha': [
                -0.0000039160766778669125,
                -3.681407568104055e-7,
                -4.852087168224363e-8,
                0.0000015402797379006135,
                0.004753963818784808,
                0.0003802615383105054,
                -0.00046874325519538347,
                0.00023112287044511903,
                -0.05011480629049495,
                0.005500897268701077,
                0.00702711485935686,
                0.0073484836427223105,
                -0.000005097695778865254,
                -0.000001548387317318861,
                0.0000025010594174288644,
                0.0000012215881167113476,
                0.12590649213937388,
                0.007923491254088753,
                0.006558551735604694,
                -0.08656621184996877,
                -0.669377318205983,
                -0.012944176795845601,
                -0.060979223361267036,
                0.15765867824896324,
                0.0004133185135123757,
                -0.00002270384034112888,
                0.000006519342373418608,
                9.434373920469218e-7,
                -0.000027315252415555002,
                -1.243380149263884e-7,
                -8.516629614378674e-7,
                -6.973609249758702e-7,
                0.00007820082184925303,
                0.00007087986962500778,
                -0.0000025774967515557685,
                0.000043371153556021626,
                0.00003743812664268137,
                -0.00008238396491818608,
                0.000008663709555687362,
                -0.000007959536685525762,
                0.00006381824561035613,
                -0.0000012836384041419823,
                0.000049500169568561073,
                -0.00006367843535331569,
                0.000007252257632067926,
                0.000005396655281038851,
                -0.000004582993970549783,
                0.000009747944853521623,
                -0.000142012263930239,
                -0.00011827049059664608,
                0.0002517764444955145,
                -0.00005521424479316583,
                0.000009620776807795954,
                0.00002128092914180754,
                0.000006888239326001702,
                3.8475777811814347e-7,
                0.000008804969802929986,
                0.000012270104378560384,
                0.00001117280587676951,
                -0.00001031216093216189,
                0.0007369719208812661,
                -0.0005050844789777617,
                0.0013763909983275785,
                -0.0007689093982549538,
                -0.00029948604327330786,
                -0.0010575641159347494,
                0.001402618948235103,
                -0.0013608481327801326,
                -0.000011072660146418173,
                -0.00001597166969668766,
                0.000009615110217811318,
                0.000004222604389890688,
                0.000002409477344302575,
                4.425171852740457e-7,
                0.0000022099288400954765,
                9.79603132296349e-7,
                0.000001888747798631446,
                0.000001819801017683468,
                -7.523637242906668e-7,
                2.687050521161985e-7,
                -0.0000013705616202380207,
                1.474600790617739e-7,
                1.367323648807162e-7,
                -7.131483302859328e-8,
                -0.017507707978316717,
                -0.010508798641903917,
                0.009385895648718116,
                -0.010956352672126005,
                -0.000008908712490104982,
                0.000002810175238910521,
                0.0000034807083348585673,
                0.0000027028944729405617,
                -0.011191016227704575,
                0.0024050614455829555,
                0.023067286260001364,
                -0.029226487173225554,
                -0.000042921477378596496,
                -0.000025268416595689704,
                -0.000004710662344149848,
                0.00003481899271862212,
                -3.790145116000208e-7,
                -0.00000214428543770637,
                0.0000017741550336581477,
                0.000001162291490235621,
                -1.6369502895768224e-7,
                -2.480314631892072e-8,
                2.6762261949624564e-8,
                1.1189729426060649e-7,
                -1.394188824783003e-7,
                -8.214506709978939e-8,
                -9.616039818631731e-8,
                2.3135808899281674e-7,
                -0.00002069851017116002,
                -0.000008897189712221657,
                -0.00000840552527394162,
                0.00002572242512205846,
                -6.358375967389234e-7,
                -0.000001241533667672374,
                8.537644080773061e-7,
                0.0000017722083879711792,
                2.34947097770111e-8,
                -2.0515717457682523e-9,
                -3.3745757958895624e-10,
                1.1904241694771563e-8,
                1.5659002376812736e-7,
                2.9137420931266588e-8,
                -2.354533838372253e-8,
                -3.8003963067649456e-8,
                -0.000005310380501304833,
                -0.000003437428465792862,
                3.197206527172428e-7,
                0.000006673602503313008,
                -0.000003848878238615534,
                -0.0000041651526493504514,
                -0.0000014280200426708545,
                -0.00000209066416737012,
                -0.27362953681145286,
                0.023435762505821817,
                0.0763423082343581,
                -0.27043584087888206,
                2.4668701542604043e-8,
                1.3747015336656129e-8,
                -5.774013985886259e-9,
                -2.3550241780629756e-8,
                -1.3287789960593623e-7,
                -7.248941945298366e-7,
                1.2285881434106845e-7,
                -1.0911877346445946e-7,
                -7.91882911638755e-8,
                -3.2719068240152347e-7,
                -4.824263782300678e-7,
                -4.175475954854327e-7,
                4.433225734094455e-8,
                -3.2921976405445335e-9,
                -8.615012860416862e-9,
                -5.891012427934478e-9,
                5.140608277020577e-8,
                -4.57370470952752e-9,
                5.5150147094868375e-9,
                2.2702277890129822e-9,
                1.5395383959789046e-8,
                6.581993091653662e-9,
                1.493600154034817e-9,
                2.9194047387133537e-9,
                -0.0000347951352433874,
                0.000054654419942136406,
                0.000023499607201423388,
                0.00005411759982646705,
                0.000008360944625736362,
                0.00002678103739353528,
                -0.00010852643103774796,
                0.00009869381645809216,
                -0.0002875600000283905,
                -0.0005660423812985556,
                -0.00008758200153603671,
                -0.00018582026858514401,
                -0.00033813607022629863,
                0.00020588514814033344,
                -0.00007451464462928903,
                0.00007953254595395442,
                4.170016182805253e-7,
                0.000017779291582693375,
                0.000003123656326950173,
                -5.544812069372295e-7,
                0.000001576243423620611,
                -0.0000013053608020394573,
                0.0000015743978987074035,
                -0.0000012007575027624995,
                0.0000021061034116161252,
                1.4643947682265284e-7,
                3.873573671843366e-7,
                -9.420841687491079e-7,
                -0.0061615120617489446,
                -0.004236000178205006,
                -0.00030992411209383963,
                -0.004917217938686815,
                0.0047351102803351985,
                -0.005455893502846994,
                -0.00005958739022232091,
                0.000014375802882774808,
                0.0000012077702676248434,
                0.0000032416622457580894,
                0.0008932889221456225,
                0.00017010796911197778,
                -1.0975814406913235e-8,
                1.870649582010179e-7,
                -2.3893174563029253e-7,
                0.0000019356652516127527,
                -0.000005953823034738492,
                1.443769929942304e-7,
                -0.000006470408108578149,
                -0.000013117904560640258,
                2.7372589177307363e-8,
                0.000001327093690147875,
                -0.00834684057637123,
                -0.002660205398909788,
                1.3705263506490452e-8,
                -5.522380566874082e-8,
                1.1576032333131993e-7,
                -1.4231732121949148e-7,
                -3.973607652024659e-9,
                -2.645612015254178e-8,
                -6.280110390402554e-8,
                -4.807019647698139e-7,
                1.9870771145269644e-8,
                -5.495351059383834e-7,
                0.014842274941513243,
                -0.0036104198881071127,
                -1.9293447202805082e-8,
                1.682651010456615e-8,
                -1.7610650172857904e-8,
                1.6672223332904112e-8,
                -1.1403678620353197e-10,
                2.99982690719224e-8
            ]
        },
        {
            'energy': -0.7981532019596451,
            'occupancy': 2,
            'alpha': [
                -0.00000536355599411845,
                0.0000011748034542746555,
                6.687107942441472e-8,
                8.173383426189592e-7,
                -0.008527093598940208,
                -0.0006823366650221968,
                0.0007125719493203611,
                -0.00044842863065739204,
                0.0006610915285423952,
                -0.0000849124086409572,
                0.000007330324316693964,
                -0.000053792535676581905,
                0.023500451234832503,
                0.004240670975093069,
                -0.0399575810012268,
                -0.02553759416285432,
                0.00003502284913667984,
                0.000001337128505822921,
                -6.789240587099113e-7,
                -0.000014512551211513656,
                -0.00010989077626524301,
                -0.0000028863745356616103,
                -0.0000031655067484802596,
                0.000025658462453298,
                0.028205002861340818,
                0.0006960785927321442,
                -0.00022080012142153984,
                -0.000026620044448029173,
                0.712051324700807,
                0.001981483914063873,
                0.00815480118391221,
                0.0054683662463381084,
                0.0045836132652914575,
                0.0025608762055554625,
                -0.002395468767585818,
                0.0014261269614980574,
                0.005151872357100143,
                -0.004928652456896003,
                -0.002490851274447711,
                0.0016024106849230843,
                0.004580820201023751,
                0.0011053168116574494,
                0.0030331696375831964,
                -0.004915197218458114,
                0.001240585990797772,
                -0.00041119974106285177,
                -0.0011498735933606057,
                0.0004262600135169448,
                0.00029926912213392104,
                -0.0010146710605444464,
                -0.00013165266859171135,
                0.0006469822088673755,
                0.008032184098572249,
                -0.016734100837861844,
                -0.012803894410844936,
                -0.013459682701795001,
                -0.0005442429151602419,
                -0.0005606192070029398,
                -0.000441391399309502,
                -0.0022579056437332166,
                -0.001936041650865056,
                0.0004459162940939399,
                -0.0017169187112302197,
                0.0010762081545989506,
                -0.00015769729964141817,
                0.00020052326870592587,
                -0.0003442030124571818,
                -0.00004271257796516448,
                0.00022301518320822766,
                -0.00023369787537155798,
                0.0003644089422150472,
                -0.0007733010392108875,
                0.0004993286885808839,
                -0.0003841484714367734,
                -0.00032166389436087933,
                0.0012654672465029135,
                0.000300032079083722,
                0.00026247874478209387,
                -0.00038214558442476484,
                -0.00021123214306565971,
                -0.00008454441345385634,
                -0.0002924442685909987,
                -0.00019736916894446,
                -0.0005718797028202831,
                0.0001836115321980386,
                0.00008172424881448333,
                0.000025404186884643644,
                0.00013565709829900616,
                0.14908568857496488,
                -0.03924938858416251,
                -0.11417020599245593,
                -0.08702201390065112,
                0.00001141806205890965,
                -0.0000037921277833115287,
                0.00001529530655415088,
                0.00002421627860555065,
                -0.000008038663060339903,
                -0.00005159494617902113,
                0.000054193623683269486,
                -0.00009359585623129205,
                -0.00004525986475280533,
                -0.000014039548242026493,
                0.000031857462225072694,
                -0.00009860731843427598,
                -0.000051195433153146536,
                -0.000025663264320015214,
                -0.00003752862539751339,
                -0.000010380686085931515,
                0.000022255001252674057,
                -0.00028067032056839,
                0.00025177373778414926,
                -0.00009720516652240771,
                -0.00001754474024118256,
                0.000009155164001881858,
                -0.000006791692502755702,
                -0.0000033679791953712704,
                -0.000019917555958193818,
                0.000009856902924774074,
                0.000007192242699538481,
                0.00000720105970850863,
                0.000007756409586958334,
                0.0000026154810662466673,
                -0.00001486475827153546,
                -0.000012461446715794711,
                0.00017275616371140306,
                0.000018990041902949266,
                0.000017004937289014223,
                -0.00008168103685230768,
                -0.000013512415427504908,
                0.000006493722854415131,
                -1.0063783683077847e-9,
                0.00000327185372452911,
                0.10825595209732827,
                0.11452393744987781,
                0.037299987681613106,
                0.05550315449671261,
                -0.000039669520720269315,
                0.0000034265453508789548,
                0.000017315615148342694,
                -0.000043567477013758244,
                0.00003931013357304876,
                0.00001877501708393969,
                -0.000008551336354807845,
                -0.000042416640072695924,
                0.0038603545078145975,
                0.01971164920928086,
                -0.003379499372074395,
                0.003015863194206619,
                0.003922932748200289,
                0.01092689576814966,
                0.013593532883643707,
                0.011907137176873262,
                -0.0017202267746424843,
                -0.00004175839767009397,
                0.00017384093581412094,
                0.00009700641090611545,
                -0.0020131869458223325,
                0.00008982045364588479,
                -0.00014040283828615265,
                -0.00007657080777875282,
                -0.000674328277180315,
                -0.00033021770943098775,
                -0.00007646692702989181,
                -0.00014230773102194807,
                0.0009985985996089346,
                0.00018384301465202357,
                0.0008597230901079472,
                0.00010305228761360882,
                0.0006423367856569582,
                0.0003455674555035139,
                0.0003637013063697566,
                0.00009471570109819295,
                0.0002545564530800749,
                0.00015665012852858267,
                -0.00029087011647448206,
                0.00000951117534107897,
                -0.00004331058237353689,
                -0.00008548571052714709,
                -0.00005156911820836647,
                -0.00008860785005198076,
                0.0007916808999189274,
                0.004153166079445205,
                0.0008416332260388879,
                0.0007227527284999528,
                0.003985179446740828,
                0.009391172566626207,
                0.0004375543943557168,
                -0.00015503914606884505,
                0.00012048590408897148,
                -0.00005900386713595056,
                0.00018507597724388175,
                0.0024999161546182943,
                0.000035910038335826335,
                -0.000007179382593775874,
                0.0000010698447301210996,
                0.000008480112108715242,
                -0.000004239274137018821,
                0.0000042862133114148075,
                0.00007684700009090861,
                0.00005952869611293892,
                0.000004900507401734495,
                0.00005655300137784683,
                -0.0016844243118062305,
                -0.0001633324563402221,
                -0.00009614606338008088,
                -0.00008494405286496815,
                -0.000038630122212115795,
                0.002749295589791537,
                0.17013271192133514,
                0.01064171065733854,
                0.000002966890631096344,
                -0.000015392568346015722,
                0.0000012383502977001717,
                -0.000008351293873277389,
                0.00014216452607813412,
                0.0000028408943303095577,
                -0.0000037786607705223535,
                -0.00001709682558030563,
                0.00013816584053550894,
                -0.000014293000263511078,
                0.0000051041226070591935,
                -0.00002345401360915591,
                0.0018508576571677686,
                0.008894520448244195,
                0.002105331523844466,
                0.00938533792853296,
                0.000006003922513654685,
                -2.4176844109388744e-7,
                0.00024515673574923666,
                -0.00038250799057186854,
                0.00014589297584689944,
                -0.000391546525906061,
                -0.00002431835344613245,
                -0.0007447724695962552
            ]
        },
        {
            'energy': -0.7970747657877892,
            'occupancy': 2,
            'alpha': [
                0.0000014572518915237936,
                -0.0000048504958007949425,
                -0.0000017294842031730208,
                -0.0000042363468691344445,
                -0.769673413052281,
                -0.06233601863871637,
                0.061070715717694894,
                -0.03704025240456188,
                0.07132012294170004,
                -0.008896648090639819,
                0.0008413347375794688,
                -0.005868316865492253,
                -0.000006227692389272022,
                0.000031476506797977474,
                0.0003647527480360212,
                0.00025306140255001986,
                0.003233685154168676,
                0.0001208129850682606,
                -0.000062649955226549,
                -0.0012607497864192364,
                -0.009472108272272942,
                -0.00024212819856439345,
                -0.00012718621463987407,
                0.0021968066593335547,
                -0.017185123435715592,
                0.0006790742164238247,
                0.00009936066692734306,
                0.0001417636356880098,
                -0.007442850703864697,
                -0.000016606363283035463,
                -0.00005359396555458919,
                -0.00003414224536380583,
                -0.003615486838823366,
                -0.0032880001581250284,
                0.00021721354811992345,
                -0.0018365046748617451,
                -0.006386639262339793,
                -0.0022304264830814375,
                -0.00023642084299503474,
                0.004808073010592396,
                -0.0033702539909404895,
                -0.0004910996550928789,
                -0.0020145126942962676,
                0.0030962682135355457,
                -0.0003530164626617033,
                -0.00031385836370619556,
                0.00025946669030182517,
                -0.0004926555841548672,
                -0.013324822517941365,
                -0.012877036370516995,
                -0.024311913820218075,
                0.015083764983691881,
                -0.0005608474116438892,
                -0.0008008879829074848,
                -0.00014163717362766185,
                0.0001495499957955105,
                -0.0004310961697672163,
                -0.0006254744860440947,
                -0.0004915658393322342,
                0.0005411319042355474,
                -0.16611521054180275,
                0.042246864726822306,
                -0.15597152763132047,
                0.09730843784089392,
                -0.013346971815857075,
                0.01855818684389306,
                -0.03093761127389651,
                -0.002516701626645792,
                -0.0002830115035739662,
                0.0001292571432915951,
                -0.00029934323479071805,
                0.000565124558937572,
                -0.00015107225253828532,
                -0.00011044985212114441,
                -0.000020997600065444625,
                -0.00008347825841150404,
                -0.00011085758871333943,
                -0.00010287432734033015,
                0.00003505780763928701,
                -0.000017276437786481964,
                0.00008983974585464452,
                -0.0000022468776829460254,
                -0.000004395858722829443,
                0.000011222830269304043,
                0.01923202504712108,
                0.009525452483049326,
                0.00297769398857434,
                0.014315967755385559,
                -0.0013795846811612634,
                0.0003439115110480606,
                0.001247251355128957,
                0.0009420481742103606,
                0.0015686542505730817,
                -0.000359247700581137,
                0.0016846646695932862,
                0.0026608480836430113,
                -0.00011400536022102842,
                0.000025039921531473145,
                -0.00006692761343693896,
                0.00016640591108137295,
                -0.0000617912370082292,
                0.000001771738025208567,
                -0.0000528897128520799,
                0.00013941463022916855,
                0.000015539430007708143,
                0.0000056372186447553665,
                -0.0000023809875017091788,
                -0.00000894230266044365,
                0.00001815287628548104,
                0.0000069000800058375805,
                0.000008644587961555415,
                -3.9356086514325725e-7,
                0.000009280776882273579,
                -0.000008462735237200406,
                -0.000004028494218501283,
                0.000024786754439220694,
                0.000002028832642253735,
                -0.000004056715352829639,
                -0.000017947589327742906,
                0.000018134015974994903,
                -2.244129194359043e-8,
                0.0000010464663258863594,
                3.119982345371334e-7,
                -0.000001700629904649727,
                -0.0000012121146230057408,
                8.900781016832651e-7,
                0.0000017577474419869602,
                -3.1726826772428093e-7,
                0.000019251531009050058,
                -0.0000037848945056955316,
                -0.00001117947321339591,
                0.0000021353278616636345,
                -0.0011453558673648544,
                -0.0012072030137289568,
                -0.00038938638072571173,
                -0.0005834295037079139,
                -0.003233907954620412,
                0.0002909124156765682,
                0.001666363510358846,
                -0.003738827961633115,
                -3.7827583893815004e-7,
                1.689698700816318e-7,
                5.003166691441425e-7,
                -1.1664016861260786e-7,
                -0.00004056135813706443,
                -0.00020689658095963024,
                0.00003598298514286376,
                -0.000031742062827878746,
                -0.000042123198597237305,
                -0.00011608631190865693,
                -0.00014383903208844447,
                -0.00012643785028720606,
                0.000018972638171551866,
                7.472423847476682e-7,
                -0.0000016990323317304876,
                -9.00326611950359e-7,
                0.00002191780382855892,
                -7.263490209810807e-7,
                0.000001598931865396552,
                9.031059237368099e-7,
                0.00000742650284939285,
                0.000003682352951494622,
                9.227822614738954e-7,
                0.000001616885527619476,
                -0.001205914634739813,
                -0.002724314052257341,
                -0.004365165407178481,
                -0.002931658575156315,
                -0.0004628584605446697,
                -0.0017800479995088467,
                -0.004034225408612186,
                -0.0033791552922877773,
                0.002062479356561011,
                -0.0036064391043091554,
                -0.024034753240086474,
                -0.0012246529136016968,
                -0.0036653278516413155,
                -0.0063178540705423605,
                -0.0056186963574268904,
                -0.003936616765161903,
                -0.00020114369070202577,
                -0.00010168514869215218,
                -0.00011480484269485027,
                0.000001935489419041624,
                -0.00007703750892967924,
                -0.00003691917018681491,
                -0.00009414439783141375,
                0.000032741531000391285,
                -0.00011929406212255044,
                -0.000006784891180750882,
                -0.000026438684266064095,
                0.00001941890773610095,
                0.0028114658981669913,
                0.00035494252168372434,
                0.0003573426293954419,
                0.0007498892644495996,
                -0.0001788254844841121,
                0.0006985518085974686,
                -0.00016680669853602785,
                0.00042280984059101635,
                -0.0000777078305247968,
                0.00005111306856476016,
                -0.154186920512237,
                -0.012936833051525006,
                0.0000071994943610158484,
                -0.0000028380334865028046,
                0.000011799801425554651,
                -0.00002957637214131619,
                -0.0017973098302187947,
                -0.00009552896584216052,
                -1.8915101807793233e-7,
                0.00012842668350158276,
                -0.0000017656274291704825,
                0.00002749141957767741,
                0.014683367495984204,
                0.0008074160349136866,
                -2.5708424757336663e-7,
                0.0000021025099942715133,
                -0.000001360181399085668,
                7.87360178703095e-7,
                4.192483014206344e-9,
                8.2254950343514e-7,
                -0.00001903235998876513,
                -0.00008794913078121711,
                -0.000022241396623885728,
                -0.00009814289936100782,
                0.0005727348277072966,
                -0.00003158691832869834,
                -0.000002165273121162701,
                0.0000038732063741977314,
                -0.0000013473132890165324,
                0.000003846362163771805,
                2.7272034516352744e-7,
                0.000007763072102220907
            ]
        },
        {
            'energy': -0.7920729534454816,
            'occupancy': 2,
            'alpha': [
                0.00005935001412011232,
                -0.000002378795529424539,
                -0.000002070140878983373,
                -0.0000176132713761018,
                0.07713383254199065,
                0.007090539839827086,
                -0.00505860503642391,
                0.0036828812835748995,
                0.7615473605289887,
                -0.08290106643541897,
                0.003399539214127441,
                -0.05045020727416939,
                -0.000014515745885889945,
                -0.000005505831668282811,
                -0.000003265580611114756,
                -0.00000308718113197539,
                0.023916894149650134,
                0.0009034021083406205,
                -0.0014033944471345283,
                -0.007577256756815488,
                -0.052359633591182224,
                -0.0014367183587385543,
                0.0028570389890791026,
                0.012353037549040232,
                0.0006381289304109399,
                0.00008222671041361565,
                -0.00006591665076933348,
                -0.000016223507950903473,
                0.00012154029515447592,
                -2.0878111003401766e-7,
                -0.0000015496535170450977,
                -4.448134033530778e-8,
                0.00017489900435381186,
                0.00019066222166499666,
                -0.000033043737557642994,
                0.00006131621677587556,
                0.0010506703071384211,
                0.000856634353469548,
                -0.00006726818603565207,
                -0.0006388879685744009,
                0.00030452544439215094,
                0.00016349206385987472,
                0.00004975798986932776,
                -0.0001896971463756749,
                0.00003282856208767869,
                0.0000680952532187142,
                -0.000019983275634233508,
                0.0000208208944404121,
                0.002830398850086038,
                0.003712918910116867,
                0.0022834575688607975,
                -0.001685843833473537,
                0.000022127520706270348,
                0.00005178514925621128,
                0.000003640351931896396,
                -0.000002163501987737521,
                0.000033793677891543375,
                0.000057298249156248814,
                0.00001717593263000886,
                -0.000032893749689297585,
                0.02263805674008057,
                0.0014479007501755823,
                0.009005704771617126,
                -0.008099790683850595,
                0.018514767663404243,
                0.014608873869641431,
                -0.014351715566809364,
                0.026254097168266013,
                0.0002396401389199493,
                0.00011228360951627415,
                -0.000006970744562673196,
                -0.00017995661367296566,
                0.00001606349427923106,
                0.000035270023000679106,
                -0.000017161617969642323,
                0.000006317117589875978,
                -0.000011873197988696013,
                0.000002133394965867108,
                0.0000015872613346588823,
                0.0000028124275583589956,
                -0.0000053603254184782855,
                0.0000050489806972875,
                -4.603274469458007e-7,
                -0.000002249207926213435,
                0.17292876679615873,
                0.10218292802380338,
                0.031444756351506585,
                0.1579349786403308,
                0.000010410766399046751,
                -0.000004035960412327531,
                -0.000024893236232310535,
                -0.000016353814599684674,
                0.014309030847483905,
                -0.0011018042982015354,
                0.015308212784460085,
                0.028034520790299368,
                0.0003190076659068527,
                0.0001678402964458002,
                0.00012739789152885144,
                -0.00020853544372368197,
                0.00005118312073206923,
                0.000024061544915857837,
                -0.000012090881742564983,
                -0.00006540036395446569,
                -0.00000228250424646043,
                -5.127095322427893e-7,
                4.7278887934603265e-7,
                9.589858449166675e-7,
                0.0000022880252065105158,
                0.000005732787721326974,
                -0.0000015122435115528477,
                -0.0000045997637554446765,
                0.00013212961256861325,
                0.00003176574229988617,
                0.00010773494081781052,
                -0.00018576716536817094,
                0.000018666882514092268,
                0.000012063151426631318,
                -0.000011953095179640786,
                -0.00003167668751777477,
                -4.858977112294998e-7,
                -2.3659150436814824e-7,
                1.51484160869324e-8,
                4.44944197355326e-7,
                -0.000002181513913799473,
                2.0639298813645221e-7,
                -2.819535300877499e-7,
                3.96604748225843e-7,
                0.00007240825360250639,
                0.00002890314347022917,
                -0.000007270840149585645,
                -0.00006033001471902576,
                0.00001878029394971212,
                0.000019817032101887528,
                0.000006205931789954511,
                0.000009989966549593833,
                -0.015848505234857153,
                0.001703981489705482,
                0.011974907272232412,
                -0.01981472998538248,
                -6.936136755435559e-7,
                -2.532475131139314e-7,
                1.3858767231158883e-8,
                5.801700560596107e-7,
                5.271449753996005e-7,
                0.00000323195695773997,
                -6.443538002359157e-7,
                5.40820869851737e-7,
                1.1029223316667395e-7,
                0.0000013869884354373484,
                0.000002322987635508277,
                0.0000021124371869551773,
                -3.3749464357821465e-7,
                -4.8188412383109104e-8,
                1.833751435118305e-8,
                9.172390672282008e-9,
                -3.2404166366060876e-7,
                -5.039408110618543e-8,
                -6.710054579510577e-8,
                -4.044241500601687e-8,
                -1.0598882397480516e-7,
                -5.992405193764939e-8,
                -3.2763315983999245e-8,
                -3.370385952385555e-8,
                0.0006367351327799688,
                0.000619603226798309,
                0.0007244727370467272,
                -0.00006447247637873673,
                0.00009177180691720571,
                -0.00006771057417299223,
                0.0009262517855263668,
                0.0011221823694281337,
                0.001030574560635253,
                0.006404554772283187,
                0.006233134266607178,
                0.006216231577407208,
                0.005539357092587577,
                0.00489084967128217,
                -0.0011590660210740952,
                0.0052036463218906375,
                0.00006422783176977436,
                -0.0001355339879834113,
                -0.000003290898794791767,
                -0.000034094809460696716,
                -0.000011879802941442265,
                -0.0000098762425042078,
                -0.000007638222879249115,
                0.000003622538848371618,
                -0.000004850763472457068,
                4.5195382961740834e-7,
                -0.000004822038382277673,
                0.0000028433491414054567,
                0.025343491728177747,
                0.0018000920027474601,
                0.005624982708691651,
                0.0022344970797418943,
                -0.0015950023666455252,
                0.0036524310826911307,
                0.00030528101621009817,
                0.0003727244602149629,
                0.00002146110411773986,
                -0.00005118959158944545,
                0.016889347998524602,
                0.0017884984660224605,
                -0.0000014474664384083429,
                -0.000001779854694934181,
                0.000010924781981088577,
                -0.00003123854478851128,
                0.000028987600015782297,
                -0.000009411611788848763,
                0.000026444836388808902,
                0.0004079947521105034,
                9.569774105023305e-7,
                -0.000016680105095452607,
                0.1550550429614166,
                0.013110989047944862,
                -1.2013470429049204e-7,
                1.7468925172295844e-8,
                -0.0000014267313679212157,
                -7.147083717805006e-7,
                -1.188067777697244e-7,
                1.3909927702048578e-7,
                2.1051316413777688e-7,
                0.000001579686077374765,
                -6.613202138451365e-7,
                0.0000034370646631687056,
                0.004747116762085155,
                -0.00003392023498519304,
                3.637890331230164e-8,
                -4.9834921712229984e-8,
                9.376641235226368e-8,
                -5.450152133026838e-9,
                3.1497183137987454e-9,
                -1.3353952622111868e-7
            ]
        },
        {
            'energy': -0.7602245949772868,
            'occupancy': 2,
            'alpha': [
                -5.15258950787012e-7,
                0.000002083890303287117,
                7.966429455068085e-10,
                0.00000104179755186933,
                0.00020788717411770368,
                2.806158586794692e-7,
                0.000030288117505116194,
                -0.000007150283306506261,
                0.000019501234480894477,
                0.000001279373122735703,
                -0.0000034090300596863565,
                0.0000019004941730096308,
                0.6876664670640915,
                0.11997035639822125,
                -0.10995153868559952,
                -0.040877482505582985,
                1.587041935876921e-7,
                5.8916504545786915e-8,
                4.799548446508889e-7,
                -2.1272679269944834e-7,
                -0.0000014066378150752742,
                8.35175339877651e-8,
                4.2738581919733696e-7,
                1.3371318574349583e-7,
                0.01286191402457582,
                0.0025912308665836845,
                0.0012848900591941785,
                0.0005572435029218679,
                -0.07278615397361901,
                -0.02280828299870649,
                0.04533877656852469,
                0.023919497254049484,
                0.0009073806993794686,
                -0.002466074175389049,
                0.0021514603631160316,
                0.0017804671994984325,
                0.00428289622712753,
                -0.002980379248975046,
                -0.0014779389170556895,
                0.0011506593878516528,
                0.0011941880555193824,
                0.0018108705582356838,
                0.002344549647655703,
                -0.0020852572095491537,
                0.0007745664741784754,
                -0.001090435860587162,
                0.00007082979661137052,
                0.0009641065280205475,
                0.0004992882152984973,
                -0.0006543392381033082,
                0.00016751396954729384,
                0.0004584296541834331,
                0.016318597981809443,
                -0.041988427060684716,
                0.016476801691779838,
                -0.000211120378374887,
                -0.0029199422433890997,
                -0.003037276099792479,
                0.0019884846519673187,
                0.00015297403644430306,
                -0.0000716781426261294,
                -0.000041845810407519605,
                0.00005889556845417412,
                -0.000004868963339992858,
                -0.00003407338538127731,
                0.000012658998555374789,
                -0.0000013082236151862581,
                -0.00001255298738610168,
                0.00019985598135803152,
                0.000025847418027607804,
                0.00035644075750621826,
                -0.0004582691140819978,
                -0.00009187567265219318,
                0.00004357063993364339,
                0.00040252123518342756,
                0.0000753735200954743,
                0.0008462623723311113,
                -0.0005590231520591286,
                -0.0012545997682633675,
                0.0007934800874864353,
                -0.0004357571963798447,
                -0.0007623460969483168,
                0.0004129493707220033,
                8.67276688171421e-7,
                -0.00000446195808571676,
                0.000007607983991849984,
                -0.00000580472012731614,
                0.000005442964478307737,
                0.2727614295045655,
                -0.18060799128232088,
                0.1919447927910907,
                0.07821626308977608,
                0.0000013384538195892832,
                7.045560471215348e-7,
                -5.209493073163978e-7,
                8.490251052486581e-7,
                -0.00003124069516078283,
                0.000012298988265596253,
                0.000056312631028041004,
                -0.00006959488894230748,
                0.00002518547039413746,
                -0.00001519355698890449,
                0.00003925258937747051,
                -0.00009822968135891978,
                0.00007688752342658278,
                -0.00014578047510951806,
                6.093330219345389e-7,
                -0.00022101488707186804,
                -0.00022091447763288992,
                -0.000036768553820125486,
                -0.00016038864339703714,
                0.00006270746907833826,
                -0.000029355221167642024,
                0.0000155311064498566,
                -9.871278766743224e-7,
                2.1440336708574898e-7,
                -0.000022237920238283972,
                0.000005484292062664846,
                0.000008868787791883467,
                8.174288506080832e-7,
                0.00005988169586510748,
                -0.000009122267236106845,
                0.000027178602930860257,
                -0.000017126469445710344,
                -0.000042463194485061326,
                -0.000019369805959890973,
                -0.000014232335352826453,
                0.00003137135831355165,
                -0.00001737474009216911,
                0.000009441845750939446,
                9.670606919885695e-7,
                0.000004935993349185895,
                -0.014832210115598158,
                -0.0160261021882768,
                0.004776237540523279,
                -0.0011840234325054659,
                4.875955800409152e-7,
                9.449031724755005e-9,
                9.84863709837958e-7,
                -4.071741662657659e-7,
                0.000005359316512869605,
                -0.000007972524507862404,
                0.000018749082461693628,
                0.000009558955050523613,
                0.0028989292799000855,
                0.002859568041460783,
                0.00358996109380241,
                0.0031401483079490497,
                -0.0035266289579901715,
                -0.0026917585512446322,
                -0.003035829851440945,
                -0.002748216746546487,
                -0.0000026153305990104116,
                0.0001691757712300575,
                0.00017505566156205706,
                0.0001599845512044319,
                0.00030474068046137986,
                -0.00020703004668582106,
                -0.0001452342656193102,
                -0.0001532619678093583,
                0.0000705854284977622,
                0.0000065622928991905735,
                -0.000015425064098231987,
                -0.000008921096931640747,
                0.001079219853802424,
                -0.000022819929105619517,
                0.000904069760401762,
                -0.00006273221069454935,
                0.0002243433575780615,
                0.00017999037929388874,
                0.00015115159249208036,
                -0.00004887454864318362,
                0.00020968536208432382,
                0.00004981068563168281,
                -0.000029281500742061825,
                0.00004320323643909521,
                -0.0000026285381234474996,
                -0.000004651705211142358,
                -0.00001141301337120217,
                0.000002877341497951295,
                -0.00022951775575098552,
                -0.0007936882132328896,
                0.00011987039958756206,
                -0.0001463264198293457,
                -0.0005049077577401569,
                0.0010464374566311056,
                0.00029362827802071684,
                0.0005799638485451038,
                0.0004622708743137346,
                0.0016824466002142698,
                0.0034206698438123007,
                0.004115180244038409,
                -0.0000052216661015720065,
                0.000009202508909214573,
                7.101780642946003e-7,
                -0.0000014107050527151093,
                9.760591685871388e-8,
                -9.353539721222229e-7,
                -0.00001524342037854249,
                -0.00006736997349167562,
                0.000048106436706687234,
                -2.5203940147242286e-7,
                0.00005467293458663008,
                0.000007148409092770601,
                0.00007079641532828373,
                0.001040767017506386,
                -0.0002282860404859504,
                -0.00073771407433244,
                -0.03799364064315809,
                0.0026994652203325103,
                -0.000006682302595344993,
                2.590377528182949e-7,
                -0.000002954970737446624,
                -0.0000018662945306014968,
                0.000004244463844224875,
                0.000007944550756919504,
                0.000050116536701992574,
                0.00000209858970923817,
                -0.0000334171001751936,
                -0.000023996244729230054,
                5.211178666758404e-7,
                -0.000003935791079095865,
                0.007042684765401556,
                0.0027425291690864255,
                -0.0015224758430195686,
                -0.0016063187878065921,
                -1.5124993296192045e-7,
                -6.426475338680984e-8,
                0.00004752529236877003,
                0.00038201043276002493,
                0.000047068055856769694,
                -0.00017502398617121908,
                0.000023402540829911394,
                -0.00001569780550194017
            ]
        },
        {
            'energy': -0.7209860277827596,
            'occupancy': 2,
            'alpha': [
                1.827731279933333e-7,
                -0.00000566501186186495,
                6.123027616416714e-7,
                -0.000010688923866509303,
                -0.003909305716814096,
                -0.00005763544362559397,
                -0.001804435699669151,
                0.0015148651783146885,
                0.040428192941652584,
                -0.0012449771775344834,
                0.028538856948623813,
                0.05503866007510007,
                -0.0000055942208440703075,
                -0.000001966137455038931,
                4.899968700298048e-7,
                -9.415037948644084e-8,
                0.14342912358796425,
                0.02800829244086196,
                -0.4493893658092095,
                -0.13060711552307913,
                0.17289911753603865,
                -0.002026043645476675,
                -0.0760474084257167,
                0.07808506528231117,
                -0.00004123737805097001,
                0.0001271112748173603,
                0.000055396782217056816,
                -0.000019698955976178935,
                -9.472802071919794e-7,
                -6.314993431810366e-7,
                -2.2293192162708036e-7,
                -2.687615754824294e-7,
                -0.00006029564459490854,
                -0.00001346515832798241,
                0.000024081076157858904,
                -0.000030877386901199686,
                0.0005330631353816727,
                0.0002508622586238507,
                -0.00003600413306343761,
                -0.00007338513587816549,
                -0.00004539919026508958,
                0.000030453504990553898,
                8.927678198526367e-7,
                0.00003209934109831599,
                0.0000036851966225370156,
                -0.000005325862579022978,
                0.000008313928704480262,
                -4.826299947282103e-7,
                0.00044469601109160334,
                0.00017847932755290269,
                0.0009209966270183208,
                0.0006076650729491639,
                -0.00003791958415215217,
                -0.000025230648691394143,
                -0.000004538802203956249,
                -0.0000023073312485251665,
                -0.00003532048227236642,
                -0.000013720234982233044,
                -0.000012650566697669945,
                0.00001702432515597268,
                0.002490519223451355,
                0.00011117321036215528,
                0.0008910232669135524,
                0.0020191209832093617,
                -0.01717682975326841,
                -0.006853043376609228,
                0.018096929615250373,
                0.003229144668740502,
                0.00002771871471911786,
                0.00001620640188127752,
                0.000015919652777719148,
                0.000009250806693115398,
                -0.0000029763756843643507,
                -0.000008062478579951996,
                0.00000651556183283347,
                1.9517869435602751e-7,
                0.000009569789356175499,
                0.0000035981650150376235,
                -8.408111998592753e-7,
                1.8421223324162407e-7,
                4.339400116299025e-7,
                -0.0000016516424426868336,
                -0.000002504277947024648,
                0.0000029657842887221687,
                -0.0966196449650059,
                -0.026740184186268275,
                0.0447337482866368,
                0.04169667506510025,
                -0.000004985347251654251,
                -0.000003355908899775708,
                -0.00000236617729071118,
                -0.0000018024292113866708,
                -0.2796719458508634,
                0.008393504550923189,
                0.10042926806627658,
                -0.01003685464019805,
                -0.000008939033449544258,
                0.000020904394097432363,
                0.00002993854931747522,
                0.000037448755036426086,
                0.00003176315342372181,
                0.000007937688281264557,
                -0.000005753515761446979,
                -0.000012058893492948203,
                9.985800527283765e-7,
                -4.142252415046357e-9,
                -4.1454260435427653e-7,
                5.7239132620261207e-8,
                0.0000019112897282119474,
                3.87490038028812e-7,
                -4.618524594456192e-8,
                1.2630329082451207e-7,
                0.00003351622979082224,
                0.000011677401340155511,
                0.000028144062882760966,
                -0.000008506111177047169,
                0.000021158791821108576,
                0.0000012483910455292025,
                -0.000007669220600132481,
                -0.00001350492698397961,
                3.4532882745192174e-7,
                1.5624024379131267e-7,
                1.0841249011002989e-8,
                -2.797550708856719e-7,
                5.023664838218099e-7,
                2.2975288841178104e-7,
                3.085493161565288e-7,
                -2.3828916009962963e-7,
                0.00003871566230472808,
                -2.846680197659804e-7,
                -0.000001071563458781833,
                -0.00001994602196007334,
                5.024387565571638e-9,
                -9.73187800952848e-8,
                -1.0569522343612676e-8,
                -7.863036651683276e-8,
                -0.334346440918527,
                -0.007267646400728914,
                -0.135062387143528,
                0.17667058953416517,
                1.4770968991066455e-7,
                9.836186834464386e-8,
                1.2419886911414152e-7,
                -1.5028844231073255e-7,
                1.5267055821265905e-8,
                -3.224475683262189e-8,
                -3.1567861172637114e-8,
                -2.9285683073889897e-8,
                7.835507084225477e-9,
                1.2582215258409713e-8,
                -6.52568261679935e-9,
                -2.6476003104222497e-8,
                2.3101982031258886e-8,
                6.989093402822506e-9,
                1.1467581595663666e-9,
                2.641805515115235e-9,
                -1.5100818552650427e-8,
                -4.866558159046759e-9,
                6.067217278379588e-9,
                -1.3984650659546688e-10,
                2.914089889119267e-9,
                -1.7887649307702178e-9,
                7.482905651194145e-9,
                4.006898059198257e-9,
                0.00023969563613359974,
                0.0002425526520620621,
                0.00014187895495572353,
                0.00017847323814016786,
                5.631332100326816e-7,
                0.00005301084035083949,
                -0.00048186774817548443,
                -0.00014972819202010225,
                -0.00028079014274682136,
                -0.00034983076192234794,
                0.0020558036363834413,
                0.00006883079106596186,
                -0.005719373512104476,
                -0.0036665785468482843,
                -0.008438757742059792,
                -0.004424111096503377,
                -0.000017720774811689583,
                0.00003501340789521611,
                8.992665267687078e-7,
                0.00000976959795181674,
                0.0000032795562524700288,
                -0.0000010487093507871285,
                0.000004657187383575626,
                -0.0000033564688288971557,
                0.00000619700675847412,
                -0.000006133955135229697,
                0.000002219719741933604,
                -0.0000033941037477567214,
                -0.03202619757254832,
                -0.0071138899903338436,
                -0.07625172025931348,
                -0.006040756070122129,
                -0.09779735898657291,
                -0.004256049870442589,
                -0.00006552542445819912,
                0.00011936747163937818,
                0.000010400724358889551,
                -0.000002177096936087705,
                -0.0018121568531547939,
                0.000023392363395725938,
                1.1257564162531961e-7,
                -0.0000011180671780861605,
                0.0000013187105071407077,
                -0.0000022235576772837923,
                -4.958015044411375e-7,
                -0.0000011509034984590618,
                0.000017691911303956698,
                0.00011255229106684194,
                0.000002376014434579858,
                2.9255083961860524e-7,
                0.03018907161280525,
                -0.00043722308681250205,
                -1.6419975010701884e-8,
                8.98957457081836e-8,
                4.460910770837741e-8,
                -3.482701542411827e-7,
                -2.7507954164224673e-8,
                6.941482093298088e-8,
                -3.544208483433033e-8,
                1.1665926070800614e-7,
                2.978669424291246e-8,
                -3.2783824543064795e-7,
                0.2134172091933163,
                0.017737966204698898,
                9.034857362919659e-9,
                6.37757621882552e-9,
                -1.5693489490084542e-8,
                9.443460688839392e-9,
                3.50040839223862e-10,
                4.3005704818202695e-9
            ]
        },
        {
            'energy': -0.701949184593114,
            'occupancy': 2,
            'alpha': [
                0.000997557516233425,
                0.0018157660518340838,
                -0.0004785517134170462,
                0.0017289939013496003,
                0.1509087516869633,
                0.040073943381710574,
                0.2067730781708709,
                -0.11091882901702936,
                0.11955847184772174,
                0.04747789014442077,
                0.0005483054789803069,
                0.107378102066436,
                -0.0003077645531193632,
                0.0029905218877963294,
                0.0002872776634272802,
                0.0006345908536375814,
                -0.03951380110856768,
                -0.00017776901891214584,
                0.08831259372181312,
                0.05084869553696199,
                -0.018532403041182543,
                0.009015767159539795,
                -0.013679823156848445,
                -0.017288025604932436,
                0.008845066954182716,
                -0.06494589168683798,
                -0.021158479132760807,
                0.02470633913663874,
                -0.00022324672620679822,
                0.0022100280052816637,
                0.00046539506264253755,
                0.000737504418383965,
                0.03573668058884343,
                -0.0033020367810275733,
                -0.012138136305818545,
                0.02324692254453192,
                -0.1506193021782165,
                -0.04041787702285919,
                0.02911281657168326,
                0.03309431326913442,
                0.03425287202414378,
                -0.022899146656978356,
                0.004726668136858486,
                -0.013769666023163518,
                -0.0058266066934227895,
                -0.004092661865988532,
                -0.0019440207134542036,
                0.0035034453672474694,
                -0.26812476831483756,
                -0.055321905944727134,
                -0.043613103355096064,
                0.014135761403215673,
                0.03685829257108604,
                0.01659268909206314,
                0.0036270246332929246,
                0.0031279906835688202,
                0.03379437313482469,
                0.008928184634961502,
                0.01061391879673862,
                -0.012156563751741394,
                -0.3338396130601194,
                0.043409528570125325,
                0.06684467885710371,
                0.0006159853286700726,
                -0.24644299097733005,
                0.036173249378651,
                0.012287123314286358,
                -0.05442194524272092,
                -0.012611813540408317,
                -0.008648018336627117,
                0.0004088052556283887,
                -0.0013656350927045355,
                -0.0031531382538233376,
                -0.0015624879262898623,
                -0.001002847529577117,
                -0.0005980485535610258,
                -0.001589401316677056,
                -0.0012619217946386618,
                0.00029330945349870534,
                0.000596789266440563,
                0.0023009959301515696,
                0.0022901200390098727,
                0.003046619628464554,
                -0.003718992677738888,
                -0.19761141044135266,
                0.02842310528111489,
                -0.04284212584745404,
                0.041868913772182964,
                0.00653657891453493,
                0.007202700914912773,
                0.0014540311429221678,
                0.0020358484174214236,
                -0.07528931906827484,
                0.03159937273449234,
                -0.04638782891230431,
                -0.02621240163671841,
                -0.013348642264351493,
                -0.0009640286778692744,
                -0.0045818273867700866,
                -0.0007245967318730702,
                -0.00960827031231602,
                -0.0030648106352861716,
                0.0032660400669124504,
                0.0022296955341478434,
                -0.0005752342309749912,
                0.0003966794861636673,
                0.0005861463327705683,
                -0.0006553102159823303,
                -0.0007140049454862612,
                0.0003983849145357752,
                0.00045582859638914513,
                -0.0007067412143191156,
                -0.009434620498354834,
                0.002715083828841836,
                -0.0038139003972708528,
                0.0005119659753876974,
                -0.008285298074601108,
                0.0004283309767368541,
                0.0025981503867027506,
                0.0035348549605915595,
                -0.0007210572090618879,
                -0.00015865177454937933,
                0.00003692730963420582,
                0.0003158877853300047,
                -0.0007665974027995749,
                -0.00006367524584625247,
                -0.0003563065094081775,
                0.0001084356180443885,
                -0.0097302164306477,
                0.0031853272921385143,
                -0.0008203961398718946,
                0.0032274914744157557,
                -0.0014700850254473078,
                -0.00033384758980695606,
                -0.0002895166296147466,
                -0.00030502210143041903,
                0.03894595921900261,
                0.014515879940230006,
                -0.028161126359959335,
                -0.03174218979611611,
                -0.0004889266558761673,
                -0.0001301076013744128,
                -0.000177018879712247,
                0.0002436974422697856,
                -0.0005359289509195187,
                -0.00036790764884503494,
                0.00006316827232534194,
                -0.00006344151991107328,
                -0.0002656052401780084,
                -0.00003504890375291054,
                -0.00023356521692047537,
                -0.00016681900482131158,
                -0.00003435542783353105,
                -0.000090272988366593,
                3.88890688952615e-7,
                -0.000024857220990369002,
                -0.000010487655217676447,
                -0.000020620647821945382,
                -0.00004545493917084319,
                -0.00003613940201438367,
                -0.000009227946911234,
                -0.00003000208250721908,
                -0.000010134145215853887,
                -0.000015050171410057667,
                -0.05287592581809162,
                -0.006415172021291947,
                -0.04662091241829295,
                -0.007478784741227682,
                -0.008323125411817385,
                -0.0038997428048781137,
                -0.0851639967546665,
                -0.01051237983405798,
                -0.09256808775371428,
                -0.01060011914411177,
                -0.10544685081795951,
                -0.011155760770795099,
                -0.06679214315164485,
                -0.009094137618495961,
                -0.08169923677178793,
                -0.0100405927411173,
                -0.0019586011481359956,
                -0.0010718876170120908,
                -0.001368387474313126,
                -0.0003453229633264281,
                -0.000422558696713721,
                0.00010180737610367094,
                -0.0008157047006742352,
                -0.00016468883347796047,
                -0.0004795485282443861,
                0.00000824974378033759,
                -0.00005464358515189863,
                0.0002560661023733131,
                -0.07329050982336527,
                -0.010836514411052513,
                -0.019765032541209475,
                -0.004669952175504566,
                -0.027119057452553164,
                -0.004819054217266487,
                -0.004456959973065199,
                -0.0017638599753580168,
                -0.001549942274939543,
                -0.0005072634185639744,
                0.10902057458069149,
                0.001612866468450844,
                0.00019371317203304515,
                0.0005043856909814993,
                0.00011404451750403284,
                0.00045180572964306304,
                0.0008719377511266758,
                0.0006293278923233201,
                -0.001562076901570995,
                -0.000342350155094718,
                -0.0011736488709474782,
                -0.00048172844275810585,
                0.047438213833822775,
                -0.0070746033713389445,
                -0.00009792759117875157,
                -0.00006225427002955258,
                -0.00011207727745992361,
                -0.00006346576255324276,
                -0.0000492136028251029,
                -0.00007135664458225595,
                -0.0003385845569147729,
                -0.00003603051487786949,
                -0.000040682266855240814,
                -0.000008350863742588872,
                -0.04602351966050397,
                -0.004871577333392208,
                0.00000726659674522998,
                -0.000020495104813030948,
                0.000014128952869141027,
                -0.00001148437432788069,
                0.0000059548709812987435,
                -0.0000033106305087796754
            ]
        },
        {
            'energy': -0.6972267794444124,
            'occupancy': 2,
            'alpha': [
                -0.0055107218597189546,
                -0.0077717174202240865,
                0.001946141584021532,
                -0.007074548813105052,
                -0.053133402926660814,
                -0.05307193102301341,
                -0.08933084376013664,
                0.07852132079576989,
                0.13967971308109672,
                0.030160058321519568,
                0.06423497222591479,
                0.22274262960621585,
                0.002208931899010132,
                -0.005765819187156533,
                -0.0004708348743451469,
                -0.001255955615412117,
                -0.09987586448992239,
                -0.007621473422208871,
                0.21252040556349722,
                0.14034101796201728,
                -0.035582110837074,
                0.016973880258526097,
                -0.052173120861815275,
                -0.04653479552729389,
                -0.004508857149165854,
                0.08951328201942105,
                0.03540750778399053,
                -0.030560532595784142,
                0.0009881786835063888,
                -0.0047721942368201455,
                -0.0012376713446125415,
                -0.0017930551109914393,
                -0.05437491954444271,
                0.007560199700107635,
                0.019886635120184286,
                -0.032446930974865416,
                0.1730694812163552,
                0.022628639301428152,
                -0.023860766363751673,
                -0.02148509042740307,
                -0.048940073518193926,
                0.036224794612661766,
                -0.004176866917198348,
                0.02088105554240717,
                0.006325318761919412,
                0.005295046608171134,
                0.0038921826039315156,
                -0.0052194652252566445,
                0.18013222124708617,
                -0.00036245204651816864,
                0.045055829601066515,
                0.016343681998906814,
                -0.06166922335008302,
                -0.024640897476144983,
                -0.0047678819809983475,
                -0.004728569661236082,
                -0.05529680639535697,
                -0.012403875074694294,
                -0.015835113412637023,
                0.019445824630065032,
                0.1165495798820529,
                -0.0727921112799876,
                0.013095508861108123,
                0.041109352594821874,
                -0.13438055576485558,
                -0.04808557092543231,
                0.07472273081490112,
                0.009181132847948685,
                0.030842071387934853,
                0.016490374751477545,
                -0.0010037147458508602,
                0.007434368125462844,
                0.0030705588485967867,
                0.0015616942672606665,
                0.0014589605919695906,
                0.0002228754656684658,
                0.0020092690124060134,
                0.0015980709265595336,
                -0.00013972555055228835,
                -0.0009199977607352429,
                -0.0048778180512284814,
                -0.003731807357085308,
                -0.005171243763282921,
                0.006611108540305137,
                -0.3150650391521049,
                -0.040547092016748935,
                0.017321496941861976,
                0.06681370464241622,
                -0.012599612723069892,
                -0.01366498980945588,
                -0.0020922290070105945,
                -0.0036370705895831796,
                -0.202409789228532,
                0.04799760984657574,
                -0.08426157623093819,
                -0.06855140250445811,
                0.03079949665743615,
                0.002866176186635742,
                0.00996369453990342,
                0.00810760571286882,
                0.02814701635030791,
                0.008450317716606315,
                -0.010077290062760086,
                -0.0032184875549162192,
                0.0008281414176689473,
                -0.0007220243698096528,
                -0.0009897006532389398,
                0.0013389545431504702,
                0.000923699668254593,
                -0.0007083930053462933,
                -0.0010289906085415518,
                0.0013443902908402854,
                0.030070565946094443,
                -0.007035181307781367,
                0.011889590899156578,
                0.001923411073036196,
                0.02893007929518779,
                -0.000655628715657463,
                -0.009358224537352623,
                -0.010228232880404418,
                0.001363755896528201,
                0.00027619856712941923,
                -0.00008104611093401005,
                -0.000530828488165108,
                0.0014320582509895138,
                0.00009636982051701543,
                0.0005993078813486611,
                -0.00014736051192873353,
                0.035136348714800446,
                -0.010945780992592491,
                0.002745664089253757,
                -0.010259436358675182,
                0.0037499458714404404,
                0.0008813360942242831,
                0.0006136892304493901,
                0.0006949886695625743,
                0.08284079510988004,
                0.02636926905980035,
                -0.09647583862572173,
                -0.07667117038889974,
                0.0009615693023110007,
                0.00023796974804535137,
                0.00031998501074629774,
                -0.00043871554846050873,
                0.0013291234596068604,
                0.0009054284505934604,
                -0.00019980594704136767,
                0.00012430670630578645,
                0.0008267159921477054,
                0.00011670193770752372,
                0.0006303384130016815,
                0.00045712943311674854,
                0.00010603677345997548,
                0.00024062169601327867,
                -0.000012464152745810769,
                0.00005835435805927158,
                0.00006593250659552506,
                0.00007586184045275809,
                0.00013528051717143758,
                0.0001114787445069798,
                0.00004234744981195921,
                0.00009298476268152357,
                0.000029083322238109293,
                0.000044975685796687514,
                0.061460000707846726,
                0.004980515412083675,
                0.0563991393599902,
                0.004966297221160771,
                0.009981085357135464,
                0.0032937502536798413,
                0.053360687874253104,
                0.002935941148021873,
                0.05455585667055969,
                0.0032225581057979675,
                0.04422458391651434,
                0.0015267710658787759,
                -0.053385485747688644,
                -0.004231248328581329,
                -0.04727680684602897,
                -0.004063830067292207,
                0.0013791270246712958,
                0.000780493886799118,
                0.0014867953733735271,
                0.0004530455706111447,
                0.00019655859223390804,
                -0.00019052260309702663,
                0.0010742558951069355,
                0.00029235165954619917,
                0.0005435717270774171,
                0.00009788862632959322,
                -0.00005626336117857386,
                -0.00037123729759591195,
                -0.0939153654402337,
                -0.004362843605567168,
                -0.06256495818576104,
                -0.006749251747805908,
                -0.059806096211704955,
                -0.007182850107883313,
                0.006451620884402023,
                0.0022872695410094623,
                0.004670416257629164,
                0.001560113176682781,
                -0.06351697747944623,
                -0.005480167016010785,
                -0.0003568489528701243,
                -0.0007341925830179006,
                -0.000346200529567684,
                -0.0006571199895037316,
                -0.0015633410358321565,
                -0.0009176923389224059,
                0.00501902650995123,
                0.001766117371950206,
                0.004602887544583442,
                0.0015839263742857372,
                0.11384867233983088,
                0.0072103063656581605,
                0.00021372209790039248,
                0.00009791995673685374,
                0.00023722233001293035,
                0.0000983860099709931,
                0.00011269112205139103,
                0.0001205228090446419,
                0.0007671710746304455,
                0.00004767138675911083,
                0.00017519824913695363,
                0.00003287449730160218,
                -0.11180742900533523,
                -0.012936309108744767,
                -0.000020514561424268478,
                0.000047389184971014596,
                -0.000032867303574849655,
                0.00002830826350114297,
                -0.000016019301451591686,
                0.000009745550700192988
            ]
        },
        {
            'energy': -0.694129811404796,
            'occupancy': 2,
            'alpha': [
                0.05865519412760804,
                0.07653256604424274,
                -0.018911491618041457,
                0.06788845616642779,
                -0.029216965554838343,
                -0.008452842665014587,
                -0.043655753696405876,
                0.02500412977812087,
                0.015422492052209203,
                0.00011437884781318083,
                0.016043849589616476,
                0.03464969346944388,
                -0.0030742400298885884,
                0.003518795795263585,
                0.0002056273344779053,
                0.0007353300608149396,
                -0.018185613225810394,
                -0.001901811059904305,
                0.03726901381550192,
                0.026948657419842138,
                -0.005393157721955888,
                0.002762586051755168,
                -0.011481707662643888,
                -0.008666299456855773,
                -0.006192694290266487,
                -0.029497336994504738,
                -0.0044398042942357325,
                -0.010320799003109747,
                -0.0011798229935131397,
                0.0032987036221658983,
                0.0011549636865855846,
                0.0014351642020537644,
                0.0278162813641365,
                -0.002272907923503561,
                -0.00568065232197649,
                0.00738767105487996,
                -0.015214014552432691,
                0.01057595619598704,
                0.0025328028918712993,
                -0.014941498712516299,
                -0.03141548661383023,
                -0.04250054871023614,
                0.005415736252086419,
                -0.029792065685195754,
                0.0060699707272954834,
                -0.0003140987205116582,
                -0.0026978327254348895,
                0.0037315823290732645,
                0.03235264092802871,
                0.016222745951515464,
                0.006806398363420367,
                -0.010831001489040185,
                0.028588819982116896,
                0.007575715983782521,
                0.001706000369260436,
                0.0004896323351557988,
                0.016304203445809986,
                -0.005817701155192923,
                0.005186585916453012,
                -0.011491729327476398,
                0.061604679535505885,
                -0.009059273633046538,
                -0.005204477806089,
                0.0006404915335965484,
                0.012008637497782906,
                -0.0140484876460082,
                0.01625984725179397,
                0.008568167166284753,
                -0.2296222979078051,
                -0.06756868980826793,
                0.015950676408354705,
                -0.05712291126174964,
                0.001738403901679484,
                0.0002596420250416562,
                0.0001578639761185723,
                0.0014773096055997988,
                0.0011707288935242635,
                0.0005403272594007514,
                -0.0011229425197761226,
                0.00049850082195396,
                0.0002135681444483802,
                -0.0017998372893002048,
                0.0011036018504445506,
                -0.002691698712464182,
                -0.04264301110306849,
                -0.013231991272201619,
                0.012956339365144915,
                0.008601474030791107,
                0.007708379253062145,
                0.008193844328297872,
                0.0006469600581963111,
                0.0018227163792654312,
                -0.037923496176141415,
                0.006322476575244697,
                -0.011740878792173942,
                -0.012365792293294627,
                -0.2192461603265664,
                -0.018960288548634654,
                -0.06368289656656385,
                -0.07982672985206472,
                -0.2154817156140416,
                -0.061390924078669945,
                0.08284100795710736,
                0.009466885091532175,
                -0.0006939570219429359,
                -0.000640879068156316,
                0.00023509020436415326,
                -0.00032589603807274466,
                -0.000717768149000548,
                -0.0005671552931277215,
                -0.00006291349930857964,
                -0.0005289743121787789,
                -0.25299485044256004,
                0.05336255742665022,
                -0.09775766110031749,
                -0.0312566312348539,
                -0.25184015419760275,
                -0.0004155178026299253,
                0.08456191592821055,
                0.07837749711959473,
                -0.0004180544997856576,
                -0.00022047050526601727,
                -0.000007918007377888144,
                0.00016973977661248967,
                -0.00043607026502608576,
                -0.00016374388579651832,
                -0.0002311551390013691,
                0.000041563841645161776,
                -0.31535390546743086,
                0.09556990567559137,
                -0.023549655555357065,
                0.08494339181677069,
                -0.0030603634550666397,
                -0.0007809215625029824,
                -0.0003968088685562346,
                -0.000520541938825105,
                0.013135768050832216,
                0.004149348539230481,
                -0.020369863973297753,
                -0.013551139027512923,
                -0.0002744248279878954,
                -0.000124358299769099,
                -0.00011254608915307379,
                0.00013215170295800252,
                -0.00102155343476534,
                -0.0007083566002676182,
                0.00018590826542946254,
                -0.0000798620801287532,
                -0.0007776761818794116,
                -0.00012228941517030222,
                -0.0005360927390884013,
                -0.00039847399808787775,
                -0.00008778582680689282,
                -0.00019418641250018063,
                0.000018716508202204384,
                -0.000041800667602292864,
                -0.0000762804517463487,
                -0.00007758691204245917,
                -0.00012049064245804451,
                -0.00010254620174862427,
                -0.00004349784323805627,
                -0.00008369152063035362,
                -0.000024092531561768485,
                -0.00003927158866038762,
                -0.013064358085337117,
                -0.002566486090915892,
                -0.001991008018003258,
                0.0006045189270358263,
                0.001501674200014432,
                0.000802454387176007,
                0.01099338128069042,
                0.0007234606033975493,
                0.006351980971174072,
                -0.0012943711896280217,
                0.02028768156998009,
                0.0006994814431429468,
                0.0012932507968479539,
                0.0001846770993510613,
                0.003421820710088429,
                0.0002279206663862817,
                0.0009471938844079673,
                0.000530452583163479,
                0.00025750720339552576,
                0.0001929052709225204,
                0.0007164363289665003,
                0.0003677446156916669,
                0.00012394395704221165,
                0.00015311231889996796,
                0.0005150348987690411,
                0.00035612435848977935,
                0.0005049376984829738,
                0.0004216986729509745,
                -0.012127816483088843,
                0.00020268281060249773,
                -0.012277824665291402,
                -0.0007664900244424726,
                -0.010378855035214152,
                -0.000843275153651257,
                -0.03804251560625935,
                -0.01087805374582124,
                -0.03620956463484958,
                -0.011287356247978648,
                -0.023611246916752215,
                -0.0011734204541252974,
                -0.0002758771485310266,
                -0.00023514989440104382,
                -0.0002941856337496176,
                -0.00022909715860939606,
                0.0007224589980383981,
                0.00047281733977927714,
                -0.04219856126627799,
                -0.01284776998448138,
                -0.04261117476451724,
                -0.012672395979479455,
                0.018739886060530227,
                0.0018021809424798162,
                -0.0000756037183260096,
                -0.000012520177115792097,
                -0.00008074141578369371,
                -0.000015317742428167842,
                -0.000022638798331744437,
                -0.000024845184743834834,
                -0.0005504323177562507,
                -0.000012792381405472532,
                -0.0001933555664142675,
                -0.00003618503686491152,
                -0.019744316819436957,
                -0.0023757400784444696,
                0.00001934680894389654,
                -0.000035512538031755136,
                0.00002476581096086501,
                -0.0000238158279108743,
                0.0000133982154494254,
                -0.000008413461693875138
            ]
        },
        {
            'energy': -0.6891254631492008,
            'occupancy': 2,
            'alpha': [
                0.013987572709920015,
                0.016765492872624174,
                -0.003972746961765685,
                0.014743586428047392,
                0.10438761122730209,
                -0.02322035528508402,
                0.13957832443527882,
                -0.0511485280970835,
                -0.011293809463121023,
                0.017260375616070005,
                -0.06240229675619779,
                -0.07817749700298893,
                0.01844008305917724,
                -0.024363655149050048,
                -0.0006823038332490559,
                -0.005145826091683743,
                0.054783843110246054,
                0.00807579365695364,
                -0.10476847028972727,
                -0.08779727458033973,
                0.012032465174223453,
                -0.006847695587562441,
                0.04367141869967881,
                0.026677928291145545,
                0.027636614798210873,
                0.2019752046176041,
                0.10002587016673586,
                -0.06871082992137473,
                0.006117066208169637,
                -0.02338785847653215,
                -0.007969087622231303,
                -0.01054396836547732,
                -0.1399212092398948,
                0.0400839170972701,
                0.059335472316023444,
                -0.07822192170670766,
                0.2792004497705923,
                -0.04302276578851542,
                -0.02324520035384761,
                0.013582169830096809,
                -0.14585333941753803,
                0.08676727668364116,
                0.006084641615964947,
                0.03202649721230122,
                0.012059990828399576,
                0.014312157757395878,
                0.012344914052917618,
                -0.013090581947885977,
                0.038104001532206215,
                -0.09504145158936923,
                0.02027289813824076,
                0.06389647474693087,
                -0.19915048875920846,
                -0.05987172541732285,
                -0.008584412079669318,
                -0.013443058897663845,
                -0.17557897438738493,
                -0.031106265853191425,
                -0.041006323227874876,
                0.0530552706044935,
                -0.20680035989280657,
                -0.037032871730353835,
                0.03339903933252595,
                0.035231137090492255,
                -0.15234376321076776,
                0.03976263415474429,
                -0.04952632388220897,
                -0.03479454443695351,
                -0.03204699810836956,
                0.010714861543238701,
                0.007587542604090072,
                -0.005501064769425691,
                0.004088155858929603,
                0.0032112648306713842,
                0.003706778950857333,
                -0.00125109015699087,
                0.003907933863161396,
                0.00377962633585188,
                0.000720543548681687,
                -0.002590089077612543,
                -0.025957926779421988,
                -0.01381921237139107,
                -0.018163441453655,
                0.02361465176129989,
                0.07101229154532528,
                0.055133834579999215,
                -0.0722417328363195,
                -0.010478395183974245,
                -0.053427353061940804,
                -0.05435577054524138,
                -0.0039621885379608765,
                -0.0131301053904237,
                0.11669873173466627,
                -0.009052662610532499,
                0.01851710933109617,
                0.035651347750159934,
                -0.030228836116360697,
                -0.0022563790420632255,
                -0.00577372260149135,
                -0.014126476132170945,
                -0.027873816128500626,
                -0.007452758965644217,
                0.013370019235663536,
                -0.003093732467998703,
                0.00024198209090695803,
                -0.0037695451850060587,
                -0.00309848933545057,
                0.006635583443545406,
                0.000011386978540449322,
                -0.0030897866379342195,
                -0.006019036803500892,
                0.00521359661622208,
                -0.04540570892091249,
                0.007127375607188924,
                -0.016417383147426214,
                -0.008455972874487948,
                -0.04428114961848512,
                -0.0026527577538065813,
                0.016430389855521824,
                0.010773290630145994,
                0.0052765573966788385,
                0.0007085779589712976,
                -0.0004715859272321097,
                -0.0014527610074530376,
                0.005454768252173129,
                0.00008195854201346248,
                0.0016742827935847173,
                -0.00014150476696290552,
                -0.060529298594316834,
                0.016959520266491605,
                -0.0037120274194747745,
                0.014753705726284353,
                0.02308380991414543,
                0.00465199140851666,
                0.0025330324127699356,
                0.0031316865607523147,
                -0.03012926079190668,
                -0.009710150119644032,
                0.07378316954032411,
                0.03901289169377335,
                0.0040483572236858735,
                0.0007956071288194242,
                0.001087541613462278,
                -0.0014985073673899193,
                0.00843519959077933,
                0.005221366368201245,
                -0.0017431851720639002,
                0.00030103231938794774,
                0.00685935610370924,
                0.000605483866210947,
                0.004239980394624973,
                0.0030122185190832674,
                0.0012394431174215926,
                0.0017874424322722358,
                -0.00025298019642984947,
                0.00032175587393021776,
                0.001221475316358506,
                0.0007429568088722539,
                0.0011793659908697388,
                0.000989303127783805,
                0.0007706880514387733,
                0.000906806882043186,
                0.00025956022878292456,
                0.0004197056996790229,
                0.09661843515411374,
                0.00016359842625860533,
                0.09319010933496268,
                0.0003880506683632495,
                0.02070066826511122,
                0.0018320638174446745,
                0.011905768484327311,
                0.00039572413628095697,
                0.012053868948113335,
                0.00014461538461885476,
                -0.06995782210468934,
                -0.0014332260091141403,
                -0.04753685381370958,
                -0.0019668583508959526,
                -0.04910608783504553,
                -0.0016889312897480175,
                0.0007844837062461069,
                -0.00011155567522989451,
                0.002770654256892351,
                0.0006068347603598668,
                -0.0011142993408758955,
                -0.0008356094794968406,
                0.0024218560280260554,
                0.0006702195950011651,
                0.0009417891941397359,
                0.0001316886328914234,
                -0.0009644213178169487,
                -0.0011698104857814464,
                0.01982982831546852,
                -0.0015909900658300183,
                0.039890882639201986,
                0.0005064219744223936,
                0.029014713454678674,
                0.0009454109822516064,
                -0.005441996626676315,
                -0.0016275140939163023,
                -0.004521672226780662,
                -0.001550803587949589,
                0.05622030433246662,
                0.0011989378903376755,
                -0.0021065301844556124,
                -0.0023975598877877284,
                -0.0024970088205182304,
                -0.0022519206212708635,
                -0.005753807739147173,
                -0.0024676111626554783,
                -0.008439543308940457,
                -0.0019164016178804327,
                -0.008170461359971624,
                -0.0018675305131195124,
                -0.04796521654535045,
                -0.006932012021108666,
                0.0010384824468201153,
                0.00027148491070033774,
                0.0011154004991577693,
                0.0002647153424068253,
                0.0006305721407192298,
                0.000399753981937019,
                0.0040789699953448786,
                0.00010533484089833553,
                0.001691427951358702,
                0.00025139278106967174,
                0.05616808252777664,
                0.007084782000688081,
                -0.00007563737984996372,
                0.0002846222422431854,
                -0.00010196643707183274,
                0.0002040700725237204,
                -0.00006665765574253438,
                0.0000981756725786907
            ]
        },
        {
            'energy': -0.6777454435612704,
            'occupancy': 2,
            'alpha': [
                -0.06651206919128082,
                -0.0680511550840799,
                0.016982595497083062,
                -0.06000537654756302,
                0.013310820646482481,
                -0.04848958437186637,
                -0.014586739314868256,
                0.030152975410392236,
                0.013156747962741444,
                0.01664844859438637,
                -0.029604791099116276,
                -0.007398625473472691,
                -0.05769348828256828,
                0.04475516619213936,
                -0.001795814638697041,
                -0.0005056616342145506,
                0.025448326520040955,
                0.006238970317649624,
                -0.039421734584302065,
                -0.04739123982192625,
                0.004095639591972949,
                -0.0015345812281576457,
                0.027833881750896204,
                0.012892389316324762,
                -0.014106521564886853,
                -0.08909980988750958,
                0.05683561113270072,
                -0.14740262771322818,
                -0.013477581754538233,
                0.05667116593383658,
                0.030960662862505477,
                0.028653912788291967,
                0.24270004468925194,
                -0.015201191372875964,
                0.008511264251793873,
                -0.027684090006026136,
                0.031122703305524312,
                -0.0002126456879624705,
                0.016514680445810375,
                -0.06346618923002328,
                -0.24276803186925666,
                -0.08419926838943205,
                0.0022538369611589983,
                -0.04677977114571157,
                0.1875293969442534,
                -0.0012029317392933119,
                -0.030071359559480537,
                0.03847616006753217,
                0.06303317790730836,
                -0.013267394000311492,
                0.022240867133263186,
                -0.009609084001710693,
                0.17301448482049922,
                -0.0013138388813788541,
                0.025282301201073887,
                -0.05118172240832742,
                -0.025114198852082287,
                -0.06597586932083964,
                0.010549378259672296,
                -0.05106643621041797,
                -0.0068518018010386905,
                -0.05477502455175933,
                0.02143039247216711,
                0.02081510390274674,
                -0.09753339183058832,
                -0.003537026688434816,
                -0.005063971636293575,
                -0.006532170361694879,
                -0.2736158612485742,
                0.0481675874861731,
                -0.01628069572756268,
                0.050473753797785,
                0.07965426967857947,
                0.009253544023098055,
                0.017172991701414744,
                0.037419766848597553,
                0.060376425848694175,
                0.023093373936547614,
                -0.032871668460005644,
                0.004125352557811464,
                -0.03070151188519989,
                -0.016822860223210594,
                -0.0037420324309127384,
                -0.0020575200288779575,
                -0.010094081426763716,
                0.024934671512079867,
                -0.044971119535945035,
                0.003259755285649355,
                0.0994131775925401,
                0.08516121755655598,
                -0.001118837145691696,
                -0.0004588213608484052,
                0.05216308367596111,
                0.003740062136754484,
                -0.006628928468560165,
                0.011659200943910212,
                -0.08447509661716215,
                0.07071689876356377,
                -0.05336543682791237,
                0.031811070883986804,
                -0.08208727070694748,
                0.048832292191600624,
                0.021878750804485182,
                0.07787445513699992,
                -0.012286214750192597,
                -0.006120312352250772,
                0.0029486859823289434,
                0.004800735581384797,
                -0.012692370157947587,
                -0.0031393164319890037,
                -0.007511751459525044,
                -0.0017101331327919673,
                0.099107048774112,
                0.018997364784167824,
                0.0250958688806188,
                0.04515484273806967,
                0.10137340063762738,
                0.03748136996756647,
                -0.03936884305801589,
                0.005928225332495952,
                -0.003658622190088166,
                -0.002029771243072856,
                0.00029470240501440405,
                0.002688239014299398,
                -0.003905189301147896,
                -0.0010912252208041772,
                -0.0032351244152172623,
                0.0006652684966542936,
                0.17233469049836964,
                -0.03176602530726601,
                0.008247499383876011,
                -0.027438869837923173,
                -0.08254947767179768,
                -0.006767480878642833,
                0.00022244233355286412,
                -0.003241212177626041,
                -0.0051824051591281535,
                -0.0017058494798904357,
                0.044048223809365676,
                0.016378196289288965,
                -0.0029553665886452706,
                -0.0011885234597635115,
                -0.0013101799029117476,
                0.0016804048184297531,
                -0.034631713909626494,
                -0.015204893803741897,
                0.011163283369755687,
                0.00290275125349773,
                -0.03993275770554029,
                0.001860602936479412,
                -0.017098398957642452,
                -0.011173456767661467,
                -0.012693758940988117,
                -0.00972981104254102,
                0.0033077388122180478,
                -0.00049763073351397,
                -0.01576926704103985,
                -0.004737020681910872,
                -0.008089800972760425,
                -0.006708553994443317,
                -0.011062196897846172,
                -0.0074141177571962905,
                -0.001792013652468406,
                -0.003217239004960746,
                -0.02079380556803196,
                -0.00007365545312718756,
                0.039456174129966694,
                0.0012952523908616057,
                0.06761616288359751,
                0.007043612896746234,
                0.031277043266052296,
                0.0010042178903151787,
                0.00528389706087501,
                -0.0011835849397591604,
                -0.008532921408943536,
                -0.001156524276426319,
                -0.03960888278935555,
                -0.0005122655040176883,
                -0.032410498218445924,
                -0.0005705373320328093,
                0.02969490974442744,
                0.0058513454180968115,
                0.021050780076633385,
                0.005227011729499433,
                0.02709620792602332,
                0.006045931077795749,
                0.015217137017604961,
                0.005212484624238391,
                0.019684012986966114,
                0.005906680697375682,
                0.018672246144754198,
                0.007218965456968443,
                -0.0012496465435886755,
                -0.0010804998675336536,
                0.019483227833017914,
                -0.0005840527357629441,
                0.012175506894459134,
                -0.0002382124663280375,
                -0.03511362833660284,
                -0.0022666381981489756,
                -0.033795304089689025,
                -0.002634589814594825,
                -0.024078385766983165,
                -0.004162951714399857,
                -0.003747033101683912,
                -0.00160142791754283,
                -0.003945807121850283,
                -0.001433469223334752,
                0.007614427742986916,
                0.0017273452016594512,
                0.028059851369699216,
                0.0024969169672587,
                0.0292161800312364,
                0.0024606635031528866,
                -0.009776514601213988,
                -0.0021755527478753913,
                -0.00022400160051797368,
                -0.0003610935190702802,
                -0.0002832702466170998,
                -0.0003645398868445816,
                -0.00017628245989586758,
                -0.00019353251818207673,
                -0.010929028333690105,
                -0.0005529295838344029,
                -0.010185936943624456,
                -0.0012618046853413239,
                0.021781726367286303,
                0.0028896440225236095,
                -0.0009558057604391576,
                -0.0012364653055477474,
                -0.0016942113443768445,
                -0.0011870356882704336,
                -0.0009200261992879872,
                -0.0008213507494604069
            ]
        },
        {
            'energy': -0.6759067145697795,
            'occupancy': 2,
            'alpha': [
                -0.033756813818444184,
                -0.034426810977125064,
                0.009312476801670747,
                -0.029852562980316376,
                -0.030595086987012646,
                0.11417978852507125,
                0.044295691756645335,
                -0.09083119798172849,
                -0.037541907442311305,
                -0.04685635229743505,
                0.08150602728304647,
                0.007167560715425628,
                0.04387814466536969,
                -0.035252251019101906,
                0.007702865998577075,
                -0.006939177738132705,
                -0.07500028386090832,
                -0.019225394786145454,
                0.11107829576198694,
                0.14260833991196886,
                -0.012399616465246252,
                0.004052356721786943,
                -0.0846572263393528,
                -0.0382316939098434,
                0.06981435065087473,
                0.028461140190152837,
                0.0698996250815817,
                -0.07192287977632823,
                0.007946734285071233,
                -0.04813116870109013,
                -0.023891039164186053,
                -0.030308573274474608,
                -0.00007916275804879156,
                0.06586401847709963,
                0.04930472713648486,
                -0.04123761745902716,
                -0.0321343084724298,
                -0.09610641050937367,
                0.014163168566116905,
                0.035917638627703544,
                -0.1772147678939506,
                0.028395156373143413,
                0.03016379711999983,
                -0.02730473956764391,
                0.05192217945836121,
                0.013038305910987846,
                0.0009777940918492,
                0.006591981830548334,
                -0.1768612859295203,
                -0.0046077719563649075,
                -0.03816421855060863,
                -0.007907717360097344,
                -0.16617746527418503,
                -0.005333090005261947,
                0.017709648217425412,
                -0.02307261719028328,
                -0.1832204349954402,
                -0.02172316029062978,
                -0.015171535892981912,
                0.01821946628698735,
                -0.011551835625311181,
                0.14338504918334255,
                -0.058540551390737154,
                -0.07297781421807943,
                0.28106440405958943,
                0.015308703325038872,
                0.005314401584108062,
                0.009949880716136287,
                -0.145505960617494,
                0.03106346769380672,
                0.0013962931556213845,
                0.02233036907399299,
                0.015305571482646997,
                0.004659486374543804,
                0.006358092247035275,
                0.006399279531787221,
                0.0148167776387035,
                0.008143704770392775,
                -0.0060256921569844055,
                -0.0002693195232782133,
                -0.07660860185261148,
                -0.018392200844048693,
                -0.020339001120547984,
                0.02700723733984874,
                0.043117709199765854,
                -0.06668307520043698,
                0.1309077139627101,
                -0.011258110910483383,
                -0.08552452395229819,
                -0.06617044862799823,
                0.011913949270642911,
                -0.015136631694103977,
                -0.15081669389501395,
                -0.01336091375017519,
                0.02580357946810256,
                -0.030834071708118693,
                -0.05731237683289636,
                0.03691648264115154,
                -0.027327536095977555,
                0.014663787578390765,
                -0.043444117448048825,
                0.025358106312507137,
                0.014261450588287677,
                0.03898023591892117,
                -0.020912976458159836,
                -0.00950932996691662,
                0.002495611053301034,
                0.01665261528977456,
                -0.023678782756280603,
                -0.003677690905517786,
                -0.019038855869937515,
                0.0043875437675968965,
                0.04025570395013835,
                0.012966957468757197,
                0.010805818948891177,
                0.024326703690412493,
                0.04937907186952423,
                0.01937839861831297,
                -0.0179421517526775,
                0.004520038882322598,
                -0.00043313764751145076,
                -0.0021286560073638413,
                -0.00015272035818709138,
                0.003775508095071776,
                -0.001105987988732189,
                -0.001282483233766797,
                -0.004236130016372476,
                0.0019437245837012574,
                0.08210610833614006,
                -0.014125378533851981,
                0.00545429139308843,
                -0.01090179651891504,
                0.07713679162484494,
                0.0032325327115513233,
                -0.001041278986141433,
                -0.00008785252259816007,
                0.011676289475064295,
                0.0041774275062477825,
                -0.13298213662205724,
                -0.04735017839138453,
                -0.0001279406966118627,
                -0.0009429559396284602,
                -0.001153658811297986,
                0.0016217932648993473,
                0.03454628374676341,
                0.013469228967351355,
                -0.011514439579569958,
                -0.004078290242610149,
                0.04113331190378041,
                -0.0033221880778452387,
                0.016462996039750585,
                0.009978865900384206,
                0.014828521813954963,
                0.010219922841590274,
                -0.0038310660194622063,
                0.00020446888728723654,
                0.018556455542332522,
                0.004842090888792987,
                0.008789139064316368,
                0.0071307567288206326,
                0.013375427937039046,
                0.008289831722171728,
                0.001971315432906659,
                0.0035408264502208952,
                -0.026055418520550024,
                -0.004137157053593724,
                -0.00708184515440765,
                -0.0019791553025700626,
                0.024444472496083117,
                -0.0014388010635254097,
                -0.05290066432793484,
                0.0011232709521065835,
                -0.054956316064770215,
                -0.00210173850406141,
                0.0011642536244609407,
                0.002393221050253908,
                0.11517543639901119,
                0.0011780753682353315,
                0.09764831159880291,
                0.0016073064435217855,
                0.004433848026915522,
                -0.0003001090434774169,
                0.004930940538067032,
                0.0009796154906691237,
                0.0022871824899538588,
                0.00034185637583438307,
                0.004414658087906215,
                0.0012790005251162417,
                0.005070388114996004,
                0.0007179487255077251,
                0.002388761779750495,
                0.00002508631127938421,
                0.0040656885426234675,
                0.0022299148745012734,
                -0.05670882021272318,
                0.0017182551959034026,
                -0.035633523729836435,
                0.0008765922219766972,
                -0.024138158565140407,
                -0.0030255364173719717,
                -0.017104682072675095,
                -0.0020172434390733464,
                0.06329121188371085,
                0.011191169551296787,
                -0.007719391354964889,
                -0.0034313825695857945,
                -0.009625934862958218,
                -0.003365867140350661,
                -0.0074786677473767495,
                -0.0011408254371836717,
                0.011980233233231623,
                0.0008582336366253962,
                0.015173941779125337,
                0.0011613014345874088,
                0.020547921337172655,
                0.004333247989660545,
                0.0010286570866123595,
                -0.00037441778653407934,
                0.0008951571234462821,
                -0.000418784453547507,
                0.0006897523636350121,
                -0.0000031487874594815706,
                0.009933174613211661,
                0.0007352945598977379,
                0.010340218744833651,
                0.0012511582732494158,
                -0.061720920717378426,
                -0.008181756446822844,
                0.0014090524295978935,
                0.001256751361599842,
                0.0023628402222636356,
                0.001243849681137147,
                0.0013691592581337897,
                0.000919411501331015
            ]
        },
        {
            'energy': -0.6706288787220714,
            'occupancy': 2,
            'alpha': [
                0.04243900311829714,
                0.04454463692483018,
                -0.011550753310013522,
                0.03878387828041976,
                0.015005669384169832,
                0.04979952369976164,
                0.07750753199412691,
                -0.06819618240143413,
                -0.026790036847759924,
                -0.02855862063937728,
                0.03128920257743935,
                -0.017438870927476476,
                -0.09309413115937747,
                0.04953904031824348,
                -0.02598705026184898,
                -0.00799819790193784,
                -0.0390202155247621,
                -0.01282284663496585,
                0.049832715778128034,
                0.07839785931756098,
                -0.008953137751804292,
                -0.00017766895038978358,
                -0.04641861316530877,
                -0.020848516178629338,
                -0.0036919680574772798,
                0.07295143886707847,
                0.029302695401169712,
                -0.008867178470733553,
                0.0030301354215438066,
                0.12625482787941425,
                0.08223119048123685,
                0.08576273032746341,
                0.003064807071856972,
                -0.03334795243428913,
                0.009601152908380766,
                -0.038231699107971064,
                0.07786783513309796,
                -0.02255592283234063,
                -0.003251213983266688,
                0.023401046793101017,
                -0.0009506428000635454,
                0.052597165287007856,
                -0.007293034243691712,
                0.0364952377499923,
                0.06614009700308646,
                -0.008968327527242467,
                -0.005305027991071498,
                -0.0027864894318852113,
                -0.03087637105836641,
                -0.029010340296099918,
                -0.014462392135967886,
                0.02491496304172348,
                0.07381778040084315,
                -0.0706980559800316,
                -0.015354863407530681,
                -0.036837016420401165,
                -0.023829328049345035,
                -0.02337368229117434,
                -0.01186087944678969,
                0.002923219572521267,
                -0.06139470229970696,
                0.05461325793838117,
                -0.034589830074868204,
                -0.016797761530728688,
                0.10977208135274248,
                0.01862694995965239,
                -0.017674677654816947,
                -0.0013475126367548588,
                0.11852834869158911,
                0.005865127202993861,
                0.001035671376636353,
                -0.0013382050809916625,
                0.04340163341278528,
                0.001273233831597585,
                0.00799287746479999,
                0.01397827305744131,
                0.02971240926172996,
                0.008424190375684388,
                -0.013307825316753664,
                -0.0011846579215636713,
                0.010999695390607387,
                -0.004480086722442911,
                -0.003944387502943985,
                0.0017280779735127534,
                0.04429455446654283,
                -0.02952269668424052,
                0.058662699766057196,
                -0.002966374871545013,
                0.1549727400369375,
                0.07625069963037459,
                -0.048049704756295844,
                -0.018752470514459246,
                -0.07506316974144335,
                -0.011819033098256106,
                0.020188676042383422,
                -0.009225906009632195,
                0.06004669162962578,
                -0.02789807317588275,
                0.02610385833065084,
                -0.009341091402849087,
                0.054615563426196535,
                -0.016982809727124237,
                -0.013294629974768022,
                -0.03436707584699169,
                0.008333932448831535,
                0.000026206762031082034,
                -0.0037969289828558147,
                -0.0012427044735326567,
                0.011082898908998324,
                -0.0017482244009265854,
                0.0027109020653558174,
                0.0021097707582373127,
                -0.04006287978441568,
                -0.01707493841100798,
                -0.011568583441875205,
                -0.030448492117866148,
                -0.045644889344868995,
                -0.02625765143105091,
                0.022501863966911707,
                -0.009155215013502313,
                0.0068064543268523394,
                0.0014053377929034452,
                -0.0011864058251071362,
                -0.0029403864806062906,
                0.007878350086742219,
                0.0003019591189073078,
                0.003736576025780829,
                -0.0006287149020668798,
                -0.09481054881276076,
                0.013195317320861063,
                -0.004438056092717587,
                0.010194197140857793,
                -0.32036830539955086,
                0.038815441664365916,
                0.03635674852828427,
                0.03387877382795067,
                0.0018125820044373056,
                -0.001052705210818168,
                -0.07244237164071145,
                -0.02339939014726493,
                0.006566997894839987,
                0.0013525496335415846,
                0.0017448900518076918,
                -0.002600259742264852,
                -0.1760329976469495,
                -0.03731638513422097,
                0.07210830607474776,
                0.037613991112489906,
                -0.2451733731176981,
                0.04607039414895165,
                -0.07278203495429819,
                -0.036036167209394086,
                -0.12073579946507224,
                -0.06150594826555345,
                0.03315815330596245,
                0.005373868810927856,
                -0.1577826705339391,
                -0.026212672373064853,
                -0.060107405565223544,
                -0.047000437491537435,
                -0.12187446335182327,
                -0.06155978652023824,
                -0.013020471993734328,
                -0.02526607234504504,
                0.037345816879643376,
                0.0008355181859353733,
                0.02395481291541642,
                0.0013391095771785513,
                0.022928523769576888,
                0.0022829821924746124,
                -0.010169853534204831,
                0.002292106687630082,
                0.0018496431236988316,
                0.0012029556110869338,
                -0.01711919977699212,
                0.0014556361473676998,
                0.04680325399449043,
                0.00025075356458496704,
                0.0387924767627783,
                0.0006093781092767172,
                0.014871008748384158,
                0.0019857588947792986,
                0.013301768920115873,
                0.002035201706034617,
                0.017266476642760712,
                0.0018449426937164248,
                0.009228027237136052,
                0.002009248572308934,
                0.008352530183135315,
                0.00208826323410595,
                0.009599193964299358,
                0.0036415681796708958,
                0.011704229485380009,
                0.0013727830877140698,
                -0.030156418261143684,
                0.0008327189498676211,
                -0.01947115847232143,
                0.000397405098913633,
                0.021213641162230405,
                0.00076063026198292,
                0.018786960533137338,
                0.0008757925416967542,
                0.05440978489519052,
                0.007247383182102864,
                0.0015194025670034372,
                0.0007143500327980977,
                0.0031986598850619573,
                0.0009530049617938728,
                0.015370577877078259,
                -0.0017448731091360158,
                -0.012699980505686903,
                -0.0010555355296131956,
                -0.01486254109227738,
                -0.0010797643870241146,
                -0.000006876609968171716,
                0.0012302117650859954,
                0.0011370265760601368,
                0.0003598406474348995,
                0.0014644242337718278,
                0.0004148395956748557,
                0.001067887653169647,
                0.0003410867723633274,
                -0.03174530628158352,
                -0.007177987271424715,
                -0.059151191004822294,
                -0.007541870593793512,
                -0.028199248824896522,
                -0.0036658607279723017,
                -0.01676003967480752,
                -0.007321743684363668,
                -0.027592009285891825,
                -0.007957728985430106,
                -0.018207249113953917,
                -0.006782992665080284
            ]
        },
        {
            'energy': -0.6678612307860892,
            'occupancy': 2,
            'alpha': [
                0.08251621425931929,
                0.09083753182092244,
                -0.03525026230188358,
                0.06881499472833363,
                0.006961308857159888,
                0.0027200151996851596,
                0.017496753768222916,
                -0.01595795076838916,
                -0.005585776764509878,
                -0.006237954251284059,
                0.004501364068438467,
                -0.005558358102437927,
                -0.0022286326998236113,
                0.01332181334291151,
                0.0157645849897449,
                -0.004150341023750183,
                -0.008412507379220866,
                -0.0032558278452672193,
                0.009798431472428822,
                0.01734709385707423,
                -0.0024516660852081282,
                -0.0004545268117555611,
                -0.010056949442347064,
                -0.004662124214995886,
                -0.03673074072002406,
                -0.02971296830518448,
                0.023476781192169196,
                -0.05731604914347647,
                -0.016919700579586108,
                -0.019795667611659525,
                -0.013972745610349899,
                -0.026866745093531805,
                0.18490220659292847,
                -0.02896812666305353,
                0.04415816471776934,
                -0.09214182603492323,
                -0.0056993936080963065,
                -0.006059493901286077,
                0.012894858557097823,
                -0.021511116967541995,
                0.019478634101612068,
                0.03796260140980685,
                -0.03328553036936843,
                0.06281044094202,
                0.3275325304981474,
                -0.018815606504668014,
                -0.02379807122102711,
                0.0051679786022399065,
                -0.0035278782592241334,
                -0.008755968440604401,
                -0.0038114637983360814,
                -0.004923393934470091,
                0.04366713167403527,
                0.0107382471665146,
                0.03544596662005245,
                -0.04719278297063172,
                -0.01738102458768229,
                0.007431336324315227,
                -0.0020408571005125727,
                0.005802330073479273,
                -0.019062906389628764,
                0.005278127844663977,
                -0.008021159777431763,
                -0.005144711287358649,
                0.01798023469766129,
                0.0033515288420001093,
                -0.006278342626787383,
                -0.0016861211139274945,
                0.21105466832984573,
                0.015994239058589394,
                -0.027978617747241422,
                0.004789499699913965,
                0.18978333093104624,
                0.016152378727175377,
                0.041593010305547316,
                0.06017892697099916,
                0.14030135640926053,
                0.04350660916275027,
                -0.05949591200878067,
                -0.004211878449923941,
                -0.0068516919328822975,
                0.004188417984231935,
                -0.0011089587760814217,
                0.0032374539127904595,
                0.011291275135371521,
                -0.0059267672342200066,
                0.010423109767861543,
                0.00013259037809839236,
                -0.002907903867430603,
                0.026862697222215584,
                0.031355988650995655,
                -0.004246539277079079,
                -0.01599242793143962,
                -0.003167360881784246,
                0.004742477443061899,
                -0.0010617686822989786,
                0.1659677275340279,
                -0.04014344135055912,
                0.03984671496267585,
                -0.004679140810689168,
                0.06900237169878112,
                -0.036093059516900665,
                -0.029845332178778425,
                -0.0649138106004492,
                -0.0032172679791905054,
                0.0005853629101028747,
                0.0010322848074701164,
                0.001689293564277658,
                -0.0027365791164969734,
                0.0016574181636708758,
                -0.0015210277329561156,
                0.000036143839426342316,
                -0.014950618441417334,
                -0.04235333876119858,
                -0.020729299970170555,
                -0.0658721867243011,
                -0.12218381009123248,
                -0.047313372418528836,
                0.037425186797339444,
                -0.017323841343109637,
                -0.0017563078214427844,
                -0.00024893302911471033,
                0.00029034921866732385,
                0.0010060125238900027,
                -0.0016731895377485448,
                0.00022485990091936854,
                -0.0010225961234700458,
                0.00011874088513435568,
                -0.17337395355403384,
                0.02721776886813252,
                -0.03326169689933057,
                -0.00008876251729393516,
                0.11923777149671755,
                -0.036135821200167624,
                -0.023368205080128046,
                -0.02818333919406166,
                0.00004170419037969111,
                -0.0007794681540265336,
                -0.015801592030025895,
                -0.00491358077978361,
                -0.0016657303256342468,
                -0.00025020466195453987,
                -0.0005012937517753435,
                0.000696803503423665,
                0.08129004102357988,
                0.0060086158379607756,
                -0.036451002937861784,
                -0.023353610225319576,
                0.12195375379356749,
                -0.032222009428796966,
                0.028586547325597213,
                0.00961898995388663,
                0.07303274798405231,
                0.03132897192903462,
                -0.020405950121598623,
                -0.005227160495528007,
                0.09645978768575604,
                0.011367806896280058,
                0.03306141949605426,
                0.024881363362806903,
                0.0777094230920897,
                0.03529294703870235,
                0.007007197508692587,
                0.014113658018565333,
                -0.0077041118820603055,
                0.003209455423405901,
                0.017336225565270272,
                0.004157943501371652,
                0.11800004761900101,
                0.008348304194223471,
                0.008779701569509914,
                0.0033957162000763878,
                0.0011102018478696255,
                0.0021230539069370473,
                -0.008978331384843856,
                0.000032433017239520114,
                0.007041395001161335,
                -0.00007630397315312327,
                0.007527799294135696,
                -0.000046759031690515755,
                0.06507749869799047,
                0.00754722115349555,
                0.06090950864026206,
                0.008440340014004614,
                0.06336057134002164,
                0.009047453506207092,
                0.04372925931161572,
                0.008607549186938075,
                0.04159200498129052,
                0.008072897583386909,
                0.042835352311445515,
                0.009519968508852034,
                0.0040294348322631734,
                0.0002656800265637651,
                -0.006783266316727413,
                0.0001451732072868778,
                -0.004465111146429708,
                0.0000520414008615484,
                0.057728952005525705,
                0.0019741052296790977,
                0.021125096064463906,
                0.0007125877378797386,
                0.01010373250818467,
                0.0009915806783558495,
                -0.0005653720138271351,
                0.00018920934338231824,
                -0.00015163851125579787,
                0.00040027586118836423,
                -0.0032061639936615564,
                0.002673130827662936,
                -0.004061612522834352,
                -0.001212607169677444,
                -0.043316500840846754,
                -0.0023881137287748485,
                -0.0011135825535535623,
                0.00001194766442277384,
                -0.00022837723904321612,
                -0.00010120004936617228,
                -0.00019586009270585028,
                -0.00009130843320341775,
                -0.0002606850502525823,
                -0.00008792300839217245,
                0.009580650331349338,
                0.004572096621723694,
                0.02829242802627696,
                0.0038620887062773427,
                -0.005609487838068359,
                -0.0007082160342453241,
                0.01172408252104132,
                0.003751216442336819,
                0.01899723665395704,
                0.004198534899203635,
                0.013352185488316883,
                0.0038722541932597987
            ]
        },
        {
            'energy': -0.6672555720527176,
            'occupancy': 2,
            'alpha': [
                0.004414359930597255,
                -0.016728275545205586,
                0.07248345046774105,
                0.04886659767392906,
                0.000906939455795347,
                0.002986755915438037,
                0.007212327349758041,
                -0.005836910400661129,
                -0.003081707666839245,
                -0.0029764846860131982,
                0.0032672817519764333,
                -0.007281792515676134,
                -0.002986765663840196,
                0.004601784755849724,
                0.0014824926912539941,
                0.0022823681636589066,
                -0.006519621982529005,
                -0.0018428049743009463,
                0.007276213084728905,
                0.013540320243505462,
                -0.0019048662015988046,
                0.0002648606734849595,
                -0.007837107202350485,
                -0.003626348050211522,
                -0.005536024286626394,
                0.00299426923989503,
                0.021549388571612274,
                -0.012130277775183688,
                -0.004128646869561371,
                -0.0026010080954707716,
                -0.0034705285101837,
                -0.003255625725342614,
                0.024264956594061925,
                -0.003581604402795819,
                0.011692863083389475,
                -0.01576846116181435,
                0.02418712144557586,
                -0.005336571705059898,
                0.008728019195030468,
                -0.00039560439514769834,
                0.0018795064965241583,
                -0.014946711072364895,
                0.008967803788138476,
                0.030011632820808095,
                0.05620978041742746,
                -0.0018794902815508956,
                -0.0021216046530676777,
                0.0000852937057963503,
                -0.007103571826573858,
                -0.006285955530306392,
                0.005289810647760817,
                0.0014412948154067958,
                0.015128715583394407,
                -0.0028533695853797674,
                -0.0010056539621665236,
                0.005216218581570707,
                0.05044809644296108,
                -0.017309418638509568,
                -0.017339496942803137,
                0.031296843553992704,
                -0.007941814570526715,
                0.00555777502225209,
                -0.0021177055640608663,
                -0.0026042048685439626,
                0.014736718008991387,
                0.003685245467300174,
                -0.002956378652746937,
                -0.0006622574070118987,
                0.017263259485428242,
                -0.03353636813465231,
                0.10030102833475553,
                0.06499100475039055,
                0.03192038777825559,
                0.002988654817653483,
                0.007500936387821508,
                0.009814418867710359,
                0.02474787920792384,
                0.007950191328345553,
                -0.009977455086478312,
                -0.0008597211186406935,
                0.16609201267920778,
                -0.015222928803113019,
                -0.02210969485874242,
                0.028996280959056625,
                0.008208174263657468,
                -0.001728713490712834,
                0.008752040566519384,
                0.00017360345824761256,
                0.0037913687062994896,
                0.008467134828497126,
                0.003441419011326875,
                0.005399879015158492,
                -0.01164966336339824,
                -0.001570311873412123,
                0.004133581213510588,
                -0.0004933140931581661,
                -0.24012746135365395,
                -0.058002386289959795,
                0.03327522430595946,
                -0.03123264402587695,
                0.2534139878676184,
                0.03944629009061836,
                0.002675871582691801,
                0.048672997244025,
                0.12738680167584174,
                0.008173521708699583,
                -0.05041017357499881,
                -0.017032541752785974,
                0.13443385480379402,
                -0.01907913137386478,
                0.03476499531165405,
                0.03760457597935596,
                -0.2866203534166458,
                0.02615532597547922,
                0.004525312218884416,
                0.03400859833521464,
                0.27809114040676947,
                -0.03883865432486085,
                0.023327627127880703,
                -0.021220695527701793,
                0.10401752723797408,
                0.021356582864159892,
                -0.018266905264351763,
                -0.04163977466327179,
                0.11116980977200569,
                0.0021819513533387143,
                0.05116965545781592,
                -0.0017388629709645031,
                -0.009374067316499245,
                -0.0429314738068447,
                0.15067917849383222,
                0.09248260083347486,
                0.02498278317361245,
                -0.00900209421583391,
                -0.0059912428502393944,
                -0.006550590197881829,
                -0.000026014118292212697,
                0.00017716652106145595,
                -0.012175302796381385,
                -0.0036525806182180617,
                0.10201001586174073,
                0.019641937736913598,
                0.02583676431611161,
                -0.036319483521499406,
                0.01790880545750792,
                0.0006232024104074551,
                -0.008398408089404483,
                -0.005452000247817613,
                0.02779654483568741,
                -0.00779942943275017,
                0.006021096132159523,
                0.001846678940771896,
                0.017242516434207808,
                0.007097609074879706,
                -0.004885923328168283,
                -0.0013361474657975136,
                0.022934109695824958,
                0.0024876917448532956,
                0.007665750758585795,
                0.0057501441903834195,
                0.01861664571855586,
                0.008264225048726438,
                0.0015982202209291383,
                0.0032864933478150547,
                0.011437940716970277,
                0.0010397811990217145,
                0.015160294038438951,
                0.0007654988594375953,
                0.02225758495694933,
                0.0015459394155941401,
                -0.0014013223250569052,
                0.0004726376645135243,
                -0.009557206587823962,
                -0.0014293308141916483,
                -0.0026148267575929664,
                0.00012886457448382847,
                0.006680629678672016,
                -0.000014795717042905061,
                0.00512796163311885,
                0.00004904234958030183,
                0.010711455547425464,
                0.001204839995549372,
                0.010548687993249149,
                0.0014179183342289106,
                0.010309537785391667,
                0.0014746842236399594,
                0.007908883261036512,
                0.0015048574364993743,
                0.0075507998244783775,
                0.0014628375051384073,
                0.007178136625499064,
                0.0016253030941795778,
                0.0004388991358621599,
                -0.0002287129884761077,
                -0.004400049718753104,
                0.00006221546035497963,
                -0.0036004294802840543,
                0.0000781593228920948,
                -0.08944455747955604,
                -0.002955514742215116,
                0.0920637976200906,
                0.004053473820576757,
                0.004328806860891854,
                0.0006802216960701183,
                0.026652970437100385,
                0.006718031588851482,
                0.02869765487276772,
                0.004737575044600994,
                -0.00006249313238466584,
                0.0008075571628718184,
                -0.10422958979136716,
                -0.0030905712975131425,
                0.1022994020502597,
                0.0028505628822859505,
                -0.002848827264749364,
                -0.0008991530420444485,
                0.018420077180855105,
                0.005092989860279129,
                0.020862410547579133,
                0.005047015577137323,
                0.018248565813908754,
                0.0047802221862712916,
                0.0017163286120409611,
                0.0010960972202385963,
                0.006427651442714785,
                0.00087397358746508,
                -0.004178517361980224,
                -0.000519436562366867,
                0.002839666693490892,
                0.0008548622958640178,
                0.0046236826829323075,
                0.0009685239707179418,
                0.0032869852655556405,
                0.0009052901431896634
            ]
        },
        {
            'energy': -0.6672361015445776,
            'occupancy': 2,
            'alpha': [
                -0.020657152656633822,
                -0.00959293426057311,
                -0.03721892978492163,
                -0.04511623559920296,
                0.012140003416655018,
                0.011151603236383971,
                0.035600337569855464,
                -0.02663255582712121,
                -0.011355118967311957,
                -0.01174658287846736,
                0.007324319255781584,
                -0.010385836098253479,
                0.000039875627679930926,
                0.0012573611196381377,
                -0.0018251951655286938,
                0.005363697331478612,
                -0.013757829295615006,
                -0.005606682566978654,
                0.015620071081373199,
                0.0285230129477884,
                -0.004235766001320369,
                -0.0009853778056307066,
                -0.016443513632188562,
                -0.007734265191700528,
                0.004260407920125033,
                0.015514924994271168,
                0.008663401802047742,
                -0.01969641550167836,
                -0.0023932949611499515,
                -0.0021081437305304103,
                -0.003943291304276047,
                0.0005396296739255699,
                -0.015238674550964178,
                0.00819643605286697,
                -0.0006869816784122836,
                0.002101146342295928,
                0.035383740613842515,
                -0.00594655289524203,
                -0.004608773739622138,
                -0.0030399943715112123,
                -0.014746168396419564,
                -0.027419807918905838,
                -0.023633871307955044,
                -0.004910537165121723,
                -0.015769463973975797,
                0.004508275746540065,
                0.0021668172503472452,
                -0.0008013551367380863,
                0.009647064891242976,
                -0.014902065044953906,
                -0.005558123632637035,
                0.010352027043599558,
                0.009297660623531153,
                -0.004442353600765655,
                -0.015797567335150805,
                0.02245947283661169,
                0.08798275168045847,
                -0.0302489225587306,
                -0.0403133946740037,
                0.04285551310194921,
                -0.030162370338882142,
                0.010215734157686876,
                -0.013978120326535214,
                -0.0012381221963511614,
                0.02699851971136311,
                0.006999059311093402,
                -0.011177464001606472,
                -0.0012059837242032172,
                -0.05724141728554214,
                0.009898692228859007,
                -0.062235583293423595,
                -0.035058334914833345,
                -0.010340416340533365,
                0.00009576226258036771,
                -0.0018830636365704636,
                -0.0033853703130452594,
                -0.008123516077364711,
                -0.0016297463525617503,
                0.00357233319353132,
                -0.00003995511843017115,
                0.28350044890869847,
                -0.026569828143505905,
                -0.04455950427895127,
                0.045432133012845564,
                0.020315517294532577,
                -0.009939116061602997,
                0.016770685529156525,
                0.0005947750037247514,
                0.002184324683406713,
                0.002786500812554906,
                -0.002912088475417975,
                0.010987161513537975,
                -0.025878125193163116,
                -0.005547816375507512,
                0.007981130854288553,
                -0.0013212989390754169,
                0.11318183755015924,
                0.04227150467416953,
                -0.031119905087448343,
                0.021221218613004904,
                -0.1717832863644005,
                -0.018892799819263957,
                0.003785433892146356,
                -0.014541405470699974,
                0.21131016176667194,
                0.011745286099492257,
                -0.08782701448846879,
                -0.028253969973569174,
                0.23760365556939345,
                -0.03166477006785319,
                0.05983412290374663,
                0.06338616746660397,
                0.18028260356397113,
                -0.0074127973307078305,
                0.001131464823082628,
                -0.006567501187642825,
                -0.14580430485189802,
                0.03391598234140144,
                -0.02271135285503543,
                0.01744145337764688,
                0.17664140488967073,
                0.035869392263242865,
                -0.03255968683135285,
                -0.07059250965280232,
                0.1934634387799731,
                0.00447378306848997,
                0.08843818859102928,
                -0.004225912832535955,
                0.04310504581171699,
                0.020582213333004386,
                -0.08619553333692058,
                -0.05676910464026943,
                0.014977989480708605,
                -0.005539067238444446,
                -0.004002913084664867,
                -0.003398708965157842,
                -0.000007831792162370358,
                -0.0015997518272858973,
                -0.025851384843764272,
                -0.007976651211776402,
                0.17546548885910873,
                0.03387617802369775,
                0.043796088980520516,
                -0.06277623844189106,
                0.010747919314469764,
                0.0003219683472008264,
                -0.0051074638714359005,
                -0.003113948567844403,
                0.01672687876234596,
                -0.004703976952301237,
                0.003529794040428666,
                0.001223656084664651,
                0.010350499430861719,
                0.004251056429445116,
                -0.0029472695197626467,
                -0.0007760632424359213,
                0.013786239388324297,
                0.0014952422246888376,
                0.004587092934560961,
                0.003477428798676459,
                0.01117933926792266,
                0.004961029016187909,
                0.000949466562440266,
                0.0019824156360381214,
                0.007091155316391077,
                -0.0008496084407663964,
                0.011952497661899696,
                -0.00031482114123489397,
                -0.002394412473786807,
                -0.00030627638422555563,
                0.004789733551094102,
                0.0005254345673892448,
                0.010018030416693764,
                0.0008323322321610177,
                -0.01048803623108984,
                0.00043641471581657543,
                0.010943675207945704,
                0.00007270050397570263,
                0.009910732639028133,
                0.0002157179042091018,
                -0.0032546192581255325,
                -0.0003620326887019329,
                -0.0030885450066583716,
                -0.00042545218113522064,
                -0.004282338354019073,
                -0.000493021876666042,
                -0.002322216001106786,
                -0.00043414392447477257,
                -0.0023502175912540764,
                -0.00041403412359756683,
                -0.003155927816330374,
                -0.0006066595812356882,
                0.007572308978513792,
                0.0006740099832301673,
                -0.011176268980037318,
                0.0002573022524111536,
                -0.0073649360577352834,
                0.00010659316586653311,
                0.044262113784361026,
                0.0022635892625938207,
                -0.06066534325764484,
                -0.001897201214219727,
                0.020967488811979677,
                0.0025535143949759215,
                0.040958344990932316,
                0.009294042465783579,
                0.05391410647637892,
                0.009796787811364354,
                0.0003658544843974046,
                0.0006756414590477881,
                0.06540110048256773,
                0.0021513741851414523,
                -0.05380969442947892,
                -0.0012833272087803532,
                -0.0021246833155688176,
                0.0005636388168079181,
                0.031009416244629773,
                0.008579615121223835,
                0.036672093986837725,
                0.008828390755888288,
                0.031427369294296514,
                0.008222288413669959,
                0.0010882077690260294,
                0.0006243998932306851,
                0.003886838389146139,
                0.0005078364402163781,
                -0.00896885463369305,
                -0.0011270496470652278,
                0.0017051776489569808,
                0.00051656515160953,
                0.0027814303537166385,
                0.0005821991438768248,
                0.0019741870118996064,
                0.0005442826774253142
            ]
        },
        {
            'energy': -0.6628280270094659,
            'occupancy': 2,
            'alpha': [
                0.013702739079736619,
                0.01583689767495341,
                -0.007435014636221259,
                0.011054592532634038,
                -0.08333420713198116,
                -0.010671938771347663,
                -0.18882127525619521,
                0.11269188677687025,
                0.06681572170844784,
                0.06643279116885956,
                -0.002985443054404594,
                0.10001680376786315,
                0.08931847363488028,
                -0.07105618004749215,
                0.016357688543096438,
                -0.014014034894753377,
                0.07231586293094418,
                0.03557868222543111,
                -0.06682364029077177,
                -0.1557816635262701,
                0.03430698822943009,
                0.010287041473822025,
                0.08279965340389209,
                0.04524737130867409,
                0.05398317474021611,
                -0.06413540406677677,
                0.003088738986737005,
                -0.00921396773647957,
                0.03049731872586277,
                -0.05450303985786303,
                -0.03182594469862552,
                -0.03955259990152435,
                0.03190225004606398,
                0.07358418679625572,
                0.045950479497246205,
                -0.03410014194422857,
                -0.16649810346442992,
                -0.049763514110299285,
                0.02482773322558807,
                0.008751934070819825,
                -0.005748866441190293,
                0.03264067525449022,
                0.01651445491510258,
                -0.005045472747922685,
                0.10430115242643849,
                0.0065957784543231,
                0.0006543449493691494,
                -0.0030202450299350652,
                -0.1337263378860331,
                0.060905449864172755,
                0.017758742317217215,
                -0.05795461010185214,
                -0.21249890358279278,
                0.04916017909812296,
                0.02716940921144942,
                -0.013672982420334781,
                -0.12548510953233835,
                0.03825615763650691,
                -0.008866286447442131,
                0.03549935745388254,
                0.15372933408090272,
                0.007107608712513555,
                0.06451175934600203,
                -0.03148688340313259,
                -0.04617365671886352,
                -0.03325886584030573,
                0.0782598049421355,
                -0.0006125191052996394,
                0.03093694761859114,
                0.00494616218961036,
                -0.002925151327497268,
                0.004727907910896823,
                0.057637876817020865,
                0.007561798778480905,
                0.015244654999329445,
                0.014770121722185956,
                0.04425591796293004,
                0.015893323335853558,
                -0.015505655783436132,
                -0.0035531943648116097,
                -0.011804857920573014,
                -0.013616709283321411,
                -0.03278072615383287,
                0.04646499213743583,
                -0.13184421485038483,
                0.036295801279593705,
                -0.0536727810355094,
                -0.024463637554561747,
                -0.14546014637282909,
                -0.11327834429319096,
                0.012030814325684553,
                -0.03259220088316678,
                0.13173451562761665,
                0.03405734259223269,
                -0.04398663511451596,
                -0.011603278488811609,
                0.024958083496151178,
                -0.004303558590356434,
                0.005222677281648703,
                0.004291580458388783,
                0.01331821289734134,
                -0.005700881084109245,
                -0.0058614615849666915,
                -0.009333813730095656,
                0.03745580797136244,
                -0.006981143001567766,
                -0.024651155500173952,
                0.016876142400804445,
                0.04147708866262895,
                -0.012571899456059701,
                -0.008833164052760032,
                0.028552771856146433,
                0.0031829230129837155,
                -0.007185387792795434,
                -0.0029406229058284274,
                -0.009663017406896367,
                -0.019778509276192954,
                -0.008988971754074744,
                0.005540960193275081,
                -0.0040669448231449795,
                0.06426494871758831,
                0.008789208905352638,
                -0.014413336649412078,
                -0.016655375872788942,
                0.06904172600903694,
                -0.001546875289462956,
                0.02325784792916482,
                0.005062729735252932,
                -0.02628638134583083,
                0.003633884075812393,
                -0.007543365747507539,
                -0.0023697721151025404,
                -0.031812372083969025,
                0.07061115958144272,
                0.03309475086550289,
                0.04017248215184867,
                0.0014947502010991501,
                0.01512074809678201,
                0.13410694125382192,
                0.039137709117717426,
                0.06918347820505931,
                0.010547687814133122,
                0.013321315871332616,
                -0.019121098045379835,
                -0.06899716829203863,
                0.02244389215549057,
                0.03815580509048086,
                0.03116304379402366,
                -0.11498939896221148,
                0.05579198027268204,
                -0.008851137246961793,
                0.00899340872044264,
                -0.10729187975331815,
                -0.032291505228333746,
                0.03124266121761222,
                0.011978924684639403,
                -0.14152054632327846,
                -0.0036483491307217676,
                -0.04041594193897093,
                -0.027848341909080757,
                -0.12496452231493303,
                -0.04637919189784644,
                -0.00808990300304951,
                -0.01790018328895847,
                -0.07330504403924329,
                -0.002049767034325328,
                -0.04511456497805035,
                -0.001285404856733244,
                0.041399194639664336,
                -0.0005196713069669028,
                -0.04557885387045377,
                -0.002634185181859561,
                -0.07726391160476564,
                -0.0022763223563420187,
                0.054842818652160646,
                -0.001291297582996442,
                -0.011424122875633793,
                -0.00006983520490379875,
                -0.014064565970928098,
                -0.00048055136244825263,
                0.018457397209102538,
                0.0008584945379428786,
                0.020617481920080866,
                0.002226342394594703,
                0.016132950273389485,
                0.0010425221546159448,
                0.015361429560254039,
                0.002368196125407318,
                0.013185366033331425,
                0.0014318385933924102,
                0.01087464722147141,
                0.0007153825245842746,
                -0.0558631864508691,
                -0.002534552434490403,
                0.06093677111638533,
                -0.0006675276918204827,
                0.04708307897730664,
                -0.00022692997128207144,
                0.005112195310261264,
                -0.0010969726958272035,
                0.0035496345342257677,
                -0.0006081432467479802,
                -0.09246786674532428,
                -0.009934815547432137,
                0.002981950141936325,
                0.0005955771454582849,
                0.004193864684729716,
                0.0006174220545719587,
                -0.0006248853316057953,
                -0.0016448175400096243,
                0.0010645093040772087,
                -0.00026394486759886407,
                -0.007894632384176667,
                -0.0003092209679988684,
                0.037359662728462466,
                0.0018249747493375285,
                0.01428267567207429,
                0.0023228116425323443,
                0.01611906787728915,
                0.0023315725780193716,
                0.01537749818393463,
                0.0027076212444951753,
                0.002235212249428895,
                -0.006749753567444654,
                -0.022189533438301164,
                -0.004259173908468511,
                0.03937488227361495,
                0.004439780548931766,
                -0.021112423325105708,
                -0.004255579780806594,
                -0.032943729150501005,
                -0.004797630501099549,
                -0.026264717912201595,
                -0.005074166973243747
            ]
        },
        {
            'energy': -0.6571120218841615,
            'occupancy': 2,
            'alpha': [
                0.040122638633974486,
                0.04704979524410647,
                -0.015312315597687736,
                0.03765561036336069,
                -0.07928852353008392,
                0.07242799549611612,
                -0.08166871321912521,
                0.027760984549827047,
                0.07153619274279001,
                0.06858331214804861,
                0.05996554171250767,
                0.1681197358912042,
                -0.12966392498451285,
                0.08054461959233354,
                -0.03836014038065678,
                -0.0049545847979571705,
                0.07179783924054842,
                0.04391533261628707,
                -0.04243329155844661,
                -0.16129989458321767,
                0.05936814989311902,
                0.017549260137480586,
                0.06808719062649066,
                0.055573771749835875,
                0.041671350639688014,
                0.06291343802588903,
                0.05569474231083326,
                -0.017805443111008745,
                -0.024197582192377404,
                0.10141572279149637,
                0.0847107008793799,
                0.08417744939874133,
                -0.012608609405514162,
                -0.02372107852216594,
                -0.010092669939324951,
                0.01616659751175036,
                0.040581700753076516,
                -0.05790708658664059,
                0.0227809651091386,
                0.05304423193276349,
                -0.11399687040146428,
                0.06329239815750702,
                0.029164344569773997,
                -0.005701658984158196,
                -0.1057603326585054,
                0.0033484236920758585,
                -0.002692928794914598,
                0.02677775163880853,
                -0.1469885255316395,
                0.009183640462100165,
                0.02004888455089767,
                0.006119070352049321,
                0.11431524719488337,
                -0.10102758088061717,
                -0.010055592931983045,
                -0.05172227128371713,
                -0.12003937372028882,
                -0.06092043758599376,
                0.0007172669364347853,
                -0.03148130860706419,
                0.07680855358417982,
                0.08444955347288176,
                0.026303286425696258,
                -0.04045691155881168,
                0.08467264635113715,
                -0.007650545774951382,
                0.07863579913637403,
                -0.020614051118520035,
                0.028335976117185514,
                0.04286330931853488,
                0.002776466662236595,
                0.023232519729387512,
                -0.09057348115825715,
                -0.008945559091816347,
                -0.01848613246228127,
                -0.014204086619504582,
                -0.056517077810162894,
                -0.015954030745146387,
                0.017276208781857247,
                0.008404953811363539,
                -0.05460317134359323,
                -0.029500711807690167,
                -0.023125998634686843,
                0.02269375382452172,
                -0.1523129576752654,
                0.007716468852220208,
                0.00628407433909677,
                -0.06591549605588758,
                0.19827819671658853,
                0.10633658222135613,
                -0.041540053437223744,
                -0.0027719381476947213,
                0.12766414438742252,
                0.0364028373111951,
                -0.03702532685058584,
                -0.0437776918052093,
                0.0482631591776824,
                0.0034152772111507037,
                0.008435617008297468,
                0.007058800469334273,
                0.04827005044271822,
                0.0021387310706238822,
                -0.005172603933607277,
                -0.0102834206512691,
                0.0034168312327603296,
                -0.01441103732503858,
                -0.011831658568692647,
                0.020098843276015514,
                0.006100121315025961,
                -0.013257112100788759,
                -0.018977963245548842,
                0.01704486615544506,
                -0.0006121277645010961,
                -0.01810507808969355,
                -0.00783549584235415,
                -0.028926945298825606,
                -0.02095758533919765,
                -0.028082721855451454,
                0.020270951324002827,
                -0.014466975665846761,
                0.043244096255078884,
                0.002078340961220524,
                -0.012684338440401734,
                -0.006005294511739248,
                0.04686821806806852,
                -0.004440194444762786,
                0.010782408584549595,
                0.00757303865754608,
                -0.07059158972347203,
                0.0041101729968571156,
                -0.007229899300160515,
                -0.003277258076199824,
                -0.07920573000303145,
                -0.07901038741326344,
                -0.018157441721201147,
                -0.033012789861953225,
                -0.003170651565060175,
                0.024435287713447478,
                0.12304486846690796,
                0.03325684755014598,
                0.052853063194477426,
                0.005546761087679769,
                0.00716162533254238,
                -0.010933172270617346,
                0.03746283793033198,
                -0.04697988857301459,
                -0.023335957385662673,
                -0.028068441177379545,
                0.049350807495748446,
                -0.06529711467854465,
                -0.01881400082498941,
                -0.02998240862834312,
                0.11964693256979078,
                0.021319292284992904,
                -0.03498126724846714,
                -0.01743998768847853,
                0.1469888211618548,
                -0.014798898837775618,
                0.03509346809549432,
                0.019325873277515348,
                0.15020570484470622,
                0.042575753380693054,
                0.007307927343236237,
                0.016347253785917674,
                0.028766149066448185,
                -0.001808205212539291,
                0.014681827780319246,
                -0.0013131026667927903,
                -0.045696423222029686,
                -0.002676245791116951,
                -0.06707860288572647,
                -0.0014602143870586415,
                -0.07022150460295781,
                -0.0016069646933458848,
                0.04563424668355476,
                0.0009524085379599346,
                0.05803865438205885,
                0.0008531138675823292,
                0.040009357061763874,
                0.001217966350366947,
                -0.03231514091976877,
                -0.002738092613077444,
                -0.0353157176195006,
                -0.0027299063616968875,
                -0.027296870494878545,
                -0.0020524485602147553,
                -0.02233897605736994,
                -0.0025029337107228627,
                -0.015203602634921544,
                -0.0018878658509789519,
                -0.0156423247938779,
                -0.0006828118407279612,
                -0.07580844370515645,
                -0.0013101390248833624,
                0.0644992975848313,
                0.0006605002651359061,
                0.06562880264446817,
                0.00022220674124152873,
                0.011193136118359672,
                -0.001007623636777107,
                0.015050384112943505,
                -0.00014496136113622385,
                -0.015074242053929337,
                0.0011566120044821794,
                -0.0038521441254705173,
                0.00003645373903861793,
                -0.0030653601305191043,
                0.00011816400252205528,
                -0.0029015696657151324,
                -0.0007003400134363739,
                -0.00010233316203625384,
                -0.0008484235785518365,
                -0.008941653771433026,
                -0.0006346089045812218,
                0.07812918566894828,
                0.00775447345262386,
                0.011552688942415562,
                0.0011313225589607504,
                0.013048125092808064,
                0.0011460302316665426,
                0.014142305576242336,
                0.0015914396688564794,
                -0.007805899123148042,
                0.0063744347263550855,
                0.0003456760019167383,
                0.0031405473575111826,
                0.02673738663087251,
                0.0018252777147434805,
                0.02847256137884634,
                0.0036993245101123594,
                0.03965752585679532,
                0.0037420148937941634,
                0.03784798431400331,
                0.004763056929721537
            ]
        },
        {
            'energy': -0.653591278201395,
            'occupancy': 2,
            'alpha': [
                0.08326988122736446,
                0.09638430965589141,
                -0.021862104838227273,
                0.08729014799312516,
                0.026925237987642604,
                -0.09208818131265639,
                -0.06826708981303674,
                0.07678724841115535,
                -0.05827666516210558,
                -0.04386472290721173,
                -0.09511796157591122,
                -0.2207639829653449,
                -0.007355892454533152,
                0.005173785703909957,
                0.0003206735177471336,
                -0.006796070341460305,
                -0.06931165011596631,
                -0.031064193425901485,
                0.02180738636460072,
                0.15871379492891488,
                -0.07519038176809863,
                -0.008614044559139823,
                -0.05234313854594285,
                -0.061616806400830254,
                0.028018467375823232,
                -0.09805618913733836,
                0.005598429414498233,
                -0.06365244936264843,
                0.0012698737773090122,
                0.0033227458434532315,
                0.0073908073849825815,
                0.003171385931465964,
                0.11133267901248373,
                0.025579478386588434,
                -0.01657160604486462,
                0.04372049489722417,
                -0.10351209750955566,
                -0.006029777897473781,
                0.0024591603265151155,
                -0.0347367559602061,
                -0.1364267282487451,
                0.032739483920592324,
                0.02591629111194005,
                -0.02993779628216161,
                -0.10670226544938867,
                0.021286629388636784,
                -0.01534720366311475,
                0.06085404745312188,
                0.011131726620953098,
                0.02651393102085341,
                0.00967461561864588,
                -0.038101476916141824,
                0.018128229838257015,
                0.013667089098347386,
                0.03817695890973632,
                -0.056864530412424334,
                -0.19231891615646785,
                -0.011715622443604865,
                0.03182761223369763,
                -0.05867724190752613,
                0.024853285483669846,
                -0.07844822894500454,
                0.045175846517829764,
                0.01748327898962633,
                -0.12872683095434198,
                -0.00007228655555899554,
                -0.03929970727282257,
                0.03488938228973486,
                0.03574421473459639,
                0.07149392523917902,
                -0.014583417768894155,
                0.054625920679775446,
                -0.1316527338025286,
                -0.004332221466984543,
                -0.024113182614819675,
                -0.0123952143876666,
                -0.08115743598062765,
                -0.01645380120791437,
                0.020511925740449962,
                0.015234370283265153,
                -0.15677016733976945,
                -0.038296533362437095,
                -0.04458602687053276,
                0.05496855720629971,
                0.13613587104322827,
                0.0384269545336154,
                -0.032992813143013666,
                0.08781111709905123,
                0.011294849827162138,
                0.007359249278791867,
                0.004739456830280321,
                -0.013035101018519141,
                -0.1123224140246812,
                -0.020469922213454034,
                0.03144221647021208,
                0.0635725335963425,
                0.10240838800134777,
                0.004921885308645321,
                0.008434845971799117,
                0.011673081628360222,
                0.10068400949868093,
                0.013215113015757413,
                -0.01154366562930294,
                0.002763191316270305,
                -0.010494574280815155,
                -0.032812658760248525,
                -0.023909159757940123,
                0.058399819208209275,
                -0.007590029777649942,
                -0.02582954630088592,
                -0.05538052941604375,
                0.04341171517796006,
                -0.010191113504299448,
                -0.04331746674280587,
                -0.01562548455935815,
                -0.0627231119049962,
                -0.0014530342891493557,
                -0.058129721613224786,
                0.040843391679952455,
                -0.02704415140445734,
                0.1093985882344209,
                0.002787179082916496,
                -0.037332235558667395,
                -0.007875520468003945,
                0.11747844401226556,
                -0.014121759292192431,
                0.021645197948765103,
                0.027453705062387417,
                -0.1367316011448773,
                -0.003006566974075993,
                0.003801410260680363,
                0.00027806269969444435,
                -0.004007444935725456,
                -0.003235880132644297,
                0.0010322116691810085,
                -0.00025011975411034923,
                0.009388138712917306,
                -0.013102748562116526,
                -0.10637010983687452,
                -0.02494342335047745,
                0.14475059456471787,
                0.012882445119262814,
                0.01578676229265051,
                -0.024208852273209465,
                0.00230387163071032,
                -0.0019504868213150684,
                -0.0007417693015397597,
                -0.0010239542294468507,
                -0.0010078266096878047,
                -0.0028812760863853467,
                -0.0010861776706750249,
                -0.0014167000973711807,
                0.005689095726745225,
                0.000832374938246354,
                -0.0014317964159710314,
                -0.0007192825634675332,
                0.005105620277169536,
                -0.0014895941991150538,
                0.0012809458477259226,
                0.00046610214775338226,
                0.006699843475200138,
                0.0014418449257993101,
                0.0004964170561885253,
                0.0007241261550216614,
                -0.06080252455480206,
                -0.0002370745959230198,
                -0.028131485537369917,
                -0.004076271774979005,
                -0.045827091302622205,
                -0.0038210651986518734,
                0.009957688686890393,
                -0.003698260002997162,
                -0.007844144962944935,
                -0.00009230730132234274,
                -0.0074958500002063845,
                -0.001535686081361674,
                -0.07168462011572468,
                -0.002263663843315081,
                -0.06786371344373185,
                -0.0026001035278639894,
                -0.0438512826209698,
                -0.002680120949645964,
                -0.05394909230330614,
                -0.0031138128868180323,
                -0.04629172061623157,
                -0.0030355866822548835,
                -0.03464659905997908,
                -0.0030892165967545434,
                -0.020976214563935697,
                -0.0027220932281861003,
                -0.02479782368047212,
                -0.003124026294849668,
                0.0549733851659822,
                -0.00010417308652266624,
                -0.05162648627656317,
                -0.002153655485839069,
                -0.07735648408910206,
                -0.00016944041681082794,
                0.031649320906739935,
                -0.000060678571412006705,
                0.02964079239594848,
                -0.0003543749154081138,
                -0.06428203389155919,
                -0.010407667237716854,
                -0.013849358396213377,
                -0.0002218020279442285,
                -0.014052269255682568,
                -0.000002651828097840838,
                -0.002155128520362541,
                -0.001143768430586119,
                -0.0056511612673072805,
                -0.0012065573840967798,
                -0.001470291741787483,
                -0.0014146288758046229,
                -0.11089925430364513,
                -0.01318007796458349,
                0.031544997716692634,
                0.002455410497000403,
                0.035164609684454916,
                0.0024317910324566623,
                0.042267792574671295,
                0.0036566131129689614,
                -0.000015487208457648745,
                0.00023599366885777625,
                -0.0013334630678121893,
                0.000028998042803965775,
                -0.015614859105777359,
                0.00032949874727885957,
                0.0014894285327321354,
                0.00016309898819930204,
                0.0014277361031350493,
                0.00011636290274380844,
                0.0018530374881680805,
                0.0001807118574545601
            ]
        },
        {
            'energy': -0.6505158750742746,
            'occupancy': 2,
            'alpha': [
                -0.06807520655114366,
                -0.07763748682266153,
                0.006126789751325894,
                -0.08082328289292576,
                -0.0612881603363992,
                -0.04100087183227408,
                -0.19830691590536592,
                0.1789604043815469,
                -0.019552316411122553,
                0.023621072139376177,
                -0.09103146879346134,
                -0.2596283521946705,
                -0.05658508788083865,
                0.016843993472257703,
                -0.031104705718529625,
                -0.013820689685694101,
                -0.0642228232302591,
                0.02727254494835372,
                0.0005100778651109352,
                0.14847598635801545,
                -0.07411706132206858,
                0.03357063296100607,
                -0.04087236057854292,
                -0.057881519469249264,
                0.027155025012878274,
                0.08350243106239592,
                0.01507024186149664,
                0.09120023140482991,
                -0.0016236929273095225,
                0.05376224438102399,
                0.06447312311835429,
                0.057160448172233355,
                -0.11773745152998921,
                -0.011535308657952364,
                0.024396640814756544,
                -0.03309768624580835,
                0.024208656335013252,
                -0.037645222555466214,
                0.05588633821590624,
                0.07024808888578553,
                0.1008830832037813,
                0.034781554249016515,
                0.01824286151744952,
                0.014125064304138969,
                0.06068111602814095,
                -0.019934841400183617,
                0.018108819091493828,
                -0.04927252003309337,
                -0.21319257075480677,
                0.031667973127542465,
                0.08489472582599114,
                -0.006569623268606983,
                -0.04560671156197767,
                -0.059698100110131665,
                -0.02980907502373561,
                0.004880465275723644,
                0.01854549407452855,
                0.012420434521726578,
                -0.01686891623575418,
                0.03738430262749209,
                0.11431092459358795,
                0.0055171062460424875,
                0.13800090172187884,
                -0.008198856377465152,
                -0.08841450306790548,
                0.028437930433386497,
                0.03064526955466286,
                0.03382997659972301,
                0.00574144075027609,
                -0.05510221603886002,
                0.029555675253313575,
                -0.04509203173213763,
                0.09136144186054397,
                -0.0012233742832067256,
                0.017134010366366487,
                0.004770656120310137,
                0.06085147670277463,
                0.010000938484223556,
                -0.012564949260209509,
                -0.012150441680274965,
                0.04505713360414767,
                0.00951296843165615,
                0.008896772799826605,
                -0.00825432904949825,
                0.0751464568219942,
                0.11626502828224311,
                -0.014284376027902645,
                0.0774823893212663,
                0.08053105366805548,
                0.008060664655277593,
                -0.0431883367600433,
                -0.020212715440465646,
                -0.06958911684064936,
                0.025334066493391396,
                0.03706059586508916,
                0.06516748994713462,
                -0.08915815482973358,
                -0.006927545119290079,
                0.003356630809186474,
                -0.0014121518436373429,
                -0.07002718464866214,
                -0.022355857341787553,
                0.005226130137813974,
                -0.024333173785931868,
                0.008343610871040751,
                0.0097506735116351,
                0.00514810728896341,
                -0.01635425253083955,
                0.005296524305885389,
                0.006852288991175229,
                0.016441960518235602,
                -0.010715872475327754,
                0.017485128158275264,
                0.03974125214929681,
                0.013857093254069476,
                0.05877192075290634,
                -0.03462541622778227,
                0.0434777373901827,
                -0.03397986089718933,
                0.0160678612836636,
                -0.0296869873406218,
                0.00032110143092642135,
                0.01214594632019231,
                0.0004093113106837112,
                -0.033452776681479196,
                0.004911006341971861,
                -0.004885955939838395,
                -0.009302414200740546,
                0.10674304282826087,
                0.011022506337039899,
                -0.02265293114291977,
                -0.008577773374034883,
                -0.08518578855522738,
                -0.040041282936856444,
                0.011616437598295722,
                -0.0035068931595674388,
                0.011861658320979199,
                0.040166217629544476,
                -0.0844594737348709,
                -0.011631519749587411,
                -0.043554609853048654,
                -0.0032040282050439526,
                -0.003503373276196736,
                0.006148541095236253,
                0.018866364815858933,
                -0.0349383887316025,
                -0.0031265279006433954,
                -0.0116241030734784,
                -0.028464166360315693,
                -0.036795014662523676,
                -0.020911645356127596,
                -0.023961876427469907,
                0.08134298029588481,
                0.006329486170312623,
                -0.020458770959761546,
                -0.011898385933272127,
                0.06961484229673087,
                -0.026007701443729526,
                0.015755278775572965,
                0.003405027781944095,
                0.09979475925539155,
                0.01722511257666342,
                0.006748662510068094,
                0.009109824914703721,
                0.042469144350692184,
                -0.002831530138121105,
                0.026732586739373745,
                -0.0016378285097661525,
                0.025121117759745022,
                0.0009630525520086541,
                -0.10715480744020645,
                -0.0033719695950670645,
                -0.13613624475594166,
                -0.002882945967172028,
                0.058921850781097976,
                -0.0007823720438464757,
                -0.019901623772634783,
                -0.004163153781597501,
                -0.06959435071752751,
                -0.00305608579193751,
                0.027124606673958957,
                0.0008511438650458387,
                0.03908805650101724,
                0.0018992167273292626,
                0.03514961934948827,
                0.001654542374463521,
                0.02701235407674228,
                0.002134126920082445,
                0.015992121575197374,
                0.001972351825726491,
                0.01912577427681847,
                0.002886107539007521,
                -0.024293639368180797,
                -0.0017933095411732923,
                -0.006466386798961214,
                -0.0042468570811574095,
                -0.07501023493603688,
                0.0006459413054010399,
                -0.03851705745601669,
                -0.0011186585846722778,
                -0.019237071459720163,
                -0.00021493683448749402,
                -0.11677963311870175,
                -0.014495165736545051,
                0.005078782336203603,
                0.000010722822787994538,
                0.004029827856043077,
                -0.0002684100567382738,
                -0.0070462835629351815,
                -0.0005457190053940648,
                0.008043503389554355,
                0.0011630528500378877,
                -0.015868944267895025,
                0.0013644000205696649,
                -0.13633805396422258,
                -0.01881835190791086,
                -0.009080902038847745,
                -0.000584058575982693,
                -0.010672063114069688,
                -0.0006080182555352393,
                -0.013638297490494198,
                -0.0009273660402731684,
                0.002185836846758014,
                0.0025732372304946953,
                -0.019550830119182166,
                0.0009988217805338034,
                -0.0033877958513868563,
                0.002225207664115724,
                0.02344471950264791,
                0.001985808909197206,
                0.02122490866892398,
                0.001273869286843266,
                0.029869132729440733,
                0.0022993322849652565
            ]
        },
        {
            'energy': -0.6487274638736368,
            'occupancy': 2,
            'alpha': [
                0.08554134628628601,
                0.10663670776213002,
                -0.036212335489837974,
                0.086712858148383,
                -0.03948290015251012,
                -0.005992981412512666,
                -0.08767081659887725,
                0.06800760429801175,
                0.01756568002878644,
                0.041487070707760317,
                -0.00768890867838801,
                -0.07328816070945846,
                0.03894822281578211,
                -0.003998270836701575,
                0.021158555192127997,
                0.028371257390519728,
                -0.019142029386139296,
                0.0392593008201146,
                -0.0032527812788804003,
                0.043735525611193656,
                -0.0121613462395827,
                0.03303273370548487,
                -0.01725615352361979,
                -0.011457362756404669,
                -0.0031702216321496525,
                -0.024396528593013063,
                0.12023685698254909,
                -0.14392374612088696,
                -0.0013546859498985069,
                -0.04046612836557627,
                -0.06582503098252893,
                -0.043253565183703,
                0.0852675708511707,
                0.041598803908924765,
                0.022794956855427168,
                0.01762105001188386,
                0.10880078451294665,
                -0.051202868516384226,
                0.07424449435238344,
                -0.01467664480763036,
                -0.16434095892509257,
                -0.07620209265031512,
                -0.03219734660516775,
                0.04271156821301993,
                -0.048083652992767734,
                0.03903991040420313,
                0.003701261306975059,
                0.06475411016947284,
                -0.12793423754255495,
                -0.019614192459610467,
                0.06757423554388728,
                0.000026815919449260885,
                0.05042217770151409,
                0.020191410989281296,
                -0.00392104936283615,
                0.04547154926544162,
                0.1397418138106765,
                -0.08231393867851985,
                -0.04478970310004725,
                0.04670408519043961,
                0.030660337015429952,
                0.02637440843187219,
                0.06433582801478835,
                -0.025112256387528956,
                0.022381538738333803,
                0.02662901701541914,
                0.027253043186760938,
                -0.007208037766914459,
                -0.017379622707548427,
                0.053788685246722624,
                -0.018613007062742385,
                0.0840773628202849,
                -0.13609513433527906,
                0.003124659759877948,
                -0.012146969134520395,
                -0.0053157670632336,
                -0.051117929736512364,
                -0.0019368873003403676,
                0.014390398034753692,
                0.015660401455716233,
                0.21467302520330866,
                0.013882918178596689,
                0.033951864745553784,
                -0.04391218478669505,
                -0.006448083274597722,
                0.061231408636947614,
                0.02101772200421955,
                0.0013135285040636563,
                -0.05434313685840082,
                0.006266359552039472,
                0.02866292688577125,
                0.04594955153102593,
                -0.00010278412567534215,
                0.027352395343674358,
                0.021582284306878984,
                0.008971024264568684,
                0.08341556068975366,
                0.024808772805664493,
                -0.013661184507509324,
                0.03014309091429107,
                0.10411686323825806,
                0.011001656784595066,
                -0.004246504160941001,
                0.018207471294035934,
                0.0528361765672705,
                0.03865659348272161,
                0.018560261922297767,
                -0.07708690199853958,
                0.044040486875650105,
                0.024393647036326207,
                0.07599668329440383,
                -0.047053588325583436,
                0.03148029920839105,
                -0.03945998777253739,
                -0.020018861232847653,
                -0.058447686464483055,
                -0.002486754626435399,
                -0.06697321858337879,
                0.044352171830548404,
                -0.03083538047615091,
                -0.126106673301711,
                0.0034243301622389074,
                0.05652473783254041,
                -0.004566036538214679,
                -0.14014972162039688,
                0.023766508644856098,
                -0.016085934732714236,
                -0.047207884306744434,
                -0.13009110522934234,
                -0.005021182433040027,
                -0.01350532339934423,
                -0.01583635778321279,
                0.0770447980038272,
                0.035145381679091724,
                -0.022513232897319286,
                -0.002468115730078885,
                -0.00023627847070244217,
                0.04084511017372463,
                -0.024011497997054352,
                -0.00007978013749480676,
                -0.19483390981408308,
                -0.012455528263669795,
                -0.01289386831676309,
                0.02279835813555015,
                -0.027600516628161383,
                0.03155089140296496,
                0.0004773606522586269,
                0.009638591409396905,
                0.047744116193757534,
                0.030951478169613796,
                0.017832186033064003,
                0.020916020319257364,
                -0.081704482677798,
                -0.006150395873127807,
                0.017072810232313322,
                0.009837257022902892,
                -0.04914832941720099,
                0.02990399466962018,
                -0.013190112403393482,
                -0.0005227021827650407,
                -0.09129675904446603,
                -0.011762045982923436,
                -0.009339813467498856,
                -0.009292312319543142,
                0.028831638016389303,
                0.0007770626058280688,
                0.09196145940261494,
                -0.0014565851090143432,
                -0.0016950824858131073,
                -0.002047060608801925,
                -0.055107277552974475,
                -0.0020285308602886994,
                -0.09711215557234298,
                -0.0007505209140958699,
                0.01767198592746289,
                0.00003966105431336255,
                0.03134982500652698,
                -0.0017050227289442498,
                0.00006147859466575344,
                -0.0007192708234455322,
                -0.049841734743501835,
                -0.002585899217198697,
                -0.05532085357784022,
                -0.0024147918476991777,
                -0.05574923064647604,
                -0.002369236726472732,
                -0.02425859842070982,
                -0.0016723878071856014,
                -0.008316376328078797,
                -0.0010992628546253878,
                -0.020906677764668372,
                -0.002567069482118342,
                -0.047516355371702165,
                -0.0008266434847021584,
                0.0209542238724473,
                -0.0018796979173699615,
                -0.012675945172232457,
                0.000855260828192753,
                0.021479468580308112,
                0.00044749506223544007,
                0.03769119861218452,
                0.0012648842218481824,
                -0.04706964299988824,
                -0.004858563509452433,
                0.027147721440446557,
                0.0007455955559413458,
                0.024979682696745466,
                0.0002547809916671371,
                0.011091484270901097,
                0.0008741251871854314,
                0.013391619148905985,
                -0.001584658695594317,
                -0.002894671660620727,
                -0.0012956639145154166,
                -0.04015634839729827,
                -0.0066046921425833485,
                -0.04041373841567016,
                -0.0022262770629728947,
                -0.046593852159485985,
                -0.0022851763474333567,
                -0.06389618920470688,
                -0.0037292514311522054,
                -0.008126797339959156,
                -0.001976278488831647,
                0.026236140847633,
                -0.0006343858968561074,
                0.001181711391134148,
                0.0007843870946343142,
                -0.024752905981058178,
                -0.0018883254908401753,
                -0.014970937183647066,
                -0.0008363714490593818,
                -0.02844571998854349,
                -0.0019154867122503103
            ]
        },
        {
            'energy': -0.6449018197647196,
            'occupancy': 2,
            'alpha': [
                -0.029755229649009986,
                -0.03402302534814523,
                -0.0020791585015673478,
                -0.040739719832865916,
                -0.024333713227477124,
                0.031839181211317416,
                -0.0014859607913484448,
                0.022308541911698725,
                0.008967274318833708,
                0.02789797149353776,
                0.003930977426193465,
                -0.0397215337363563,
                0.04579370759328335,
                0.057299259897838774,
                0.05989285728239377,
                0.04755299775367455,
                -0.008622399550240127,
                0.047768438761875746,
                -0.004204798553786188,
                0.02091093109602676,
                -0.003960719849926433,
                0.03540087403002809,
                -0.007367904574915088,
                -0.0030231680958893287,
                -0.027560322409259493,
                0.049435276911094006,
                -0.0029823430515466087,
                0.062251912894626386,
                -0.012723158373000356,
                0.04742936472938142,
                -0.1328602884671298,
                -0.08040511432557794,
                -0.02322855990477789,
                -0.06884496896988303,
                -0.014615440736392364,
                0.007880171067799322,
                0.07423810524455673,
                0.024533671214864827,
                0.01875800080513137,
                0.03759272876507447,
                0.04118863081630714,
                0.02459668260304402,
                0.01788585923216025,
                0.0025783956991864785,
                -0.005036631795073647,
                -0.024774170170461438,
                0.0031196662796221047,
                -0.012373336929587907,
                -0.04101650713493739,
                -0.002112449746548071,
                0.027554509210448372,
                0.032746208211601666,
                0.09626101604244179,
                -0.02315272987095879,
                0.01784896229137169,
                -0.0056045586800938345,
                -0.019747614966083748,
                0.0025763173002473984,
                0.03535952724134057,
                -0.041939575765986815,
                0.01460242733498273,
                0.03206742589320402,
                0.022171846822361056,
                0.013419113750053923,
                0.013848872695032759,
                0.023042298482276475,
                0.017605556030388225,
                0.0018291401886976033,
                0.01853345320297287,
                -0.018331557365400004,
                0.025086169225088686,
                -0.01848458609757921,
                0.022843563478102256,
                -0.006625323370459773,
                0.000581335413973793,
                -0.00025793837721455173,
                0.022155307859203124,
                -0.003799874650224093,
                -0.003994726928561746,
                -0.0010091097656909148,
                -0.1016504542608,
                -0.009353062305753968,
                0.004597331650643484,
                0.009499101617470326,
                -0.013290685742176855,
                0.0394014126725695,
                0.019414670295725852,
                -0.001961801051974561,
                -0.024456224117435588,
                0.08207035162859205,
                0.08232936917261363,
                0.06505518503872126,
                0.008795160236417863,
                0.02710612493536598,
                0.01241056696924174,
                0.0024369897569134187,
                -0.045784669357769744,
                -0.0042256707872170025,
                0.00916778826223288,
                -0.0018058195198107072,
                -0.016159909005072966,
                -0.013752851295392509,
                0.0015279167830204328,
                -0.02187808653192894,
                -0.01867010322212491,
                -0.020415821023195245,
                -0.00483631979406191,
                0.036735296948121755,
                -0.05174647261540976,
                -0.011167761112881843,
                -0.03431536483193495,
                0.01712845742670527,
                0.004359701005794748,
                0.021631623523456572,
                0.007195810852472584,
                0.029298386729678726,
                -0.028408176562396106,
                0.015316762619308043,
                -0.01366461930023767,
                0.002130091949906797,
                0.07239644715471663,
                -0.0033424694725982074,
                -0.028394469164263948,
                0.004513989482522181,
                0.05062026422083801,
                -0.017171664280515926,
                0.002966467146875401,
                0.03248210145476121,
                0.04277368874885674,
                0.009814779905321976,
                -0.016892974338161275,
                -0.006112231125712754,
                0.03538894966871053,
                0.09709979991366424,
                -0.15166983300177322,
                -0.0757247811013251,
                -0.00013567214415185038,
                0.0440703933091105,
                -0.007856742006011509,
                0.00327801820917872,
                0.10222180517149183,
                0.0026402195852725492,
                0.00935318377142287,
                -0.0048331133139791,
                -0.2558455120686027,
                0.04695955348967197,
                0.007115183019075327,
                0.01706975501329833,
                0.2909836060910427,
                0.02248435294037678,
                -0.01551237672063564,
                -0.004531492497172762,
                -0.2696397424096763,
                -0.04501610886936974,
                0.0016357351014246349,
                -0.011135851167313394,
                0.12302991305966714,
                0.10305880063614457,
                -0.021418141316252724,
                0.013527509285380773,
                -0.12703029911987876,
                0.022486452624119246,
                -0.07531431867142387,
                -0.043948560440146084,
                0.06287274519298479,
                0.0004248201161339393,
                0.024550750677403047,
                0.0016745604196724624,
                -0.012310574712454168,
                0.001631514873387724,
                -0.037960906782075934,
                0.0007330486460633365,
                -0.023845685565455833,
                -0.0002869396022509361,
                0.028410497122376942,
                0.0004080113532101534,
                0.02351680575070464,
                -0.0007718764233640227,
                -0.005759607441809861,
                0.00024934885872541053,
                0.006749550473190207,
                0.0005729957273424867,
                0.009198296756675823,
                0.0003399271133737411,
                0.013555220149015815,
                0.0013981061859029125,
                0.008270979090917013,
                0.000509063974727467,
                0.006860987940555339,
                0.0006163822159133428,
                0.012770463002874015,
                -0.00003243242163359703,
                -0.03565639090468548,
                0.0001042140896832111,
                0.022791385776207713,
                -0.0013566706818006332,
                -0.005765877811543504,
                0.0006833068049634761,
                -0.021713416853217496,
                -0.0004441886269712488,
                -0.0024650583436745294,
                -0.00008853156471556021,
                0.003855304999616073,
                0.0014599540324654618,
                -0.007445572446233558,
                0.00015844990916763206,
                -0.02229910050980564,
                -0.00008315904077227273,
                0.08023095281455593,
                0.004676733158976557,
                0.002930540486135563,
                0.00038179299447646054,
                -0.014235135131923933,
                0.0007165859216683243,
                -0.020491558249476276,
                -0.003143992187205446,
                0.025390058242380404,
                0.0010973036626675252,
                0.017863997199101027,
                0.0006838667023783383,
                0.0363882412113878,
                0.0015161244121318278,
                -0.09056741614750746,
                -0.004619245711441398,
                0.13717240218573468,
                0.0013201489560786556,
                0.0024208008094655383,
                0.0006179479720565704,
                -0.08984049019151859,
                -0.005305486804043244,
                0.052680856710694515,
                0.001322679201973929,
                -0.04153848586945066,
                -0.002183158287847755
            ]
        },
        {
            'energy': -0.6425942200094426,
            'occupancy': 2,
            'alpha': [
                0.004073252964189105,
                -0.005517785090786619,
                0.03597854136215978,
                0.02742958152731263,
                0.004700715959300678,
                -0.011374941726625697,
                -0.01567491361011242,
                0.002272941286692706,
                -0.006511941293902495,
                -0.015027917844754811,
                -0.009200993219883513,
                0.008024601769364993,
                0.01866696367815942,
                -0.003928290477788165,
                0.001960341458750655,
                0.0019393452576632927,
                0.0034314066000364647,
                -0.030718213205290865,
                0.0013621743070647537,
                -0.008561683682051536,
                -0.002572473240390611,
                -0.02195852155671325,
                0.0055562496620859235,
                -0.0015797427430646741,
                0.02252579572100633,
                -0.0007535572739147341,
                -0.01256510476415925,
                -0.01481801905493043,
                0.00644047638014411,
                0.04010795507908388,
                -0.008913447633835378,
                0.006277620089819508,
                -0.011831037722407923,
                0.0258335115187068,
                0.0008967567608058494,
                -0.009130198491436873,
                -0.04222758814189723,
                -0.017826422448292877,
                -0.015526198677676708,
                -0.0053618006242361505,
                -0.011177759465371234,
                0.01412989597866109,
                -0.019282228192631798,
                -0.01858330157468359,
                -0.0005276599265504516,
                0.006207021117615186,
                -0.004479510578693296,
                -0.005746658929370925,
                0.0005769750605241383,
                0.00536149758618549,
                -0.013141062885834283,
                -0.01419699036627794,
                -0.04247124597017333,
                -0.005070481099155134,
                -0.014322203267219148,
                -0.007412907639487014,
                -0.01780391512763399,
                0.007168685668034615,
                -0.0475197592520487,
                -0.004036388258954448,
                0.005459700382824852,
                -0.010012506390702348,
                -0.0004254515844820245,
                -0.007727673483127532,
                -0.014806933153443589,
                -0.012015480526890809,
                -0.0033507948745716597,
                0.0036084783192799003,
                -0.005579448168839391,
                0.015538167503578431,
                -0.044940513570358026,
                -0.02387053339164817,
                0.011609179043276047,
                0.001774081451129573,
                -0.0013550299232682494,
                -0.0008307333930335003,
                -0.010673294712674225,
                -0.00028716353058463,
                0.0010785479453402254,
                -0.0019037093236894916,
                0.02595932686839965,
                0.039108236789331896,
                -0.13712022298588075,
                -0.08038086579016766,
                0.00932289419929995,
                -0.01532354672043844,
                -0.014751958540368275,
                0.007701770691672138,
                -0.0031082510226880223,
                -0.009973360004491052,
                -0.0059471898646647646,
                -0.0034108363001056426,
                -0.008356146084143931,
                -0.014712056269528047,
                -0.008039408240251086,
                0.0034984586216464295,
                0.057591917662425114,
                -0.01758113489468832,
                -0.00021507566087531824,
                -0.0181543731408916,
                -0.04966659240816518,
                0.022497113437052175,
                -0.005548484734228001,
                0.020010161681178463,
                -0.2824408789053616,
                0.0345560631581186,
                0.01708848064560396,
                -0.06548447210135111,
                0.3181468516293179,
                -0.00954095728488436,
                -0.04746366172975349,
                0.01648933830642068,
                -0.04387929742624961,
                -0.02481840347430619,
                0.0014742010813333286,
                -0.025923969815213267,
                0.049350654248846444,
                0.021247048402664396,
                -0.005515162492220619,
                0.018763695466086066,
                -0.30822518359922757,
                -0.019313737050214115,
                -0.038907399158580665,
                0.035044344764494,
                0.24339863482358415,
                0.04546315921296432,
                0.00959590445059388,
                -0.08654299313509033,
                -0.005932687288617571,
                -0.015250687966531465,
                0.05000614832854339,
                0.02969028965095518,
                -0.060099838409524944,
                0.019222732012599893,
                -0.03282134299135106,
                -0.01632193488846603,
                0.0019269636406712897,
                -0.027307771848118573,
                0.0037446635166858374,
                -0.0018252693245202837,
                -0.0654489902660021,
                0.029620335903342933,
                -0.11429456963209135,
                -0.06245277159093417,
                -0.08319743448425451,
                -0.009308687760365046,
                0.007581817239250753,
                0.0025979765966472135,
                0.0501629162002622,
                -0.015201895889822098,
                -0.024832534404572,
                -0.020523367856444926,
                -0.034273845248837094,
                -0.01768663050485073,
                -0.015901904239239387,
                -0.015313083011612973,
                0.08657288270468089,
                0.004713488565991669,
                0.0005615112481574136,
                0.0016584774732483886,
                0.038807804139328675,
                0.014997965574657891,
                -0.022477847567738622,
                -0.010866100360446542,
                -0.029974422199490702,
                -0.000871223705926008,
                -0.021217937384414565,
                -0.0010351862317083298,
                0.0018842544751522757,
                -0.0006935281153860693,
                0.008359715895964476,
                -0.0005726802456355588,
                0.006301861216773816,
                -0.00005073411989595749,
                -0.006273996736272332,
                -0.00011547985332372059,
                -0.014483369912173676,
                0.00014467557173008857,
                -0.0034402340782336495,
                -0.00030301228202409366,
                0.006590892974011001,
                0.00013290815717380264,
                0.004734678365508802,
                0.00014017658385506317,
                0.0038643699912574605,
                -0.00008450362723412663,
                -0.003116616384778785,
                -0.00014955976066370833,
                -0.004986008306755469,
                -0.0004207580655348744,
                -0.004349804315056605,
                -0.0006732402358182313,
                0.019215807363358765,
                -0.00021888639680036183,
                -0.014358546526163422,
                0.0005584596253652234,
                -0.0014823130616993263,
                -0.00047662304945719227,
                0.03473921526031526,
                0.0006007872664083487,
                -0.029970480439156608,
                -0.0006584402938251681,
                -0.00884510626750226,
                -0.0015270918120011327,
                -0.10768588613982043,
                -0.004078303865029999,
                0.13503842767248353,
                0.0028476312773988814,
                0.02513873342752124,
                0.0017937358527024918,
                -0.024021726919358295,
                0.0004944960882434085,
                0.027436825398568218,
                -0.0006467753036246526,
                0.0038110289060926715,
                0.0007090431734527378,
                -0.11508887301263682,
                -0.004009041076680707,
                0.09768506688212153,
                0.00254482899318143,
                -0.023350239572659068,
                -0.0008502999098474541,
                -0.025424647978651224,
                -0.00152231501387232,
                0.024108220706354648,
                0.0006928528390968967,
                -0.0009763542927915323,
                -0.0001488571512328753,
                -0.011874343798372228,
                -0.0005354901781884395,
                0.034613298383362245,
                0.0009236126658694059,
                0.014607749593085759,
                0.0005419058846858455
            ]
        },
        {
            'energy': -0.6419681446759228,
            'occupancy': 2,
            'alpha': [
                0.011023248197337833,
                0.014429558468406194,
                -0.003970906444964085,
                0.012782609147133816,
                0.026058031590168177,
                -0.05764236620397249,
                -0.04970542985092525,
                0.02002534941325844,
                -0.047203652628682494,
                -0.1128568678698582,
                -0.02161013032146045,
                0.11211392719985565,
                0.024561539639340078,
                -0.008143767194379927,
                -0.0046336616949960805,
                0.001926642291845264,
                0.033904243643804864,
                -0.26340076982101984,
                0.02116938550440034,
                -0.0858024957267405,
                0.012982475426108435,
                -0.18660044789110283,
                0.0267305085890921,
                0.005957102442627999,
                0.05822776294812239,
                -0.012761359064608587,
                0.00851892444323856,
                -0.023936515286391853,
                0.024473444467291904,
                0.0877605172853849,
                -0.0045180607295231935,
                0.023886214186461564,
                -0.027055830861329455,
                0.06563978407758775,
                0.02378513389330617,
                -0.015540106210116545,
                -0.10381975280909046,
                -0.05466689874659584,
                -0.01376057063343135,
                -0.0031350463010612934,
                -0.028685399267117773,
                0.013769048992144352,
                0.00889917399932723,
                -0.004364301316604496,
                0.00511468533570782,
                0.01619364993825445,
                0.00042127501777305504,
                -0.005421479450171696,
                -0.028310352824888523,
                0.026986220700669236,
                -0.024056485169998646,
                -0.04558455947664682,
                -0.11041524102749652,
                -0.02143840079352339,
                -0.014253208961275262,
                -0.0003632283351490279,
                -0.02963359274659107,
                -0.013663547191916557,
                -0.02899705129908608,
                0.05835473548077713,
                0.013454578750937172,
                -0.04113246371351058,
                0.005076222386083097,
                -0.017716042294144443,
                -0.060601894848903846,
                -0.05703107151144767,
                -0.03855797566837853,
                0.014547034665119548,
                -0.01049929178463985,
                0.005869233281077584,
                -0.0024005830720487667,
                0.009378631903543636,
                0.007387375984823846,
                0.003900549905600329,
                -0.00031817952344196125,
                -0.0018377700614193738,
                -0.011471864865693498,
                0.002444381018046133,
                0.0023413184646491614,
                -0.0024105988122779063,
                0.10464013572272071,
                -0.013636350257150261,
                0.033938239295651006,
                0.03237357169575672,
                0.06499863162309498,
                -0.13031522536591772,
                -0.07922602977012523,
                0.01874391250240757,
                0.0010330551457539026,
                -0.029553056347790384,
                -0.023547642742184495,
                -0.012473776385749853,
                -0.044640596403071615,
                -0.12382716893336629,
                -0.04819127626116661,
                -0.0007377865933024937,
                0.008815878437306256,
                0.006045165218822199,
                -0.005389047627342449,
                0.0035611554070037214,
                0.011422613264040898,
                0.0025919281674721783,
                0.000855763813490589,
                0.007898923285522502,
                0.13818283744446955,
                0.009222527715507899,
                -0.003857955057406868,
                -0.016779386307686165,
                -0.04493720864259943,
                0.014362340978579106,
                0.056735487929532286,
                -0.02403671379217023,
                0.006307866714903577,
                -0.004750302822597602,
                -0.0036670539352072623,
                -0.00836744840248435,
                0.006062864424260345,
                -0.00871836039984993,
                0.0063207780934852985,
                -0.00259247765327393,
                0.030984326004314756,
                0.01368555170253535,
                0.05433530468714838,
                -0.023266122495268705,
                -0.1497331665334281,
                0.007186323982994011,
                -0.004015676579021915,
                -0.013796315632149758,
                -0.015388616407359416,
                -0.002235648591686439,
                0.00001978003004153692,
                -0.0018895433461676371,
                -0.1516741579338765,
                0.04041359846537546,
                -0.060039484545799715,
                -0.028249590627335796,
                0.0009683093110774884,
                -0.23120453162755866,
                0.0246573836141553,
                -0.01981368584958006,
                -0.10860990856624857,
                -0.012801938276031563,
                0.03412766672732646,
                0.026333402466602464,
                -0.1782716127671117,
                -0.02773897776546689,
                0.017992664095582696,
                0.004682005491428471,
                0.08338113005939417,
                -0.03981887784095731,
                -0.0596186941415174,
                -0.0501760522274648,
                -0.052745826380394836,
                -0.040045708409920076,
                -0.04085821722190684,
                -0.037883355097368454,
                0.19910505696552763,
                -0.003936468209993296,
                0.003670597920069583,
                0.0014079934078708245,
                0.1153556627980915,
                0.03347372842300563,
                -0.047077677036626374,
                -0.022198540099126512,
                -0.06568908146748181,
                -0.002209925310258276,
                -0.03911304772415346,
                -0.003420015678642037,
                0.009714157294287842,
                -0.0019912388884293928,
                0.008066651725187238,
                -0.0018847794353940533,
                -0.00244862407012846,
                -0.0006804283416809928,
                -0.0186104490535087,
                -0.0006831614580250295,
                -0.07281279914253824,
                0.00193486722156993,
                -0.008512019538832646,
                -0.0009527096208190249,
                0.005097689992167356,
                -0.00009656053524194785,
                0.003930603669567855,
                0.000146407481450993,
                0.0007991882047542124,
                -0.000661342189071255,
                -0.0028417976336957257,
                -0.00012294784682668542,
                -0.004722641335326976,
                -0.0005583615628823665,
                -0.006932820032990936,
                -0.0010303133841149457,
                0.1306267688911657,
                -0.0022472642516644416,
                -0.10529665960098004,
                0.00566913951994872,
                0.018359854669120598,
                -0.00394136716506823,
                0.0035744763286971845,
                -0.00019633181009793603,
                0.004842286013672911,
                0.000043109227896036864,
                -0.03722332177478033,
                -0.006577476106089489,
                0.051643408292890144,
                0.001032171881527464,
                -0.019414453126086674,
                -0.0008913624151396574,
                0.04805864807769231,
                0.001662357088656536,
                0.0035007641097299443,
                -0.00032719036057767876,
                0.0029482334809650137,
                -0.00019107283975957294,
                0.06054862963915096,
                0.009725624197788786,
                0.01223398584656222,
                0.00032304458473676273,
                -0.05871841075955511,
                -0.0016113901341613288,
                -0.04147369057619724,
                -0.0012637168193043013,
                -0.053968297512105336,
                -0.002819815397844151,
                0.04078396050385886,
                0.0012795629263771418,
                -0.013164838676422496,
                -0.0029814617416396823,
                -0.018435598140763027,
                -0.0007372366221163168,
                0.07977717624300726,
                0.0020806592403202,
                0.04344919895253089,
                0.0015400869864310477
            ]
        },
        {
            'energy': -0.6405244068619177,
            'occupancy': 2,
            'alpha': [
                0.013757701059562758,
                -0.011663810925728822,
                0.09823204198909304,
                0.07891364214207966,
                0.011360717209265457,
                0.001069891128257896,
                0.018241521339225557,
                -0.058706658491907836,
                0.03980853431527538,
                0.0882001083103217,
                -0.007395856482126073,
                -0.09851620513670423,
                0.03144737027211873,
                -0.02497961888481811,
                -0.004752677462749769,
                -0.00485080712807022,
                -0.0320008305689398,
                0.2625808163852435,
                -0.025828547223777858,
                0.08281683773723963,
                -0.02975565222672946,
                0.18216124319822666,
                -0.01023684885288825,
                -0.013832986385534787,
                0.029760171522692214,
                -0.023835249315501017,
                -0.04600192969113123,
                -0.03797026410728893,
                0.022290930234105243,
                0.052144078516309166,
                0.004971952304524755,
                0.01839544739153609,
                -0.010255261520299286,
                0.05437751715121337,
                -0.004147801033042433,
                -0.011623879804978917,
                -0.089174338608204,
                -0.009641167416196268,
                -0.06355822994418635,
                -0.04368261506651257,
                -0.012285463840572728,
                0.007430249206752843,
                -0.03744461756072208,
                -0.035146420046229414,
                -0.0032860971469987742,
                0.015754711512995956,
                -0.016196932261494584,
                -0.014028625276933633,
                0.10353410304007132,
                -0.015135474973814992,
                -0.050879839070679486,
                -0.02633978744990199,
                -0.09061339522488526,
                0.009237497951416736,
                -0.013396658893610417,
                -0.0015412214438741468,
                -0.018932218398967224,
                0.008135518331073996,
                -0.022900337211801885,
                0.02616846475576939,
                -0.020126935779402153,
                -0.019607467042301173,
                -0.04389762693660886,
                -0.02375288096093104,
                0.024971080543622473,
                0.011561347059620935,
                0.025668570808526258,
                -0.013080937285438621,
                -0.0191133234136057,
                0.03905009959115026,
                -0.121753304976934,
                -0.06185792617680919,
                0.03414779218154389,
                0.005560419889119537,
                -0.00456402535425694,
                -0.002505456708406529,
                -0.03472231983727994,
                -0.0012646049861105469,
                0.0024347150426188313,
                -0.004606045360038761,
                0.049049786830765725,
                -0.008198811464512555,
                0.02250235752619053,
                0.024776529144911436,
                -0.05206822759829697,
                0.09945856168342183,
                0.04594586621793596,
                0.002909591189281909,
                -0.017882613356712828,
                -0.041905384394722314,
                -0.02286050775233605,
                -0.019966767261603655,
                0.028461148317071274,
                0.11259963354442527,
                0.030147706574912787,
                0.01312900099818889,
                0.1686252986923229,
                -0.03825596466531851,
                -0.004487284573709682,
                -0.04617005359629346,
                -0.14148464659038945,
                0.05509577077327019,
                -0.014858839475705881,
                0.053125648666568236,
                0.09671156764136515,
                -0.0009814753485600392,
                -0.006513676450349968,
                0.0021823597140603747,
                -0.04822354232854784,
                0.01076715306966365,
                0.03581807226658927,
                -0.015806074401597026,
                -0.10476919981686104,
                -0.07205735359510543,
                0.0027996180785861105,
                -0.07715100809344702,
                0.12622481177500633,
                0.059505605205352564,
                -0.015568762978166941,
                0.05363901441689104,
                0.052098179378232745,
                0.008891799995721799,
                0.032394259226203447,
                -0.015213852634540314,
                -0.10515082887258013,
                0.0005663136258108486,
                -0.0013354294319923817,
                -0.0005048683787080524,
                -0.019079275609389056,
                -0.04179223877060025,
                0.13346791129158614,
                0.07837004152102499,
                -0.11307468038522692,
                0.024840714176964474,
                -0.022948778935357236,
                -0.008405591678075992,
                0.007921028784389184,
                0.22464588169994246,
                -0.014350945117850511,
                0.02279593147730262,
                -0.05101360887684462,
                -0.009953216458472367,
                0.03235114714465755,
                0.020896411419394897,
                -0.1025535763314947,
                -0.024750433697692423,
                0.014386244601860528,
                0.0029418919457405704,
                0.018325042624560743,
                -0.028934993447449854,
                -0.041226267387000096,
                -0.03517591507038976,
                -0.007280765474398695,
                -0.026352985941909636,
                -0.030608240003705302,
                -0.027417084323311164,
                0.12674637846924636,
                -0.019130486461691187,
                0.004246098647506231,
                -0.0023440895672132444,
                0.10217380772498665,
                0.019417136306406763,
                -0.025721446971914124,
                -0.011833122211127476,
                -0.0770944853528349,
                -0.0007262839385484861,
                -0.05723761712998495,
                -0.0006066605023254104,
                0.003586339130537812,
                -0.0008308888158897637,
                0.06949724442949942,
                -0.000277545168793494,
                0.05953581841156473,
                0.000723803149320521,
                -0.03723152280479484,
                0.00013157291995224065,
                0.029470826663685362,
                -0.0015551559591963173,
                0.011147404654397262,
                -0.0001967463610155274,
                0.019984623344154785,
                0.0005044186981538323,
                0.013898910149018746,
                0.0003576739029774163,
                0.011089152478769975,
                -0.00036231573969933666,
                -0.01111027189771854,
                -0.000493613100015228,
                -0.015710035737010783,
                -0.0009786079532794025,
                -0.013717794697958283,
                -0.0013122360715129332,
                -0.09029402885959056,
                0.002741448632780205,
                0.0877519871514585,
                -0.00541414803963345,
                -0.030437003634368853,
                0.0038924382897952544,
                0.09613436048674331,
                -0.0002372380591384671,
                -0.07943619642262091,
                0.00034804311810261734,
                0.018887172399497425,
                0.0024537828828173174,
                0.03393394948865684,
                0.00014063889345499898,
                -0.01876056229375906,
                -0.00009342234643699637,
                0.028069610379739665,
                0.0010465216554872995,
                -0.060634225077202904,
                0.001365978190147791,
                0.07308697251564805,
                -0.0017719197965116935,
                -0.05687745547942665,
                -0.008854853875293901,
                0.02019779560503248,
                0.0004824129541929748,
                -0.04241027187340765,
                -0.0009439577835033315,
                -0.020207099147920692,
                -0.0005131842169838123,
                -0.027326212631472366,
                -0.002186990546374479,
                0.0113062187446435,
                0.0006361946092612028,
                0.015762448694328513,
                0.00379489671263833,
                -0.0022551810712184025,
                0.00003499611474111887,
                0.05152550817742986,
                0.0012416473275836404,
                0.03920524902654237,
                0.0012404272687252186
            ]
        },
        {
            'energy': -0.6390344078626837,
            'occupancy': 2,
            'alpha': [
                -0.012272334365156531,
                -0.05719244426082139,
                0.14593861051815496,
                0.07121202735215779,
                -0.03890453016307208,
                0.04262371147692012,
                -0.027905280753331926,
                0.07427454116851065,
                -0.028962078958960108,
                -0.05143005778939342,
                -0.005038945011909566,
                0.02826107720554806,
                -0.039243107961447955,
                0.034384410652153384,
                0.0019363375771605585,
                0.00746299413323954,
                0.022014055319960212,
                -0.18083248579790112,
                0.017619952248497987,
                -0.05582822739277488,
                0.014911964842683601,
                -0.12385171263304406,
                0.010547109354053775,
                0.006297095385841898,
                -0.01319813313696087,
                0.05183151350389821,
                0.013078011269392748,
                0.0171187107292261,
                -0.027436314136350285,
                -0.04142184941556607,
                -0.004066969275224775,
                -0.014797440211762585,
                -0.008031145085707252,
                -0.04711213482848901,
                -0.005581681497329425,
                0.0010567149252337879,
                0.07884279895644826,
                -0.002576567466864127,
                0.0396488260572096,
                0.046548321837758214,
                -0.0004431970930063732,
                0.024332156822194237,
                -0.038797025515398126,
                -0.019392206026149855,
                0.0007816906197494372,
                -0.01641973902298044,
                0.010135029954894894,
                0.003376770246827084,
                -0.12007505627215909,
                0.01357931250185931,
                0.04222010311659112,
                0.0416419307435116,
                0.08767458340181557,
                -0.024812711336056968,
                0.0017939508309808055,
                -0.0019556677888030297,
                0.01400727889632799,
                -0.017115838192194453,
                0.0015961159551705437,
                -0.02516170630943866,
                0.0459489580643861,
                0.05239717138801504,
                0.058389905143816624,
                0.029870670919557456,
                -0.02784679922180687,
                0.004843073055802338,
                0.004993829596693833,
                0.02351346044212175,
                0.006906249973616709,
                0.04313390434581418,
                -0.1523033759549554,
                -0.10510732618075541,
                -0.01305245160423544,
                -0.005449725359607663,
                0.0037079174878399657,
                0.0016462666081045842,
                0.027731312501428223,
                -0.00048804185218169813,
                -0.0022951966915545578,
                0.0017108014339087309,
                -0.020994570793089216,
                -0.005152669059262967,
                0.01257247449460918,
                -0.002172438946244941,
                0.03082883170007727,
                -0.04229042614167061,
                -0.032430983873284025,
                0.011945770727181755,
                0.032872747893329786,
                0.05088005999697506,
                0.021543467204533123,
                0.0243162425312897,
                -0.02292070773468854,
                -0.06793738462816393,
                -0.022227357409829493,
                0.00034340433010823833,
                0.20674823658599364,
                -0.0650111811646603,
                0.008976360735159507,
                -0.0661620577918314,
                -0.22955891357209063,
                0.06280742737527084,
                -0.02522738616021902,
                0.04118386455174904,
                0.013693100584690261,
                -0.010260538649986209,
                -0.0033758916552573026,
                0.014602198542188366,
                -0.041161273349887985,
                0.0008868133248320033,
                0.0006494195127478006,
                -0.002724420917519417,
                -0.15428311885791363,
                -0.08624151972310617,
                0.014109160830180345,
                -0.08401820119602865,
                0.14016147515356164,
                0.10871790503011707,
                -0.04149299237375739,
                0.08118757681428164,
                0.04704858126071097,
                -0.0010340676340619267,
                -0.005338925731161919,
                0.0006908636946958922,
                -0.017823834986821777,
                -0.009054050231202967,
                -0.000613210262448342,
                0.01698298801400514,
                0.015262308466545658,
                -0.048372989504139124,
                0.17838258041240176,
                0.11089598847129226,
                0.11014230860443619,
                -0.025742893257141276,
                0.009866225497536562,
                -0.0005946845875144468,
                -0.002467056973532443,
                -0.1519378944749358,
                0.011287136507312329,
                -0.01478098211346409,
                0.03188573767415744,
                -0.003869639715544378,
                0.014275891970561767,
                0.007790393959759882,
                0.0865650365533669,
                0.026765776756459532,
                -0.015076346254050379,
                -0.002864951813842109,
                0.010551681437461748,
                0.026496739245292306,
                0.038208834201822646,
                0.03247556967557038,
                -0.011924160986854185,
                0.025626227329271212,
                0.03125732175313024,
                0.027647571620647283,
                -0.11078059038875963,
                0.030692870978268044,
                -0.004978299371035348,
                0.004969536956808797,
                -0.11334186166577968,
                -0.01468659063192093,
                0.0198152844681914,
                0.009186907548349131,
                0.06009457478194717,
                -0.00022736227548834586,
                0.03986044609217842,
                0.0008286480373757587,
                -0.006133121647056658,
                0.000671551282887676,
                -0.08221426591333593,
                0.0007195238689989227,
                -0.04859558975823829,
                -0.00012397293782193092,
                0.06378455667511758,
                0.0005841566365175854,
                -0.012584465084456771,
                0.00033037716301312147,
                -0.027737175217034147,
                0.0003828000400191745,
                -0.010662776522760396,
                -0.0003501621900715383,
                -0.005298365409248283,
                -0.0001698811032908423,
                -0.002581426203258397,
                0.0006575440430922129,
                0.00973544172099212,
                0.00039693990614897705,
                0.011186165710722873,
                0.0006946176160809916,
                0.011853321137480185,
                0.0012909952601668103,
                0.04832031508777699,
                -0.001886182485654723,
                -0.05670293186052736,
                0.0029010835060029007,
                0.010517686585233312,
                -0.0029648876358271356,
                0.11646476740514025,
                -0.0009482387082985182,
                -0.12317812016196701,
                0.000764465009596032,
                -0.012020785823906605,
                -0.0006467527120859192,
                0.0035692008106940724,
                -0.00040574831662473093,
                -0.014637741524553749,
                0.0005735773327560882,
                -0.025289809881254087,
                -0.0009119141328746627,
                -0.09007677988697634,
                0.00214196764313916,
                0.08538983322051985,
                -0.0017440291619992502,
                0.018878092867878556,
                0.0032870783361572268,
                0.018444783770688592,
                0.0004309202039704431,
                -0.007550581181677525,
                -0.00004815622047790387,
                0.012668524193794429,
                0.00029380228398131103,
                0.020494449251166242,
                0.0022752604257024064,
                0.0007576055862780985,
                -0.0003439857497813506,
                -0.01081030310594854,
                -0.0024934994815390002,
                -0.005043044358641433,
                -0.0003316034330743703,
                -0.04589722486076696,
                -0.0010245166197232689,
                -0.04458839623718319,
                -0.0012261615369305286
            ]
        },
        {
            'energy': -0.635667935476085,
            'occupancy': 2,
            'alpha': [
                0.06734571348426133,
                0.09998342318152675,
                -0.03808411983213513,
                0.0745672119222221,
                -0.09158524258900637,
                0.24162023435061786,
                0.16370408822943253,
                0.025173295136136226,
                -0.09223835021716698,
                -0.09555337430856263,
                -0.039755085239577756,
                -0.12331169830746516,
                0.004431323008719899,
                -0.0030408775092803267,
                -0.0009087273554302668,
                0.0037811920245004677,
                0.12723140140946612,
                0.09290065923218166,
                0.14329222058609767,
                -0.21568685359142917,
                0.11187646580827271,
                0.0323408952682976,
                0.05589597612752721,
                0.11541991817057624,
                0.03096743975107033,
                0.01942289529000418,
                -0.029527845895312668,
                0.04199826093453217,
                -0.00535164664289311,
                0.0008062285770164644,
                -0.0010354908663224994,
                -0.003732618748283264,
                -0.06409567792352847,
                0.0004825198116629558,
                -0.032206725135941354,
                0.013980484623997836,
                -0.01935015707729588,
                0.023242503759389882,
                -0.0351200908252558,
                0.05456321184792014,
                -0.046118225842671834,
                -0.017258136197458387,
                0.03569572203545023,
                -0.06193330443034791,
                -0.029218020527055685,
                -0.01590392484873742,
                -0.04051943250210416,
                -0.0726640546817409,
                0.0072944848458699465,
                0.06569327728342318,
                -0.03970366047186678,
                0.08207728041122016,
                -0.0020820184815145484,
                -0.003901902890961306,
                -0.015895218049682434,
                0.014202483486478623,
                -0.003075837517806447,
                -0.023749393900597944,
                -0.0010002116009938302,
                -0.010862338289327296,
                0.12417905986958731,
                0.15304711604567686,
                -0.022139499322433583,
                0.15929194425525905,
                -0.08662951179035458,
                0.011561513784804973,
                0.044444963776702914,
                0.13067606211948546,
                -0.10883463926952751,
                0.034770582134289116,
                0.017632858118356194,
                0.02801794385511704,
                0.17578999627594638,
                -0.0034059004580061706,
                -0.0097926840148451,
                -0.01675620377933415,
                -0.056593151977837396,
                -0.012412699376540803,
                -0.002195454231973581,
                -0.018317614206472065,
                0.025012211488531742,
                -0.01183841166654997,
                -0.005147429170585373,
                0.003288324449225352,
                0.02894938418037186,
                -0.006893392416049679,
                -0.01172419667123445,
                0.12155819025727446,
                -0.003640115718166371,
                -0.001397311734496582,
                -0.0013192690288559286,
                0.005109498823999966,
                -0.08449105411980498,
                0.03135047525265749,
                -0.06836224527090724,
                0.04083261787797666,
                0.026266015272665786,
                0.06455487406380918,
                -0.04794637710573888,
                0.016399731953574737,
                0.07536066280163278,
                0.029075542490545152,
                0.03385962490897979,
                0.055421705270458595,
                0.02041722676949042,
                0.0017678814292523268,
                -0.0011766983574367728,
                -0.008019424487969638,
                0.018933283857401867,
                -0.000665228541107487,
                0.008715614837916719,
                -0.003337950636118096,
                0.07591502847170002,
                -0.014831358227820954,
                -0.028615991438202024,
                -0.04651616491721789,
                0.04957538579497422,
                -0.05825898968032766,
                0.05177534940803624,
                -0.019692264240983345,
                -0.011891011392762678,
                0.0031701748616068002,
                0.013733497575843988,
                -0.006454377144917717,
                -0.015467624052396578,
                0.00662994097018599,
                0.0017186624978018463,
                -0.013781996388009934,
                -0.08580295548377735,
                -0.012862125430943514,
                -0.01273328497880514,
                -0.02847530944718511,
                0.005129282357126393,
                -0.002703500581168271,
                0.00016093028909057238,
                -0.0021648550666771987,
                -0.019333700610403997,
                0.057108866875016755,
                0.08019577719273345,
                -0.00528500159738348,
                -0.0358044670026632,
                0.00004512687637520714,
                0.0016651201106494147,
                -0.0005685444949241575,
                0.006751734141498102,
                0.0004921861070124893,
                -0.000541618156119965,
                -0.0006085947504739449,
                0.0014499908663861453,
                0.002050453923961736,
                0.002572583552094512,
                0.001744484522962812,
                0.0009827833397986832,
                0.0020799464000801986,
                0.0025658061584700066,
                0.0021663961295704357,
                -0.00800707732449657,
                0.002690029282723872,
                -0.0001519886618544842,
                0.0005011876638247186,
                -0.008094941689609439,
                -0.0009673698208450722,
                0.0020417307901673416,
                0.0010385589387458124,
                0.02685975678957414,
                -0.0004875282243048889,
                -0.05316394527792262,
                0.003401537932671632,
                -0.02673566545950044,
                0.001058479229857864,
                -0.05685739469945377,
                0.005944579907366417,
                0.0654777601681796,
                -0.0004470107576721019,
                0.1865510520024504,
                0.00369887188903493,
                -0.03249841500125617,
                0.00016335527123027043,
                -0.12064812674977046,
                0.003006090402435611,
                0.07642890045852425,
                0.0009291053056397744,
                0.07630598519808987,
                0.001072737235278981,
                0.07385782904007532,
                0.0014398555509434693,
                -0.014319569440175792,
                -0.0003414286524300726,
                -0.033208662859768756,
                -0.0007897011938860778,
                -0.014964024014913731,
                -0.0001856581167378308,
                0.04178107997528314,
                -0.0001604643019317174,
                -0.031287320624877116,
                -0.004917085244454903,
                -0.07292077026731902,
                -0.0077881264132475024,
                0.017935078968168067,
                0.0004471076612008219,
                0.04182299607620664,
                0.00003241054377465394,
                0.12449007108967172,
                0.020172074027944572,
                0.007131017953388497,
                0.00006329515615144689,
                0.006800156260996801,
                -0.00008447061797626213,
                0.0009137135505877203,
                0.0008946509996712221,
                0.043138495630218,
                -0.0014413599970680745,
                0.026415543897998425,
                -0.0011403680259045026,
                -0.0457044257831304,
                -0.004064752433599266,
                -0.005161044784090846,
                -0.00011153821417876401,
                -0.0068447003494792255,
                -0.00013244316045480105,
                -0.01545845185293706,
                -0.00021833431119545256,
                0.0022658145170669918,
                0.00003874496942244552,
                0.0007091849839535586,
                0.00016554499138139966,
                -0.06761214177244362,
                -0.016196251228457845,
                0.00037983530138514825,
                -0.000001879777173686219,
                -0.003480837378765627,
                -0.00005873325475677639,
                -0.0034107447947230945,
                -0.00005951873837849232
            ]
        },
        {
            'energy': -0.6348220402701469,
            'occupancy': 2,
            'alpha': [
                0.0695302805121048,
                0.09982753476569124,
                -0.026174054055634863,
                0.08635246472608595,
                0.02429628140189037,
                -0.08555527061305233,
                -0.09220304581068524,
                0.007633088856076422,
                0.05230180670547324,
                0.0583797594080254,
                0.019094394083573007,
                0.08708091509195376,
                -0.007940407856032833,
                0.007122552654989814,
                -0.00962988327892217,
                0.012133968711224352,
                -0.12846396008968328,
                -0.10917065230424798,
                -0.17149093697098644,
                0.21036841717303165,
                -0.16145108257415178,
                -0.0436896196591788,
                -0.010929256383120431,
                -0.1479906063832954,
                0.023883756959496346,
                0.04528674789977041,
                -0.03183170074936272,
                0.04244786329117918,
                -0.01919247056780589,
                -0.0026582037431423546,
                0.0026290241605382647,
                -0.00235825443169054,
                -0.12336673122307447,
                0.0022153079314178445,
                -0.06536006124194581,
                0.021050808522354386,
                0.017914252347374194,
                -0.007908794046874574,
                -0.007919486897671585,
                0.01396685182875734,
                -0.02546605083309146,
                -0.0287893263206678,
                0.023156667047863504,
                -0.06035415368780323,
                -0.0794870817173352,
                0.003651653801978234,
                -0.09393295825144224,
                -0.13444370290141416,
                -0.027682190220083173,
                -0.027288442986678523,
                0.01793697720806524,
                -0.021785699907599813,
                0.02834730057697501,
                -0.015430166714548669,
                -0.038718811482087986,
                0.03417882414271345,
                0.03611574798229132,
                -0.021321488618411214,
                0.006263558377132819,
                -0.027831193731292884,
                -0.038553296756717995,
                -0.05223157565429972,
                0.028840406038247918,
                -0.06867756023623009,
                0.02995967477625634,
                -0.00485870779222599,
                -0.007693713545866602,
                -0.06289917027099227,
                -0.10616686922496114,
                0.03193276697968958,
                0.0001643528473762529,
                0.01925614615732679,
                0.3221588051180836,
                0.0032440133195173184,
                -0.02863846785765081,
                -0.035951264901485085,
                -0.1833284376308729,
                -0.02375261038274408,
                0.0009994245161286822,
                -0.03283426273027762,
                -0.01285431350423886,
                -0.004469787536948897,
                0.00656533951804712,
                -0.013616659506311904,
                -0.02506665877076248,
                0.007460681436987206,
                -0.015406735317057505,
                -0.07536665398736857,
                0.01588053546552045,
                0.012951351548679072,
                -0.0037952094183565355,
                0.02031973034091903,
                0.0730345347833167,
                -0.02872976727304707,
                0.03292610293273275,
                -0.011860695913267777,
                0.0480576165585962,
                0.058370683880837035,
                -0.04960766841881926,
                0.01569611383637263,
                0.054116240759271406,
                0.03423113719828767,
                0.030477425311457897,
                0.06161075380567577,
                -0.012506204203171332,
                -0.004785483426830674,
                0.000965109841876199,
                0.0036065434111287346,
                -0.014161173978870232,
                -0.002642853138939988,
                -0.004224064709849979,
                -0.0008543325381688084,
                0.06752514411535232,
                -0.025046620021280885,
                -0.028655537986856463,
                -0.055729214143954514,
                0.0640747408728099,
                -0.04977264268441191,
                0.04869600628511308,
                -0.011765847105327123,
                0.011477171954610477,
                -0.0031481577725494406,
                -0.010152235981628878,
                0.004216210753961135,
                0.008955546006224615,
                -0.006129600944881317,
                -0.0009769011515826508,
                0.010357486462510808,
                -0.08719233549042911,
                -0.01942814791874453,
                0.002999433035625011,
                -0.01989335415711107,
                0.03291336350053963,
                -0.01584780081706313,
                -0.001951408284473954,
                -0.007738159139715033,
                0.0490237770150254,
                -0.07323658018339377,
                -0.04824405529137912,
                0.018597875876620075,
                0.027446100789993582,
                -0.0008444922065632877,
                -0.00006053268938378897,
                0.0009462499953921454,
                0.030806696285315103,
                0.007713667455267337,
                -0.0053526147737719566,
                -0.0019506557491434675,
                0.01779628847188709,
                0.0073539266241603495,
                0.011822726647188671,
                0.009029180305064461,
                -0.007927157510302657,
                0.01150013003233831,
                0.013478110463798989,
                0.011916449859315526,
                -0.03384106733477739,
                0.018724092887649695,
                -0.001756446859886779,
                0.0036951978540327316,
                -0.04916487359182689,
                -0.002262037952998917,
                0.006343589973349016,
                0.0035194023311072727,
                0.0076037677445559984,
                -0.0015484379056630764,
                -0.00435257499018313,
                -0.0027315515150791152,
                -0.03096197631247261,
                0.0002562704539485557,
                0.010220999373026162,
                -0.0020209300510633217,
                -0.033908374017507854,
                -0.0007051330364349902,
                -0.06582150601284296,
                -0.0014713711315893756,
                0.01624592460515736,
                -0.00027409738513162787,
                0.05178792942702645,
                -0.0012809934136241092,
                0.15068277406488248,
                0.0028824937801974295,
                0.13999584998980014,
                0.002242275933439434,
                0.1311492722568205,
                0.002824239314341009,
                -0.0575111867928362,
                -0.0012181792079480754,
                -0.09075186023510208,
                -0.0016127739433880446,
                -0.05827071588760684,
                -0.000989529933022013,
                -0.02161649020802431,
                0.0008624694261372799,
                0.01913776963710871,
                0.005174177185501533,
                0.044970895406144615,
                0.0072908709693754,
                0.02655653823146051,
                -0.00013802272579633976,
                0.030105421366762076,
                0.000045140573324988875,
                -0.05895710712935423,
                -0.009059653033381455,
                -0.004035275542809191,
                0.000015354733292029243,
                -0.004671843897115389,
                0.00009332760913634679,
                -0.00557805474964144,
                0.0011764020729946039,
                0.037184391653762444,
                -0.001488577119635291,
                0.03548870075494896,
                -0.0013675516543622589,
                0.03320521945495007,
                0.0038693047265317133,
                0.004911598185495551,
                0.00011022337101926584,
                0.00392355885450441,
                0.00009359136163648433,
                0.0119016586602361,
                0.00015226218870077914,
                0.007463896592336373,
                0.0006879596206581213,
                0.006220636840713431,
                0.0003780886796239918,
                0.08209324653164846,
                0.019746933196636406,
                -0.0035575573248679496,
                -0.00015059449467754748,
                -0.014980208510008813,
                -0.00026421624924549973,
                -0.020933060299943504,
                -0.0003477807784611176
            ]
        },
        {
            'energy': -0.6334818810906582,
            'occupancy': 2,
            'alpha': [
                -0.004896706628656677,
                -0.008988244921099264,
                0.006042563767333325,
                -0.0033984018527702577,
                0.07799833004298239,
                -0.2008756809240796,
                -0.14133497152094704,
                -0.009882211096339077,
                0.025514041622973743,
                0.02152513815002257,
                -0.01521847271482406,
                -0.10193038129715885,
                -0.011016250552976501,
                0.007757842808156329,
                -0.007992066989821982,
                0.0044805995894022935,
                0.2022100990856522,
                0.045142183015278475,
                0.3378907949973035,
                -0.3212521374794306,
                0.3722614514341599,
                -0.007394123418267084,
                -0.10202024375969315,
                0.3036481319326159,
                -0.001546310306563262,
                0.012092591179179695,
                0.003940874253971639,
                -0.012243656741423702,
                -0.010442482449597404,
                -0.0015766358875007156,
                0.005826904761306528,
                0.0028716264525522417,
                -0.02470313963494879,
                0.007040614778832616,
                -0.021223958171091798,
                0.0007411966893004753,
                0.016908550763275625,
                -0.025411039754499883,
                0.01726877135871687,
                -0.027478245671658345,
                0.005099147648397469,
                -0.0020598376035541504,
                -0.00953673098986153,
                0.007947566917184802,
                -0.03431237081337116,
                0.019787986095686837,
                -0.04704060294403059,
                -0.036891777474269055,
                -0.023645622389072526,
                -0.053047232874023936,
                0.03268606097480734,
                -0.06507869719328623,
                0.017503589518859334,
                -0.009271082989317296,
                -0.013276159295538378,
                0.00729146392520508,
                0.01722922456857719,
                -0.001856847789141652,
                0.0007978606475460105,
                -0.006275937118203873,
                -0.09233667285844986,
                -0.11754841757927167,
                0.023665173960281078,
                -0.1298177434412198,
                0.0559585823760739,
                0.00183008973938752,
                -0.03701620362418064,
                -0.06157956756756787,
                0.015581516107530502,
                -0.0027957936662371344,
                -0.008124892536888632,
                -0.0016338683561401366,
                0.10218869859108945,
                0.006370166224453548,
                -0.016170446600166928,
                -0.012037865841870941,
                -0.10968251478143659,
                -0.007875826137090314,
                0.001316035372002514,
                -0.008513809087664562,
                -0.015102564632964685,
                0.003847690466345522,
                0.006099966304379775,
                -0.008970249303388817,
                0.030384131712903727,
                0.02552032761642359,
                0.058874975796859574,
                0.02160164721706715,
                0.016786579607226397,
                0.00973884389542556,
                -0.002668861456975637,
                0.008411098171369669,
                -0.09640978634990288,
                0.0025631632840583925,
                0.03624168308485515,
                -0.04107438577417149,
                0.004768758666773236,
                -0.01008108021603859,
                0.006373910473966395,
                0.0008219027483266358,
                -0.0115476953428916,
                -0.002169547408940071,
                -0.006861432519086097,
                -0.005578349542456267,
                -0.015929201095763026,
                -0.002522844647709186,
                0.0012107467162047693,
                0.004365684098823722,
                -0.016131049794664294,
                -0.0005464273435525648,
                -0.0047870889150545765,
                0.00043306557290093064,
                -0.010814728275430945,
                -0.0028433841987528822,
                0.0037942216019446248,
                0.0027060845384484695,
                -0.004205959463493622,
                0.007138239537518738,
                -0.006895804134711657,
                0.002815789577199699,
                0.009655948788478525,
                -0.003182812792554489,
                -0.01146455493164035,
                0.005402019939664592,
                0.00964904225288782,
                -0.006212906488269333,
                -0.0015512822964133866,
                0.011731832653805984,
                0.006628704554742399,
                -0.0006349695976508353,
                0.004431238476853755,
                0.0048102766066278274,
                0.01854292478024155,
                -0.010798417853191841,
                -0.0017455799064297498,
                -0.004602371313905378,
                -0.1528722152425139,
                0.027914376269278614,
                -0.014726092700657377,
                -0.07695665949530042,
                0.0292239501176935,
                -0.0007436460129311114,
                -0.001103015131115973,
                0.0013157842126467134,
                0.016913599214101918,
                0.005486493334390554,
                -0.003390085830277866,
                -0.0008544151784352147,
                0.014048468169892284,
                0.002613235906700104,
                0.005697288495542072,
                0.004266724423439783,
                -0.008378710242482084,
                0.007213776063284779,
                0.008095872877692754,
                0.007292181431883158,
                -0.01572012359991047,
                0.012825213502988245,
                -0.0013324547145173156,
                0.0025244322362607775,
                -0.030783692000718885,
                0.00006563577797978914,
                0.002194759083373293,
                0.001454942593181389,
                -0.01764888485200958,
                -0.00044325018862707524,
                0.029545377100897215,
                -0.004122572250197021,
                -0.0033969762799413716,
                -0.000912726771933435,
                0.039722410872299385,
                -0.004621414770784809,
                -0.059930070339552055,
                -0.0002025259859408917,
                -0.14897632043896417,
                -0.002448720871114783,
                0.016879110304895042,
                -0.0009361430253339227,
                0.061495797283661384,
                -0.0026819146809170017,
                0.05391199951155029,
                0.0011731879925812852,
                0.042863633034379456,
                0.0007068760830083725,
                0.0394614289021065,
                0.0008472804124065617,
                -0.039979356408850655,
                -0.0008508315769382108,
                -0.0482692360283913,
                -0.0008953514754074673,
                -0.038153570813267285,
                -0.0008170335527376519,
                -0.0220950210754555,
                -0.005084351333017589,
                -0.027296448502192427,
                -0.008168439601655643,
                -0.0010065082671848538,
                -0.011871206738210125,
                -0.00132751336774482,
                -0.00007536312951516647,
                -0.007993207683341066,
                -0.000010422204128657524,
                -0.1075142251120278,
                -0.01744863006024029,
                -0.005401499431161594,
                -0.00002044119361635089,
                -0.005578018647434801,
                0.0000804820389153825,
                -0.005880318942593724,
                0.00011071633900860309,
                -0.007506928047822953,
                0.00023160124279896117,
                -0.0025024647604652344,
                0.00005311020775289625,
                -0.05453765973172903,
                -0.009498463299387947,
                0.004366226319726749,
                0.00008355614691004215,
                0.0044635012475411125,
                0.00008436072685574981,
                0.013089758412013295,
                0.0001305440800748755,
                0.0036523909067629244,
                0.0004882599640831582,
                0.004719233169693331,
                0.00019963267979760765,
                -0.16667434840363105,
                -0.03991927807194976,
                -0.0037476803224501887,
                -0.00011318095218186756,
                -0.007134660131689357,
                -0.00013200470364089077,
                -0.013402035732463638,
                -0.00018921634270503625
            ]
        },
        {
            'energy': -0.6324416344411612,
            'occupancy': 2,
            'alpha': [
                -0.06638213766183133,
                -0.09330342645855963,
                0.011515820344713759,
                -0.09471308707841013,
                0.007264554005882419,
                0.0025765948474339266,
                -0.022123998798760224,
                -0.039352714840453565,
                -0.014305993189045206,
                -0.026585886536850612,
                -0.03670183413908767,
                -0.0027689885171200534,
                -0.1390250900635682,
                0.08561274068309963,
                -0.047196967097332766,
                -0.020988786413571357,
                -0.010913836384106387,
                0.07304213700216448,
                -0.036932494025965934,
                0.02029588107860082,
                -0.06679323597101733,
                0.045512198016203424,
                0.049861628637557935,
                -0.04167475650294921,
                0.06779641756245333,
                0.032433243603690196,
                -0.014712989179706393,
                -0.01750433514476591,
                -0.06132954129519941,
                -0.017363087758556488,
                0.08045335787950147,
                0.03888414054706072,
                0.040248224565581685,
                -0.004931666210809812,
                -0.010012533827381914,
                -0.028723873635257188,
                -0.13277256432742768,
                -0.060327696614679634,
                -0.07874610993979772,
                0.008663257546089546,
                -0.04686178321485758,
                0.13187693415071325,
                0.028117043178686723,
                0.007241817918084416,
                -0.02612553752244333,
                0.008642685705722783,
                -0.06284839832707972,
                0.010765136257534854,
                0.04222334107798576,
                0.018388506446942395,
                -0.07120978538960536,
                -0.04386624220963103,
                0.04046985023476918,
                -0.10082306691482382,
                0.0165740946413812,
                -0.08864424805777128,
                -0.1796302465877518,
                -0.051939280062775366,
                -0.030801980844994543,
                0.020889682262707383,
                0.02007825439907179,
                -0.014924874459782043,
                -0.03794201693769005,
                -0.031395052120107556,
                -0.026447018638457404,
                -0.04497516985732256,
                0.012749478592729627,
                0.017916585912041004,
                0.11127856376587508,
                -0.0029526150886271933,
                0.024292158600305144,
                -0.014383770277481174,
                0.04109469576850301,
                0.002007192238946159,
                -0.0208257829701848,
                0.00219909012783788,
                -0.1139938202409571,
                -0.011222455151110002,
                -0.004393720014916438,
                0.0042108428238543825,
                0.07320488907659232,
                -0.04056260404833728,
                -0.04561365199032237,
                0.05627972721198839,
                0.0004569234669483708,
                -0.020343973349295098,
                -0.03358011814562816,
                0.03786219608780655,
                0.15370173909946155,
                0.07817236983758283,
                -0.003601642430693462,
                -0.006546545534778171,
                -0.01581799527826913,
                0.015949143493239813,
                -0.035337690343179975,
                0.031906255240538466,
                -0.06652937436928494,
                -0.053108820934939543,
                0.061738138309392364,
                -0.012556754217635874,
                -0.025801774377439954,
                -0.033656652355104455,
                -0.03085882341875365,
                -0.0724103435726786,
                0.09910501258201877,
                0.006997901309043639,
                -0.010214017471686924,
                -0.018651867932208653,
                0.09285675223378084,
                -0.000053462327524785285,
                0.027082516132539883,
                -0.003297491628158418,
                -0.06510923671162361,
                0.03309883797377607,
                0.032408736113412946,
                0.06406946091598206,
                -0.08312793743394274,
                0.037473480488207166,
                -0.045222634395120434,
                -0.0019835936341225965,
                -0.04508127802364846,
                0.01906213832506366,
                0.0722608474039458,
                -0.034051512822575236,
                -0.0648665405479442,
                0.03746069093236285,
                0.010463619094862204,
                -0.07240332674908415,
                0.08095860074491064,
                0.02651778256031883,
                -0.01945726873316435,
                0.009731338079275844,
                0.11744562537316192,
                -0.07921474252775723,
                -0.00831215349759636,
                -0.029401909047687233,
                0.03588316793088409,
                0.05139536851810376,
                0.029874349280340336,
                0.02223501164531907,
                -0.1785239068273162,
                0.0035758359290899403,
                0.012688076435702621,
                -0.006812523056656015,
                0.10215851030101432,
                0.046299907772344266,
                -0.022972282117143715,
                -0.003435692607321294,
                0.11052464129705603,
                0.003566179926811289,
                0.02820400437275393,
                0.019066290375119043,
                -0.08475380563004585,
                0.0500582723250037,
                0.05317059285086814,
                0.048646317083373726,
                -0.07031077528929204,
                0.09336431851969873,
                -0.011370852876347618,
                0.01749587341812735,
                -0.21116404107759942,
                0.010647797820493462,
                0.0011541425133940195,
                0.0035703488036494795,
                -0.08091295073296885,
                -0.002833388037105201,
                -0.09533607315268972,
                -0.002686977691518156,
                -0.02856274900551409,
                -0.00204655604255436,
                0.046909031564223914,
                -0.001402167946608079,
                0.04733344144841318,
                -0.0008773344131203895,
                -0.023222850332850323,
                0.000656393612019617,
                -0.03381282714161637,
                0.000057932895498259185,
                -0.006581408838991927,
                -0.0009775068531046843,
                0.028907370363391388,
                0.00014094496603464016,
                0.008693095001460892,
                0.000006325246487897635,
                0.01965356019993702,
                0.0009115756449011557,
                -0.05050388949576414,
                -0.0013011290298493834,
                -0.047162264032298735,
                -0.0017226074152840375,
                -0.03553021802305968,
                0.0005897267150583632,
                0.03151546270410215,
                0.0011771854950365383,
                -0.005500413664769834,
                -0.0005178658493676586,
                -0.03525553799548248,
                0.0011541694704000495,
                -0.04073608010447223,
                -0.00014126094191223293,
                -0.02080790893516346,
                -0.0006259936927182306,
                0.0022885755716671873,
                -0.00013948302376160933,
                0.032008590094126495,
                0.000022775901016139955,
                0.03148115845372509,
                -0.00012674871678990704,
                -0.06497244279283636,
                -0.0031269956350233035,
                -0.036222077030158076,
                0.0013146920201632234,
                -0.04954027896042999,
                0.001554707243226194,
                -0.004511037387290277,
                -0.00012283023656746035,
                -0.020980672460800754,
                -0.0004543690441178791,
                -0.030406608459317284,
                -0.0005048640585740104,
                -0.08128550912435409,
                -0.0006714403303169088,
                0.018822987875887917,
                0.004950179575121549,
                0.03490375807475875,
                0.0011212695064609804,
                0.01980245833312809,
                0.005011987514452234,
                -0.037928136375847576,
                -0.0009148465713520827,
                -0.03270859335189691,
                -0.0007657941238173879,
                -0.09340487730024696,
                -0.0011828872569608407
            ]
        },
        {
            'energy': -0.6301592168269776,
            'occupancy': 2,
            'alpha': [
                -0.07601029675290777,
                -0.11722888754618711,
                0.030279405396059163,
                -0.10033756093075594,
                -0.048826063283492885,
                0.10067850344988681,
                0.07830847704849306,
                0.032563614361810565,
                -0.0074408688151041446,
                0.003921939427961871,
                0.01966658552169766,
                -0.00811677287116197,
                0.10407698424881924,
                -0.04780576354402667,
                0.044623220096281405,
                0.017226001822405947,
                -0.010770144534727778,
                -0.064110006316825,
                -0.021287706627643527,
                0.009127323018883497,
                -0.015508245393048672,
                -0.03635447637130673,
                0.002074105166042195,
                -0.018104473621372616,
                -0.06315216711899321,
                -0.07826775706063584,
                0.05219264922500257,
                -0.1344283379601787,
                0.02886112246769947,
                0.01460911203019019,
                -0.06906150011676314,
                -0.04993432697198667,
                0.18572330968735767,
                0.027553945305657447,
                -0.01805521654880419,
                -0.027159295433537522,
                0.07363590558316502,
                0.02412639047016927,
                0.05307158722499337,
                -0.04159417764524088,
                -0.021995222473381325,
                -0.009357911389321414,
                -0.06337776706643942,
                0.0935170572846322,
                -0.020093715560239693,
                0.08182656864966462,
                -0.1484108132693543,
                0.03785873916973356,
                -0.01950523119783884,
                -0.004363477419093514,
                0.036694221171217366,
                0.041544134354382645,
                0.00353248450320999,
                0.07811755382913281,
                0.030986724616898418,
                -0.027357276530742942,
                0.01427852653283299,
                0.01992492831885092,
                -0.0031954797760845783,
                0.009020300748319058,
                0.03124129587314461,
                0.07227759604623056,
                0.015961590403020032,
                0.07593718706374676,
                -0.007187218645512578,
                0.03488604663963455,
                0.01656305739878607,
                0.02710499988122461,
                0.14908755027894036,
                -0.017850667467028118,
                -0.016502130101505478,
                0.010423016946739081,
                0.0871920082985821,
                0.02469369092999125,
                -0.048126150960254827,
                0.006650746993371752,
                -0.329296001861425,
                -0.005788211531339208,
                -0.010885842756586557,
                0.012194851636710672,
                -0.010978117241757951,
                0.015348353734194591,
                0.006383935303918501,
                -0.004619665212976228,
                -0.008945580020735531,
                0.016371955982684643,
                0.009383090621143961,
                -0.005224606311077449,
                -0.1029398908727481,
                -0.025383863762656427,
                0.0312889362302406,
                -0.00018634942606887434,
                0.014217823775667184,
                -0.006051135156806083,
                0.00045102992899700506,
                -0.0039547695871072165,
                -0.042280657720979595,
                -0.08418555773959747,
                0.07774111148802856,
                -0.008187032487818146,
                -0.05089419674222921,
                -0.04287222135042112,
                -0.055653535305864955,
                -0.08757389835756467,
                -0.016908792610540645,
                0.0011743021521615105,
                0.0012135024558551882,
                0.004197477552477289,
                -0.017355249930756975,
                0.003060745576323968,
                -0.002467031424638427,
                0.0003680266125578425,
                -0.10178182645238193,
                0.018969060579432952,
                0.04413938319704946,
                0.0663732931128208,
                -0.09829794270217473,
                0.05417174500056829,
                -0.06573890134205561,
                0.0031139069918666323,
                0.00811466094507951,
                -0.002934919344632013,
                -0.012205873302710642,
                0.006547768531515477,
                0.005892845825857768,
                -0.006035214292124607,
                -0.0019463199532735475,
                0.013002623445056235,
                0.09184588587508534,
                0.024685804781541917,
                -0.0047726051246547736,
                0.026180286047297944,
                -0.048592667968227435,
                0.051336873303363915,
                -0.0010914905360771632,
                0.011056122862562313,
                0.006889914623661249,
                -0.046178032961250136,
                0.0005408052221048948,
                0.00019097472876187247,
                0.029009692642054868,
                -0.0010962888903050096,
                -0.0012879828891050947,
                0.0028307636363851247,
                -0.050659786640080466,
                -0.030140710380487094,
                0.010679844557125092,
                -0.0014661367718624995,
                -0.06474263475231959,
                0.011953193584808878,
                -0.004070320956072301,
                -0.000040942448904521996,
                0.06393010480640925,
                -0.029384135291091774,
                -0.02766467042276527,
                -0.02639987896660262,
                0.005247806196360887,
                -0.05321115243065634,
                0.00843232988792463,
                -0.008902118792550286,
                0.11226006042258085,
                -0.01511566131348219,
                0.01084874936117568,
                0.00305256280803944,
                0.028169595317761382,
                0.003249190401453934,
                0.06633988157957482,
                0.002866870270169407,
                -0.0035511697253214057,
                -0.0009759077709007316,
                -0.030835822574230124,
                0.003914647495261054,
                -0.01863458517292063,
                0.0011122192192633694,
                0.08488380363653769,
                0.001197337386000499,
                0.019073635756807306,
                -0.000009557325296717311,
                -0.03291543774215198,
                0.0020867368834004744,
                0.07012669063801515,
                -0.0007621017620906917,
                0.01751773403716808,
                -0.00042005261635431163,
                0.027715794673175847,
                -0.0010918780516048464,
                -0.1448594049773303,
                -0.003260311152976648,
                -0.13085899918493923,
                -0.0039853318471626455,
                -0.11966163776983695,
                -0.005607877962429935,
                -0.017181312811710373,
                -0.00030828853819035403,
                0.0020869957724866284,
                0.001104418709802395,
                0.009264074246699677,
                0.000047260206005872664,
                -0.03809161627264089,
                0.00022611311561815387,
                -0.04113710149598355,
                0.0004265902469349269,
                0.05022382802583058,
                0.00878343016776171,
                -0.0059740092700947016,
                -0.0001103054132320005,
                -0.005694195467312281,
                0.00002427292499485517,
                0.052467493093618395,
                0.0032461004821964542,
                -0.06214033191107071,
                0.00166035388967814,
                -0.06022411483213299,
                0.0015983764037522288,
                0.0005014303799185698,
                -0.00011757991613233513,
                0.004024771169755181,
                0.00004988064387098694,
                0.0031042793132590968,
                0.00004932740333219727,
                0.013823125939194436,
                0.0000658924755546861,
                -0.010141687624846928,
                -0.0032884116319027283,
                -0.018419842421075965,
                -0.0006821698481974591,
                0.009696314683131216,
                0.002150632322587803,
                0.029339712795409728,
                0.0004729884060050191,
                0.0029954657007792685,
                0.00033297544401409497,
                0.05150550463030649,
                0.0004773721853843388
            ]
        },
        {
            'energy': -0.6255545611160874,
            'occupancy': 2,
            'alpha': [
                -0.003152654045685588,
                -0.007940908051095088,
                0.010896523254063489,
                0.00130653509398601,
                0.059388131769741455,
                -0.12101781715881609,
                -0.06270600471902354,
                0.005394579432968613,
                -0.13509960242761776,
                -0.25733683772464877,
                -0.004274487218694116,
                0.185188590485714,
                0.04678065936980742,
                0.011053567536600407,
                0.040715963451624565,
                0.0389048642617834,
                0.015357869389626631,
                0.37196044873240625,
                -0.029228833495173995,
                -0.01110873815306035,
                -0.1164500376366938,
                0.20638827203616922,
                0.13731064762922646,
                -0.05739473621105748,
                -0.000735114688386039,
                0.02781672871691326,
                0.052461034248671864,
                -0.0011513095307949714,
                0.008370446127768232,
                0.03281239190921503,
                -0.08303290990039128,
                -0.04271715013821491,
                -0.02308129675516649,
                -0.00516243459089859,
                0.007875947282024561,
                0.00358967164543836,
                0.04123034872354101,
                -0.04340745630183902,
                0.06422208767274792,
                0.030255279496870093,
                -0.011744859366548805,
                -0.008201658275300573,
                -0.0028275109854320264,
                0.019035188437504274,
                -0.009309760951286364,
                0.006988269288333454,
                -0.003091867298693741,
                -0.009835101248348964,
                -0.11590444563004099,
                0.013877201677396315,
                0.024817015513165504,
                -0.029650592779161353,
                0.031708932417059243,
                -0.012058157933876481,
                -0.005916770737473741,
                0.02542740043381311,
                0.04323190637188075,
                -0.01917023046550017,
                0.0005826897832211966,
                -0.00035922744161837343,
                -0.0273415678504322,
                -0.04267736782045492,
                0.0014229236303624562,
                -0.05600996017317458,
                0.003927565510694069,
                -0.08150470778889667,
                -0.08121354475051851,
                0.019911946363396823,
                0.008644104815383158,
                0.0018062385093665005,
                -0.007718008659887099,
                0.00023497238064747712,
                0.021338800650948442,
                0.0009244621886355084,
                -0.0032591963928222814,
                -0.00569788037304588,
                -0.022988340906680706,
                -0.00015211046585781723,
                0.000538992505754443,
                -0.00156419483951245,
                -0.0022477534597404878,
                0.007728721036690112,
                0.018091483969099174,
                -0.022613384967145975,
                0.11944922931491582,
                -0.23733554279809932,
                -0.05613824047203029,
                0.052517256971787656,
                -0.038699465013416874,
                0.033730109265582106,
                0.03513480383137449,
                0.04515484412239285,
                -0.07324360265965868,
                -0.008570388828219934,
                -0.09968726001104847,
                0.05661208556557321,
                0.010720139862319435,
                -0.005888714506510647,
                0.003659147015271889,
                0.00024018888091040442,
                -0.015578794519190834,
                -0.0003804193708536608,
                -0.006054000719436034,
                -0.005971218174579809,
                -0.030124552433740043,
                0.0016339917397663036,
                0.004287562720291299,
                -0.005340020048713934,
                -0.02992944860691729,
                0.00022312985690794862,
                0.00035482585171572184,
                -0.0029069561942671237,
                -0.011091400970780511,
                -0.005881693044121676,
                0.0031168430862697706,
                -0.0033764902590429323,
                -0.001860160888843578,
                0.009785786102744809,
                -0.007051947274852182,
                0.004376830088170382,
                0.0008991863359583905,
                -0.006763435992617182,
                -0.023855510048789982,
                0.011156309708866422,
                0.011140463290417693,
                -0.013161416639244574,
                -0.0044065410154786495,
                0.024359673180106036,
                0.0037042895183636033,
                -0.0016447613243604335,
                0.00958088954257765,
                0.0071253039319232716,
                -0.006232078413026852,
                0.03178508577502106,
                -0.02862041106486842,
                -0.00963356857444025,
                0.07641062212345831,
                0.23902539377360235,
                0.09104892070133018,
                0.06202023594031594,
                0.05114265838200374,
                -0.002690732638684478,
                -0.007707137401042075,
                0.004448267379971097,
                -0.0208299494981052,
                -0.03499959797399465,
                -0.0035364380075637914,
                -0.011538358657884157,
                -0.01680834620400758,
                0.03128760673873413,
                0.016664082494531954,
                0.01966255040510317,
                0.07526507949502871,
                -0.017396405675648416,
                -0.009146403565688566,
                -0.010709208834698223,
                -0.06167212709375486,
                -0.01689139958111695,
                0.010660178976454238,
                0.002559103523129168,
                0.03932387735923376,
                -0.023578008924043457,
                0.03420338256143223,
                0.016362104392178153,
                0.027736439959597525,
                -0.0002664591054778062,
                0.05296423150189397,
                -0.0026917233484793075,
                0.004815382083110718,
                -0.0007980618089106382,
                -0.03829614841638636,
                -0.0032680766779205166,
                -0.05631310937299968,
                -0.0021772239500819973,
                -0.054330598810590776,
                -0.0016998480469506611,
                -0.08091044618994914,
                0.0038618347556138638,
                0.02507458522569155,
                -0.002191239085276662,
                0.010621442526343233,
                0.0002101026942407078,
                0.010763192121440435,
                0.00016474672786227006,
                0.008232250969798679,
                0.0002571272643429515,
                -0.008404109579740825,
                0.00001374908178531785,
                -0.009294163943017535,
                -0.000023422640865441312,
                -0.008578713894851318,
                -0.0007750782919885286,
                0.19925144615026924,
                0.007403583943400484,
                -0.0608409669185892,
                0.0018597536017483213,
                -0.07438379194582097,
                0.0015199267241323546,
                0.002495422654705969,
                -0.0003626490117461841,
                -0.009492055447143453,
                0.00012825847571175825,
                -0.06056316911113302,
                -0.010944058449954566,
                -0.009609417761481009,
                -0.00011931835264755955,
                -0.010715528463031365,
                0.000012714463846490267,
                0.058287602875711886,
                0.0032757208020538922,
                -0.007639031084213974,
                -0.00020727326672399758,
                -0.0006529335091897062,
                0.000003961378254416096,
                0.11647095946958232,
                0.021007394959932077,
                0.0012705477257309694,
                0.00006313886116814626,
                0.006371552621978876,
                0.00006164531182434529,
                0.0262658977537797,
                -0.000013220417656902629,
                -0.013795528975525159,
                -0.00019223924035717237,
                0.002324307135793364,
                -0.000639351646596872,
                0.020833239615873012,
                0.0056221284058415285,
                0.03539352467274915,
                0.00007253702069559617,
                -0.03104812187604297,
                0.00017195340843934284,
                0.018811322498566485,
                0.00009845795259271706
            ]
        },
        {
            'energy': -0.6252247372373665,
            'occupancy': 2,
            'alpha': [
                -0.002703841844397375,
                -0.0025536258158373893,
                0.0006623201610826118,
                -0.005951849952905044,
                0.00710748534354034,
                -0.015752490196866243,
                -0.029638934818568868,
                -0.013161741228393333,
                0.03863153819954899,
                0.06375960818374604,
                -0.009907770221463785,
                -0.03995596945776497,
                0.13004897989438957,
                0.048341008276460415,
                0.14395780592260002,
                0.08406179806975392,
                -0.0015785654208597313,
                -0.07115952631834897,
                0.013364426797882254,
                0.0028414352811138134,
                0.03261219223808093,
                -0.03950055967776628,
                -0.03557611369527648,
                0.01934438500773544,
                0.024262974942150052,
                0.04661876310212271,
                -0.03914251100627466,
                0.07449652356511219,
                0.02055287073768548,
                0.10859430389289235,
                -0.23668179808785264,
                -0.14155495217524455,
                -0.020653214618270035,
                -0.07185042011957488,
                -0.025087692485796845,
                0.02457433759195767,
                -0.03324251409918676,
                0.009709822431459965,
                -0.04822725928431693,
                0.03690319020618926,
                -0.028226920038348095,
                0.07884864850716776,
                0.05214843504634338,
                -0.04820126626020794,
                -0.04083773918599733,
                -0.05600532788487837,
                0.013790239425875378,
                -0.0090633445532561,
                0.02868149998115136,
                0.001548628073709026,
                -0.02272655923172589,
                -0.0009722387272063426,
                0.07708587610234428,
                -0.03164808790520069,
                0.04170512147763385,
                -0.034863830789972294,
                -0.1300350711412264,
                -0.03706249021366256,
                0.015905825625893495,
                -0.03508442331544015,
                -0.006617807005757755,
                -0.021185154697605724,
                -0.0020282189079747774,
                -0.023804189527882245,
                0.0023002041145547955,
                0.003717185446300414,
                0.013826777267900795,
                -0.020049435664216603,
                0.001039333637184365,
                0.02289851636272124,
                0.017111187847211724,
                -0.014641016285401461,
                0.012403596821962983,
                -0.021285425768933903,
                -0.004872079073680044,
                -0.007116040637414086,
                0.0764571095240891,
                -0.018837906126309454,
                0.0027996922909092306,
                0.0002642172868787394,
                -0.0014690043718854147,
                -0.046199256093666236,
                -0.04590552308769901,
                0.055810196828998064,
                -0.025541135955980565,
                0.05133176306101857,
                0.00670144618405676,
                -0.012193453795902653,
                -0.10858999506680686,
                0.11786782954518506,
                0.1347777401712101,
                0.08910680314795781,
                0.012793292969965205,
                0.0017598904272749392,
                0.02517404453372751,
                -0.012029559451199018,
                -0.004594430605655096,
                0.004433374626573436,
                0.007649956628705854,
                -0.005663760114351518,
                -0.0003206969420434436,
                0.0049504517589268405,
                0.0035122966549376734,
                -0.007816904478250059,
                0.08721491884535783,
                -0.010351676410898342,
                -0.008570329000727534,
                0.011083153514026202,
                0.08418416677387558,
                -0.008363874919963647,
                -0.008661631682217901,
                0.00661345142022713,
                -0.0033198303079692154,
                0.0037742197725040266,
                0.003196728863913322,
                0.0015216365242035584,
                -0.004744098352640927,
                0.0026512981044470568,
                -0.00006349648466623777,
                -0.0026231993629087145,
                -0.007388171287888982,
                0.018060688461488204,
                0.06888944144243807,
                -0.033258595517131465,
                -0.021170573641519284,
                0.03598775394171199,
                0.010390338870099875,
                -0.07072042550143508,
                0.0028254195722991512,
                0.0033033859171482456,
                -0.00047720175507762403,
                -0.001327364878560513,
                -0.01606770731057354,
                0.09167505360729124,
                -0.0887998869652112,
                -0.03796345069902971,
                -0.02133597561724329,
                -0.044680745156654406,
                -0.024263478858097837,
                -0.015707690014913175,
                -0.14485222960236732,
                0.008164646789494932,
                0.017880717783793385,
                -0.01590068604208145,
                -0.05849492678934569,
                -0.1067914065748942,
                -0.011460079055215837,
                -0.03756721923870483,
                -0.03870546464124403,
                0.09614759588918743,
                0.052138381032081925,
                0.059594230562793116,
                0.22737118974276188,
                -0.049927436007659344,
                -0.023510603792402426,
                -0.029352654451007862,
                -0.19294653626020408,
                -0.042102216785068085,
                0.03230881831307888,
                0.009827731397388488,
                0.10411429926130919,
                -0.07107967209927461,
                0.10640440079258236,
                0.05129848713297776,
                0.00336224120894327,
                -0.001487155734275101,
                -0.05648886836060129,
                -0.0009212440594197084,
                -0.04738801470362733,
                0.0007410758813027651,
                0.013117585843445367,
                -0.0010686797912635828,
                0.02320403625779833,
                -0.00017013970952824473,
                -0.02540159832353715,
                -0.00020825445043802914,
                0.011650062286861511,
                -0.0010147951650071464,
                0.010517451913480951,
                -0.0005241385240518506,
                0.0017421600423411755,
                0.00046889910122783595,
                0.006202426077066246,
                0.0004243138253610593,
                0.020818503535123007,
                0.000730792675176667,
                0.031774999317922534,
                0.0007826531920548212,
                0.0298488101172454,
                0.0003143195529634792,
                0.043342298113931706,
                -0.0014346475323789392,
                -0.04079833229561415,
                -0.0018047738465355693,
                0.012725125604248703,
                -0.0008018954414778385,
                0.015552398355534227,
                -0.0003090939980444352,
                -0.0023895166811123835,
                -0.00004985983927610363,
                -0.0007776811216388503,
                -0.0001708903247443573,
                -0.011730253800537105,
                -0.0018516806677713819,
                0.030919598841739247,
                -0.00017245927072682892,
                0.03287608845729273,
                -0.00001778799150386291,
                0.1753532946756955,
                0.010029321675483113,
                -0.0018950247696971777,
                0.00016776840536978887,
                -0.003051751625258706,
                0.00010142958636135496,
                -0.028844780151644583,
                -0.0051364269422613336,
                -0.005764406351211027,
                -0.00014993863894829655,
                -0.012406690560890917,
                -0.00019351546165829382,
                -0.07465266888008065,
                0.00007034750711458213,
                -0.041657415907549664,
                0.00006871453772757576,
                0.012267316042063922,
                -0.0018293443627778005,
                -0.00794578031427475,
                -0.0019671672997035572,
                0.10723179387157891,
                0.000150289302530388,
                -0.09767329786531445,
                0.0005039153333965595,
                0.04973530559078156,
                0.0002642619510002611
            ]
        },
        {
            'energy': -0.6215182300064087,
            'occupancy': 2,
            'alpha': [
                -0.0032949099138327343,
                -0.0057120420704175195,
                -0.005122929414738091,
                -0.007948881197521226,
                -0.06225099111147225,
                0.10527258581809465,
                -0.08855278940340564,
                -0.15156219778535393,
                0.057225974285179025,
                0.08646942828785097,
                -0.13760491998414412,
                -0.15730771594129828,
                0.008384810752038625,
                0.020376338711447752,
                0.005478707990490281,
                0.039407738135318865,
                0.05127992873463525,
                -0.12516309941291417,
                -0.027013856573738584,
                -0.1310944298606774,
                -0.16053253330677755,
                -0.07528778271335669,
                0.21075862456063513,
                -0.11773942357641806,
                0.024330658052455423,
                0.06220674905820813,
                0.034860496186205014,
                -0.07499577540647534,
                -0.002876041169234147,
                0.039906773000837864,
                -0.048504634520564305,
                -0.003992228985058134,
                -0.05717016844903642,
                0.04458431799191775,
                0.020111607096177594,
                -0.023681954862140548,
                -0.013187120076510657,
                -0.0903884243882618,
                -0.054071052800484826,
                -0.02775651388794567,
                -0.026419026168267724,
                -0.020361847011572166,
                -0.03375854542635386,
                0.03338149501635574,
                0.01395802983596718,
                0.026378849050574707,
                0.016687198796389184,
                -0.008252178050531533,
                0.04359483679454299,
                -0.0580936774913434,
                -0.06997480168267102,
                -0.06019241383709812,
                0.0062176335404628595,
                -0.045052166505245225,
                -0.04452732986272995,
                0.05389178619073558,
                0.1099782970881484,
                -0.037554310317830256,
                -0.029951648461918147,
                0.028484784239531397,
                0.011832974159272805,
                0.0456975030622899,
                -0.0781363399698648,
                -0.15852866264395532,
                0.06509665908264388,
                -0.06895532750975641,
                0.15840993868345377,
                -0.013208539425605905,
                0.012954481715984583,
                -0.005227712768168306,
                -0.00800649683058304,
                0.016045696918969794,
                -0.019748559443309815,
                0.01137626643876374,
                0.006494805489731112,
                -0.0003096683180425396,
                0.003226014140212355,
                0.008877059181529822,
                0.004645878108009052,
                -0.0032057976921164885,
                0.03151340624802391,
                0.03080774943043831,
                0.05007738211012826,
                -0.06774421463629245,
                -0.10686825376611761,
                0.08742782626256033,
                -0.050020826632985835,
                0.12826153381432615,
                0.008701797236783658,
                0.027830693443346054,
                0.0009876260589348376,
                0.052787005703622936,
                -0.1224271066129728,
                0.026041214174925054,
                -0.14927813883168298,
                0.12423826343107908,
                -0.00835603432746685,
                -0.010548057895577001,
                0.00795865854934256,
                0.004883961826191078,
                0.0057367596830090115,
                -0.00592074454756504,
                -0.010095238480301577,
                -0.004456615050052631,
                -0.09090114161693415,
                0.014184109890745755,
                0.008404770992387896,
                -0.029791801936233306,
                -0.08951795444749279,
                0.006730471640260785,
                0.02534760535221824,
                -0.014912279100981198,
                -0.008399052682674192,
                0.0013458410453611278,
                0.004987242969876225,
                0.010287377847581323,
                -0.012378323210423377,
                -0.0028236677522645312,
                -0.005984799664229767,
                -0.004468865639388686,
                -0.008947066252975071,
                -0.020788919353884716,
                -0.07766467812608996,
                0.03515566481460801,
                0.005636387736237739,
                -0.04190160626756699,
                -0.010298037277461695,
                0.07891616739004399,
                0.004914930181222412,
                0.0014920465376560684,
                -0.00690415608238086,
                -0.001056695303546536,
                -0.005905293255798372,
                0.004694218801507694,
                -0.03554037851497599,
                -0.01764654241332151,
                0.11628126925261277,
                -0.09926268930531892,
                0.13525943369085777,
                0.05451670924008427,
                0.15144242116859916,
                -0.01189108663397567,
                -0.022844571449461174,
                0.021212292395864557,
                -0.0016987414544641375,
                -0.032545137571842624,
                -0.006171313882377887,
                -0.011470257869157943,
                0.023698302832909073,
                0.02309398006383668,
                0.010245751733040927,
                0.014212780471154405,
                0.056679291306732944,
                -0.004608475926995504,
                0.005536262541765699,
                0.0027761070399948237,
                -0.05631950026188107,
                0.015472592853362615,
                0.006667529723803665,
                0.008920093900929201,
                -0.013836575961436141,
                -0.014509383420854413,
                0.03279070617516498,
                0.018024149143864243,
                -0.06551289436824836,
                0.00022656234163638048,
                -0.021612333056256993,
                0.0031363137743109586,
                0.029305464938549762,
                0.00003983598495137979,
                0.08644685640029443,
                0.00008057735702476728,
                0.022271234094039857,
                0.0005090166302308418,
                -0.08551304673459748,
                0.004680076889606295,
                0.04699063299905472,
                -0.0019059387259746524,
                0.0416637889729403,
                -0.0011454667982136863,
                -0.005653324063754369,
                0.00009773193575149672,
                -0.0049206698229346865,
                -0.00005817977919211148,
                -0.017437928174314065,
                0.00016359247984166505,
                0.004759349774309644,
                -0.0001330473974611233,
                0.0023971207498068915,
                -0.0002640798690176861,
                -0.006238344772409224,
                -0.00010615751784569823,
                -0.04446413766318275,
                -0.005328556837960806,
                -0.07248654780386005,
                -0.005855853943314179,
                -0.1447530894022951,
                -0.005727894645441181,
                -0.007945519737309233,
                0.0002539081460120142,
                -0.0017825663338384668,
                -0.0001972651886244597,
                0.03377020055765174,
                0.006761784545367436,
                -0.033261599338206035,
                -0.00022031197749825934,
                -0.03522834094888026,
                -0.00014042504485836142,
                0.039272707574567425,
                0.0019092757391867166,
                -0.0065948139586444075,
                0.00034680041204289224,
                -0.010040763800775804,
                0.0001058418644437556,
                -0.11205587268294258,
                -0.018011487884552063,
                -0.0017092390971532004,
                0.00011788132209888656,
                0.005565027619855441,
                0.00013717492216082567,
                0.08266667074365305,
                -0.00027968860238610925,
                -0.00869308701819019,
                0.0008860605519462905,
                0.01761198757183295,
                -0.00016455028731601767,
                0.011979797447078727,
                0.004418817342774608,
                0.027481177722338684,
                -0.00009394129317033954,
                -0.03033985399803973,
                0.00009820743818896903,
                -0.00807062281679774,
                0.00006244021400595521
            ]
        },
        {
            'energy': -0.616214728974623,
            'occupancy': 2,
            'alpha': [
                0.0007040869265900363,
                0.0010524101211544837,
                0.007817680787384826,
                0.005067961225921997,
                0.0016381642204469338,
                -0.023409408988340888,
                -0.0522451696413946,
                -0.08283947692320129,
                0.022778700241817034,
                0.02440781908875951,
                -0.05655958224523029,
                -0.04945772626224205,
                -0.003686783872049324,
                -0.018583255953519135,
                0.01669254120653939,
                -0.03498098893083332,
                0.04588672281709621,
                -0.016928888881409834,
                -0.004890827653958135,
                -0.10762155839763828,
                -0.1184101628405352,
                -0.01262340063790086,
                0.16445917232893795,
                -0.0907775924954498,
                -0.07273779459883248,
                -0.012341530275411964,
                -0.018406739033922558,
                0.07530839816257655,
                0.008107765910128323,
                -0.15632555457683156,
                0.03177072987350282,
                -0.044456719326934575,
                0.06009383741365269,
                -0.10833775951597693,
                -0.041701625263092436,
                0.039827177191568565,
                0.11435482631407128,
                0.08157904018430553,
                0.05696209237160971,
                0.027087567260788634,
                0.02637011395970296,
                0.0007245450419340185,
                0.021911333039057984,
                -0.017447705749578834,
                -0.038141985110005674,
                -0.04633383159082656,
                -0.017475421487179517,
                0.006102146071696034,
                -0.01331603186118075,
                -0.034892935866265636,
                0.036658891736628174,
                0.015427824936876122,
                0.08342996679136153,
                0.07786170748605763,
                0.06280082355090164,
                -0.0357623863609985,
                -0.06337836269596059,
                0.03446880413953915,
                0.06057458242375925,
                -0.06737521393311166,
                -0.049600204803527184,
                -0.008061844869292487,
                -0.02854684197159327,
                -0.09885507814794574,
                0.08986725726859883,
                -0.02412041493800244,
                0.057511970569587935,
                -0.04738553918290316,
                -0.008493536733083116,
                0.004777347906655741,
                0.007493411467663418,
                -0.014899576670083516,
                0.027385424412542256,
                -0.01823668223917371,
                -0.010675545792493104,
                -0.004749807405430275,
                0.011335177964869776,
                -0.018001046208005238,
                -0.003173825244657915,
                0.0044939648561776865,
                -0.0822253841672352,
                -0.032755703907635596,
                -0.04101931117410819,
                0.06519389436558058,
                -0.04257359386025627,
                0.012227471578348794,
                -0.007406648188161755,
                0.058971027151744994,
                -0.05217810224897836,
                -0.016766199259813555,
                0.03550294120952715,
                -0.03789490828544356,
                -0.10239667851714208,
                0.005945505128273656,
                -0.10554083800599091,
                0.08529482611705723,
                0.009513364928422294,
                0.008350004437574134,
                -0.006379869627256701,
                -0.004626903318832635,
                -0.008088658744868143,
                0.003956883812861445,
                0.009142383240959796,
                0.0000569680471805397,
                0.09933837144525086,
                -0.027771756907530247,
                0.0005070087309225315,
                0.05455568927683497,
                0.08956237216418889,
                -0.012469517419052348,
                -0.06130114671012914,
                0.023026736226195842,
                0.005970772849596816,
                -0.002251707732449142,
                -0.003991011570017509,
                -0.009305576142440807,
                0.008160588765006459,
                0.0057619760257421986,
                0.0038183885111418127,
                0.005215134269457156,
                0.030641919920632397,
                0.022300203714771004,
                0.09461557061228304,
                -0.037619058467176954,
                0.031210798478732517,
                0.048051322186627485,
                0.002838479694571053,
                -0.09136657689371622,
                -0.002219106620037701,
                -0.0005549902244762613,
                0.0074030164856983376,
                0.0026599262193722725,
                0.09271657680516833,
                0.03171075705823116,
                0.09858420116309533,
                0.06745042555638045,
                0.08734920379243974,
                -0.02492579879780532,
                0.09936618154309883,
                0.04925584248481036,
                -0.16027140081725874,
                0.01756330378844131,
                0.024240452186822588,
                -0.032199355073375395,
                -0.03426924390826239,
                0.1195387756587088,
                -0.001748347500692843,
                0.02907154010583707,
                -0.1441166135899606,
                -0.03615394022082742,
                0.021495831993716078,
                0.0027965504106825098,
                -0.15614389730441533,
                -0.009851614881417135,
                -0.0562001961223807,
                -0.04048042394473134,
                0.1010808970406944,
                -0.11928309500171001,
                -0.0009138345822869962,
                -0.03327907126525264,
                0.13743481924316583,
                0.013218456326133214,
                -0.090319194268471,
                -0.05665594614438544,
                0.10266629704617367,
                0.003931600846939443,
                0.05762673576834559,
                0.003791042119308374,
                -0.045490260633959306,
                0.0017816064029962232,
                -0.0082336526785843,
                0.0000632415492927575,
                -0.02807199066600034,
                0.0008604502735555975,
                -0.08359309057462393,
                0.00010355270676455828,
                0.050769445469316846,
                0.0004567435311009337,
                0.06638371325454039,
                -0.00041621049767776535,
                0.00953749809069691,
                0.0005923304895987806,
                0.00912685437261223,
                0.0002348660066106239,
                0.02545045724282204,
                0.00003877984777692083,
                0.0009307564830433073,
                0.0002842666073371869,
                0.003874126364490263,
                0.0005371192974876982,
                0.018150240770190416,
                0.0001770029655125205,
                -0.010869603914807704,
                -0.0021240035131704017,
                -0.06647285926697635,
                -0.003972142383481263,
                -0.10378797710408491,
                -0.004759630403471802,
                0.007697899171124127,
                0.00024631507797519107,
                0.0011202559663421395,
                0.00021647129739665565,
                -0.009600689007680284,
                -0.0016932384914653553,
                0.044326691066120104,
                0.00034194456347274037,
                0.04016388585995331,
                0.0003456082417417111,
                -0.08551196618632195,
                -0.004698920542087293,
                0.004403883972393248,
                0.00008667977427035989,
                0.008174739598435449,
                -0.00007852004388439079,
                -0.04008854015134157,
                -0.006156926187198759,
                0.01387407258548059,
                -0.00007832664815573138,
                0.015140055322810696,
                -0.00014611000571326476,
                -0.09376325343604287,
                0.0004618934950765737,
                -0.005891182060288702,
                -0.002000107642194377,
                -0.08990227726205073,
                -0.0007013121075379417,
                0.0014738470571357572,
                0.0016358547930546347,
                -0.08143103872795472,
                0.000285015816502318,
                0.0582129701892773,
                -0.00010220899019825527,
                0.07965801815032365,
                -0.00047416732289143386
            ]
        },
        {
            'energy': -0.6120696574091768,
            'occupancy': 2,
            'alpha': [
                0.01106130555746164,
                0.007430828212192425,
                0.001318909841208864,
                0.007178528436428847,
                -0.0058263339493349695,
                0.023013658846045157,
                -0.007827329685823784,
                0.021930803024189444,
                -0.005462069737978697,
                -0.008475701330328158,
                0.004030331531766184,
                0.017573658077820492,
                -0.06187082977538818,
                0.06771080535469912,
                -0.007703632195194237,
                0.03947169295211987,
                -0.02365875599995884,
                0.006740762799691504,
                -0.00012881564351476224,
                0.05691877883737611,
                0.05734944188564504,
                0.0041143697375627605,
                -0.08060382642247468,
                0.04816186280074416,
                0.08042545034519727,
                0.03942019411463161,
                0.035115844392106445,
                -0.05324079050628501,
                -0.013369463179756985,
                -0.14550489751957024,
                -0.02672754777356859,
                -0.0435916598040386,
                -0.07908012623096423,
                0.030407707150775565,
                -0.01606871084649897,
                0.06376390493480434,
                -0.06523613283400796,
                -0.07827137070527625,
                -0.06677665182184386,
                0.010972772957380585,
                -0.16518844694220505,
                0.021201309350607947,
                0.030628211820235257,
                -0.028324186729038962,
                -0.09495346988280355,
                -0.04032563063197735,
                0.03715309462830562,
                -0.05224043210927021,
                0.011967937154870052,
                0.014283688803641148,
                -0.045079815324628694,
                -0.017720979113285552,
                0.08222099056245093,
                -0.05350118464871706,
                -0.017460196958447735,
                0.06771668946619201,
                0.02900093220942776,
                -0.13705977663130778,
                -0.006387506005670545,
                0.0007080638466200849,
                0.031314876455958165,
                0.0032476053513719443,
                0.006609826454954482,
                0.017325966623875515,
                -0.0502265712974524,
                -0.009474721862871537,
                -0.013010011617926852,
                0.02368653605882035,
                0.062061978221867514,
                0.09718757215026942,
                -0.016059669814091338,
                0.07165791539510415,
                0.07307214100985077,
                -0.022062052530603386,
                -0.004017996726063732,
                -0.047490892200802805,
                0.10611070385930597,
                -0.02771089266006111,
                0.029780055288405747,
                -0.017097356827708843,
                0.08063129665843513,
                -0.03211819495723454,
                0.07403744487008924,
                -0.01061327626617872,
                0.015618983041590281,
                -0.004094419895624594,
                -0.014573025911192982,
                -0.016332782029542938,
                0.012933833516260842,
                0.04342297713188368,
                0.0345398051147302,
                0.07734467896767794,
                0.04866552934063266,
                -0.001750328012843268,
                0.04686247801869512,
                -0.03715642498483082,
                -0.013070167510990762,
                -0.03769622638224282,
                0.09595210424822131,
                0.03790585489049422,
                -0.017022714222857012,
                0.01221853242529265,
                -0.08435147204071289,
                -0.06898157649493633,
                0.003842646567421369,
                0.03358096034468003,
                0.01451609879332723,
                -0.08563993615454549,
                -0.10687968404658414,
                -0.019155545978811646,
                0.033406889494977686,
                0.01699569055294403,
                -0.08733613748905385,
                -0.028362869146560235,
                0.07513715094378452,
                0.03495820923727296,
                -0.08586928495685438,
                0.01575061505059928,
                -0.07105177398072691,
                -0.0501788991555965,
                -0.10984739701713077,
                0.0013889969103760783,
                -0.04593386264802804,
                -0.011104007199262666,
                0.03938420857928095,
                -0.0443886326675123,
                -0.016379082351642513,
                0.07815848164677804,
                0.02144102117819876,
                -0.014074057539500206,
                0.006310457285027795,
                -0.012154071792951157,
                0.14659713989135872,
                0.03639143520925386,
                0.0506885695643998,
                0.04653364115898826,
                -0.04260947026395996,
                0.010831239262760705,
                -0.046675686852150844,
                -0.026007901874638258,
                0.08881647986088911,
                0.0038096901887058024,
                -0.06954363291785462,
                -0.014162837235553675,
                -0.06721459246233963,
                0.11982698799124916,
                -0.03350850400525597,
                0.01101684893003433,
                -0.12941129499108664,
                -0.00267708993403189,
                0.06988236935734235,
                0.046348151481672,
                -0.12704255178236776,
                -0.022799890351638888,
                -0.07825061822221058,
                -0.05785851053146282,
                0.006170117790068105,
                -0.13000978217933365,
                0.023490716434791937,
                -0.019292740012529702,
                0.15676807965961154,
                -0.01349791491946873,
                -0.05692368375954252,
                -0.04131217702359078,
                -0.061797673818098295,
                -0.0037533192523180057,
                -0.06548746829853988,
                -0.003333636543832435,
                -0.04609637075818267,
                -0.0012505278517875578,
                0.01601844559207004,
                -0.0012841019860159713,
                0.026196980441380115,
                -0.0012138175174539341,
                0.023651141579698567,
                0.0006456905963680556,
                -0.034538008305616374,
                -0.0007308172230660441,
                -0.02928754172275698,
                -0.00060904194233973,
                0.02592358166005467,
                0.001085206063344699,
                0.0546348088908958,
                0.0007264767516506058,
                0.04218111709841254,
                0.0013912568211717673,
                0.0639680899859134,
                0.0009718199202058429,
                0.04341851920973168,
                0.0010319794849945267,
                0.05061898935427154,
                0.002375649680235696,
                0.011777774500048301,
                0.0006041667905704878,
                0.03168664382041375,
                0.0018325466501587849,
                0.04695759930850978,
                0.002632528298241636,
                -0.06362522924687763,
                0.0004151933027802473,
                -0.06401236493506576,
                0.0006437074384528065,
                0.0014119539182723864,
                0.0006850777024548845,
                0.0052142618842101526,
                -0.0004866990552853921,
                -0.07053017592974957,
                -0.000053975045352468624,
                -0.06641088011768786,
                -0.004721695875085828,
                -0.0896165568116006,
                -0.00007028956588695954,
                -0.0894014099707565,
                -0.00009636301510700951,
                0.011422369004414025,
                0.001661747520029328,
                -0.06418510491798021,
                0.00027020703289136,
                0.023154746046456027,
                -0.0000658664460450422,
                0.05380238112130102,
                -0.00026706086794937514,
                -0.048107165518511054,
                0.0019858050276558093,
                -0.08851796189180881,
                -0.0008709243591928287,
                0.0009204079298819606,
                -0.00037004281068218583,
                -0.07264132910237928,
                0.000027208127952874263,
                0.001095959059743846,
                0.00011623598976088141,
                0.09284024285521135,
                -0.0005400648173059475
            ]
        },
        {
            'energy': -0.6107777485604042,
            'occupancy': 2,
            'alpha': [
                0.009668976931319732,
                0.016932667407205892,
                -0.020489647974807,
                -0.0005224346812419738,
                -0.0031345579012887646,
                0.006045919048053084,
                -0.004685931286443248,
                0.00848949017980563,
                -0.0035911877025762897,
                -0.006798864469202996,
                0.0016113328166514345,
                0.005835481106524662,
                0.012468969911904488,
                -0.008204647634479112,
                0.005831158037139714,
                0.007750091113910797,
                -0.0025038520662949643,
                0.004679626664020976,
                0.00003388671601904212,
                0.006449874296828809,
                0.00589315880883255,
                0.0022112007053649877,
                -0.008295020438115273,
                0.005285370680548631,
                0.01693194351962577,
                0.00548921908453816,
                -0.006291744416706329,
                -0.0320619076140176,
                -0.005054318224079196,
                -0.023471495841180683,
                -0.0076408793480421166,
                -0.006108326733712264,
                -0.026353670950809156,
                0.014363277470780807,
                -0.02543090718799715,
                0.027237208501797394,
                -0.001054894153066981,
                -0.012882242885956354,
                -0.013800365322266481,
                -0.004764128639813145,
                -0.05981365641558036,
                0.0011541929363766974,
                -0.020365943204775982,
                -0.02935641779261949,
                -0.045723849935687934,
                -0.018667172895689962,
                0.0175913907310809,
                -0.02277736433358389,
                -0.0025260788193909403,
                -0.005145725342612457,
                -0.0012719858561902413,
                0.0005240966148766017,
                0.02581876353823528,
                0.01030731000852446,
                -0.031257104778898884,
                0.01319115137198123,
                0.014564926128450947,
                -0.015758802660448917,
                -0.07008157734713093,
                -0.059440336954333824,
                0.003108864322495167,
                0.003706664821018114,
                0.0071344540282195276,
                0.001596254288713062,
                -0.005974985301933983,
                0.0006849486348745231,
                -0.002218939324244264,
                0.002897219482935221,
                0.024260685084225516,
                0.04149512061186136,
                -0.0093591217264771,
                0.033985262186242926,
                0.025859622559969025,
                -0.010733998586235851,
                -0.002432132636434086,
                -0.020051299069740004,
                0.056335267222202424,
                -0.014099605179204718,
                0.016363268811817596,
                -0.008381989655071535,
                0.0007180009689472493,
                0.052986243831102224,
                -0.19536062826855904,
                -0.13593068395678817,
                0.004919950410625905,
                -0.004364380417904267,
                -0.002537791687518074,
                -0.0018537076752967844,
                -0.012454658225956821,
                0.0018958781617271748,
                -0.0003921678906448459,
                0.01350937628295198,
                0.004849668114317407,
                -0.001911837716449896,
                0.004637587415976577,
                -0.004004482658795737,
                -0.02402426515504937,
                -0.02251165672271353,
                0.04625412969352089,
                0.018973344773401644,
                0.008386616125876576,
                0.012198823210048124,
                -0.03628120123779789,
                -0.023191509499836487,
                -0.2331842048926145,
                -0.059616191646950936,
                -0.08054210427610951,
                0.10303981258489246,
                0.2108132060885912,
                0.06092390345863422,
                0.08634853324403155,
                -0.1197171213399729,
                -0.03546207220346158,
                -0.0038138869777176215,
                0.035510012924385465,
                0.02889108987823692,
                -0.036996603606858795,
                -0.00686481872026847,
                -0.026095085138976702,
                -0.032786670332804614,
                0.2534231776910819,
                -0.05804293109243196,
                -0.07413327066528531,
                0.10547512567106337,
                -0.26017723618503963,
                0.039467438908947446,
                0.08279348520110068,
                -0.07353959009574537,
                0.007994388846256473,
                -0.0058551695430513456,
                -0.011468856028911685,
                -0.017553554128834876,
                0.024479536474646683,
                0.0009453293132229166,
                0.014328267258366514,
                0.010960027636237124,
                -0.004425842826133864,
                0.0031538987019696565,
                -0.004758784370083551,
                -0.0025713096628499784,
                0.028544826571291534,
                -0.0598824185725369,
                0.18930396829568402,
                0.12306573883074139,
                -0.0019652266488811862,
                0.024613326230728965,
                -0.0034128106021618426,
                0.004693041502026524,
                -0.028379308090362942,
                -0.005227973131266014,
                0.010337252088612872,
                0.0057376440748042375,
                -0.031202370746838452,
                0.0008761463559046645,
                -0.011415956206835052,
                -0.007257195750688397,
                0.010205889789783994,
                -0.024680918029691138,
                0.002007092368533296,
                -0.005245890325612838,
                0.024199279974464142,
                0.0017108484267735582,
                -0.01642234437218748,
                -0.010393197757411545,
                -0.010903040526399427,
                -0.0006149100997124164,
                -0.008027870943382177,
                -0.0005085343047676324,
                -0.020821526595405326,
                -0.0002779284257870584,
                0.00041845004276123965,
                -0.0005105032235766607,
                -0.001964389717684156,
                -0.0004592347264453483,
                0.0047175733171795345,
                0.00007902071509596101,
                -0.0034658587926101937,
                -0.00004314286833530959,
                -0.004248395078200218,
                -0.000039075068336508626,
                0.009277284734983182,
                0.0004950187437325235,
                0.020854739359741314,
                0.0003545354069524925,
                0.017262195000254443,
                0.0006274526939389435,
                0.03375620773864359,
                0.00045766766830238016,
                0.0233726991381695,
                0.0005153978832120837,
                0.026690446016640407,
                0.00044937120273561297,
                0.004590383438577388,
                0.0002375470582342143,
                0.001983455668443198,
                0.0003079617663107257,
                0.0053258965835524036,
                0.0003138962890356102,
                -0.03576265694075462,
                0.0006402535556552548,
                -0.025505567078420117,
                -0.0000991772191083592,
                -0.0011635458310019248,
                -0.000018033805345611886,
                -0.13996446591920225,
                0.0004474762081640261,
                0.14183466929022162,
                -0.0002675114311850207,
                -0.007577573763761204,
                -0.00026908328225053386,
                -0.037319107558555886,
                -0.0002072900321473648,
                -0.043642656854636114,
                -0.00009069704648448902,
                0.003949305257704018,
                0.000679328665781738,
                0.1528870023734693,
                -0.000695304557614107,
                -0.15809868421196152,
                0.00048362528098034734,
                0.017174618871942594,
                -0.000011482591035269886,
                -0.0010131982941512638,
                -0.0005186183846644567,
                -0.019378086568901953,
                -0.0000393647136826019,
                0.00014621546923539974,
                -0.000028075047358847195,
                -0.017931002038334788,
                0.00005923877545219674,
                0.005853373741303067,
                0.000006087426937897448,
                0.014665947230836468,
                -0.00007884182567839494
            ]
        },
        {
            'energy': -0.6088783376629129,
            'occupancy': 2,
            'alpha': [
                0.04706983590099018,
                0.06703468799235471,
                -0.01119367056623129,
                0.06690424195641134,
                0.005337218504328007,
                -0.015715641240652462,
                0.03527076279479061,
                -0.006498072455828599,
                -0.0006718684967070809,
                0.0018438000674602226,
                0.014799675773215962,
                -0.008694159729058824,
                0.10008847651327155,
                -0.12331290545244442,
                0.014370295359120912,
                -0.015407486227433244,
                0.01543194163798487,
                -0.005750460772226665,
                -0.00021047889035015512,
                -0.039439972151638775,
                -0.037558793448764616,
                -0.0023458952937016626,
                0.0525611193598167,
                -0.03441629953976117,
                -0.007851734020553667,
                -0.09937922707471754,
                0.015584644710661146,
                -0.04883470995299062,
                0.028038713407461478,
                0.10458508744803748,
                0.01828715337604096,
                0.043074603843993385,
                -0.03863816022809058,
                0.05184366803683204,
                -0.04994378078733708,
                0.11672755185079753,
                0.054195095460707214,
                0.04116079193707491,
                0.054645962490537575,
                -0.04148143116323692,
                -0.1047227888830567,
                -0.07872248018480583,
                0.003470954876998195,
                -0.032848761992332956,
                -0.1415146656466213,
                -0.04235523687390626,
                0.051645420540402664,
                -0.05846585179950472,
                0.007798048453770049,
                -0.011648212134213024,
                0.04433884739676358,
                0.007180957333799968,
                -0.015052869757036132,
                0.09606693623483231,
                -0.027152931818627234,
                0.0524829955244109,
                0.027964567254377452,
                -0.010518076296200652,
                0.04022234000815172,
                -0.05636229339997071,
                -0.018492540411169038,
                -0.0028742750884112973,
                -0.008155465523646875,
                0.01310291674594717,
                0.032118342844911676,
                0.016917297650720236,
                -0.0019416162488729088,
                -0.008921588957699239,
                0.05320263189790048,
                0.10261354662583078,
                -0.034172795137375186,
                0.10020782108487208,
                0.08204735190884341,
                -0.03271638533517379,
                -0.015057099696614572,
                -0.06654357123649352,
                0.14264379270358754,
                -0.03876498922178094,
                0.050293765588170225,
                -0.021631025428666083,
                -0.05599072984868412,
                -0.02449089472124761,
                0.02205053498146691,
                0.025996787120003285,
                -0.0073027474353374675,
                0.0014292238853807343,
                0.02204330967132835,
                0.0043810417109545535,
                -0.06768470352321683,
                -0.07082582745669154,
                -0.0648213781609914,
                -0.04283569932437376,
                -0.029001887404138057,
                0.0014173748587652131,
                -0.028230933548684115,
                0.020027681568397245,
                -0.022333598209919505,
                -0.03756430819653812,
                0.11388313668520547,
                0.07071889291251603,
                -0.03548935959709507,
                0.027701580354048225,
                -0.11585469631634804,
                -0.07150156974238957,
                0.07221708750592863,
                -0.014657876373692976,
                0.01906830967702169,
                0.02232723044538194,
                -0.0005420001253054502,
                -0.01722631201327658,
                -0.05527523628742945,
                0.0224259291612134,
                -0.0894296387429174,
                -0.04973719406977904,
                0.10272276613353482,
                0.042662806998248294,
                -0.08817756550272363,
                0.01656526763052683,
                -0.09852920907298117,
                -0.07095434077488745,
                -0.003737752419582447,
                0.014338786410741662,
                0.056620221662058184,
                -0.026621195831163513,
                0.06557306929138831,
                0.013739862626160622,
                -0.01933371187759244,
                -0.029534027999582057,
                0.016871059198929502,
                -0.04709510532830135,
                0.01563228076151401,
                -0.0356790957028342,
                -0.1482628763500645,
                -0.03129500279868093,
                -0.0005109166932860045,
                -0.008996367288535931,
                0.02807594688699066,
                -0.007481506208258142,
                0.029893506641180484,
                0.018272717088275416,
                -0.06604659086366996,
                0.01586765984717976,
                -0.015602700775138164,
                -0.032359559452036536,
                0.09586935039091457,
                -0.09530605256459697,
                0.051034247283189976,
                0.00802136957432056,
                0.07115520388049394,
                -0.022704091167503344,
                -0.0897060956216131,
                -0.06589515065209685,
                0.07908632828004632,
                0.03395508852450573,
                0.08264848356990043,
                0.06397242473835389,
                0.06680068486607413,
                0.10058807068179645,
                -0.041317808687815795,
                -0.0003439309499370032,
                -0.13849527958921984,
                0.0324189396254546,
                0.014238091745176307,
                0.018174311658248028,
                0.020749713689826702,
                0.0014195803574856055,
                0.057637137216492655,
                0.0007315749079226253,
                -0.05389393939179296,
                -0.0003259996736234591,
                -0.005905672884312458,
                0.0001533946682048982,
                -0.028513094045563552,
                0.0004584472520183548,
                -0.0014848463135728443,
                -0.0008607471142377035,
                0.02393931339635638,
                0.0007221801221486565,
                0.012245491731626937,
                0.000877441449771259,
                0.03395294956320493,
                0.001099196520663014,
                0.06579764189493902,
                0.0009772508936355256,
                0.0578033435884706,
                0.0007637263408537962,
                0.08927866538833712,
                0.0013314040235431048,
                0.06320674593289247,
                0.001697989980600628,
                0.06794300869754351,
                0.0004002941975710786,
                -0.012703758613980017,
                -0.00023513064036415076,
                -0.01880118086068873,
                -0.0010254332830285282,
                -0.027046178190475802,
                -0.0017897137992620282,
                -0.09385088237238771,
                0.0010370210533838505,
                -0.09536189438397184,
                0.001174133075376393,
                0.0070540026297511585,
                0.0006437395105360459,
                0.04248613500698276,
                -0.00013212035332430935,
                0.0002997848011470253,
                -0.00019053774644457955,
                0.055011386123707734,
                0.004771667365533143,
                -0.11409435224340739,
                -0.0008044128442169422,
                -0.11241172699461899,
                -0.0009246931397611945,
                -0.0027792364757039207,
                -0.0003664483994716778,
                -0.002883902490270108,
                0.000014602550892848625,
                0.0413845283701444,
                -0.00013685751810358168,
                -0.04104783272487324,
                0.00013548198246781976,
                0.07704734192475338,
                -0.004249088789789275,
                0.060002205973783425,
                0.0005207752774893093,
                -0.0006808718354047835,
                0.0001489157805402106,
                0.049761518745561874,
                0.00016570204788919054,
                0.04736790969108741,
                -0.00021416745729583078,
                -0.08250739898289744,
                0.0003815495940582372
            ]
        },
        {
            'energy': -0.6014386661611822,
            'occupancy': 2,
            'alpha': [
                0.10286436439999182,
                0.19777615003102472,
                -0.05088244563518614,
                0.18219997905514898,
                -0.008306637008576371,
                0.01435386597727232,
                0.031915229108148195,
                0.0039506445860733675,
                -0.008557716074226356,
                -0.010602407728551295,
                0.015037482860814943,
                -0.0027022644050769175,
                -0.12722390339004075,
                0.0852027187546749,
                -0.12864588313217257,
                0.03387240072231679,
                -0.0020393267484564714,
                -0.005495326309523458,
                -0.004003419864152898,
                0.0008837573980739364,
                0.0007508826386102857,
                -0.001870383927257513,
                -0.001462456213661405,
                -0.0005185819467532968,
                -0.00527694104466834,
                0.0018628030706360442,
                -0.0102115009123765,
                0.013799325285469595,
                -0.028250373131190942,
                -0.06231071774294565,
                0.037955918656157994,
                0.06560848995785394,
                -0.11352493763761981,
                0.07428278262017725,
                0.042154148497401386,
                -0.038026247979717195,
                -0.01792096484696529,
                -0.023480631370128523,
                0.0196476513259388,
                -0.04821260089263989,
                0.08051421370475986,
                -0.06002596731858651,
                -0.014350365751055052,
                -0.0057379490068523295,
                0.13288825507948288,
                0.10661219250916372,
                0.04600705869999947,
                -0.05192679796845505,
                0.006052772754223662,
                -0.00738104999347868,
                0.0074066341555189255,
                -0.02946731148276077,
                -0.03036140190779747,
                -0.06235310445979183,
                -0.06536141948437692,
                0.09026824240423174,
                0.08320983389008375,
                0.041609690482179315,
                0.034942122762804534,
                -0.032977255224972635,
                0.01044776445736867,
                0.010958645049102586,
                -0.008991436350764092,
                0.02026556101333724,
                -0.006192078560031468,
                0.005940840301663591,
                -0.002070781485102647,
                0.018659830257469104,
                -0.005529017717486916,
                -0.0022151874287467204,
                -0.012778897895914448,
                0.01629797373839508,
                -0.05169637996934318,
                0.06529049079750034,
                0.057329597554187275,
                0.02389503904345584,
                -0.08108675881126069,
                0.07258970149204341,
                -0.017332639088411456,
                -0.02007374164065809,
                -0.1461630286928955,
                0.015283180452916876,
                0.02337537208011458,
                -0.025614867357499946,
                0.0005484228208159644,
                0.00005960649606506664,
                0.00965334575347649,
                0.0019498881472439443,
                0.11275029830753916,
                -0.02832222575788678,
                -0.05157956385158641,
                0.07100751583028055,
                0.005904959409893054,
                0.00422384727659755,
                -0.00022748551016432925,
                -0.005548530834749094,
                -0.06834769301547876,
                0.008716554078264863,
                0.05080673758500025,
                0.07019854225265029,
                -0.07159194747102408,
                0.044079778092508445,
                -0.0727281038811849,
                -0.004748211009312568,
                0.054851632847753504,
                -0.054449755937708386,
                0.047668426918230984,
                0.10601190621436693,
                0.05085237772038615,
                -0.0015866196419083941,
                -0.1312918600990784,
                -0.003597091546010923,
                0.01719880268130722,
                -0.02734396688634667,
                0.06703007632070476,
                0.0380703665258794,
                0.01714960714076875,
                0.013611089363732865,
                -0.06862678305927808,
                -0.04216088271782913,
                0.10355522136740226,
                -0.001827704006884347,
                0.10407726921584803,
                0.008534712138574459,
                0.09342230629018107,
                0.0432547779591026,
                -0.04796954050559012,
                -0.08532929943348926,
                -0.0007665384093461711,
                -0.10094170965097714,
                0.023005285864266894,
                -0.08411977102581929,
                0.06808412091932864,
                0.013191612597395699,
                -0.06950159494409833,
                -0.023908138615895434,
                0.00035132451611251695,
                -0.002163615158886198,
                0.0010447697319415597,
                -0.00004370974741665186,
                -0.10814674515110728,
                0.009965497862457652,
                0.019479725534725986,
                -0.01817394490553031,
                -0.1260110406412388,
                0.02633095202138061,
                -0.05071505883951036,
                -0.020351003644937044,
                0.06005100866538799,
                0.04096370619941474,
                0.05596423026490127,
                0.053746283788772095,
                0.017227308013065826,
                -0.05384069266513096,
                -0.06275662381927682,
                -0.05437897356601602,
                -0.11939673393816634,
                -0.002583587381314361,
                0.04788492330670845,
                0.03282770414161699,
                0.06568659358735583,
                -0.0487181303265226,
                0.05478586985899847,
                0.024232366752358212,
                -0.04441333247107543,
                -0.00008694673817264065,
                0.033766432197288414,
                0.0008756095153066526,
                0.14700170686113448,
                0.0013743095903324097,
                0.02415195774938707,
                0.0013513731989966407,
                -0.018709712688291434,
                0.0005487710246077818,
                0.01897226554562632,
                0.00062209137037074,
                -0.0027082921112813662,
                -0.00004400325134444926,
                -0.0156430667901476,
                0.0002553672151410416,
                -0.031096967333769196,
                -0.00022791111730181593,
                -0.011015908299872946,
                -0.001083736682870441,
                -0.08049738550266759,
                0.00026489669297118606,
                -0.026889194204534974,
                -0.001267670490910643,
                -0.04180455626383789,
                -0.00025486723410766835,
                -0.08068629450343516,
                0.002548555506832286,
                -0.003951094088672802,
                0.00023003321594895377,
                0.005480333639836103,
                0.0004983511852854615,
                0.004194606845493936,
                0.00023205597892094962,
                -0.0914198779417483,
                -0.00046627011310731,
                -0.09000132946571188,
                -0.00030990615146365513,
                0.014340353639434951,
                0.0022697346045959244,
                0.06051688113857248,
                -0.0002976289270626543,
                0.06347658847128505,
                -0.00003596975559168384,
                -0.07103493089411085,
                -0.006831041435330108,
                -0.040529443694413636,
                -0.001909659123634807,
                -0.0401289155205417,
                -0.0019372688320537484,
                0.0034089169099248166,
                0.0006382191098399069,
                0.07920941995908815,
                -0.00019453714962556625,
                0.07617343778198475,
                -0.000190468082787412,
                -0.06343726411561765,
                -0.0002764703575403971,
                -0.08773256683761534,
                0.004781837982432319,
                0.019110127667386616,
                0.0008309633635813204,
                0.002038593600884967,
                0.00034249952768699665,
                0.008051688365753743,
                -0.0002002138713182319,
                -0.08941487305833005,
                -0.00007431429688806205,
                0.03850170927283838,
                0.0000525215757615789
            ]
        },
        {
            'energy': -0.6000689167556584,
            'occupancy': 2,
            'alpha': [
                -0.15880163902227792,
                -0.32794341333989596,
                0.06914910192937507,
                -0.2824401898532092,
                -0.03432312599647709,
                0.06344365973879251,
                0.0014067904121780963,
                0.011001464466631293,
                -0.011251438881423858,
                -0.021461200828683122,
                -0.008377771244547763,
                0.007193606758592339,
                -0.021721053788349768,
                0.006974339274182493,
                -0.04777890310803557,
                0.048629332858589794,
                -0.01145187524878166,
                0.003501834493561031,
                -0.005609633861770741,
                0.026963812540883418,
                0.021470584766705325,
                0.00015029710100329213,
                -0.029645407044676986,
                0.022853550453552356,
                0.016640965229408236,
                -0.03810470966715728,
                0.06957006636380737,
                -0.142469302764662,
                -0.005145788398602882,
                -0.013824240340954183,
                -0.008254807675977652,
                0.03458782553384702,
                -0.0819091317819252,
                0.11311329025840705,
                -0.007656736232290694,
                0.071689544535302,
                -0.0028417798965478373,
                -0.08048507397646479,
                0.01772374400247609,
                -0.08340519113994159,
                -0.08502386046036287,
                -0.05098176013212483,
                -0.04356166923599721,
                0.04516442056805648,
                -0.08715624378630846,
                0.03389570964945882,
                0.059431257926628456,
                -0.062088251243803,
                -0.002673466705531738,
                -0.030995062171555808,
                -0.006856553517147877,
                -0.03875501707195549,
                0.028243936144426246,
                -0.012596752223638317,
                -0.06451749066173972,
                0.10546641579510002,
                0.07910778273315802,
                -0.035742741460711755,
                0.02327909035398785,
                -0.05243041068694903,
                0.018686806851699145,
                0.030901239513941355,
                0.007230116342154583,
                0.00022129197951059544,
                -0.023391287198658222,
                -0.0058760746954383564,
                0.013105618957117097,
                0.021576701427453923,
                0.02714005227790799,
                -0.0058057165846084335,
                -0.021853498455610847,
                0.035694479266917566,
                0.0479440433683622,
                0.0054279385611780626,
                0.0007364900107844784,
                -0.06363923211350031,
                0.07160483387809032,
                -0.007555944395080994,
                0.051693914898996246,
                -0.02543798697731405,
                -0.1293793439152462,
                0.006007362062541228,
                0.032849567481036825,
                -0.04152261483418138,
                0.0054447485371944175,
                -0.005839601030793368,
                -0.017168103063693707,
                0.00718502314900112,
                0.0235563603664779,
                -0.013781869910277925,
                -0.04354517246911755,
                0.06874289676212895,
                0.02013562425096866,
                0.0004026443214131849,
                0.010752737555528963,
                -0.013081365394205024,
                0.11719880517991965,
                -0.04301536103148179,
                -0.06552042969484165,
                -0.08318450182976346,
                0.12431710930006896,
                -0.08207484183130061,
                0.07557625808409014,
                0.0057702351181193835,
                0.045821602256381745,
                -0.050978019927814415,
                0.05428285497382492,
                0.09232629102905116,
                0.03664862661622794,
                -0.00018654365319100655,
                -0.12198795481919737,
                -0.01385008371047884,
                -0.05640597328818995,
                0.019586759895619955,
                -0.08651534482631172,
                -0.046038662077551744,
                -0.05530294585595559,
                -0.034411753176957556,
                0.08167239043603415,
                0.050566184402595596,
                0.09289817854412122,
                -0.006923682397387002,
                0.09141590192809614,
                0.01536377417185298,
                0.08766525399428504,
                0.033832629668030974,
                -0.05321216715052479,
                -0.07001784625269004,
                0.004156886838200051,
                0.1490929508075401,
                -0.04541553602080498,
                0.13925506938189033,
                0.013085880032731772,
                -0.0038000070921852904,
                -0.013417253206788226,
                0.0031955856502042706,
                -0.01462612778349389,
                0.0038523599590091196,
                -0.013024770683660978,
                -0.011675137654396704,
                -0.08309389375670449,
                0.0050313029555341116,
                0.010254889220017986,
                -0.010620644622136728,
                -0.016693075012563098,
                0.006892138237251218,
                -0.011176283754056635,
                -0.0012390716695127473,
                0.005771425307564018,
                0.003369264500563137,
                0.00957436772839704,
                0.010990362882566872,
                -0.002583811971989374,
                -0.005703756756332003,
                -0.011247273306200244,
                -0.007748131680074128,
                -0.017414747330794567,
                -0.0027984718619747757,
                0.00805818149507429,
                0.005780230568703665,
                0.010264529670213615,
                -0.005750190191262944,
                0.005950448575176465,
                0.0031049081597567633,
                -0.07935390016255821,
                -0.0012895492256671632,
                0.04532033293464288,
                0.0016196880019189487,
                0.021201066207656796,
                -0.0010515353842640296,
                0.03581107817418418,
                0.0009013263886543029,
                -0.012157903538156328,
                -0.0007713756279756939,
                0.020189753049422724,
                0.0021015081181963466,
                -0.011393553169668509,
                -0.00040764385411919216,
                -0.021777617874530444,
                -0.000042786619977164415,
                0.02536649850217765,
                0.0009489341133684084,
                0.05935640917364938,
                0.0005552901492714625,
                0.011916852861631166,
                0.0014818899292734146,
                0.06452143315024238,
                0.0006098294692466933,
                0.03715643595926663,
                0.0010588759723564219,
                0.01745990036244624,
                0.002384357881702052,
                0.013268523359137075,
                0.0004170701120884465,
                0.01198621963748183,
                0.001250642624424269,
                0.016808464030424797,
                0.001457329419871098,
                0.13094057825156669,
                0.001052225196230982,
                0.13055645997341558,
                0.0009717046416236319,
                0.01975807358325927,
                0.004291091742007593,
                0.06221579491713554,
                -0.00003735741470581965,
                0.06296182423984707,
                0.000004926349946600501,
                -0.010236890743441926,
                -0.0013769080727561048,
                0.030735979717550804,
                0.0027113127758274145,
                0.030091812496839187,
                0.002823573772974579,
                0.005877749534007855,
                0.0010099799257258057,
                0.07634889816091182,
                -0.00019425930912418603,
                0.07676831396579505,
                -0.0001914084750141985,
                -0.04465428013539766,
                -0.00039165623267043277,
                -0.014057748817723497,
                0.0008843448689939425,
                -0.0007455025067318883,
                0.00015697057456050517,
                0.0037847361935650155,
                0.0006432290283831702,
                -0.002863343948605352,
                -0.00002145915319361844,
                -0.014001572900514148,
                -0.0000016978907082681334,
                0.005603760161598454,
                0.000023767299484843803
            ]
        },
        {
            'energy': -0.5977552565770262,
            'occupancy': 2,
            'alpha': [
                -0.03054625431255815,
                -0.06843451042882116,
                0.018155229233358446,
                -0.052118781544791194,
                0.09254498737213115,
                -0.18510898966751432,
                0.12667660792278357,
                0.060762384754620355,
                -0.02351357254531988,
                0.0005956128084692944,
                0.16173859374830304,
                -0.04448943613008007,
                -0.15051691887483468,
                0.07146172906777959,
                -0.11865264301648452,
                -0.10722743898751011,
                0.04324562664962147,
                -0.04116303396187809,
                0.006302356278568697,
                -0.12569894167078688,
                -0.09702906434438499,
                -0.0071799698671940635,
                0.12991031007485274,
                -0.11558367449673591,
                0.006860425268855895,
                -0.1266278497261632,
                -0.006504314575969636,
                -0.021016917607579205,
                -0.03247338284331099,
                -0.08160018481859778,
                0.14983415329624122,
                0.04925333694185922,
                0.04040735282713429,
                0.04453328240246061,
                -0.01425515792019115,
                0.06199877938357773,
                -0.004756434196713515,
                0.06200419814598975,
                0.056296320149129275,
                -0.04955043762401454,
                -0.008727657103536806,
                -0.014678584682739523,
                0.0027733489849048696,
                -0.0010258110102564753,
                -0.10815939680384888,
                -0.033898978574447555,
                0.001901597094764783,
                0.0024406523214230693,
                0.013665005905828415,
                0.02722215810481795,
                0.0685350218504798,
                0.014054756686808653,
                -0.08196202118675602,
                0.019243819485395934,
                0.03421412474626671,
                -0.04940717847871263,
                -0.06852834404091393,
                0.040250188304695005,
                -0.010560966245180521,
                0.038009934454770695,
                -0.04230668837939084,
                -0.04916399058693871,
                -0.0034005660163010597,
                0.10460838204413436,
                0.06486117508823087,
                0.10733574606690964,
                -0.07520938734023191,
                0.010017274623627887,
                0.005450415979937733,
                0.00016794365621777778,
                -0.007316116684735541,
                0.014698870178743377,
                0.052779484597877256,
                -0.03277896185254418,
                -0.02880420990260042,
                -0.04584592899084879,
                0.06537647978801302,
                -0.04005024461733312,
                0.03299985745641795,
                -0.0006802327124864341,
                0.06569276869441859,
                -0.000028403207578378185,
                -0.029281933724381433,
                0.03726489415426686,
                -0.0074007395157156,
                0.02258435030202424,
                0.15188023099813022,
                -0.025611944849937843,
                0.11155842957418786,
                -0.07903648375732142,
                -0.02335133304828155,
                -0.09078867435167806,
                -0.05922112861421049,
                0.02135029718728211,
                -0.04619598936519191,
                0.023680310578860907,
                0.027791609734987635,
                -0.008016001393509638,
                -0.012666018313139453,
                -0.010491403867777251,
                0.023192558028890548,
                -0.01704495080191347,
                0.010677274600261816,
                -0.0011539876987281367,
                -0.02755205021245154,
                0.031066169453556104,
                -0.036629631043079335,
                -0.04888646622475231,
                -0.015240297172093471,
                0.0015569023505689152,
                0.07056383280730343,
                0.014000304215024496,
                -0.01268585313105394,
                -0.002039824754138732,
                -0.016172959858796035,
                -0.012445476870558497,
                -0.014122883454557082,
                -0.005798368346023107,
                0.012989606344231686,
                0.009733047671646308,
                -0.05266085336696954,
                0.0069329614262178514,
                -0.05270187026940374,
                -0.011980166046599612,
                -0.05408417613557319,
                -0.01582181229459281,
                0.03730403829538593,
                0.03642451456061624,
                -0.0009316311617863,
                0.028145186692696313,
                -0.006545770756210502,
                0.03082548785227235,
                0.040547320380721556,
                0.0339152329879152,
                -0.08138898984669306,
                -0.05453280066497555,
                0.07002034071974765,
                -0.026169794067517127,
                0.06396513725548554,
                0.05706756196904856,
                0.04115190470245493,
                -0.000881599058562203,
                -0.0008010112832133089,
                0.004059053632996525,
                -0.1796118385434409,
                0.009592988300512955,
                -0.041771610528521456,
                -0.028396082998383223,
                0.13133227270374417,
                0.06228223098051912,
                0.03931348210723399,
                0.03992496469530702,
                0.06402473559893355,
                -0.09137803425266582,
                -0.06675321860985457,
                -0.06995541923942483,
                -0.15023944738199937,
                0.043501240793012416,
                0.054355764674367237,
                0.04685006531343983,
                0.06199518743875543,
                -0.07386478147364134,
                0.09659070280145647,
                0.04359941900035097,
                0.0013620177552489167,
                -0.0011395226190980632,
                0.04267211223451356,
                -0.005524104066958876,
                -0.06266962488238506,
                -0.0030062706521766336,
                -0.028806320381458795,
                -0.0015646934102145774,
                -0.029225252725349753,
                0.0007781353474795073,
                0.027562106935340055,
                -0.006239129115256847,
                0.05896615911717544,
                0.0020196453296959386,
                -0.012939812968274867,
                0.0021796737784017333,
                0.02647811470128656,
                0.0012374219242724167,
                0.03716194056438096,
                0.0009008001354948461,
                0.05067640720078835,
                0.000528173297695879,
                0.039674256094329556,
                0.0009956026763694038,
                0.035597504546961395,
                0.0012705709896424337,
                0.04487810568632309,
                0.0026919527257519495,
                -0.0789175599382303,
                0.000594891650843167,
                -0.02347196577426149,
                -0.0020585369363685705,
                -0.050712864569139295,
                -0.005488630206760172,
                0.023072421332386767,
                0.000543480781637379,
                0.022883322522897886,
                0.0003511836358979667,
                -0.03398071290035035,
                -0.009545956020659812,
                -0.03921514853858669,
                0.0006172573290616508,
                -0.03713202235164699,
                0.0006718308188169358,
                -0.12586656902981028,
                -0.01105139969638185,
                0.002750977420031161,
                0.0005992489098505483,
                0.00319474760233318,
                0.0005048374367475841,
                0.009086430713971689,
                0.002485726393173167,
                -0.04644770678831803,
                0.00012882456867860248,
                -0.05036123134671071,
                0.00012742964178669375,
                0.01950328201220558,
                0.0003260989751541406,
                -0.10100320485960006,
                0.004639106260011844,
                0.06848181926650368,
                0.0019759376525146956,
                -0.00795451893909561,
                -0.0016248542923461796,
                0.04508858485903892,
                -0.0001217445942813653,
                -0.11361637178656313,
                -0.0005061801631905022,
                0.038882960745395975,
                0.00013118733266427945
            ]
        },
        {
            'energy': -0.5942286433348851,
            'occupancy': 2,
            'alpha': [
                -0.01291969337349864,
                -0.02242249636230627,
                0.004611976617727143,
                -0.03453822510690553,
                0.1398245950651036,
                -0.26865607635345384,
                0.1336267141297308,
                0.11072155232723288,
                -0.05981620995444191,
                -0.04057083340881614,
                0.2697592331417267,
                -0.07165559034342642,
                0.07422216522766303,
                -0.001391673177109614,
                0.06022858672222208,
                0.12825866129140112,
                0.04737728894093484,
                -0.06942528052444512,
                0.0014207002337431568,
                -0.15510013372202497,
                -0.11230124692291588,
                -0.010551645382501633,
                0.1452589965221526,
                -0.14759775645272033,
                0.04319694289948296,
                0.02857705133218315,
                -0.034887649403209424,
                0.034739627274789235,
                0.013398707177805154,
                0.07745007313092483,
                -0.14007951861349857,
                -0.020343405484807,
                -0.08519552571958902,
                0.03601910663972859,
                0.016582345178099325,
                -0.0236702675779266,
                -0.0885534976194499,
                -0.023238704558789444,
                -0.03567832379209434,
                -0.016648858504872046,
                -0.0166295324588066,
                0.047732143559029154,
                0.03262458918458725,
                -0.044922393524148105,
                0.09316496924570382,
                0.06323011603663124,
                0.03491971220117808,
                -0.04575164707534968,
                0.003416221339477905,
                0.036351085136752094,
                0.019284918969954695,
                -0.004053533683792669,
                0.03693865134104215,
                -0.07607445052747226,
                -0.050378909358759855,
                0.058908030604973974,
                -0.005805339884437058,
                -0.06953679200442739,
                -0.003549543542539808,
                -0.02889114839040835,
                -0.036424207038659825,
                -0.05510086341647505,
                0.012221014739968212,
                0.13344355941546973,
                0.05050311619964704,
                0.1543129147075821,
                -0.11303484867809302,
                0.05996150591997804,
                0.0027601920622459886,
                0.023283266757122705,
                0.007098668634387852,
                -0.007905888976431531,
                -0.03641455645425485,
                0.045557057851284645,
                0.04480666331931895,
                0.02102443462826957,
                -0.047500830429019494,
                0.051377127527486556,
                -0.015266801645329888,
                -0.017678235516906365,
                -0.0054039005150169,
                -0.02452104650405994,
                0.005058690377776227,
                -0.016650319501840864,
                -0.0014648240451577916,
                0.03137321924500939,
                0.23175931326721025,
                -0.029086759622835082,
                -0.03972928367836696,
                0.08175710350740467,
                0.009640848628079745,
                0.129116418103555,
                -0.051506352807806105,
                0.04597617643204424,
                -0.045191896945519214,
                0.0023669433935678556,
                0.01083370956474869,
                -0.0008150764999604123,
                0.0053918340752752685,
                -0.010451033561509025,
                0.014551108242963113,
                0.0025377988928828228,
                0.007897475195975083,
                -0.002282621517351151,
                0.002887518874329994,
                -0.010135505760008564,
                0.005809273300520472,
                -0.0010131798224724288,
                -0.0014326714195093274,
                -0.007417310382891835,
                -0.0062265529577323455,
                -0.007689520840340628,
                -0.00970711393610209,
                0.003564759950165892,
                -0.0005875779075737966,
                -0.004048597465073033,
                -0.007399767091717144,
                -0.005319768079715957,
                0.009928337488018687,
                -0.003441156756052356,
                0.003012280272776464,
                -0.0038221931547663133,
                0.004192922198818937,
                0.0008204975811991162,
                0.00482998650381794,
                -0.0026031585364126478,
                -0.005527748852166727,
                -0.002299997427275512,
                -0.0010740600666972408,
                0.018486082186555307,
                -0.004590036945579031,
                0.006840930014064778,
                0.00033326420497786725,
                -0.04298160522832239,
                0.039168357212951234,
                0.03205627832483773,
                0.08104603337997907,
                -0.03518203320060388,
                0.07120209018710698,
                0.0708732752212884,
                -0.000434266728459822,
                -0.0023085467811608156,
                -0.002350553662236018,
                0.00018840390046567638,
                0.11985387563656062,
                0.0076880812975849665,
                0.004254728190928758,
                0.010952225568351641,
                -0.10952284627146394,
                -0.04827723124137111,
                0.005767825093898228,
                -0.0037253484554053517,
                -0.06730290547166645,
                0.07782066652325564,
                0.029083553162833797,
                0.04218597251970521,
                0.08172201164490726,
                -0.053701389843768106,
                -0.02011773627604535,
                -0.026016858786441294,
                -0.029301713105829245,
                0.05773076679610588,
                -0.07217336562573796,
                -0.03121782945290053,
                -0.06192973992642673,
                -0.005169065056254373,
                -0.03362297661904773,
                -0.01130223364898752,
                0.09606577204853331,
                -0.0011363221104083666,
                -0.014941686397848434,
                -0.003381330167277716,
                -0.006332089602959908,
                -0.00009449127632535438,
                0.04853637108139913,
                -0.008564287795841737,
                0.05605967202244702,
                0.001496469978370978,
                -0.06460081619265827,
                0.001045341603090363,
                -0.02428458981835074,
                -0.0006714183296329656,
                -0.008544342209130907,
                -0.0006738498260552151,
                -0.05816896979782271,
                0.0003006999338655063,
                -0.01415663162290693,
                -0.0006944396642217644,
                -0.02914813826984517,
                -0.00043733270956796994,
                -0.052121776119581714,
                -0.0004956902133596412,
                -0.11171121797124563,
                0.0017479824682606947,
                -0.0025461808601365044,
                -0.0005447997770351423,
                -0.04300087635422309,
                -0.005934928734982907,
                0.007569274508916538,
                0.000006455350715113332,
                0.009152810724517724,
                0.00016141333613050492,
                -0.0701477955608504,
                -0.01697449531289533,
                0.005623521774421539,
                -0.0004341167219506539,
                0.004608703431294179,
                -0.0004392036154458871,
                0.10690452565695592,
                0.009156280687876724,
                -0.002679808624500631,
                0.00023612275040976394,
                -0.0017152128435310836,
                0.00029249470130310204,
                0.02508661495674673,
                0.006464567968334978,
                0.0040564903037929746,
                -0.000017333737339789565,
                0.005956545187425552,
                -0.000020174157663227024,
                0.001460429575994598,
                -0.000034263348531205294,
                0.04714569156990947,
                -0.0009636154755772928,
                -0.07379426048780631,
                -0.0016392804989511251,
                -0.007384079044197732,
                -0.002046422534682874,
                -0.05621885520317418,
                -0.00002440868629099256,
                0.05793721090024554,
                0.0006428672852530088,
                -0.024176363953191785,
                0.000002364772485754302
            ]
        },
        {
            'energy': -0.5884083550117863,
            'occupancy': 2,
            'alpha': [
                -0.048036884500998335,
                -0.1126680520965429,
                0.1552773965989545,
                -0.09591364575804141,
                0.052222701578407735,
                -0.09548420006809107,
                0.07200859952939236,
                -0.1847400706137847,
                0.053581491530503636,
                0.08827650993770826,
                -0.08944704725766237,
                -0.024344984658611166,
                -0.01974971219165143,
                -0.0359982816363778,
                -0.0807569268102619,
                0.05324203495898797,
                -0.017984886707220562,
                -0.026449457771717377,
                -0.01307365968214813,
                0.04285931334703178,
                0.031902095007608364,
                -0.010349947401167858,
                -0.03773458744116215,
                0.043048235918049745,
                -0.0065975117566705295,
                -0.07799542986485662,
                0.042947644296238506,
                0.18666612011410172,
                0.01041374905839463,
                -0.08212072140820934,
                -0.00005254371158311404,
                0.04660639510920054,
                -0.054444781660216574,
                -0.00844262829915683,
                0.03582329818205113,
                0.048435204948754064,
                -0.021797730535584325,
                0.07505464811548879,
                0.1481483932411927,
                0.13974325008139307,
                -0.07567795267227241,
                -0.0031995015425717917,
                0.14283003254791093,
                -0.0910445187161227,
                0.12833701422135363,
                0.06504208456245572,
                0.060237170111674516,
                -0.0700110637101987,
                -0.01728728869080006,
                0.18678299520696878,
                -0.008951246419915565,
                -0.02430912652548589,
                0.03614556219545581,
                0.01986290658865314,
                -0.016194846375760744,
                0.09210134403259423,
                -0.023504137601720106,
                -0.08967225395204441,
                0.05377988627837406,
                -0.07555737880683192,
                0.06353438472898673,
                -0.055285055429187,
                -0.1831685387610816,
                -0.0008419740230901474,
                0.006630640469803301,
                -0.12728152074032947,
                0.016406724866875767,
                0.01882670133874909,
                -0.02370504565647748,
                0.10792986878818261,
                0.0602524070453178,
                0.05578543578456783,
                -0.021483104402423885,
                0.056289357388958974,
                0.07582440669879464,
                0.015062989251653463,
                -0.07372194975622286,
                0.08435686012505761,
                -0.03369905507821362,
                -0.028174636727015374,
                0.029243067187627137,
                -0.06543617456929657,
                -0.042252409407146786,
                0.022655097365472658,
                -0.04194637467201302,
                0.014501781446002034,
                -0.040214998089340835,
                0.01976216373883439,
                -0.004913090243682885,
                -0.05452798493947671,
                -0.06272068435453,
                0.06730247371975391,
                0.02200710290608946,
                0.02687664963955074,
                0.0022200109365593823,
                -0.007633161566979327,
                0.0701196031762975,
                0.05282675819328289,
                -0.003232635754615101,
                0.00027926749886968296,
                0.04953072242265016,
                -0.014167886613410962,
                0.003992089985378258,
                -0.07484466288261613,
                -0.027759748776983697,
                0.003388756961856986,
                -0.05171002744714761,
                -0.04196077115653223,
                0.008023771231075717,
                -0.02705928901858764,
                0.054905902206035466,
                0.020288984430147764,
                -0.04407998385245742,
                -0.04233895251468164,
                0.009902793590054358,
                -0.07851977611051685,
                -0.0827320498614645,
                0.02824170840004343,
                -0.018106334324195627,
                -0.028230255609253234,
                -0.0353230702779343,
                0.007960467414009945,
                -0.0474258536326676,
                -0.028884726078741617,
                -0.04967324485227352,
                -0.00907365433737633,
                0.05995777836956475,
                0.008706541074345755,
                -0.0025834736804851836,
                0.06716447869046738,
                0.05306642619089605,
                0.05602731370586502,
                -0.015223323226320964,
                0.04433724075590168,
                -0.0017692858991201956,
                0.03551686374162301,
                -0.01808005271355231,
                -0.0040370515818350175,
                -0.010784579206625702,
                -0.021562147374519478,
                0.012311043765364939,
                0.003868215880682364,
                0.02399292649336946,
                -0.013300015494955165,
                -0.019279364286531344,
                -0.021800913137609183,
                0.024160562490797396,
                0.018906692407804244,
                0.035908351358501935,
                0.026165531430941733,
                -0.0458327437453135,
                -0.015353464729701808,
                0.04834878803363555,
                -0.042037253696109854,
                0.01748357873542953,
                0.0031095837241270122,
                0.00858160872254427,
                0.029087554402647313,
                -0.029472165497921716,
                -0.008913784452636915,
                -0.0034248736025823882,
                -0.029110228371332925,
                0.016580667891143253,
                0.00487408135044074,
                0.14000622859368161,
                0.003920641398855407,
                0.04090355787491086,
                -0.00002468018188533152,
                0.12106981809448537,
                0.0025136159394819817,
                -0.06317887267660732,
                -0.0007261083095201955,
                0.019771283528430748,
                0.0025941767426370275,
                -0.029078661741604405,
                0.0008853374365489387,
                -0.07140807877855915,
                -0.0014100685726395627,
                0.04065462098547551,
                -0.0011481479029839226,
                -0.03655780493667503,
                0.00011522275053209887,
                0.013392255477886587,
                -0.0011611958740773728,
                -0.06898788178182921,
                0.00020420090178830536,
                -0.024425863782661386,
                -0.0014548727531381895,
                -0.04768824806188551,
                -0.0006627526183540569,
                -0.08506887895995245,
                0.0016539952447088466,
                -0.0031964971310160704,
                -0.0038789698134022,
                0.03028513083671507,
                -0.00038013490829077193,
                0.0072058306291149544,
                0.0018686081512939538,
                0.025621815102037485,
                0.001887408510469952,
                0.02626326744624459,
                0.000758465849551043,
                0.024175764355146824,
                0.0009013434044219658,
                -0.04834750147329363,
                0.00015982981076449152,
                -0.034456425382822675,
                0.0004540591779616746,
                -0.048385617254233765,
                -0.003726309685367021,
                -0.038405865297926375,
                0.0012101132265617694,
                -0.05898672007818441,
                -0.0007207459242181822,
                -0.040842274535553266,
                -0.009664954957207945,
                -0.04824171919561593,
                0.00021992065083168083,
                -0.06408214743943196,
                0.0000014784176930541707,
                -0.012153229574576475,
                0.0005811632186596544,
                0.01384052039168077,
                -0.0009014629346488979,
                0.04943164023023957,
                1.8159817850017194e-7,
                0.00849996266860922,
                0.0019917731774920532,
                0.05135493137746516,
                -0.000015090648890280568,
                0.023682415356531334,
                -0.00032835733525860645,
                0.011718544453739075,
                -0.00035582415763192517
            ]
        },
        {
            'energy': -0.5863191511969108,
            'occupancy': 2,
            'alpha': [
                -0.032783559681901726,
                -0.013433642675991505,
                -0.0786536375024067,
                -0.19931938926185086,
                -0.06745396592483364,
                0.12631400505057652,
                -0.11524320377877213,
                0.20196850262098814,
                0.024275593108176344,
                0.03985839304951153,
                -0.039347479070870196,
                0.07770034302066339,
                0.007164994598794696,
                -0.06864365127060251,
                -0.05677837157873234,
                0.015136192763789408,
                0.03250016921729824,
                0.08933934727993718,
                0.04726128083920881,
                -0.03762081523094631,
                -0.03290765127140103,
                0.023971760612482945,
                0.036465761640593924,
                -0.034548949201293915,
                -0.016897626227377106,
                0.06311731096606374,
                -0.18752423329056672,
                0.01099808264448939,
                0.001518707864412495,
                -0.10534364578184664,
                0.029480910157336504,
                0.03599569000808904,
                -0.025739496770131366,
                -0.029100797801272314,
                -0.06950995522036692,
                -0.03951511184291603,
                0.008273346542697207,
                0.09979748989708911,
                -0.1753302825382146,
                -0.01705487087564352,
                -0.062098116453441154,
                0.02446832943610476,
                -0.018227666845625237,
                -0.13879097226723766,
                0.11897576095146917,
                0.020680920496562668,
                0.008324795777984778,
                -0.050894727828283165,
                0.015118817628699398,
                -0.15078585417942797,
                0.0008887451117770613,
                0.13502508441468014,
                0.05173942735211993,
                0.05684412533074789,
                -0.05067115734941942,
                0.040135627405943626,
                0.011841781000369424,
                -0.05745951335709327,
                -0.003675968196297336,
                -0.09363367037676566,
                -0.09489016930147907,
                0.037012152186198716,
                0.2286939327113652,
                -0.011062815310995155,
                0.016140029540834135,
                0.10805209783259198,
                -0.005789607591411103,
                -0.13568304581845492,
                -0.023544636965454304,
                0.11247637132913496,
                -0.05391778826506276,
                -0.01030352726396171,
                -0.04759886583961074,
                0.042995874060658204,
                0.06277966180520551,
                0.05510268254328452,
                -0.030230531934994014,
                0.04703478468330751,
                -0.03172591816343992,
                -0.025893404574754416,
                0.012542770378686072,
                -0.0468608937833183,
                -0.016714040918054972,
                0.010430065199440777,
                0.04970780192820476,
                -0.01780173273330398,
                -0.0585619825901115,
                -0.07275828893964076,
                -0.019125287550793603,
                -0.058007741929515605,
                -0.057960792655950534,
                0.020560145160273227,
                -0.05639477925080705,
                -0.09510723175265406,
                0.01694642315868327,
                0.061503634735295125,
                0.03599674568950216,
                -0.05128563717332774,
                0.061789941407184364,
                -0.04666611513329347,
                0.05542752663131883,
                0.06052141963189768,
                0.018439473770973477,
                0.044916068317866965,
                0.011239738557618732,
                -0.004434076723001523,
                -0.025315332894287987,
                -0.01987110333416725,
                -0.019595055681924642,
                -0.021305806921703332,
                0.03159335064060559,
                0.016918834225622088,
                -0.08175105151368976,
                0.021613585596632637,
                0.05023214999415088,
                0.034857526545892394,
                -0.018779167402661646,
                -0.06715839469466589,
                0.053191862706934566,
                -0.05925547603197004,
                -0.029152385402716665,
                0.012012654557867578,
                -0.01138592871701392,
                -0.03288366793046149,
                -0.010450500818371995,
                -0.012545636461409257,
                0.025428148577221244,
                0.0163040383796533,
                -0.0016444145239914497,
                0.08136691003109671,
                -0.057488691417809934,
                -0.025201132245512965,
                -0.006481512155791997,
                0.0558547376710057,
                0.0005694320364463082,
                0.03229243040354241,
                0.007129521290892875,
                0.019133769234064762,
                -0.008545364694905102,
                0.01892289030190954,
                0.0013739345072850337,
                0.008878136329541304,
                -0.0016091820996453374,
                -0.02280798206498919,
                -0.035300068221663566,
                -0.013424731555830795,
                0.031192169098393764,
                0.0230749702012537,
                0.05229721534596678,
                0.039953596204756685,
                -0.048980544452628366,
                -0.016106490501935734,
                0.051902158384213526,
                -0.06190020710079787,
                0.013640860186403368,
                -0.005656060149893949,
                -0.0025040341962697275,
                0.03409502043342164,
                -0.03155243386325142,
                -0.009746908385956736,
                0.008620337084700969,
                -0.04682259089541975,
                0.023531980634542985,
                0.004212290864181917,
                0.002592636091265119,
                0.0003235283750144324,
                -0.11482622994668511,
                0.0006448208236373939,
                0.06514001773734848,
                0.0042436629155591715,
                -0.011799678109993042,
                0.001309357002977488,
                0.040632847103695434,
                -0.00048299750932743996,
                0.009316283061825744,
                -0.00017306682194788276,
                0.09680258016810143,
                0.003299111977715165,
                0.048171779224104504,
                0.004110890389670465,
                -0.04195323455358472,
                -0.0009629047047065669,
                -0.028151233682514994,
                -0.0011577133117144514,
                -0.06606912852074481,
                -0.00022641520223909932,
                -0.008761470589298844,
                -0.0011801736066484475,
                -0.036465913298737565,
                0.00007175394597163662,
                -0.04243500025592013,
                0.0005509981903067566,
                0.03955543413396652,
                0.0022580709705441117,
                -0.0905590202908157,
                -0.005271510190529282,
                -0.031270892740386004,
                -0.0039058913428933134,
                0.02274212087565622,
                0.0006040802221203129,
                0.012749927658572104,
                0.0013605323667483275,
                -0.029829160287996676,
                -0.0008440368658035863,
                -0.014767690175204717,
                0.00021380365492431155,
                -0.03381326176049743,
                0.0001351883065942697,
                -0.07250957916088195,
                -0.006399370163595369,
                -0.0604172991519196,
                -0.0015658963657821702,
                -0.026157689053962156,
                0.00139836915880677,
                0.017274153728131132,
                0.0023777923806012945,
                -0.0378976678377146,
                -0.00003050688506159317,
                -0.02348704256430105,
                0.00021292464342801602,
                -0.013057930373946045,
                0.00029995567994777725,
                0.016925654056786546,
                -0.002508693785985704,
                0.06567966425769156,
                0.0005200050547172659,
                -0.025906632947190786,
                -0.004923191731908082,
                0.06204247354453038,
                0.00003353136440194799,
                0.020460491803961357,
                -0.0005490383485959194,
                0.02657908896958125,
                -0.0003492967299534875
            ]
        },
        {
            'energy': -0.5832876342127018,
            'occupancy': 2,
            'alpha': [
                0.00403274406848122,
                0.03954485089701632,
                0.040109038969250194,
                -0.01119156181319569,
                0.06971060636021419,
                -0.11377549621602154,
                -0.0509516537543458,
                -0.03591314034719444,
                -0.07034365848185037,
                -0.119466314314441,
                0.12446346896528815,
                -0.0632809183032563,
                -0.07696829632880199,
                0.018271825358474103,
                -0.029785329534730905,
                -0.058937432389046,
                -0.01132383740907443,
                -0.069659784246003,
                -0.029764599493322063,
                -0.012863437667815532,
                -0.0024736771884062174,
                -0.012862287479303314,
                0.004250722466419657,
                -0.014918831144126822,
                0.022630917482015553,
                0.13448793106645782,
                0.05178479741901711,
                -0.004180979755692116,
                0.003653685972488148,
                -0.22713741316159639,
                0.045354897624187825,
                -0.0569542527680496,
                0.04941403360346545,
                -0.08267027022715961,
                0.023123080730510153,
                -0.05227941382150037,
                -0.01727487343516805,
                -0.07210506622170182,
                -0.08631797850473798,
                0.10890044982758544,
                -0.05100543929105642,
                0.022534059111605276,
                0.004085173637974062,
                0.024533743979529593,
                0.012800392141870655,
                -0.07394008423496572,
                -0.05899777068617506,
                0.06311016164860474,
                -0.022018063413010658,
                0.03100167750883025,
                -0.07003437368067557,
                0.013453797148618054,
                0.05374112682582724,
                0.008163446488677612,
                0.031863557742883984,
                0.00848671492404343,
                0.07865129158747558,
                -0.06862571044456693,
                -0.02686786309849169,
                0.03547997672105067,
                0.004977073312575131,
                -0.009818198477348316,
                -0.025395941677023352,
                -0.03413585056029306,
                -0.015372482819151469,
                0.01630131824978195,
                -0.010851779536392948,
                0.08648711310214398,
                -0.0060440615819726705,
                0.00773817139757693,
                0.017232636100144676,
                -0.003341480376226381,
                0.005304963863530014,
                -0.03731406103714001,
                -0.022808805114595182,
                0.03380606231739935,
                -0.006422613846885217,
                -0.028135035650630996,
                -0.035770406325539426,
                0.028833610371427027,
                0.0004976810177561846,
                0.034143938935263594,
                0.0658238175184452,
                -0.08804284633439226,
                -0.01553697631629813,
                0.01107667862159317,
                0.10096252873409477,
                0.055490629399112076,
                -0.01244058011163041,
                -0.01836115421577513,
                0.04095368201627065,
                -0.02265873559729008,
                0.028034201070006027,
                0.07630677029857558,
                -0.017295793557935632,
                -0.05269580568148559,
                -0.007989226751653807,
                0.015130900509812651,
                0.00012235400130501236,
                -0.003473193256798076,
                -0.005657593235067857,
                0.001988444753909759,
                0.003001141641160908,
                -0.01261940331140984,
                0.01589766025617601,
                -0.016438964950488837,
                0.08669802095468286,
                0.027165362331632577,
                0.021400613338769234,
                0.029669842543410627,
                -0.06757168849736506,
                -0.0677559489159421,
                0.005155494307046053,
                0.006880432711099541,
                0.005475451350059709,
                -0.01007011720073664,
                -0.0018914862245915998,
                0.016411310227373868,
                -0.002445009802224091,
                -0.005696827435218533,
                0.052882981603841916,
                -0.03729283582273701,
                0.049992285244082627,
                0.07090122398004306,
                0.04403520842755512,
                0.007663398819543773,
                -0.0931461113328243,
                -0.022151020763207067,
                0.0024242081265606046,
                0.009557304319879825,
                0.022692365214442737,
                -0.015898289799899025,
                -0.0008581471201013498,
                0.15332566904586203,
                0.06408865206096011,
                0.07418009819856274,
                0.011428786143195039,
                -0.01527561011848551,
                0.01743688422955676,
                0.0052942567463912776,
                0.005146591683790022,
                -0.029400421837987665,
                -0.03311886456393498,
                0.05280936442155988,
                -0.005993874644619402,
                -0.03506203922064936,
                0.09728095116611009,
                0.051525120454296254,
                0.059095014802208544,
                0.09615333433437817,
                -0.12474863093244931,
                -0.060124065987941996,
                0.11251729721424718,
                -0.12016330570804212,
                0.07567871249721811,
                0.01656080428982629,
                0.051797112328406225,
                0.051834918783949954,
                -0.11778433661066544,
                -0.0653912997669082,
                -0.001817811821885558,
                -0.09752363652447053,
                0.01250743308274798,
                -0.01878676953629596,
                0.01721047312119533,
                -0.0009561666559354054,
                -0.09328786354127187,
                -0.00619282817443577,
                -0.0805990141866406,
                -0.002108649335478032,
                -0.020132542699101776,
                -0.004408299202022768,
                0.04855877294805575,
                -0.0009782154626592138,
                -0.02550830174787234,
                -0.004374757956756326,
                -0.02037734717041296,
                -0.0019909686280989844,
                -0.06732905789285595,
                -0.004497349896423418,
                -0.0026301608623833066,
                0.000632638892677702,
                -0.03156728654837226,
                0.00009492531258172846,
                0.0334633539352427,
                0.00005528032518095118,
                -0.03578345057470464,
                0.00009329366266281265,
                -0.006290220437524301,
                -0.00008400028716797632,
                0.026098576106155538,
                0.0006474897977763433,
                -0.03973563941575255,
                0.0009395094573124797,
                0.06413574342015013,
                0.00551636722371401,
                0.019178937741163957,
                0.001582319120508587,
                -0.0014888480057650168,
                -0.00017814928564667437,
                -0.001703937812841026,
                0.00004986977794648475,
                -0.049655760990209186,
                -0.009855626633522437,
                0.06878718117048896,
                -0.000656957714335016,
                0.07753443410094739,
                -0.000008216616994872323,
                -0.12943665317357492,
                -0.012121332311585969,
                0.002860248974395475,
                0.00014718487011695187,
                -0.0031103555365878392,
                -0.00022028002652404042,
                0.01832860713690346,
                0.006565491706007197,
                0.08965853074921808,
                -0.00028116760524315163,
                0.08712718306631267,
                -0.00031898391822243776,
                0.05131300921259392,
                -0.0008462520264875322,
                0.06670950775877131,
                -0.000012878699431375875,
                0.1370779802683154,
                -0.00023844995361896597,
                0.01452643775584332,
                0.002290572181098039,
                0.14882756052295623,
                -0.0001808702378734701,
                0.11752486958972128,
                -0.0006803021767498342,
                0.06262807597607423,
                -0.0013324615057542103
            ]
        },
        {
            'energy': -0.5810785382647659,
            'occupancy': 2,
            'alpha': [
                -0.0017416935459524789,
                0.47155335917514074,
                0.3640374055110993,
                -0.4441966508137632,
                0.017612611426133865,
                -0.03157773691721271,
                0.003803377709073527,
                -0.014707975896085917,
                0.011626022196087243,
                0.02434476023702817,
                -0.010049427380729566,
                -0.0014106997961444037,
                0.0443264839719089,
                -0.04003427465669742,
                0.022017084764061,
                -0.016640748160236748,
                0.0015121876993010118,
                -0.0003282062106241648,
                0.0024016876004255817,
                -0.001533749986904281,
                -0.001059410693020844,
                0.00014228051518563507,
                0.0010171559284000687,
                -0.00098537252368078,
                0.0014803056202696,
                -0.007282373631358903,
                0.006022956921013669,
                -0.011801130999600546,
                -0.0025378958541131267,
                0.07969401450640408,
                0.019309597628273417,
                0.021434870467259726,
                0.029703820898607736,
                0.007769567557290311,
                0.0055564438799130655,
                -0.017511877756114364,
                -0.005548234039529355,
                0.011729427348270254,
                0.000732469344769998,
                0.0356580558696888,
                -0.01568214961289952,
                -0.005682300756657283,
                -0.009255278874318823,
                -0.003892013374878824,
                -0.0077965282331295465,
                -0.01979122802996205,
                -0.021675418263896237,
                0.028469046091681303,
                -0.008693457065101605,
                0.03343682307192129,
                -0.008705201470410115,
                0.01806592437428006,
                -0.03634096388907227,
                0.017669203692908433,
                -0.009690023199663998,
                -0.013584896714870983,
                0.026902176574445956,
                -0.0025638622000850983,
                -0.02565797718517714,
                0.026461396313726782,
                0.004905572934472358,
                -0.010554888164622482,
                -0.015794932538748467,
                0.003504490069849658,
                0.004725282555014939,
                -0.012031443025615601,
                -0.004038263552860219,
                -0.004900247378388296,
                -0.007054239587723269,
                0.041695141741496744,
                0.00943218306886662,
                -0.02769636036824008,
                0.0025708780287317596,
                -0.016318984071561668,
                -0.018410202433327808,
                0.008041575297245076,
                0.008286872508007114,
                -0.015595125404201101,
                -0.0022282298283173665,
                0.011625367370939254,
                0.007295049575341825,
                0.020778840880968905,
                0.029531358447195958,
                -0.03340848471076604,
                -0.0036180542740306943,
                0.002458140595602214,
                -0.0031581696368256796,
                -0.005533968643483197,
                -0.009745845963894688,
                -0.013934553177123296,
                -0.021527505203207363,
                -0.03810128934078285,
                -0.00267836241305546,
                -0.000860271120787549,
                0.0014000499663943575,
                0.004360796200701122,
                0.004921004548640822,
                0.029457168270915202,
                0.04303395448016727,
                -0.043796990660608805,
                0.0019610447734619563,
                0.05195210969047921,
                0.03614257142993901,
                -0.024476192028789215,
                0.015165227991746197,
                -0.0031587152091109203,
                0.04128142956964866,
                0.009291945484749759,
                0.003417838163831746,
                0.0167152075456193,
                -0.024536387214789516,
                -0.032429930506178865,
                -0.013240676213047099,
                0.09085273183402029,
                0.08418694739913385,
                -0.06903759996825834,
                0.0014300099069012406,
                0.07705009179636381,
                0.08130398509383259,
                -0.08715814556468834,
                0.015881301625465534,
                -0.01494222308859754,
                0.023942006339878204,
                0.030230948528046832,
                0.01838913043166469,
                0.0002200606094933876,
                -0.04640900224490517,
                -0.0024332667458581534,
                0.00086308872294136,
                0.23134183013715268,
                0.17481803707045487,
                -0.20777348704551757,
                -0.0059948201970249715,
                -0.05569055345810782,
                -0.026578995372043605,
                -0.03775385957902933,
                -0.00016217951818169287,
                -0.00015099157671928025,
                -0.0009523208410638144,
                0.00044071240341998937,
                0.006656282633066007,
                -0.01375108703162306,
                -0.02344289074781712,
                0.02541185575497623,
                -0.01737899798996457,
                0.01515879809691222,
                -0.03546887533601092,
                -0.021307260563943414,
                -0.003526525013226961,
                -0.03396638899624368,
                0.045989928193961485,
                0.01960021609970884,
                -0.03649732912009161,
                0.03491708011554362,
                -0.036561659428212365,
                -0.015489163022064725,
                -0.03107715059616977,
                -0.008023341061427562,
                0.05315953757793466,
                0.032465989618572826,
                0.005783444059994573,
                0.03107831815594926,
                0.008166884764699924,
                0.01339816987430155,
                0.029567266918577147,
                0.00022817530804891903,
                -0.016632348804276016,
                -0.001205802746877786,
                -0.031928182739212455,
                -0.000794173600554882,
                -0.026667886223677426,
                -0.001329850088775911,
                0.017481916024510432,
                0.00024158235280738151,
                -0.0028557924200598626,
                -0.00041100360435547144,
                -0.006501674304677752,
                -0.00003745327013678412,
                0.010200932398267318,
                0.0001425747630886389,
                0.005364316896788181,
                -0.00021010029405644405,
                -0.012264906351476168,
                0.000047938938849948394,
                0.017888950594580386,
                -0.0003352607234897224,
                -0.005227595750439063,
                0.00016367669116127917,
                0.006625616571585473,
                -0.00009187238704241222,
                0.01549723285014552,
                -0.0012126392263680649,
                -0.0015382511592922843,
                -0.000571212410217859,
                -0.0014773002563631564,
                -0.0006272075570117934,
                -0.003370390845429504,
                -0.0002577747624736017,
                0.004152102330031442,
                0.0003863956898957104,
                -0.0008317095721663816,
                0.0001123110523688912,
                -0.007339819499372761,
                -0.0018826842746466515,
                0.03524805998233537,
                -0.00025182339919406163,
                0.03359067520658369,
                -0.0004812531530998882,
                0.03145752754784378,
                0.003022023335859903,
                -0.012047124082470995,
                -0.0004337335502969084,
                -0.0017852381551471618,
                0.00031031654299859237,
                -0.006065569569742247,
                -0.0020016884282937925,
                0.03613487015665007,
                -0.00021095072804850346,
                0.04160780694514044,
                -0.00011701960415100102,
                0.02952584146446723,
                -0.0003162423940231228,
                -0.028652224444644988,
                -0.0012478562874999382,
                -0.0420519518648237,
                0.0006205931306236491,
                -0.0013810819636951598,
                -0.00023614777718646753,
                -0.052072546308672814,
                0.00014500921699943557,
                -0.0583945180998422,
                0.00001684013523693178,
                -0.02243002615825347,
                0.0005945240840921542
            ]
        },
        {
            'energy': -0.580732056260131,
            'occupancy': 2,
            'alpha': [
                -0.0005364756548231768,
                0.08941859642001233,
                -0.40596176429775466,
                -0.21565288656669815,
                0.03594361461939237,
                -0.07059516616037997,
                -0.00800252187780288,
                -0.15816535027539058,
                -0.06967088789658973,
                -0.1488572544466745,
                0.0425582586228156,
                -0.06785640929586943,
                0.0182618573622219,
                -0.020837421265665186,
                0.004471121591539465,
                -0.0018530969651424922,
                -0.03881904807828984,
                -0.08589678262142403,
                -0.05569823152181281,
                0.050080503089824126,
                0.03982493552379022,
                -0.021064628348313307,
                -0.03688997480577754,
                0.04987453373257878,
                -0.014763139046703722,
                0.001994362647025319,
                -0.01603915159331962,
                -0.00293380346481684,
                -0.001263244046885683,
                0.008592951250057842,
                0.007220211548620972,
                0.007799644905225239,
                -0.00803078004928632,
                -0.005566639091925619,
                -0.02061045841003755,
                0.00722293739806696,
                0.03297414461291415,
                -0.009181347024985763,
                0.07982695859093374,
                0.019515089735590126,
                0.007864847893630606,
                0.016964509540504928,
                -0.07959901812671491,
                -0.04969250749465009,
                -0.0037466643688669875,
                0.010373457456740292,
                0.009683776757823108,
                -0.014156425302907909,
                -0.0411342319587577,
                0.05224277636258702,
                0.013203491103770549,
                -0.04105743424672734,
                0.013473520554468644,
                0.019629222529166546,
                -0.013329966508491171,
                -0.006240468236810903,
                -0.0070711726296427396,
                0.018839627327374174,
                -0.012001029714619638,
                -0.03778114749620608,
                0.041238641081471024,
                0.0005631993558397229,
                -0.12276989320706395,
                -0.05570381828673824,
                -0.011863643339442106,
                -0.06549176171729783,
                0.038474456767921,
                0.10815765871153576,
                0.0012543253926857434,
                0.052327074468498505,
                -0.1844479885371899,
                -0.11080629459292865,
                -0.0018859126329551315,
                0.005491606335972172,
                0.006084040459366827,
                -0.004360953803203967,
                -0.0001570309269266823,
                0.004741381024624496,
                0.005678053615203008,
                -0.00649360498327169,
                -0.004496898654711396,
                -0.01241779104727377,
                -0.016410786775781318,
                0.023763491375659744,
                -0.03979170004561737,
                0.002256618594245681,
                0.051535098694635795,
                0.10903689287205495,
                -0.004890114417957737,
                -0.004806894471814059,
                -0.01062804296409589,
                -0.008190020132664316,
                0.055824262527159406,
                0.1040316737610668,
                -0.031251584705875156,
                -0.07191028293870416,
                0.02618135528381132,
                -0.17156484581642223,
                0.10416535306283009,
                -0.08779542171671277,
                -0.025784533291817218,
                0.1276600224708091,
                0.031188202006401326,
                0.17391650951066312,
                0.009762418279856524,
                -0.0004552684163705656,
                -0.025373284621970776,
                -0.0022270882785406804,
                -0.021597297179826884,
                -0.01071845788186807,
                0.020572230461297504,
                0.024115480247769543,
                -0.0970497738867474,
                0.06857284847368848,
                0.07394722139836901,
                0.15748672288879043,
                0.09897101225968154,
                -0.13652103868832938,
                0.1284317681005126,
                -0.022529331626263867,
                -0.018080483604871304,
                0.01645541987206094,
                -0.004479017599425626,
                -0.03215849688809892,
                -0.0022077488213659373,
                -0.006405220512345155,
                0.022931115044056594,
                0.01409647082643796,
                -0.00115297379123588,
                0.03892459568401929,
                -0.17646302731981522,
                -0.09119675014552599,
                -0.00013783620394499632,
                -0.008054332293917353,
                -0.005694977463057743,
                -0.00558866990299702,
                -0.00558614281593466,
                -0.012877100940861039,
                0.016081237187566145,
                -0.024524809467881045,
                -0.006051001193982774,
                0.01405610311883728,
                0.002156449992291139,
                -0.026738828542227776,
                -0.006563446147380972,
                0.004030443299774457,
                -0.004769944430029175,
                -0.0019360826117231003,
                0.003842391670445234,
                -0.0033059691844138247,
                0.0065768484494384966,
                0.003610830014831232,
                -0.005406769966730141,
                0.0016737957857105518,
                -0.007449062615651443,
                -0.004440987029440069,
                -0.007940729203527725,
                0.00032697441824933345,
                0.009038084418634521,
                0.006138718512535463,
                0.0034408165590542814,
                0.0015430670401069123,
                0.003210188926065278,
                0.002579807872301949,
                0.032547639949899315,
                0.0034789661029153407,
                0.062363077170994215,
                0.002767404241239388,
                0.015671239060093052,
                -0.00040239741343411114,
                -0.01652494373236618,
                -0.002998797542695496,
                -0.028169254862073372,
                -0.0031588388897199927,
                -0.0366906800369364,
                -0.0012422341981205602,
                -0.05290517497636903,
                -0.002463263888471485,
                -0.05116569522211978,
                -0.004863223840417477,
                -0.0023852535276252026,
                0.0002459372591216551,
                0.004865533185525888,
                0.00007609964851117478,
                -0.005925581089428881,
                0.0001124517444367489,
                0.006394404794258031,
                -0.000009071856762935149,
                -0.0004792984019109196,
                0.00009668659407263992,
                -0.004709787644197242,
                -0.00017045270508029734,
                -0.01992055694569931,
                -0.000010047397422093724,
                0.09443779591042684,
                0.00822653037113059,
                0.0341579685763606,
                0.004668196056502994,
                0.030405204900004576,
                0.0017478411864880227,
                -0.03163160365577162,
                -0.0016763350463616577,
                0.0012091032013715017,
                -0.0017791964160048554,
                -0.015357839763854946,
                0.0004309940867259436,
                -0.031707190008844234,
                -0.00017905869051675435,
                0.00015862028586263854,
                0.000007113721875948786,
                -0.07029054202127914,
                -0.005364251890780786,
                0.07486711927467424,
                0.005458279365987356,
                0.006433133918317575,
                0.005021051011760799,
                -0.0324121004145551,
                -0.00002204389738988361,
                -0.01833697030059754,
                0.0002829176329522984,
                -0.021531614428949394,
                0.00018759996105270656,
                -0.003715018378809146,
                -0.0008576696569278955,
                -0.0034150600437323686,
                0.00021704835306078947,
                0.031679903960130665,
                0.006244647895665334,
                -0.006737888950048394,
                0.00003705398712370963,
                -0.011400933454004012,
                -0.00006297516048149986,
                -0.0008812937797300365,
                0.00012274069907070506
            ]
        },
        {
            'energy': -0.5798206023470694,
            'occupancy': 2,
            'alpha': [
                -0.01537808531107648,
                -0.19789081033592504,
                -0.20747187722504504,
                0.05104271925520109,
                0.07583705947624704,
                -0.13766436519021588,
                0.059479576010207404,
                -0.015935654605342846,
                0.10967732847009068,
                0.22593290991778564,
                -0.08300657145987345,
                0.03226736986498776,
                0.07176013844636395,
                -0.08194564476225588,
                0.026969645715298404,
                -0.02664409935279526,
                0.025699376587209714,
                0.045222662448705056,
                0.03937003492744238,
                -0.028478279443206335,
                -0.022792812600571213,
                0.011663495576661416,
                0.02018729944243382,
                -0.026345851563804368,
                0.036076116886192645,
                0.02367682437443529,
                0.009039325334368156,
                0.03671254396049802,
                -0.002715207768928998,
                0.0970478331859693,
                0.038402964678754196,
                0.03705875400387396,
                0.05342603163380051,
                -0.012180590252190706,
                0.02564671212457448,
                -0.05387595176527119,
                -0.03330349731181378,
                0.047603849534473996,
                -0.03220557622446123,
                0.1753552545411666,
                -0.08019224796252485,
                -0.0082625163373979,
                0.013996497144926054,
                -0.053832463513377504,
                0.04601002002982856,
                -0.05984483754882754,
                -0.05126321504409549,
                0.05503251922405147,
                -0.022187623306861828,
                0.1621581582445637,
                -0.03408545101440507,
                0.09407504396140469,
                -0.06055552108803976,
                0.0284707039191432,
                -0.01819228522431628,
                -0.012394553480623188,
                0.05512558097635651,
                -0.050132320186645186,
                -0.05848168249767295,
                0.05136317386107123,
                0.02671433518584153,
                -0.05650893512839285,
                -0.05275985804998844,
                0.06447067924560274,
                0.031350436514111964,
                -0.05099544386296651,
                -0.04580676817590442,
                -0.06750741861041906,
                -0.042495741464454256,
                0.07328919521778317,
                -0.042116657704349934,
                0.01758007937376241,
                -0.004321013270388471,
                -0.03324537983732215,
                -0.012821499406142113,
                0.04777107176774638,
                -0.008395153963867478,
                -0.01373249627958621,
                -0.04013191893447356,
                0.022391081622164632,
                0.027939024557773567,
                0.037779838410169915,
                0.07200869042037385,
                -0.08874870635642394,
                0.00005834975647675528,
                0.006981846112124405,
                -0.04756774972760269,
                -0.08935669223605971,
                -0.025005125157819354,
                -0.0345781267145491,
                -0.04376773924300582,
                -0.060135045251226996,
                -0.03951072631036504,
                -0.06165043271920682,
                0.02342473418697957,
                0.0582712749916919,
                0.03511651090522231,
                -0.03636411961532045,
                0.019725334216580796,
                -0.010229987400401028,
                0.02414334836793808,
                0.0285652348135605,
                -0.004016217459172545,
                0.04036597279644652,
                0.03667784274745446,
                -0.007717228682576902,
                0.10768686762537844,
                0.013181523742732138,
                0.014643200086272446,
                0.04202356590394237,
                -0.05608000550595699,
                -0.09057354327246277,
                -0.06104213142293558,
                -0.04156496087955723,
                0.018046832472587634,
                0.045622639222759345,
                -0.01827318579743315,
                -0.07350057528324017,
                -0.008467527183395294,
                -0.0147491451568449,
                0.034040484407126655,
                -0.04246365234966187,
                0.05531398641762611,
                0.08155494102270448,
                0.03692971685083841,
                -0.001862990619208979,
                -0.118716962727639,
                -0.005055849873975884,
                0.001935167843408542,
                -0.04629504564772955,
                -0.10339167729570732,
                0.0662844513775623,
                -0.012593028592722624,
                -0.0712788288344766,
                -0.037331965361787164,
                -0.049928108890794964,
                0.00013714726365703504,
                0.006296452709027213,
                -0.014258332674081515,
                0.012852350262763547,
                0.024647906810726053,
                -0.040974345072300446,
                -0.06296392638924249,
                0.07366824572346722,
                -0.03271800876001755,
                0.020021696759937712,
                -0.04488355315872722,
                -0.026558749806829596,
                0.005651946400679452,
                -0.04364105563751915,
                0.05694239845430281,
                0.023953175486022212,
                -0.043878505783212694,
                0.03932098092581965,
                -0.05179368554361007,
                -0.024530165189559416,
                -0.04528954596551153,
                -0.0035809369821590423,
                0.07328514457097829,
                0.046899750546782464,
                0.010104766788929725,
                0.03748075871281563,
                0.017439835842134137,
                0.02120097520564886,
                0.11044448262538852,
                0.001604879939893491,
                -0.10017401667757284,
                -0.008547153376312833,
                -0.06450901709596085,
                -0.0012405889621722609,
                -0.1262323725305806,
                -0.005781709682676878,
                0.07640120313567592,
                0.0034731971347295157,
                0.01645970813869065,
                -0.00043789237492886557,
                -0.024602353457870634,
                0.0005050328815667968,
                0.08102533977189036,
                0.0033642429695467596,
                -0.012081156054075582,
                -0.000509757128036089,
                -0.04064342245373284,
                -0.0003897319859113913,
                0.02619304810863011,
                -0.0008214239288202877,
                -0.03469389522012296,
                -0.0002442635308157573,
                -0.010972430315212096,
                -0.0005867232798973905,
                0.015525393170433185,
                -0.002282420454632262,
                0.0038461956593038417,
                -0.0033777002863341773,
                -0.0574233940149393,
                -0.007992795910125217,
                -0.031612683232141586,
                -0.0034240998105568407,
                0.019941643682809058,
                0.0017485147018041797,
                0.0023499446871045396,
                0.0006357766994195022,
                -0.02744603373776195,
                -0.007758627281018502,
                0.0914327475232789,
                -0.000706716188344411,
                0.0910251073211581,
                -0.0009979566059640874,
                0.03132319628042991,
                0.0032502816591277075,
                -0.06030344290188854,
                -0.0014797962025627442,
                -0.030353884085484253,
                0.0006116427033147098,
                -0.041906821341748786,
                -0.013467353392145125,
                0.09167552973175021,
                -0.0005758641764468503,
                0.10232917445555235,
                -0.0003975054486696753,
                0.08651073904238787,
                -0.0006686075506172564,
                -0.03725912555099047,
                -0.00266296533246172,
                -0.048992677238711126,
                0.001096492656224759,
                -0.022302456700597828,
                -0.00416825688395048,
                -0.0650466568193986,
                0.00023543928337634018,
                -0.08296106605951574,
                -0.00013778249901557404,
                -0.028792686336332633,
                0.0008227112172927922
            ]
        },
        {
            'energy': -0.5780082341957085,
            'occupancy': 2,
            'alpha': [
                -0.01930393882113963,
                -0.16742314699391367,
                0.10634762377807258,
                0.07299159242358164,
                -0.004894887461393492,
                0.028890362599224693,
                -0.18704456651544665,
                -0.0516499506351327,
                -0.16231456415582315,
                -0.3408905385831204,
                0.12734173629102377,
                -0.07754766924181451,
                0.13089087492597656,
                -0.16591841033784682,
                0.037867430176580695,
                -0.0358332997227263,
                -0.040482690337987834,
                -0.1009836029687733,
                -0.065460508770101,
                0.03757562688488329,
                0.032896892079702485,
                -0.020969915689262104,
                -0.025511970334289837,
                0.037283043521540986,
                -0.02842771509960827,
                0.06605425724325743,
                -0.0765242512210943,
                0.035095868481507204,
                0.0009507371546792823,
                0.10376752362936968,
                0.07015890519257496,
                0.06633297602398537,
                0.011162119481554938,
                -0.0612783371324474,
                -0.04759295057451346,
                -0.04258128852035764,
                0.04405456068058979,
                0.050584745456135394,
                -0.09148164995172849,
                0.0492814301703634,
                -0.04209268125785899,
                -0.040357054026074236,
                0.026325795634686188,
                -0.06202691860000613,
                0.06693898464251515,
                -0.032195489826006875,
                -0.025401034699472413,
                -0.0039857785654893564,
                -0.006291246234772237,
                -0.10250171001096976,
                -0.03837261917511481,
                0.05509416091260421,
                0.00025773813807216907,
                0.09936046005290919,
                -0.037522994608206524,
                -0.00844955209748569,
                0.042596603089004106,
                -0.006482251863940446,
                0.002348168182068751,
                -0.04233077596788892,
                -0.0550300587910613,
                0.03593529930821933,
                0.05468872748977022,
                -0.14126281783229955,
                -0.02911520901772282,
                0.05220581890105723,
                0.06588696089829468,
                0.08370205643382068,
                -0.04419063180441255,
                0.05357648718376159,
                0.0592696778736128,
                0.07824323951238929,
                -0.02972933319444303,
                -0.0006662688493144214,
                0.021721028005331766,
                0.058622281396967506,
                -0.012923756473253637,
                0.00797408392128088,
                -0.03607823640638485,
                -0.004418951989659098,
                0.003214124181149795,
                -0.009545404241449923,
                -0.0010485654886512293,
                -0.003933829699383484,
                -0.023602028655369926,
                0.00012787425712597046,
                0.09366586616607815,
                0.15646079457354184,
                -0.0492883268658369,
                -0.059881783019650386,
                -0.08530879511561211,
                -0.09044760993407142,
                0.05837189267330445,
                0.13002645438036894,
                -0.04326711117361423,
                -0.09800426887596982,
                0.02236042673756505,
                0.06563661468644794,
                -0.029000328311473523,
                0.03548598550898929,
                0.05659335965405845,
                -0.03200864909039411,
                -0.014145945359960294,
                -0.057485016242811535,
                0.0062700341234139985,
                -0.0027333677522256264,
                -0.0036935861895883897,
                -0.0014171014440509547,
                -0.005296252236821356,
                -0.005773654585308701,
                0.006247488940695283,
                0.0019912477995723734,
                -0.009630328435381712,
                -0.06335025125768858,
                -0.009133350600729376,
                -0.06013422700677409,
                -0.07990430888326767,
                0.00800630123285024,
                -0.06233432520972835,
                -0.028894299077986175,
                -0.00447261202551245,
                0.003441167447002988,
                0.0008769633214440327,
                -0.009145853258822206,
                0.001088728901199362,
                -0.003881863456327942,
                0.004040415818363282,
                0.004286838247998246,
                -0.0010980512540387447,
                -0.013817374854005082,
                0.02783565217137891,
                0.08008765163144843,
                -0.022007903053288116,
                -0.08368010189364726,
                -0.05018663622482443,
                -0.058682204907247376,
                0.003712510917031904,
                -0.013558252641291324,
                0.02710862974203583,
                -0.01840435572731774,
                -0.0006639077682736458,
                0.0028926441809274473,
                -0.001598594541818947,
                -0.007555975682628999,
                -0.05731963448711968,
                0.026667092302922978,
                -0.050796427489856306,
                -0.02753354956726789,
                0.02629631221410975,
                -0.05104938918741498,
                0.06235436809773642,
                0.026719039342048265,
                -0.04784995994502472,
                0.03457672097115822,
                -0.07071166976092823,
                -0.03795233977999473,
                -0.0636649176862312,
                0.008152504233182334,
                0.09537283785198425,
                0.06515999499786541,
                0.018425186629096823,
                0.037961604901037095,
                0.032981342589914364,
                0.03191437370385356,
                0.055024447283691165,
                0.004357123359458429,
                -0.06991592723555264,
                0.002183873234147965,
                -0.006681292601521946,
                0.0023167972515041506,
                0.01103304879611151,
                -0.0015232902739842724,
                0.03278609385649775,
                -0.0028223593017367913,
                -0.08136277027710148,
                -0.005817045586121312,
                0.027977343773509956,
                -0.001116081012012033,
                -0.09498885396825724,
                -0.007296393229658959,
                -0.02700801982039255,
                -0.0011209881535667653,
                -0.04237277429321001,
                -0.0008141206788227011,
                -0.014640631840421588,
                -0.001103623100142741,
                -0.01812977199626373,
                -0.0005728175780733042,
                -0.024340795859806218,
                -0.00016757431550345743,
                -0.003539750994183159,
                -0.003031988014032121,
                -0.019836492112267033,
                0.0035833186646945293,
                0.11206076641712237,
                0.013201476487087771,
                0.042610200966984244,
                0.004985639946749137,
                -0.0005427880446551399,
                -0.000134736626376623,
                0.025842152753359264,
                0.0021964079232436556,
                -0.03903718431571797,
                -0.0043024076628092826,
                -0.00028146903312957196,
                0.000038880409484309315,
                -0.006807313531635613,
                -0.0003526137404861184,
                0.017990505392891012,
                0.002464906805321301,
                -0.022467361959146233,
                0.0011457777260802317,
                -0.08191786077740774,
                -0.0029205800432529076,
                0.05316687516248065,
                0.018898183635889076,
                -0.007874058587691742,
                -0.00006919116426341856,
                -0.0026691226045808705,
                0.000055296219040636256,
                -0.004429264179998007,
                0.00002768457862451889,
                -0.042266850171972736,
                -0.006148011044945756,
                -0.0477268206233416,
                0.0018212272971203044,
                0.03643443250440494,
                0.006854276596815625,
                -0.07338321128699302,
                0.0003771556104527313,
                -0.11268458942983856,
                -0.0005111581731269316,
                -0.03192196545554822,
                0.0011100707736328925
            ]
        },
        {
            'energy': -0.5659137738664367,
            'occupancy': 2,
            'alpha': [
                -0.011866062769937048,
                -0.07666471566033235,
                -0.0037712081607002494,
                -0.08530818095888083,
                -0.05801181634404505,
                0.09438102378377555,
                -0.004876511094736797,
                0.012300001235426163,
                -0.04652954875946114,
                -0.12628969527365536,
                -0.025742301816457827,
                -0.00009461919128028768,
                -0.1653542642316261,
                0.2764895173452682,
                0.026868936625428247,
                -0.154992401540355,
                -0.016567558197345813,
                -0.017495611705429293,
                -0.020901399517510407,
                0.03634684278224971,
                0.021649538613857964,
                -0.006685708457072024,
                -0.00680476808116496,
                0.042403689856239636,
                0.011932868056508493,
                -0.132937934393273,
                -0.09031783568927625,
                0.1323227846148022,
                0.002936278017085518,
                0.025474418749181056,
                -0.023165295652947386,
                -0.15193945409172543,
                -0.0630688483365898,
                0.01411622975354628,
                0.009473415911617999,
                0.054850915793193386,
                0.006369459164723857,
                0.1102265970060881,
                0.07294970282751652,
                -0.09482910887070023,
                0.03519833229314167,
                -0.059052565686887167,
                0.06992513742998395,
                -0.11328635424626067,
                0.016279578124509073,
                0.041778824503605025,
                0.056957517000137486,
                -0.06463108180289673,
                0.038563820029218654,
                -0.07170024428339308,
                0.07228684589854403,
                -0.029759206420137855,
                -0.11261311466424265,
                -0.07275421307559993,
                0.09733874138228961,
                -0.07872985362231034,
                -0.090389782177665,
                0.07917058488193181,
                -0.007020642729523831,
                0.09970434140209829,
                -0.03808307235940657,
                -0.00015430735896939263,
                0.034291525803292075,
                -0.01757393546829137,
                0.004644118559755534,
                0.035694079537184877,
                0.04393907931253606,
                -0.037795870695334834,
                -0.1035626992928014,
                0.06972612414356347,
                -0.01929327167833082,
                0.04505795542706521,
                -0.019510779015929156,
                0.018956378613332475,
                0.04869144397980117,
                -0.015930485638050176,
                -0.03788642074043095,
                0.030603266382324617,
                -0.014067727103569965,
                -0.02687504209314006,
                0.06320459955725188,
                0.0355479526100783,
                0.008306992567038925,
                0.020932151753282682,
                -0.01148717020270905,
                0.0004278782701280295,
                -0.014301127331544511,
                0.05639018836662006,
                0.06061486407450777,
                0.05334655097562603,
                0.2039758490377658,
                -0.085197232800127,
                0.00863460058452228,
                0.02730929381397164,
                -0.023083461530703526,
                -0.012460678135038464,
                0.07000455786616737,
                0.021941496436913472,
                -0.015844237531415298,
                0.010042610187637635,
                0.05661631136441995,
                0.02713810703324192,
                0.010571419329126915,
                0.036165878150161444,
                0.053940613455647476,
                0.04094282744001646,
                0.09068833218800641,
                -0.03983536246069573,
                0.058273290074203093,
                0.06572664319321378,
                0.0010883881041525217,
                -0.0902070027215734,
                -0.07060012262170519,
                -0.08196545901710665,
                0.07340574104621812,
                -0.022852062949365218,
                -0.05773464311479224,
                -0.054281688622069404,
                -0.02772259754813823,
                -0.08760288858194806,
                -0.03920517547529642,
                -0.032411428628395446,
                0.01298724193501623,
                0.07719210889017554,
                -0.04489454927223411,
                0.0005598163181108063,
                -0.0844139160150974,
                0.009718798226104913,
                0.009544247584767698,
                0.02380309864606708,
                -0.011943743573407549,
                0.01637487196055514,
                0.007146743570246902,
                0.03756787852015326,
                0.033957340674118305,
                -0.02829234645753233,
                -0.0002242841371577357,
                0.0005780105119815458,
                0.01341292969407049,
                -0.017572786834602717,
                0.062184520444018,
                -0.06115028063476737,
                -0.08395785208013443,
                0.12314875963426516,
                0.03141348425636512,
                -0.03377501321970855,
                0.0014658097334452557,
                -0.03263379228112803,
                -0.0541558802067381,
                -0.0017700928959707182,
                0.014088955066575199,
                -0.014364430949254346,
                0.023210658958773164,
                0.03193246834602591,
                0.040669966191683254,
                0.025725529573150472,
                0.04370366895779164,
                -0.02427437837169592,
                -0.027179540844625285,
                -0.0345347487285069,
                -0.034782892393418766,
                0.03424959447305613,
                -0.022125526089807192,
                -0.012215199153354327,
                -0.0027984696915300967,
                0.00007832963203509564,
                0.07226009492039873,
                0.005537482222313389,
                0.07364573122330473,
                0.004090291849301946,
                0.05086011441027213,
                0.0057489845485395735,
                -0.05461113862195929,
                -0.002459097581922456,
                -0.02005774541545052,
                -0.000343821120031091,
                0.05346139745229544,
                0.003212606221087919,
                0.008676163080023556,
                0.0010134106754761227,
                -0.030720112777165697,
                -0.001151726855643118,
                0.022268134001531086,
                -0.000018211997625747643,
                -0.022373807736860082,
                -0.0035064836753496594,
                -0.003740352686911908,
                -0.0005931643012355023,
                -0.032706520680961935,
                -0.0011347679270040784,
                -0.02238299618138414,
                -0.0016736752564603262,
                0.006407704096548673,
                0.0009572294675032711,
                0.01839137426328291,
                0.003766356809164045,
                0.001569341295535159,
                0.0010653283751107159,
                0.03313700738541967,
                0.0030915135401832984,
                0.027492503565476573,
                0.002311726757167785,
                0.031972543122824264,
                0.0069856455477708464,
                0.08836829475951241,
                0.0009292283100538227,
                0.10149701079407708,
                0.0013377104523657826,
                0.04451024897504241,
                0.005649466529268728,
                -0.11504118979179058,
                -0.003790624032974055,
                -0.10124577546632524,
                -0.0026421536881991196,
                0.01844899553558604,
                0.007410679956685255,
                0.04268809992483716,
                -0.001373430482509874,
                0.04273021730299429,
                -0.0015706264318440127,
                0.14908539305418217,
                0.0017681157150362349,
                -0.02130476430467815,
                0.009806001236132999,
                -0.029130000527213134,
                -0.00252299555263307,
                0.013833047646032885,
                0.0034787005804168642,
                0.010793913923877567,
                0.000027090913783337913,
                0.05246170074475411,
                0.0015196923015159734,
                -0.02953081858785624,
                -0.001115433506911102
            ]
        },
        {
            'energy': -0.5628992642596937,
            'occupancy': 2,
            'alpha': [
                -0.009192069730195188,
                -0.05482777045252566,
                0.03145661214895707,
                -0.11112460249026407,
                0.010838166482598176,
                -0.0001267862191517976,
                0.0022688611916545183,
                0.0036959279585811315,
                0.049543253920619514,
                0.1430487498423427,
                0.07535572300391324,
                -0.002605656828274811,
                -0.039068326758902545,
                0.10307785224522974,
                0.104166677139597,
                -0.1870641574054801,
                0.0279412634173159,
                0.038789888344973565,
                0.03428129415100112,
                -0.070335753929047,
                -0.04041435885915279,
                0.0114402799145938,
                0.00610593765526745,
                -0.08626302922499633,
                0.02499334813191191,
                0.16177595316827514,
                0.08068812244734008,
                0.006738921917551523,
                0.0028002804934452235,
                0.030459160612634442,
                0.05736740254582254,
                -0.12733223305223865,
                -0.09677021281513497,
                -0.05300261139741753,
                0.04511393690843111,
                -0.06274922498805655,
                0.010758459681549629,
                -0.1570373796932247,
                -0.032283141235134885,
                0.038832801334982334,
                0.030173043652188782,
                -0.1794220086130331,
                -0.03417023112641027,
                -0.002789744493624793,
                0.04947549113839265,
                -0.06178313328907373,
                -0.02117665809810561,
                0.00909003303875297,
                -0.020858498329293543,
                0.016620064466273857,
                -0.05667568623424465,
                -0.05977058453729522,
                -0.03196626776082258,
                -0.019740443015600975,
                0.011984686442536602,
                0.008081849506778723,
                0.15695575588433242,
                0.11571949904237078,
                0.029993750245799474,
                0.027016998999180225,
                0.044799446121284434,
                0.008347244441825151,
                -0.025498514650464262,
                0.004485135795212369,
                -0.0276559007939341,
                -0.037162497909698486,
                -0.06495441884984883,
                0.0717760219688498,
                -0.130976247591612,
                0.020928278148352516,
                -0.049525832785675926,
                0.08612279409083488,
                -0.020980252738475293,
                -0.057137022783271395,
                0.011906645350034311,
                0.06472980438158454,
                -0.03516719032587571,
                -0.018681416650514586,
                -0.07911824633989945,
                0.012996799802843722,
                -0.056019057921471535,
                0.059349411394728394,
                0.01360741846202371,
                0.0014403149407657793,
                0.031226471918303376,
                -0.0021943421103859505,
                0.031501664895510886,
                -0.08033465224405471,
                0.009635689510951803,
                0.04151701540613473,
                0.13258020109524848,
                -0.15232574121111328,
                -0.008356568767894828,
                -0.0524824366335441,
                0.041628642295847236,
                0.0035051144214496037,
                0.07598835671505316,
                0.01856251328016477,
                -0.04851114842843062,
                0.02431839979078645,
                0.07074251326624045,
                0.010454656198294927,
                0.00217155599305181,
                0.06337111530044659,
                -0.07454540084727934,
                -0.007716598247924786,
                -0.09366824192513702,
                0.05709777354481328,
                -0.058861989450840764,
                -0.03444156710808455,
                -0.017787116028259338,
                0.1134709406397512,
                -0.07674181656850712,
                -0.10437073069568974,
                0.0833509278110384,
                -0.025327667705288312,
                -0.06776469840357019,
                -0.069290316269878,
                -0.04702874396131748,
                -0.10701427853660574,
                0.059971624259699666,
                0.039857184660396165,
                -0.019211690485437208,
                -0.05690729467263492,
                0.05805131219291169,
                0.02096925780971454,
                0.0832245637019034,
                -0.014961797548114239,
                0.01647497338752393,
                0.026288076265975183,
                -0.002723331766114694,
                0.010477757640262906,
                -0.0015265149578850383,
                0.02094393865230004,
                0.034741149090065176,
                -0.04982002620451287,
                -0.0007406848209405022,
                -0.001762291134292316,
                -0.026667953611394197,
                0.03481265011490169,
                -0.07020561554951807,
                0.0748456165747916,
                0.1041879164267182,
                -0.12365692056410085,
                0.0014328144546730752,
                -0.005893890946205492,
                0.008731537544648286,
                -0.027987437006799572,
                -0.013903542221726453,
                -0.0018650958714024743,
                0.016212057045040005,
                -0.020893228046358313,
                0.008036841836361601,
                0.011693565622515856,
                0.011961981246421859,
                -0.0023706225899055,
                0.011596355335697127,
                -0.0015585913195427898,
                0.0031976499800653304,
                -0.012007669072890362,
                -0.010904381477549121,
                0.01646772279211437,
                0.0017631039772596003,
                -0.003817651373909854,
                -0.05026668449956167,
                -0.0023934000087085846,
                -0.011404977483371633,
                -0.001384769955466907,
                -0.026873973237246968,
                0.0011096945091070619,
                0.029568818097530338,
                0.00020043183843561013,
                0.003506215145301793,
                -0.00023159898303246748,
                0.019005233522492657,
                0.001638584349887722,
                -0.07975866574526336,
                -0.006432659843313915,
                -0.037773171686071014,
                -0.0026853865631772268,
                -0.04488059364094714,
                -0.0011200015439392181,
                -0.05544422716032256,
                -0.0008709073419208706,
                0.0439422081359709,
                -0.0029748268205298718,
                -0.059682606380043704,
                -0.0008494898505217672,
                -0.0460017147234671,
                -0.001277358061537507,
                0.030420559359427377,
                -0.0047400250530931455,
                -0.010877721023200577,
                0.00020814978229590641,
                -0.032539771534716856,
                -0.005127983870544327,
                0.014828023180571578,
                -0.0008687014564606121,
                0.04426730625459798,
                0.004728049362404781,
                0.036960433909021144,
                0.0037047294067665063,
                -0.0010446994963427486,
                0.001067472471486686,
                -0.09993582453337843,
                -0.001166503957329918,
                -0.10299085841422506,
                -0.0018472790352938632,
                0.009206148338892368,
                0.002189433338547605,
                -0.13573842266908587,
                -0.004380584103396076,
                -0.13037052522135237,
                -0.004078584632457783,
                -0.015935783801138068,
                -0.006076617826024824,
                -0.025731062303664065,
                0.0019523493889963888,
                -0.035652442722982555,
                0.0017884789707233104,
                -0.16711469494919798,
                -0.0026352455451846717,
                -0.009981127622699126,
                0.00238198610978908,
                -0.012086090190592215,
                -0.0006266608693749759,
                -0.02360404016823281,
                -0.006537467393379854,
                0.0012147514486987635,
                0.00011874880107954028,
                0.008524023698126744,
                0.00042943817680699215,
                -0.01491080861337796,
                -0.00038092608982473437
            ]
        },
        {
            'energy': -0.5615364960477207,
            'occupancy': 2,
            'alpha': [
                0.004845568611877626,
                0.01540328882909074,
                -0.010095302472529809,
                -0.0121376670515033,
                0.06050001555215868,
                -0.11064902272392235,
                -0.06713179236227645,
                0.009364886929357911,
                -0.04646228776838777,
                -0.12715387284008367,
                -0.08520329285016055,
                0.0049897696968080624,
                -0.20011609187671117,
                0.2345634310970156,
                -0.2155796107722633,
                0.13061615340842203,
                -0.025842772976166235,
                -0.05182026310502023,
                -0.031495665777145826,
                0.06950066655261224,
                0.03961078225836982,
                -0.011016326661870414,
                -0.002123429947016774,
                0.0883943305463496,
                -0.004015046784939554,
                -0.10149685612692962,
                0.04129584978375882,
                -0.07425704305381296,
                0.015071453293345105,
                -0.032470695286949625,
                -0.14475182178917811,
                0.015601724103491966,
                0.0661183462838648,
                0.1080384891001841,
                0.10166903155180054,
                -0.026012469185491223,
                -0.008197955523746333,
                0.11569258895241807,
                -0.0720048597239016,
                0.10550796012948352,
                0.01273120168120433,
                -0.09565094937170558,
                -0.03469491285520613,
                0.05253305904135086,
                -0.013868838083763815,
                -0.011973352794964365,
                -0.03251473704459843,
                0.09629994364387531,
                0.004785565436788332,
                0.05514991876314021,
                -0.07222947095382777,
                0.21521308005600887,
                -0.1245868367144773,
                -0.06217704732024063,
                0.034439210467026665,
                0.06389579825204873,
                0.03995492951119337,
                0.07190385088097584,
                0.021668052089300352,
                0.06527360993377501,
                -0.06427224654655907,
                -0.0059080526207531785,
                0.05622950604592256,
                -0.013923530623400503,
                0.035199477512369626,
                0.059538008370792914,
                0.07174195108959477,
                -0.09581805461027193,
                -0.03769225018312459,
                -0.02099489717325736,
                -0.014223447243128991,
                0.024253957611118645,
                0.034924517770984397,
                -0.018827075260507715,
                -0.06719221361002162,
                -0.02132789757746255,
                0.02561278125018974,
                -0.015232707085789925,
                0.01645783212886314,
                0.053203094803982706,
                -0.03512871865505213,
                0.03680797982455739,
                0.012791845453807137,
                0.007831828735979702,
                -0.04081209296734789,
                0.006657740220938346,
                -0.033783917663456904,
                0.07790309084316395,
                0.05486804111904882,
                -0.06265270261871204,
                0.031695498968492976,
                0.19423055827853608,
                0.003737374613822063,
                0.06674549012634576,
                -0.039247379746577646,
                0.006377885288844837,
                0.009419298746876628,
                -0.0030114203756012843,
                -0.02567852921230081,
                -0.01738569640702784,
                0.012239148605725354,
                -0.00537707426756525,
                0.0018412227410189656,
                0.01598519781143459,
                -0.05243473413227456,
                0.00021911109064838178,
                -0.051359837861037164,
                0.02690305574334071,
                -0.028880198858386094,
                -0.017734130845490206,
                -0.01996499794140228,
                0.06499066872859703,
                -0.023616079932720007,
                -0.015235348169066848,
                0.026060746010376917,
                0.009008089798191711,
                -0.011959611059863996,
                -0.009598143915008303,
                -0.026591582187307488,
                -0.029291764080755532,
                0.03730602107381268,
                0.01765092622258558,
                -0.018723002103193023,
                -0.02142683141141925,
                0.030860885824373758,
                0.017256649631184146,
                0.046893455254900726,
                -0.016647262731221153,
                0.019804476663959035,
                -0.008808259397689908,
                0.002195454565105639,
                -0.01149387201463356,
                -0.006027393139116285,
                0.02939763551597047,
                -0.021084265622744975,
                0.04767399628524951,
                0.0011752765342565017,
                0.0021570527467181196,
                0.0268469435602221,
                -0.03520409428247675,
                -0.038677270165727105,
                0.03923829406458129,
                0.06649636282679051,
                -0.06216019453656112,
                0.0012174570852963621,
                -0.06351292750567693,
                -0.039425282953585536,
                -0.021009427439587183,
                -0.07107380842705963,
                -0.04328041837404069,
                0.0033929431803190403,
                0.011879077470553941,
                0.04503891549429162,
                0.04324427210994521,
                0.025609170704531906,
                0.0381001632145465,
                0.06016546168828423,
                -0.020221407899291582,
                -0.018316131507572882,
                -0.008085925937020193,
                -0.057101713111788556,
                0.07659889478794674,
                -0.011639742999113033,
                0.019581472969458627,
                0.10096200442992849,
                0.005081070458553197,
                -0.10582157837850498,
                -0.008142685820467054,
                -0.06620022543294062,
                -0.0029620717833294214,
                -0.14243471971448882,
                -0.009114201109359815,
                0.15854241136529004,
                0.007431174803962512,
                -0.027135071444619418,
                -0.005252193385951606,
                0.10366650528605374,
                0.008346930465681678,
                0.04453471068884962,
                0.002442930588444442,
                0.047932732757142035,
                0.0016416523755295245,
                0.0011348264783518811,
                0.00012989098339976756,
                0.0337176531154288,
                0.002452323947910609,
                -0.01598710004454133,
                0.00007271428858360788,
                0.04837393698337764,
                0.0009554883546881082,
                0.009122502797108852,
                0.007672252051048412,
                0.014980137181030296,
                -0.0018206899376259254,
                0.04218863198524533,
                0.005394215169954339,
                -0.028766751661986553,
                -0.00014266493219948845,
                0.03382854044273333,
                0.0006313811329631357,
                0.012037579650012314,
                0.0009492281268373844,
                -0.06288008765077588,
                -0.013917599443716917,
                -0.05907334726904026,
                -0.0014680876289264006,
                -0.05270882075663821,
                -0.0011543908423202892,
                0.046307902472673614,
                0.005772617366231148,
                -0.03506877195365317,
                -0.002071431797978276,
                -0.03789053282254657,
                -0.0014239458788044,
                0.01452467050019001,
                0.0040818082345129274,
                -0.007778822953696132,
                0.0013281863520251361,
                -0.02060204441396103,
                0.000941014362754287,
                -0.09247384840551752,
                -0.0015660961192779789,
                -0.055659308712977626,
                0.011052489076416256,
                -0.06268977627176094,
                -0.00375955616803792,
                0.021999147227806364,
                0.006445611991389979,
                0.008893811361311276,
                0.0007223583037823674,
                0.04363354808772273,
                0.002331421577566294,
                -0.08024737820349195,
                -0.0021137364767089798
            ]
        },
        {
            'energy': -0.5576424436873186,
            'occupancy': 2,
            'alpha': [
                -0.0020584105480880017,
                -0.017818710640985294,
                0.0910114276742276,
                0.023886486802775556,
                0.11748516758542037,
                -0.3076982769297102,
                0.19721633366465408,
                0.016726283458987135,
                -0.006528641303691947,
                -0.04197063435303249,
                -0.2099871021092994,
                0.04143431435666829,
                0.05778831858720812,
                -0.032872186685613675,
                0.13177653581484042,
                -0.11396499361047581,
                -0.07360696592429258,
                -0.06241906002992622,
                -0.08694417520027382,
                0.23058927025544243,
                0.12315016698967875,
                -0.03536254043886541,
                0.013572332020565953,
                0.2914774609423242,
                0.03157536750634726,
                0.07251254108288366,
                -0.1061926184095833,
                -0.1137211201148015,
                -0.03711983959791163,
                0.06522676014852043,
                0.06592714187236784,
                -0.05268262366716697,
                -0.05430354115940921,
                0.039041922174852986,
                -0.09253365069848758,
                -0.03797720426934816,
                0.001339776815231281,
                -0.029015214871325648,
                -0.07908812553905373,
                -0.06529141107870341,
                0.0005539460011213845,
                -0.005611003893744665,
                -0.0855553593678656,
                -0.022423006617640726,
                0.0026926266527580486,
                0.026085946583676828,
                -0.005041880283414921,
                -0.0672532374035472,
                -0.0386934431033993,
                0.03654797104318921,
                0.0752164833872043,
                0.0754708723412273,
                0.021298344386010883,
                -0.019807676656481123,
                -0.06752005251367353,
                -0.05391092528896951,
                0.02932621110690618,
                0.030324562870642408,
                -0.0578042709581458,
                -0.01594506849826711,
                0.01489401309808696,
                0.029294485808609022,
                -0.061333266496753205,
                0.12277623545603616,
                0.10641818121063933,
                0.0214394737505423,
                0.09580523344705887,
                -0.07934929024484438,
                -0.0030669576525319815,
                -0.01798912695268241,
                -0.008012936273834384,
                0.02757624765326621,
                -0.02528534066006955,
                0.01327399943948193,
                0.03952820888004112,
                0.027314656714637488,
                -0.001568097136861705,
                -0.014837089547176783,
                0.01045993091273829,
                -0.04791140420335447,
                -0.006915385509818529,
                0.02399630197007109,
                -0.007129187706186408,
                -0.01597282766057587,
                -0.06806011262350684,
                -0.013797070912452629,
                -0.08524808277794456,
                0.08357356317438275,
                0.01664563289846582,
                0.08038051593853401,
                0.04136806809269751,
                -0.11464698498502959,
                0.006471603548575679,
                0.0719716722494029,
                -0.12280869681859782,
                0.06721980160683809,
                -0.018666927783522073,
                0.003161911136878156,
                -0.010735088897387507,
                0.02200252307812234,
                0.027566303784633806,
                -0.01503614180842763,
                -0.011166588645964716,
                0.004750627584291982,
                -0.004385422614709209,
                -0.010580595327147174,
                -0.01789695603355151,
                0.03328893587493594,
                -0.0334954574591276,
                -0.002941722337362753,
                0.014771357949310893,
                0.01988636843986074,
                0.016088751547854916,
                0.0012535631775808765,
                -0.022701713877149813,
                -0.009569014317040896,
                -0.019995239780841126,
                -0.009931817373709451,
                -0.019046677950411685,
                -0.01728428806571026,
                0.014395702510835735,
                0.015388006832301352,
                0.02060998261148614,
                -0.022140869451933186,
                0.02491918474623629,
                -0.007144529824730193,
                0.00100314282469125,
                0.019989459522185945,
                -0.004382330228365865,
                0.0028930589520720583,
                0.014423348483222083,
                0.011337829220638758,
                0.026226804770779044,
                -0.029831767790199686,
                0.014648721789509534,
                -0.05235339972812343,
                0.012658566138579838,
                0.006697403530157077,
                0.09570971713460164,
                -0.11346960203266131,
                -0.01926770381827651,
                0.023968023873178576,
                0.0014470311021976818,
                -0.041324181704786536,
                0.05994793042044772,
                0.045119686043300605,
                0.04532100222057601,
                0.019197269167777913,
                0.042498559032371444,
                0.08250252029893405,
                0.006664216299590839,
                0.0042983831286890406,
                -0.05302299993947524,
                -0.020850105576416818,
                0.016311534393644293,
                -0.004998044869967655,
                -0.04969080433470428,
                -0.02435143069616445,
                -0.025786448626213307,
                -0.034090690777026464,
                0.051911926523676134,
                -0.09529041177090483,
                -0.036346403805817676,
                -0.05720276842609676,
                -0.07400106037850336,
                -0.00546487914521056,
                -0.01561842142586366,
                -0.010796338632320946,
                0.03405864803618648,
                -0.0015481186275487853,
                -0.09385854685368036,
                -0.011314355293423712,
                -0.030839290888513844,
                -0.003898213893957129,
                0.08888854182397891,
                0.00408298909120857,
                0.11759635477218881,
                0.015745620366522592,
                0.07984604435303948,
                0.009590097260698286,
                -0.031686755392241445,
                -0.0007386099672753989,
                -0.012270818451006936,
                0.00008014096284106031,
                -0.020226418948114288,
                -0.0021508158901018056,
                0.03316010408982862,
                0.0007203176505255803,
                -0.029126518436578423,
                0.0001414574030973069,
                0.014504474900390175,
                -0.0043459500473899855,
                0.030714958230136327,
                -0.005797381216405088,
                0.023761859289350318,
                0.004230342143995947,
                -0.08510956263467624,
                0.001210895080472626,
                -0.016107081467425965,
                -0.0011872707991669692,
                0.009862100409070457,
                0.002317638337873151,
                -0.05698686293488998,
                -0.023452078925023257,
                -0.015341785904002973,
                0.00025443888088552837,
                -0.0334856441586114,
                -0.0010457357312960412,
                0.005162885837531911,
                -0.0019148764388685212,
                0.02330504837011369,
                0.002053019297024882,
                -0.030936505722727676,
                -0.0021414906058720455,
                -0.010098160161489834,
                -0.005827428616704827,
                -0.00471567118080281,
                0.0003480077369050305,
                0.009649334055322919,
                0.001048513066202923,
                -0.040207872726323826,
                -0.0009663775671196638,
                0.06460363507246654,
                -0.0016058081481951226,
                0.07150935776426541,
                0.00271221928207181,
                0.06542725721306951,
                0.020670019393251325,
                -0.004968045630411327,
                -0.0016357042723364411,
                0.009068361413301706,
                -0.0016014330962633484,
                0.11354924489835162,
                0.002446559256211922
            ]
        },
        {
            'energy': -0.5543822772387509,
            'occupancy': 2,
            'alpha': [
                0.018454883687259265,
                0.009921503032660746,
                0.014130419077111711,
                0.01745564414121931,
                -0.03907630532862033,
                0.07149593387058394,
                0.006882726177568051,
                -0.026550981453876472,
                0.0018724294142796031,
                -0.005500640090945368,
                0.020925715765890085,
                -0.011972710374235444,
                0.007849326854070542,
                -0.07938780077451094,
                -0.12094090527839825,
                0.1813037765514968,
                0.006622708369554475,
                0.007727594813528654,
                0.0070400849089585086,
                -0.028363522778208854,
                -0.014441504826391323,
                0.005751201050294004,
                -0.004262117721235362,
                -0.03720751659276858,
                -0.00436321920979533,
                -0.02728662338849731,
                -0.07460946096579749,
                0.046396267128558294,
                -0.06709021606656286,
                0.1007624988867527,
                -0.071445418688019,
                0.1497767602211788,
                0.027193250759309995,
                0.01747350424404743,
                0.02335856580229573,
                -0.10020658235764295,
                0.013374600473120755,
                0.04405396014710388,
                0.047074494197418895,
                -0.05123021756479088,
                0.0749615841032905,
                -0.012012725585008249,
                0.0011401004864058804,
                -0.05222618031796303,
                -0.00807941971291101,
                -0.03832525786946145,
                -0.08466692349227013,
                0.1045936882200114,
                0.004819500612549823,
                -0.022445821631075422,
                0.07463589195992643,
                -0.056343113758222936,
                -0.06706865328599851,
                -0.06296599319847203,
                -0.049648182749912305,
                -0.03051833285590333,
                -0.040348645500002105,
                0.05886345062036276,
                -0.02364842782360526,
                0.015783869588067403,
                0.01163919601697796,
                -0.013852669651576447,
                -0.018886046455081712,
                -0.008598187452824743,
                -0.010563957245849137,
                -0.028896937408428768,
                -0.017265753464007095,
                0.014691364385073347,
                -0.12975810361963436,
                -0.033412523164299046,
                0.006989506377092732,
                -0.029825999262291708,
                0.013897154116144178,
                -0.015792074482971756,
                -0.11402976275688079,
                0.05416027788016318,
                0.03889359469957646,
                -0.04598206096199779,
                0.015980247108383555,
                0.07378002950953703,
                -0.006540255282905159,
                0.00926618854002363,
                -0.016758795168533437,
                0.015619168908671552,
                0.00732612366046297,
                -0.0014796901059464596,
                0.013028331696026497,
                -0.00027490263551398106,
                0.04513599023735243,
                -0.0012131856779750416,
                -0.12730572254900663,
                0.1537527335170556,
                0.0008741149921577793,
                -0.008918005910041502,
                0.010563837550996664,
                -0.019934586128199015,
                0.05561955660093325,
                0.019572683816311304,
                -0.09132250084366021,
                -0.05385676550867362,
                0.06376310430770887,
                -0.030316513386914944,
                0.0914274563623818,
                0.0525035029088893,
                0.017747591530929925,
                0.004234121669670888,
                0.009471629830312583,
                0.006973890215559013,
                0.0025583341531421225,
                0.01344292019517801,
                0.010508093037845336,
                -0.011150143909155745,
                -0.05831654802903692,
                -0.0807543996662417,
                0.11046063081144132,
                0.016484866313382782,
                -0.06379873057210515,
                -0.02403055684533752,
                -0.09347827896613771,
                -0.11323114687597616,
                -0.016092371007105307,
                0.008158075916572275,
                0.005563619136695834,
                -0.008407585271034563,
                -0.01185256176739607,
                -0.004924619139017455,
                -0.0017235780580246898,
                0.016199365385164186,
                0.0824072375410873,
                -0.042692736264612015,
                0.013042304850596554,
                -0.036093306858248624,
                0.024981888445653484,
                -0.10448821265534355,
                -0.06993791376554505,
                0.009216628022670079,
                -0.001678613356267381,
                -0.0005874088749888936,
                -0.011327338509950042,
                0.014231294571693028,
                0.012864131113170198,
                -0.0015132186167387067,
                -0.0200676848364987,
                0.006967890758094638,
                0.13101736213731494,
                0.046776444575852366,
                0.0421700203089958,
                0.07717076216170314,
                0.0687650448835816,
                0.13888204608119178,
                -0.010798580709727246,
                0.06621260696099975,
                -0.10630865309481595,
                -0.0075814937706274385,
                0.018498244642131317,
                0.026999584585456347,
                -0.09424311208498953,
                -0.06871378892241588,
                -0.05335311900039851,
                -0.03672062892387442,
                0.09244398072390263,
                -0.1633874838128428,
                -0.09342110313968291,
                -0.09375884458904633,
                -0.002134326147248644,
                0.0007048585647263131,
                0.04253391526564165,
                0.0054777552673919636,
                -0.07635041175398344,
                -0.0028878395434523254,
                0.033417869527319136,
                0.003040333500670849,
                -0.07627687558862317,
                -0.005504700416857878,
                -0.010425033869485635,
                0.0009009505550340551,
                -0.033876747217882364,
                -0.003215810993521431,
                0.0011343285395994632,
                -0.0003921547720423192,
                0.07612314745951687,
                0.0018224493795468792,
                -0.07785667014285964,
                -0.0019368164239413792,
                0.03461712945961732,
                0.004990096298342575,
                -0.027729552312007747,
                0.00016152708661383239,
                0.06076298495017076,
                0.0020695197720252143,
                0.03633679378226621,
                0.006009292068686304,
                -0.0073068217515446015,
                0.0012027702635187488,
                -0.003172233317275489,
                -0.00042680417879792365,
                0.02047576343305492,
                0.0004961591568169759,
                0.1061790590400351,
                0.006730088973038853,
                0.11173719864235306,
                0.0064391201734396355,
                0.03375594876760724,
                0.008140382269447868,
                0.016984543262168268,
                -0.00018705451283563846,
                0.012182210295575169,
                -0.00063169914671596,
                0.05197998270297762,
                -0.00023816285534946792,
                -0.13979119809225496,
                -0.006964763149112037,
                -0.15223197617406192,
                -0.00810627502911452,
                -0.0019140719948583056,
                0.0015273541364655844,
                -0.013430614333651484,
                -0.000693676880473633,
                -0.0052488514027865,
                -0.00037616639005384615,
                0.019199751319891763,
                0.0006965527165064392,
                0.11367197329178817,
                0.002575833661304968,
                0.1255354558626515,
                0.004616567866563229,
                -0.0061240044229455325,
                -0.002325057602309982,
                -0.0334293082545751,
                -0.003810517776193155,
                0.008748030489103706,
                -0.003062415605332437,
                0.2037215279801743,
                0.005127832875484355
            ]
        },
        {
            'energy': -0.5530496591470335,
            'occupancy': 2,
            'alpha': [
                -0.0046502277835715295,
                -0.04105987270721241,
                0.01135051590809751,
                -0.025486722435839555,
                -0.007284302531988427,
                -0.04661820868894742,
                0.18275756833509205,
                0.059445980637887134,
                0.0074983844769796444,
                0.012338351651558109,
                -0.04186351932519378,
                0.014025610823968896,
                0.0016721267762597012,
                -0.02700109470783767,
                -0.08122180347167217,
                0.15198235303376503,
                -0.0475072377786094,
                0.006056946532609514,
                -0.05886670288812926,
                0.15451290289969635,
                0.07830620366137964,
                -0.03121689868608376,
                0.029689071791910597,
                0.19456143444995605,
                0.011808877297275802,
                0.09855055320884534,
                -0.059413639552852886,
                0.09865477325927259,
                0.045163786485188304,
                -0.14314078281926718,
                -0.05300213565224745,
                0.05114291534898644,
                -0.011638202395094303,
                -0.0918641124477351,
                0.02037467844355782,
                -0.09200670235080886,
                0.009702080084956486,
                -0.0705061864234056,
                0.02101206316000339,
                -0.13247661078364392,
                0.0358690184182191,
                0.03891899971675231,
                0.04669796926776814,
                -0.07391328081196467,
                0.04409503592456254,
                -0.1465020091396794,
                -0.09302738824407779,
                0.07593763299637443,
                0.012934966014426045,
                -0.07804655893346017,
                0.13309025827669058,
                -0.1782632706297735,
                0.001204735436185434,
                0.011154962851399093,
                -0.009134502666248432,
                0.04709697782082869,
                0.007605918278544771,
                -0.041268660088393555,
                0.01113783350162286,
                -0.03350714437283626,
                0.02770311432160462,
                0.00577251927207803,
                -0.04354584400675265,
                0.08287014247368175,
                0.04416362129622878,
                0.011329604371031941,
                0.011763143336620412,
                -0.0012285243039015263,
                -0.025017493548292243,
                0.031031293589931862,
                0.0017881901021305577,
                -0.012704253772330216,
                0.007409278439319878,
                -0.09456761328531162,
                -0.048971539379790534,
                0.11747959911513568,
                0.011061468907247723,
                -0.058127486044108556,
                -0.09376536751442507,
                0.055283130115526095,
                0.0018563579213259757,
                -0.033462319994386334,
                -0.0013980661748390774,
                -0.012078143104693097,
                -0.013592829525626408,
                -0.009734700411097103,
                -0.015171923975195742,
                0.012108763670201934,
                -0.044007376962493704,
                -0.06107169606077028,
                -0.06576085639493268,
                0.12195783168170651,
                0.0011922167602772958,
                -0.009078026907301025,
                -0.09089416089024425,
                0.04550577441818199,
                0.027136831404332887,
                0.023619724528637157,
                0.008389419085849757,
                0.029818638113961703,
                0.013355832194977402,
                0.013433077269466473,
                0.017327056547848198,
                0.015454255833235907,
                0.006004995264329551,
                -0.011433825050771623,
                0.0069584400356776654,
                -0.012349927268433631,
                0.00857863170176689,
                -0.01126776685356296,
                0.0009812430420401716,
                -0.012952276110374337,
                -0.006607768747855209,
                -0.041039509197401784,
                0.026483597854800325,
                -0.021990828066108636,
                -0.01628605583979971,
                -0.01973208407695946,
                0.009960083080454851,
                -0.018547316075317483,
                -0.0066161941862163945,
                -0.008039219197305858,
                -0.001837636104808754,
                -0.0012798480946812696,
                -0.006909801246621284,
                -0.006476632101789181,
                0.0004908845638235569,
                -0.004354506989366503,
                -0.009361404923724146,
                0.014772104911576326,
                -0.0065899631131587,
                0.01097314693773511,
                -0.012135107320693032,
                0.06363585579303717,
                0.005399623404265082,
                0.08230867246181801,
                0.01950819865807177,
                0.00047087929942737244,
                0.07701823180350453,
                -0.0740702299492829,
                0.006279112853942546,
                -0.010094833402003352,
                -0.005012986923248994,
                0.006738654859286615,
                -0.1089703891641171,
                -0.039800768195872895,
                -0.05762540910423007,
                -0.021872450812034136,
                -0.05437241578298299,
                -0.12020206609217698,
                -0.01891463647708997,
                -0.018399028544339453,
                0.08746089710041004,
                -0.009799264261465525,
                -0.02641713593544548,
                -0.007560026288014189,
                0.07658912443644983,
                0.05431364776890477,
                0.025298414557452714,
                0.044412528113339116,
                -0.07365136079077501,
                0.12101866217437471,
                0.06980166798131801,
                0.08836494381833426,
                -0.11439647679964932,
                -0.008350171886834698,
                0.0677919803449389,
                0.0017281639902930741,
                -0.1136673875048636,
                -0.0049954929368099645,
                0.1224178370711453,
                0.009025651778765128,
                -0.18438406720931577,
                -0.011204895986491398,
                0.06092975848563692,
                0.005238983993504563,
                0.03380883574048781,
                0.005709858940383114,
                0.016114320197313542,
                0.00507396754103449,
                -0.009005443289994189,
                -0.0001179415341040425,
                -0.10865750212044165,
                -0.0027420406509701344,
                0.0786818782605529,
                0.004369935973579905,
                -0.07727727063770913,
                -0.0009707150355650453,
                -0.014267250451577035,
                0.0006331661680901973,
                0.05988107109562212,
                0.004562556335371217,
                0.0005875131572836072,
                -0.0033843261850324906,
                -0.03350006933624877,
                -0.0009792784856865488,
                -0.041946986415182144,
                0.002197660827719805,
                -0.019267398294832063,
                0.0015742613237668753,
                0.01245418094021005,
                0.001244087847849417,
                0.028649254136012842,
                0.0002600688332935838,
                0.008179405405401923,
                -0.000506090748276908,
                0.00785407885782556,
                0.0002465068797292118,
                -0.051351659257708494,
                -0.003283650821892174,
                -0.038810982602691176,
                -0.0009707854240404978,
                -0.017698696793926057,
                -0.0005768667670912286,
                -0.006926271731194115,
                -0.002312189970401155,
                -0.001961747962419467,
                -0.00025420856928380436,
                -0.003443353041122475,
                -0.00032375568810310955,
                0.012164150978703775,
                0.0003727352316473121,
                -0.09062260481938456,
                -0.0028494032362483836,
                -0.09841483692373876,
                -0.0037862275956004644,
                0.04543880404753555,
                0.014721700546708485,
                0.0346386725212059,
                0.003281353102622927,
                -0.00175345975719461,
                0.0025799607250368965,
                -0.16031000179776816,
                -0.0043176898890289455
            ]
        },
        {
            'energy': -0.5514192499226825,
            'occupancy': 2,
            'alpha': [
                0.034960340448809975,
                0.14036996691431702,
                -0.14497962446692692,
                0.0419147890218627,
                0.017646849607451394,
                -0.03512815727722118,
                0.04273557681295462,
                0.1855442909724119,
                -0.027932622141484027,
                -0.03762824323755873,
                -0.03548229439947988,
                0.04394992371227564,
                0.10568178265089155,
                -0.1364754608922868,
                0.1077816668097567,
                -0.01497487709370447,
                -0.017102386170686226,
                -0.04160723099930738,
                -0.018700848131558947,
                0.08333631558907978,
                0.04235084919598524,
                -0.010608451535199504,
                0.02066388061386172,
                0.11504485224752123,
                -0.01879929957317139,
                -0.0024379758287639657,
                0.2293406990012519,
                0.09473977555308355,
                0.024527117836636185,
                -0.014907339637028085,
                0.07132930122784636,
                0.011492395320401408,
                0.0048973868764589455,
                -0.07642646024694613,
                0.09365209938919734,
                0.09834398815748081,
                -0.06299484506818966,
                -0.11874161720193468,
                0.07916030714638848,
                0.05110550727589746,
                -0.010368294524959645,
                0.026343867714484583,
                0.09597343617560268,
                0.10566565636116211,
                -0.028044876386823816,
                0.03711008945356833,
                0.0846062441605631,
                0.01683242549749908,
                0.022226446322800058,
                -0.0037696750449495724,
                -0.1824638597527796,
                -0.0542175292462686,
                0.08523583466550427,
                0.017000244683173734,
                0.06316501671836504,
                0.03092292355228326,
                -0.013473503558414092,
                -0.06414417813582783,
                0.07989620996957279,
                0.008441402387048812,
                -0.05942998474795097,
                0.012024067622491306,
                0.09132841416296661,
                0.03281529214267134,
                0.014740174757949587,
                0.1191881476174064,
                0.03685075094728653,
                -0.07194020745050363,
                -0.07343764906457652,
                -0.08498119779537344,
                0.041093272243325735,
                -0.08040505542094804,
                0.012400948806696304,
                0.010931694946257148,
                0.003585759653254556,
                -0.09983609817585057,
                -0.025815138115589033,
                0.0562304274412534,
                0.008994602060170194,
                0.023220448492054176,
                -0.007919899220080934,
                -0.029937548080541453,
                0.024618112426339562,
                0.020248944666922935,
                -0.012438268508643319,
                0.010301923060993536,
                -0.029777006102462623,
                0.000018803427042530813,
                -0.03932312425680502,
                0.02549551571032762,
                -0.04085030171994104,
                -0.06486524636659947,
                -0.0048946678081495994,
                0.039755491897259805,
                -0.02798852013815659,
                0.07342124541851369,
                0.04899145350567899,
                -0.024345220366047724,
                -0.11631834985431824,
                -0.15724886823005518,
                0.004696219828747727,
                -0.07403530875617349,
                0.1134876001961826,
                0.010940052368931042,
                -0.007675319731520367,
                0.014014188122813286,
                0.008013633203155906,
                -0.04031888660675235,
                0.029443972489882404,
                -0.007395673420701914,
                -0.036118583229751686,
                -0.0021243845904358213,
                -0.07014720867325842,
                -0.02159842081399009,
                0.11853158158793542,
                0.07637203615593775,
                -0.012225979510452664,
                0.04947013700567724,
                -0.09963117158264878,
                -0.04227609731330007,
                -0.008222862622425706,
                -0.013334628666062612,
                -0.04171180236384811,
                0.016529271010808363,
                -0.020317292279919227,
                0.015736321743407146,
                0.020771555058933112,
                -0.03623888034193782,
                0.13228610101574337,
                -0.09067852553610894,
                0.01443364832577029,
                -0.08692355283523179,
                -0.016284716140290156,
                -0.0020225450061668775,
                0.026152208781421993,
                0.0004044848028343992,
                0.007679101458696083,
                0.004505052398927755,
                0.036977357791906675,
                -0.04258005118424247,
                0.014227479384386964,
                -0.0172882746742542,
                0.028381832286223516,
                0.029244417866194198,
                -0.03167867925316444,
                0.02534355765091559,
                0.0032913570093706527,
                0.0017702361835590461,
                0.020980475863428015,
                -0.02801536963005463,
                -0.01646931837230778,
                -0.0257785676909359,
                0.0009492746397993323,
                -0.017670528613841007,
                -0.032047747065658855,
                -0.02949753109635412,
                -0.006880573598185501,
                0.04140321340711685,
                0.031466855889255914,
                0.028453412223714617,
                0.006655431900883934,
                0.00599962674205861,
                0.0386246903356971,
                0.024646709894917473,
                -0.02406519534283381,
                -0.005959762445725619,
                0.043483114845037536,
                -0.004157932663040027,
                0.04544027795885891,
                0.00035986158699988533,
                0.08567569069264885,
                0.007430833886053947,
                0.1313488014302964,
                0.007644367867944102,
                0.01855820415118996,
                -0.0019432565383884284,
                0.12112530333204345,
                0.010974587098754528,
                -0.0019348189369971106,
                0.0035282109785115287,
                0.009328948001815468,
                0.0007926635821340458,
                0.07666404633186022,
                0.0022756589417815853,
                -0.004056796950812973,
                -0.00036499536956071337,
                -0.017958401552862945,
                -0.0005212345937596911,
                0.019092330492450873,
                -0.0009902425939271697,
                -0.047448584552102824,
                -0.004077529921909463,
                0.016583035441194823,
                -0.004050280532408171,
                0.018174500300906386,
                0.0029155154428789094,
                -0.07802597727763087,
                -0.0034126827301474982,
                0.19105203056779338,
                0.009636572067129317,
                0.11895509657109993,
                0.004103705413675248,
                -0.03136089432021158,
                -0.008048860835544477,
                0.003410064903320926,
                -0.0005578655056561213,
                0.026252326023387472,
                0.0010341866303977178,
                -0.037112839443590305,
                -0.001976755537192668,
                -0.12675440387872164,
                -0.01059756588739451,
                -0.07638884887913262,
                -0.0045260688706045445,
                0.022050744412710054,
                0.002441124387854584,
                -0.0037634912236352777,
                -0.000177384607595328,
                -0.023888708068048027,
                -0.0012204093936799554,
                0.016522564074287815,
                0.0007368584140190684,
                0.0019474439863356487,
                -0.006963781440261128,
                0.00036626142789623954,
                0.0009977971395029792,
                0.016976777467046338,
                0.007012957865696721,
                -0.005535026185281296,
                0.00036955526951177844,
                -0.03812539793902036,
                -0.0009691405364590703,
                -0.017380143956454933,
                0.00005555059651280429
            ]
        },
        {
            'energy': -0.5504026411044821,
            'occupancy': 2,
            'alpha': [
                0.0315506381338294,
                0.07947389072479208,
                0.08973877742159735,
                0.1507095906762598,
                0.04079295676137838,
                -0.07888736048972257,
                -0.04686963457934503,
                -0.16094869453242253,
                0.04669106785754997,
                0.10810371135557383,
                0.048448832520563805,
                -0.04351715276060546,
                0.015809927914842852,
                0.02580010888127879,
                0.0314539199586067,
                0.021953824992036283,
                -0.0030867312038685246,
                0.09988536150328753,
                -0.005047333727509915,
                -0.012701345814477107,
                -0.009822697948313489,
                -0.030611557365950476,
                -0.0061854573294112475,
                -0.0349441174931495,
                -0.019120491258300665,
                0.058493823447619296,
                -0.15344389848314288,
                -0.16628794228497829,
                0.03002848512582186,
                -0.11587381253490198,
                -0.011347974040975642,
                -0.02787718940951699,
                0.02751224268628099,
                0.02825779164484598,
                -0.151600267861366,
                -0.025184515791031196,
                0.04634618796170502,
                0.024549065718254055,
                -0.07359405425808574,
                -0.020655735045968866,
                -0.0034195848064099946,
                0.059895588875294024,
                -0.13072853941371593,
                -0.005550743825098077,
                -0.042502469035148226,
                0.09073219881321683,
                -0.022819548010888605,
                -0.06801980935765178,
                -0.06301676337068833,
                0.01933587446217007,
                0.06516017281910842,
                0.08538645688472546,
                0.05693707088647408,
                0.03779737058680117,
                -0.038832368772905,
                -0.06432807143886465,
                -0.043174039905202195,
                0.024438119472636514,
                -0.06653560918458089,
                -0.05876666942760895,
                0.05481398510675768,
                0.03748149365873983,
                -0.07952286211357369,
                -0.031650676814766354,
                -0.0039286097315005385,
                -0.07437043912265419,
                -0.009730094773874763,
                0.10636293639086784,
                -0.071209663282888,
                -0.09914698177093195,
                0.015701685989806907,
                -0.06455217526128627,
                -0.01167736293663496,
                0.10655180161328018,
                0.010102898968117493,
                -0.015132114425104426,
                0.026635096089367552,
                -0.013707641941978266,
                0.1040296984052902,
                -0.05436596161902868,
                -0.009803229202417184,
                0.005726925067786887,
                -0.05002559468547647,
                0.004288234391191465,
                0.0055499056916407385,
                -0.01036254027406104,
                0.02359377701060701,
                -0.01823228767546117,
                -0.015863088078265947,
                0.013615900323810062,
                0.022270637582263338,
                0.010522194352460343,
                0.0061374525254277385,
                -0.08172243337254456,
                -0.01200873018423619,
                -0.05609053031886707,
                -0.008496690683157754,
                -0.03539723510502261,
                -0.11404364452279066,
                -0.1263892650585419,
                0.06803987637965384,
                -0.0855223978451341,
                0.11362306424465343,
                0.027751694761813807,
                0.04307662495994163,
                -0.010612713281858643,
                0.0193170075830986,
                0.031448668675537486,
                0.0007475303747087906,
                0.022913214071035515,
                0.041556887204775746,
                -0.029616574853910452,
                -0.020449280315960286,
                0.016414832687779473,
                0.05060931817565192,
                0.07409833910799855,
                -0.056849051468792315,
                0.020319522268699434,
                -0.13540515319914415,
                -0.09561126850687196,
                -0.030961764369679352,
                0.019106640216195906,
                0.03427411057551122,
                -0.029707461311167957,
                -0.01792596539248842,
                -0.022298435906898537,
                -0.009257754574714205,
                0.048143416292531334,
                0.12355558356138517,
                -0.08933798381255023,
                0.036974101215451784,
                -0.06589433528869955,
                0.014055833929130712,
                0.06720755981787281,
                0.026882740935162647,
                0.04447682523154546,
                0.0017836816474727014,
                -0.014065348557408168,
                -0.0031842002237561385,
                0.010373450959896691,
                0.021703898755223047,
                0.0002940690855468061,
                -0.05847707087333258,
                0.0006282238241673193,
                -0.0870488387068982,
                -0.02298637283213122,
                -0.039660060058789026,
                -0.028792801010189318,
                -0.05052784184189427,
                -0.08726693871923655,
                -0.004894698105579515,
                -0.02256645842158452,
                0.07691053628471979,
                -0.02207336822075977,
                -0.0057428905205883524,
                -0.007897219242766802,
                0.0687160893086129,
                0.04136453060763806,
                0.002983251059920106,
                0.01523866526186146,
                -0.06492032647137898,
                0.0870802347153509,
                0.05413003916088269,
                0.06091266516288046,
                0.003847390660000696,
                0.00438418095718077,
                -0.026704452499989623,
                0.0010462060384563345,
                0.05077267336420668,
                -0.000046448691542065054,
                -0.10066836911175506,
                -0.012763527997783266,
                -0.029715576811065306,
                -0.005240891449653545,
                0.005026051654429546,
                0.0018071655949257821,
                -0.08400623143376376,
                -0.007609813878520672,
                -0.04116587714814403,
                -0.005585244061489009,
                0.038718055653195436,
                0.001514745044604831,
                0.023128750340002953,
                0.0007621031805345838,
                -0.0905210192929766,
                -0.002375552595539443,
                0.09313233594649255,
                0.0021685489664728863,
                0.021803406839649975,
                0.0013134592130668618,
                -0.006458014514603197,
                0.00007312025254921356,
                -0.007683841546593634,
                -0.00023059319104913614,
                -0.06134081571696415,
                -0.006323294802262297,
                0.073408912236807,
                0.0067491146803489435,
                0.14565608490212117,
                0.005938016806583362,
                0.15016200934972038,
                0.009495258529640617,
                -0.01800514180279459,
                -0.004330130453540513,
                0.0372621089733823,
                0.0012741248713367085,
                0.01561271976070481,
                -0.000008436562887091513,
                -0.04857377042429429,
                -0.004224402844004078,
                -0.04159168805906859,
                -0.002944734222064282,
                -0.15351506776035362,
                -0.011309318741606615,
                -0.03258794444022761,
                -0.008701570465755391,
                -0.02752964180231016,
                -0.0016164797673370417,
                -0.0042193516418830524,
                -0.0005322792770677104,
                0.0364005887634894,
                0.0013609581941258445,
                -0.07646788358485326,
                -0.002786216604405721,
                -0.08123256569475668,
                -0.0035419606898021995,
                0.0026193153895576926,
                -0.0005716372638597895,
                0.04674674989817126,
                0.0031396321078645865,
                0.022686416741817636,
                0.0027801815643998334,
                -0.12203908471922555,
                -0.003976102674930841
            ]
        },
        {
            'energy': -0.5488159374495201,
            'occupancy': 2,
            'alpha': [
                0.005651287373372537,
                0.009678606345140582,
                0.03270997500195032,
                0.035074031924680296,
                -0.02792779579095451,
                0.047137573499884906,
                0.08032853319834844,
                0.07713916772180765,
                -0.046316553976089525,
                -0.09903183104977346,
                -0.18075343866786256,
                0.1298395937071813,
                0.02028452752200326,
                -0.007388211295820074,
                0.02936714743809882,
                0.011545922718903149,
                0.08137930966195248,
                -0.4287340162847225,
                0.10486266962419848,
                -0.21458313126577067,
                -0.08681092519801657,
                0.22971141418688656,
                -0.0628127122140305,
                -0.1957793824714742,
                0.010413628728090403,
                0.03383653996097341,
                -0.048286806020449845,
                -0.03543452872431235,
                0.010245405480558464,
                -0.04330628681099334,
                0.005158997233798427,
                -0.010571424419602906,
                -0.008670158537327105,
                0.005019683080157297,
                -0.03894915373316209,
                -0.025693957939537517,
                0.0031326457407661957,
                -0.01743028209419744,
                -0.007165573781644086,
                -0.033358476501291624,
                0.0013803836872203043,
                0.025484769195320226,
                -0.03132322371558747,
                -0.015928156649301507,
                0.002589282474397417,
                -0.00890035815209409,
                -0.02277194804742982,
                -0.016183422356352364,
                -0.018235873839583517,
                0.022417275626448217,
                0.055559385373004956,
                -0.011457904664560734,
                0.016303782271924732,
                0.00006755491426624302,
                -0.027159002889091906,
                -0.008922433894042018,
                0.000939707521100021,
                -0.008063108033652188,
                -0.027875856448397716,
                -0.020535567169724347,
                0.012947825150353975,
                -0.03231973955023784,
                0.002896449181553438,
                0.0508691775952605,
                0.017340525312156036,
                -0.11491892354082718,
                -0.0617126404752626,
                -0.11107542684347663,
                -0.013632099537794228,
                -0.018528363181158133,
                0.0009642584907486777,
                -0.015643439701674346,
                -0.004669686832196031,
                -0.0019760218232971532,
                0.007465308637638149,
                0.027232571665217423,
                0.005007243432955658,
                -0.01929506796146323,
                -0.001596517529230729,
                -0.015286956503642738,
                0.00017141234329438523,
                -0.001097155141982427,
                -0.011913859389099552,
                -0.013708535617075872,
                0.01771979925513131,
                -0.03385477427188722,
                -0.05561747844228224,
                0.0028049436819566937,
                -0.00912893374468677,
                0.012689214325724918,
                0.0005255458920215668,
                0.0008846041835325392,
                -0.005707790523563489,
                0.31005381393830406,
                0.18757439237109638,
                0.10470768326179684,
                -0.0027850667019610237,
                -0.008078909410113997,
                -0.021264294922480814,
                -0.02232572177352877,
                0.018148885008869863,
                -0.016614459654200404,
                0.024463479907424264,
                0.009016592675403886,
                0.003557038962954779,
                -0.010873787814879795,
                -0.0015219379166830434,
                0.014267744970448594,
                -0.009593438353908659,
                -0.0009193226879496339,
                0.015267781971070515,
                -0.003589019169414968,
                -0.0016598722151455305,
                0.004192582024722415,
                0.007311331854159587,
                0.014160864821579109,
                -0.014362957724754839,
                0.00017893899919888917,
                -0.027847849719954236,
                -0.023374584898117612,
                0.0008993491070777063,
                0.004023505045826615,
                0.015172733483871558,
                -0.010193743020970238,
                0.005257381582734877,
                -0.009590642118657457,
                -0.004589336773924587,
                0.014979666893931034,
                0.023529158271319444,
                -0.01662569852807359,
                0.007621879494757878,
                -0.011494323512367217,
                0.007093937053683605,
                0.02286548911065045,
                0.014539162684689667,
                0.014601999224254873,
                -0.04885257889913805,
                0.07136462754251259,
                -0.12453935500139035,
                0.08561010288368064,
                -0.0027447139461641307,
                0.00529828128780887,
                -0.011809377927996642,
                -0.013183872859161394,
                -0.032829209041376844,
                -0.001882429041211358,
                -0.012794587715349396,
                -0.009595293124415259,
                -0.015179264703732069,
                -0.03148495376767671,
                -0.0031226259308706527,
                -0.01110672860905545,
                0.026524517375644596,
                -0.013262192756912466,
                -0.00403431032638843,
                -0.0065428962364698215,
                0.022935770007397938,
                0.019170174078210582,
                0.0010571166530883008,
                0.005597977377379235,
                -0.021618420235906825,
                0.026670625437930886,
                0.022685981108530512,
                0.022047297936501765,
                -0.030788833875663734,
                -0.0029516332273287617,
                0.00919601344081947,
                0.0008949863911007859,
                -0.007353282255913635,
                0.00019303275339294866,
                -0.01930506405562194,
                -0.0018632507691760144,
                -0.04402300364542451,
                -0.006562248094731216,
                0.024439626035399963,
                0.005428068832871858,
                -0.0673583243380871,
                -0.00024373660068387155,
                0.136747883649611,
                0.012787748727256036,
                -0.008549669889482303,
                -0.00019144800300623324,
                -0.01803464013946834,
                -0.0004434901246600749,
                -0.0016438461982630048,
                -0.00010787984336734895,
                0.010157146758485109,
                0.00031656946113198096,
                -0.011771941129506223,
                -0.00003703526804688281,
                0.015783065903197724,
                -0.0003499858071439981,
                0.043561196244532883,
                0.011971723964997055,
                0.2886814931960456,
                0.02051864529035348,
                -0.17158037101801918,
                -0.02503368582904017,
                0.025178208744802557,
                0.0008086668639519629,
                0.03286587552904445,
                0.0024648233741305136,
                0.0277890831779378,
                0.006001181088414697,
                0.0011633516495274056,
                -0.000004782816791784053,
                -0.0074761846063178235,
                -0.0004526712881314667,
                -0.02275808822975075,
                -0.0021551546550697648,
                -0.0047582992520706245,
                -0.0005770631216532644,
                -0.03596519696268128,
                -0.002706683721280652,
                0.04530935872625759,
                0.010396922663125243,
                -0.0020057682386372877,
                -0.00004690373585616477,
                0.005234319981809825,
                0.000345345655364168,
                -0.005408249442671586,
                -0.0001880202227663381,
                -0.02574506314431515,
                -0.001864041378117695,
                -0.02716479623202664,
                -0.0011194896548474029,
                -0.08048166919510852,
                -0.022888043446048615,
                0.018504358666249526,
                0.0011927995744992362,
                0.007150599444719111,
                0.0009294546075269898,
                -0.04086906082024657,
                -0.0013979492576563224
            ]
        },
        {
            'energy': -0.5451616986959122,
            'occupancy': 2,
            'alpha': [
                0.01069823890750801,
                0.08710084743280634,
                -0.0026415888629983254,
                0.028129535406826105,
                0.00985222910983904,
                -0.03297240491636229,
                0.007202950004061482,
                -0.03721015650983091,
                -0.00220467476933597,
                -0.06059914668849109,
                -0.07003352225127013,
                -0.027754680593501765,
                -0.026263503339723493,
                -0.002572538805440404,
                -0.08644073153681539,
                0.06689563519215666,
                0.00981632565903572,
                0.07950397498453117,
                0.012727988449220887,
                -0.06392479734565067,
                -0.03517733051829023,
                -0.03186131340594568,
                -0.026720344940197812,
                -0.10394414976496008,
                0.0287934185069531,
                -0.04887504082454877,
                0.052885095803609054,
                -0.09966528039339455,
                -0.007128923033774139,
                0.019755955531339034,
                -0.040635501324521615,
                0.043823094311883554,
                0.0007531059098955476,
                0.02105736095993322,
                -0.015126801910860585,
                0.09347936182244794,
                0.026336245882809806,
                -0.017735115735771984,
                -0.018854111103387416,
                -0.05830044865689813,
                -0.028658061874210928,
                -0.0064808008436811415,
                -0.030871256709110093,
                0.06395667190057128,
                0.06199717936906141,
                -0.22116668048350085,
                0.049433813925146536,
                -0.1229335729965522,
                0.01576978517803971,
                0.01318589756776838,
                0.03250883950095063,
                0.049065313740319146,
                -0.003319271565975897,
                0.016128265422059685,
                0.023113606572264817,
                0.005653926735760803,
                -0.04199006556511256,
                0.01510519369263687,
                0.02052045142622473,
                0.0008345179958472975,
                0.007228738763059972,
                -0.003824561251666986,
                -0.01750687079737068,
                0.010799712947739097,
                0.00020087358957704524,
                -0.00364304494065953,
                0.042974866414786664,
                -0.02637636169846385,
                0.013235458776381364,
                -0.0738425738275494,
                -0.014530888132385868,
                0.008257696547361559,
                -0.0025837149599689806,
                -0.26053420158318347,
                0.27883989003454973,
                0.03459863939010829,
                -0.043376318298851406,
                -0.007390329056378323,
                -0.22410477228769943,
                -0.17298873131512832,
                -0.022134541254884375,
                -0.0005822482581737517,
                -0.006777808437798262,
                0.03326876816028442,
                -0.029147365825568115,
                0.011727630564748279,
                -0.017920429983052776,
                0.05271480598161708,
                0.00551503091096585,
                -0.03256602322198064,
                -0.03293322498322414,
                0.06311883914828186,
                0.000739304969503733,
                -0.03259896117911303,
                0.016531670413752045,
                -0.08877066819842248,
                -0.00828493987331976,
                -0.05820509251323486,
                -0.05661886372204817,
                -0.057463764583002154,
                0.0033020512168250886,
                -0.057739795846080286,
                0.005246362911757629,
                0.004020126638374125,
                0.021710702753171326,
                0.013054778877310281,
                0.017618982714235513,
                -0.007729060029128891,
                0.023955584992237232,
                0.015280964507475075,
                -0.01407096594311898,
                -0.012583408066826715,
                -0.00975843651378163,
                0.03111448190937425,
                -0.01345928004352169,
                0.051566594069136926,
                0.004261619335803105,
                0.021552875591503193,
                -0.04993001409000921,
                0.008457886238707338,
                -0.02532099234545543,
                0.007802941766139678,
                -0.017085011906138765,
                -0.007081035111976713,
                -0.027087148094775176,
                0.006460287442800677,
                0.016604527501352728,
                -0.0023767697901953,
                0.04622982904363532,
                -0.03862892652834257,
                0.012924381807118263,
                -0.02800875459081238,
                -0.008820912776838977,
                -0.015443003341989208,
                -0.03111592420974306,
                0.009397853617823271,
                -0.011628802278313874,
                -0.016191830954537762,
                -0.03748969990243102,
                0.03466876270049694,
                0.024789980527936486,
                -0.009474307947695703,
                -0.007301430805299181,
                0.024702283171600198,
                0.021802941088180983,
                -0.012805752197557415,
                0.0025481837198602273,
                0.014316900114711258,
                0.00645041019824469,
                0.01857596701155626,
                0.00015627896048312948,
                0.021110420343999015,
                -0.015801761573939612,
                0.015675958117668184,
                0.003162862625217978,
                0.014528889749230821,
                -0.012296800649218488,
                -0.021561419404170966,
                -0.0014088480672828903,
                0.0017409772863201355,
                0.012227290583492163,
                -0.009457798390917881,
                -0.02268888638043653,
                -0.011227495704530724,
                -0.0464491006333104,
                -0.003020060389272348,
                0.004996143849958265,
                0.0016711372617833713,
                -0.08813096650879237,
                -0.0031015284048136497,
                -0.05634355437059239,
                -0.0005988497684802319,
                0.008553067066894812,
                0.000421484255816404,
                0.0031740715918516806,
                0.001232887948647137,
                0.02194677355835101,
                0.00201914671897631,
                0.018933643073762395,
                -0.00013232735510088875,
                -0.3189303784565101,
                -0.010956521360588075,
                0.05902937319044393,
                0.0022076067398050497,
                0.13303278115366587,
                0.005902334791119332,
                -0.0022651832938127238,
                -0.001027648990914732,
                -0.23043088882855892,
                -0.005287562450598769,
                0.022316419338134764,
                0.002329080707505714,
                -0.005316414976201046,
                -0.00013664414923752593,
                -0.016293057722269102,
                -0.0016787193331563408,
                0.08821288815439461,
                0.0045150950380081906,
                0.07209678908850325,
                0.002964747684017165,
                0.033297780455826646,
                0.0015798604200631787,
                -0.003171012679100631,
                -0.0026080315348427857,
                0.025129084495848077,
                0.000954800459362699,
                0.03206969911003408,
                0.0012516353252138006,
                0.018158214711481442,
                0.003166985455427532,
                0.015829936519476454,
                -0.0008625398978427994,
                -0.014917033488057197,
                -0.001664205143809004,
                -0.011338508793001946,
                0.00019791386592386243,
                -0.025372720414089115,
                -0.0013902479180475042,
                -0.026450203863426367,
                -0.0015857615967637192,
                0.032840717804717874,
                0.001616708272651018,
                0.01624229319184562,
                0.001937351027433223,
                0.014053267099108252,
                0.0005954041079986143,
                -0.012210897246253965,
                -0.00580858747567019,
                -0.014662710711866657,
                -0.0008662292978422445,
                -0.005063981640342855,
                -0.000558538069598368,
                0.021272030754741954,
                0.0008457667743742655
            ]
        },
        {
            'energy': -0.5441101398933808,
            'occupancy': 2,
            'alpha': [
                -0.0007408978978013013,
                0.010327295218475996,
                0.012171836197150315,
                -0.0036081853227182843,
                -0.02367707480745204,
                0.11979520135195831,
                -0.13739215570193325,
                -0.028630338785895312,
                0.022238465322705552,
                0.24587531365188856,
                0.2844739275176139,
                0.07031308120017249,
                -0.04915775258817103,
                0.03346637091332632,
                -0.09091961797471025,
                0.017339003616913477,
                -0.02788560241454241,
                -0.2418932800170174,
                -0.037452507544623655,
                0.18884428016709764,
                0.10454534745251025,
                0.11222519149288293,
                0.08394044900814421,
                0.31228493025245363,
                -0.01279452074525064,
                -0.013635826011168393,
                0.005183008562012651,
                -0.045280782959661585,
                -0.010102293101525188,
                0.02297009114878315,
                -0.04098723244370229,
                0.02467875040048763,
                0.01823928528440093,
                -0.00048620977498454126,
                -0.025491562105049777,
                0.03201495332359169,
                0.03246012221510984,
                0.012286331524174814,
                -0.009827104802687874,
                0.029793012827280637,
                -0.0061111391474721775,
                -0.02953300550683185,
                -0.03522904071805499,
                0.018881053766238897,
                0.008043080372449296,
                -0.03941759624655394,
                0.01472620290882994,
                -0.04314124080793973,
                -0.014562859493331583,
                -0.026208145080057168,
                -0.034313081140380904,
                0.023053730702898928,
                -0.010159415076361273,
                0.03010751134397762,
                0.020982686526817687,
                -0.017803293189417226,
                -0.024295459363070305,
                0.050021416814719354,
                0.010528405690425673,
                -0.0075720901967033325,
                -0.0037984929037607586,
                0.004622272374795652,
                0.021966707007204486,
                -0.08633584556171822,
                -0.008761568589523323,
                -0.02752713287037216,
                -0.15053241142045964,
                0.13805029648010206,
                0.007590542598644083,
                -0.017608850430256246,
                -0.0010341527262915501,
                0.029091922871202727,
                -0.0013199399435077472,
                -0.03803185238070633,
                0.07673282783235347,
                -0.004150393847903745,
                -0.005959528997162953,
                0.005789095704792428,
                -0.03419862648064549,
                -0.05669525057380384,
                -0.021905304459928884,
                0.011852010827794614,
                -0.019334152843054418,
                0.03224737975929413,
                0.10919473139248806,
                -0.04505917795481532,
                0.07731179106371783,
                -0.18948081264510136,
                0.010612010983278092,
                -0.039174025104898876,
                -0.001824106724928793,
                0.03625022458154158,
                0.0013761630423193584,
                0.07867727573959588,
                -0.04738275026006374,
                0.27298253522533544,
                -0.025541394152377057,
                -0.032379358818057306,
                -0.035260118569835616,
                -0.04348681454777466,
                0.014905096087679676,
                0.03489104695217241,
                -0.06405979800329067,
                0.005384825733909515,
                0.03222895828425418,
                0.010516080794791953,
                0.019197272006185883,
                0.006684149733807998,
                0.023543858039186495,
                0.024587446552901782,
                -0.001188021469352596,
                -0.01902212646485593,
                -0.011080713865775558,
                0.05000503044952309,
                -0.06359992497972232,
                0.008850188260512494,
                0.01791905436037115,
                -0.021759937452120886,
                -0.03495157320885739,
                -0.04421739380910552,
                -0.029568147839085526,
                0.015768212943308085,
                -0.0036341301365661527,
                -0.0163626211934202,
                -0.029036570506532237,
                0.0014521452582475047,
                0.012902613889567916,
                0.012850309888860103,
                -0.0038083441851604165,
                -0.0035218754655917187,
                0.013739710936563527,
                0.01045260757894072,
                -0.0074592163166653114,
                -0.010140056505468816,
                -0.03297651957973691,
                0.0022879560102997154,
                0.037716705172254214,
                0.05271364792527606,
                0.11554633007993656,
                -0.102698134021493,
                0.027516085671743084,
                -0.005949109925659782,
                -0.02333761653108218,
                0.021542377879523216,
                0.022887684718844222,
                -0.02007161235156816,
                0.0029572832999289335,
                0.009317855456727251,
                0.0018926509771578883,
                0.021728436738767842,
                0.006469027637781621,
                0.023231343385801614,
                -0.013323526756243737,
                0.020626557689665388,
                0.009514605916543389,
                0.01854453203433271,
                -0.009421856587994746,
                -0.028886475686537613,
                -0.0032502089708507757,
                -0.002936336776269195,
                0.009260382052340903,
                -0.004475604279906414,
                -0.02763271681023607,
                -0.014283763315787209,
                0.036403896792509036,
                0.005860815370973618,
                -0.01443491834492808,
                0.005304207956817988,
                -0.014213955901699582,
                0.0007567250486589018,
                -0.00770403692744708,
                0.0003150374756942452,
                0.025268776057316922,
                0.0019581813421530162,
                -0.053303449218549334,
                -0.006974012382727405,
                -0.12107338719931306,
                -0.013759266449003006,
                -0.08802820895792172,
                -0.004057585292940921,
                -0.07097051220717394,
                -0.0028607908516644904,
                0.030046093135799343,
                0.0008586227193269841,
                0.008257430111140385,
                0.001091485826394167,
                0.02127615185722022,
                0.00018942336577343745,
                -0.05273025826914832,
                -0.001024300169617272,
                -0.006638103721467128,
                0.0023668220617086354,
                0.016308421846297,
                0.0009234001044251102,
                0.03563564813337162,
                0.003507853760216687,
                -0.2642392916032446,
                -0.012848877234977041,
                0.04166409736617746,
                0.0008290317779493839,
                -0.05340903991505755,
                -0.002328692134914024,
                0.006476185546343419,
                0.010145045277626202,
                0.030701534590969633,
                0.0018226986289192385,
                0.03453275284659763,
                0.001352744291600363,
                0.025290580053518162,
                0.0025604131512174336,
                0.0613930512163849,
                0.002587917310854593,
                -0.04106150268275044,
                -0.0014582766377682734,
                0.02836356538158932,
                -0.0036924206324240863,
                -0.03128760752140032,
                -0.0017875396246663678,
                -0.02539393066132651,
                -0.001659591758097883,
                0.03854490963230079,
                0.0018710115964713204,
                0.013006245634204772,
                0.0032871291658467246,
                0.01112117156292277,
                0.00029784815962705514,
                0.03618805080641922,
                0.01740589162241512,
                -0.013506534447725458,
                -0.0008310383069924742,
                -0.000035783558540151,
                -0.00030953416992567383,
                0.01856495464281162,
                0.0006997150139748995
            ]
        },
        {
            'energy': -0.5434873172542128,
            'occupancy': 2,
            'alpha': [
                0.005354182691287846,
                0.02030800587458969,
                0.029205100730929495,
                0.03390160608544275,
                -0.0011192482376866366,
                0.01916171548757865,
                -0.03863724929535794,
                -0.03179702142406739,
                0.005657845278738805,
                0.04515289996250227,
                0.05515808443341132,
                0.011398541118750084,
                -0.006559228063401194,
                0.006047600543551519,
                -0.012277818396368408,
                0.0018446867387060767,
                -0.005236374950194108,
                -0.05555867300969674,
                -0.007560211426408232,
                0.03302445071965207,
                0.01912695197654662,
                0.03247964375391196,
                0.01574717936382401,
                0.05780111621939605,
                0.0008252812600517673,
                -0.004280062454834639,
                -0.004333874752416455,
                -0.04960440059513827,
                -0.0009745850504982624,
                0.003729403138384309,
                -0.0071581597471794154,
                0.00398764309886815,
                0.014102868496968221,
                0.014278749817382716,
                -0.023302423296889235,
                0.016035354787506943,
                0.011636052141367668,
                0.02241125861448779,
                -0.0501142536928105,
                0.01112483933390808,
                -0.01237121638292844,
                -0.004795317873772489,
                -0.01250068785947401,
                0.029008050403620436,
                0.0000172767652925355,
                -0.004547256900743927,
                0.006085628389105347,
                -0.03171245221677444,
                0.0038141133605392,
                -0.002985743518459708,
                0.016919131491671933,
                0.037569535758697405,
                0.004361484752010794,
                0.008974963652876101,
                0.005782238898233104,
                -0.01038951813323284,
                -0.008378634891238093,
                0.006758236160253815,
                0.00442215574468319,
                0.007361237718418541,
                0.0038989221533697297,
                -0.002946954638276253,
                -0.0023639110253151486,
                -0.017386846434976153,
                -0.0008670297478910641,
                -0.017211427249407968,
                -0.03364144203751044,
                0.02698254988440769,
                -0.008979955452825808,
                -0.005868796858943987,
                -0.07850907705381771,
                -0.051108570913205066,
                -0.0023319120625770427,
                -0.0036900033136309683,
                0.0451456132399004,
                -0.008223503005284606,
                -0.001961127656082156,
                0.0016303177665713488,
                -0.0035627447667543046,
                -0.03913860295358408,
                -0.0044274937302366596,
                0.006384181429865027,
                0.00035635725468048315,
                0.007935743377154983,
                0.0228610496552408,
                -0.010851046631289156,
                0.01671614365586527,
                -0.034788120431121054,
                0.0027773010299050197,
                -0.003926972187847059,
                0.001077718432121559,
                0.004297725878624556,
                0.0002757373085715246,
                0.014246324833804728,
                -0.00942292067441259,
                0.04875357849403546,
                0.08469211320203769,
                0.0736232344639578,
                0.1430649183748627,
                0.2301065964553507,
                -0.07440016346216116,
                -0.23373843786464218,
                0.2617126426936721,
                -0.002045318115515598,
                -0.004220346240814544,
                0.009328901480941686,
                0.009481791059521039,
                -0.0032848116328845997,
                0.00899478058129032,
                -0.0005331728717499769,
                -0.005931403566384128,
                0.007729845302974302,
                0.07131266099379148,
                -0.20691675509326338,
                0.24868620035604946,
                0.0075736435901100786,
                -0.08552881672727533,
                0.10049874766442661,
                0.14059538511013106,
                0.25068174694477174,
                -0.003828700573621904,
                -0.001201676028482728,
                -0.008855168267360788,
                0.008807236975930997,
                -0.0025960051763914676,
                0.0067216810072311265,
                0.010864134120697866,
                -0.007898105189187772,
                0.025312679198857557,
                0.0018732323612569886,
                -0.06322622623552385,
                -0.05558231723748497,
                -0.0006736290589300931,
                -0.001144374551006938,
                -0.006167675882271298,
                0.0006022429157999025,
                0.007233728824550721,
                0.01312112846226242,
                0.021665941465023507,
                -0.018257172918578698,
                0.003432568271075361,
                -0.0009482147812750704,
                0.006079370101965421,
                0.006564128777130051,
                0.003521110941466882,
                -0.00396831725935279,
                0.0002979721214179084,
                0.0014955873093150142,
                0.000010455363489697572,
                0.0034491534849338604,
                0.0015552184972607314,
                0.004480782301260334,
                -0.0018222578387344255,
                0.0033291209444625334,
                0.0021730144537783582,
                0.003599015327213471,
                -0.0011183637156525115,
                -0.0052636555190332624,
                -0.0009438281941644238,
                -0.0006929058961069999,
                0.0010603337226009837,
                -0.00042632602980426706,
                -0.005026847336461727,
                -0.0024423320700933176,
                0.015209786210475053,
                0.0012602803759919816,
                -0.042980525127898635,
                -0.001327201759697872,
                0.00030169169494845196,
                0.00036611185430146656,
                -0.027031517129669398,
                -0.0017483466869230879,
                -0.006332910359078985,
                0.0023722186611681135,
                -0.011703754905769533,
                -0.0013876863720091966,
                -0.0339161786424788,
                -0.0038204318803665943,
                -0.011076903820993621,
                -0.000974816727993241,
                -0.03390389440008448,
                -0.0012983111735666855,
                0.023422513389479264,
                0.0007682778643546679,
                -0.009316672006077116,
                -0.0002651647104069772,
                0.02453020863607866,
                0.0005084273666196196,
                -0.026882521288916394,
                -0.0005414328074129617,
                -0.0044783855248919915,
                0.00019115990473827894,
                0.0013814162281205597,
                0.0014517098773224335,
                0.006089687317049417,
                0.000594888271527941,
                -0.047141411185687356,
                -0.0024390565953616283,
                -0.1988996656176912,
                -0.0073601651065563125,
                0.26085248607669215,
                0.010266040444888618,
                0.00038417803631182843,
                0.0020142526299603706,
                0.008518017293591059,
                -0.0008302665566137455,
                -0.0010614382669793551,
                0.0011083368914855563,
                0.00377106708154323,
                0.0007263614837220034,
                -0.23561161731169883,
                -0.008918287157524398,
                0.20892246757084254,
                0.00634139793433692,
                0.004231613331349386,
                0.00007659941378727139,
                0.0010888013655059195,
                -0.00004366064577035232,
                -0.009634431890650625,
                -0.0003878023515466829,
                0.003108662873843931,
                0.00019854793106613186,
                0.0018626003397548122,
                0.0004688604073577686,
                0.0012011699960745052,
                0.00002662243306531463,
                0.00682290606526181,
                0.003194118053553111,
                -0.0016771236676582561,
                -0.00011561062871064001,
                0.0005988146525862212,
                -0.000023730894481689087,
                0.002757618904897445,
                0.00009519569510587372
            ]
        },
        {
            'energy': -0.5404771265564468,
            'occupancy': 2,
            'alpha': [
                0.007160276971470764,
                0.027804637003293317,
                -0.031746635418438765,
                0.062377063000359514,
                -0.09189805569578088,
                0.2281631973008054,
                0.04675962921574276,
                0.2078125867213473,
                0.05957379623144365,
                -0.003970889757697569,
                0.07612733896141097,
                -0.19800201527128675,
                -0.0010975505839165326,
                0.014631894558818618,
                0.03310491394809011,
                -0.05091122679526486,
                -0.05965359657843724,
                -0.15289395493720676,
                -0.09776738231542362,
                0.07053395770903853,
                0.03814626087268909,
                0.18419728130159546,
                0.0926062942409733,
                0.12043087890972504,
                0.01779374033397188,
                -0.07636767328220244,
                -0.019781611660630822,
                -0.0028907747970355305,
                -0.0005015891117910639,
                0.011616794691761316,
                0.02378831290084457,
                -0.03942215477873965,
                0.017065794831291174,
                0.056414645168537246,
                0.010352259240519995,
                0.015146240255567607,
                -0.023626027967143196,
                0.07511992931649594,
                0.004998840716497343,
                0.007062650956685504,
                -0.04095048382766447,
                0.06834035266279637,
                0.02438622278285093,
                -0.011149129377855643,
                0.00811976297104172,
                -0.002564776327417028,
                0.008224395451152602,
                -0.005543764087863948,
                0.014735106532797653,
                0.019729805140507477,
                0.057140908977068486,
                0.000024329849409346662,
                -0.016746978435179062,
                -0.016381211760965915,
                -0.019398198136473883,
                0.02285300176072521,
                0.020176690621969175,
                -0.09923317753327804,
                -0.05341326192613699,
                0.030852390873006067,
                -0.03790186150343731,
                -0.10371105223480521,
                0.07053442503539484,
                0.015732500262093062,
                0.01574083942432278,
                -0.16959243738599694,
                -0.1802283785920729,
                -0.13923223958141093,
                0.011967198261646812,
                0.009575281439387736,
                0.03674352172219101,
                -0.05118154994180856,
                -0.0017993752007758902,
                -0.025486138901518962,
                0.02533776343480567,
                -0.004873411161410894,
                -0.005606817013699366,
                -0.0015563766489748807,
                -0.016023059895570287,
                -0.015637662158567964,
                0.08373260273437576,
                -0.014191882597870027,
                0.022938777812621998,
                -0.0681730161879385,
                -0.04893003104740901,
                -0.04137824247539251,
                0.1526465870188175,
                0.11901608768809503,
                -0.00027156983619701445,
                0.008920978792105447,
                0.023370388405269116,
                -0.03410287234520488,
                -0.04759120521521029,
                -0.031809715004463834,
                -0.17047557244599804,
                -0.18589590226349623,
                -0.0023463438311175106,
                -0.011913166539661332,
                -0.008986105879389103,
                -0.07814421554263601,
                0.002159674289624546,
                -0.013921155297578548,
                0.04694285811675777,
                -0.03480929327290446,
                -0.07988490086556621,
                -0.02156083808440863,
                -0.06436545476780584,
                -0.009524912427785786,
                -0.07379268138691714,
                -0.048979708408955214,
                0.04131103215326726,
                0.04732223515140858,
                -0.005772291027401807,
                0.04441246787710623,
                0.006485072082003148,
                0.026315009206560873,
                0.0002531245802830647,
                0.042464484509658666,
                -0.01870754998085221,
                -0.0030574240794714325,
                0.07793321317744491,
                -0.041770954314763395,
                0.040717517753646064,
                0.055336792258829516,
                0.07832102503237935,
                -0.01055940942421161,
                -0.07289390008051704,
                -0.010806246596056644,
                0.03796644426243364,
                -0.02673994557385851,
                0.011732831769295278,
                -0.025659010851874692,
                0.000011897882727941515,
                0.007583784179458506,
                0.014184637015951195,
                -0.026221824063902353,
                0.047023494727786906,
                0.056105660293897186,
                0.09444700373777866,
                -0.027539461570231606,
                -0.08254548023495725,
                0.01372842537638781,
                0.027627010097302486,
                -0.04648307903205316,
                0.0005686078839143542,
                0.0009962858297332118,
                0.008817534305058009,
                -0.012380466924472571,
                -0.0002871778040381659,
                0.0045180605435842965,
                0.010376170731697379,
                -0.011132269151242002,
                -0.00024982786510878674,
                0.00303756768427031,
                0.006217753510379492,
                -0.005193690185906492,
                0.00017574411193573838,
                -0.0005553568135886277,
                0.004732930374209903,
                -0.007784028052579541,
                -0.00010365648391883241,
                0.002236470835496998,
                0.0014454533023377505,
                -0.0066616918853062545,
                0.03471996021582088,
                0.000010415680247628532,
                -0.02633122197669555,
                0.001249677983761934,
                -0.0022048921226280643,
                0.003287930461913828,
                -0.013365730318007984,
                0.0046923283165987905,
                -0.030038543115562213,
                -0.0018034268329831084,
                -0.04859396684908952,
                -0.0034283758465347832,
                -0.1630520016127572,
                -0.01414175978983599,
                0.2141636317378399,
                0.018794487128086724,
                -0.030958113327602708,
                -0.0017875737935003789,
                0.01022842735126339,
                0.00022319062870204342,
                0.01696237107977981,
                -0.000957818997128498,
                0.0010437507442080174,
                -0.00028408993412234925,
                -0.020031070712478477,
                -0.0011322320283762028,
                0.005336690601884822,
                -0.0018728319190644568,
                -0.046106921362039845,
                -0.00677544693727541,
                -0.08817024868742933,
                -0.009430401181632688,
                0.13926580172037703,
                0.009631639710372052,
                0.05399994655936657,
                0.003929467348092892,
                0.035884430206853564,
                0.0019995596602896664,
                0.062466902849613946,
                0.02279201346536774,
                -0.09171610222007501,
                -0.00479692514912952,
                -0.10170381285924601,
                -0.005980552659055055,
                0.00036110235165957166,
                0.000789790471997273,
                0.012629666534187576,
                -0.0001550273866874512,
                -0.005199388716225984,
                -0.001282819269413804,
                -0.07561289276608761,
                -0.009427672593085102,
                0.10275414706467448,
                0.0056135899583686834,
                0.09926328469287322,
                0.00580251840435995,
                -0.08554169814822549,
                -0.005239120293077786,
                0.0006233869333942582,
                0.0001536722240355484,
                -0.0005471939446055138,
                0.000043030127180443375,
                0.06007669959789084,
                0.016585737785330484,
                0.0000297526862926017,
                -0.000008877438322370763,
                0.0004822513442524744,
                0.000014722112950901545,
                0.0003112252312645533,
                0.0000027027452272253085
            ]
        },
        {
            'energy': -0.5389883928002209,
            'occupancy': 2,
            'alpha': [
                -0.007472306129890711,
                -0.00879592068600062,
                0.03025914212510611,
                -0.09632829223629819,
                0.017831369961422955,
                -0.018360181059248498,
                0.0736162095911428,
                0.16381437156516382,
                0.06475501530088733,
                0.03389590956651116,
                -0.05967035063923035,
                -0.12275487376462832,
                0.018532975310313442,
                -0.02699433528356957,
                -0.004181918478628001,
                0.05328602918948006,
                -0.03153037236638038,
                -0.1629148999509897,
                -0.05541678862856444,
                -0.010112955256180224,
                0.000008249443924598448,
                0.2218971037249728,
                0.0380618588479236,
                0.015081327600305812,
                -0.012057994571551633,
                0.11888983956684461,
                0.05974752464037346,
                -0.032550654970002355,
                0.0051110715857351895,
                -0.014187099292913603,
                -0.014120500274315164,
                0.04184425293033088,
                -0.020046833063293634,
                -0.060965248192389444,
                -0.0033771708357458533,
                -0.012394333756661284,
                0.01855852185021976,
                -0.0972487712769218,
                -0.06316435877006027,
                0.04080992337511236,
                0.039366126887033726,
                -0.10751101235527201,
                -0.04226179805680209,
                0.05008264414716794,
                -0.01060987943503729,
                0.023543872363722223,
                0.0027191157230932483,
                0.0024316861182565033,
                -0.029644549491117493,
                0.003513546454930119,
                -0.06859309557747104,
                0.03994189298538111,
                0.03418098998885616,
                0.01410994512335784,
                0.029687047922784062,
                -0.022497785242532667,
                -0.012060400891312275,
                0.1333433723131053,
                0.09140792224072503,
                -0.03218683165613998,
                -0.010388589635097504,
                0.011114714467732146,
                0.039141989583408754,
                0.03225937503884515,
                0.02876096968849371,
                -0.10876576391878102,
                -0.07230485982392622,
                -0.06650868016522159,
                -0.01584528414339861,
                -0.03781816079979468,
                -0.05326472614414303,
                0.08348324909456208,
                0.0027339931757350004,
                0.05559391070151874,
                -0.022244730736649867,
                -0.018325539752657972,
                0.004643621508036387,
                0.016506148759459868,
                0.03475464190820992,
                0.015835521214362675,
                -0.14638430484866222,
                0.025409064804932584,
                0.0020207492082229125,
                0.10110579881171451,
                -0.05431784058070355,
                -0.04665588660710577,
                0.06825240193972222,
                0.10476219393390515,
                -0.00028168097332994813,
                0.007146230716018004,
                -0.025040458349226063,
                0.02476247347894001,
                -0.034268209063258025,
                -0.0391589796050982,
                -0.09768901701214326,
                -0.18451849059900194,
                0.0017904026672225552,
                -0.0005881756309435411,
                -0.014324680578550224,
                0.09370716100687969,
                -0.004200838758145547,
                0.007796135500880348,
                -0.07795296329087471,
                0.05038623222328993,
                0.11441088959101134,
                0.03985053807062383,
                0.10351392786690963,
                0.004797747495261365,
                0.11160679488046545,
                0.07118589749788119,
                -0.10500437129215268,
                -0.06375501427442719,
                0.001420885995400795,
                -0.05769153163958833,
                -0.02055238512340502,
                -0.024088378071060637,
                0.006324489055784532,
                -0.056867960987352334,
                0.008104817352838495,
                0.006037482710260146,
                -0.11310692697892974,
                0.06710043988087352,
                -0.09619335578632439,
                -0.08988770796801378,
                -0.11661212293713273,
                0.02916611759626902,
                0.13641164395283567,
                -0.004349347285905017,
                -0.04288163777525869,
                0.026147386616439075,
                -0.012134085125529648,
                0.03287909643192838,
                0.0009621333159198137,
                -0.011734105659387751,
                -0.004343796373763238,
                0.03161410825392487,
                0.017902983945043437,
                0.06221708549811823,
                0.029972855385688463,
                0.009846398371046216,
                0.1312447002155055,
                -0.014349866354689576,
                -0.0030719921183133157,
                0.06277381662856331,
                -0.0026492375689523505,
                0.00967307022158521,
                -0.011483503917183304,
                0.013738097400148338,
                0.002234589008946904,
                -0.00974930053793988,
                -0.018486937202529974,
                0.004843168035421813,
                0.0006653707765253539,
                -0.009568906195132412,
                -0.013527312167364811,
                -0.001049773564701902,
                -0.0010868285442745345,
                0.011821088203987537,
                -0.005550693488048136,
                0.01075345176704204,
                0.0005674264629751693,
                -0.007388811677101053,
                0.0074048484985924454,
                0.011552241474236497,
                -0.028175879372372377,
                -0.00004346509249764773,
                -0.03074988341620424,
                -0.005231158009227621,
                0.011744020725246952,
                0.00023098090922046675,
                -0.022260957990634826,
                -0.00409290952172433,
                0.04876369621326363,
                0.004663934675067957,
                0.024109087137283793,
                0.002124987668560776,
                -0.08421333405119635,
                -0.004485092225579076,
                0.12730179577781547,
                0.01147401466850716,
                0.043483323992317795,
                0.002485820388491555,
                0.01152642628622846,
                0.0006179637715470011,
                -0.041644327759546504,
                -0.00023220581820942657,
                0.008145513048658324,
                0.00047892602803547825,
                0.031029714107477582,
                0.0013271282958676963,
                -0.020534391013964898,
                0.0006699599497344901,
                -0.004971646867864754,
                -0.002576365427440494,
                -0.0651814935023775,
                -0.008945735734600859,
                0.15292968010726596,
                0.009328860951120127,
                -0.04942752954117236,
                -0.0033182581803719137,
                -0.05315835861323401,
                -0.003318226944395741,
                -0.017493107415224588,
                -0.0023178918083760465,
                0.14079853169137957,
                0.007616760343283929,
                0.16447138584095833,
                0.009843635762655425,
                -0.005496837372601494,
                -0.0012584259039984977,
                -0.012449957644230127,
                0.0007781765612924707,
                0.002535832576617122,
                0.0017391331643398184,
                -0.07316093419973976,
                -0.014256880664686566,
                -0.171827224961557,
                -0.009056963438146435,
                -0.17036222334448545,
                -0.009638102472444905,
                0.10876875520763211,
                0.0077535595490802,
                -0.002124661237173557,
                -0.0011566264026995413,
                0.002312073364970224,
                0.00007557182855269313,
                0.028842090385967557,
                0.006165114862967841,
                0.0005225079602732625,
                0.0000594599045078306,
                -0.002170712057466266,
                -0.00010552981459840869,
                -0.00010409269451825608,
                0.000027035110152996833
            ]
        },
        {
            'energy': -0.5362191462103612,
            'occupancy': 2,
            'alpha': [
                0.0012407158107906968,
                0.028967427999651185,
                -0.07337196962386772,
                -0.043756004307982536,
                0.020452516140893988,
                -0.06784043317305301,
                -0.039309119414435316,
                -0.18597781836797955,
                0.0071134252677649236,
                0.02877634743189566,
                -0.022490030013874562,
                0.027851422657042272,
                0.02272482480535584,
                -0.023214777377998926,
                0.03866537036784643,
                0.012504280848360253,
                0.004164272964827858,
                -0.14214755115439576,
                0.0031382491987225884,
                -0.025049971159985158,
                -0.0053818566230257455,
                0.2064472189670225,
                -0.01030984351475425,
                0.0012148347608029579,
                0.008842064976694493,
                0.001521915899496371,
                -0.07654085139565574,
                -0.026893452680060666,
                0.00957786992492928,
                0.002717733797982383,
                0.012503912968179983,
                0.007797024930392018,
                0.005773026335080096,
                0.011663490675887733,
                -0.022887493778297067,
                -0.009919078614475699,
                0.03332284014792669,
                0.06696482706945155,
                -0.10615497298828504,
                -0.08635051884829649,
                -0.0005498851988030917,
                0.011843095495216104,
                0.04475507242782605,
                0.013553138123887054,
                -0.0010588659048795586,
                0.015976295040113064,
                -0.02547978899312857,
                -0.0174810878056959,
                0.0018364620002752072,
                -0.040757359088455535,
                0.1460705419663412,
                0.06303476911400861,
                -0.00017010297670922973,
                -0.02195705717991421,
                0.032826432635216556,
                0.010477239283480752,
                -0.00763438704158268,
                -0.055699181406354985,
                0.1009062495066011,
                0.08957339569499773,
                0.0385068383735665,
                0.03198528217888323,
                -0.05936321679540183,
                -0.005843719310560455,
                -0.000539529145761372,
                0.01361322456565941,
                0.04461596224017194,
                0.07645551234558845,
                -0.001510901440897277,
                -0.014847917241955695,
                0.026871379541888247,
                0.008107244095039757,
                -0.0018083260130526118,
                0.03580716101704285,
                -0.0038108062087458933,
                0.018834177330503275,
                0.0056093170056272,
                -0.017459062357867802,
                0.02145830028339118,
                -0.014571409782586073,
                0.03935767715438498,
                -0.06810070354245298,
                0.22908174567926076,
                0.12605770044743478,
                0.02523616602716309,
                -0.0021262651006098603,
                -0.03303424589363191,
                -0.0289633947351313,
                -0.004332599309215966,
                0.018956264572945,
                -0.00946028250906805,
                -0.005830463315715091,
                0.008952508286466699,
                -0.07304760578911497,
                0.012608428726404301,
                0.0015804330148793645,
                0.010484153674546297,
                0.0035853137920710634,
                -0.03972783530543106,
                -0.02663888670012656,
                -0.0022929604172456527,
                0.0023888922016015433,
                -0.024120494218223352,
                -0.01208240604823936,
                -0.05094225253533845,
                0.12134475586824427,
                -0.026835633178604483,
                -0.24218617995412345,
                -0.0008687623451389062,
                -0.06535236923128734,
                -0.22297104145014934,
                0.10592311912261047,
                -0.02097401403586075,
                -0.005303706780146842,
                -0.007111868402321411,
                -0.00809398057919645,
                0.017175953154124544,
                0.009168842102258696,
                -0.020213540816560877,
                -0.004099767557129363,
                0.033049311197681744,
                -0.07934423252336353,
                -0.2159822757054337,
                0.13626882879690128,
                0.012398639342727034,
                0.12143763124379302,
                -0.005134503319691616,
                -0.23782002669008437,
                0.007105418419455285,
                -0.008069222358378987,
                0.012332714520654613,
                0.0037814380800113485,
                -0.007600784623879359,
                -0.009770146686107402,
                0.018520812315031582,
                0.00987724277438892,
                -0.006208949975577102,
                0.05545850612763847,
                -0.010687037346370741,
                0.010759060703013735,
                -0.02852495406047295,
                -0.06392570711094213,
                0.21964824501468394,
                0.12944459738183545,
                0.004811199153356532,
                0.017836115254405597,
                -0.000330742822261082,
                0.004688394872059275,
                0.007207316468215583,
                -0.002675218365621374,
                -0.02051922322178393,
                -0.014090560795518162,
                -0.005451543086041044,
                -0.0016869435640001536,
                -0.01858470313680274,
                -0.012708745491448677,
                -0.007518018364843544,
                0.01886248128155486,
                0.004954961441837106,
                0.008515072012209017,
                0.008566161689391717,
                -0.009357324352281277,
                0.015355643577066987,
                0.007754232765595169,
                -0.04011485017033092,
                -0.0002470792018341777,
                -0.048194814085460995,
                -0.0010425117367083246,
                0.003903669264143926,
                -0.00045441671810100815,
                -0.057191206741529756,
                -0.006702334113995616,
                -0.08987570705951858,
                -0.007251761845246701,
                0.018497493550814776,
                0.00392440004440721,
                0.009995664776263923,
                -0.00000349984131347795,
                -0.06720375963136493,
                -0.0085044840150439,
                0.018078875172172663,
                0.0011714765802113222,
                -0.011470497788570736,
                -0.0004285599052939889,
                -0.027565907063602332,
                -0.0013878792791094984,
                0.021071184558817065,
                0.0008657128877935437,
                -0.00041464436310692645,
                0.0003018673507432346,
                0.009719209523266218,
                -0.00048775363378192804,
                0.004678511076082164,
                0.007591551028705955,
                -0.05320022024521632,
                -0.004330996732869814,
                0.03218009801601139,
                0.003005215661911116,
                0.040016731114105655,
                0.004294994355792766,
                -0.020745333161139898,
                -0.00100685444179562,
                -0.005423453523518534,
                -0.004154447242654034,
                -0.06376561258441091,
                -0.0037007965233728426,
                -0.010556474651866503,
                -0.0006492413407212918,
                -0.004013989785734788,
                0.001253737331026187,
                -0.007081989758664387,
                -0.0019951017443143614,
                -0.004236378803292144,
                0.0010371154211380575,
                0.0014672001719933316,
                -0.0008552713960015073,
                0.054613535758111745,
                0.0031238253238946513,
                0.025732730063420133,
                0.001255601622511899,
                -0.016407213061177213,
                -0.001538577403547062,
                0.004738584827159758,
                -0.0010893946716240617,
                0.013326430235835145,
                0.0007770610635383408,
                -0.005080956672749468,
                -0.0019728005798200195,
                -0.01142732591325651,
                -0.000506759364774121,
                -0.011924786470190834,
                -0.0007023441237970087,
                0.00477839602434148,
                0.0004529583309906102
            ]
        },
        {
            'energy': -0.5356252333786848,
            'occupancy': 2,
            'alpha': [
                0.001329657885115278,
                -0.009551363702351146,
                0.0005186783704256179,
                0.04620982079356856,
                0.04869413746095454,
                -0.1322935503024816,
                -0.026910423034468754,
                -0.11083904462193257,
                0.014242893232055562,
                0.030293480310365276,
                -0.08799631602675898,
                0.03583907375775676,
                -0.06207033158628829,
                0.033304446373140194,
                -0.09216433326600887,
                -0.06860731228350919,
                -0.0010214620374136797,
                -0.3560551801120348,
                -0.009825648846318405,
                -0.05339745589989187,
                -0.012431168651111322,
                0.5465004307844207,
                -0.003821032674628452,
                0.012873345901230833,
                -0.017106900301392496,
                -0.007928453526208896,
                0.012433612563537366,
                0.03919874945188033,
                -0.011004385037788503,
                0.01406074119129143,
                -0.013938495931695263,
                -0.026022464536379793,
                -0.00010477554696971065,
                -0.02045683390186395,
                0.014676277635259374,
                0.010361838456334895,
                -0.009167896610487287,
                -0.02054151307145635,
                0.05200571584846079,
                -0.009095176050084466,
                -0.011821473754375486,
                0.030848410396931238,
                0.011238836329928276,
                -0.023651279957233,
                0.0036825529381847356,
                -0.012753506871506443,
                0.01571755658706242,
                0.020694207123780926,
                0.003239644008180255,
                -0.030601695272848884,
                -0.055299153201524585,
                -0.03734596206292688,
                -0.002261215191203708,
                0.04269213150841487,
                -0.006106625807795016,
                0.028336525592154573,
                0.011809353390240498,
                -0.03150737196199084,
                -0.03558062948597788,
                -0.04847731033353197,
                0.00874609929790157,
                0.07317340172157105,
                -0.026488200438525008,
                -0.012234507318131903,
                -0.017397177401217035,
                0.15670448173689877,
                0.14142015648188963,
                0.09743854658961199,
                0.010222908693615128,
                0.028253236442721753,
                0.017988146381467257,
                -0.03310391584097523,
                0.0004323915679774686,
                -0.027645046969656955,
                -0.01575417520629411,
                -0.0018902540659489727,
                -0.002657532563269872,
                0.012034587766038503,
                -0.017786965408805453,
                0.02518905883799488,
                0.017097675822476486,
                -0.005815214580042447,
                -0.08412885847682847,
                -0.0663001471314565,
                0.018130658178799493,
                0.011890468652119375,
                -0.07911324741503206,
                -0.025050457795812935,
                -0.004318750462730663,
                -0.061411823244307745,
                0.024853785688564018,
                -0.010419922357745795,
                0.005582173969473455,
                -0.21337587988623452,
                -0.003385025346109455,
                -0.05954362848490587,
                -0.0034835542389340846,
                0.004805779487295006,
                0.024579559295399015,
                -0.027232461890383905,
                -0.000024468443168251445,
                0.00043432754489781104,
                0.033802666938279796,
                -0.02318763350332825,
                -0.0008651043615708039,
                -0.058394561183396095,
                -0.010005663799597083,
                0.0725000818122582,
                -0.014508006614705485,
                -0.0015916919634106441,
                0.10133352840822273,
                -0.03213577660937984,
                0.005727576190168817,
                0.025663922132861262,
                0.010862482032964227,
                0.006452831149208064,
                -0.00557506673678605,
                0.02323480125024652,
                0.009477246506484667,
                0.0028128769443513586,
                0.005689162360213462,
                0.006065135501344486,
                0.09466213696983253,
                -0.030202943384877976,
                0.012803113751776212,
                -0.05413553289773829,
                -0.025746594558743896,
                0.07832690790906449,
                0.010175615493704274,
                -0.003407737864061731,
                0.0012763926856297631,
                -0.012544906174148886,
                -0.023597915158505584,
                0.026767847393000224,
                -0.03216834490816551,
                -0.02971642101256803,
                -0.008721660782850745,
                0.14525582677361337,
                -0.014925407510123782,
                0.026412775313196878,
                -0.013383954807218865,
                0.014462240692430656,
                -0.0812772163193232,
                -0.05120836579032777,
                0.012158283078372002,
                -0.047782011405160925,
                0.028763951400401923,
                -0.001777368240835675,
                0.003413151265621932,
                0.028353629849135413,
                0.025092156146078938,
                0.015685481095575264,
                -0.010504765444135648,
                0.04047160663295408,
                0.019314829435156926,
                0.019041572469767013,
                -0.004153847713374269,
                -0.04613039440203165,
                0.028275968417242347,
                0.001212256521319867,
                0.01319886514763797,
                0.03207697108347746,
                -0.033221059714956355,
                -0.017362148539627302,
                -0.004461378144083765,
                -0.001410600372127318,
                0.046116156776037115,
                0.0008003280722106719,
                0.0005905623714652736,
                -0.0019522704925039177,
                0.050902824364928254,
                0.0024902825150455252,
                0.023894161462366347,
                0.0022755074883497924,
                0.027363600554721753,
                0.0022807181826348007,
                0.14310980302769868,
                0.01242643886677724,
                -0.16285997538181574,
                -0.01785202180092212,
                -0.0011755467681449291,
                -0.0005315337094175813,
                -0.008786428188303773,
                -0.00046760874041621076,
                0.02690212736120572,
                0.0007980452192268764,
                -0.02622448747986143,
                -0.0008770081826263189,
                0.00878539431894591,
                0.0005561486689336023,
                -0.004543244959774495,
                0.0016028420671119438,
                0.017135112156817074,
                0.010770540933087932,
                -0.17189115979041336,
                -0.014891258001338606,
                0.13712250317863645,
                0.01171520342296268,
                0.0029127314342068528,
                -0.0003999865141933292,
                0.020840352887760892,
                0.0011993191734173047,
                -0.03718816464521703,
                -0.014583208070269053,
                -0.003434149618859321,
                -0.000020731752369878104,
                -0.024862467732266105,
                -0.0016325285006087804,
                0.017442219173742928,
                0.000912949776906292,
                0.00773800378286832,
                0.0005135887801197823,
                0.00799665039832919,
                -0.00032931258063391606,
                -0.005960172152484532,
                -0.004598937311069572,
                0.015389695528120022,
                0.0006546236679933878,
                0.022905213355970507,
                0.001286443623771279,
                -0.004840450036868899,
                -0.0006276425735983873,
                0.02396839370107976,
                0.003737129494935812,
                0.008419492453152858,
                0.0005920447092402675,
                -0.002069571957464571,
                -0.001967474330973162,
                -0.02150397718075791,
                -0.001001080346007843,
                -0.020673217065680247,
                -0.0008939537128096293,
                -0.0028694300620928886,
                0.0003348872737269684
            ]
        },
        {
            'energy': -0.5353977253128572,
            'occupancy': 2,
            'alpha': [
                0.006145996152262685,
                0.03436071930445877,
                -0.02991364479730329,
                0.10848233751171404,
                0.00053474993380155,
                -0.009226060024595025,
                0.05161122631658323,
                0.047276872951906114,
                0.003594936653252269,
                0.0009572335851036717,
                -0.015492754066097115,
                -0.0044352296628881556,
                -0.1865191434868531,
                0.11144145341248034,
                -0.23345350395222456,
                -0.27126194492415623,
                0.0015087193594794804,
                0.07998272844361601,
                0.004032382430867418,
                0.0006792634552034263,
                -0.002453577039353484,
                -0.12117914541138952,
                -0.006692970817281684,
                -0.019309347214842627,
                -0.02627705352640069,
                0.05461596533143372,
                -0.023765246807220492,
                -0.022711300697778235,
                -0.028769360069491687,
                0.0519366102139986,
                -0.012649076806570835,
                -0.11376568577709426,
                -0.01802022661620623,
                0.005492325676236045,
                -0.02562324005958078,
                -0.028749609601180472,
                -0.001603552188866775,
                -0.021844404685542298,
                -0.015120062200157918,
                -0.0030840384223585894,
                -0.06596096749361327,
                0.06123605768377669,
                0.01508070788052396,
                -0.018598347903295447,
                0.023064340395324814,
                0.009777524303774996,
                -0.048907580402654666,
                -0.0022222504699936207,
                -0.02149691318908153,
                -0.017635505632676938,
                0.01676503835986724,
                -0.03706298667834718,
                0.009419099483641967,
                0.12398033368846782,
                -0.03519633696439079,
                0.1416981025548508,
                0.07529930942564456,
                -0.1350081544091948,
                0.05300157144011376,
                -0.10862859727195594,
                0.008098713422958894,
                0.006228144562501619,
                -0.004164956991979167,
                0.016581940340901918,
                0.013559503435499375,
                -0.04561647089726044,
                -0.024481384422021076,
                -0.011562973271014559,
                0.04057324064308996,
                0.04106266484047905,
                0.04180095060512169,
                -0.06410335592655135,
                -0.007619632942528044,
                0.027124804531637774,
                -0.06637731619381904,
                0.09063494929490735,
                0.012077418034034105,
                -0.032673222659928836,
                0.007786244264121862,
                0.018148832970743333,
                -0.07688897235015023,
                -0.09975074693008251,
                0.06498901570254596,
                -0.03655061939256864,
                -0.010901331578571554,
                -0.010123790452288424,
                0.011020279243232211,
                0.015121337297868827,
                -0.0143903040006648,
                -0.17416560929482594,
                0.09888253718514393,
                -0.07300286158570264,
                -0.0014612793556327225,
                0.05272141164979993,
                0.003405403063604741,
                -0.0012466552887531379,
                -0.008185887458403178,
                -0.027232799809000806,
                0.026105869232985846,
                -0.10160723922202411,
                -0.004089988321933907,
                -0.034164719163816006,
                0.07148808874593256,
                -0.06899353173128926,
                0.04037872010323011,
                -0.03761363787185198,
                0.05381895964922615,
                -0.04668566010814001,
                0.03910914922631825,
                -0.039450743181450185,
                -0.09997281988048662,
                -0.054736720807148094,
                0.00240055165000025,
                0.08352480097915096,
                0.006041608501265621,
                0.04345081456004799,
                -0.003931525701406036,
                0.0787132320589699,
                -0.004336824057429604,
                0.027303779486568966,
                -0.036376590838237355,
                -0.004946207074024347,
                -0.08932773182212632,
                -0.0680855521906047,
                -0.04105903675450173,
                -0.012195062533766204,
                0.08835106518500459,
                -0.04755152452759688,
                0.04684237739914582,
                -0.029498615862989488,
                0.012540597275086678,
                -0.038809388359169014,
                -0.07902984671139224,
                0.08779117775422372,
                -0.07453103963538298,
                -0.11081989401628413,
                -0.0013151422495714484,
                -0.03256343412034423,
                -0.004163648332063173,
                -0.0003988716604592213,
                0.06308116200701713,
                -0.02590239494586346,
                0.05804519240076405,
                -0.008386646484991052,
                0.04017859916242731,
                -0.13834505478032577,
                0.09935435416210997,
                -0.015361602967495802,
                0.014647835008017036,
                0.0916407570681285,
                0.07514125330673031,
                0.02822825105375261,
                -0.03535040596322726,
                0.12936964491558878,
                0.05479790856049914,
                0.04546641685051268,
                -0.016749518934924632,
                -0.13311452358233514,
                0.09828236355395399,
                0.00165486880997685,
                0.04663601776299536,
                0.09982595424311386,
                -0.09158531575778911,
                -0.05551721991558967,
                -0.005733210508636559,
                -0.0016641784187675218,
                -0.006082151645256393,
                -0.00019095347606095213,
                0.002677379151740345,
                0.0011443720557576212,
                0.024755814853050714,
                0.0006185587988632101,
                -0.03651856142964003,
                -0.005799630264725649,
                0.01745110226807359,
                0.0021711784344548885,
                -0.03425408848543983,
                -0.0014532106943648169,
                0.03876798885683749,
                0.005015109252554967,
                0.05674920953672862,
                0.0014942697033175842,
                -0.09426345298063281,
                -0.004503768734563941,
                0.0003552705390912106,
                -0.0031779833310088858,
                -0.008130442038370529,
                0.0001463199155878743,
                0.013642478705260632,
                0.0017409051063298452,
                0.030237775107856253,
                0.004255656412839257,
                0.0017166488005020287,
                -0.0021529148837978757,
                0.04457523172934988,
                0.003342300732464118,
                -0.019907346766363066,
                -0.002194380996094054,
                0.05253284493797671,
                0.0023662342032167868,
                0.05911644863977986,
                0.0026076415377345734,
                0.0024497435229481495,
                0.00007899403510670893,
                0.061608160634430344,
                0.004313009935443797,
                0.08333220212593061,
                0.004525382395037597,
                0.05232561191274455,
                0.0025424268931223013,
                0.03618334756909306,
                0.0008043035573174846,
                0.026568018105574347,
                -0.0003798590381776837,
                -0.005385171048989131,
                -0.0010835115818275127,
                -0.09447895738721822,
                -0.004538903629549975,
                -0.09205453982636615,
                -0.004839812611488832,
                0.007967854332081477,
                0.002390174857281905,
                0.07810345277508102,
                0.011397530502940923,
                0.03465098841249338,
                0.0023652472186728286,
                -0.001648691800862862,
                -0.0006483240483748801,
                -0.07463394262720138,
                -0.0034469021577701823,
                -0.07287577933343008,
                -0.003244276958896199,
                -0.008365288649087095,
                0.0012516499952411673
            ]
        },
        {
            'energy': -0.5324682633351135,
            'occupancy': 2,
            'alpha': [
                -0.0019067694819133421,
                -0.008556692197187295,
                0.009284948366541054,
                -0.06759377662459996,
                0.03594338878936268,
                -0.08191670083619217,
                0.09474132111315844,
                0.1289623184889522,
                0.025236709717650775,
                0.04113604561462047,
                -0.0657859237330021,
                -0.005287597047575992,
                -0.0779396069537091,
                -0.022895661875901013,
                -0.21741034444375984,
                0.007167384097845155,
                -0.0012998145834901883,
                0.030015115311114664,
                -0.0015573953755436023,
                -0.01426191327434075,
                -0.007756645476423685,
                -0.05164086993821962,
                -0.009352504786379756,
                -0.030152254361641827,
                -0.022367666069893086,
                0.13991640469346234,
                0.03452497404455314,
                0.013628765495818606,
                -0.006070487272010329,
                -0.044186143857726075,
                -0.10635473762668207,
                0.09935808629716673,
                0.0710052482904313,
                -0.17809397729742837,
                -0.11168338911301087,
                0.0388001260824939,
                0.02255743378777802,
                -0.11955833075116715,
                -0.012203041596461617,
                0.06061472889009946,
                0.0035685244353383166,
                -0.02141226603437383,
                -0.022328627682322952,
                0.03816117915603377,
                -0.03986862987221317,
                0.0033471976076730288,
                -0.02841985077437094,
                -0.0811994807272285,
                -0.039816669732508844,
                -0.04616947042397183,
                -0.09025321414967553,
                -0.07335174259427882,
                0.05570284783686454,
                0.12186969192171979,
                0.11261890793670112,
                -0.1326737409836094,
                -0.04996113863075904,
                0.08315991683796414,
                0.0009967420190415527,
                0.04804757382896855,
                0.0028331741823221647,
                0.05850874203015549,
                0.01042585281430882,
                0.020094078170388413,
                0.026005290849232983,
                -0.03547460974471314,
                -0.008815475165652373,
                0.010359026330395716,
                -0.027697771006673196,
                -0.03422231486459185,
                -0.020880013173484577,
                0.03606762393463424,
                -0.004207635235093586,
                0.13578323280310647,
                0.07106620204795647,
                -0.03052461682464515,
                0.009001011377039222,
                -0.0009961264618937675,
                0.06425245332772979,
                -0.09724528209696406,
                0.1198247275553362,
                0.043967844580157706,
                -0.03362270799198628,
                0.0895762065001129,
                -0.023169173870955368,
                -0.032674855125008194,
                0.006177341817112126,
                0.031223788655325994,
                -0.008509726064573897,
                -0.10734950638850407,
                -0.020809476656190453,
                0.04826359798561888,
                -0.007257567495062239,
                0.04282203746695007,
                -0.006703416138363406,
                -0.04129831376155927,
                0.005083166171327208,
                0.015679271741302705,
                -0.0290009808087685,
                0.0558465110777676,
                0.0017735988177576976,
                0.012931550202182215,
                -0.039257339989761546,
                0.04280399636816645,
                -0.04802221724096497,
                0.06913967475119072,
                -0.08472870004703448,
                -0.0396809180557974,
                -0.03772910065200414,
                0.007478605277454825,
                0.07843827489693293,
                0.08942061190494092,
                -0.0036918994498923523,
                -0.05448330587728136,
                -0.0022679703391581445,
                -0.022588667930538004,
                0.0035144138091303618,
                -0.044614153772497445,
                -0.005550526462487587,
                -0.014868301523605099,
                0.04126156147075979,
                -0.03270811718887469,
                0.058063063964595256,
                0.12628184806452178,
                0.04153693157765137,
                0.040598262273697006,
                -0.12792962750470438,
                -0.02176233962464937,
                -0.02141237406255889,
                0.010822089653174688,
                -0.005603252330996779,
                0.02143040836709646,
                -0.056865678163730504,
                0.054038489403378874,
                -0.14338865400250622,
                0.06465341036685571,
                -0.0033091959298031694,
                -0.013156227219640795,
                -0.008842696807682928,
                0.00731781296343407,
                -0.08821886123138674,
                -0.012770756627131443,
                -0.03080422576666347,
                0.07436401689555112,
                0.01371823174757491,
                -0.1276586951996988,
                0.039260072311789705,
                0.0689154091115872,
                0.01622988881080269,
                0.039123436080328144,
                0.0019177219802168392,
                0.09522757545046354,
                -0.02105165208757643,
                0.07572116125392468,
                0.011204830937891794,
                0.07548979601623698,
                -0.004758139809819779,
                -0.10931227682639491,
                0.05896493343152021,
                0.06122698501758428,
                0.035900636546589745,
                0.08235638189249916,
                -0.08889419138922827,
                0.00415770958748496,
                -0.005195883332635067,
                0.0008236232524263741,
                0.0019005409172012705,
                -0.003911769768122598,
                0.0015804177798846232,
                -0.0044638711802969635,
                0.07909202194772498,
                0.0022994303016300927,
                0.004809044004459437,
                -0.001189495737160396,
                0.04470436631688,
                0.0035105234364771784,
                -0.019862357738175535,
                0.001886837481046081,
                0.023891673993193273,
                0.004847869082399248,
                0.01888452020983585,
                0.0007885846925510952,
                0.06959806393590266,
                0.002813116514768691,
                -0.13991027060891945,
                -0.0027030250837503157,
                0.10369997463164284,
                0.004070721995801872,
                -0.02819289086446699,
                0.0006175961035988886,
                -0.03016543859480295,
                0.0065207087780621105,
                0.021762614941936584,
                -0.0018062129723988665,
                0.034865828228297986,
                0.000997962247799798,
                0.014772669022319308,
                0.00006489406098209922,
                -0.021522515696097283,
                0.00014475544211123195,
                -0.03015044698449174,
                -0.0007258434336179267,
                -0.028655691331620277,
                -0.008729031473785958,
                -0.09797633323696625,
                -0.005439610248027183,
                -0.1090200996304453,
                -0.006988904729326151,
                0.004176961337458386,
                0.0017366166808104656,
                -0.026573677402814983,
                -0.0009153456334211101,
                -0.018686448267803638,
                0.00005400038238876966,
                -0.024677601615853834,
                -0.007289895265147923,
                0.1385546948962183,
                0.006625466553238062,
                0.1314530157335095,
                0.006664731512114945,
                0.02020157663973753,
                -0.002262467100894494,
                0.06694676865810674,
                0.00488384886987389,
                0.02220110587366781,
                0.002246608596474045,
                -0.0003334291422228235,
                -0.0010264479836601568,
                -0.04812018947279456,
                -0.0021964810773989645,
                -0.0692080093401483,
                -0.003033430531936303,
                -0.022752832587794508,
                0.00039482314553787937
            ]
        },
        {
            'energy': -0.5307329857632583,
            'occupancy': 2,
            'alpha': [
                0.00022942441137655485,
                0.10671708741713347,
                -0.34031107657466697,
                -0.18444449560303044,
                -0.005112695400566077,
                0.01614648960186541,
                -0.0015710455876354727,
                0.038986692033363586,
                -0.0071133392400943895,
                -0.014073073866569185,
                0.0051684404536915425,
                0.0013444515310297826,
                0.02622476574138938,
                -0.009558052131833613,
                0.03368980038439735,
                -0.010169797209989005,
                -0.00030276130820502815,
                -0.01238782203103041,
                -0.0006432066458259998,
                0.0019969769438602674,
                0.000757932626934257,
                0.025992588433707647,
                0.003751084772177173,
                0.006182153677276882,
                0.007080913375874877,
                -0.05879608288180084,
                0.02253325449393743,
                -0.011826493747142227,
                -0.017512091806271984,
                0.02425083750155802,
                0.015896390017635244,
                0.02970952839637413,
                -0.014501005091291683,
                0.07417018599112407,
                -0.09877746947889657,
                -0.04222196111521139,
                -0.019179007506348506,
                -0.0010045003217875074,
                0.08789953571792859,
                0.052761829536938774,
                -0.0142488323095936,
                -0.028018261287234805,
                0.05693071784613862,
                0.0389544118494701,
                0.005261817807360539,
                0.002254617853094686,
                -0.17622606695823798,
                -0.13323079372238555,
                -0.001442140548314141,
                0.026790499337954087,
                -0.07138895221429155,
                -0.04352654080416862,
                -0.0217302785796309,
                -0.0039459031478561385,
                -0.0680831294329374,
                -0.019472615985866987,
                0.0017759490066277476,
                -0.000627250405364892,
                -0.005790894249167488,
                0.0020295949374880867,
                -0.01632806499000935,
                -0.010462413899940877,
                0.016230306851932132,
                -0.005483025432841263,
                -0.010292770704641028,
                0.040268746646648666,
                0.01577104559281313,
                -0.011642777760930667,
                0.010366731189560684,
                -0.031136170091626905,
                0.13631797632415446,
                0.08398235121731189,
                -0.011598313730491716,
                0.09881090539188574,
                0.00028030348765814865,
                0.21134334670457353,
                0.024257964619795756,
                -0.1695784555911795,
                0.0332191055307198,
                -0.15693442003739372,
                -0.013251650154209312,
                0.005959313352964159,
                -0.005601245965188947,
                -0.01400008086310939,
                -0.0019866821213391744,
                0.012036770032398472,
                -0.0065364877829658255,
                -0.002523437246934976,
                0.024042239199116362,
                0.012929850266066084,
                -0.023871104466816593,
                -0.018413149208320077,
                0.00004628307800919254,
                -0.019109434564456663,
                -0.00044715899227008925,
                0.0013869582799439955,
                0.018663696532752266,
                0.08444234676586979,
                -0.10331178930810908,
                -0.012706422138421561,
                -0.02642900725679161,
                -0.04925747820981542,
                -0.07202943792503763,
                -0.13461454529118458,
                0.004268954966740833,
                -0.00929518350750073,
                0.00767020636040467,
                0.018512767307226754,
                0.002380821617220098,
                0.005672554083375469,
                0.0017403599160527314,
                -0.013471452637584782,
                -0.05246359185045354,
                -0.06834783581160793,
                0.010276341541218753,
                -0.07444058768250435,
                0.052186677399328196,
                0.11010388017500607,
                -0.029913528696999942,
                0.08690275023036831,
                -0.0030538912980186085,
                0.009276269468561216,
                0.004385813053540683,
                -0.017826191309346005,
                -0.003449706498396527,
                -0.008297860220707776,
                0.012207083460471824,
                0.015270222705890513,
                0.0064203153514250915,
                -0.019707451466886284,
                0.054964861690662045,
                0.026007087670559585,
                0.09773640317795518,
                -0.03326567381236308,
                -0.08496551700005694,
                -0.052795543542011256,
                0.0005266643847778111,
                0.0063041005902966405,
                0.001399866329834875,
                -0.0005031788579833927,
                0.00912256184383245,
                0.007508980006697841,
                -0.005550146466744116,
                -0.015304403564310199,
                -0.058879450269527824,
                -0.0022079307104707793,
                -0.034133962677983236,
                -0.01693758567511742,
                -0.018074134690520573,
                -0.06575670319745236,
                0.12791526283174537,
                0.07492843250518288,
                0.027330810714455075,
                -0.11089534330924088,
                0.11291357069288165,
                0.049135853707101385,
                0.043030655102988695,
                -0.020630261311657714,
                -0.07312046887466572,
                -0.049273346780228544,
                -0.08065106419901055,
                -0.04727906829435805,
                -0.056478465177178035,
                -0.0465114675769116,
                0.05367214891930287,
                0.0025163241033787057,
                0.02943106564710251,
                0.003207972089555061,
                -0.02668670755162309,
                -0.0010403970318272043,
                0.04009338345741867,
                0.0019898392670581002,
                0.041367422980434214,
                0.00292156637313055,
                -0.011975762683100497,
                -0.0026111179011218664,
                0.03504508323396691,
                0.0030590120692671687,
                -0.016267767938980302,
                -0.0014738786767136435,
                0.04305709845683626,
                0.0023763973050603317,
                -0.14559918077886513,
                -0.0073115813899277075,
                -0.07708739898564929,
                -0.00401619617177474,
                0.12235118062086564,
                0.005774170822385446,
                -0.10459600509355975,
                -0.003908240661137191,
                0.11830358469671533,
                0.0033404315830044577,
                -0.0016737259829149008,
                -0.001132458048659869,
                -0.016397946404259497,
                -0.0011040606971558311,
                0.00628733313465208,
                0.0008377231319963474,
                0.0680004870015814,
                0.005037329391668502,
                -0.05395556896133201,
                -0.005683550780996123,
                0.00025333103705245673,
                0.00032833788206795627,
                0.009733223758907303,
                0.0008169788308528086,
                0.012083281231132047,
                0.0007045119991861704,
                -0.009771085152182212,
                -0.00204146186796122,
                -0.0595677770396271,
                -0.009195979612777863,
                0.08335480559036752,
                0.010106219432680684,
                0.005332787910321541,
                0.0012653863348358265,
                -0.015215909277517497,
                -0.0006876869004859609,
                -0.013203547365583396,
                -0.0006687793708642157,
                -0.0047844315421845555,
                0.0001257861142946924,
                -0.0509711671212918,
                -0.0046637320591075854,
                -0.13038645828594367,
                -0.006967367756293691,
                0.0004473901431130999,
                0.00032356020982989757,
                0.14780015242163547,
                0.0064981878372708714,
                0.09838558382305357,
                0.005591954353215079,
                0.02346710616016737,
                -0.0018472976196172797
            ]
        },
        {
            'energy': -0.5298664987810684,
            'occupancy': 2,
            'alpha': [
                -0.0004850235256267832,
                -0.12634185392500735,
                0.36886436231228836,
                0.2425810575578142,
                0.001530598973517375,
                0.009144132574026426,
                0.009198412651997258,
                0.08912684771177466,
                0.00011463161856101078,
                0.0028038424149337006,
                -0.0016690219942733795,
                -0.0020120386233694085,
                0.037614284284628124,
                -0.055024258463425305,
                0.00992857191423641,
                0.003143591145594827,
                -0.0012170198564581316,
                -0.007317347223420471,
                -0.0019995879421864614,
                0.0002156703942928772,
                -0.000341629953994491,
                0.01602732085826424,
                0.0036007689387892883,
                0.001749448260764756,
                -0.008924789638754128,
                -0.026172982122091203,
                0.012844549228533982,
                0.009620802355887558,
                -0.018962268588505762,
                0.037499061358787875,
                0.03333345852631655,
                0.039843207706801095,
                -0.0010349643237255867,
                0.010743233633235597,
                -0.01546304324303925,
                -0.0037975752672604847,
                -0.025034714291292445,
                -0.03820769594814142,
                0.12468380659196801,
                0.06030462261255213,
                0.002948343655859621,
                0.010027328090077947,
                -0.05896109820461844,
                -0.0397466488955242,
                -0.003184982024471144,
                -0.009143180244642488,
                -0.017927128701340486,
                -0.014250312959984033,
                -0.01031790934988792,
                0.02922512008264306,
                -0.13444844688671875,
                -0.05531962367160036,
                -0.009209848079815027,
                0.004119070297675181,
                -0.02727953098285225,
                -0.019557617307110493,
                -0.0013634634515841434,
                0.01016439588224762,
                -0.0025213123139254303,
                0.0026585394739839937,
                -0.024895381793164872,
                0.0035815053917637647,
                0.028667572268808034,
                -0.012206886401090545,
                -0.006877063034063264,
                0.03978865198968074,
                0.013903117070263427,
                -0.008874482656433392,
                -0.00023727655315781623,
                0.06404874722299192,
                -0.14499192256705362,
                -0.10420523854019206,
                -0.0020055564640321807,
                -0.015387321706967454,
                0.0038238898298145483,
                0.028035518747806843,
                0.0016816226777867573,
                -0.022666640763371076,
                -0.004592509693629133,
                -0.024482098549080775,
                0.004875678559164189,
                -0.018631446000283616,
                0.07204867227017632,
                0.049500591101354456,
                -0.00747577703341203,
                0.0025511275348615897,
                -0.002396821135949162,
                0.0037587373769827786,
                0.023916448777968717,
                0.000910686640793046,
                -0.048109972917310395,
                -0.023416388695565386,
                -0.0025936199730834087,
                -0.009299746775163742,
                -0.0038671993117609304,
                -0.009150217990078582,
                -0.024656413097302307,
                -0.09459405396991367,
                0.14662981963184987,
                -0.01091690782121891,
                0.0202028860200321,
                0.05960238090046107,
                0.09905431564153372,
                0.12272589676843397,
                0.0033805626276500744,
                0.04186406333770469,
                -0.006637100709766216,
                -0.07584470032854629,
                -0.004813707896250379,
                -0.013629461500569326,
                -0.07634781953551162,
                0.028602041030652937,
                0.061340670584358895,
                0.1075411728604688,
                -0.0024468483910568516,
                0.0907111341399432,
                -0.05898823971782351,
                -0.09764036503237165,
                0.05174451835001543,
                -0.08513702801799931,
                0.002233790477253534,
                -0.015191855966672309,
                -0.07522686336374522,
                0.02865540038200843,
                -0.002039558065248861,
                0.04048689381997772,
                -0.006868235462241855,
                -0.07406356823830611,
                -0.0029544803631243533,
                0.02440105493346798,
                -0.06321291858273385,
                -0.04181769115834206,
                0.11112600646621426,
                -0.030770385049248172,
                -0.12607735488204164,
                -0.0863102344625281,
                0.00050268343180195,
                0.003973439457972076,
                0.0008553902388951178,
                0.0005278582787319133,
                -0.0021231885575374184,
                -0.02161422491096775,
                0.06871546861968805,
                0.04789445104434415,
                -0.07644611859403862,
                -0.019952231508852867,
                -0.016724557401351692,
                -0.013376069679358421,
                -0.0102357041755895,
                -0.08539655330397725,
                0.18207510236341592,
                0.10111415310889536,
                0.02351874915792025,
                -0.1384475510315501,
                0.15859834262143968,
                0.06983455592474512,
                0.0535006704231521,
                -0.0398831861401426,
                -0.06444771112131786,
                -0.051422186728618646,
                -0.09480326545135824,
                -0.04810885615553481,
                -0.0891689022862505,
                -0.07047060560955094,
                0.04283274000636946,
                0.001183473296929611,
                0.07122191493328311,
                0.0036751563653122346,
                -0.005887392487515393,
                -0.0007590032162445663,
                0.052329871726167154,
                0.004463472890954991,
                0.08258888922678585,
                0.006409500719561014,
                -0.012771131211844497,
                -0.0032977397404881066,
                0.035162631737400474,
                0.003722663817617315,
                -0.016593841363556336,
                -0.0006834514429392812,
                -0.010392509976016678,
                -0.0007612247829597449,
                -0.021153994009296108,
                -0.001100701107070924,
                0.0114835338783442,
                0.0009463763800513111,
                0.01394485850294832,
                0.000641425477224022,
                -0.020709655376740937,
                -0.0009980307821554682,
                0.016755885395089508,
                0.00005837673762773167,
                0.00668377644200156,
                -0.001734266031916811,
                -0.009054461300842117,
                -0.0011140381604992362,
                0.009712550971202685,
                0.0009516605645189382,
                -0.07439594126188179,
                -0.007530284833520534,
                0.06632492136580509,
                0.005134336413680715,
                -0.008431456092160752,
                -0.0014708953794361165,
                -0.010754087542545228,
                -0.00024065218285174516,
                0.0034767073864987027,
                0.00023739896766475892,
                -0.017319690618178927,
                -0.0018210878930047926,
                0.07742731318086692,
                0.010816362166733824,
                -0.07114967144962858,
                -0.01044898571717825,
                -0.001235297327229257,
                -0.0012954318888750418,
                -0.0022411044212423364,
                -0.00008486353212911135,
                0.009661022183802052,
                0.00043468320948647157,
                0.00338136324066184,
                0.00005579202631153333,
                -0.04030444864058561,
                -0.006295250564349015,
                -0.1715094743716213,
                -0.008875642655969358,
                0.001064127976379375,
                0.0003443520365432333,
                0.18896078673265893,
                0.00824377009154062,
                0.0996434529649611,
                0.00604196989557729,
                0.033131829138787115,
                -0.0019142775689795844
            ]
        },
        {
            'energy': -0.5290684493497801,
            'occupancy': 2,
            'alpha': [
                0.0003002755891302046,
                0.05172540205305469,
                -0.14866058716795055,
                -0.11833834607443684,
                0.004021425728370228,
                -0.023161584354607904,
                -0.0026499948663731765,
                -0.09341726554332525,
                0.005826911435636797,
                0.008929164770042318,
                -0.006447084779865109,
                0.0010164679127695312,
                0.029514436955098554,
                -0.10311519137026477,
                -0.03144072820819884,
                -0.030541305290767824,
                0.0009247921976300479,
                0.010954463034357037,
                0.001589575705965165,
                -0.0023609370926518393,
                -0.0005224848226612047,
                -0.025328506073364412,
                -0.005609246687250738,
                -0.006086049775897622,
                -0.001370811869130959,
                0.07024971215657624,
                -0.01832389703337753,
                0.008200372562306178,
                -0.015813099188521838,
                0.020792111777956396,
                0.05537382190891778,
                0.019911975862010746,
                0.01630315717515025,
                -0.06910656667222254,
                0.07448182920507047,
                0.026042725061305158,
                0.03261851853546186,
                0.024120676907163317,
                -0.16335909159832543,
                -0.08453139435777147,
                0.006961458729226051,
                0.009088074626297472,
                0.025038898441571956,
                0.01409783734915159,
                -0.0022977765928662566,
                0.003413892645175161,
                0.16060022622470307,
                0.1255394423510491,
                0.009848120545739901,
                -0.04701898931214993,
                0.15315646407242908,
                0.07003446394409155,
                0.02981098260164216,
                0.020617312791375603,
                0.02208095725158406,
                0.0015475496216021045,
                0.004400933007597208,
                -0.011908326819660165,
                0.008001582981077419,
                -0.01026835044406606,
                0.030844411257962164,
                0.008114122924587226,
                -0.032701626196656,
                0.014749126605308822,
                0.013522448159343942,
                -0.05749040905321923,
                -0.02016750016454542,
                0.016312776622709125,
                -0.006211011707971235,
                -0.038201570447383204,
                0.059080396376254646,
                0.044252958726125634,
                0.00962211988216549,
                -0.08275901880957555,
                -0.003301435240343473,
                -0.1969413263297337,
                -0.01808504135281538,
                0.16861590567671353,
                -0.016666050810718442,
                0.15244441454250884,
                0.0035913865444455262,
                -0.0004832381788600964,
                -0.028914438183249246,
                -0.016538015558941337,
                0.0066176386224005455,
                -0.01150703964479172,
                0.005673399724687185,
                -0.0001315390667837344,
                0.015914190523005634,
                -0.0230235996078385,
                -0.05347336274668002,
                -0.04370129137801692,
                0.0016537528494084772,
                0.019041300407919112,
                0.0025583848632326016,
                0.003668346942942049,
                0.01240112453053066,
                0.04337396694237175,
                -0.07392032951878265,
                0.016677365101721603,
                -0.00421696354458863,
                -0.022472038566191566,
                -0.04935711049326311,
                -0.03686183064995165,
                -0.0021482723286898515,
                -0.01594563440612263,
                0.0005629244591949196,
                0.022334715516829463,
                0.003222534649132813,
                0.000039878995645995303,
                0.03201590805128255,
                -0.0075809961852060905,
                -0.02659351153088909,
                -0.060459653278641494,
                -0.0015881088362224571,
                -0.043986571692545696,
                0.025226029266978853,
                0.026808181449580512,
                -0.028591025792857796,
                0.0266862099407734,
                -0.0009040271868672654,
                0.00034673176023034084,
                0.030717947207405494,
                -0.004690590331963445,
                0.001377659537830804,
                -0.015142344528298844,
                -0.0012146547241268081,
                0.023072448123379476,
                -0.0021274794617368057,
                -0.009937182002311551,
                0.026823641852087427,
                0.023820622087895288,
                0.07664446363664139,
                0.0274063345531464,
                -0.16034958664507237,
                -0.12008228834499109,
                -0.0008700109650157278,
                -0.006034333123739059,
                -0.0018639329349007415,
                0.00036554721785678174,
                -0.0024865848217724,
                0.003314907618630493,
                -0.02828009208588066,
                -0.012657288805967797,
                -0.0794807434362596,
                -0.07797794731332625,
                0.04989895699197905,
                0.0008959716472998439,
                0.010701128531165264,
                -0.06909340605641712,
                0.21457995399555832,
                0.11078893509634861,
                0.006470682700781599,
                -0.10821846977275462,
                0.18601392211216755,
                0.08682619928207816,
                0.05456959729448034,
                -0.0870517840056529,
                0.00803556960184235,
                -0.026497507561920274,
                -0.07134910724019362,
                0.008532992302066559,
                -0.12696047248616704,
                -0.08861151741205948,
                -0.07481182371731306,
                -0.0031700474294954774,
                -0.0775070698436542,
                -0.005776669663780193,
                0.025041598005920002,
                0.0012650992080954523,
                -0.06432742749878956,
                -0.004182403829823141,
                -0.09453458078866683,
                -0.007233376188080764,
                0.02127499072986922,
                0.0047739267711803006,
                -0.04997985439017274,
                -0.004793261692109291,
                0.02310222171836037,
                0.00153640490387022,
                -0.03499134930802673,
                -0.001347338547375283,
                0.13567929296637932,
                0.0071929133573571695,
                0.06467611689369043,
                0.00382746135313595,
                -0.10975485383414815,
                -0.005342596699809013,
                0.11170269265804836,
                0.005032184663559763,
                -0.1205550967865032,
                -0.00465038454473997,
                -0.003079604004612874,
                0.002206295477524755,
                0.01710104019462505,
                0.0014637450679350263,
                -0.009431608495571392,
                -0.0011535510246368584,
                0.02841199128836705,
                0.0040409627122814165,
                -0.032265428604842494,
                -0.0016402042751660075,
                0.004894318074679921,
                0.0003761628149097532,
                0.001411469253575677,
                0.00005655127073687992,
                -0.006438729818132198,
                -0.00003159121830288799,
                -0.03636729217091217,
                -0.0036393626529874247,
                -0.038759810126792714,
                -0.004775251844217767,
                0.017783167262987554,
                0.0039039284411693125,
                -0.003700635665146355,
                -0.00016411023760535455,
                0.00775764042780062,
                0.00030112728175821365,
                0.00024312995837906892,
                0.000007613539898626973,
                0.0032023645278889063,
                0.00003933782708614313,
                0.014943070885119866,
                -0.005541409036934895,
                -0.16796086365180296,
                -0.007693482279528618,
                -0.0010098522386180588,
                -0.0005069686368884337,
                0.17475297129391823,
                0.007529172100800688,
                0.03839053689752715,
                0.00337070855948521,
                0.01870145968826342,
                -0.0016393594791751852
            ]
        },
        {
            'energy': -0.5226580963400268,
            'occupancy': 2,
            'alpha': [
                0.00046543409387696455,
                0.021312316128796128,
                0.10539966994971532,
                -0.026834641248171736,
                -0.07822793272868514,
                0.1448575030670378,
                -0.03699951405892062,
                -0.11940509554227087,
                -0.094329893518593,
                -0.24314624056971135,
                0.09263426656521075,
                0.0016185548311002014,
                0.06039547993635319,
                -0.08428491278504915,
                0.13261034128449767,
                0.02489599254118685,
                0.008966630132689586,
                -0.009117272101554273,
                0.013085453227035668,
                0.028295494930894755,
                0.010858378219247658,
                0.06336646451151824,
                0.018510482997003475,
                0.048728317993621206,
                0.057947910269238026,
                -0.020338690634915946,
                0.07120458089182588,
                0.018784859339320135,
                0.018637341023898368,
                -0.1453462923568254,
                0.039408404171395246,
                0.03310932895779833,
                0.012452363714411128,
                0.02685537675564462,
                0.024177122615560032,
                -0.0032740856825085574,
                -0.03250284623442502,
                0.02572756758773084,
                -0.014975202523291964,
                0.07477146207102155,
                -0.004125581030628529,
                0.006065984708243289,
                0.00998469787599397,
                0.031237726871940208,
                -0.005362734434642831,
                0.009858242208892127,
                -0.04999943345469856,
                -0.028364528768458526,
                0.07555683910336587,
                0.14429504202555243,
                0.12501656348195592,
                -0.06602076230642029,
                0.02176113487368276,
                -0.0975849791112098,
                0.0010147080908441887,
                -0.04123646396378068,
                -0.0017805288453289236,
                -0.012071228510156634,
                -0.036188498793092105,
                0.0721389065488155,
                0.028186115725842346,
                -0.18370119011599345,
                -0.03414814816630859,
                0.056541983566957346,
                -0.0671948201151496,
                0.0688891886834937,
                0.024806798095818164,
                -0.13961756431937958,
                -0.01321690296142254,
                -0.055724644944071144,
                -0.07454861461669894,
                0.02201073043713395,
                0.003894619026290674,
                0.08498386148514298,
                0.04091664422498109,
                -0.003484318491627379,
                0.00020916115138207398,
                -0.0620753180195056,
                0.009304799729758766,
                -0.04805138567561627,
                -0.03374949571813396,
                0.06380713451670374,
                0.03494395572830707,
                -0.05761580562422546,
                0.016834229929878368,
                0.1601436499409294,
                -0.04184183901025306,
                -0.05000546810313059,
                0.033391659810762746,
                0.10089681990837934,
                -0.036783985691700195,
                -0.012970492607589023,
                0.02538082962156557,
                -0.11814363892547912,
                0.034762517879427406,
                0.10586676989942732,
                0.004267085837476957,
                -0.062391733244827496,
                -0.03171344343649019,
                0.048728427507005484,
                -0.001341381003139498,
                -0.01066090503716012,
                -0.03215485086657555,
                0.0886536528379217,
                -0.012556323369695227,
                0.0003397624667907111,
                0.061720130357737275,
                0.044420072670678615,
                -0.0011217805121770908,
                0.028194316379443796,
                -0.03186763089932118,
                -0.010526702054827223,
                0.005006358732836469,
                -0.03422695960517066,
                -0.03099982398004647,
                0.041067258015896654,
                -0.003086837325213839,
                -0.07668171276449828,
                -0.022535272533204937,
                -0.007157521613977624,
                0.002806862138177411,
                0.025011004928208597,
                -0.02368862553002523,
                -0.018310243824840165,
                0.01186108682800067,
                -0.00006164095107549328,
                0.06852303673491256,
                0.03599241303014838,
                -0.006758573253283498,
                -0.009653782053778044,
                -0.0292022251116527,
                0.013689976344927269,
                -0.043135115663023464,
                0.15035734346628718,
                -0.08579437933682794,
                0.0373031911798444,
                0.003784065033881544,
                0.008718277415275125,
                0.010053598838209159,
                -0.01239817714039901,
                0.030143408799151825,
                0.04942830241621533,
                0.03259277427691606,
                -0.06498186759662303,
                -0.023899608530216405,
                -0.12506621277429894,
                0.12396346922683295,
                0.08036581651608418,
                0.04135880729253532,
                0.022783523048947065,
                0.015254625197638752,
                0.05290925805699659,
                -0.019306921631220043,
                0.03171250298955959,
                0.041190866903650716,
                0.0590646500961829,
                0.020234878506398286,
                -0.10388752443796874,
                0.14053465169620005,
                0.09114170744407113,
                0.04739171134171779,
                0.13680308625309875,
                -0.0875287325155148,
                0.00036470907484013583,
                0.0392205331865262,
                0.004028246908519145,
                -0.07858471012643482,
                -0.002401100053006558,
                -0.019115143692837105,
                0.0007907602422954299,
                -0.01741250699536498,
                0.0045125883753725825,
                -0.08172048578840803,
                -0.002429819357659083,
                -0.03767520436174555,
                -0.002817159777561807,
                0.0638722005724354,
                0.0011456292952638893,
                0.04104596297290817,
                -0.0015545770480788347,
                0.012611598049648183,
                0.0028724312382217387,
                0.033151728225369353,
                0.0021000881469801914,
                -0.08042944079101337,
                -0.0036720833526240784,
                0.036452622764468125,
                0.0015582440190143705,
                -0.03801658401913441,
                -0.002851748568561005,
                0.04394975762868005,
                -0.0014655305983721763,
                -0.1180490691264317,
                -0.004124487735802572,
                -0.09486283578519876,
                -0.0012119827318904724,
                -0.02441746704873107,
                -0.0007032512834572791,
                -0.0098282703269879,
                0.0006910638469759148,
                -0.0074238980228766415,
                -0.0014906073965374193,
                0.07518335799807599,
                0.017771856041315388,
                0.049609677100191193,
                0.0021257872974636016,
                0.027922659361624125,
                0.002712738352965581,
                -0.11395597997106366,
                -0.014234328505090005,
                0.002726510114018816,
                0.0006979054777355658,
                -0.031009831267006325,
                -0.0025046292017736347,
                0.07918259830740998,
                0.029019290147127952,
                -0.029454444803435093,
                -0.00126858621893073,
                -0.0565802142567701,
                -0.002447518917364786,
                -0.05911627284888969,
                -0.001842858595409299,
                0.11293397363353025,
                -0.0010909365182984845,
                0.016413551401275813,
                0.004333524656218586,
                -0.004784158635383319,
                0.0011438304020081143,
                -0.005610299911255028,
                -0.0005939955759313619,
                -0.13355817887538945,
                -0.006490268286509413,
                -0.05796952379602901,
                -0.0010476874332883566
            ]
        },
        {
            'energy': -0.5223382839956926,
            'occupancy': 2,
            'alpha': [
                0.00013767503704798604,
                -0.010348327737527302,
                -0.01946918884768974,
                -0.0016605825502533187,
                -0.00640632022953364,
                0.008243672697048036,
                0.008267212734773731,
                -0.0010210605098988548,
                -0.00813937779949822,
                -0.021601041986082474,
                0.00251500662439001,
                0.0024647076326120105,
                -0.0031168489063229205,
                0.003807300353209603,
                -0.00502468978491236,
                -0.008900854030707792,
                0.000932518543429489,
                -0.0007809860368926746,
                0.0014142230282006047,
                0.0016884868443977422,
                0.0006209371555882122,
                0.0061467001300288746,
                0.0005463279965035665,
                0.0031245290391942893,
                0.0024297754176113035,
                0.00614680865966937,
                -0.0001280710823990282,
                0.0006601008312205326,
                -0.0028512257720218447,
                -0.008052620956706835,
                -0.01657836468984842,
                0.01637397948747808,
                0.01872084016086306,
                -0.012605074743014364,
                -0.00408143535348675,
                0.0016354938238170443,
                -0.004920926582126252,
                0.0002900223820611756,
                -0.0012140960834417177,
                0.017200249859448437,
                -0.004549615667588387,
                0.01044456289515062,
                -0.00660317097055523,
                -0.0015441966394081693,
                -0.006381573366744537,
                -0.0012822489164940076,
                0.008768919808588887,
                0.006720013196959439,
                0.004462969246590892,
                0.005494917578779465,
                0.009900141677183177,
                -0.0261603426223477,
                -0.0017647537848420943,
                0.006951044289039438,
                0.004264963860423136,
                -0.02486611832046044,
                0.005132558824705279,
                0.0005654422471547363,
                -0.033770975390838155,
                0.014279968783875958,
                0.0037950242042028514,
                -0.01337402496754639,
                -0.004725261401492795,
                0.006501327843485552,
                -0.004529126619126361,
                0.007585944835121454,
                0.0044745968594352755,
                -0.0091253589036217,
                -0.0036922128066598746,
                0.005805278606488067,
                0.01884640156933723,
                -0.00594777305370347,
                -0.0005799920765891221,
                0.005070903295709263,
                0.02256816565482383,
                -0.03438793989080133,
                -0.0019472495144321794,
                0.008445719229194857,
                0.0016729920752559906,
                -0.0002865297714724957,
                0.0037213872493498377,
                -0.004752452812518498,
                0.09806629707648953,
                0.028951577077258955,
                0.0010608443026919282,
                0.013865000922813836,
                -0.005221182601320314,
                -0.004153875396809682,
                -0.0014660044869969945,
                -0.003375809863802319,
                0.004509906822694329,
                -0.0010265455650278782,
                0.0025971287904555107,
                -0.010821154207893645,
                0.003568673683007509,
                0.008862144410403372,
                -0.0013139959651629403,
                0.02148616308411485,
                0.00019761184131236937,
                0.004649664261534745,
                0.0017188752922718583,
                0.006746805156522825,
                0.010362514016432522,
                -0.015036774167667116,
                0.0726013765499173,
                -0.01644311210815842,
                -0.3140011196078123,
                0.025340017733254405,
                -0.10606781969129073,
                0.1462338979092636,
                -0.0987329207629697,
                -0.2761808347953268,
                0.0011230826649186135,
                -0.008708281642533787,
                0.013224538845500471,
                -0.013754496042970684,
                -0.0008208081497806059,
                0.011117911237350939,
                0.00930143386977731,
                -0.0017378244382887176,
                0.09843870853471265,
                0.14384424396037998,
                -0.10880387463363776,
                -0.27423470113440745,
                -0.07578003393154302,
                -0.02532689265849347,
                -0.30670990997343756,
                0.03976952465497109,
                -0.0016127813223289393,
                0.004466545529415404,
                0.003774094233355034,
                -0.0013507813642757215,
                -0.00004693542063941832,
                -0.005019038408714422,
                -0.01158093339005404,
                0.024150357598143372,
                -0.00006203873416295953,
                0.0008185550045405968,
                0.00016065152768622313,
                -0.0007379434672690242,
                0.002028349297363205,
                0.00020568630281220728,
                0.104685035662723,
                0.010814818443770694,
                0.000052244726175893814,
                -0.0027350370656907303,
                -0.011294011821905085,
                0.011773748631727216,
                -0.002492130368915928,
                -0.0016075759269596373,
                -0.01320380024607301,
                0.013437379611599272,
                0.0018380565921441714,
                -0.00005092466461672207,
                -0.010175747725214856,
                0.007779565845501282,
                0.000007015395392681214,
                -0.0027080855487958,
                -0.009299190173809674,
                0.009213578703309548,
                0.00015823626301609766,
                -0.0005415722244918354,
                -0.002664602579127081,
                0.011568861007129987,
                0.012828649066252673,
                0.0004855056315467139,
                -0.011149898830649232,
                -0.0010792859374158842,
                -0.0031349383020747414,
                -0.0005874717459331452,
                0.015379380544137946,
                0.002123739088313549,
                -0.018074785258636365,
                -0.0017003640187179812,
                -0.00012709110566234074,
                0.00005184386630603555,
                0.007841842453376885,
                0.0006613051215969517,
                0.0011661285790385337,
                -0.00017138262129631795,
                -0.013018017409673208,
                -0.0010218058186159111,
                0.03630650744284742,
                0.0020565988347738965,
                -0.01267342731692775,
                -0.000176395405668551,
                0.0018129059238652344,
                -0.00013989253596891077,
                0.0011525561269938253,
                0.00010411811812426999,
                -0.008020356347008564,
                -0.00022550700888498377,
                -0.010164531957995812,
                -0.00026163033731946793,
                -0.008332508520432463,
                -0.00012293124802063767,
                -0.0014452175351867581,
                0.000008815679780474,
                -0.00404521263961626,
                -0.001676835748656446,
                -0.00019538548299785884,
                0.0016056286785108695,
                0.006615364951361876,
                0.0012016920114710243,
                -0.23344698664172917,
                -0.008439205183009878,
                0.2360815206777369,
                0.009293541502950203,
                0.0023192384406258222,
                -0.0016707365502417787,
                -0.012452628635473367,
                -0.0008268336370914646,
                0.005161372184116028,
                0.0004801631209981845,
                0.0068019342207329865,
                0.0025596301427661177,
                -0.2344494372890301,
                -0.00815330718383994,
                0.22866831930408496,
                0.009313817987328157,
                -0.04331021517723291,
                -0.002023602779554355,
                -0.002429156966298774,
                0.00018184528216491164,
                0.0026057452299009655,
                -0.000008508550034985386,
                -0.0006483362564887699,
                -0.000013696670668120012,
                -0.0029047249107169715,
                -0.0000730062365391634,
                0.0023427095227030958,
                0.00015173851126772055,
                -0.0030819345441493525,
                -0.00014029751446585775
            ]
        },
        {
            'energy': -0.5202289473079922,
            'occupancy': 2,
            'alpha': [
                -0.00038207708595283045,
                0.044485670896636936,
                0.02551399159799883,
                -0.06539065956581577,
                0.02720843062325571,
                -0.014958615150908409,
                -0.06570315661335525,
                0.03498666122289161,
                0.04510690331111338,
                0.12719886094586963,
                -0.0035020115834339632,
                -0.014028944224775726,
                0.07044462738820524,
                -0.07807171584597726,
                0.11668289414083295,
                0.13379146678215195,
                -0.005887000757039421,
                0.0002394935987933033,
                -0.008920999396834259,
                -0.008074912232912797,
                -0.003042257550539623,
                -0.027043355778784788,
                0.0002738142502769456,
                -0.014565259182262964,
                -0.0008783266721658614,
                -0.08896023953657803,
                -0.055038511796225285,
                0.0005446488925375626,
                0.011379564381855539,
                -0.1258184228973701,
                0.12422280209127157,
                -0.09005632554627022,
                -0.09058861044154685,
                0.10229534654864056,
                0.008487497928760548,
                -0.030854242398045708,
                0.0009528804244385812,
                0.009009162432752538,
                0.10714218290733117,
                -0.09693390246771619,
                0.06410365255205473,
                -0.018947442133856036,
                -0.004462135586107343,
                -0.028461030354366344,
                0.016434799436935803,
                0.01700119485708978,
                -0.0022210853817061487,
                0.0011645384456425514,
                -0.021592193483271675,
                0.00905944777402953,
                -0.12307796497132067,
                0.1430838383631805,
                0.020116636107380036,
                -0.12343103885225763,
                -0.09058168567778474,
                0.033273414669946204,
                -0.056520465912028126,
                0.03461855106833604,
                0.03310843672181299,
                -0.06700138574266373,
                -0.04042179095045036,
                0.06069966968562381,
                0.04136224299738616,
                -0.05315781553547176,
                0.017504869031814054,
                -0.00883013946447416,
                -0.015864283215917395,
                0.04627930663838228,
                0.002292270147199956,
                -0.05874771467492029,
                -0.027166078680044736,
                0.05413643151371018,
                0.0029090414245400023,
                -0.11846414217177191,
                -0.10140701227381649,
                0.11787749555210035,
                0.002570875694462685,
                -0.002465077088702856,
                -0.0006175524355160491,
                0.02227004664133008,
                0.021345454396562633,
                -0.06529491155455287,
                -0.05677430418943283,
                0.09984953691615037,
                -0.006917661709855591,
                -0.08060641215385894,
                0.0290480442127963,
                0.02390510207015375,
                0.04469309068639797,
                0.11899668667260618,
                -0.05627818100452389,
                0.03538352790224765,
                -0.017044492271834476,
                0.057836705168304116,
                -0.022416616665517267,
                -0.05325683929979547,
                -0.005537828483844863,
                -0.016724296526269698,
                -0.03461546224948297,
                0.06239321820705615,
                0.0019257841376186348,
                -0.05098092390930482,
                -0.051237463436908076,
                0.03443457858882704,
                0.02800274684443278,
                0.009333416123972305,
                -0.09472495709529616,
                -0.036916220208774365,
                0.006521768965965337,
                -0.010700843743036727,
                0.032577925789308536,
                0.008950565143341898,
                0.0038835014035899975,
                -0.056027987066556546,
                -0.019013133385518074,
                0.012101842964480275,
                0.0008988606423259331,
                -0.036557509018338756,
                -0.02452083394025887,
                0.04275580211942196,
                -0.008490285640025165,
                -0.006572407261800778,
                0.028957981945850458,
                0.0034958732016112932,
                -0.02948652161925925,
                0.013268543972714467,
                -0.09559681359433761,
                -0.040433873216337894,
                -0.009433186540690187,
                -0.013849099316897092,
                -0.014711190133033679,
                0.023455205461802475,
                -0.032914646781632334,
                0.18477275163661347,
                0.039886959984810615,
                -0.10144866245420808,
                0.0009099520989302393,
                -0.002315063696651823,
                0.00027692904371016394,
                0.0037621765647728005,
                -0.032543865219608795,
                -0.05876564830813893,
                -0.04825343408157828,
                0.1007820384355438,
                -0.02198223641621057,
                -0.08162131983498125,
                0.16845021742224306,
                -0.02135318806731909,
                0.0328382265874438,
                0.058905885911016025,
                0.06753533389450285,
                -0.06572166214892365,
                -0.011440954816096735,
                0.04824094348298281,
                0.07495369713770492,
                -0.02106901016945699,
                0.019720287292434375,
                -0.07221295677006782,
                0.17509371745170882,
                0.0036604168736931804,
                0.04460445975223646,
                0.14819662795993532,
                -0.027870171856284712,
                -0.057360366380702014,
                -0.05660402266677489,
                -0.0040907425440502715,
                0.1334992452970619,
                0.010931820825961598,
                0.028927884161894124,
                0.0033316310251228706,
                -0.08856368201669736,
                -0.010946888220873877,
                0.16457084770147515,
                0.01675701895704326,
                -0.026160877654262886,
                -0.0041790656956669624,
                -0.01596024003599922,
                -0.001583596190791232,
                -0.025137700407675403,
                -0.0006974364165440363,
                0.009026184897666139,
                0.002576742297117226,
                -0.14806896549239695,
                -0.008317161275050144,
                0.1350539065871363,
                0.007223855290188237,
                -0.020284212993850362,
                -0.0004396779734354071,
                0.016130576034040736,
                0.0002134518610610381,
                0.00857838066451925,
                -0.0019152400745645214,
                0.06695355218329854,
                0.0012939079842804806,
                0.04361523964683968,
                0.00009532249974724488,
                0.010334159481377886,
                0.00030866482850703197,
                -0.017298060548182927,
                -0.00419721622181898,
                -0.009170963014390254,
                0.00010118340177950293,
                -0.03424948341711296,
                -0.004966198460732195,
                -0.06905723796614027,
                -0.0034832854551221024,
                -0.019680878306687535,
                0.00012609279341393455,
                -0.12057050668602524,
                -0.019594761091887264,
                -0.01469114430191947,
                -0.000687959176831632,
                0.010739471016011807,
                0.0012022357271101384,
                -0.03802901853224877,
                -0.01466837373670148,
                0.011706234014998861,
                0.0002975648091158483,
                0.0723117050092831,
                0.0029020980420191955,
                0.09258758821951575,
                0.0036745581643164945,
                0.0942974289438885,
                -0.0012529416089941874,
                0.028893469369108523,
                0.004676365275734085,
                0.00430002659238863,
                0.0003716641127015919,
                -0.007224776267623637,
                -0.0005494744368816915,
                -0.11803839603541587,
                -0.0059822987034861275,
                -0.062001881299439524,
                -0.001501892481469972
            ]
        },
        {
            'energy': -0.5193350535432052,
            'occupancy': 2,
            'alpha': [
                0.0007784120797648867,
                -0.19380254878177516,
                -0.16907714369781904,
                0.09296316649695405,
                0.028410951535154605,
                -0.04852454702135597,
                0.0044645460102725925,
                0.0541572672020508,
                0.048448578443576924,
                0.13204564246032363,
                -0.044434608022585864,
                0.002144518293574663,
                0.057260159628922384,
                -0.03233416395189356,
                0.13818027107102726,
                0.05128496914758867,
                -0.005407024307407071,
                0.00038498584436283986,
                -0.007823405815056082,
                -0.013306129888892959,
                -0.004842178819790426,
                -0.026602776120167863,
                -0.007695750688400877,
                -0.02224195064501821,
                -0.018626422369686,
                -0.07388871119510332,
                -0.07083580920405985,
                -0.04012539619215762,
                0.01332526487850271,
                -0.11059439668915706,
                0.0070662108583629795,
                0.07052544401343287,
                0.047299917615204044,
                0.04012962420105953,
                -0.006663570719599069,
                -0.02823654010772483,
                -0.010037456821072526,
                0.03003326498792204,
                0.05639689775510145,
                -0.06564683856840625,
                0.04789778868075839,
                0.027885607316533674,
                -0.017935164041898065,
                -0.009323258479502486,
                -0.03486645532781512,
                0.013227601311524211,
                -0.0064714639254319665,
                0.025578328493792022,
                -0.033459300597500734,
                -0.06403199279036845,
                -0.05710366267062385,
                0.02993772964556296,
                -0.027606361844651404,
                -0.08603737581923195,
                -0.0019945501127512995,
                -0.08726427752778881,
                0.020028842902129786,
                0.026526573835408216,
                -0.07746242222683036,
                0.11065343174052196,
                -0.023914821068309226,
                0.08198732240512115,
                0.02025413770839158,
                -0.0398249707781204,
                0.03191438001047152,
                -0.013122594466908152,
                -0.007171208540071114,
                0.07664727414339902,
                -0.01914651201739248,
                0.13016171342887967,
                0.15425375265982882,
                -0.14587386635570548,
                -0.002921782012078845,
                -0.03784364866574484,
                0.07831923986263299,
                -0.09326736123225293,
                -0.010193703888135239,
                -0.041536997065482965,
                0.0011674411766646007,
                -0.02084633694406155,
                -0.027291931922732493,
                0.09386295507026492,
                0.0824644949164847,
                -0.07516982161851438,
                -0.0055551932102864176,
                -0.08958175417766595,
                0.022361459296431522,
                0.0256786648032883,
                0.03417271069382244,
                0.09539677142319791,
                -0.027016878789845825,
                -0.003913123120092099,
                -0.015204254557615784,
                0.06012024968914923,
                -0.020732416009953014,
                -0.05742455863767322,
                -0.005318994850483584,
                0.21319625405323753,
                0.1083478776473313,
                -0.08908353719409759,
                0.00040008009717040625,
                0.18121765392130648,
                0.10217556783285937,
                -0.11654323523613423,
                -0.017296133369815957,
                0.018839697991369544,
                0.09233263200144315,
                0.03128542629810665,
                -0.01131861258521307,
                0.03504428005567246,
                -0.06617308710104157,
                -0.005194222422054249,
                0.0022836450459468257,
                0.06701763227275763,
                0.11396911243896546,
                -0.16064945801962507,
                0.00894208462768656,
                0.09501815160834433,
                0.10135660734507833,
                -0.13413155858274942,
                0.0095589704519754,
                0.026656577218492714,
                -0.06071666020049593,
                -0.0056519378615318945,
                0.024723269803371608,
                0.013083020107416162,
                0.08618038308325823,
                0.029363138711081753,
                -0.022873739002845516,
                0.07738661050229656,
                0.06170099294214523,
                -0.03834607751349906,
                -0.015839829736685615,
                0.0708982752777701,
                -0.07688465734082439,
                0.09077756751235266,
                -0.0013997247733511632,
                -0.002291311233495803,
                -0.0039109488417141515,
                0.0057896527293915465,
                0.038553614282327814,
                0.06781523332772663,
                0.07504770747654145,
                -0.08133265730132715,
                -0.011021234820550811,
                -0.08366663896052909,
                0.022260211430571206,
                0.0700219182187043,
                0.015493732953460331,
                0.027323440597447658,
                -0.03449933258486516,
                0.07283618125371533,
                -0.00014607530552662823,
                0.026413155030485476,
                -0.0057999822644550425,
                0.06283749226674186,
                0.007514128599561097,
                -0.07651827167868945,
                0.03757285865969012,
                0.07031599834513458,
                0.025516038431959015,
                0.07265600225188344,
                -0.06325219433590965,
                0.03394309561908085,
                -0.004080189753859248,
                -0.007337641193267369,
                0.06741136775936236,
                0.0044286324414856346,
                -0.0050090378336215885,
                -0.0028735169245299327,
                0.006412203893845654,
                -0.0010128953971723876,
                0.04946766329294776,
                -0.00024999660135457567,
                0.0013210040114181084,
                -0.00044919675436867274,
                -0.015288880972916348,
                0.0007046108723325712,
                -0.03856620425123006,
                -0.0008488117845484214,
                -0.07684616214133055,
                -0.00443961345616708,
                0.10036649604168557,
                0.006407986225172783,
                0.0043185707737910355,
                0.0022669712667597783,
                0.012389556835730068,
                -0.0003797340506162042,
                -0.02470383414761662,
                -0.002059678730416802,
                0.030454394020614856,
                -0.002142412268799007,
                0.06935811275014465,
                0.0033189917302344366,
                0.04765702982951601,
                0.0003038910510849632,
                0.013389960209689512,
                0.0006271310954657417,
                -0.03131158875601977,
                -0.0030094383918783446,
                -0.03216485475431919,
                -0.0016624058405274756,
                -0.030631008739397572,
                -0.006595238176726939,
                0.06963591842342455,
                0.004063665082550532,
                0.03391170729900786,
                0.0034291640735643674,
                -0.0828069740149873,
                -0.010925595665754623,
                -0.03293502920384872,
                -0.0014475826794473098,
                -0.018246231536100575,
                0.0003373762828611021,
                -0.040729331138089554,
                -0.01606487561338102,
                -0.032367573493064315,
                -0.0014167132003394018,
                -0.06586835277315083,
                -0.0026860898226251997,
                -0.09361836771164057,
                -0.0036267484765497683,
                0.04076638360481987,
                -0.0018104347024633517,
                0.03121092061077613,
                0.0037473758296983173,
                0.0031966145612511866,
                -0.000372176599972358,
                -0.014065549211585407,
                -0.0005954005933072913,
                -0.05620049123710965,
                -0.003045282515680511,
                -0.03938477450389049,
                -0.0010869546641796102
            ]
        },
        {
            'energy': -0.5174153811132982,
            'occupancy': 2,
            'alpha': [
                -0.000057198082989491246,
                -0.013173444848826302,
                0.005496061658322212,
                0.017928763796789628,
                0.008254730734734973,
                -0.014143202422271017,
                -0.006449724249250882,
                -0.002282318275283385,
                0.0145446161931475,
                0.0384468839851207,
                -0.012610433659244939,
                0.0004896265817215658,
                -0.10429014044857425,
                0.0806347289963622,
                -0.09119138324661262,
                -0.07070347742121905,
                -0.0017451033855950847,
                -0.00008267272354774338,
                -0.0025331657395979215,
                -0.0034092555084264,
                -0.0011704546370232944,
                -0.00883625457899032,
                -0.0015467084450780377,
                -0.005837952590289895,
                0.00025848531766863416,
                -0.020306445731674526,
                0.004572186627031101,
                0.005541305571053717,
                -0.0005293160027685815,
                0.053932718690030995,
                -0.12465386637432738,
                -0.04325428367160781,
                -0.00704039746271001,
                0.006481358143192552,
                0.017820673387016237,
                0.012870898258156332,
                0.005161506005651705,
                0.012701558599581596,
                -0.008636944101219996,
                -0.028194792002099435,
                0.002673950611672057,
                -0.002792076848894086,
                0.012790214530979992,
                0.0027074906968637302,
                0.0010919081006615218,
                -0.001371679032571745,
                -0.016130403438943758,
                -0.015624527311009677,
                -0.003205863908095323,
                -0.022491694853310342,
                0.004799129148020741,
                0.02817703863956351,
                -0.00802647841018744,
                -0.021672904493990026,
                0.039078610485604064,
                0.024649941941400202,
                -0.0012384594435674674,
                -0.004588460812435746,
                0.012264725337869204,
                0.01566222245478703,
                -0.004844502199549821,
                0.02208026950264348,
                0.004764909753368419,
                -0.008515649515395332,
                0.009818776540055887,
                -0.006896227283227782,
                -0.005177281138840263,
                0.02111785947234526,
                0.0010969563323283392,
                0.011201802034546453,
                0.0012867837903840105,
                -0.010945330946282429,
                0.0005695379152622926,
                0.02738704293837563,
                -0.001907796400726873,
                0.019848470709837144,
                0.0006149639512289156,
                -0.034710169179772335,
                -0.013786975640108485,
                -0.015846512548299562,
                0.00010796870523808511,
                0.004155924378777596,
                -0.007737486385952036,
                -0.011606236941372756,
                -0.0003655705364515312,
                -0.028113391498139628,
                0.007859669357172173,
                0.007889225776655408,
                -0.017556907903657038,
                -0.004002876429578077,
                0.08930473285964151,
                0.04681680229074832,
                -0.005075447617911031,
                0.019317172759853948,
                -0.006741032045808074,
                -0.017058530101956442,
                0.0009326215095722294,
                0.0027214868549131446,
                0.013170962544621547,
                -0.010599696275673733,
                -0.00083354419633237,
                0.010761764632615394,
                0.009322960470339254,
                -0.002422558987316369,
                -0.004334343765834678,
                -0.008832398261825292,
                -0.003664572431995037,
                0.013422771060737871,
                0.00008101601427189021,
                0.004753978663741445,
                0.010843701565499124,
                -0.012185318185672662,
                0.0014724212671552253,
                0.012432614821640195,
                0.007300400936704075,
                -0.0004063545675150866,
                -0.0015334610500899347,
                0.002677230923706743,
                0.009627199812696831,
                -0.00771124144654909,
                0.003432142512404497,
                0.003008672461291339,
                0.011346611072901584,
                -0.00784140028637982,
                0.00010363288288306729,
                -0.0095752226329577,
                -0.0007965042495077577,
                0.015470668628047236,
                0.0002326448552049602,
                0.005263367560702507,
                -0.0012142141596400101,
                -0.0066723357572332324,
                -0.04267565319861181,
                -0.02927886571804575,
                0.047211220157154385,
                0.06066780074939242,
                -0.00015131689296328494,
                -0.000683556435145541,
                -0.0006793070280470795,
                0.001469862556842896,
                0.0005839704457427933,
                0.005481447759039543,
                -0.008633458470803518,
                -0.013446114896681365,
                0.01563312633492305,
                0.16144631461305184,
                0.21809873954918862,
                0.21250545709820756,
                0.08446287054042088,
                -0.31293491334168383,
                -0.02507097459219427,
                -0.07305604413678138,
                -0.11846487379705957,
                -0.2592753098419729,
                0.025852109237860802,
                -0.033622456620515974,
                0.04965423296099713,
                0.2025180308183409,
                0.2032759402246906,
                0.21110240389932536,
                0.03557528785273107,
                -0.081127544289932,
                0.0077824204456899745,
                0.0017563221610483637,
                -0.014249065461058825,
                -0.0015243340963855094,
                0.00428585198486221,
                0.0005665300500652771,
                -0.0017852201172456285,
                -0.00030453346762197983,
                -0.011604554118532838,
                -0.0019222377204543752,
                0.006259148235715076,
                0.00036758341973414734,
                0.002198325514957697,
                0.00042031205191732536,
                -0.007880037846970724,
                -0.00044095082236353264,
                -0.008276850551562362,
                -0.0002765090029574237,
                0.015944126755229528,
                0.0006420616148472522,
                -0.01235448784056715,
                -0.0009885138575235928,
                -0.021523304618808883,
                -0.0018742082436934945,
                0.0028034378471791083,
                0.00026774636439375575,
                -0.023328855913309923,
                -0.001091563643003067,
                0.030260034300437104,
                0.003631123992298801,
                0.020376455057003293,
                0.0014076034880634014,
                0.01502711936968517,
                0.000185148469812341,
                0.0031832682661207864,
                0.00003393085732277192,
                -0.00009239042836497926,
                -0.00008153941625295202,
                0.000769353626130971,
                0.0001123127897746032,
                -0.008200209981422598,
                -0.0016918713744927712,
                -0.003784156524717815,
                -0.00017089640799313084,
                0.006185143000230173,
                -0.00033389378817162365,
                0.09419795167030189,
                0.019022240295407486,
                0.0019230253532544104,
                0.00040415802634226317,
                -0.00016003611797211486,
                -0.00021192594752407557,
                -0.012259645537497834,
                -0.004511734801753322,
                -0.0004695339319408733,
                0.00014316590574290928,
                -0.000275146656864639,
                -0.0000758436153183877,
                -0.006121922713940517,
                -0.0003086927355902897,
                0.23482966500683422,
                0.016031334310429964,
                -0.16246927528974608,
                -0.009271128819197115,
                0.0011238429666087595,
                -0.00003756018016614904,
                0.13515637611536158,
                0.0021719831031112922,
                -0.2412761675396807,
                -0.012024426774865316,
                0.0786712197999719,
                0.005242386543217567
            ]
        },
        {
            'energy': -0.5156457195054598,
            'occupancy': 2,
            'alpha': [
                -0.0016967606993718637,
                0.09629556922267322,
                0.07777898573159708,
                -0.02451949971688267,
                0.014923953556532915,
                -0.013054736688841157,
                -0.03973007102871897,
                -0.007540030728242381,
                0.03664316516817419,
                0.09954294416665183,
                -0.022344005543712086,
                -0.0004707376988008622,
                0.016947577182139708,
                0.05182765090926449,
                0.20684370447303352,
                -0.22477289696546598,
                -0.0048882497995268535,
                -0.0017869120810856084,
                -0.007159586215214125,
                -0.006890174263310419,
                -0.002472985690500482,
                -0.020826840274500023,
                -0.00009873668975261734,
                -0.012084873135061755,
                0.015494304227621929,
                -0.061230566113430994,
                -0.006021220307930849,
                0.05702226406247488,
                0.00924071077881656,
                -0.049108954569261336,
                -0.06918747087961516,
                0.16500889810961913,
                -0.07762331348693349,
                0.04044901303995642,
                0.05937571907683176,
                0.020608109628526813,
                0.00949410654800597,
                0.033523723812527745,
                0.016118029801076558,
                -0.08547536939434049,
                -0.012056931000062042,
                -0.009405958590939584,
                0.049838210231989206,
                -0.040016359701847866,
                0.025989795153713465,
                -0.0156930048663999,
                -0.0011166117222039102,
                -0.006747079191476532,
                0.0011888537448360426,
                -0.026162756652606187,
                -0.009842713597629659,
                0.0981677344414261,
                -0.019489620392254322,
                -0.03836259425578768,
                -0.018882536696700997,
                0.0707305280866235,
                0.003922857713297827,
                -0.05301379281409102,
                0.02943167248295185,
                -0.03765914344786146,
                -0.020880006467928335,
                0.039907250870545724,
                0.01944020729952452,
                -0.027850134157673144,
                0.01933327319418581,
                -0.0008123711740735117,
                -0.012357549181280991,
                0.04529669713981996,
                0.01892810183249167,
                -0.029864696109452287,
                -0.062280636826283806,
                0.07025292548209096,
                0.014552692828480145,
                0.07804523249045024,
                0.004462453958629065,
                0.00025557845278085416,
                -0.001909963313487899,
                -0.10889296560572528,
                -0.12360140917123635,
                0.13261028395026167,
                0.0030555264592965685,
                -0.08190265038974406,
                -0.019109951309096453,
                -0.027528809159007253,
                -0.0008310507513359414,
                -0.07362101897629081,
                0.02192333772619986,
                0.02085803924904153,
                0.0068567799284008826,
                0.04123824477269812,
                0.045379641162496084,
                -0.11033955017510551,
                -0.015239108132146089,
                0.04954662768312059,
                -0.018957133257974632,
                -0.045384126091605304,
                0.0027512320628991357,
                -0.10659063937308992,
                -0.030608973963250036,
                0.022487113375951096,
                0.0009997405070581182,
                -0.0977253230317656,
                -0.043556180926713886,
                0.031904114940192574,
                0.0007030005914812225,
                -0.05778164419538245,
                -0.016438779693620887,
                -0.02221028572006535,
                0.004193856798874306,
                -0.05609975150093626,
                0.019931232078976287,
                -0.03058839995887742,
                -0.0016384569975823563,
                -0.011605050677639108,
                -0.052806099556923065,
                0.08822344181277332,
                -0.008519247212352346,
                -0.029046365821050284,
                -0.04310608307908448,
                0.08426946018115532,
                -0.0011573846872122266,
                -0.043688205357358484,
                0.020321863711897523,
                -0.024518117339545883,
                -0.00493815468103441,
                -0.04965704395419059,
                -0.010995686370264258,
                -0.018928780806133687,
                0.015561042770897609,
                -0.03976080830788117,
                -0.03358098709654393,
                0.013811623605476523,
                0.0032610236818826463,
                -0.06165367517104893,
                -0.18182954227146292,
                0.2447345132565949,
                0.00033961568205554646,
                -0.0008881804661006959,
                -0.00041350144462612843,
                0.0032144103738187555,
                -0.006200472727336096,
                -0.04812052449040892,
                -0.01967749514123564,
                -0.012570617860681355,
                -0.003222704526585759,
                -0.07068318379111771,
                -0.12873642271504335,
                0.15390418693557378,
                -0.001421901450468562,
                -0.023124962342375648,
                -0.12294700648463837,
                0.21164762609785887,
                0.00853237592548388,
                -0.014024231693248894,
                -0.08622483361005287,
                0.1515296827412322,
                -0.005031376778036543,
                -0.0691032087326793,
                -0.11605234489107878,
                0.14187562287107336,
                -0.0023240178269039397,
                -0.02689984704540068,
                -0.10300243006514169,
                0.13121290831811036,
                -0.054131472366234154,
                -0.002882884736618869,
                0.048143476961838835,
                0.004894595625005104,
                0.0050105417203525566,
                0.0021058051578500617,
                -0.05615329505853864,
                -0.006990956322665262,
                0.05447449496459385,
                0.007127431427673243,
                -0.01197329177886455,
                -0.0010534970648931616,
                -0.007061591457208641,
                -0.0006613841460495654,
                -0.02662781634817611,
                -0.0016708871748157175,
                0.041144818697518445,
                0.005650164161201288,
                0.012233270337485946,
                0.002647243841676698,
                -0.06632611993364809,
                -0.0017235766077297197,
                -0.16414295697423442,
                -0.009474059937400433,
                0.006893483947678218,
                -0.0015983581193675955,
                0.14072571260704153,
                -0.0016580400901918886,
                0.05693463629571928,
                0.0033742545859620082,
                0.03759809888991184,
                0.00023288186965853415,
                0.008244331961821297,
                0.00007873799743986317,
                0.021339961372281106,
                0.0005344914916118408,
                0.02348705375972444,
                0.001503265137401339,
                -0.01739561032376403,
                -0.002629669765286638,
                -0.01361678966552071,
                -0.0005003683010620784,
                -0.0034841714053432107,
                -0.0008299672339547377,
                -0.021595300950190136,
                -0.0019560637061530866,
                0.02465239485313297,
                0.0014849150066652444,
                0.027146967404485127,
                0.0008190032283363737,
                -0.031191504364457435,
                -0.01125376706090397,
                0.005740182734046281,
                0.00032919875800960035,
                0.00814860663703171,
                0.00027108260410219656,
                0.015498458563780298,
                0.0006692979143194562,
                -0.01787148322048049,
                -0.0020279433858107518,
                0.014497356631622235,
                0.0012332889429227656,
                0.0034153939730855606,
                0.00021598184164327985,
                -0.008227888797714395,
                -0.00004747208239149149,
                0.015096996909808397,
                0.000647437579650262,
                -0.003916559025351354,
                -0.000277835698628854
            ]
        },
        {
            'energy': -0.512922524653118,
            'occupancy': 2,
            'alpha': [
                -0.0006386303125505498,
                0.12798233448912028,
                0.11495161199185068,
                -0.08776869219555333,
                0.01983004985021417,
                -0.048296566038203086,
                0.06823891785025607,
                0.10864740755725046,
                0.07963644658160393,
                0.2069311770054475,
                -0.1361516023332811,
                0.04598184401694935,
                0.013922128041585576,
                -0.02783623372008442,
                -0.0142016202726298,
                0.09491986113802071,
                -0.010312321480257588,
                -0.005371345608738983,
                -0.014344618535999302,
                -0.018930660430044488,
                -0.007143055534166327,
                -0.038069219189087046,
                -0.0059860981215778975,
                -0.03226040165281719,
                0.024920928855642725,
                -0.10432564232392043,
                -0.04825524954076722,
                0.08699972067728402,
                0.006717575177837352,
                0.0010562230559615408,
                0.039294426099363414,
                -0.03292696689344713,
                0.07486740073537165,
                0.00734368688881728,
                0.014786483001912947,
                0.01601357673428994,
                -0.003950369074250494,
                0.15615403905518874,
                -0.011584673909350697,
                0.09671147732114894,
                -0.04852999460311699,
                0.053708414293953115,
                0.05821445175831616,
                -0.035794294622835295,
                -0.00139887377561614,
                -0.01655135616518266,
                -0.019097300741388587,
                0.008567392967039789,
                -0.003655987354258155,
                -0.14934154926339732,
                0.020829028709246807,
                -0.10482853198508421,
                -0.04813150465829716,
                -0.03771833515411072,
                0.035009054341433955,
                -0.047320047868627924,
                -0.02235391476252676,
                -0.09042692622693126,
                -0.08110050007826398,
                0.11623515055488959,
                -0.029226538735259083,
                0.0770870801359439,
                0.010116741094085292,
                -0.047809885746587066,
                0.06146612024462928,
                0.05493083415683983,
                0.0005322051750978008,
                0.15080693357898628,
                -0.0011797185409251566,
                -0.06641593302712659,
                -0.0841568870442691,
                0.0792619369295379,
                -0.005395163064363956,
                0.06312620989554023,
                0.06318721508392838,
                -0.05439136793470905,
                0.003386871888550785,
                -0.01676875053108099,
                -0.004891137779285549,
                -0.024985843134812974,
                0.0017504633579075823,
                0.035398086303252335,
                0.09092658161399109,
                -0.14531496986511425,
                0.00119894473160882,
                -0.17190720783257057,
                0.036399593683825976,
                0.045763985359808856,
                0.0060819894205148125,
                0.010195225223724087,
                -0.03190017180528516,
                0.031185099253048094,
                -0.03214561606905051,
                0.10316975142928392,
                -0.03961844397986423,
                -0.10614523345623816,
                0.004259394880942195,
                -0.13173128854428987,
                -0.08079954898263277,
                0.074909625293883,
                -0.004147170304396613,
                -0.09987212180618707,
                -0.07336925619511044,
                0.08471704476406951,
                -0.042282220146219573,
                -0.03591572850019196,
                0.08299856863726024,
                0.0105287115591763,
                -0.03656569042774949,
                0.0036821754020542013,
                -0.042241063934450096,
                -0.07267649276360472,
                -0.0029988812645213776,
                -0.07350515928620627,
                -0.08678158590427647,
                0.10701051947566553,
                -0.0027897598018493943,
                -0.08521563086302261,
                -0.07513146218147759,
                0.08570123209780849,
                0.03478058922407663,
                -0.01671617404087674,
                -0.06048547508787055,
                -0.024918423867173124,
                0.037475165211213475,
                -0.052826115149573194,
                0.05196168578037884,
                0.04876836876388191,
                0.0072071645825481645,
                -0.060063335224353975,
                -0.05186093388035036,
                0.0440501191576045,
                -0.00018963807441191942,
                0.031626738584471493,
                0.05380742174484942,
                -0.08582873016224499,
                -0.0020369216103146262,
                -0.00038913872386624665,
                -0.005726169173262023,
                0.008941072318041131,
                0.032643334640784324,
                0.05225180270432656,
                0.09054516576704019,
                -0.14732513622823382,
                -0.000973299327272827,
                0.00831608388552435,
                0.04552520616451338,
                -0.06150292917953444,
                0.003335842595961324,
                0.025269282667497363,
                0.04915036647368132,
                -0.06925905353604013,
                -0.0002686661999526257,
                0.01838747780765695,
                0.040570979923017565,
                -0.04938270279526528,
                -0.0000711328176438226,
                0.008270227867347487,
                0.04608747174057293,
                -0.05779357812257606,
                0.0021467019511471853,
                0.021047459497726722,
                0.02857592501733604,
                -0.05580516266768757,
                0.1395603804690942,
                0.018555693635301105,
                -0.0797178732679581,
                -0.013621317941114075,
                -0.03321069594240195,
                -0.004131185920412917,
                0.1457401030077915,
                0.0149870220771057,
                -0.10014757432535697,
                -0.01006891826138052,
                -0.01353666607460915,
                -0.002271718542794202,
                0.04045385118739372,
                0.009167261689341996,
                -0.11753862668782833,
                -0.007631280161779951,
                -0.011271934637141878,
                -0.003168699685860127,
                0.07667954316137578,
                0.004635530165347909,
                -0.0712950267716534,
                -0.006275533496833901,
                0.019515227990613816,
                0.0010328727618214044,
                -0.02138125726386391,
                -0.0008709920182416406,
                0.0072714139972159565,
                0.0025166059462524933,
                0.12836659751918075,
                0.010390918496442374,
                0.08059972886989866,
                0.00004547331101656235,
                0.02448408009399947,
                0.0011983392446678512,
                0.014067075147856897,
                0.001998673099114632,
                0.007906244390110942,
                -0.0013481158404948083,
                -0.02025213276086178,
                -0.005381319280361116,
                0.0526248842060873,
                0.0011632280938752367,
                0.05122662877902816,
                0.002244790702027873,
                -0.013491366652469373,
                -0.00012708463760687408,
                0.0137702630126654,
                0.001267496629888505,
                0.0033108262898856183,
                -0.0003820225167145541,
                -0.0687942271659095,
                -0.022548729246827375,
                -0.017704867144975527,
                0.00025951033686116506,
                -0.031194697912341272,
                -0.0005457946568514719,
                -0.14553757231987988,
                -0.007520260627349986,
                0.0023430731299888797,
                -0.0005981488748108117,
                0.0041503632292805214,
                0.0007422238893532569,
                0.006353060936372304,
                -0.00021257762503570086,
                -0.000035691475762633324,
                -0.0000013896393436700154,
                -0.005609281979642561,
                -0.0004025281738793377,
                -0.0014318702773147922,
                -0.000003158975393045908
            ]
        },
        {
            'energy': -0.5100496001174772,
            'occupancy': 2,
            'alpha': [
                -0.0003049213726565703,
                0.06459288771361052,
                -0.002936475846384159,
                -0.06805779470782339,
                -0.006132623935709293,
                0.013986250654364313,
                0.018934725272742193,
                0.047055834650748696,
                -0.006990729762154368,
                -0.015944364553055892,
                0.006417853348938313,
                0.0022533502594068214,
                -0.00808970050821583,
                0.02237110813427131,
                -0.005595562014896129,
                -0.07607932051572926,
                0.001047704956851872,
                0.0002806645757510433,
                0.0015500084539661597,
                0.0005061779842082604,
                0.0001268964897690051,
                0.006211582348042103,
                -0.0014896202837157084,
                0.0013215513460162935,
                0.009401178158757231,
                0.01149168747077862,
                -0.10491105912118993,
                -0.0042676114407068,
                -0.023019179070333264,
                -0.022901697994664558,
                -0.052207840464219925,
                0.011323655140602396,
                0.009335598812966079,
                -0.0043877232545519234,
                -0.09565131236888831,
                -0.012028266191668038,
                -0.019771478452114917,
                0.005404229656842684,
                0.06452760910465989,
                0.0545788448020729,
                -0.026299191999558894,
                0.05089273297915244,
                -0.02994397427050583,
                -0.05386247871720059,
                -0.012738890631018818,
                0.04595575580731864,
                0.0862631250849621,
                0.01137953823364954,
                -0.01134880603208483,
                0.027991061073533215,
                -0.054685229933058375,
                -0.05435121393262021,
                0.005309816832814981,
                0.02239223754887444,
                -0.025055887317272964,
                -0.08498394656219173,
                -0.008085743095124626,
                -0.030452997544545175,
                -0.08879921169162583,
                0.0300418289644198,
                -0.003930678946037036,
                -0.012114101450975742,
                -0.0015708301504568567,
                -0.008771955205875105,
                -0.005403724115693523,
                0.014341583968636863,
                0.01109846510421941,
                -0.0038271326019167743,
                -0.0019306000945061568,
                -0.02845552068681359,
                -0.007721880836203409,
                0.04300991304962709,
                -0.007006580144073821,
                -0.273379594478214,
                -0.15958027567054858,
                0.10640599246225532,
                -0.01727224924991051,
                0.2769758227833715,
                0.18372401663290464,
                -0.12838030952080093,
                0.008309551843473127,
                0.022988245924280247,
                0.06858743349955203,
                -0.05838949170353604,
                -0.0019151857744213506,
                0.015191658182265156,
                -0.006380141788589916,
                -0.004690046730872306,
                -0.006152223573661745,
                0.005017157865734979,
                0.05375126244202135,
                -0.0362074601042639,
                0.0038735109904698716,
                -0.01189335887244126,
                0.004309557956670328,
                0.008593614930716002,
                -0.007957013571838792,
                -0.022991296555938057,
                -0.04444064071546123,
                0.04430083314771203,
                0.00549695075129017,
                -0.056872341743357924,
                -0.03636025766953412,
                0.010210347171557247,
                -0.015271995216402533,
                0.0064173120695874015,
                0.060491117137084355,
                -0.022202265973766525,
                -0.027349188902657452,
                -0.00169803601257169,
                -0.041275783803805734,
                -0.01330835317305987,
                -0.003550553519345819,
                -0.04877586819178616,
                -0.040625137925530366,
                0.01720906997896314,
                0.0017690008026521884,
                -0.015158290274683383,
                -0.04691578482420303,
                0.04687369927086671,
                0.014232717767038194,
                -0.013192731068362402,
                -0.06088221220349769,
                0.010028719933061835,
                0.025285316178631608,
                -0.007416172371056323,
                0.026822032722296912,
                0.002502600768015692,
                0.0010362145557724707,
                -0.03104413936821975,
                -0.0025078932422883784,
                0.03286061761908312,
                0.000013449116158825544,
                -0.024227195211981637,
                -0.06997523229192605,
                0.13562715781570378,
                -0.00043732966675010177,
                0.0003581213997015687,
                -0.0005156025687886423,
                -0.0003274288538595277,
                0.01628139309246907,
                0.02647197371087058,
                0.07371369954787582,
                -0.05927364405210898,
                -0.001418702807466961,
                -0.013057190693156596,
                -0.05349070034523248,
                0.10960782358367001,
                -0.006517025770348234,
                -0.03941512521175921,
                -0.08448575961196697,
                0.10373910402574822,
                0.00033347952377635944,
                -0.03505210293809952,
                -0.07087244434722062,
                0.07917416558425684,
                0.00653952306533981,
                -0.018470473645590825,
                -0.05901988025453826,
                0.10623599385298027,
                0.003247508848930594,
                -0.014572319164947868,
                -0.04684184700207289,
                0.10152629183859473,
                0.048018243112647345,
                0.005321825012624861,
                0.03286544725882058,
                -0.000955788463625859,
                0.06014019688988341,
                0.004152714331719763,
                0.03364419664775919,
                0.0038737642739329263,
                0.016604957560641682,
                0.0010060499459474967,
                -0.014502614768453099,
                -0.002879574731171997,
                0.015356275883522034,
                0.002128910628701796,
                -0.00831781349467035,
                -0.00034545752539009,
                -0.028038306210441035,
                -0.004065848176550035,
                -0.18558403257477674,
                -0.015463511649653547,
                0.2660775393120459,
                0.0223640749232689,
                0.18811834168389768,
                0.012212017270774513,
                0.049513893754762894,
                0.0029758464020285982,
                -0.2728960709829373,
                -0.018321095438286923,
                -0.007292455324978543,
                -0.0015000994468803957,
                -0.008467002103936399,
                -0.0002873790180522777,
                -0.0005721236628762799,
                0.00033378299733750194,
                -0.0030445310315649777,
                -0.001717710707625159,
                0.006369721075337001,
                0.0005553091636341949,
                0.00408056188112978,
                0.0009069457847541225,
                0.04174683108490703,
                0.0027305793706773485,
                0.013010357579369117,
                -0.0004598174921395487,
                0.010051360919187083,
                -0.006054759303188234,
                0.001241287921993321,
                -0.0005276922398421031,
                0.004488507180402444,
                0.0007660816655008161,
                0.005928728670443406,
                0.0024741032291081076,
                -0.004618613270523919,
                0.00007588371860278476,
                -0.011460278218329694,
                0.0003381737788522151,
                -0.078697422616339,
                -0.004375032265177108,
                0.011684622311255125,
                0.0016198504663361279,
                -0.00263744815042209,
                -0.0009618042340998734,
                -0.0008340424090675608,
                -0.00015305424952421546,
                0.0012622569173305997,
                0.00003229522068814582,
                -0.00574776038623032,
                -0.000029658542845954443,
                -0.01366212761470122,
                -0.0007254527446448022
            ]
        },
        {
            'energy': -0.5078784481525161,
            'occupancy': 2,
            'alpha': [
                0.007944070779419096,
                -0.04535857710727961,
                0.025664480744743208,
                -0.11777257253301307,
                -0.0018768581905120177,
                0.024456931858771003,
                -0.049854256408523596,
                -0.0162466062219953,
                -0.016426809645517442,
                -0.036068943443047036,
                0.05738154656451273,
                -0.022093970907668105,
                -0.027586143327084103,
                -0.009327589157272085,
                -0.09742971843782468,
                -0.018329931859988827,
                0.00214879036591508,
                0.0008748584511843381,
                0.0028709446396504995,
                0.003458924501754098,
                0.00143874364951657,
                0.009130395304325087,
                -0.000020295441913201658,
                0.0065141697149504706,
                -0.025944418595252237,
                0.036332441788108086,
                -0.04614919008474465,
                -0.0007432331025085513,
                -0.012517280960695631,
                0.024606450407848014,
                -0.031767371898470814,
                -0.017815590407381527,
                0.07634756887026539,
                -0.04616643002971436,
                -0.037102921981802,
                -0.05276364237731699,
                -0.0008156529692186933,
                -0.07232359944995598,
                0.09732650888408584,
                -0.09609605119374612,
                0.12116371066528063,
                0.12994624808669883,
                -0.0326085801339361,
                0.04509885849686572,
                -0.03686178769472914,
                0.023379240650512202,
                -0.04897040174478771,
                0.03512388168853558,
                -0.0033018785413622413,
                0.0839219254190388,
                -0.07961288790400484,
                0.08781668979155505,
                -0.0034918886950885174,
                0.04374389084749227,
                0.003344827222982059,
                -0.0516850716497976,
                -0.02308187580857666,
                -0.05037363464040648,
                -0.05181192129128032,
                0.005881658609745442,
                -0.007260348641800155,
                -0.015871472066801888,
                0.011231347580023933,
                -0.003906542108965759,
                -0.0214781588215689,
                -0.010939533820215019,
                0.0033838075609996855,
                -0.04576057417149968,
                -0.019461606397800535,
                -0.13722449122613045,
                0.026916670984561367,
                -0.07990089177966006,
                -0.008152927940559258,
                0.0018090999847011852,
                0.07977875579448206,
                -0.08963163118781392,
                -0.008849257900646338,
                -0.05461799978970615,
                0.041826951745352545,
                -0.03610030951131054,
                0.003935533706413515,
                -0.2056720436521712,
                0.04021644733252101,
                -0.14382191003164588,
                -0.0041257958047301755,
                0.03896315350465665,
                -0.009463055552416536,
                -0.008457961395541789,
                -0.022111173910618172,
                -0.05175628050265341,
                0.008127833672433348,
                0.011948495500856889,
                0.007019692196407208,
                -0.02204443790590029,
                0.008219876498697766,
                0.023356111713619374,
                -0.017730030657606987,
                0.11117601996061828,
                -0.06115561366703117,
                0.12052536616772541,
                -0.005316861537271099,
                0.06758115567799995,
                -0.04246881509470587,
                0.1202510296530226,
                -0.006766358079109106,
                -0.2006561821413509,
                0.0382307840531234,
                -0.11734025148500232,
                -0.013608117362037318,
                -0.2120002700390842,
                -0.015598759925681327,
                -0.12012452953662502,
                0.023885492694692857,
                -0.1483873966247284,
                0.020543664855269025,
                -0.0832880157965142,
                0.02418635308267671,
                -0.12586927828821715,
                -0.014578583351999982,
                -0.07188893443066008,
                0.006970807474857437,
                -0.20342047427641444,
                -0.02645884579434491,
                -0.09780433151955258,
                0.012433603913233001,
                -0.20766980798647655,
                0.018051532109870254,
                -0.10351227026438808,
                -0.04591070764683662,
                0.007298522812142661,
                -0.01233238751948785,
                0.04541476236676737,
                0.0005343958842518918,
                -0.01191204297582401,
                0.017619652736764725,
                -0.023952253706215346,
                0.0004850077095179426,
                0.00021160925296136534,
                0.0014464070654707248,
                -0.0018824888521822413,
                0.009261690764693718,
                -0.18285902751120012,
                0.04285378956123445,
                -0.13340925616762403,
                0.0018171996275372535,
                0.01975736126180589,
                -0.0005878715486004577,
                -0.02186957918278501,
                -0.008820514871029967,
                -0.00262207945432777,
                0.012330822440335655,
                -0.024049711475002955,
                0.0024243660248794282,
                0.00207638871530447,
                -0.0029071252933928773,
                -0.027217191748389696,
                -0.0012053749513432751,
                0.02001368243233801,
                -0.006623639142780255,
                -0.02792942866927446,
                -0.0050292682425046465,
                -0.009523872873027545,
                0.0284862801047023,
                -0.010214514314207841,
                -0.09967829821697839,
                -0.009932547651850782,
                0.13560339383966838,
                0.016690716988429027,
                -0.007668226405439058,
                -0.004050742515177882,
                -0.09333073330136774,
                -0.010558877279642106,
                0.1230264679549968,
                0.016287665623864318,
                -0.014878334673965257,
                -0.002196563000118948,
                -0.006916486108137072,
                -0.0030363823829357944,
                0.029535739239486193,
                0.0021666325099747867,
                -0.06384744890036298,
                -0.004970042856994711,
                0.10583197837396935,
                0.00762653184442375,
                -0.02757560439541173,
                -0.002561901837451585,
                0.04494971567076524,
                0.0013014310966309017,
                -0.01716801385402813,
                -0.0013621214195256458,
                0.022330315855008026,
                0.003771145817734014,
                -0.021095103393798244,
                -0.003473023404864416,
                -0.01714051016917303,
                -0.00013473747846255962,
                -0.005490513751182217,
                -0.00029237931434859436,
                -0.07769320346123282,
                -0.007482258697396562,
                -0.06743622224294164,
                -0.0026694866065134406,
                -0.0011211651129073954,
                0.0009510526924126163,
                0.022931964819640636,
                0.0019086811813609403,
                0.008423235492422994,
                0.00016704875720861655,
                0.03166218467889004,
                0.00407758579540768,
                -0.07920532219927623,
                -0.004109563076652649,
                -0.07132006614941079,
                -0.002834918192313597,
                0.014444665938185091,
                0.004240668397872022,
                -0.0029777147522218406,
                -0.000029112154344407103,
                -0.00536770960677156,
                0.00017590925056774537,
                -0.04053190033676551,
                -0.0023179626495486807,
                -0.006368401509926783,
                0.0007744482242641907,
                -0.008170427886387515,
                -0.0012236782184017795,
                -0.0013027109373303758,
                0.000028273959495908123,
                -0.005271706967555954,
                -0.0002071295915990592,
                0.01833249447247764,
                0.0012986241880113116,
                0.001573462245589865,
                -0.00008044131995805367
            ]
        },
        {
            'energy': -0.5062902548202375,
            'occupancy': 2,
            'alpha': [
                -0.0019847745567237686,
                0.07866272792625337,
                -0.10365667504507284,
                -0.08081702267370716,
                -0.002968570342015489,
                -0.0021816952124014354,
                0.08433980562683561,
                0.13218102731519676,
                -0.03252354897403759,
                -0.08082379847419822,
                0.029956025982696633,
                0.0008628261010367927,
                -0.021399471819846583,
                0.06792389922785587,
                0.0020219555714189835,
                -0.01948022859883693,
                0.00507800169916171,
                0.004087025802886468,
                0.00748478942138728,
                0.00003608043523337693,
                0.0009033436900871965,
                0.023209459724840422,
                -0.016372385491571315,
                0.003145007227574935,
                -0.01127486420385934,
                0.03464667182364973,
                -0.24127938307590754,
                -0.14379884481526503,
                -0.014351418711684405,
                -0.0181950529224791,
                -0.03834094196479975,
                -0.02830060823676949,
                -0.0055960451545093775,
                0.09894275431363063,
                -0.12590902343089214,
                -0.12813712527814958,
                -0.030740855133152663,
                0.00753496335069582,
                0.13997870386758077,
                0.18651279597137901,
                -0.014513806413064014,
                0.0028033708789273128,
                -0.1716702714606768,
                -0.1200100969411675,
                0.003937907597174854,
                0.016476083066826682,
                -0.0013259819704088847,
                0.04848581993926267,
                -0.052269451043907414,
                0.0445094609195159,
                -0.14216932076012742,
                -0.17763539787783847,
                -0.01783468802778372,
                0.007242367542271429,
                -0.16440001090237136,
                -0.04124803057263581,
                0.010864302758356443,
                0.055238030086193345,
                -0.10286567613328527,
                -0.1064508964081903,
                0.0026340675515397396,
                -0.005545368317471759,
                -0.0160676670318859,
                -0.017442044460064872,
                -0.013230508505055425,
                -0.0033159520219553902,
                0.03490204953229503,
                -0.014037485785402249,
                0.0006269678955992066,
                -0.0007031359540247948,
                0.021032643735695942,
                0.06747871829390274,
                -0.005553510132503008,
                -0.05709820962520833,
                0.1569227303522756,
                -0.1460075883307702,
                0.001413975863885798,
                -0.04228702165852001,
                -0.04037531121205001,
                0.2338364814067173,
                -0.008427552898505124,
                -0.01769163303020653,
                0.017610606501853806,
                0.06219332766560612,
                -0.006278720153359696,
                0.07724542718927625,
                -0.029122292237648496,
                -0.02363820191757489,
                0.01118057415562748,
                0.01548451574079633,
                0.03152055776590057,
                0.021874397285753043,
                0.02329588421724044,
                -0.053948473025031675,
                0.021266984390008587,
                0.048916148381870445,
                -0.019836084649976136,
                0.005826417322161714,
                -0.038694783908274445,
                0.03503240317001422,
                0.0221518576055887,
                -0.08348550866730375,
                -0.017427035597399592,
                -0.0638850366715639,
                0.032784917987068486,
                0.04100608398358395,
                0.0102913799231301,
                -0.04966684542546426,
                -0.008579176529194944,
                -0.024262137594382522,
                -0.041436937534868316,
                0.07398672846283967,
                -0.012461482941594331,
                -0.03213342237395561,
                -0.054350612064110564,
                -0.02215136001679555,
                0.0012984480427183551,
                0.06079255452692232,
                -0.06681388657942158,
                0.05883168890036077,
                -0.0206657455384283,
                -0.00006514993474289967,
                -0.047141389516684104,
                0.026172026454084663,
                -0.001916178412049989,
                0.055065760296540256,
                -0.004804545830970244,
                -0.07647631414891572,
                0.008694357261491285,
                -0.03636275799710543,
                0.04708626362750512,
                0.04328900411627375,
                -0.0022862640056997203,
                0.019231523932137905,
                0.021864265608193167,
                0.018726198774427875,
                -0.0019177834735975476,
                -0.0003049190085971394,
                -0.0021505902017803897,
                -0.0018715949889164377,
                -0.006612583162490684,
                -0.026260567594819217,
                0.03258547243921187,
                0.08060957361599956,
                0.007357483737654611,
                0.017344968230985754,
                0.03110720317846048,
                0.023535403120885923,
                0.00021115271896332124,
                -0.019462804730091182,
                -0.017578848524601388,
                -0.01799491297875903,
                -0.008339208415762935,
                -0.01786760727789951,
                -0.006080592632984502,
                -0.01033969479293419,
                0.009088580646859192,
                0.016126111396939282,
                0.026929216706237283,
                0.020999938143150782,
                0.009987213691963464,
                0.010204591186577584,
                0.008763365362108526,
                0.007248219781525212,
                0.17705220518885423,
                0.01829335884432305,
                0.032059614514820325,
                -0.0015417300123854664,
                0.0015934377716865478,
                0.00032605143963146963,
                0.12687220875613123,
                0.010453065763891541,
                0.008262170589914903,
                -0.004523770248125808,
                -0.010780974964007836,
                -0.0058973957507706095,
                0.010588104666402495,
                0.0036216942586375653,
                0.0035366050997231954,
                0.0018442308997198345,
                -0.14436041445635123,
                -0.016197146377699333,
                0.17223183825052402,
                0.014751904334107451,
                0.0033438519506509834,
                -0.00018529145940079754,
                -0.19212604707357356,
                -0.015212070873995336,
                0.13168414099580417,
                0.010079948385012617,
                0.06457653302273715,
                0.0033803833820379697,
                -0.051435773048355615,
                -0.00617589705102234,
                -0.037671767864408325,
                -0.00026865532362937424,
                -0.006919549099571449,
                0.0009899142529525777,
                -0.006632637820643495,
                -0.004090605388952736,
                0.03497060886277401,
                0.0035702925488993184,
                0.001786017416203208,
                -0.001073406703692323,
                0.018599045842078537,
                0.0031986662568451807,
                -0.04602780173278678,
                -0.005011102360908267,
                0.0076552370567466626,
                0.0007352927862946986,
                0.021857777237480246,
                -0.0003386091509851857,
                0.012863604337709052,
                0.001690121183701513,
                0.02847194793424329,
                0.010599109540956043,
                -0.010801825937418482,
                -0.001828007000804944,
                0.008910283767736065,
                0.0009536628585854016,
                0.044227687036544214,
                0.0027293934008751227,
                0.027416893123092007,
                0.004217277464265362,
                -0.002846891135771287,
                -0.0000952331597371973,
                -0.004130822665198573,
                -0.0012009364317659484,
                0.004696277060178822,
                -0.00029241530525373497,
                -0.02792200499474604,
                -0.001575734370461204,
                -0.007846781891940819,
                -0.0002086300494214093
            ]
        },
        {
            'energy': -0.5032040128223189,
            'occupancy': 2,
            'alpha': [
                -0.0035098111062283983,
                0.07647305098046646,
                0.015707872518812904,
                -0.028550322617002865,
                0.0027331299482782354,
                0.016234408670832163,
                -0.07756132982883937,
                -0.049378906809541906,
                -0.01735398252454401,
                -0.03219877899397581,
                0.09088217606283766,
                -0.03856072273294452,
                -0.025653559474721765,
                -0.03955547912741388,
                -0.13730233560585633,
                0.016530561336346384,
                0.00218373723589613,
                0.0009555502327588048,
                0.0029762255359154118,
                0.0004357296602764529,
                0.0013192713929905616,
                0.010914888857393975,
                -0.009916222731880819,
                0.0035484897397974847,
                0.028389811552173554,
                0.041855805531694414,
                -0.11631566742194359,
                0.11790247306633098,
                -0.013530768910929861,
                0.021563134980455655,
                -0.038343535418309725,
                -0.00624514280985804,
                -0.025801371436752735,
                -0.1265785454610159,
                -0.08731210885346187,
                0.0263545402958809,
                0.006306467993353054,
                -0.1063797934633893,
                0.14370811057411226,
                -0.21659736343976285,
                -0.057293662352800756,
                0.08559324044205043,
                0.061694303993170344,
                -0.13351486400546206,
                -0.005282110382608905,
                -0.04699866151725244,
                0.005855968872528237,
                -0.04421007948168237,
                -0.009053120495865786,
                0.08771708928539859,
                -0.09075922357963838,
                0.15766174279292547,
                0.014561688972434086,
                0.0569823736868799,
                0.031679733626875865,
                -0.08015586301703906,
                -0.027030578286078858,
                -0.08040727915253817,
                -0.09366420166421188,
                0.06318682881608191,
                -0.011191857053886443,
                0.007699960607683773,
                0.019469745068215367,
                -0.004423449319481918,
                -0.026827850044711953,
                -0.03624347387023812,
                0.005807161353934982,
                -0.05830280766515149,
                0.006194538564567644,
                0.03825806546274548,
                -0.004292303332358278,
                0.06154500750770877,
                0.010052396496239032,
                0.06964919310586307,
                0.018781760531373762,
                0.011634636728502974,
                0.01071440316332978,
                -0.01126098932913715,
                -0.04568757809151123,
                0.10587108163142009,
                0.03791957138456984,
                0.1602683195204786,
                0.08375075283172534,
                -0.04337101861074458,
                -0.0065720337473237625,
                0.044355407431666063,
                -0.016179188169711943,
                -0.007411605628860421,
                -0.02590509522981641,
                -0.061772265854687994,
                -0.006756295991260147,
                0.02511878136554534,
                0.010524113396584895,
                -0.023693502813388605,
                0.008488843889584841,
                0.02981837872975823,
                -0.006351756869975063,
                -0.045449320964544425,
                -0.0036780151558571455,
                0.005253821546762013,
                0.011349177768906257,
                -0.08859100521352709,
                -0.03599023089425037,
                -0.01734115334059485,
                -0.03866590753834107,
                0.13505432797461456,
                0.08598522267602406,
                0.038892420952060996,
                -0.04462830313198191,
                0.15524460094918313,
                -0.027218477817997796,
                0.006593188554977607,
                -0.006746036249973019,
                -0.0032454560525267693,
                -0.038972660250267854,
                0.048423897813869084,
                -0.011167161516652199,
                0.0035342617157527486,
                -0.04275492970136318,
                0.08765594996077264,
                0.03365676605372976,
                0.1130302345876503,
                -0.08451793050317971,
                0.09484967615425277,
                0.04038676919627814,
                0.10422390587686182,
                0.010367063762250491,
                0.12624505785823395,
                0.011070448958232832,
                -0.035644939573102545,
                -0.01496480496406519,
                0.02258607057956104,
                0.0008861447311125135,
                -0.00858671471184654,
                0.01614331955750258,
                -0.03256506327935719,
                0.000217589073260297,
                0.00027229946232077096,
                0.0012949379536337127,
                -0.0019288503354368293,
                0.023551950691134246,
                0.20048479250438275,
                0.10158422089648673,
                -0.05312922427381676,
                -0.0009416476111061135,
                0.01839721485455079,
                0.004000343086449785,
                -0.03169528379287329,
                -0.00989698358648384,
                0.00469459379912582,
                0.02353825799575825,
                -0.030906064037610266,
                0.004576250029382372,
                0.0083071769159178,
                0.0024385911188303353,
                -0.03881171436819681,
                -0.0016395006390417075,
                0.01906296343754157,
                -0.001947461387932578,
                -0.04439604493075482,
                -0.005588141149077372,
                -0.0031489120495136642,
                0.03815829795572777,
                -0.021083170704823944,
                -0.20582850639211664,
                -0.025060414707910664,
                0.23831994993756947,
                0.028872879095597066,
                0.004069243708714053,
                -0.0031961354047565765,
                -0.15053656775350988,
                -0.020067820563154683,
                0.17820546742885296,
                0.020578169831748334,
                -0.004173881765725909,
                -0.00046304601701721755,
                -0.02596800196267747,
                -0.006528745924252281,
                0.049866973681491844,
                0.004186317546701673,
                0.02446247249040801,
                0.004162667565769852,
                0.009633530306719198,
                0.0027908448746544563,
                -0.06143556485893421,
                -0.0037068583493311464,
                -0.09885155940071255,
                -0.006786642298986543,
                0.05383169947173617,
                0.004193231259060145,
                0.02546796861331567,
                0.007234715673159118,
                -0.01943370388368829,
                -0.004175366303768736,
                -0.017540867573644887,
                0.00024610180146163857,
                -0.007849682979686622,
                -0.0005564747644525131,
                0.013272290527225677,
                -0.0038080181405816937,
                0.025223087736022148,
                0.003270422441641736,
                -0.00747482633286059,
                -0.000833545687196458,
                0.057054497759641894,
                0.0022281732534308227,
                0.041760746705277324,
                0.0006575719539435447,
                0.03081314245667051,
                0.004563455360758392,
                0.021453346320357652,
                0.0008713040099013131,
                0.034577775763276176,
                0.002443865519813953,
                0.015666858821335637,
                0.0034944766875635302,
                0.011770847586054019,
                0.0018960205709536212,
                0.005095563124780581,
                0.0018980377395949426,
                -0.1526842205561298,
                -0.009869933699292274,
                -0.0063024771055762725,
                0.00003104361705674759,
                -0.00824752152810257,
                -0.001373010054635959,
                -0.001546283080212138,
                -0.0004663427011534367,
                -0.007799739999718971,
                -0.0002484565408399492,
                0.023633267441617416,
                0.0017582110926752893,
                -0.002145751507054553,
                -0.00033388086503345876
            ]
        },
        {
            'energy': -0.4985426834095583,
            'occupancy': 2,
            'alpha': [
                0.003418280925591164,
                -0.02224721084869562,
                -0.024745997043258798,
                -0.028569603847514818,
                -0.09151912434755453,
                0.24841147738622277,
                -0.06340211271470542,
                0.029887525170502208,
                0.06169034683164048,
                0.1460966730317558,
                -0.2094366569890983,
                0.08748938444192106,
                -0.01991386219933791,
                -0.01207918788701111,
                -0.0638466837147017,
                -0.08246725894371876,
                -0.004641249536277304,
                -0.012758132718622998,
                -0.008161871099607646,
                0.030526487082864363,
                -0.003942355596128656,
                -0.04606176854973126,
                0.1437808319869014,
                0.023858422731347837,
                0.021419230460411106,
                0.09803629577638492,
                0.019409617061571648,
                -0.046814464860811006,
                -0.01692117729359218,
                0.016460171839887804,
                -0.030682678479758824,
                -0.022091532952227787,
                0.0003888921390222832,
                -0.007132105675738066,
                -0.03475351208433197,
                -0.04451440510201376,
                -0.018198621415939913,
                -0.07871359114099144,
                0.01571366569438846,
                0.000011997927732767166,
                0.011652279054383801,
                0.06278633859099429,
                -0.044185126539858115,
                0.023882447643631344,
                0.0006795033099941533,
                0.014008129981069498,
                -0.03013949867502281,
                0.0030630003930567987,
                0.0838417431507037,
                0.27419574694888127,
                0.13404886560070917,
                -0.027788462603493328,
                0.04945267789884356,
                0.045366213471594634,
                -0.056568891078517675,
                0.02054412194166172,
                0.019049449234067085,
                -0.02711139940056029,
                -0.014906714556103123,
                -0.0690373060673692,
                0.004977766417734922,
                -0.3171098219874255,
                -0.03979819699723635,
                0.0014571452510788066,
                0.009565413071742685,
                0.29140849721611467,
                -0.04869181126032113,
                0.04707938333168414,
                0.0016655441358807044,
                -0.04451050519459659,
                0.018028819692837837,
                -0.04551130640904439,
                0.006334434573363373,
                -0.00557604601521111,
                0.03736257855217231,
                -0.01316133300232312,
                -0.0038686279465873098,
                0.001312955801620428,
                0.037823213221043366,
                0.03358649024460936,
                -0.009858806662279531,
                0.019935404202258294,
                -0.008859480900067478,
                0.03974400089848148,
                0.01058173437853939,
                -0.17319348796195388,
                0.08997132905900095,
                0.042772786541020506,
                -0.01736545383312522,
                -0.035927159925501106,
                0.02054079424839548,
                -0.008754618746229523,
                -0.08080376944762169,
                0.10774283681874851,
                -0.02611390034259754,
                -0.15118800716167358,
                -0.008770526641153473,
                0.04861229910843415,
                -0.014220319966125097,
                0.028233129497718147,
                -0.001153241778195274,
                0.027580690141465376,
                0.00676203608092466,
                0.02438527370527027,
                0.01590619251523008,
                0.049487727517847045,
                -0.011939428278267132,
                0.020614416687664245,
                0.004473816639954407,
                0.03447303581412252,
                -0.009389592112751413,
                0.054096006544105076,
                0.007458294723301633,
                -0.03392607589676071,
                0.008366861783246485,
                -0.04639632198287828,
                0.011266666751660569,
                -0.015546288109311811,
                -0.0050665100352747985,
                -0.03856377461897103,
                -0.010031291303050869,
                0.06076857260807885,
                0.00013325562899743566,
                0.024690085236422726,
                -0.006357090275741544,
                0.07614749653351234,
                -0.0026849545472753906,
                -0.0007962750355298745,
                -0.01080486763515411,
                0.00585140785190266,
                0.01741856008196256,
                0.010196485795046806,
                0.0018009803207269853,
                -0.00807382098783872,
                -0.003573969588237313,
                0.0005552535916646835,
                -0.00003182535987105846,
                0.003347984842039236,
                -0.003922183642468567,
                0.007658642501137952,
                -0.004649708159328879,
                0.04143432658024436,
                -0.009566638619395449,
                0.0708603219006435,
                -0.002204852545677264,
                0.010259619421865759,
                -0.007403050216442514,
                0.003916370335830956,
                -0.009813385514138982,
                -0.0033018365579443164,
                -0.0012267863093240383,
                0.006167991956366649,
                0.004430682586111515,
                -0.003275646708279545,
                -0.02095041444628807,
                -0.007168005234220397,
                0.0005749646160317227,
                0.005232370684921815,
                -0.021683440377738346,
                -0.004191761323971174,
                -0.0029733500366468284,
                -0.004472735154973642,
                0.015258586750250649,
                0.017430847492069183,
                -0.058313466992751535,
                -0.004524382213203801,
                0.004552075597066752,
                0.009671951769500427,
                -0.004771250125081967,
                0.0037478285575563877,
                -0.13436970003992174,
                -0.0025398569547803317,
                -0.013404459181281298,
                0.0031762568551659673,
                -0.21614405097224884,
                -0.01607055293543469,
                0.21640057178875693,
                0.025025271792467645,
                -0.19189629375085987,
                -0.020192132486478734,
                -0.03414137385412822,
                -0.0011599515441526658,
                0.030442827494246566,
                0.003372795519447819,
                -0.0028208533542148527,
                -0.0003034088477313211,
                -0.007409742595111551,
                -0.001671273890948668,
                0.04192472697180555,
                0.003071893089166652,
                -0.010725169909828757,
                -0.0006016966763941513,
                0.12559862119695753,
                0.008340532328084222,
                0.07127896296600662,
                -0.004536686633387606,
                0.03899010837642394,
                0.0011797814792697215,
                -0.027778053964988347,
                -0.002028242146184186,
                -0.011226637714824805,
                0.000011304655245579477,
                0.09470607736989056,
                0.03202843369827539,
                -0.003186444431648746,
                0.0011545787522513943,
                -0.02025278776174533,
                -0.001871384703153872,
                0.025005267436165827,
                0.0026561146132376167,
                -0.017681283384340975,
                -0.0009577061377540297,
                -0.030162447979650273,
                -0.0014807996653865966,
                -0.0575879841700996,
                -0.018881341067580226,
                -0.010226934845700263,
                -0.0012355498887128165,
                -0.00018919187364279747,
                -0.00014535306298314683,
                0.036724899073762085,
                0.0025761188541456245,
                0.00130270002504141,
                0.00023685253950384493,
                -0.006905364193813453,
                -0.0012294058634305424,
                0.005516343798431895,
                0.007384210572547963,
                -0.006897193534275496,
                -0.00023591047837978257,
                0.019871134098974997,
                0.0016588409765534,
                -0.008974891364878605,
                -0.0007514282002611948
            ]
        },
        {
            'energy': -0.4923707489127348,
            'occupancy': 2,
            'alpha': [
                -0.01329607967390646,
                0.025185569312620976,
                -0.0795478685282097,
                0.10670787038352514,
                -0.022953327396540546,
                0.06558499097771955,
                -0.012322142588226174,
                0.010897057949838345,
                0.004794116059843783,
                0.00422548537647453,
                -0.06520459177604175,
                0.02662246016585196,
                0.020590121457680535,
                0.030467086487058488,
                0.03055011325907368,
                0.17625340346054835,
                0.004387768401727569,
                -0.0020558946914340384,
                0.005031773397461872,
                0.018828654705126138,
                -0.0013630952498013425,
                -0.010322000240820587,
                0.07077526102554482,
                0.017256918680984466,
                0.04769209219216914,
                0.07933992561393187,
                -0.014484016522915574,
                0.00849199521124628,
                0.017457588656618065,
                -0.02868063710461065,
                0.014762689449197189,
                0.030737541207002984,
                -0.05543034242324339,
                -0.09904638740369957,
                -0.05989991576256135,
                0.02210918574744153,
                0.028730853109817944,
                -0.09724087780026658,
                0.0037211215670142498,
                -0.016517254681813462,
                -0.055208143400605196,
                -0.24001315897867692,
                -0.036189708614506905,
                -0.11136736793259337,
                0.005411984241668206,
                -0.11736828825737312,
                0.027574188633458015,
                -0.06495555061684553,
                0.014184367662105084,
                0.09254177759173113,
                0.02507391013175537,
                -0.004597177841888756,
                -0.07357055219754739,
                -0.017988874214888647,
                0.07787687953951508,
                -0.168511850156215,
                0.006229472615037767,
                0.2106384834884586,
                -0.02500250669172555,
                0.09885276918113707,
                0.013984663569203172,
                -0.09247213208737487,
                -0.020642136590318796,
                0.004837570704583367,
                -0.0003958621562149522,
                0.06527265155167582,
                -0.018341629038247223,
                0.005048239379025228,
                -0.017801723508191647,
                0.17712611026650435,
                -0.051075013173668,
                0.17252697627672672,
                0.02014507699511627,
                0.08587707157082311,
                0.00400133859104148,
                0.04822037483691298,
                0.019062426369215842,
                0.12923971411599736,
                -0.010215705542891942,
                0.049948275826456966,
                0.009787101413861243,
                -0.032774460400102554,
                0.009626576147797907,
                -0.027425124012162065,
                0.0017617900874804507,
                -0.014942931548959188,
                0.02595980204194463,
                -0.0011914207300970448,
                0.024884362844770226,
                0.04333648229541639,
                -0.017354519192588954,
                0.02451166056891662,
                -0.01980133788704093,
                0.01234067575206224,
                0.01329631584532771,
                -0.030112808150665124,
                0.023959052193603787,
                -0.09391659634318651,
                0.08320300365854637,
                -0.10734438328587913,
                0.03130556499722091,
                -0.09307156521821301,
                0.024726699464002074,
                -0.15078316476250608,
                -0.004078402393520303,
                -0.11020768451000824,
                0.020258150243171253,
                -0.07451788010392912,
                -0.009325378098145102,
                -0.11934207973839904,
                0.004994657260525187,
                -0.07251274142870782,
                -0.038073761436952985,
                0.16828136554084286,
                -0.010567550016350668,
                0.04234934780886186,
                -0.03757429287864494,
                0.16807122443523118,
                0.015344327837620948,
                0.07306228298940061,
                0.004098702490913344,
                -0.17990568214368732,
                -0.016912579439534062,
                -0.08086332154295037,
                0.005909780851153265,
                -0.1833983141623468,
                -0.0024023106271108922,
                -0.08693640977885135,
                0.03848518669544696,
                0.01842427713779377,
                0.04799458936869507,
                -0.0454291006694554,
                -0.0015525776229336572,
                0.013199208858316684,
                0.016860337245458445,
                0.004778351714856546,
                -0.003455035672909095,
                -0.000030507278804500186,
                -0.006508253281850976,
                0.0031604118667126362,
                0.0024672963724499857,
                -0.18652333797706838,
                0.02859244350021559,
                -0.11751653162218978,
                0.007409594406411824,
                -0.005774666497232071,
                0.015456272145604244,
                -0.01037391846272029,
                0.010724139008644794,
                0.0014814578944942227,
                -0.0007515159692502093,
                -0.026355984852997522,
                -0.007248558014067463,
                0.004902299378990696,
                0.03651794495928406,
                -0.0041166348412110705,
                0.0014780407175929659,
                0.0037185150342749916,
                0.043839464334206324,
                -0.004425638043096266,
                0.005016136595599896,
                0.00916709832363302,
                -0.009259431885777032,
                -0.03857155954579947,
                -0.056871147868026224,
                -0.007951536253108547,
                0.029222566954526668,
                0.008436835039131153,
                -0.06429158014535721,
                -0.0066047644303081085,
                -0.054210455924545535,
                -0.004191241586809837,
                0.010729766327510394,
                -0.0011856503866308449,
                -0.05723221630665304,
                -0.0032898703374895145,
                0.04480416762235323,
                0.006132507257725418,
                -0.04047519015249031,
                -0.004100032500084895,
                0.05267663707623918,
                0.008119063142209011,
                -0.018888648649030133,
                0.0007458767895328153,
                -0.07498694286598835,
                -0.0033423392310861517,
                -0.029118612324906815,
                -0.00025368153251193793,
                0.06547849837537606,
                0.0067300824665014695,
                -0.10112672515500196,
                -0.0038973957225605887,
                0.004002931472402075,
                -0.0026276800044613253,
                0.008053809836569868,
                -0.0014897834887566458,
                0.011515426779157465,
                0.000712770526070754,
                0.0654940861566832,
                0.005841088315471658,
                0.0801844649000985,
                0.008148224610653738,
                0.026195812096238686,
                0.009181769148593059,
                0.013726855197594392,
                -0.0004198831475965698,
                0.0030274135021759363,
                -0.0006641008620120575,
                -0.02551247883938854,
                -0.002659787148796685,
                0.08493709323885357,
                0.004764280155679325,
                0.07626306670333162,
                0.004372478343855786,
                -0.004802608232163089,
                -0.0024988541251526153,
                0.0033169292358920742,
                0.00034668128857760224,
                0.009999859725865881,
                0.001087435871630254,
                -0.02630787793323104,
                -0.0020335162043880932,
                -0.0028191527859125587,
                0.0015118726833655812,
                0.009986092054309462,
                0.0017344627125951328,
                -0.0024047167147764866,
                0.0031547927583093823,
                0.010959107277499547,
                0.0003179268873775613,
                -0.03313291954252858,
                -0.00282578094689823,
                0.013420841166201205,
                0.0012018989805349248
            ]
        },
        {
            'energy': -0.48690316762770053,
            'occupancy': 2,
            'alpha': [
                -0.003564038034120213,
                -0.017226609520279035,
                0.1416773883386334,
                0.09519738647752077,
                0.0037746904624937874,
                -0.014726102313920655,
                -0.03302577166645111,
                -0.067607403574318,
                0.0035084942183613932,
                0.009391616914818436,
                0.009267962760730357,
                -0.009383590495560605,
                0.0002689974180283568,
                0.001354575577109476,
                -0.000109924481395972,
                0.013233262115159898,
                0.0010072211724672245,
                -0.0019296131478798895,
                0.001156968045225267,
                0.0042756514967305205,
                -0.0004023895115690668,
                -0.004280392813581696,
                0.017949193496410935,
                0.003785705981839162,
                -0.011732717082123945,
                0.021436992897278958,
                0.06483448862713272,
                0.11362910672360092,
                0.006564928832507311,
                0.006826174713951825,
                0.01028721084297146,
                -0.010486800968279874,
                0.0247906604655838,
                -0.019208932569693526,
                -0.007692265266281193,
                -0.1114733969715431,
                -0.00019926514998967816,
                -0.007279479229776444,
                -0.026946376009836483,
                -0.03221612131502322,
                -0.0007702335048203448,
                -0.0749776089001278,
                0.14288259556609523,
                0.014234094923011921,
                -0.01836810776730819,
                0.15792746724820664,
                -0.3177818358386594,
                -0.07387351282297251,
                0.009630358213561417,
                -0.03463696025496397,
                0.021380086125073708,
                0.017896531137268426,
                -0.014111688370129763,
                -0.01099935663966782,
                0.019553831191078896,
                0.01731097130678765,
                0.025577775423141717,
                -0.006966800446096597,
                0.08682228597728647,
                0.038036103861845874,
                -0.0035763913472543294,
                0.020854811391906494,
                0.020680258360452897,
                0.026569740443859513,
                -0.009801259725884321,
                -0.004066079804586831,
                -0.012761412437339166,
                -0.020521431673080914,
                -0.007460210503585187,
                0.03938720630719276,
                0.04427383461182309,
                0.07374916881500163,
                0.05599311186742362,
                -0.1335568456234912,
                0.27278314623944844,
                0.09024580800341674,
                -0.08146249046444201,
                -0.097675299017151,
                0.35731990529051433,
                0.1460557351931631,
                -0.0013802220620675895,
                -0.0019491583863172697,
                -0.0026421677130238487,
                0.0032079294302993716,
                0.0005095469944425753,
                -0.011081949625311607,
                0.0014611971187037506,
                0.00612829861601157,
                -0.003190891737402705,
                -0.0029561910271483577,
                -0.0000031355644762200473,
                -0.0027814204398543874,
                -0.008085429569711526,
                0.010293051728535839,
                0.0017544172749801655,
                -0.009880858234734806,
                0.017007330483668186,
                -0.04361820443482478,
                -0.03761607012154531,
                -0.07867020879028695,
                -0.0009993912253463881,
                0.015068154765829662,
                -0.06991477479250786,
                -0.04097083669497029,
                -0.009670198960843415,
                -0.00918142980061352,
                -0.030518558962702984,
                0.01557568911940018,
                0.013940888221054963,
                0.008717707166195585,
                0.005238966355997936,
                -0.016379673191162458,
                0.003555264078241556,
                0.029312582677926958,
                0.07507258261610143,
                0.11696455696307166,
                -0.024432968504293183,
                -0.039473352782238215,
                0.09851884477056008,
                0.06349146156250612,
                0.0016234403441975785,
                0.0017329734044333814,
                0.045171553774161016,
                -0.0016072636210159024,
                -0.004352743380969293,
                -0.012803935290554272,
                0.01716305800405447,
                0.025315402829091782,
                0.008513986479410877,
                0.02468198603278651,
                -0.11766193722111033,
                -0.06816931328129795,
                -0.0033838798283304028,
                -0.001880283157889701,
                -0.0011340209534273218,
                -0.001660156568926858,
                -0.0015448771084999849,
                0.0008330783880485944,
                -0.0023618421713222826,
                0.0011499032439388308,
                -0.0024402033344448314,
                0.005775851426208512,
                -0.04376556157428468,
                -0.013617389488082464,
                0.0025133605087668746,
                -0.007406403718477109,
                -0.006996461338378277,
                0.0012607784461378213,
                0.0027405986474056607,
                -0.007326280544312468,
                -0.004596275277716769,
                0.004614218514152933,
                -0.0014208423926146284,
                0.003830762917482017,
                -0.002902696394476627,
                0.013354390414179924,
                -0.0020404385243473935,
                0.003531207221733321,
                -0.006843440259518069,
                0.012198091690531997,
                -0.000916926645885799,
                -0.012514636080856728,
                -0.010732663189900064,
                0.006532735363288537,
                -0.03751124010739666,
                -0.004926319970475586,
                -0.006584679832361277,
                -0.0013614259820808447,
                0.023162258915439295,
                0.0018397405696503263,
                -0.000029170623122428985,
                0.002977364832886429,
                -0.006991495889620896,
                -0.0010911024252580278,
                0.0409224162427569,
                0.006431266255937212,
                -0.009383405727887952,
                -0.0034523376197154207,
                0.019639672389797396,
                0.0000688406276022138,
                -0.28052116596804577,
                -0.02566370063236377,
                0.07113167352248409,
                0.01137458121001338,
                0.07896090005135638,
                0.01264213756747596,
                0.02956051524983797,
                -0.0050982972518036325,
                0.2515353199760934,
                0.01714169211654434,
                -0.03796127498683704,
                -0.00956832041727908,
                0.010235904027040216,
                0.0008778747141816673,
                0.007440427868242022,
                0.00011635674495009514,
                0.0019964223689761264,
                -0.0008404712944346984,
                0.10668166502136064,
                0.013010610994115178,
                -0.07187094474606925,
                -0.009047397222740767,
                -0.004750899268789519,
                -0.0022902762662259575,
                -0.03170228900738345,
                -0.0036331196122164813,
                0.021084376288501176,
                0.0023411514485993283,
                -0.0013219970369627997,
                0.0035623861851426346,
                -0.059207189761991436,
                -0.004381355028922454,
                0.09892364515119696,
                0.0069168665627323805,
                -0.0034240507736379372,
                -0.0022485690875914868,
                0.018912014650144054,
                0.0019426457814481356,
                -0.021863563732737446,
                -0.0023833418004132276,
                0.010930059049531983,
                0.000852138371250057,
                -0.0038396291530626266,
                -0.00011340961695177027,
                -0.00311683320252517,
                -0.00004804379394024491,
                -0.0006616772478088902,
                0.000813754814762875,
                -0.003644488314071775,
                -0.0003725117001406554,
                -0.0025661225538587953,
                -0.0003628360069855088,
                0.010645218561664359,
                0.000858667369392569
            ]
        },
        {
            'energy': -0.4858924025837172,
            'occupancy': 2,
            'alpha': [
                -0.0007888684739051163,
                -0.004324482530468885,
                -0.003556797558128438,
                0.012606765953088454,
                -0.029669188892841713,
                0.03180796834609031,
                0.11248323650016782,
                0.15421844728655895,
                0.024374052098120783,
                0.13425926401305993,
                0.3319334353463892,
                -0.10452679422259978,
                0.0008765609948268381,
                -0.0012030773496934978,
                0.0007640522600124176,
                -0.0031083754717104203,
                -0.07785281567801704,
                0.00844353469261064,
                -0.09531834795930395,
                -0.18934077001895855,
                0.014278019623833042,
                0.06157445158698896,
                -0.6817056270611398,
                -0.17195401027147483,
                0.014063385123909877,
                0.027048820746903464,
                0.014254968602008195,
                -0.0035893828717582566,
                0.0005007473493609856,
                0.000760376882512122,
                -0.00016846105770825117,
                -0.0008213843703379658,
                -0.0005375086217707337,
                -0.009009598084825607,
                0.004990345687383261,
                -0.012869964314185061,
                0.004139240685418372,
                -0.009326773841377964,
                -0.023880630845042352,
                -0.009437744649098684,
                -0.0038963081027956568,
                -0.01792534288911166,
                0.0009238084750644271,
                0.0009479358846061848,
                0.0033096000539423035,
                -0.01628259368040364,
                -0.01800665582857686,
                0.00041807054696693267,
                0.028002042574130366,
                0.0772775276317608,
                0.07032561986217427,
                0.002403698852282203,
                -0.0007624320198452142,
                -0.0018940844656250304,
                0.0019203075900103249,
                -0.00007352333894161748,
                0.010915875507674325,
                0.010009319499375833,
                0.0066134760311680795,
                0.0018950988266089714,
                -0.004020398965378409,
                -0.0947786227466183,
                -0.04887090633286114,
                -0.03736543470600385,
                -0.0005285822209652254,
                0.01630172141696253,
                0.1470875183601329,
                -0.04153288832124504,
                -0.0012600417997499377,
                0.008984156138449932,
                -0.0026895566441221186,
                0.011332024232826478,
                0.006458859857940441,
                0.014921802921509611,
                0.013922866977659121,
                0.003957576015043578,
                -0.0006546250746946369,
                0.021148173875408,
                0.02041184755515413,
                -0.001855770812588058,
                -0.003975442097162646,
                -0.000503734667002272,
                -0.0019858462162445772,
                0.0025211876885953767,
                -0.01138869996807002,
                -0.08719836008704712,
                -0.12836325386086012,
                0.07755672223612135,
                0.00009638266279498818,
                0.0009415812830278658,
                0.0016626603018621764,
                -0.002711082934114266,
                0.09745830768729029,
                0.007597482344665961,
                -0.2623868573199272,
                0.11018393364189269,
                0.00297928402077152,
                -0.005514148621717004,
                0.0035179897839049713,
                -0.009622297148495664,
                0.001874429358275001,
                -0.0016762495309661104,
                0.001312274871607882,
                -0.009766426445018163,
                0.0023200050840620494,
                -0.006675063700970666,
                -0.008561478961875297,
                0.004653587294639695,
                0.0033109086041700824,
                -0.007064386225853117,
                -0.0025703219608078807,
                0.005225580120987704,
                -0.002014356836703417,
                0.013548627017186392,
                0.004718810598057859,
                0.00226556537881652,
                -0.0025296804251544206,
                0.011528378435911217,
                0.007435598278740502,
                0.000379224987631129,
                -0.0017180852569220898,
                -0.002684985945231898,
                0.008950741448683353,
                -0.009264758396360016,
                -0.0022193537394862217,
                -0.0026302552481507428,
                0.0037230576030894027,
                -0.010095582092329896,
                0.002426610277054847,
                0.005804984764066559,
                0.0022937947352549815,
                -0.008032297260260982,
                0.000011474281166011155,
                0.000041106376860111926,
                -0.00021733208184624003,
                -0.00026322597888538536,
                0.06751783983849322,
                0.006746274905468843,
                0.1076865371456125,
                -0.038002544997965716,
                -0.0015771004204321612,
                -0.012486026280680658,
                -0.00926343517101261,
                0.005910153408848872,
                0.00008511798616910184,
                -0.00007554825328732911,
                0.00006228733878780019,
                -0.00012503106557342817,
                -0.000011574308186396958,
                -0.00020412695814412405,
                0.00023335618883017827,
                -0.000019459919259651772,
                0.00003565197145045392,
                0.00036446097514977705,
                -0.0003604036382491162,
                -0.00037246314936667556,
                -0.00010290871169829143,
                0.000490583498568185,
                -0.00041959969886004177,
                -0.0003761169704651687,
                -0.00004283824857859421,
                -0.0004381715640874639,
                0.0005894466563024034,
                0.00000839304447019665,
                -0.022824353143168108,
                -0.002270904121354664,
                -0.014503682653028,
                -0.002392752844551051,
                -0.022932941718143432,
                -0.0010688614694499493,
                -0.055814376294616885,
                -0.0027590334470539097,
                -0.01823788534981338,
                -0.002092453396765572,
                -0.10656723553780016,
                -0.02387421853126481,
                0.11069550942276346,
                0.008170696886078322,
                -0.004827939244107218,
                0.00520249512838444,
                -0.0022269374111815333,
                0.0013837726135689698,
                0.009008912772357386,
                0.0015157877344757792,
                -0.016046985539113066,
                -0.0010476816307172932,
                0.013525003389575041,
                0.0012273369042826781,
                0.01391417386355031,
                0.001368342322633897,
                -0.025325539305215663,
                -0.00215418552946711,
                0.15223889319379888,
                0.03966486107204724,
                -0.017321605212947407,
                0.004552477269842952,
                -0.07812635863276816,
                -0.004080998226241738,
                0.007208673581625784,
                0.0009509191814522044,
                0.0020464865507729534,
                0.0004864763103804696,
                0.02558862334818581,
                0.0030477612276046664,
                -0.006455814794611858,
                -0.00047340961995367037,
                -0.004091909125869742,
                -0.0002512240593287985,
                0.00025354503237026043,
                0.0005861543513680325,
                0.0024741607381932886,
                0.0004808785327440701,
                0.005923738384637742,
                0.00039554648107730997,
                -0.02212175823152417,
                0.0011239811035768956,
                -0.003433728732124287,
                -0.00034436004289354434,
                -0.004419850696478775,
                -0.00048662088231662715,
                0.01376665965321193,
                0.0011491791105866095,
                0.00018821628582803347,
                0.000025705932485803812,
                -0.00037678653216529934,
                -0.000013582172556431535,
                0.05248364823111266,
                -0.027348072024068183,
                -0.0005320916370098719,
                -0.00003948397459294093,
                0.000490500800531597,
                0.00003620133383254273,
                0.00019145158278347066,
                0.000014237091254558446
            ]
        },
        {
            'energy': -0.4848743712626315,
            'occupancy': 2,
            'alpha': [
                0.008793336721375875,
                -0.07975648019850264,
                0.016538320913128027,
                0.008824273208324917,
                0.0035752707223657893,
                -0.009573652021792736,
                0.018261630290480967,
                0.019397852324780206,
                -0.0003598140920877557,
                -0.0028704092209255656,
                -0.006710301204981809,
                0.00400796174140575,
                0.0019335175254641041,
                0.00023082553266255966,
                -0.00797366170913568,
                0.021465613184672567,
                -0.001830686293338067,
                0.0010144947727458262,
                -0.002242559971247196,
                -0.004765297518072126,
                0.000495016208741226,
                0.001568905077501058,
                -0.018288455329911624,
                -0.004309249572577324,
                0.029919758141746636,
                -0.11162638116486064,
                0.08259761716291086,
                -0.15470388076816857,
                0.0022087433666606393,
                -0.002668243104652603,
                0.0031262160054161725,
                0.0041826238019176554,
                -0.09003632277638399,
                0.06991220495378948,
                -0.16023896102122087,
                0.2585284673469422,
                0.006841593097774808,
                0.02765612960209057,
                -0.0243180419903903,
                0.055802334886445794,
                -0.01198525714942718,
                0.08385882369609902,
                -0.04744614404123703,
                0.17357545601745014,
                0.01256393645497545,
                -0.12432509650599766,
                0.054022933891760196,
                -0.32796619908702124,
                0.0005887750332149628,
                -0.020773861058016676,
                0.004577282963270265,
                -0.021910336197349778,
                0.04369280342916737,
                0.04000232682738801,
                0.036870940211838454,
                -0.039889833749669285,
                -0.08318147441788622,
                -0.02091293258733056,
                -0.011788700132564769,
                0.04299408427973515,
                0.0001673162928949922,
                0.0075618628066235665,
                -0.0035974018823246075,
                -0.006195776639763112,
                0.006737491238190626,
                -0.005474735467436579,
                0.002320679323770105,
                0.011164547749491539,
                0.021186976012512328,
                -0.1425080833173468,
                0.030450768904254553,
                -0.08898312150456238,
                0.08031870653307098,
                0.05672999006229547,
                0.055229112219595096,
                0.27674613373861245,
                0.03198282833472069,
                0.12228258880149127,
                -0.05357985018208515,
                0.28989125040182534,
                0.013108099720102392,
                0.006551952139775052,
                0.006943649776177791,
                -0.0034135812504518686,
                0.0009428620956338496,
                0.002080278181143468,
                -0.00017975252649807963,
                -0.0018885532665530698,
                0.0020464026702039753,
                0.0008949788862056146,
                -0.000897747608090811,
                0.0004805782203233433,
                0.004691870993264114,
                -0.002946720336862214,
                -0.005539920576318839,
                0.005502855988672725,
                -0.01798702278373282,
                0.08053660356582928,
                -0.04738246635854928,
                0.028780998228155073,
                -0.023203547700331357,
                0.08767124108286944,
                -0.0009962655351459788,
                0.06078141723515373,
                -0.014386428771443678,
                0.0027904996035768505,
                0.029204407623336173,
                -0.027231719393450145,
                -0.01018346491609977,
                0.010631320834326401,
                0.011356026350105486,
                -0.044361001223183566,
                0.027839752741074402,
                -0.0473583109131018,
                0.06641632409245941,
                -0.056695829334219766,
                0.02257128105229275,
                -0.0519313872262295,
                0.05556987679365485,
                -0.08621100105535165,
                0.007663936475238928,
                -0.0343710520761677,
                -0.02238198582197102,
                0.017473303380940823,
                0.007919383979299722,
                -0.04171366758874909,
                -0.00792397416362808,
                0.030952143553754394,
                -0.020116518701866194,
                0.03987353092032079,
                -0.007902744726057275,
                -0.030018720766838664,
                -0.0004077403255597463,
                0.00014125223230098614,
                0.001083607027681318,
                0.0006848751550686585,
                0.002030004081099865,
                -0.0003609517160251446,
                0.00308978562193582,
                -0.0011813032199473271,
                0.0071140915460612235,
                0.0035636563805099275,
                0.02646270922096627,
                -0.06169869215194651,
                0.00035533285936374947,
                -0.0014149320878314956,
                -0.00045512947823271593,
                -0.0023353472401113975,
                0.0011781068313299278,
                0.00037888186545126303,
                0.00012094174449793103,
                -0.002634771446457656,
                -0.0004072884318860202,
                0.0014607470499650682,
                0.005018948546907452,
                -0.00012132342487920473,
                -0.00017274951107435515,
                0.0003552799058434164,
                0.004602017584175073,
                -0.0014945029212950474,
                -0.00000815796590629168,
                0.0005297199649544414,
                -0.0012752284247893664,
                -0.005605753276977341,
                0.0645338428542698,
                0.008661459366944626,
                -0.06167441267628565,
                -0.008176543366165525,
                -0.008948308052376962,
                -0.00014771527734263237,
                0.029764592400695056,
                0.0034190105338091675,
                -0.02622323339634846,
                -0.002742297852123517,
                0.0005862136114590627,
                -0.0012883966956721159,
                -0.003480133068425965,
                0.0006558211874601159,
                -0.0033629138309711985,
                0.00019361891595045646,
                0.024628544794482073,
                0.006321970747604193,
                -0.17130868074446806,
                -0.008596664648897932,
                -0.02303942141195107,
                0.004433176683205967,
                -0.24857830374261827,
                -0.01886852745154707,
                0.22974933627870064,
                0.022353381385899915,
                -0.054631213797379945,
                -0.0023444490832636934,
                -0.005060879813502606,
                0.0003914022017107271,
                -0.0028074416717337606,
                0.00019940690592686806,
                -0.0022880412431068426,
                0.00015728433658979745,
                -0.020749967955843454,
                -0.000718237224685397,
                -0.06362200822732272,
                -0.007074176860329399,
                -0.002949189677129598,
                -0.000701163494065697,
                0.017837245970511395,
                0.001627808614860301,
                0.02849676643732739,
                0.0030254303915525542,
                -0.0012604942424570057,
                -0.0018263180092923487,
                -0.06535268810615467,
                -0.004176999413691186,
                -0.029473849201205816,
                -0.0016095801205002235,
                0.0004217549843509092,
                0.0008520286239787886,
                0.022849762668173918,
                0.0023478697498631293,
                0.010106752923455642,
                0.0011787809356931323,
                -0.058484475299918404,
                -0.004914243907539978,
                -0.0023020667925950566,
                -0.000017315917941063567,
                0.00116797749625826,
                0.00015418073196550735,
                0.0012760066090017226,
                -0.0007552276341836724,
                0.0013007544454867218,
                0.00008590268367683984,
                -0.003189280803871698,
                -0.0003006096400050358,
                0.002264432242474226,
                0.0001931492493319158
            ]
        },
        {
            'energy': -0.4817797216843319,
            'occupancy': 2,
            'alpha': [
                0.00023916987684574232,
                -0.062393234771160884,
                0.21455304998232647,
                0.12707748406587635,
                0.0007586449978499231,
                0.034678947207055374,
                0.17754347152404476,
                0.334055157207218,
                -0.027343924653335003,
                -0.10603667442140585,
                -0.16505403070561483,
                0.09065185043980517,
                -0.0017239306625822534,
                -0.0023672795632682514,
                -0.006252096445611814,
                -0.013366976766509001,
                0.005122071002018621,
                0.014267872382565697,
                0.0063170710243407825,
                0.0006089291099132711,
                0.0014006998222148522,
                0.014143917152698617,
                -0.020096203082031458,
                0.0016896009005217556,
                -0.0015712569953812508,
                0.011011630735672276,
                -0.08042013428646053,
                -0.043596309394844344,
                -0.009275662087061202,
                0.0006508674303469497,
                -0.009159088911079144,
                -0.0006405422732685189,
                0.001325892637952059,
                0.013476082415712038,
                -0.018934537420851157,
                -0.017175287487990628,
                0.024489805016968024,
                0.02270956378557474,
                -0.015158609134142862,
                -0.0284005158675737,
                0.00439450070885525,
                0.0019934227328624148,
                0.010372677688602321,
                0.002391298871249528,
                0.005083553965721338,
                -0.02770847175076829,
                0.08279619161333249,
                0.053114041769459185,
                -0.0009865228720555839,
                0.03743824648967183,
                0.009497395019117059,
                0.05006691525951204,
                -0.0005781101156903765,
                -0.0005888862049028095,
                -0.02845061279979425,
                -0.01142376029351434,
                -0.0018371651061459856,
                -0.0004283064190107124,
                -0.01244030681200616,
                -0.008005087336809779,
                0.03194950755569482,
                -0.020124581131716293,
                -0.11789927765946107,
                -0.17267797342158664,
                0.10545591208475545,
                -0.06873254760308944,
                0.028778560831230836,
                0.18301736560560064,
                0.001164531291954979,
                -0.04672297389434592,
                0.1583598030346987,
                0.09248273399425257,
                -0.023842780529692874,
                0.024273935948810384,
                -0.07329311552787052,
                -0.059899574884846304,
                0.022443185381351746,
                0.020321890638827486,
                -0.09079576932039203,
                -0.04839661183176968,
                0.0001721422027441598,
                -0.0017311419148497084,
                0.0033435114445730736,
                0.0012380239948855667,
                0.006219345607762179,
                0.1051691002671482,
                0.037474404636346464,
                -0.07115416751831947,
                0.0030818642634741333,
                0.0030250111064820365,
                0.0025061693540160495,
                0.002432680386723564,
                0.04854530386609468,
                -0.07612425031747472,
                0.031090069476810176,
                0.06264165609051729,
                -0.017933349567859566,
                0.03865364979236753,
                -0.14350018291270242,
                -0.09450794320703736,
                0.015778183376008732,
                0.050873866569634094,
                -0.1518663583773896,
                -0.07929810754726846,
                0.002502108543872921,
                0.0025010589408920175,
                0.003906373779136883,
                -0.003908814914420959,
                -0.0027824830345087774,
                0.00030099758075909517,
                -0.0027668646776921506,
                0.004927102711962466,
                0.031477563363326425,
                -0.023034447569883765,
                0.1730532657086043,
                0.13419991492198294,
                -0.030847574031952887,
                -0.08691052079455386,
                0.1856184862686953,
                0.08131224055663129,
                -0.0014013591202125138,
                0.0004743250315164383,
                -0.0016448212676393648,
                0.004900751707333752,
                0.001580646803517556,
                0.004716727824713454,
                0.0028371532448163697,
                0.00015620412951099338,
                -0.0011895730625993218,
                0.056733668609655966,
                -0.19753977754159077,
                -0.11799007527465989,
                0.004206136201992026,
                0.00033164276165467953,
                0.0000922198298068988,
                0.0011840209678461808,
                0.003239939423503152,
                -0.009144896452658369,
                0.003499749750355442,
                -0.003436984300500411,
                0.00014046073219711164,
                0.003714032400184077,
                0.0012827778677874822,
                0.0019420815883704398,
                -0.0021911934255048936,
                0.011092287071778256,
                0.0071626627660422194,
                0.00628796333991631,
                -0.003934489458449355,
                0.00809071025908732,
                0.0023238477801156205,
                0.0020404753903029717,
                0.00131653851684127,
                -0.00955715252371073,
                -0.005921997827184219,
                -0.009771088532162117,
                0.0024533936175958303,
                -0.007385723756982424,
                -0.0007473137828243526,
                -0.006019293792092925,
                0.0015360025354111137,
                0.012924824267475515,
                0.00896099317913032,
                0.0054213191307144765,
                -0.010774979743595838,
                0.001849306494047608,
                0.01768486205348622,
                -0.0013284392751828633,
                -0.0037836910302394182,
                0.0011267666785629848,
                -0.07916262632050763,
                -0.005610154469762929,
                0.022019343044808053,
                0.002868720932260405,
                -0.20149483180644615,
                -0.026567474010743795,
                -0.04849396464890926,
                0.012334529371027785,
                -0.09305912927562826,
                0.007330254515919699,
                0.0640258256447202,
                0.006597590604311251,
                0.005603115124332492,
                -0.000988975921568255,
                -0.016106609463666703,
                -0.003762831335444547,
                0.003193013151159411,
                0.0019820152560772295,
                -0.07497270096631836,
                -0.005000416988139178,
                0.013934667864999542,
                0.0030177493182331405,
                -0.1406807374158025,
                -0.020278301171599605,
                -0.05348268312097491,
                -0.00003068058061993816,
                -0.006111451450244777,
                0.006584894385281947,
                0.1670735194178553,
                0.017411196315819263,
                -0.17170316560152252,
                -0.017024093893206835,
                0.0059141845149153025,
                0.008731790544677098,
                0.002264403882600531,
                0.0021114250896094146,
                -0.0015391597989188029,
                -0.002089519695502861,
                0.003480705505240939,
                -0.0014333043394559645,
                -0.16643343119687992,
                -0.013144176818742593,
                0.16457144501270707,
                0.012882603210934257,
                0.027875973314166073,
                0.01613058057764383,
                0.0022464622292554526,
                0.00011934515555657512,
                -0.0019422539579244489,
                -0.00008552738434269295,
                -0.000712562066854881,
                -0.000059704597123092064,
                0.008140028031029294,
                0.0004586278182743698,
                0.003420108968234563,
                0.00006243344765203307,
                -0.003057411021084445,
                -0.0013239826764176918,
                0.004058210041698345,
                0.00039827228017780633,
                0.005999959776119337,
                0.0006938803178543149,
                -0.015509539218299293,
                -0.0013316833380275196
            ]
        },
        {
            'energy': -0.4806020817190941,
            'occupancy': 2,
            'alpha': [
                -0.00007997673991673107,
                -0.04977842633296713,
                0.15546225350082032,
                0.09982785365783091,
                -0.011545965080185114,
                -0.01900468791720805,
                -0.18395777051443957,
                -0.3507110523341301,
                0.028991260066234044,
                0.11900598580131604,
                0.1957166353934102,
                -0.10223840981916865,
                -0.006742230694220932,
                -0.022419969140286388,
                -0.045319042911038145,
                -0.029514705656709692,
                -0.002637490264750201,
                -0.01688965994369771,
                -0.003089032937202789,
                0.005115492649387476,
                -0.0024610056862121063,
                -0.014894087346810697,
                0.04462369062782262,
                0.003074588767017342,
                0.010265405245229764,
                0.016662638550047317,
                -0.0527608993655974,
                -0.05302092754156728,
                -0.035612434676789255,
                0.011435762821976746,
                -0.029993539619476588,
                -0.010137881579137122,
                -0.00952998400736064,
                0.01924760818707024,
                -0.05349396757532519,
                -0.0160682572167843,
                -0.03232000276932832,
                -0.030631141524813357,
                0.06094586483415657,
                0.06763115197098468,
                -0.00330120033855045,
                -0.00338489934481809,
                -0.043701253856648796,
                -0.012321037514995367,
                0.0020948910776680896,
                -0.049630959189949614,
                0.10977804785940853,
                0.04259208392485902,
                -0.02449014506637372,
                0.005932769308084083,
                -0.024165820325313593,
                -0.10678899352317803,
                0.006540194562386508,
                0.004647537203187858,
                -0.07470789714567912,
                -0.06039114544986583,
                -0.0016771494373513736,
                0.03504851022027931,
                -0.07259574867468774,
                -0.029980456802603847,
                -0.029690457642903005,
                -0.012545354049066869,
                0.11925280371885882,
                0.1931002857374766,
                -0.12751760841101775,
                0.09774714765836037,
                -0.02151242681018605,
                -0.21204533389752397,
                -0.0017739284646352536,
                -0.03795768338287767,
                0.12606022218028295,
                0.0848541332182262,
                -0.030699621162140332,
                0.021586783821840295,
                -0.07331644440136265,
                -0.06272049987421714,
                0.03207253417836738,
                0.03985978780378996,
                -0.11781704336764774,
                -0.03123101986159723,
                -0.0025918329995258584,
                0.006328603613535888,
                -0.004423349409737183,
                -0.0022872215923661144,
                -0.009903770179549817,
                -0.11669524815540092,
                -0.049310187067703716,
                0.08152245798749976,
                0.011345589628857887,
                0.009935801705610642,
                0.007963345046055887,
                0.00960299992628514,
                -0.058175142140614956,
                0.08426337586467261,
                -0.024813644538276874,
                -0.07471790259690998,
                -0.018995336944036167,
                0.031084679471583367,
                -0.12164991421532736,
                -0.06913452357631987,
                0.017291122554377085,
                0.0394521149130033,
                -0.11737180393935513,
                -0.0779887410714059,
                0.012405449557266628,
                -0.0025805755504529717,
                0.023072986210230108,
                -0.005831693498436606,
                -0.009662122710075754,
                -0.01845217998287396,
                -0.0020650034762955266,
                0.02585553840820534,
                0.024143521932159476,
                -0.019290930860228463,
                0.13374593159294118,
                0.10178036678679481,
                -0.025690062142129794,
                -0.0527968741749984,
                0.14853962771451867,
                0.061161774261881276,
                -0.003928899843380717,
                -0.008661734775172047,
                -0.03088555669580439,
                -0.012442990124276167,
                0.002134463514126672,
                0.005904570407767548,
                -0.011683594680210322,
                -0.03813046986179254,
                -0.00024413501023354956,
                0.047125801907339546,
                -0.14756498001338744,
                -0.09397941752717515,
                0.01647411582192141,
                -0.0008961556192965943,
                -0.0013828526460263847,
                0.0003128243964480062,
                -0.00758585813485443,
                0.01076371508574451,
                -0.009619734753859664,
                0.005704130951425388,
                0.000049099886864339324,
                -0.02579171074542104,
                0.03025240381615181,
                0.018270327934866906,
                -0.00869619202920481,
                0.04539337543106911,
                0.02790049823352837,
                0.029184950318753677,
                -0.015480219545194384,
                0.03316356522491358,
                0.010044147145512314,
                0.013311877688401183,
   