
if __name__ == "__main__":
    import json

    output_path = "result_db12.json"
    if len(sys.argv) == 4:
        print(sys.argv)
        output_path = sys.argv[1]
        choice = sys.argv[2]
        numberProcesses = int(sys.argv[3])

    if choice == "single":
        score = single_dirac_benchmark(correction=False)
        numberProcesses = 1
        score["ITER"] = 1
        scores = [score]
    elif choice == "multi":
        results = multiple_dirac_benchmark(numberProcesses, correction=False)
        scores = []
        for norm in results["raw"]:
            score = {}
            score["NORM"] = norm
            score["ITER"] = 1
            scores.append(score)
    else:
        sys.exit(1)

    i = 0
    for score in scores:
        score["COPIES"] = numberProcesses
        score["TYPE"] = choice

    output = {}
    output["scores"] = scores
    major, minor, micro = sys.version_info[:3]
    output["PythonVersion"] = {}
    output["PythonVersion"]["Major"] = major
    output["PythonVersion"]["Minor"] = minor
    output["PythonVersion"]["Micro"] = micro

    print(output)
    with open(output_path, "w") as f:
        json.dump(output, f)
