# Contributing to SimplyClip application

Welcome, and thank you for your interest in contributing to our SimplyClip application!

There are many ways in which you can contribute, beyond writing code. The goal of this document is to provide a high-level overview of how you can get involved.


## Reporting Issues

Have you identified a reproducible problem in our sample code? Have a feature request? We want to hear about it! Here's how you can make reporting your issue as effective as possible.

### Where to Report

You can report the issues by contacting us on our email ids.
-amengan@ncsu.edu
-nkotche@ncsu.edu
-nnlodha@ncsu.edu
-schidar@ncsu.edu
-ugnanas@ncsu.edu 

### Look For an Existing Issue

Before you create a new issue, please do a search in open issues to see if the issue or feature request has already been filed.

If you cannot find an existing issue that describes your bug or feature, create a new issue using the guidelines below.

### Writing Good Bug Reports and Feature Requests

File a single issue per problem and feature request. Do not enumerate multiple bugs or feature requests in the same issue.

Do not add your issue as a comment to an existing issue unless it's for the identical input. Many issues look similar, but have different causes.

The more information you can provide, the more likely someone will be successful at reproducing the issue and finding a fix.

Please include the following with each issue:

* Version of our code

* Your operating system

* List of extensions that you have installed

* Reproducible steps (1... 2... 3...) that cause the issue

* What you expected to see, versus what you actually saw

* Images, animations, or a link to a video showing the issue occurring

* A code snippet that demonstrates the issue or a link to a code repository the developers can easily pull down to recreate the issue locally

### Final Checklist

Please remember to do the following:

* [ ] Search the issue repository to ensure your report is a new issue

* [ ] Recreate the issue after disabling all extensions

* [ ] Simplify your code around the issue to better isolate the problem

Don't feel bad if the developers can't reproduce the issue right away. They will simply ask for more information!

# Thank You!

Thank you for taking the time to contribute.