# Dataset: WiFi-based Human Activity Recognition using Raspberry Pi

## Introduction

This dataset contains 980 CSI captures for 11 activities performed in a small apartment by 1 subject. Each capture contains 3 seconds of CSI captured for 80MHz 802.11ac frames at a sampling rate of 100Hz. Each capture is labelled as `{activity_name}_{epoch_timestamp}.pcap`.

## Capture Setup

This data was captured using a wireless Access Point, a Raspberry Pi 4, and a desktop PC. The desktop PC was connected to the AP running as a managed network, and traffic was generated using `ping -i 0.01 -F 192.168.1.1` (-F enabling flood ping, which ensures pings are sent without waiting for a response). The Raspberry Pi 4 overhears the outgoing frames from the desktop. A diagram is included in both the publication, and this directory. 

As this setup uses a managed 802.11 AP-STA pair, inconsistencies in the CSI stream may be present and vary throughout the dataset. This should be considered a wholly realistic representation of possible system performance using commercial off-the-shelf wireless hardware.

![Diagram Image](csidiagramimage.png)

The Raspberry Pi 4 is configured with Debian 10 (Buster/Linux 4.19.97) with the main branch of [`nexmon_csi`](https://github.com/seemoo-lab/nexmon) installed. `nexmon_csi` was configured with the following filter options: Channel 36/80, Core 1, NSS mask 1, 30us Delay. The MAC address filter was set for the AP. Data collection was controlled from another device connected to the Pi over SSH, communicating over a separate 2.4GHz network to reduce interference.

The AP used is a Sky ER110 wireless router operating a 5GHz WiFi network on channel 36 at 80MHz. Finally, a separate wireless device is paired with the AP to generate traffic for which the Pi can capture CSI. This is accomplished by sending flood pings at a consistent 0.01s interval to the AP. While this does not guarantee a consistent sampling rate, the resultant timestream can be linearly interpolated to approximately 100Hz.

The environment and activity location distribution is detailed in the image below. Additional explanation is also included in the publication.

![Environment Layout](layoutdiagram.png)

## Reference

The data in this project is licensed under MIT license. If you are using this dataset for any research or other projects, I would greatly appreciate if you could cite this repository or one of my papers.

a) "G. Forbes. CSIKit: Python CSI processing and visualisation tools for commercial off-the-shelf hardware. (2021). https://github.com/Gi-z/CSIKit."

b) "Forbes, G., Massie, S. and Craw, S., 2020, November. 
      WiFi-based Human Activity Recognition using Raspberry Pi. 
      In 2020 IEEE 32nd International Conference on Tools with Artificial Intelligence (ICTAI) (pp. 722-730). IEEE."

  ```
  @electronic{csikit:gforbes,
      author = {Forbes, Glenn},
      title = {CSIKit: Python CSI processing and visualisation tools for commercial off-the-shelf hardware.},
      url = {https://github.com/Gi-z/CSIKit},
      year = {2021}
  }

  @inproceedings{forbes2020wifi,
    title={WiFi-based Human Activity Recognition using Raspberry Pi},
    author={Forbes, Glenn and Massie, Stewart and Craw, Susan},
    booktitle={2020 IEEE 32nd International Conference on Tools with Artificial Intelligence (ICTAI)},
    pages={722--730},
    year={2020},
    organization={IEEE}
  }
  ```

MIT License
Copyright (c) 2020 GLENN FORBES
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.