% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layouts}
\alias{layouts}
\alias{layout_tbl_graph_frgrid}
\alias{layout_tbl_graph_kkgrid}
\alias{layout_tbl_graph_gogrid}
\title{Layouts for one- and two-mode networks}
\usage{
layout_tbl_graph_frgrid(object, circular = FALSE, maxiter = 1000)

layout_tbl_graph_kkgrid(object, circular = FALSE, maxiter = 1000)

layout_tbl_graph_gogrid(object, circular = FALSE, maxiter = 1000)
}
\arguments{
\item{object}{A migraph-consistent network/graph}

\item{circular}{Should the layout be transformed into a radial representation.
Only possible for some layouts. Defaults to FALSE}

\item{maxiter}{maximum number of iterations, where appropriate}
}
\description{
Layouts for one- and two-mode networks
}
\details{
The function uses approximate pattern matching
to redistributes the coarse layouts on the square grid points, while
preserving the topological relationships among the nodes (see Inoue et al. 2012).
}
\examples{
autographr(mpn_elite_mex, "frgrid")
autographr(mpn_elite_usa_advice, "frgrid")
autographr(mpn_elite_usa_money, "frgrid")
autographr(mpn_ryanair, "frgrid")
autographr(mpn_elite_mex, "kkgrid")
autographr(mpn_elite_usa_advice, "kkgrid")
autographr(mpn_elite_usa_money, "kkgrid")
autographr(mpn_ryanair, "kkgrid")
autographr(mpn_elite_mex, "gogrid")
autographr(mpn_elite_usa_advice, "gogrid")
autographr(mpn_elite_usa_money, "gogrid")
autographr(mpn_ryanair, "graphopt")
}
\references{
Inoue et al. (2012).
Application of Approximate Pattern Matching in Two Dimensional
Spaces to Grid Layout for Biochemical Network Maps.
PLoS One 7 (6): e37739. doi: https://doi.org/10.1371/journal.pone.0037739.
}
