# Description

# Checklist:

- PR form
  - [ ] This pull request has an informative title
  - [ ] Description above itemizes changes under subtitles, e.g. "## Data""
  - [ ] Any closed, fixed, or related issues are referenced and explained in the description above, e.g. "Fixed #0 by adding A"
  - [ ] Package builds on my OS without issues
- PR checks all pass for latest commit
  - [ ] CodeFactor check: Package improves or maintains good style
  - [ ] Package builds on Mac
  - [ ] Package builds on Windows
  - [ ] Package builds on Linux
  - [ ] CodeCov check: Package improves or maintains good test coverage
- Documentation
  - [ ] Any new or modified functions or data have roxygen style documentation in their .R scripts
  - [ ] Any longer functions are commented inline so that it is easier to debug in the future
  - [ ] PR description above and the NEWS.md file are aligned
  - [ ] DESCRIPTION file version is bumped by the appropriate increment (major, minor, patch)
