package backend.support;

/**
 * This class computes the Precision and Recall.
 * @author Enrico
 */

public class ResultsCalculator {

    /**
     * Computes precision
     * @param truePositives - number of true positives
     * @param falsePositives = number of false positives
     * @return
     */

    public static float computePrecision(float truePositives, float falsePositives){
        float precision = truePositives/(truePositives+falsePositives);
        return precision;
    }


    /**
     * Computes recall
     * @param truePositives - number of true positives
     * @param falseNegatives - number of false negatives
     * @return
     */

    public static float computeRecall(float truePositives, float falseNegatives){
        float recall = truePositives/(truePositives + falseNegatives);
        return recall;
    }

}
