package backend.base.graphs;

import backend.analysis.CodeChunksLinker;
import backend.analysis.GerritExtractor;
import backend.analysis.ImportFilter;
import backend.analysis.machineLearning.ModificationConverter;
import backend.base.Change;
import backend.base.gerrit_data.CodeChunk;
import backend.base.gerrit_data.Modification;
import backend.db_connectors.Dataset;
import backend.db_connectors.FilesIndexer;
import backend.main.CodeChunksExtractor;
import com.google.common.collect.Multimap;
import org.jfree.ui.RefineryUtilities;
import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

public class ParetoPlotterTest {


    private static Multimap<String, Change> changes;
    private List<Modification> modificationsToPlot;


    private List<Modification> init(String datasetPath, String gerritUrl, String csvName, boolean filterImports){
        Dataset dataset = new Dataset(datasetPath);
        changes =  dataset.getChanges();
        GerritExtractor ge = new GerritExtractor(changes);
        ge.set(gerritUrl);
        CodeChunksExtractor cce = new CodeChunksExtractor();
        List<CodeChunk> codeChunkList = cce.extractCodeChunks(ge, csvName);

        if(gerritUrl.equals(FilesIndexer.AndroidGerritUrl)){
            codeChunkList = removeNonJavaFiles(codeChunkList);
        }

        if(filterImports){
            ImportFilter importFilter = new ImportFilter();
            codeChunkList = importFilter.filterImports(codeChunkList);
        }

        CodeChunksLinker cl = new CodeChunksLinker();
        return cl.splitChangeBased(codeChunkList);
    }


    private List<CodeChunk> removeNonJavaFiles(List<CodeChunk> codeChunkList){
        List<CodeChunk> filteredChunksList = new ArrayList<>();
        for(CodeChunk codeChunk : codeChunkList) {
            String fileName = codeChunk.getFileName();
            if(fileName!=null) {
                String[] fileNameSplit = fileName.split("\\.");
                if (fileNameSplit[fileNameSplit.length - 1].equals("java")) {
                    filteredChunksList.add(codeChunk);
                }
            }
        }
        return filteredChunksList;
    }


    @Before
    public void prepareModifications() {
        List<Modification> modifications = new ArrayList<>();
        modifications.addAll(init(FilesIndexer.AndroidDatasetPath, FilesIndexer.AndroidGerritUrl, FilesIndexer.AndroidFile, false));
        modifications.addAll(init(FilesIndexer.JGitDatasetPath, FilesIndexer.JGitGerritUrl, FilesIndexer.JGitFile, false));
        modifications.addAll(init(FilesIndexer.JavaClientDatasetPath, FilesIndexer.JavaClientGerritUrl, FilesIndexer.JavaClientFile, false));
        modificationsToPlot = new ModificationConverter().extractFeatures(modifications, true);
    }

    @Test
    public void plotParetoCurveTest(){
        ParetoPlotter paretoPlotter = new ParetoPlotter("Changes per group", modificationsToPlot, "Group");
        paretoPlotter.pack();
        RefineryUtilities.centerFrameOnScreen(paretoPlotter);
        paretoPlotter.setVisible(true);
    }

}