package backend.main;

import backend.analysis.GerritExtractor;
import backend.base.gerrit_data.CodeChunk;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class CodeChunksExtractor {

    //private static String csvName = "./JavaClientRecord";
    //private static String csvName = "./JGitRecord";
    //private static String csvName = "./androidRecord";

    /**
     * Returns a list of the code chunks in the dataset under analysis.
     * If a file containining the serializable code chunks exist it reads it and creates the list.
     * If not, it creates the file mining the related gettirRepository
     *
     * @param ge an instance of the GerritExtractor class
     * @return list of code chunks
     */

    public List<CodeChunk> extractCodeChunks(GerritExtractor ge, String fileName) {
        File file = new File(fileName);
        List<CodeChunk> codeChunkList;
        if(!file.exists()) {
            System.out.println("mining "+fileName);
            codeChunkList = ge.mineDatasetRevisionData();
            System.out.println("code chunks size  "+codeChunkList.size());
            try (FileOutputStream fileOutputStream = new FileOutputStream(file)) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                for(CodeChunk c : codeChunkList) {
                    System.out.println("writing on "+fileName);
                    objectOutputStream.writeObject(c);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        else {
            codeChunkList = new ArrayList<>();
            try (FileInputStream fileInputStream = new FileInputStream(file)) {
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                for (; ; ) {
                    codeChunkList.add((CodeChunk) objectInputStream.readObject());
                }
            } catch(EOFException e) {
                //ignored
            } catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return codeChunkList;
    }

}
