package backend.db_connectors;

import backend.base.Change;
import com.google.common.collect.Multimap;

import java.io.IOException;
import java.util.Map;

public class Dataset {

    private Multimap<String, Change> changes = null;

    public Dataset(String datasetPath) {
        DatasetReader datasetReader = new DatasetReader(datasetPath);
        try {
            datasetReader.extractDefects();
            this.changes = datasetReader.getChangesInDataset();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Multimap<String, Change> getChanges() {
        return changes;
    }
}
