package backend.base.gerrit_data;

import java.io.Serializable;
import java.util.Date;

public class Modification implements Serializable {

    private CodeChunk oldCodeChunk;
    private CodeChunk newCodeChunk;
    private FeaturesList features;

    private String reviewCode;
    private String revisionCode;
    private String fileName;

    private Date date;

    public Modification(CodeChunk oldCodeChunk, CodeChunk newCodeChunk){
        this.oldCodeChunk = oldCodeChunk;
        this.newCodeChunk = newCodeChunk;
    }

    public CodeChunk getOldCodeChunk() {
        return oldCodeChunk;
    }

    public CodeChunk getNewCodeChunk() {
        return newCodeChunk;
    }

    public void setFeatureList(FeaturesList features){
        this.features = features;
    }

    public FeaturesList getFeatures() {
        return features;
    }

    public void setDate(Date date){
        this.date = date;
    }

    public Date getDate() {
        return date;
    }

    public void setRevisionCode(String revisionCode) { this.revisionCode = revisionCode;}

    public String getRevisionCode() {return revisionCode;}

    public void setReviewCode(String reviewCode) { this.reviewCode = reviewCode;}

    public String getReviewCode() {return reviewCode;}

    public void setFileName(String fileName) { this.fileName = fileName;}

    public String getFileName() {return fileName;}



}
