package backend.base.gerrit_data;

import backend.base.Change;
import backend.base.taxonomy.Subtype;
import backend.base.taxonomy.Type;

import java.io.Serializable;
import java.util.List;

public class CodeChunk implements Serializable {

    private int beginLine;
    private int endLine;
    private List<DiffLine> lines;

    private String changeID;
    private int changeBeginLine;
    private int changeEndLine;
    private Subtype subtype;
    private Type type;
    private Change.Category category;
    private String fileName;

    private List<Comment> comments;

    public CodeChunk(int beginLine, int endLine, List<DiffLine> lines){
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.lines = lines;
    }

    public int getBeginLine() {
        return beginLine;
    }

    public int getEndLine() {
        return endLine;
    }

    public List<DiffLine> getLines() {
        return  lines;
    }

    public String getChangeID() {return changeID;}

    public int getChangeBeginLine() {return changeBeginLine;}

    public int getChangeEndLine() {return changeEndLine;}

    public Subtype getSubtype() {return subtype;}

    public Type getType() {return type;}

    public Change.Category getCategory() {return category;}

    public String getFileName() {return fileName;}

    public void setRelatedChange(String changeID, String fileName, int changeBeginLine, int changeEndLine, Change.Category category, Type type, Subtype subtype) {
        this.fileName = fileName;
        this.changeID = changeID;
        this.changeBeginLine = changeBeginLine;
        this.changeEndLine = changeEndLine;
        this.category = category;
        this.subtype = subtype;
        this.type = type;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Comment> getComments() {
        return comments;
    }



}
